/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jem.internal.proxy.core.BaseProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ConfigurationContributorAdapter;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IExtensionRegistration;
import org.eclipse.jem.internal.proxy.core.IUIRunner;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.util.PerformanceMonitorUtil;
import org.eclipse.jem.util.TimerTests;
import org.osgi.framework.Bundle;

public class ProxyLaunchSupport {
    public static final String NOT_SET = "...not..set..";
    public static final String EXPRESSION_TRACING = "/debug/traceexpressions";
    public static final String EXPRESSION_TRACEING_TIMER_THRESHOLD = "/debug/traceexpressionstimethreshold";
    private static Map LAUNCH_INFO;
    public static final IConfigurationContributor[] EMPTY_CONFIG_CONTRIBUTORS;
    public static String ATTR_PRIVATE;
    private static IUIRunner UI_RUNNER;
    static /* synthetic */ Class class$0;

    static {
        block9: {
            LAUNCH_INFO = new HashMap(2);
            EMPTY_CONFIG_CONTRIBUTORS = new IConfigurationContributor[0];
            UI_RUNNER = null;
            ATTR_PRIVATE = null;
            try {
                Bundle uiBundle = Platform.getBundle((String)"org.eclipse.ui");
                if (uiBundle == null || uiBundle.getState() != 32) break block9;
                try {
                    UI_RUNNER = (IUIRunner)Class.forName("org.eclipse.jem.internal.proxy.core.UIRunner").newInstance();
                }
                catch (InstantiationException e1) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e1, Level.WARNING);
                }
                Bundle debuguiBundle = Platform.getBundle((String)"org.eclipse.debug.ui");
                if (debuguiBundle != null && debuguiBundle.getState() == 32) {
                    Class debugUIConstants = debuguiBundle.loadClass("org.eclipse.debug.ui.IDebugUIConstants");
                    ATTR_PRIVATE = (String)debugUIConstants.getField("ATTR_PRIVATE").get(null);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static ProxyFactoryRegistry startImplementation(IProject project, String vmTitle, IConfigurationContributor[] aContribs, IProgressMonitor pm) throws CoreException {
        return ProxyLaunchSupport.startImplementation(project, vmTitle, aContribs, true, pm);
    }

    public static ProxyFactoryRegistry startImplementation(IProject project, String vmTitle, IConfigurationContributor[] aContribs, boolean waitForBuild, IProgressMonitor pm) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            throw new CoreException((IStatus)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(ProxyMessages.Not_Java_Project_WARN_, project.getName()), null));
        }
        String launchName = project.getPersistentProperty(ProxyPlugin.PROPERTY_LAUNCH_CONFIGURATION);
        ILaunchConfiguration config = null;
        if (launchName != null && !NOT_SET.equals(launchName)) {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int i = 0;
            while (i < configs.length) {
                if (configs[i].getName().equals(launchName)) {
                    config = configs[i];
                    break;
                }
                ++i;
            }
            if (config == null || !config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(project.getName())) {
                project.setPersistentProperty(ProxyPlugin.PROPERTY_LAUNCH_CONFIGURATION, null);
                config = null;
            }
        }
        if (config == null) {
            ILaunchConfigurationWorkingCopy configwc = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.jem.proxy.LocalProxyLaunchConfigurationType").newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom("LocalProxy_" + project.getName()));
            configwc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            config = configwc;
        }
        return ProxyLaunchSupport.startImplementation(config, vmTitle, aContribs, waitForBuild, pm);
    }

    public static ProxyFactoryRegistry startImplementation(ILaunchConfiguration config, String vmTitle, IConfigurationContributor[] aContribs, IProgressMonitor pm) throws CoreException {
        return ProxyLaunchSupport.startImplementation(config, vmTitle, aContribs, true, pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProxyFactoryRegistry startImplementation(ILaunchConfiguration config, String vmTitle, IConfigurationContributor[] aContribs, boolean waitForBuild, IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        String stepId = "Pre-launch VM ( " + vmTitle + " )";
        TimerTests.basicTest.startStep(stepId);
        if (vmTitle.equals("Beaninfo")) {
            PerformanceMonitorUtil.getMonitor().snapshot(125);
        }
        final ILaunchConfigurationWorkingCopy configwc = config.getWorkingCopy();
        pm.beginTask("", 400);
        pm.subTask(ProxyMessages.ProxyLaunch);
        if (waitForBuild) {
            if (UI_RUNNER != null) {
                UI_RUNNER.handleBuild((IProgressMonitor)new SubProgressMonitor(pm, 100));
            } else {
                ProxyLaunchSupport.runBuild((IProgressMonitor)new SubProgressMonitor(pm, 100));
            }
            if (pm.isCanceled()) {
                return null;
            }
        }
        if (aContribs != null) {
            IConfigurationContributor[] newContribs = new IConfigurationContributor[aContribs.length + 1];
            System.arraycopy(aContribs, 0, newContribs, 1, aContribs.length);
            newContribs[0] = new ProxyContributor();
            aContribs = newContribs;
        } else {
            aContribs = new IConfigurationContributor[]{new ProxyContributor()};
        }
        String launchKey = String.valueOf(System.currentTimeMillis());
        LaunchInfo launchInfo = new LaunchInfo();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        Class<?> clazz3 = clazz;
        synchronized (clazz) {
            while (true) {
                if (!LAUNCH_INFO.containsKey(launchKey)) {
                    LAUNCH_INFO.put(launchKey, launchInfo);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    break;
                }
                launchKey = String.valueOf(launchKey) + 'a';
            }
            String projectName = configwc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            aContribs = ProxyLaunchSupport.fillInLaunchInfo(aContribs, launchInfo, projectName);
            try {
                ProxyFactoryRegistry reg;
                configwc.setAttribute("org.eclipse.jem.proxy.LaunchKey", launchKey);
                if (vmTitle != null && vmTitle.length() > 0) {
                    configwc.setAttribute("org.eclipse.jem.proxy.vmtitle", vmTitle);
                }
                if (ATTR_PRIVATE != null) {
                    configwc.setAttribute(ATTR_PRIVATE, true);
                }
                final IConfigurationContributor[] contribs = aContribs;
                final LaunchInfo linfo = launchInfo;
                int i = 0;
                while (true) {
                    if (i >= contribs.length) {
                        pm.worked(100);
                        configwc.launch("run", (IProgressMonitor)new SubProgressMonitor(pm, 100));
                        reg = launchInfo.resultRegistry;
                        if (pm.isCanceled() || reg != null) break;
                        throw new CoreException((IStatus)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, ProxyMessages.ProxyLaunchSupport_RegistryCouldNotStartForSomeReason_WARN_, null));
                    }
                    final int ii = i++;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            contribs[ii].initialize(linfo.getConfigInfo());
                        }
                    });
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            contribs[ii].contributeToConfiguration(configwc);
                        }
                    });
                }
                if (pm.isCanceled()) {
                    if (reg != null) {
                        reg.terminateRegistry();
                    }
                    Object var15_15 = null;
                    LAUNCH_INFO.remove(launchKey);
                    return null;
                }
                ProxyLaunchSupport.performExtensionRegistrations((BaseProxyFactoryRegistry)reg, launchInfo);
                int i2 = 0;
                while (i2 < contribs.length) {
                    final int ii = i2++;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            contribs[ii].contributeToRegistry(reg);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                LAUNCH_INFO.remove(launchKey);
                throw throwable;
            }
            Object var15_17 = null;
            LAUNCH_INFO.remove(launchKey);
            pm.done();
            if (vmTitle.equals("Beaninfo")) {
                PerformanceMonitorUtil.getMonitor().snapshot(126);
            }
            TimerTests.basicTest.stopStep(stepId);
            return launchInfo.resultRegistry;
        }
    }

    public static IConfigurationContributionInfo createDefaultConfigurationContributionInfo(IJavaProject javaProject) throws JavaModelException {
        LaunchSupportIConfigurationContributionInfo configInfo = new LaunchSupportIConfigurationContributionInfo(javaProject, ProxyPlugin.getPlugin().getIDsFound(javaProject));
        return configInfo;
    }

    public static IConfigurationContributor[] fillInLaunchInfo(IConfigurationContributor[] aContribs, LaunchInfo launchInfo, String projectName) throws JavaModelException, CoreException {
        IProject project;
        IJavaProject javaProject;
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            launchInfo.configInfo = ProxyLaunchSupport.createDefaultConfigurationContributionInfo(javaProject);
            if (!(launchInfo.configInfo.getContainerIds().isEmpty() && launchInfo.configInfo.getContainers().isEmpty() && launchInfo.configInfo.getPluginIds().isEmpty())) {
                Object contributor;
                int i;
                IConfigurationElement[] contributors;
                ArrayList<Object> computedContributors = new ArrayList<Object>(launchInfo.configInfo.getContainerIds().size() + launchInfo.configInfo.getContainers().size() + launchInfo.configInfo.getPluginIds().size());
                Iterator<Object> iter = launchInfo.configInfo.getContainers().keySet().iterator();
                while (iter.hasNext()) {
                    IClasspathContainer container = (IClasspathContainer)iter.next();
                    if (!(container instanceof IConfigurationContributor)) continue;
                    computedContributors.add(container);
                }
                iter = launchInfo.configInfo.getContainerIds().values().iterator();
                while (iter.hasNext()) {
                    IConfigurationContributionInfo.ContainerPaths paths = (IConfigurationContributionInfo.ContainerPaths)iter.next();
                    contributors = ProxyPlugin.getPlugin().getContainerConfigurations(paths.getContainerId(), paths.getAllPaths());
                    if (contributors == null) continue;
                    i = 0;
                    while (i < contributors.length) {
                        contributor = contributors[i].createExecutableExtension("class");
                        if (contributor instanceof IConfigurationContributor) {
                            computedContributors.add(contributor);
                        }
                        ++i;
                    }
                }
                iter = launchInfo.configInfo.getPluginIds().keySet().iterator();
                while (iter.hasNext()) {
                    String pluginId = (String)iter.next();
                    contributors = ProxyPlugin.getPlugin().getPluginConfigurations(pluginId);
                    if (contributors == null) continue;
                    i = 0;
                    while (i < contributors.length) {
                        contributor = contributors[i].createExecutableExtension("class");
                        if (contributor instanceof IConfigurationContributor) {
                            computedContributors.add(contributor);
                        }
                        ++i;
                    }
                }
                if (!computedContributors.isEmpty()) {
                    IConfigurationContributor[] newContribs = new IConfigurationContributor[aContribs.length + computedContributors.size()];
                    System.arraycopy(aContribs, 0, newContribs, 0, aContribs.length);
                    IConfigurationContributor[] cContribs = computedContributors.toArray(new IConfigurationContributor[computedContributors.size()]);
                    System.arraycopy(cContribs, 0, newContribs, aContribs.length, cContribs.length);
                    aContribs = newContribs;
                }
            }
        }
        launchInfo.contributors = aContribs;
        return aContribs;
    }

    public static void performExtensionRegistrations(final BaseProxyFactoryRegistry baseRegistry, LaunchInfo launchInfo) throws CoreException {
        IConfigurationContributionInfo configInfo = launchInfo.configInfo;
        if (!(configInfo == null || configInfo.getContainerIds().isEmpty() && configInfo.getPluginIds().isEmpty())) {
            IExtensionRegistration contributor;
            int i;
            IConfigurationElement[] contributors;
            String registryID = baseRegistry.getRegistryTypeID();
            Iterator<Object> iter = configInfo.getContainerIds().values().iterator();
            while (iter.hasNext()) {
                IConfigurationContributionInfo.ContainerPaths paths = (IConfigurationContributionInfo.ContainerPaths)iter.next();
                contributors = ProxyPlugin.getPlugin().getContainerExtensions(paths.getContainerId(), paths.getAllPaths());
                if (contributors == null) continue;
                i = 0;
                while (i < contributors.length) {
                    if (registryID.equals(contributors[i].getAttributeAsIs("registryType"))) {
                        try {
                            contributor = (IExtensionRegistration)contributors[i].createExecutableExtension("class");
                            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                public void run() throws Exception {
                                    contributor.register(baseRegistry);
                                }

                                public void handleException(Throwable exception) {
                                }
                            });
                        }
                        catch (ClassCastException classCastException) {}
                    }
                    ++i;
                }
            }
            iter = configInfo.getPluginIds().keySet().iterator();
            while (iter.hasNext()) {
                String pluginId = (String)iter.next();
                contributors = ProxyPlugin.getPlugin().getPluginExtensions(pluginId);
                if (contributors == null) continue;
                i = 0;
                while (i < contributors.length) {
                    if (registryID.equals(contributors[i].getAttributeAsIs("registryType"))) {
                        try {
                            contributor = (IExtensionRegistration)contributors[i].createExecutableExtension("class");
                            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                public void run() throws Exception {
                                    contributor.register(baseRegistry);
                                }

                                public void handleException(Throwable exception) {
                                }
                            });
                        }
                        catch (ClassCastException classCastException) {}
                    }
                    ++i;
                }
            }
        }
    }

    static void runBuild(IProgressMonitor pm) throws CoreException {
        boolean autobuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (!autobuilding) {
            try {
                ResourcesPlugin.getWorkspace().build(10, pm);
            }
            catch (OperationCanceledException operationCanceledException) {}
        } else {
            pm.beginTask("", 200);
            IJobManager jobManager = Platform.getJobManager();
            Job currentJob = jobManager.currentJob();
            if (!(currentJob != null && (currentJob.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || currentJob.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD)) || jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length <= 0 && jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length <= 0)) {
                pm.subTask(ProxyMessages.ProxyWaitForBuild);
                try {
                    while (true) {
                        try {
                            jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new SubProgressMonitor(pm, 100));
                            jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, (IProgressMonitor)new SubProgressMonitor(pm, 100));
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
            pm.done();
        }
    }

    public static synchronized LaunchInfo getInfo(String key) {
        return (LaunchInfo)LAUNCH_INFO.get(key);
    }

    public static URL convertStringPathToURL(String path) {
        try {
            return path != null ? new File(path).toURL() : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL[] convertStringPathsToURL(String[] paths) {
        if (paths != null) {
            URL[] result = new URL[paths.length];
            int nextURL = 0;
            int i = 0;
            while (i < paths.length) {
                URL url = ProxyLaunchSupport.convertStringPathToURL(paths[i]);
                if (url != null) {
                    result[nextURL++] = url;
                }
                ++i;
            }
            if (nextURL == 0) {
                return null;
            }
            if (nextURL != result.length) {
                URL[] nr = new URL[nextURL];
                System.arraycopy(result, 0, nr, 0, nr.length);
                result = nr;
            }
            return result;
        }
        return null;
    }

    public static String[] convertURLsToStrings(URL[] urls) {
        if (urls != null) {
            String[] strings = new String[urls.length];
            int i = 0;
            while (i < urls.length) {
                URL url = urls[i];
                if (url != null) {
                    strings[i] = url.getFile();
                    if (strings[i].startsWith("/") && Platform.getOS().equals("win32")) {
                        strings[i] = strings[i].substring(1);
                    }
                }
                ++i;
            }
            return strings;
        }
        return null;
    }

    public static class LaunchInfo {
        public IConfigurationContributor[] contributors;
        public ProxyFactoryRegistry resultRegistry;
        protected IConfigurationContributionInfo configInfo;

        public IJavaProject getJavaProject() {
            return this.configInfo.getJavaProject();
        }

        public IConfigurationContributionInfo getConfigInfo() {
            return this.configInfo;
        }
    }

    public static class LaunchSupportIConfigurationContributionInfo
    implements IConfigurationContributionInfo {
        public Map containers = Collections.EMPTY_MAP;
        public Map containerIds = Collections.EMPTY_MAP;
        public Map pluginIds = Collections.EMPTY_MAP;
        public Map projectPaths;
        public IJavaProject javaProject;

        public LaunchSupportIConfigurationContributionInfo(IJavaProject javaProject) {
            this.javaProject = javaProject;
        }

        public LaunchSupportIConfigurationContributionInfo(IJavaProject javaProject, ProxyPlugin.FoundIDs foundIDs) {
            this(javaProject);
            this.containerIds = foundIDs.containerIds;
            this.containers = foundIDs.containers;
            this.pluginIds = foundIDs.pluginIds;
            this.projectPaths = foundIDs.projects;
        }

        public Map getContainerIds() {
            return this.containerIds;
        }

        public Map getContainers() {
            return this.containers;
        }

        public IJavaProject getJavaProject() {
            return this.javaProject;
        }

        public Map getPluginIds() {
            return this.pluginIds;
        }

        public Map getProjectPaths() {
            return this.projectPaths;
        }
    }

    static class ProxyContributor
    extends ConfigurationContributorAdapter {
        ProxyContributor() {
        }

        public void contributeClasspaths(IConfigurationContributionController controller) {
            controller.contributeClasspath(ProxyPlugin.getPlugin().getBundle(), (IPath)null, 0, true);
        }
    }
}

