/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.evaluation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.text.Assert;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.evaluation.EvaluationExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EvaluationExpressionReaderWriter {
    private static final String TEMPLATE_ROOT = "expressions";
    private static final String TEMPLATE_ELEMENT = "expression";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";

    public EvaluationExpression[] read(Reader reader) throws IOException {
        return this.read(reader, null);
    }

    public EvaluationExpression[] read(Reader reader, ResourceBundle resourceBundle) throws IOException {
        return this.read(new InputSource(reader), resourceBundle);
    }

    public EvaluationExpression[] read(InputStream inputStream, ResourceBundle resourceBundle) throws IOException {
        return this.read(new InputSource(inputStream), resourceBundle);
    }

    private EvaluationExpression[] read(InputSource inputSource, ResourceBundle resourceBundle) throws IOException {
        try {
            ArrayList<EvaluationExpression> arrayList = new ArrayList<EvaluationExpression>();
            new HashSet();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getElementsByTagName(TEMPLATE_ELEMENT);
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 != n) {
                Node node = nodeList.item(n2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    String string = this.getStringValue(namedNodeMap, NAME_ATTRIBUTE);
                    string = this.translateString(string, resourceBundle);
                    String string2 = this.getStringValue(namedNodeMap, DESCRIPTION_ATTRIBUTE, "");
                    string2 = this.translateString(string2, resourceBundle);
                    StringBuffer stringBuffer = new StringBuffer();
                    NodeList nodeList2 = node.getChildNodes();
                    int n3 = 0;
                    while (n3 != nodeList2.getLength()) {
                        String string3 = nodeList2.item(n3).getNodeValue();
                        if (string3 != null) {
                            stringBuffer.append(string3);
                        }
                        ++n3;
                    }
                    arrayList.add(new EvaluationExpression(string, string2, stringBuffer.toString()));
                }
                ++n2;
            }
            return arrayList.toArray(new EvaluationExpression[arrayList.size()]);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (SAXException sAXException) {
            Throwable throwable = sAXException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable.getMessage());
        }
        return null;
    }

    public void save(EvaluationExpression[] evaluationExpressionArray, OutputStream outputStream) throws IOException {
        this.save(evaluationExpressionArray, new StreamResult(outputStream));
    }

    public void save(EvaluationExpression[] evaluationExpressionArray, Writer writer) throws IOException {
        this.save(evaluationExpressionArray, new StreamResult(writer));
    }

    private void save(EvaluationExpression[] evaluationExpressionArray, StreamResult streamResult) throws IOException {
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(TEMPLATE_ROOT);
            document.appendChild(element);
            int n = 0;
            while (n < evaluationExpressionArray.length) {
                object = evaluationExpressionArray[n];
                Element element2 = document.createElement(TEMPLATE_ELEMENT);
                element.appendChild(element2);
                NamedNodeMap namedNodeMap = element2.getAttributes();
                Attr attr = document.createAttribute(NAME_ATTRIBUTE);
                attr.setValue(((EvaluationExpression)object).getName());
                namedNodeMap.setNamedItem(attr);
                Attr attr2 = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                attr2.setValue(((EvaluationExpression)object).getDescription());
                namedNodeMap.setNamedItem(attr2);
                Text text = document.createTextNode(((EvaluationExpression)object).getExpression());
                element2.appendChild(text);
                ++n;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            object = new DOMSource(document);
            transformer.transform((Source)object, streamResult);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException transformerException) {
            if (transformerException.getException() instanceof IOException) {
                throw (IOException)transformerException.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private String getStringValue(NamedNodeMap namedNodeMap, String string) throws SAXException {
        return this.getStringValue(namedNodeMap, string, null);
    }

    private String getStringValue(NamedNodeMap namedNodeMap, String string, String string2) {
        Node node = namedNodeMap.getNamedItem(string);
        return node == null ? string2 : node.getNodeValue();
    }

    private String translateString(String string, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return string;
        }
        int n = string.indexOf(37);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 1;
            while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            String string2 = string.substring(n + 1, n2);
            stringBuffer.append(this.getBundleString(string2, resourceBundle));
            n = string.indexOf(37, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private String getBundleString(String string, ResourceBundle resourceBundle) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return String.valueOf('!') + string + '!';
            }
        }
        return RdtDebugUiMessages.getString(string);
    }
}

