/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SpellDictionaryHashMap
extends SpellDictionaryASpell {
    private static final int INITIAL_CAPACITY = 16384;
    protected Hashtable mainDictionary = new Hashtable(16384);
    private File dictFile = null;

    public SpellDictionaryHashMap() throws IOException {
        super((File)null);
    }

    public SpellDictionaryHashMap(Reader reader) throws IOException {
        super((File)null);
        this.createDictionary(new BufferedReader(reader));
    }

    public SpellDictionaryHashMap(File file) throws FileNotFoundException, IOException {
        this(new FileReader(file));
        this.dictFile = file;
    }

    public SpellDictionaryHashMap(File file, File file2) throws FileNotFoundException, IOException {
        super(file2);
        this.dictFile = file;
        this.createDictionary(new BufferedReader(new FileReader(file)));
    }

    public SpellDictionaryHashMap(File file, File file2, String string) throws FileNotFoundException, IOException {
        super(file2, string);
        this.dictFile = file;
        this.createDictionary(new BufferedReader(new FileReader(file)));
    }

    public SpellDictionaryHashMap(Reader reader, Reader reader2) throws IOException {
        super(reader2);
        this.dictFile = null;
        this.createDictionary(new BufferedReader(reader));
    }

    public void addDictionary(File file) throws FileNotFoundException, IOException {
        this.addDictionaryHelper(new BufferedReader(new FileReader(file)));
    }

    public void addDictionary(Reader reader) throws IOException {
        this.addDictionaryHelper(new BufferedReader(reader));
    }

    public void addWord(String string) {
        this.putWord(string);
        if (this.dictFile == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.dictFile.toString(), true);
            fileWriter.write(string);
            fileWriter.write("\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error writing to dictionary file");
        }
    }

    protected void createDictionary(BufferedReader bufferedReader) throws IOException {
        String string = "";
        while (string != null) {
            string = bufferedReader.readLine();
            if (string == null || string.length() <= 0) continue;
            string = new String(string.toCharArray());
            this.putWord(string);
        }
    }

    protected void addDictionaryHelper(BufferedReader bufferedReader) throws IOException {
        String string = "";
        while (string != null) {
            string = bufferedReader.readLine();
            if (string == null || string.length() <= 0) continue;
            string = new String(string.toCharArray());
            this.putWordUnique(string);
        }
    }

    protected void putWord(String string) {
        String string2 = this.getCode(string);
        Vector<String> vector = (Vector<String>)this.mainDictionary.get(string2);
        if (vector != null) {
            vector.addElement(string);
        } else {
            vector = new Vector<String>();
            vector.addElement(string);
            this.mainDictionary.put(string2, vector);
        }
    }

    protected void putWordUnique(String string) {
        String string2 = this.getCode(string);
        Vector<String> vector = (Vector<String>)this.mainDictionary.get(string2);
        if (vector != null) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (!string.equalsIgnoreCase((String)vector.elementAt(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                vector.addElement(string);
            }
        } else {
            vector = new Vector<String>();
            vector.addElement(string);
            this.mainDictionary.put(string2, vector);
        }
    }

    public List getWords(String string) {
        Vector vector = (Vector)this.mainDictionary.get(string);
        if (vector == null) {
            return new Vector();
        }
        return vector;
    }

    public boolean isCorrect(String string) {
        List list = this.getWords(this.getCode(string));
        if (list.contains(string)) {
            return true;
        }
        if (list.contains(string.toLowerCase())) {
            return true;
        }
        return list.contains(string.toUpperCase());
    }
}

