/***************************************************************************
                           cfile.h  -  description
                             -------------------
    begin                : Wed Apr 3 2003
    copyright            : (C) 2003-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFILE_H
#define CFILE_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cobject.h>

#define IO_RAW			0x0001
#define IO_READONLY		0x0002
#define IO_WRITEONLY		0x0004
#define IO_READWRITE		0x0008
#define IO_APPEND		0x0010
#define IO_TRUNCATE		0x0020
#define IO_CREAT		0x0040

#define MO_IRWXU 0x01C0    /* RWX mask for owner */
#define MO_IRUSR 0x0100    /* R for owner */
#define MO_IWUSR 0x0080    /* W for owner */
#define MO_IXUSR 0x0040    /* X for owner */

#define MO_IRWXG 0x0038    /* RWX mask for group */
#define MO_IRGRP 0x0020    /* R for group */
#define MO_IWGRP 0x0010    /* W for group */
#define MO_IXGRP 0x0008    /* X for group */

#define MO_IRWXO 0x0007    /* RWX mask for other */
#define MO_IROTH 0x0004    /* R for other */
#define MO_IWOTH 0x0002    /* W for other */
#define MO_IXOTH 0x0001    /* X for other */

class CByteArray;

class DLL_EXPORT CFile : public CObject {

public:
	/** */
	CFile();
	/** */
	virtual ~CFile();

	/** */
	bool Open( CString filename, int mode, int acc = 0 );
	/** */
	bool IsOpen() { return (m_nFD!=-1); };
	/** */
	void Close();
	/** */
	long Flush();
	/** */
	bool Rename( CString from, CString to );
	/** */
	bool Remove( CString s );
	/** */
	long Write( const char * buf, long count );
	/** */
	long Read( char * buf, long count );
	/** */
	bool Seek( ulonglong offset, int origin );
	/** */
	int GetBufferPos() { return m_nBufferPos; };

private:
	/** */
	int m_nFD;
	/** */
	int m_nMode;
	/** */
	CByteArray * m_pBuffer;
	/** */
	int m_nBufferPos;
};

#endif
