/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.closure;

import java.util.HashMap;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.closure.ClosureGeneratorData;
import org.pentaho.di.trans.steps.closure.ClosureGeneratorMeta;
import org.pentaho.di.trans.steps.closure.Messages;

public class ClosureGenerator
extends BaseStep
implements StepInterface {
    private ClosureGeneratorMeta meta;
    private ClosureGeneratorData data;

    public ClosureGenerator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.data.reading) {
            Object[] rowData = this.getRow();
            if (rowData == null) {
                this.data.reading = false;
            } else {
                if (this.first) {
                    this.first = false;
                    this.data.outputRowMeta = this.getInputRowMeta().clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.parentIndex = this.getInputRowMeta().indexOfValue(this.meta.getParentIdFieldName());
                    if (this.data.parentIndex < 0) {
                        throw new KettleException(Messages.getString("ClosureGenerator.Exception.ParentFieldNotFound"));
                    }
                    this.data.childIndex = this.getInputRowMeta().indexOfValue(this.meta.getChildIdFieldName());
                    if (this.data.childIndex < 0) {
                        throw new KettleException(Messages.getString("ClosureGenerator.Exception.ChildFieldNotFound"));
                    }
                    this.data.parentValueMeta = this.getInputRowMeta().getValueMeta(this.data.parentIndex);
                    this.data.childValueMeta = this.getInputRowMeta().getValueMeta(this.data.childIndex);
                }
                Object parentId = rowData[this.data.parentIndex];
                Object childId = rowData[this.data.childIndex];
                this.data.map.put(childId, parentId);
            }
        } else {
            for (Object current : this.data.map.keySet()) {
                this.data.parents = new HashMap<Object, Long>();
                this.data.parents.put(current, 0L);
                this.recurseParents(current, 1L);
                for (Object parent : this.data.parents.keySet()) {
                    Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
                    outputRow[0] = parent;
                    outputRow[1] = current;
                    outputRow[2] = this.data.parents.get(parent);
                    this.putRow(this.data.outputRowMeta, outputRow);
                }
            }
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void recurseParents(Object key, long distance) {
        if (distance > 20L) {
            throw new RuntimeException("infinite loop detected:" + key);
        }
        Object parent = this.data.map.get(key);
        if (parent == null || parent == this.data.topLevel || parent.equals(this.data.topLevel)) {
            return;
        }
        this.data.parents.put(parent, distance);
        this.recurseParents(parent, distance + 1L);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ClosureGeneratorMeta)smi;
        this.data = (ClosureGeneratorData)sdi;
        if (super.init(smi, sdi)) {
            this.data.reading = true;
            this.data.map = new HashMap<Object, Object>();
            this.data.topLevel = null;
            if (this.meta.isRootIdZero()) {
                this.data.topLevel = new Long(0L);
            }
            return true;
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

