/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Partitioner;
import org.pentaho.di.trans.step.StepPartitioningMeta;

public abstract class BasePartitioner
implements Partitioner {
    protected StepPartitioningMeta meta;
    protected int nrPartitions = -1;
    protected String id;
    protected String description;

    public Partitioner clone() {
        Partitioner partitioner = this.getInstance();
        partitioner.setId(this.id);
        partitioner.setDescription(this.description);
        partitioner.setMeta(this.meta);
        return partitioner;
    }

    public int getNrPartitions() {
        return this.nrPartitions;
    }

    public void setNrPartitions(int nrPartitions) {
        this.nrPartitions = nrPartitions;
    }

    public void init(RowMetaInterface rowMeta) throws KettleException {
        if (this.nrPartitions < 0) {
            this.nrPartitions = this.meta.getPartitionSchema().getPartitionIDs().size();
        }
    }

    public StepPartitioningMeta getMeta() {
        return this.meta;
    }

    public void setMeta(StepPartitioningMeta meta) {
        this.meta = meta;
    }

    public abstract Partitioner getInstance();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

