/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline
extends MulticastProcessor
implements AsyncProcessor,
Traceable {
    private static final Logger LOG = LoggerFactory.getLogger(Pipeline.class);

    public Pipeline(CamelContext camelContext, Collection<Processor> processors) {
        super(camelContext, processors);
    }

    public static Processor newInstance(CamelContext camelContext, List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(camelContext, processors);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Iterator<Processor> processors = this.getProcessors().iterator();
        Exchange nextExchange = exchange;
        boolean first = true;
        while (this.continueRouting(processors, nextExchange)) {
            if (first) {
                first = false;
            } else {
                nextExchange = this.createNextExchange(nextExchange);
            }
            Processor processor = processors.next();
            AsyncProcessor async = AsyncProcessorConverterHelper.convert(processor);
            boolean sync = this.process(exchange, nextExchange, callback, processors, async);
            if (!sync) {
                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                return false;
            }
            LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
            if (PipelineHelper.continueProcessing(nextExchange, "so breaking out of pipeline", LOG)) continue;
            break;
        }
        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)nextExchange);
        ExchangeHelper.copyResults(exchange, nextExchange);
        callback.done(true);
        return true;
    }

    private boolean process(final Exchange original, final Exchange exchange, final AsyncCallback callback, final Iterator<Processor> processors, AsyncProcessor asyncProcessor) {
        LOG.trace("Processing exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        boolean sync = asyncProcessor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                Exchange nextExchange = exchange;
                while (Pipeline.this.continueRouting(processors, nextExchange)) {
                    AsyncProcessor processor = AsyncProcessorConverterHelper.convert((Processor)processors.next());
                    if (!PipelineHelper.continueProcessing(nextExchange, "so breaking out of pipeline", LOG)) break;
                    doneSync = Pipeline.this.process(original, nextExchange = Pipeline.this.createNextExchange(nextExchange), callback, processors, processor);
                    if (doneSync) continue;
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                    return;
                }
                ExchangeHelper.copyResults(original, nextExchange);
                LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)original.getExchangeId(), (Object)original);
                callback.done(false);
            }
        });
        return sync;
    }

    protected Exchange createNextExchange(Exchange previousExchange) {
        return PipelineHelper.createNextExchange(previousExchange);
    }

    protected boolean continueRouting(Iterator<Processor> it, Exchange exchange) {
        boolean answer = true;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null) {
            boolean doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop);
            if (doStop) {
                LOG.debug("ExchangeId: {} is marked to stop routing: {}", (Object)exchange.getExchangeId(), (Object)exchange);
                answer = false;
            }
        } else {
            answer = it.hasNext();
        }
        LOG.trace("ExchangeId: {} should continue routing: {}", (Object)exchange.getExchangeId(), (Object)answer);
        return answer;
    }

    @Override
    public String toString() {
        return "Pipeline[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "pipeline";
    }
}

