/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;

public interface ManagedThreadPoolMBean {
    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName();

    @ManagedAttribute(description="Thread Pool ID")
    public String getId();

    @ManagedAttribute(description="ID of source for creating Thread Pool")
    public String getSourceId();

    @ManagedAttribute(description="Route ID for the source, which created the Thread Pool")
    public String getRouteId();

    @ManagedAttribute(description="ID of the thread pool profile which this pool is based upon")
    public String getThreadPoolProfileId();

    @ManagedAttribute(description="Core pool size")
    public int getCorePoolSize();

    @ManagedAttribute(description="Core pool size")
    public void setCorePoolSize(int var1);

    @ManagedAttribute(description="Pool size")
    public int getPoolSize();

    @ManagedAttribute(description="Maximum pool size")
    public int getMaximumPoolSize();

    @ManagedAttribute(description="Maximum pool size")
    public void setMaximumPoolSize(int var1);

    @ManagedAttribute(description="Largest pool size")
    public int getLargestPoolSize();

    @ManagedAttribute(description="Active count")
    public int getActiveCount();

    @ManagedAttribute(description="Task count")
    public long getTaskCount();

    @ManagedAttribute(description="Completed task count")
    public long getCompletedTaskCount();

    @ManagedAttribute(description="Task queue size")
    public long getTaskQueueSize();

    @ManagedAttribute(description="Is task queue empty")
    public boolean isTaskQueueEmpty();

    @ManagedAttribute(description="Keep alive time in seconds")
    public long getKeepAliveTime();

    @ManagedAttribute(description="Keep alive time in seconds")
    public void setKeepAliveTime(long var1);

    @ManagedAttribute(description="Is shutdown")
    public boolean isShutdown();

    @ManagedOperation(description="Purges the pool")
    public void purge();

    @ManagedOperation(description="Returns the number of additional elements that the Task queue can ideally (in the absence of memory or resource constraints) accept")
    public int getTaskQueueRemainingCapacity();
}

