/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.File;
import java.io.IOException;
import org.apache.activemq.broker.AbstractLocker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.LockFile;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedFileLocker
extends AbstractLocker {
    public static final File DEFAULT_DIRECTORY = new File("KahaDB");
    private static final Logger LOG = LoggerFactory.getLogger(SharedFileLocker.class);
    private LockFile lockFile;
    protected File directory = DEFAULT_DIRECTORY;

    public void doStart() throws Exception {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfLocked) {
                this.lockFile.lock();
            } else {
                boolean locked = false;
                while (!this.isStopped() && !this.isStopping()) {
                    try {
                        this.lockFile.lock();
                        locked = this.keepAlive();
                        break;
                    }
                    catch (IOException e) {
                        LOG.info("Database " + lockFileName + " is locked... waiting " + this.lockAcquireSleepInterval / 1000L + " seconds for the database to be unlocked. Reason: " + e);
                        try {
                            Thread.sleep(this.lockAcquireSleepInterval);
                        }
                        catch (InterruptedException e1) {}
                    }
                }
                if (!locked) {
                    throw new IOException("attempt to obtain lock aborted due to shutdown");
                }
            }
        }
    }

    @Override
    public boolean keepAlive() {
        return this.lockFile != null && this.lockFile.keepAlive();
    }

    public void doStop(ServiceStopper stopper) throws Exception {
        this.lockFile.unlock();
        this.lockFile = null;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    public void configure(PersistenceAdapter persistenceAdapter) throws IOException {
        this.setDirectory(persistenceAdapter.getDirectory());
    }
}

