/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShellCommand
implements Runnable {
    private final String command;
    private final String directory;
    private final Stream outputStream;
    private final StringBuffer output;
    private int exitValue = -1;
    private static final Primitive _RUN_SHELL_COMMAND = new pf_run_shell_command();

    public ShellCommand(String command, String directory, Stream outputStream) {
        this.command = command;
        this.directory = directory;
        this.outputStream = outputStream;
        this.output = outputStream == null ? new StringBuffer() : null;
    }

    public final String getOutput() {
        return this.output != null ? this.output.toString() : "";
    }

    final int exitValue() {
        return this.exitValue;
    }

    void processOutput(String s) {
        if (this.outputStream != null) {
            this.outputStream._writeString(s);
        } else {
            this.output.append(s);
        }
    }

    @Override
    public void run() {
        Process process = null;
        try {
            if (this.command != null) {
                if (Utilities.isPlatformUnix) {
                    if (this.directory != null) {
                        StringBuilder sb = new StringBuilder("\\cd \"");
                        sb.append(this.directory);
                        sb.append("\" && ");
                        sb.append(this.command);
                        String[] cmdarray = new String[]{"/bin/sh", "-c", sb.toString()};
                        process = Runtime.getRuntime().exec(cmdarray);
                    } else {
                        String[] cmdarray = new String[]{"/bin/sh", "-c", this.command};
                        process = Runtime.getRuntime().exec(cmdarray);
                    }
                } else if (Utilities.isPlatformWindows) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("cmd.exe");
                    list.add("/c");
                    if (this.directory != null) {
                        StringBuilder sb = new StringBuilder("cd /d \"");
                        sb.append(this.directory);
                        sb.append("\" && ");
                        sb.append(this.command);
                        list.addAll(ShellCommand.tokenize(sb.toString()));
                    } else {
                        list.addAll(ShellCommand.tokenize(this.command));
                    }
                    int size = list.size();
                    String[] cmdarray = new String[size];
                    for (int i = 0; i < size; ++i) {
                        cmdarray[i] = (String)list.get(i);
                    }
                    process = Runtime.getRuntime().exec(cmdarray);
                }
            }
        }
        catch (IOException e) {
            Debug.trace(e);
        }
        if (process != null) {
            ReaderThread stdoutThread = new ReaderThread(process.getInputStream());
            stdoutThread.start();
            ReaderThread stderrThread = new ReaderThread(process.getErrorStream());
            stderrThread.start();
            try {
                this.exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                Debug.trace(e);
            }
            try {
                stdoutThread.join();
            }
            catch (InterruptedException e) {
                Debug.trace(e);
            }
            try {
                stderrThread.join();
            }
            catch (InterruptedException e) {
                Debug.trace(e);
            }
        }
    }

    private static List<String> tokenize(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuote = false;
        int limit = s.length();
        block4: for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    if (inQuote) {
                        sb.append(c);
                        continue block4;
                    }
                    if (sb.length() <= 0) continue block4;
                    list.add(sb.toString());
                    sb.setLength(0);
                    continue block4;
                }
                case '\"': {
                    if (inQuote) {
                        if (sb.length() > 0) {
                            list.add(sb.toString());
                            sb.setLength(0);
                        }
                        inQuote = false;
                        continue block4;
                    }
                    inQuote = true;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }

    private static class pf_run_shell_command
    extends Primitive {
        pf_run_shell_command() {
            super("%run-shell-command", Lisp.PACKAGE_SYS, false, "command directory output => exit-code");
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Pathname pathname;
            if (!Utilities.isPlatformUnix && !Utilities.isPlatformWindows) {
                return Lisp.error(new LispError("run-shell-command not implemented for " + System.getProperty("os.name")));
            }
            String command = first.getStringValue();
            String namestring = null;
            Stream outputStream = null;
            if (second != Lisp.NIL && (namestring = (pathname = Lisp.coerceToPathname(second)).getNamestring()) == null) {
                return Lisp.error(new FileError("Pathname has no namestring: " + pathname.princToString(), pathname));
            }
            if (third != Lisp.NIL) {
                outputStream = Lisp.checkStream(third);
            }
            ShellCommand shellCommand = new ShellCommand(command, namestring, outputStream);
            shellCommand.run();
            if (outputStream != null) {
                outputStream._finishOutput();
            }
            return Lisp.number(shellCommand.exitValue());
        }
    }

    private class ReaderThread
    extends Thread {
        private char[] buf = new char[4096];
        private final InputStream inputStream;
        private final BufferedReader reader;
        private boolean done = false;

        public ReaderThread(InputStream inputStream) {
            this.inputStream = inputStream;
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void run() {
            while (!this.done) {
                String s = this.read();
                if (s == null) {
                    return;
                }
                ShellCommand.this.processOutput(s);
            }
        }

        private String read() {
            StringBuffer sb = new StringBuffer();
            try {
                do {
                    int numChars;
                    if ((numChars = this.reader.read(this.buf, 0, this.buf.length)) < 0) {
                        this.done = true;
                        break;
                    }
                    if (numChars > 0) {
                        sb.append(this.buf, 0, numChars);
                    }
                    Thread.sleep(10L);
                } while (this.reader.ready());
            }
            catch (IOException e) {
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
            return sb.toString();
        }
    }
}

