/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.ArithmeticError;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DivisionByZero;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Ratio;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public final class Fixnum
extends LispInteger {
    public static final int MAX_POS_CACHE = 256;
    public static final Fixnum[] constants = new Fixnum[256];
    public static final Fixnum ZERO;
    public static final Fixnum ONE;
    public static final Fixnum TWO;
    public static final Fixnum THREE;
    public static final Fixnum MINUS_ONE;
    public final int value;
    static final BigInteger BIGINTEGER_TWO;

    public static Fixnum getInstance(int n) {
        return n >= 0 && n < 256 ? constants[n] : new Fixnum(n);
    }

    private Fixnum(int value) {
        this.value = value;
    }

    public Object javaInstance() {
        return this.value;
    }

    public Object javaInstance(Class c) {
        String cn = c.getName();
        if (cn.equals("java.lang.Byte") || cn.equals("byte")) {
            return (byte)this.value;
        }
        if (cn.equals("java.lang.Short") || cn.equals("short")) {
            return (short)this.value;
        }
        if (cn.equals("java.lang.Long") || cn.equals("long")) {
            return (long)this.value;
        }
        return this.javaInstance();
    }

    public LispObject typeOf() {
        if (this.value == 0 || this.value == 1) {
            return Symbol.BIT;
        }
        if (this.value > 1) {
            return Lisp.list(Symbol.INTEGER, ZERO, Fixnum.getInstance(Integer.MAX_VALUE));
        }
        return Symbol.FIXNUM;
    }

    public LispObject classOf() {
        return BuiltInClass.FIXNUM;
    }

    public LispObject getDescription() {
        StringBuffer sb = new StringBuffer("The fixnum ");
        sb.append(this.value);
        return new SimpleString(sb);
    }

    public LispObject typep(LispObject type) {
        if (type instanceof Symbol) {
            if (type == Symbol.FIXNUM) {
                return Lisp.T;
            }
            if (type == Symbol.INTEGER) {
                return Lisp.T;
            }
            if (type == Symbol.RATIONAL) {
                return Lisp.T;
            }
            if (type == Symbol.REAL) {
                return Lisp.T;
            }
            if (type == Symbol.NUMBER) {
                return Lisp.T;
            }
            if (type == Symbol.SIGNED_BYTE) {
                return Lisp.T;
            }
            if (type == Symbol.UNSIGNED_BYTE) {
                return this.value >= 0 ? Lisp.T : Lisp.NIL;
            }
            if (type == Symbol.BIT) {
                return this.value == 0 || this.value == 1 ? Lisp.T : Lisp.NIL;
            }
        } else if (type instanceof LispClass) {
            if (type == BuiltInClass.FIXNUM) {
                return Lisp.T;
            }
            if (type == BuiltInClass.INTEGER) {
                return Lisp.T;
            }
            if (type == BuiltInClass.RATIONAL) {
                return Lisp.T;
            }
            if (type == BuiltInClass.REAL) {
                return Lisp.T;
            }
            if (type == BuiltInClass.NUMBER) {
                return Lisp.T;
            }
        } else if (type instanceof Cons) {
            if (type.equal(Lisp.UNSIGNED_BYTE_8)) {
                return this.value >= 0 && this.value <= 255 ? Lisp.T : Lisp.NIL;
            }
            if (type.equal(Lisp.UNSIGNED_BYTE_16)) {
                return this.value >= 0 && this.value <= 65535 ? Lisp.T : Lisp.NIL;
            }
            if (type.equal(Lisp.UNSIGNED_BYTE_32)) {
                return this.value >= 0 ? Lisp.T : Lisp.NIL;
            }
        }
        return super.typep(type);
    }

    public boolean numberp() {
        return true;
    }

    public boolean integerp() {
        return true;
    }

    public boolean rationalp() {
        return true;
    }

    public boolean realp() {
        return true;
    }

    public boolean eql(int n) {
        return this.value == n;
    }

    public boolean eql(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Fixnum && this.value == ((Fixnum)obj).value;
    }

    public boolean equal(int n) {
        return this.value == n;
    }

    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Fixnum && this.value == ((Fixnum)obj).value;
    }

    public boolean equalp(int n) {
        return this.value == n;
    }

    public boolean equalp(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value == ((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return (float)this.value == ((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value == ((DoubleFloat)obj).value;
        }
        return false;
    }

    public LispObject ABS() {
        if (this.value >= 0) {
            return this;
        }
        return LispInteger.getInstance(-((long)this.value));
    }

    public LispObject NUMERATOR() {
        return this;
    }

    public LispObject DENOMINATOR() {
        return ONE;
    }

    public boolean evenp() {
        return (this.value & 1) == 0;
    }

    public boolean oddp() {
        return (this.value & 1) != 0;
    }

    public boolean plusp() {
        return this.value > 0;
    }

    public boolean minusp() {
        return this.value < 0;
    }

    public boolean zerop() {
        return this.value == 0;
    }

    public static int getValue(LispObject obj) {
        if (obj instanceof Fixnum) {
            return ((Fixnum)obj).value;
        }
        Lisp.type_error(obj, Symbol.FIXNUM);
        return 0;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public static int getInt(LispObject obj) {
        if (obj instanceof Fixnum) {
            return ((Fixnum)obj).value;
        }
        Lisp.type_error(obj, Symbol.FIXNUM);
        return 0;
    }

    public static BigInteger getBigInteger(LispObject obj) {
        if (obj instanceof Fixnum) {
            return BigInteger.valueOf(((Fixnum)obj).value);
        }
        Lisp.type_error(obj, Symbol.FIXNUM);
        return null;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public final BigInteger getBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public final LispObject incr() {
        return LispInteger.getInstance(1L + (long)this.value);
    }

    public final LispObject decr() {
        return LispInteger.getInstance(-1L + (long)this.value);
    }

    public LispObject negate() {
        return LispInteger.getInstance(-((long)this.value));
    }

    public LispObject add(int n) {
        return LispInteger.getInstance((long)this.value + (long)n);
    }

    public LispObject add(LispObject obj) {
        if (obj instanceof Fixnum) {
            long result = (long)this.value + (long)((Fixnum)obj).value;
            return LispInteger.getInstance(result);
        }
        if (obj instanceof Bignum) {
            return Lisp.number(this.getBigInteger().add(((Bignum)obj).value));
        }
        if (obj instanceof Ratio) {
            BigInteger numerator = ((Ratio)obj).numerator();
            BigInteger denominator = ((Ratio)obj).denominator();
            return Lisp.number(this.getBigInteger().multiply(denominator).add(numerator), denominator);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat((float)this.value + ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat((double)this.value + ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.add(c.getRealPart()), c.getImaginaryPart());
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject subtract(int n) {
        return LispInteger.getInstance((long)this.value - (long)n);
    }

    public LispObject subtract(LispObject obj) {
        if (obj instanceof Fixnum) {
            return Lisp.number((long)this.value - (long)((Fixnum)obj).value);
        }
        if (obj instanceof Bignum) {
            return Lisp.number(this.getBigInteger().subtract(Bignum.getValue(obj)));
        }
        if (obj instanceof Ratio) {
            BigInteger numerator = ((Ratio)obj).numerator();
            BigInteger denominator = ((Ratio)obj).denominator();
            return Lisp.number(this.getBigInteger().multiply(denominator).subtract(numerator), denominator);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat((float)this.value - ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat((double)this.value - ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.subtract(c.getRealPart()), ZERO.subtract(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject multiplyBy(int n) {
        long result = (long)this.value * (long)n;
        return LispInteger.getInstance(result);
    }

    public LispObject multiplyBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            long result = (long)this.value * (long)((Fixnum)obj).value;
            return LispInteger.getInstance(result);
        }
        if (obj instanceof Bignum) {
            return Lisp.number(this.getBigInteger().multiply(((Bignum)obj).value));
        }
        if (obj instanceof Ratio) {
            BigInteger numerator = ((Ratio)obj).numerator();
            BigInteger denominator = ((Ratio)obj).denominator();
            return Lisp.number(this.getBigInteger().multiply(numerator), denominator);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat((float)this.value * ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat((double)this.value * ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.multiplyBy(c.getRealPart()), this.multiplyBy(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject divideBy(LispObject obj) {
        try {
            if (obj instanceof Fixnum) {
                int divisor = ((Fixnum)obj).value;
                if (this.value > Integer.MIN_VALUE && this.value % divisor == 0) {
                    return Fixnum.getInstance(this.value / divisor);
                }
                return Lisp.number(BigInteger.valueOf(this.value), BigInteger.valueOf(divisor));
            }
            if (obj instanceof Bignum) {
                return Lisp.number(this.getBigInteger(), ((Bignum)obj).value);
            }
            if (obj instanceof Ratio) {
                BigInteger numerator = ((Ratio)obj).numerator();
                BigInteger denominator = ((Ratio)obj).denominator();
                return Lisp.number(this.getBigInteger().multiply(denominator), numerator);
            }
            if (obj instanceof SingleFloat) {
                return new SingleFloat((float)this.value / ((SingleFloat)obj).value);
            }
            if (obj instanceof DoubleFloat) {
                return new DoubleFloat((double)this.value / ((DoubleFloat)obj).value);
            }
            if (obj instanceof Complex) {
                Complex c = (Complex)obj;
                LispObject realPart = c.getRealPart();
                LispObject imagPart = c.getImaginaryPart();
                LispObject denominator = realPart.multiplyBy(realPart).add(imagPart.multiplyBy(imagPart));
                return Complex.getInstance(this.multiplyBy(realPart).divideBy(denominator), ZERO.subtract(this.multiplyBy(imagPart).divideBy(denominator)));
            }
            return Lisp.type_error(obj, Symbol.NUMBER);
        }
        catch (ArithmeticException e) {
            if (obj.zerop()) {
                return Lisp.error(new DivisionByZero());
            }
            return Lisp.error(new ArithmeticError(e.getMessage()));
        }
    }

    public boolean isEqualTo(int n) {
        return this.value == n;
    }

    public boolean isEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value == ((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return this.isEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value == ((DoubleFloat)obj).value;
        }
        if (obj instanceof Complex) {
            return obj.isEqualTo(this);
        }
        if (obj.numberp()) {
            return false;
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    public boolean isNotEqualTo(int n) {
        return this.value != n;
    }

    public boolean isNotEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value != ((Fixnum)obj).value;
        }
        if (obj instanceof SingleFloat) {
            return this.isNotEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value != ((DoubleFloat)obj).value;
        }
        if (obj instanceof Complex) {
            return obj.isNotEqualTo(this);
        }
        if (obj.numberp()) {
            return true;
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    public boolean isLessThan(int n) {
        return this.value < n;
    }

    public boolean isLessThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value < ((Fixnum)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.getBigInteger().compareTo(Bignum.getValue(obj)) < 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.getBigInteger().multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) < 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isLessThan(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isLessThan(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isGreaterThan(int n) {
        return this.value > n;
    }

    public boolean isGreaterThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value > ((Fixnum)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.getBigInteger().compareTo(Bignum.getValue(obj)) > 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.getBigInteger().multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) > 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isGreaterThan(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isGreaterThan(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isLessThanOrEqualTo(int n) {
        return this.value <= n;
    }

    public boolean isLessThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value <= ((Fixnum)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.getBigInteger().compareTo(Bignum.getValue(obj)) <= 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.getBigInteger().multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) <= 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isLessThanOrEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isLessThanOrEqualTo(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isGreaterThanOrEqualTo(int n) {
        return this.value >= n;
    }

    public boolean isGreaterThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.value >= ((Fixnum)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.getBigInteger().compareTo(Bignum.getValue(obj)) >= 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n = this.getBigInteger().multiply(((Ratio)obj).denominator());
            return n.compareTo(((Ratio)obj).numerator()) >= 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isGreaterThanOrEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isGreaterThanOrEqualTo(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public LispObject truncate(LispObject obj) {
        LispObject value2;
        LispObject value1;
        LispThread thread;
        block8: {
            thread = LispThread.currentThread();
            try {
                if (obj instanceof Fixnum) {
                    int divisor = ((Fixnum)obj).value;
                    int quotient = this.value / divisor;
                    int remainder = this.value % divisor;
                    value1 = Fixnum.getInstance(quotient);
                    value2 = remainder == 0 ? ZERO : Fixnum.getInstance(remainder);
                    break block8;
                }
                if (obj instanceof Bignum) {
                    BigInteger val = this.getBigInteger();
                    BigInteger divisor = ((Bignum)obj).value;
                    BigInteger[] results = val.divideAndRemainder(divisor);
                    BigInteger quotient = results[0];
                    BigInteger remainder = results[1];
                    value1 = Lisp.number(quotient);
                    value2 = remainder.signum() == 0 ? ZERO : Lisp.number(remainder);
                    break block8;
                }
                if (obj instanceof Ratio) {
                    Ratio divisor = (Ratio)obj;
                    LispObject quotient = this.multiplyBy(divisor.DENOMINATOR()).truncate(divisor.NUMERATOR());
                    LispObject remainder = this.subtract(quotient.multiplyBy(divisor));
                    value1 = quotient;
                    value2 = remainder;
                    break block8;
                }
                if (obj instanceof SingleFloat) {
                    return new SingleFloat(this.value).truncate(obj);
                }
                if (obj instanceof DoubleFloat) {
                    return new DoubleFloat(this.value).truncate(obj);
                }
                return Lisp.type_error(obj, Symbol.REAL);
            }
            catch (ArithmeticException e) {
                if (obj.zerop()) {
                    return Lisp.error(new DivisionByZero());
                }
                return Lisp.error(new ArithmeticError(e.getMessage()));
            }
        }
        return thread.setValues(value1, value2);
    }

    public LispObject MOD(LispObject divisor) {
        if (divisor instanceof Fixnum) {
            return this.MOD(((Fixnum)divisor).value);
        }
        return super.MOD(divisor);
    }

    public LispObject MOD(int divisor) {
        int r;
        try {
            r = this.value % divisor;
        }
        catch (ArithmeticException e) {
            return Lisp.error(new ArithmeticError("Division by zero."));
        }
        if (r == 0) {
            return ZERO;
        }
        if (divisor < 0 ? this.value > 0 : this.value < 0) {
            return Fixnum.getInstance(r + divisor);
        }
        return Fixnum.getInstance(r);
    }

    public LispObject ash(int shift) {
        if (this.value == 0) {
            return this;
        }
        if (shift == 0) {
            return this;
        }
        long n = this.value;
        if (shift <= -32) {
            return n >= 0L ? ZERO : MINUS_ONE;
        }
        if (shift < 0) {
            return Fixnum.getInstance((int)(n >> -shift));
        }
        if (shift <= 32) {
            return LispInteger.getInstance(n <<= shift);
        }
        if (shift == Integer.MIN_VALUE) {
            return n >= 0L ? ZERO : MINUS_ONE;
        }
        return Lisp.number(BigInteger.valueOf(this.value).shiftLeft(shift));
    }

    public LispObject ash(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.ash(((Fixnum)obj).value);
        }
        if (obj instanceof Bignum) {
            if (this.value == 0) {
                return this;
            }
            BigInteger n = BigInteger.valueOf(this.value);
            BigInteger shift = ((Bignum)obj).value;
            if (shift.signum() > 0) {
                return Lisp.error(new LispError("Can't represent result of left shift."));
            }
            if (shift.signum() < 0) {
                return n.signum() >= 0 ? ZERO : MINUS_ONE;
            }
            Debug.bug();
        }
        return Lisp.type_error(obj, Symbol.INTEGER);
    }

    public LispObject LOGNOT() {
        return Fixnum.getInstance(~this.value);
    }

    public LispObject LOGAND(int n) {
        return Fixnum.getInstance(this.value & n);
    }

    public LispObject LOGAND(LispObject obj) {
        if (obj instanceof Fixnum) {
            return Fixnum.getInstance(this.value & ((Fixnum)obj).value);
        }
        if (obj instanceof Bignum) {
            if (this.value >= 0) {
                int n2 = ((Bignum)obj).value.intValue();
                return Fixnum.getInstance(this.value & n2);
            }
            BigInteger n1 = this.getBigInteger();
            BigInteger n2 = ((Bignum)obj).value;
            return Lisp.number(n1.and(n2));
        }
        return Lisp.type_error(obj, Symbol.INTEGER);
    }

    public LispObject LOGIOR(int n) {
        return Fixnum.getInstance(this.value | n);
    }

    public LispObject LOGIOR(LispObject obj) {
        if (obj instanceof Fixnum) {
            return Fixnum.getInstance(this.value | ((Fixnum)obj).value);
        }
        if (obj instanceof Bignum) {
            BigInteger n1 = this.getBigInteger();
            BigInteger n2 = ((Bignum)obj).value;
            return Lisp.number(n1.or(n2));
        }
        return Lisp.type_error(obj, Symbol.INTEGER);
    }

    public LispObject LOGXOR(int n) {
        return Fixnum.getInstance(this.value ^ n);
    }

    public LispObject LOGXOR(LispObject obj) {
        if (obj instanceof Fixnum) {
            return Fixnum.getInstance(this.value ^ ((Fixnum)obj).value);
        }
        if (obj instanceof Bignum) {
            BigInteger n1 = this.getBigInteger();
            BigInteger n2 = ((Bignum)obj).value;
            return Lisp.number(n1.xor(n2));
        }
        return Lisp.type_error(obj, Symbol.INTEGER);
    }

    public LispObject LDB(int size, int position) {
        long n = (long)this.value >> position;
        long mask = (1L << size) - 1L;
        return Lisp.number(n & mask);
    }

    public LispObject pow(LispObject obj) {
        BigInteger y = Bignum.getValue(obj);
        if (y.compareTo(BigInteger.ZERO) < 0) {
            return Fixnum.getInstance(1).divideBy(this.pow(Bignum.getInstance(y.negate())));
        }
        if (y.compareTo(BigInteger.ZERO) == 0) {
            return Fixnum.getInstance(1);
        }
        int x = this.value;
        if (x == 0) {
            return Fixnum.getInstance(0);
        }
        if (x == 1) {
            return Fixnum.getInstance(1);
        }
        BigInteger xy = BigInteger.ONE;
        BigInteger term = BigInteger.valueOf(x);
        while (!y.equals(BigInteger.ZERO)) {
            if (y.testBit(0)) {
                xy = xy.multiply(term);
            }
            term = term.multiply(term);
            y = y.shiftLeft(1);
        }
        return Bignum.getInstance(xy);
    }

    public int hashCode() {
        return this.value;
    }

    public String printObject() {
        LispThread thread = LispThread.currentThread();
        int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue(thread));
        String s = Integer.toString(this.value, base).toUpperCase();
        if (Symbol.PRINT_RADIX.symbolValue(thread) != Lisp.NIL) {
            StringBuilder sb = new StringBuilder();
            switch (base) {
                case 2: {
                    sb.append("#b");
                    sb.append(s);
                    break;
                }
                case 8: {
                    sb.append("#o");
                    sb.append(s);
                    break;
                }
                case 10: {
                    sb.append(s);
                    sb.append('.');
                    break;
                }
                case 16: {
                    sb.append("#x");
                    sb.append(s);
                    break;
                }
                default: {
                    sb.append('#');
                    sb.append(String.valueOf(base));
                    sb.append('r');
                    sb.append(s);
                }
            }
            s = sb.toString();
        }
        return s;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Fixnum.constants[i] = new Fixnum(i);
        }
        ZERO = constants[0];
        ONE = constants[1];
        TWO = constants[2];
        THREE = constants[3];
        MINUS_ONE = Fixnum.getInstance(-1);
        BIGINTEGER_TWO = new BigInteger("2");
    }
}

