# $OpenBSD: Makefile.inc,v 1.2 2014/12/11 13:48:42 sthen Exp $

CATEGORIES =		telephony

HOMEPAGE =		http://www.creytiv.com/
MASTER_SITES =		${HOMEPAGE:=pub/}

MAINTAINER =		Dmitrij D. Czarkoff <czarkoff@gmail.com>

# Code is BSD-licensed, but zrtp.so module is statically linked to AGPLv3-
# licensed libzrtp.  As a result, main baresip package is subject to AGPLv3.
PERMIT_PACKAGE_CDROM =	Yes

USE_GMAKE =		Yes

MAKE_FLAGS +=		OS=openbsd
MAKE_FLAGS +=		SYSROOT=/usr
MAKE_FLAGS +=		ARCH=${ARCH}
MAKE_FLAGS +=		MOD_SUFFIX=.so
MAKE_FLAGS +=		LIBS+="-lssl -lcrypto -lz -lpthread"
MAKE_FLAGS +=		LFLAGS="-L${LOCALBASE}/lib -L/${X11BASE}/lib"
MAKE_FLAGS +=		SH_LFLAGS+="-shared"
MAKE_FLAGS +=		CC="${CC}"
MAKE_FLAGS +=		LD="${CC}"
MAKE_FLAGS +=		APP_LFLAGS+="-rdynamic"
MAKE_FLAGS +=		AFLAGS="${ARFLAGS}"
MAKE_FLAGS +=		BUILD="build-${ARCH}"
MAKE_FLAGS +=		USE_OPENSSL=yes USE_TLS=yes USE_DTLS=yes
MAKE_FLAGS +=		USE_ZLIB=yes
MAKE_FLAGS +=		HAVE_PTHREAD=1 HAVE_PTHREAD_RWLOCK=1 HAVE_LIBPTHREAD=1
MAKE_FLAGS +=		HAVE_GETIFADDRS=1
MAKE_FLAGS +=		HAVE_STRERROR_R=1
MAKE_FLAGS +=		HAVE_GETOPT=1
MAKE_FLAGS +=		HAVE_INTTYPES_H=1
MAKE_FLAGS +=		HAVE_NET_ROUTE_H=1
MAKE_FLAGS +=		HAVE_SYS_SYSCTL_H=1
MAKE_FLAGS +=		HAVE_INET6=1
MAKE_FLAGS +=		HAVE_SYSLOG=1
MAKE_FLAGS +=		HAVE_DLFCN_H=1
MAKE_FLAGS +=		HAVE_LIBRESOLV=1
MAKE_FLAGS +=		HAVE_INET_NTOP=1
MAKE_FLAGS +=		HAVE_INET_PTON=1
MAKE_FLAGS +=		LIBRE_MK=/dev/null
MAKE_FLAGS +=		LIBRE_INC="${LOCALBASE}/include/re"

FAKE_FLAGS +=		PREFIX=${PREFIX}

CFLAGS +=		-I${X11BASE}/include -I${LOCALBASE}/include \
			-DOPENBSD -DOS=\"openbsd\" -DARCH=\"${ARCH}\" \
			-DVERSION=\"${V}\" -fPIC -std=c99 -pedantic \
			-DUSE_OPENSSL -DUSE_TLS -DUSE_DTLS -DUSE_ZLIB \
			-DHAVE_PTHREAD -DHAVE_GETIFADDRS -DHAVE_STRERROR_R \
			-DHAVE_GETOPT -DHAVE_INTTYPES_H -DHAVE_NET_ROUTE_H \
			-DHAVE_SYS_SYSCTL_H -DHAVE_STDBOOL_H -DHAVE_INET6 \
			-DHAVE_LIBRESOLV -DHAVE_SYSLOG -DHAVE_FORK \
			-DHAVE_INET_NTOP -DHAVE_PWD_H -DHAVE_POLL \
			-DHAVE_INET_PTON -DHAVE_SELECT -DHAVE_SELECT_H \
			-DHAVE_SETRLIMIT -DHAVE_SIGNAL -DHAVE_SYS_TIME_H \
			-DHAVE_UNAME -DHAVE_UNISTD_H -DHAVE_STRINGS_H \
			-DHAVE_GAI_STRERROR
