#!/bin/sh
export PATH='/usr/obj/ports/hs-crypto-4.2.5.1/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: Crypto
version: 4.2.5.1
id: Crypto-4.2.5.1-4d8235c736bf10d862cbdf8a4ee83dd3

license: OtherLicense
copyright: Dominic Steinitz 2003 - 2007
maintainer: Caylee Hogg <caylee.hogg@gmail.com>
stability: Alpha
homepage:
package-url:
synopsis: Collects together existing Haskell cryptographic functions into a package
description: DES, Blowfish, AES, TEA, SHA1, MD5, RSA, BubbleBabble,
             Hexdump, Support for Word128, Word192 and Word256 and Beyond, PKCS5
             Padding, Various Encryption Modes e.g. Cipher Block Chaining all in one package,
             with HUnit and QuickCheck tests, and examples.
category: Cryptography, Codec
author: Dominic Steinitz
pkgpath: security/hs-crypto
exposed: True
exposed-modules: Codec.Binary.BubbleBabble Codec.Encryption.RSA
                 Codec.Encryption.RSA.EMEOAEP Codec.Encryption.RSA.MGF
                 Codec.Encryption.RSA.NumberTheory Codec.Encryption.DES
                 Codec.Encryption.AES Codec.Encryption.TEA Codec.Encryption.Blowfish
                 Codec.Encryption.Modes Codec.Encryption.Padding Codec.Text.Raw
                 Codec.Utils Data.Digest.MD5 Data.Digest.SHA1 Data.Digest.SHA2
                 Data.Digest.SHA224 Data.Digest.SHA256 Data.Digest.SHA384
                 Data.Digest.SHA512 Data.LargeWord Data.HMAC
hidden-modules: Codec.Encryption.BlowfishAux
                Codec.Encryption.DESAux Codec.Encryption.AESAux Data.Digest.MD5Aux
trusted: False
import-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
library-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
hs-libraries: HSCrypto-4.2.5.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.2-53984ba5b2984037aa88060d4a146cd3
         QuickCheck-2.6-534d9f1b52f49eb1979bcce9bb5a52b9
         array-0.5.0.0-8a40db6fafcaa8a9af9e4724885ba0bf
         base-4.7.0.2-b11c3b9ddc2bebe1a3d85499c9ea3f18
         pretty-1.1.1.1-acc3b405212f217732bea6bb8ac62790
         random-1.0.1.1-d27743fb814afecff4d7eb6b55c3784a
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-Crypto-4.2.5.1/html/Crypto.haddock
haddock-html: /usr/local/share/doc/hs-Crypto-4.2.5.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
