/*

Copyright (c) 1991  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/* Vendor-specific definitions */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef CSRG_BASED
#include <sys/param.h>
#endif

#define SUFFIX "suffix"
#define FOLD "fold"
#define FOLDSUFFIX "foldsuffix"
#define MNULL 0
#define MSUFFIX 1
#define MFOLD 2
#define MFOLDSUFFIX 3

/*
 * The directories to search.  Assume that the manual directories are more
 * complete than the cat directories.
 */

#define SEARCHDIR  MAN

#if (defined(sgi) || (defined(SVR4) && !defined(sun)) || (defined(BSD) && (BSD >= 199103)) || defined(linux) || defined(__CYGWIN__) )
# define SEARCHOTHER CAT
#endif

/*
 * The default manual page directory.
 *
 * The MANPATH environment variable will override this.
 */

#ifndef SYSMANPATH

#if defined(__bsdi__)
#  define SYSMANPATH "/usr/share/man:/usr/contrib/man:/usr/contrib/isode/man:/usr/local/man"
#elif defined(__OpenBSD__) || defined(__DARWIN__)
#  define SYSMANPATH "/usr/share/man:/usr/local/man:/usr/X11R6/man"
#elif defined(SVR4) && defined(sun)
#  define SYSMANPATH "/usr/share/man:/usr/X11/man:/usr/openwin/share/man:/usr/dt/share/man:/usr/sfw/share/man"
#elif defined(SVR4) || defined(__osf__) || (defined(BSD) && (BSD >= 199103))
#  define SYSMANPATH "/usr/share/man"
#elif defined(sgi)
#  define SYSMANPATH "/usr/catman/a_man:/usr/catman/g_man:/usr/catman/p_man:/usr/catman/u_man:/usr/man/p_man:/usr/man/u_man:/usr/man"
#endif

#ifndef SYSMANPATH
#  define SYSMANPATH "/usr/man"
#endif

#endif

/*
 * Compression Definitions.
 */

#if defined(sgi)
#  define COMPRESSION_EXTENSION   "z"
#  define UNCOMPRESS_FORMAT       "pcat %s > %s"
#  define NO_COMPRESS           /* mac can't handle using pack as a filter and
                                   xman needs it to be done that way. */
#elif defined (ISC) || defined(__SCO__) || defined(__UNIXWARE__)
#  define COMPRESSION_EXTENSION   "Z"           /* dummy */
#  if !defined(__SCO__) && !defined(__UNIXWARE__)
#    define COMPRESSION_EXTENSIONS  "zZF"       /* pack, compress, freeze */
#  else
#    define COMPRESSION_EXTENSIONS  "zZ"        /* pack, compress */
#  endif
#  define UNCOMPRESS_FORMAT       uncompress_format
#  define UNCOMPRESS_FORMAT_1     "pcat %s > %s"
#  define UNCOMPRESS_FORMAT_2     "zcat < %s > %s"
#  define UNCOMPRESS_FORMAT_3     "fcat < %s > %s"
#  define NO_COMPRESS
#else
#  define COMPRESSION_EXTENSION "Z"
#  define UNCOMPRESS_FORMAT     "zcat < %s >> %s"
#  define COMPRESS              "compress"
#  define GZIP_EXTENSION "gz"
#  define GUNZIP_FORMAT "gzip -c -d < %s >> %s"
#  define GZIP_COMPRESS "gzip"
#  define BZIP2_EXTENSION "bz2"
#  define BUNZIP2_FORMAT "bunzip2 -c -d < %s >> %s"
#  define BZIP2_COMPRESS "bzip2"
#  define LZMA_EXTENSION "lzma"
#  define UNLZMA_FORMAT "unlzma -c -d < %s >> %s"
#  define LZMA_COMPRESS "lzma"
#endif



/*
 * The command filters for the manual and apropos searches.
 */

#if defined(hpux)
#  define NO_MANPATH_SUPPORT
#endif

#ifdef NO_MANPATH_SUPPORT
#  define APROPOS_FORMAT ("man -k %s | pr -h Apropos >> %s")
#else
#  define APROPOS_FORMAT ("man -M %s -k %s | pr -h Apropos >> %s")
#endif

#ifndef HANDLE_ROFFSEQ
# if defined(__OpenBSD__)
#  define FORMAT "| mandoc -Tascii"
# elif defined(CSRG_BASED)
#  define FORMAT "| eqn | tbl | nroff -mandoc"
# elif defined(BSD) && (BSD >= 199103)
#  define FORMAT "| eqn | tbl | nroff -man"
# elif defined(linux) || defined(__CYGWIN__)
#  define FORMAT "| pic | eqn | tbl -Tlatin1 | GROFF_NO_SGR= groff -Tlatin1 -mandoc"
# else
#  define FORMAT "| neqn | nroff -man"  /* The format command. */
# endif
# define TBL "tbl"
#else                           /* HANDLE_ROFFSEQ */
# if defined(linux)
#  define ZSOELIM	"zsoelim"
# else
#  define ZSOELIM	"soelim"
# endif
# define EQN		"eqn"
# define TBL		"tbl"
# define GRAP		"grap"
# define ROFF_PIC	"pic"
# define VGRIND		"vgrind"
# define REFER		"refer"
# if defined(__OpenBSD__)
#  define FORMAT	"mandoc -Tascii"
# elif defined(CSRG_BASED)
#  define FORMAT	"nroff -mandoc"
# elif defined(linux)
#  define FORMAT	"GROFF_NO_SGR= groff -Tlatin1 -mandoc"
# elif defined(__DARWIN__)
#  define FORMAT	"nroff -man"
# else
#  define FORMAT	"groff -man"
# endif
# define DEFAULT_MANROFFSEQ "et"
#endif /*HANDLE_ROFFSEQ */
#if defined(__OpenBSD__)
# define TBL "cat"
#endif

/*
 * Names of the man and cat dirs.
 */

#ifdef __bsdi__
#define MAN "cat"
#else
#define MAN "man"
#endif

#if defined(SCO)
#  define CAT "cat."
#else
#  define CAT "cat"
#endif

/* Solaris has nroff man pages in "man" and sgml man pages in "sman" */
#if defined(sun) && defined(SVR4)
#  define SFORMAT		"/usr/lib/sgml/sgml2roff"
#  define SMAN			"sman"
#  undef SEARCHOTHER
#  define SEARCHOTHER 		SMAN
#  define SGMLENT_EXTENSION	"ent"   /* SGML entity files end in ".ent" */
#endif


typedef struct _SectionList {
    struct _SectionList *next;
    char *label;                /* section label */
    char *directory;            /* section directory */
    int flags;
} SectionList;

extern char *CreateManpageName(const char *entry, int section, int flags);
extern void AddStandardSections(SectionList ** list, const char *path);
extern void AddNewSection(SectionList ** list, const char *path,
                          const char *file, const char *label, int flags);
