# Author: Natan Zohar
import gtk
import math
import pygtk
import pango
import copy
import random
import sys
import gobject
from pympd.modules import visiblob

gtk.gdk.threads_init()

__name = 'Artist Tracker'
__version = '0.01'
__author = "Natan 'whatah' Zohar"
__blurb = 'Artist Tracker is a plugin that visualizes recently played artists as blobs around a central circle. As an artist is played more often, their blob grows bigger. The more recently an artist has been played, the closer to the center their blob appears.'

HASH='artisttracker'
class TrackerGUI:
    def __init__(self):
        self.__initWidgets()
        self.levels = [HASH]

    def __initWidgets(self):
        self.window = gtk.Window()
        self.window.set_size_request(100, 100)
        gtk.gdk.threads_enter()
        self.blob = visiblob.Blobber()
        gtk.gdk.threads_leave()
        self.window.add(self.blob)
        self.__connectHandlers()


    def __connectHandlers(self):
        self.window.connect('delete-event', self.hide_cb)
        self.blob.connect('button-press-event', self.bp_cb)
        self.blob.connect('blob-clicked', self.blob_cb)

    def bp_cb(self, widget, event):
        if event.button == 3 and len(self.levels) > 1:
            self.levels = self.levels[:-1]
        HASH = self.levels[-1]
        self.blob.show_hash(HASH)

    def blob_cb(self, widget, event, text):
        if event.button == 1:
            if len(self.levels) < 2:
                self.levels.append(text)
        HASH = self.levels[-1]
        self.blob.show_hash(HASH)

    def show_cb(self, obj=None):
        self.window.present()

    def toggle_show(self, obj=None):
        if self.window.get_property('visible'):
            self.hide_cb(self.window, None)
        else:
            self.show_cb(self.window)

    def hide_cb(self, obj, data=None):
        obj.hide()
        return True

class Artisttracker:
    # called when we load the plugin. we get passed the mainWindow, plugin menu
    # item as well as a connection to mpd.
    def _init(self, data, get):
        gobject.idle_add(self._idleinit, data)

    def _idleinit(self, data):
        self.xml, self.pluginMenu, self.pympd, self.base_dir, self.parser = data
        self.trackerGui = TrackerGUI()
        self.trackerGui.blob.hash = HASH
        gobject.idle_add(self.trackerGui.window.show_all)
        self.readConfig()
        self.buildPluginMenu(self.pluginMenu)

    def _conf(self, hasConf=False):
        return False

    # update plugin, data is of type mpdclient.Status
    def _spin(self, data, songChanged=False):
        if not data.state == 'play':
            return
        if songChanged:
            song = self.pympd.getCurrentSong()
            if not song.artist.strip() == '':
                self.trackerGui.blob.add_blob(song.artist, HASH)
                if not song.title.strip() == '':
                    self.trackerGui.blob.add_blob(song.title, song.artist)
            else:
                self.trackerGui.blob.add_blob('Unknown Artist', HASH)
                if not song.title.strip() == '':
                    self.trackerGui.blob.add_blob(song.title, 'Unknown Artist')
            self.trackerGui.blob.show_hash(self.trackerGui.levels[-1])
        
    # called on plugin unloaded
    def _unload(self):
        self.trackerGui.window.destroy()
        self.pluginMenuEntry.destroy()
        return

    # Init Functions
    def readConfig(self):
        pass
    def saveConfig(self):
        if not self.parser.has_section('artisttracker'):
            self.parser.add_section('artisttracker')
            

    # build the menu for pluginMenu. 
    # NOTE: you build a menuItem() and append it to the plugin menu passed in from pympd
    def buildPluginMenu(self, pluginMenu):
        self.pluginMenuEntry = gtk.MenuItem('Artist Visualizer')
        pluginSubMenu = gtk.Menu()
        pluginSubMenu.set_title('AViewer')
        menuEntry = gtk.CheckMenuItem('Show Artist Visualizer')
        menuEntry.activate()
        menuEntry.connect('activate', self.trackerGui.toggle_show)
        pluginSubMenu.append(menuEntry)
        self.pluginMenuEntry.set_submenu(pluginSubMenu)
        self.pluginMenuEntry.show_all()
        pluginMenu.append(self.pluginMenuEntry)
