package WebGUI::Operation::WebGUI;

#-------------------------------------------------------------------
# WebGUI is Copyright 2001-2006 Plain Black Corporation.
#-------------------------------------------------------------------
# Please read the legal notices (docs/legal.txt) and the license
# (docs/license.txt) that came with this distribution before using
# this software.
#-------------------------------------------------------------------
# http://www.plainblack.com                     info@plainblack.com
#-------------------------------------------------------------------

use strict;

#-------------------------------------------------------------------

=head2 www_genesis ( )

The beginning of WebGUI.

=cut

sub www_genesis {
	my $session = shift;
	$session->style->useEmptyStyle("1");
	my $output = '<html><head><title>About WebGUI</title>
	<style>.big {font-size: 23px;}</style>
	</head><body bgcolor="#ef4200" text="black" link="white" vlink="white">
	<br><br><br><br>
	<div align="center" width="100%" height="100%"><div style="width: 400px; font-family: helvetica; font-size: 13px;" align="left">
	<div style="font-family: times new roman, times, serif; font-size: 18px;"><i>
	&#65;&#110;&#100;&#32;&#116;&#104;&#101;&#32;&#73;&#110;&#116;&#101;&#114;&#110;&#101;&#116;&#32;&#119;&#97;&#115;&#32;&#119;&#105;&#116;&#104;&#111;&#117;&#116;&#32;&#102;&#111;&#114;&#109;&#44;&#32;&#97;&#110;&#100;&#32;<span class="big">&#118;&#111;&#105;&#100;&#59;</span>&#32;&#97;&#110;&#100;&#32;<span class="big">&#100;&#97;&#114;&#107;&#110;&#101;&#115;&#115;</span>&#32;&#119;&#97;&#115;&#32;&#117;&#112;&#111;&#110;&#32;&#116;&#104;&#101;&#32;&#102;&#97;&#99;&#101;&#32;&#111;&#102;&#32;&#116;&#104;&#101;&#32;&#119;&#101;&#98;&#46;&#32;&#65;&#110;&#100;&#32;&#80;&#108;&#97;&#105;&#110;&#32;&#66;&#108;&#97;&#99;&#107;&#32;&#102;&#111;&#114;&#109;&#101;&#100;&#32;&#87;&#101;&#98;&#71;&#85;&#73;&#32;&#111;&#102;&#32;&#116;&#104;&#101;&#32;&#100;&#117;&#115;&#116;&#32;&#111;&#102;&#32;&#116;&#97;&#103;&#115;&#32;&#97;&#110;&#100;&#32;&#115;&#99;&#114;&#105;&#112;&#116;&#44;&#32;&#97;&#110;&#100;&#32;<span class="big">&#98;&#114;&#101;&#97;&#116;&#104;&#101;&#100;</span>&#32;&#105;&#110;&#116;&#111;&#32;&#116;&#104;&#101;&#32;&#119;&#101;&#98;&#32;&#116;&#104;&#101;&#32;&#98;&#114;&#101;&#97;&#116;&#104;&#32;&#111;&#102;&#32;&#108;&#105;&#102;&#101;&#59;&#32;&#97;&#110;&#100;&#32;&#99;&#111;&#110;&#116;&#101;&#110;&#116;&#32;&#98;&#101;&#99;&#97;&#109;&#101;&#32;&#97;&#32;<span class="big">&#108;&#105;&#118;&#105;&#110;&#103;</span>&#32;&#115;&#111;&#117;&#108;&#46;
	</i></div><br><br><br>
	<div align="right">Ruling WebGUI, 2:7</div>
	</div></div>
	<br><br><br><br>
	</body></html>';
	return $output;
}

#-------------------------------------------------------------------

=head2 theWg ( )

The core WebGUI function.  All WebGUI Assets, Operations and functions require this
to work, even superseding the session variable.

=cut


sub www_theWg {
	my $session = shift;
	$session->style->useEmptyStyle("1");
	my $output = q|<html><head><title>WebGUI</title></head><body style="background-color: #000000; text-align:center;">
<pre><font color=#ce3903>p</font><font color=#ec3c01>ackageWebGUI;our$VERSION="|.$WebGUI::VERSION.q|";subpage{my$s</font><font color=#ef3e01>e</font><font color=#f03e01>s</font><font color=#f64001>s</font><font color=#f94201>i</font><font color=#fc4200>o</font><font color=#fe4200>n</font><font color=#f54001>=</font><font color=#f13f01>s</font><font color=#e63c01>h</font><font color=#d43701>i</font><font color=#be3201>f</font><font color=#a42b01>t</font><font color=#862301>;</font><font color=#641a01>m</font><font color=#481300>y</font><font color=#2e0c00>$</font><font color=#110500>a</font><font color=black>ssetUrl=shift\|\|$</font><font color=#010100>s</font><br><font color=#a22a01>e</font><font color=#fe4100>ssion->url->getRequestedUrl;my$output=processOperations($s</font><font color=#fd4100>e</font><font color=#ef3d00>s</font><font color=#da3800>s</font><font color=#c33300>i</font><font color=#9b2901>o</font><font color=#5c1801>n</font><font color=#1e0800>)</font><font color=#0a0300>;</font><font color=#020100>i</font><font color=black>f($outputeq"</font><br><font color=#5b1801>"</font><font color=#fe4100>){my</font><font color=#fe5215>$</font><font color=#fc6c38>asset=eval{WebGUI::Asset->newByUrl($sess</font><font color=#fc6e3a>i</font><font color=#fc6f3c>o</font><font color=#fc703e>n</font><font color=#fc713f>,</font><font color=#fc7240>$a</font><font color=#fc713e>s</font><font color=#fc6c38>s</font><font color=#fd652f>e</font><font color=#fd5c22>t</font><font color=#fe5011>U</font><font color=#fe4403>r</font><font color=#fe4100>l,$sess</font><font color=#f84000>i</font><font color=#c03301>o</font><font color=#792000>n</font><font color=#3a1000>-</font><font color=#060200>></font><font color=black>form->proc</font><br><font color=#200901>e</font><font color=#fa4000>s</font><font color=#fe4100>s("</font><font color=#fc6b33>r</font><font color=#f7e5dd>evision"))};if($@){$session->errorHandle</font><font color=#f7e6de>r</font><font color=#f7e6df>-</font><font color=#f7e7e0>></font><font color=#f7e7e1>w</font><font color=#f7e8e1>ar</font><font color=#f7e7e0>n</font><font color=#f7e5dd>(</font><font color=#f7e1d8>"</font><font color=#f7dcd2>C</font><font color=#f8d6c9>o</font><font color=#f8ccbb>u</font><font color=#fab59a>l</font><font color=#fb9772>d</font><font color=#fc7441>n</font><font color=#fd581e>'</font><font color=#fe4e10>t</font><font color=#fe4403>i</font><font color=#fe4100>nst</font><font color=#fc4100>a</font><font color=#e43b00>n</font><font color=#b93000>t</font><font color=#581801>i</font><font color=#170600>a</font><font color=#020100>t</font><font color=black>eassetf</font><br><font color=#020100>o</font><font color=#d63800>r</font><font color=#fe4100>url</font><font color=#fe4a09>:</font><font color=#f7f0eb>"</font><font color=#f6f6f6>.$assetUrl."Rootcause:".$@);}if(defined$asset){my$meth</font><font color=#f7ebe4>o</font><font color=#f9c9b6>d</font><font color=#faa181>=</font><font color=#fc7848>"</font><font color=#fe4c0e>v</font><font color=#fe4100>iew";</font><font color=#d13601>i</font><font color=#781f00>f</font><font color=#220900>(</font><font color=black>$sessi</font><br><font color=black>o</font><font color=#952701>n</font><font color=#fe4100>->fo</font><font color=#f9cab4>r</font><font color=#f6f6f6>m->process("func")){$method=$session->form->process("fun</font><font color=#f6f5f5>c</font><font color=#f7ebe7>"</font><font color=#f8dad0>)</font><font color=#faa584>;</font><font color=#fd6732>u</font><font color=#fe4b0c>n</font><font color=#fe4100>les</font><font color=#fa4000>s</font><font color=#e13a00>(</font><font color=#902601>$</font><font color=#300d00>m</font><font color=#090200>e</font><font color=black>tho</font><br><font color=black>d</font><font color=#551701>=</font><font color=#fe4100>~/^[</font><font color=#fb9d77>A</font><font color=#f6f6f6>-Za-z]</font><font color=#f6f6f7>+$/</font><font color=#f6f6f6>){$sess</font><font color=#f8e1d5>i</font><font color=#f6f6f5>o</font><font color=#f6f6f6>n->error</font><font color=#f7e5dc>H</font><font color=#f7eae3>a</font><font color=#f6f6f6>ndler->secu</font><font color=#f6f5f5>r</font><font color=#f7efe9>i</font><font color=#f7e6dd>t</font><font color=#f8e0d4>y</font><font color=#f8dcd0>("</font><font color=#f8e0d4>t</font><font color=#f7e7de>o</font><font color=#f7f2ec>c</font><font color=#f6f6f6>allanon-exis</font><font color=#f7ece7>t</font><font color=#f9baa3>e</font><font color=#fc7a4a>n</font><font color=#fe4403>t</font><font color=#fe4100>meth</font><font color=#ea3d00>o</font><font color=#9d2900>d</font><font color=#3c1001>$</font><font color=#010000>m</font><font color=black>e</font><br><font color=black>t</font><font color=#140601>h</font><font color=#f94100>o</font><font color=#fe4100>don</font><font color=#fd6c34>$</font><font color=#f6f6f5>a</font><font color=#f6f6f6>sset</font><font color=#f7f1eb>U</font><font color=#fd662c>r</font><font color=#fd5e24>l</font><font color=#fd743e>"</font><font color=#f6f6f6>);$met</font><font color=#f7eeea>h</font><font color=#fd5e24>o</font><font color=#fb8b60>d</font><font color=#f6f4f3>=</font><font color=#f6f6f6>"view"</font><font color=#f6f4f2>;</font><font color=#fc8051>}</font><font color=#fd6730>}</font><font color=#f7f0eb>$</font><font color=#f6f6f6>out</font><font color=#f6f5f4>p</font><font color=#f7e4dd>u</font><font color=#f8d1c3>t</font><font color=#f9bca4>=</font><font color=#fb9c78>t</font><font color=#fb8052>r</font><font color=#fd6932>y</font><font color=#fd571a>A</font><font color=#fe4f13>s</font><font color=#fe4d11>s</font><font color=#fe4d0f>e</font><font color=#fe4c0f>tM</font><font color=#fe4d0f>e</font><font color=#fe4d11>t</font><font color=#fd5114>h</font><font color=#fd5d23>o</font><font color=#fc7543>d</font><font color=#fb9269>(</font><font color=#f9b398>$</font><font color=#f8cebe>s</font><font color=#f7e2d9>e</font><font color=#f6f4f3>s</font><font color=#f6f6f6>sion,$a</font><font color=#f6f0ed>s</font><font color=#f8d4c5>s</font><font color=#fb885e>e</font><font color=#fd581d>t</font><font color=#fe4100>,$m</font><font color=#fd4100>e</font><font color=#f23e00>t</font><font color=#b83001>h</font><font color=#4c1501>o</font><br><font color=black>d)</font><font color=#d13701>;</font><font color=#fe4100>$ou</font><font color=#fe4908>t</font><font color=#f7ede6>p</font><font color=#f6f6f6>ut=tr</font><font color=#fd6830>y</font><font color=#fe4100>A</font><font color=#fe4404>s</font><font color=#f7ece5>s</font><font color=#f6f6f6>etMet</font><font color=#f9b79c>h</font><font color=#fe4100>o</font><font color=#fe4403>d</font><font color=#f8dfd3>(</font><font color=#f6f6f6>$sessi</font><font color=#f9c4ae>o</font><font color=#fe4505>n</font><font color=#fe4100>,</font><font color=#f9d8c7>$</font><font color=#f6f6f6>a</font><font color=#f7f3f1>s</font><font color=#f9c5b0>s</font><font color=#fb8e66>e</font><font color=#fd6c39>t</font><font color=#fe5216>,</font><font color=#fe4201>"</font><font color=#fe4100>view")unless($ou</font><font color=#fe4e10>t</font><font color=#fd6934>p</font><font color=#fb8b63>u</font><font color=#f9c5b0>t</font><font color=#f6f3f2>\|</font><font color=#f6f6f6>\|($meth</font><font color=#f6f4f3>o</font><font color=#f8d2c3>d</font><font color=#fb956f>e</font><font color=#fd4d0e>q</font><font color=#fe4100>"vie</font><font color=#d43901>w</font><br><font color=black>")</font><font color=#882401>)</font><font color=#fe4100>;}}i</font><font color=#f9c2a9>f</font><font color=#f6f6f6>(defi</font><font color=#fb9870>n</font><font color=#fe4100>ed</font><font color=#f9c6ae>(</font><font color=#f6f6f6>$out</font><font color=#f7e8e1>p</font><font color=#fd571a>u</font><font color=#fe4100>t)</font><font color=#f9b295>a</font><font color=#f6f6f6>nd$ou</font><font color=#f8ded3>t</font><font color=#fd5317>p</font><font color=#fe4100>u</font><font color=#fe5315>t</font><font color=#f8d0bc>e</font><font color=#fb9d7a>q</font><font color=#fd561a>"</font><font color=#fe4202>"</font><font color=#fe4100>){if($ses</font><font color=#fe4a0a>s</font><font color=#fd5317>i</font><font color=#fd581d>o</font><font color=#fd581e>n</font><font color=#fd561b>-</font><font color=#fe5012>></font><font color=#fe4807>v</font><font color=#fe4200>a</font><font color=#fe4100>r->isA</font><font color=#fe4202>d</font><font color=#fd571b>m</font><font color=#fba17f>i</font><font color=#f6f4f3>n</font><font color=#f6f6f6>On){my$</font><font color=#f6f5f5>a</font><font color=#f9c1a7>s</font><font color=#fe4100>set=</font><font color=#942701>W</font><br><font color=black>eb</font><font color=#4c1501>G</font><font color=#fe4100>UI::</font><font color=#fb966f>A</font><font color=#f6f6f6>sset-</font><font color=#f9c0a7>></font><font color=#fe4100>ne</font><font color=#fba27d>w</font><font color=#f6f6f6>ByU</font><font color=#f6f4f4>r</font><font color=#fb9369>l</font><font color=#fe4100>($s</font><font color=#fb8d61>e</font><font color=#f6f6f6>ssio</font><font color=#f7ede9>n</font><font color=#fc7340>,</font><font color=#fe4100>$s</font><font color=#fe5d20>e</font><font color=#fd5e25>s</font><font color=#fe4201>s</font><font color=#fe4100>ion->ur</font><font color=#fe4607>l</font><font color=#fd5b20>-</font><font color=#fb8d63>></font><font color=#fab398>g</font><font color=#f8c7b4>e</font><font color=#f8cfc0>t</font><font color=#f8d4c6>Re</font><font color=#f8d2c3>f</font><font color=#f8cdbc>e</font><font color=#f8c5b1>r</font><font color=#fab69b>e</font><font color=#fb9b76>r</font><font color=#fc7a4a>U</font><font color=#fe5519>r</font><font color=#fe4809>l</font><font color=#fe4303>)</font><font color=#fe4100>\|\|W</font><font color=#fd5c20>e</font><font color=#f6f4f3>b</font><font color=#f6f6f6>GUI::Ass</font><font color=#fb9c75>e</font><font color=#fe4100>t->g</font><font color=#551801>e</font><br><font color=black>tD</font><font color=#100501>e</font><font color=#f53f00>f</font><font color=#fe4100>aul</font><font color=#fd642b>t</font><font color=#f6f6f6>($ses</font><font color=#f7ebe3>s</font><font color=#fe4504>i</font><font color=#fe4100>o</font><font color=#fc7845>n</font><font color=#f6f6f6>);$</font><font color=#fab295>s</font><font color=#fe4302>e</font><font color=#fe4100>ssi</font><font color=#fd6025>o</font><font color=#f6f6f6>n-></font><font color=#f6ede7>h</font><font color=#fc7b4c>t</font><font color=#fe4100>tp->setRedi</font><font color=#fe4808>r</font><font color=#fc7f52>e</font><font color=#f9c6b0>c</font><font color=#f7f4f2>t</font><font color=#f6f6f6>($asset->get</font><font color=#f7f4f2>U</font><font color=#f8d4c5>r</font><font color=#faa686>l</font><font color=#fc794a>(</font><font color=#fe5115>"</font><font color=#fe4100>f</font><font color=#fb936a>u</font><font color=#f6f6f6>nc=add;cl</font><font color=#fd682f>a</font><font color=#fe4100>ss=</font><font color=#f74000>W</font><font color=#130601>e</font><br><font color=black>bGU</font><font color=#c43301>I</font><font color=#fe4100>::A</font><font color=#fe4504>s</font><font color=#f7e8df>s</font><font color=#f6f6f6>et::W</font><font color=#fd642a>o</font><font color=#fe4100>b</font><font color=#fe5516>j</font><font color=#f6f4f1>e</font><font color=#f6f5f5>c</font><font color=#f9c5af>t</font><font color=#fe4f11>:</font><font color=#fe4100>:</font><font color=#fe5a20>L</font><font color=#fd713a>a</font><font color=#fe4100>y</font><font color=#fe4504>o</font><font color=#f7ebe2>u</font><font color=#f6f6f6>t</font><font color=#f6ece6>;</font><font color=#fb8559>u</font><font color=#fe4302>r</font><font color=#fe4100>l=".$asset</font><font color=#fd591e>U</font><font color=#f9bda5>r</font><font color=#f7ede9>l</font><font color=#f6f6f6>));}else{$session</font><font color=#f7ece7>-</font><font color=#f8d5c7>></font><font color=#fa9f7e>h</font><font color=#f8cdb9>t</font><font color=#f6f6f6>tp->setS</font><font color=#f7eae1>t</font><font color=#fe4605>a</font><font color=#fe4100>tus</font><font color=#c83501>(</font><font color=#010000>"</font><br><font color=black>404</font><font color=#822301>"</font><font color=#fe4100>,"Pa</font><font color=#f9bda2>g</font><font color=#f6f6f6>eNotF</font><font color=#fb9167>o</font><font color=#fe4100>u</font><font color=#fe4201>n</font><font color=#f7dfd1>d</font><font color=#f9c2ac>"</font><font color=#fd5012>)</font><font color=#fe4100>;</font><font color=#fe5518>m</font><font color=#f8d1c0>y</font><font color=#faaa8a>$</font><font color=#fe4100>no</font><font color=#f9c4ac>t</font><font color=#f7e5dd>F</font><font color=#fc7949>o</font><font color=#fe4100>und=WebGUI:</font><font color=#fd6128>:</font><font color=#f8dbce>A</font><font color=#f6f6f6>sset->getNotFound($session);if(</font><font color=#f9bea3>d</font><font color=#fe4100>efin</font><font color=#842301>e</font><font color=black>d</font><br><font color=black>$no</font><font color=#401201>t</font><font color=#fe4100>Foun</font><font color=#fb8e63>d</font><font color=#f6f6f6>){$ou</font><font color=#f9bda2>t</font><font color=#fe4100>pu</font><font color=#fc8556>t</font><font color=#fe4f12>=</font><font color=#fe4100>t</font><font color=#fd5b21>r</font><font color=#f8cdba>y</font><font color=#f6f6f6>A</font><font color=#f8d6c5>s</font><font color=#fe4100>se</font><font color=#fc8658>t</font><font color=#fc6934>M</font><font color=#fe4201>e</font><font color=#fe4807>t</font><font color=#fe4100>hod($sess</font><font color=#fe4a0b>i</font><font color=#f8d2c1>o</font><font color=#f6f6f6>n,$notFound,'view');}else{$sessi</font><font color=#fb8d62>o</font><font color=#fe4100>n->e</font><font color=#401201>r</font><font color=black>r</font><br><font color=black>orH</font><font color=#0a0300>a</font><font color=#f33f01>n</font><font color=#fe4100>dle</font><font color=#fe6126>r</font><font color=#f6f5f5>-</font><font color=#f6f6f6>>err</font><font color=#f7e5da>o</font><font color=#fe4403>r</font><font color=#fe4100>("T</font><font color=#fd6933>h</font><font color=#f8d6c8>e</font><font color=#f6f6f6>no</font><font color=#f6f3f0>t</font><font color=#fe4f0f>F</font><font color=#fe4100>oun</font><font color=#fd591e>d</font><font color=#fc7e4a>p</font><font color=#fe4100>agecouldn</font><font color=#fb8b5e>o</font><font color=#f6f6f6>tbeinstanciated!");$output="Aner</font><font color=#f6f5f4>r</font><font color=#fe5f23>o</font><font color=#fe4100>rwa</font><font color=#f23f01>s</font><font color=#090300>e</font><font color=black>n</font><br><font color=black>coun</font><font color=#ba3101>t</font><font color=#fe4100>ere</font><font color=#fe4303>d</font><font color=#f7e1d5>w</font><font color=#f6f6f6>hile</font><font color=#f6f5f5>p</font><font color=#fc8253>r</font><font color=#fc713f>oc</font><font color=#fb9169>e</font><font color=#f7e9e3>s</font><font color=#f6f6f6>sing</font><font color=#fb956c>y</font><font color=#fc713f>ou</font><font color=#fc8456>r</font><font color=#f8dfd3>r</font><font color=#fd642b>e</font><font color=#fe4100>quest.";</font><font color=#fe4201>}</font><font color=#f9ccb8>$</font><font color=#f6f6f6>output="Anerrorwasencounteredwhi</font><font color=#f7dfd1>l</font><font color=#fe4302>e</font><font color=#fe4100>pro</font><font color=#b53001>c</font><font color=black>es</font><br><font color=black>sing</font><font color=#7b2101>y</font><font color=#fe4100>ourr</font><font color=#fab99d>e</font><font color=#f6f6f6>quest</font><font color=#f6f5f3>.</font><font color=#f6f4f3>"i</font><font color=#f6f6f5>f</font><font color=#f6f6f6>$outp</font><font color=#f6f5f4>u</font><font color=#f6f4f3>te</font><font color=#f6f5f4>q</font><font color=#f8dfd2>'</font><font color=#fe4403>'</font><font color=#fe4100>;}}if($o</font><font color=#fe5111>u</font><font color=#f6f1ed>t</font><font color=#f6f6f6>puteq"chunked"){$output=undef;}r</font><font color=#fab496>e</font><font color=#fe4100>turn</font><font color=#761f01>$</font><font color=black>ou</font><br><font color=black>tput</font><font color=#350f01>;</font><font color=#fe4100>}sub</font><font color=#fb8658>p</font><font color=#f6f6f6>rocessOperations{m</font><font color=#faa785>y</font><font color=#fe4100>$session=</font><font color=#fc8557>s</font><font color=#f6f6f6>hift;my$output="";my$op=$session-</font><font color=#fc804f>></font><font color=#fe4100>for</font><font color=#fd4100>m</font><font color=#2e0d01>-</font><font color=black>>p</font><br><font color=black>roce</font><font color=#090300>s</font><font color=#ee3e01>s</font><font color=#fe4100>("o</font><font color=#fd5b1e>p</font><font color=#f6f1ee>"</font><font color=#f6f1ef>);if</font><font color=#f6f2f0>($o</font><font color=#f6f2f1>p</font><font color=#f6f3f1>){</font><font color=#f6f5f5>$</font><font color=#f6f6f6>output</font><font color=#fc7641>=</font><font color=#fe4100>WebGUI::O</font><font color=#fab79a>p</font><font color=#f6f6f6>eration::execute($session,$op);}</font><font color=#f6f4f3>r</font><font color=#fe5416>e</font><font color=#fe4100>tur</font><font color=#e73c01>n</font><font color=#060200>$</font><font color=black>ou</font><br><font color=black>tput;</font><font color=#af2e01>}</font><font color=#fe4100>pack</font><font color=#fd5e23>a</font><font color=#fd6228>g</font><font color=#fd652d>e</font><font color=#fd6730>W</font><font color=#fc6b34>e</font><font color=#fc6e39>b</font><font color=#fc713d>G</font><font color=#fc7341>U</font><font color=#fc7745>I</font><font color=#fc7b4b>:</font><font color=#fc7e4e>:</font><font color=#f8e2d7>A</font><font color=#f6f6f6>sset;</font><font color=#f7ebe3>s</font><font color=#fe4605>u</font><font color=#fe4100>bcanView</font><font color=#fe4707>{</font><font color=#f7ebe3>m</font><font color=#f6f6f6>y$self=shift;my$userId=shift\|\|$s</font><font color=#f8d4c2>e</font><font color=#fe4100>lf-></font><font color=#a42b01>s</font><font color=black>ess</font><br><font color=black>ion-></font><font color=#721f01>u</font><font color=#fe4100>ser->userId;my</font><font color=#fe5112>$</font><font color=#f6f0eb>u</font><font color=#f6f6f6>ser=W</font><font color=#fabda3>e</font><font color=#fe4100>bGUI::Use</font><font color=#fd6e38>r</font><font color=#f6f6f6>->new($se</font><font color=#f6ede9>l</font><font color=#f7ebe6>f->session,$user</font><font color=#f6f5f5>I</font><font color=#f6f6f6>d);ret</font><font color=#fba480>u</font><font color=#fe4100>rn0u</font><font color=#621a01>n</font><font color=black>les</font><br><font color=black>s($se</font><font color=#2b0c01>l</font><font color=#c13200>f</font><font color=#c63300>-</font><font color=#ca3400>></font><font color=#cc3500>g</font><font color=#cf3600>e</font><font color=#d23600>t</font><font color=#d83800>(</font><font color=#db3800>"</font><font color=#dd3900>s</font><font color=#ec3d00>t</font><font color=#fe4100>ate"</font><font color=#fc8253>)</font><font color=#f6f6f6>eq"pub</font><font color=#fc8658>l</font><font color=#fe4100>ished");i</font><font color=#faa684>f</font><font color=#f6f6f6>($userIde</font><font color=#fb9167>q</font><font color=#fc6b35>$self->get("own</font><font color=#fc733e>e</font><font color=#f7f3f0>r</font><font color=#f6f6f6>UserId</font><font color=#fd6f38>"</font><font color=#fe4100>)){</font><font color=#fb4100>r</font><font color=#1a0701>e</font><font color=black>tur</font><br><font color=black>n1;}e</font><font color=#030100>l</font><font color=#160600>s</font><font color=#180600>i</font><font color=#190700>f</font><font color=#1a0700>(</font><font color=#1b0700>$</font><font color=#1c0700>u</font><font color=#1f0800>s</font><font color=#200800>e</font><font color=#210900>r</font><font color=#982801>-</font><font color=#fe4100>>isI</font><font color=#fab79b>n</font><font color=#f6f6f6>Group</font><font color=#f6f2ee>(</font><font color=#fe5517>$</font><font color=#fe4100>self->ge</font><font color=#fe4302>t</font><font color=#f8d9ca>(</font><font color=#f6f6f6>"groupIdV</font><font color=#fb895c>i</font><font color=#fe4100>ew"))){return1;</font><font color=#fc7440>}</font><font color=#f6f6f6>return</font><font color=#f7e9e0>$</font><font color=#fe4908>s</font><font color=#fe4100>elf</font><font color=#cc3601>-</font><font color=#010000>></font><font color=black>can</font><br><font color=black>Edit($userId);}</font><font color=#c93401>s</font><font color=#fe4100>ubn</font><font color=#fe4504>e</font><font color=#f7e7de>w</font><font color=#f6f6f6>{my$c</font><font color=#f9d0bd>l</font><font color=#fe4100>ass=shift</font><font color=#fd5d22>;</font><font color=#f6f5f3>m</font><font color=#f6f6f6>y$session</font><font color=#faa988>=</font><font color=#fd5213>shift</font><font color=#fe4504>;</font><font color=#fe4100>my$assetI</font><font color=#faa786>d</font><font color=#f6f6f6>=shift</font><font color=#f9bda2>;</font><font color=#fe4100>retu</font><font color=#852401>r</font><font color=black>nund</font><br><font color=black>efunless($asse</font><font color=#1f0801>t</font><font color=#f94000>I</font><font color=#fe4100>d);</font><font color=#fd6f39>m</font><font color=#f6f6f5>y</font><font color=#f6f6f6>$clas</font><font color=#fb9871>s</font><font color=#fe4100>Name=shif</font><font color=#fb946b>t</font><font color=#f6f6f6>;my$assetR</font><font color=#f6efec>e</font><font color=#f7e6df>visi</font><font color=#f7e1d7>o</font><font color=#fe5010>n</font><font color=#fe4100>=$sessio</font><font color=#fe4302>n</font><font color=#f8dbce>-</font><font color=#f6f6f6>>stow-</font><font color=#fb8658>></font><font color=#fe4100>get</font><font color=#fd4100>(</font><font color=#3a1001>"</font><font color=black>asse</font><br><font color=black>tRevision");my</font><font color=#601a01>$</font><font color=#fe4100>revi</font><font color=#faa17d>s</font><font color=#f6f6f6>ionDat</font><font color=#fd662c>e</font><font color=#fe4100>=shift\|\|$</font><font color=#f9c6b0>a</font><font color=#f6f6f6>ssetRevision->{</font><font color=#f8d0bd>$</font><font color=#fe4100>assetId}{</font><font color=#fd5b1f>$</font><font color=#f6f4f3>s</font><font color=#f6f6f6>essio</font><font color=#f7f5f4>n</font><font color=#fe5618>-</font><font color=#fe4100>>sc</font><font color=#ea3d01>r</font><font color=#080200>a</font><font color=black>tch-</font><br><font color=black>>get("versionT</font><font color=#b12f01>a</font><font color=#fe4100>g")</font><font color=#fe4302>\|</font><font color=#f8d9ca>\|</font><font color=#f6f6f6>'_'};</font><font color=#f8dfd1>u</font><font color=#fe4201>n</font><font color=#fe4100>less($re</font><font color=#fe5010>v</font><font color=#f7f2ef>i</font><font color=#f6f6f6>sionDate){($rev</font><font color=#fb956c>i</font><font color=#fe4100>sionDate)</font><font color=#fb9268>=</font><font color=#f6f6f6>$sessi</font><font color=#f8d2bf>o</font><font color=#fe4100>n->d</font><font color=#a42b01>b</font><font color=black>->qui</font><br><font color=black>ckArray("sele</font><font color=#090200>c</font><font color=#ef3e00>t</font><font color=#fe4100>max</font><font color=#fd5a1d>(</font><font color=#f6f3f1>r</font><font color=#f6f6f6>evisi</font><font color=#fab08f>o</font><font color=#fe4100>nDate)fro</font><font color=#fc7d4c>m</font><font color=#f6f6f6>assetDatawherea</font><font color=#f6f6f5>s</font><font color=#fd6126>s</font><font color=#fe4100>etId=?and</font><font color=#f9c2a9>(</font><font color=#f6f6f6>status</font><font color=#faa37f>=</font><font color=#fe4100>'app</font><font color=#611a01>r</font><font color=black>oved'</font><br><font color=black>orstatus='arc</font><font color=#4a1401>h</font><font color=#fe4100>ived</font><font color=#fb9168>'</font><font color=#f6f6f6>ortagI</font><font color=#fc7541>d</font><font color=#fe4100>=?)orderb</font><font color=#f9b79c>y</font><font color=#f6f6f6>assetData.revis</font><font color=#f8daca>i</font><font color=#fe4100>onDate",[</font><font color=#fe4b0b>$</font><font color=#f7f0eb>a</font><font color=#f6f6f6>ssetI</font><font color=#f6f6f5>d</font><font color=#fd6a33>,</font><font color=#fe4100>$se</font><font color=#f94000>s</font><font color=#170601>s</font><font color=black>ion-></font><br><font color=black>scratch->get(</font><font color=#912601>"</font><font color=#fe4100>vers</font><font color=#f9c4ad>i</font><font color=#f6f6f6>onTag</font><font color=#f7f3ef>"</font><font color=#fe5010>)</font><font color=#fe4100>]);$asse</font><font color=#fe4606>t</font><font color=#f7e5da>R</font><font color=#f6f6f6>evision->{$asse</font><font color=#fba684>t</font><font color=#fe4100>Id}{$sess</font><font color=#fc7d4c>i</font><font color=#f6f6f6>on->sc</font><font color=#f7e7de>r</font><font color=#fe4707>a</font><font color=#fe4100>tch</font><font color=#cc3501>-</font><font color=black>>get("</font><br><font color=black>versionTag")</font><font color=#020000>\|</font><font color=#da3901>\|</font><font color=#fe4100>'_'</font><font color=#fe4c0c>}</font><font color=#f7f0eb>=</font><font color=#f6f6f6>$revi</font><font color=#f8e8de>s</font><font color=#fe4201>i</font><font color=#fe4100>onDate;$</font><font color=#fd6b34>s</font><font color=#f6f6f6>ession->stow->s</font><font color=#f6f6f5>e</font><font color=#fd6c34>t</font><font color=#fe4100>("assetR</font><font color=#fe4404>e</font><font color=#f9cdb9>v</font><font color=#f6f6f6>ision"</font><font color=#f9b79a>,</font><font color=#fe4100>$ass</font><font color=#7e2201>e</font><font color=black>tRevis</font><br><font color=black>ion);}return</font><font color=#1a0701>u</font><font color=#fb4000>n</font><font color=#fe4100>def</font><font color=#fc733e>u</font><font color=#f6f6f6>nless(</font><font color=#f8e8df>$</font><font color=#fe4201>r</font><font color=#fe4100>evisionD</font><font color=#fb8d61>a</font><font color=#f6f6f6>te);if($classNa</font><font color=#f8d7c8>m</font><font color=#fe4606>e</font><font color=#fe4100>){my$cmd</font><font color=#fc8559>=</font><font color=#f6f4f2>"</font><font color=#f6f6f6>use".</font><font color=#f6f5f5>$</font><font color=#fc7947>c</font><font color=#fe4100>las</font><font color=#fc4100>s</font><font color=#350f01>N</font><font color=black>ame;ev</font><br><font color=black>al($cmd);if(</font><font color=#3e1101>$</font><font color=#fe4100>@){$</font><font color=#fb936a>s</font><font color=#f6f6f6>ession</font><font color=#f6f3f1>-</font><font color=#fd5315>></font><font color=#fe4100>errorHan</font><font color=#fc895c>d</font><font color=#f6f6f6>ler->error("Co</font><font color=#f7f2ef>u</font><font color=#fc7745>l</font><font color=#fe4100>dn'tcomp</font><font color=#fd6630>i</font><font color=#f7e7df>l</font><font color=#f6f6f6>easset</font><font color=#f8dacc>p</font><font color=#fe4605>a</font><font color=#fe4100>cka</font><font color=#ce3601>g</font><font color=#030100>e</font><font color=black>:".$cl</font><br><font color=black>assName.".Ro</font><font color=#531600>o</font><font color=#fe4100>tcau</font><font color=#fba37f>s</font><font color=#f6f6f6>e:".$@)</font><font color=#fb966e>;</font><font color=#fe4100>returnun</font><font color=#fd5518>d</font><font color=#f8e2d9>e</font><font color=#f6f6f6>f;}$class=$c</font><font color=#f7e3db>l</font><font color=#fb885d>a</font><font color=#fe4303>s</font><font color=#fe4100>sName;</font><font color=#fe4201>}</font><font color=#fc6e3a>m</font><font color=#f7e0d5>y</font><font color=#f6f6f6>$cache</font><font color=#f6f2f0>=</font><font color=#fc7c4c>W</font><font color=#fe4100>ebG</font><font color=#fc4100>U</font><font color=#591801>I</font><font color=black>::Cache</font><br><font color=black>->new($sessi</font><font color=#4e1501>o</font><font color=#fe4100>n,["</font><font color=#fb9f7b>a</font><font color=#f6f6f6>sset",$</font><font color=#f7e6dd>a</font><font color=#fd5e24>s</font><font color=#fe4100>setId,$r</font><font color=#fc703d>e</font><font color=#f8d1c0>v</font><font color=#f6f6f5>i</font><font color=#f6f6f6>sionDate</font><font color=#f7ebe4>]</font><font color=#fab296>)</font><font color=#fc6a35>;</font><font color=#fe4100>my$prop</font><font color=#fe4302>e</font><font color=#fb8a60>r</font><font color=#f7e5dd>t</font><font color=#f6f6f6>ies=$ca</font><font color=#f9b69b>c</font><font color=#fe4303>h</font><font color=#fe4100>e-></font><font color=#c63401>g</font><font color=#070200>e</font><font color=black>t;if(ex</font><br><font color=black>ists$propert</font><font color=#2a0c01>i</font><font color=#fd4100>e</font><font color=#fe4100>s-></font><font color=#fc8050>{</font><font color=#f6f6f6>assetId}</font><font color=#f8ded2>)</font><font color=#fc6f3b>{</font><font color=#fe4302>#</font><font color=#fe4100>gotprop</font><font color=#fe4708>e</font><font color=#fd662e>r</font><font color=#fb8f66>t</font><font color=#faa887>i</font><font color=#f9b599>e</font><font color=#f9b69d>s</font><font color=#fab498>f</font><font color=#faa887>r</font><font color=#fb926a>o</font><font color=#fc723e>m</font><font color=#fe4d0f>c</font><font color=#fe4505>a</font><font color=#fe4100>che}el</font><font color=#fe4a0b>s</font><font color=#fc7241>e</font><font color=#f9c8b4>{</font><font color=#f6f3f1>m</font><font color=#f6f6f6>y$sql="</font><font color=#f8c4af>s</font><font color=#fe4b0b>e</font><font color=#fe4100>lec</font><font color=#e83c00>t</font><font color=#2c0c01>*</font><font color=black>fromasse</font><br><font color=black>t";foreachmy</font><font color=#070200>$</font><font color=#e63c01>d</font><font color=#fe4100>efi</font><font color=#fe5113>n</font><font color=#f7efea>i</font><font color=#f6f6f6>tion(@{$</font><font color=#f7e5dc>c</font><font color=#fb9d7a>l</font><font color=#fd4f11>a</font><font color=#fe4201>s</font><font color=#fe4100>s->definition($sessi</font><font color=#fe4201>o</font><font color=#fe4707>n</font><font color=#fc7b4b>)</font><font color=#f9bea7>}</font><font color=#f7eae5>)</font><font color=#f6f6f6>{$sql.=</font><font color=#f6f6f5>"</font><font color=#f9c8b3>l</font><font color=#fd551a>e</font><font color=#fe4100>ftj</font><font color=#fb4100>o</font><font color=#5d1901>i</font><font color=black>n".$defin</font><br><font color=black>ition->{table</font><font color=#812201>N</font><font color=#fe4100>ame}</font><font color=#fb9871>.</font><font color=#f6f6f5>"</font><font color=#f6f6f6>onasset.a</font><font color=#f7ede8>s</font><font color=#fab195>s</font><font color=#fc7e50>e</font><font color=#fd6129>t</font><font color=#fe4a0b>I</font><font color=#fe4100>d=".$definiti</font><font color=#fe4403>o</font><font color=#fe5417>n</font><font color=#fd6935>-</font><font color=#fb855a>></font><font color=#fab397>{</font><font color=#f7e8e1>t</font><font color=#f6f6f6>ableName}</font><font color=#f7ece7>.</font><font color=#faa482>"</font><font color=#fe4506>.</font><font color=#fe4100>ass</font><font color=#f03e00>e</font><font color=#611a01>t</font><font color=black>Idand".$de</font><br><font color=black>finition->{ta</font><font color=#190700>b</font><font color=#e33b00>l</font><font color=#fe4100>eNa</font><font color=#fe4b0d>m</font><font color=#f9bfa7>e</font><font color=#f6f4f3>}</font><font color=#f6f6f6>.".revisio</font><font color=#f7f0ec>n</font><font color=#f7dcd1>D</font><font color=#f8cbba>a</font><font color=#f9b499>t</font><font color=#fa9b77>e</font><font color=#fb875b>=</font><font color=#fc7847>"</font><font color=#fd6f3a>.</font><font color=#fd6932>$</font><font color=#fd6830>r</font><font color=#fd6932>e</font><font color=#fd6d39>v</font><font color=#fc7744>i</font><font color=#fb8356>s</font><font color=#fb946e>i</font><font color=#faaa8b>o</font><font color=#f9c2ad>n</font><font color=#f8d2c4>D</font><font color=#f7e2da>a</font><font color=#f6f3f1>t</font><font color=#f6f6f6>e;}$sql.=</font><font color=#f6f2f0>"</font><font color=#f8d4c5>w</font><font color=#fc7747>h</font><font color=#fe4606>e</font><font color=#fe4100>rea</font><font color=#eb3d00>s</font><font color=#5c1901>s</font><font color=#040100>e</font><font color=black>t.assetId=</font><br><font color=black>".$session->db</font><font color=#461301>-</font><font color=#ef3d00>></font><font color=#fe4100>quo</font><font color=#fe4909>t</font><font color=#faa787>e</font><font color=#f6efeb>(</font><font color=#f6f6f6>$assetId);$properties=$session->db-></font><font color=#f6f3f1>q</font><font color=#f8cbba>u</font><font color=#fb8a60>i</font><font color=#fe4808>c</font><font color=#fe4100>kHas</font><font color=#be3200>h</font><font color=#320d01>R</font><font color=black>ef($sql);ret</font><br><font color=black>urnundefunless</font><font color=#020100>(</font><font color=#561701>e</font><font color=#e83c00>x</font><font color=#fe4100>ist</font><font color=#fe4708>s</font><font color=#fc7443>$</font><font color=#f8c8b5>p</font><font color=#f7eae4>r</font><font color=#f6f5f5>o</font><font color=#f6f6f6>perties->{assetId});$cache->s</font><font color=#f6f2f0>e</font><font color=#f7e8e2>t</font><font color=#f8dace>(</font><font color=#faaf92>$</font><font color=#fc7442>p</font><font color=#fd5216>r</font><font color=#fe4100>ope</font><font color=#fc4100>r</font><font color=#e23b00>t</font><font color=#7a2001>i</font><font color=#170600>e</font><font color=black>s,60*60*24);}</font><br><font color=black>if(defined$prope</font><font color=#3b1000>r</font><font color=#c43301>t</font><font color=#fe4100>ies)</font><font color=#fe4404>{</font><font color=#fd723f>m</font><font color=#faa585>y</font><font color=#f8d1c1>$</font><font color=#f7f2ef>o</font><font color=#f6f6f6>bject={_session=>$sessi</font><font color=#f7f3f0>o</font><font color=#f8e0d5>n</font><font color=#f9c6b3>,</font><font color=#faab8d>_</font><font color=#fb8d65>p</font><font color=#fd6d38>r</font><font color=#fe4a0b>o</font><font color=#fe4100>perti</font><font color=#e73c01>e</font><font color=#8e2501>s</font><font color=#280b00>=</font><font color=black>>$properties};b</font><br><font color=black>less$object,$clas</font><font color=#140500>s</font><font color=#711e01>;</font><font color=#d43700>r</font><font color=#f84000>e</font><font color=#fe4100>tur</font><font color=#fe4404>n</font><font color=#fd5013>$</font><font color=#fd6027>o</font><font color=#fc8458>b</font><font color=#faa687>j</font><font color=#f9c3ae>e</font><font color=#f8d3c4>c</font><font color=#f8dace>t</font><font color=#f7dfd5>;</font><font color=#f7e3da>}</font><font color=#f7e6de>r</font><font color=#f7e7e1>e</font><font color=#f7e8e1>tu</font><font color=#f7e7e0>r</font><font color=#f7e5de>n</font><font color=#f7e3db>u</font><font color=#f7e0d7>n</font><font color=#f7dcd2>d</font><font color=#f8d8cb>e</font><font color=#f8d3c4>f</font><font color=#f8cab7>;</font><font color=#f9b89f>}</font><font color=#faa484>s</font><font color=#fb8e65>u</font><font color=#fc7543>b</font><font color=#fd5e25>a</font><font color=#fd5419>d</font><font color=#fe4d0f>d</font><font color=#fe4605>R</font><font color=#fe4100>evis</font><font color=#fc4100>i</font><font color=#e73c00>o</font><font color=#c63300>n</font><font color=#761f01>{</font><font color=#220900>m</font><font color=#060200>y</font><font color=black>$self=shift;my$p</font><br><font color=black>roperties=shift;my$</font><font color=#1e0800>n</font><font color=#691b00>o</font><font color=#bc3101>w</font><font color=#fa4000>=</font><font color=#fe4100>shift\|\|</font><font color=#fe4a0a>$</font><font color=#fe571b>s</font><font color=#fd6129>e</font><font color=#fd6833>l</font><font color=#fc6e3b>f</font><font color=#fc713f>-</font><font color=#fc7341>></font><font color=#fc7240>s</font><font color=#fc713e>e</font><font color=#fc6e3a>s</font><font color=#fd6933>s</font><font color=#fd632c>i</font><font color=#fd5c22>o</font><font color=#fe5316>n</font><font color=#fe490a>-</font><font color=#fe4201>></font><font color=#fe4100>datetime-</font><font color=#fd4100>></font><font color=#e23b01>t</font><font color=#ad2d01>i</font><font color=#731e01>m</font><font color=#3f1100>e</font><font color=#0c0300>(</font><font color=black>);my$workingTag=Web</font><br><font color=black>GUI::VersionTag->get</font><font color=#010000>W</font><font color=#0a0300>o</font><font color=#240a00>r</font><font color=#6d1d01>k</font><font color=#ad2d00>i</font><font color=#cd3500>n</font><font color=#e53b00>g</font><font color=#f84000>(</font><font color=#fe4100>$self->session);$se</font><font color=#fd4100>l</font><font color=#f63f00>f</font><font color=#e83c00>-</font><font color=#d93800>></font><font color=#c83400>s</font><font color=#b42f00>e</font><font color=#8d2501>s</font><font color=#5e1901>s</font><font color=#2c0c01>i</font><font color=#0e0400>o</font><font color=#080200>n</font><font color=#010000>-</font><font color=black>>db->write("insertint</font><br><font color=#010100>o</font><font color=black>assetData(assetId,revis</font><font color=#030100>i</font><font color=#1e0800>o</font><font color=#3b1000>n</font><font color=#561600>D</font><font color=#761f01>a</font><font color=#972801>t</font><font color=#b32f01>e</font><font color=#c93501>,</font><font color=#dc3901>r</font><font color=#ec3d01>e</font><font color=#f94504>v</font><font color=#fe4602>i</font><font color=#fe4200>s</font><font color=#fe4301>e</font><font color=#fe4703>d</font><font color=#f74303>B</font><font color=#eb3d01>y</font><font color=#de3a01>,</font><font color=#d03601>t</font><font color=#bf3201>a</font><font color=#ad2e01>g</font><font color=#972801>I</font><font color=#802101>d</font><font color=#661b01>,</font><font color=#511600>s</font><font color=#401100>t</font><font color=#2d0c00>a</font><font color=#180700>t</font><font color=#040100>u</font><font color=black>s,url,ownerUserId,groupIdE</font><font color=#010100>d</font><br>

</pre>
</body></html>|;
	return $output;
}
1;
