require "test/unit"
require 'tempfile'

$:.unshift File.expand_path(File.dirname(__FILE__) + '/../lib')
require "eventmachine"

module EventMachine
  def self._set_mocks
    class <<self
      alias set_tls_parms_old set_tls_parms
      alias start_tls_old start_tls
      def set_tls_parms *args; end
      def start_tls *args; end
    end
  end
  
  def self._clear_mocks
    class <<self
      alias set_tls_parms set_tls_parms_old
      alias start_tls start_tls_old
    end
  end
end
  

class TestSslArgs < Test::Unit::TestCase
  def setup
    EventMachine._set_mocks
  end
  
  def teardown
    EventMachine._clear_mocks
  end
  
  def test_tls_params_file_doesnt_exist
    priv_file, cert_file = 'foo_priv_key', 'bar_cert_file'
    [priv_file, cert_file].all? do |f|
      assert(!File.exists?(f), "Cert file #{f} seems to exist, and should not for the tests")
    end
    
    # associate_callback_target is a pain! (build!)
    conn = EventMachine::Connection.new('foo')
    
    assert_raises(EventMachine::FileNotFoundException) do
      conn.start_tls(:private_key_file => priv_file)
    end
    assert_raises(EventMachine::FileNotFoundException) do
      conn.start_tls(:cert_chain_file => cert_file)
    end
    assert_raises(EventMachine::FileNotFoundException) do
      conn.start_tls(:private_key_file => priv_file, :cert_chain_file => cert_file)
    end
  end
  
  def test_tls_params_file_does_exist
    priv_file = Tempfile.new('em_test')
    cert_file = Tempfile.new('em_test')
    priv_file_path = priv_file.path
    cert_file_path = cert_file.path
    conn = EventMachine::Connection.new('foo')
    params = {:private_key_file => priv_file_path, :cert_chain_file => cert_file_path}
    begin
      conn.start_tls params
    rescue Object
      assert(false, 'should not have raised an exception')
    end
  end
end if EM.ssl?