#########################################################################
#
# KDevPlatform Configuration File 
#
# This file sets various CMake Variables
#
# KDEVPLATFORM_INCLUDE_DIR             - The Include Directory for all KDEVPLATFORM libraries
# KDEVPLATFORM_INTERFACES_LIBRARIES      - the interfaces library
# KDEVPLATFORM_LANGUAGE_LIBRARIES        - the language library
# KDEVPLATFORM_OUTPUTVIEW_LIBRARIES      - the outputview library
# KDEVPLATFORM_PROJECT_LIBRARIES         - the project library
# KDEVPLATFORM_SUBLIME_LIBRARIES         - the sublime library
# KDEVPLATFORM_SHELL_LIBRARIES           - the shell library
# KDEVPLATFORM_TESTS_LIBRARIES           - the tests library
# KDEVPLATFORM_JSONTESTS_LIBRARIES       - the jsontests library
# KDEVPLATFORM_UTIL_LIBRARIES            - the util library
# KDEVPLATFORM_VCS_LIBRARIES             - the vcs library
# KDEVPLATFORM_DEBUGGER_LIBRARIES        - debugger module library
#
# Copyright 2008  Andreas Pakulat <apaku@gmx.de>
# Redistribution and use is allowed according to the terms of the BSD license.
######################################################################

get_filename_component(_KDEVPLATFORM_CURRENT_DIR  "${CMAKE_CURRENT_LIST_FILE}" PATH)
set( KDEV_PLUGIN_VERSION 16 )

if(NOT WIN32)
# This is needed on non-win32 platforms, as lib-install-dir might be in a 
# totally different prefix than include-install-dir. So instead hardcode the
# absolute path during buildtime
set( KDEVPLATFORM_INCLUDE_DIR "/usr/local/include/kde4/kdevplatform" )

else(NOT WIN32)

set( KDEVPLATFORM_INCLUDE_DIR "${_KDEVPLATFORM_CURRENT_DIR}/../../../include/kdevplatform" )

endif(NOT WIN32)

if( NOT TARGET KDevPlatformImport__kdevplatforminterfaces )
    include("${_KDEVPLATFORM_CURRENT_DIR}/KDevPlatformTargets.cmake")
endif( NOT TARGET KDevPlatformImport__kdevplatforminterfaces )

macro( _kdevplatform_set_lib_vars _prefix _lib )
  set( KDEVPLATFORM_${_prefix}_LIBRARIES KDevPlatformImport__${_lib} )
endmacro( _kdevplatform_set_lib_vars )

_kdevplatform_set_lib_vars( INTERFACES kdevplatforminterfaces )
_kdevplatform_set_lib_vars( PROJECT kdevplatformproject )
_kdevplatform_set_lib_vars( LANGUAGE kdevplatformlanguage )
_kdevplatform_set_lib_vars( UTIL kdevplatformutil ) 
_kdevplatform_set_lib_vars( SHELL kdevplatformshell )
_kdevplatform_set_lib_vars( SUBLIME sublime )
_kdevplatform_set_lib_vars( VCS kdevplatformvcs )
_kdevplatform_set_lib_vars( OUTPUTVIEW kdevplatformoutputview )
_kdevplatform_set_lib_vars( DEBUGGER kdevplatformdebugger )
_kdevplatform_set_lib_vars( DOCUMENTATION kdevplatformdocumentation )
_kdevplatform_set_lib_vars( TESTS kdevplatformtests )
if ( TRUE )
_kdevplatform_set_lib_vars( JSONTESTS kdevplatformjsontests )
endif()

include(${_KDEVPLATFORM_CURRENT_DIR}/KDevPlatformMacros.cmake)

mark_as_advanced(
    KDEVPLATFORM_INTERFACES_LIBRARIES
    KDEVPLATFORM_LANGUAGE_LIBRARIES
    KDEVPLATFORM_OUTPUTVIEW_LIBRARIES
    KDEVPLATFORM_PROJECT_LIBRARIES
    KDEVPLATFORM_SUBLIME_LIBRARIES
    KDEVPLATFORM_SHELL_LIBRARIES
    KDEVPLATFORM_UTIL_LIBRARIES
    KDEVPLATFORM_VCS_LIBRARIES
    KDEVPLATFORM_DEBUGGER_LIBRARIES
    KDEVPLATFORM_DOCUMENTATION_LIBRARIES
    KDEVPLATFORM_TESTS_LIBRARIES
    KDEVPLATFORM_JSONTESTS_LIBRARIES
)
