# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "amalgalite"
  s.version = "1.1.2"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Jeremy Hinegardner"]
  s.date = "2011-04-01"
  s.description = "Amalgalite embeds the SQLite database engine in a ruby extension.  There is no\nneed to install SQLite separately.  \n\nLook in the examples/ directory to see\n\n* general usage\n* blob io\n* schema information\n* custom functions\n* custom aggregates\n* requiring ruby code from a database\n* full text search\n\nAlso Scroll through Amalgalite::Database for a quick example, and a general\noverview of the API.\n\nAmalgalite adds in the following additional non-default SQLite extensions:\n\n* {R*Tree index extension}[http://sqlite.org/rtree.html]\n* {Full Text Search}[http://sqlite.org/fts3.html]"
  s.email = "jeremy@hinegardner.org"
  s.executables = ["amalgalite-pack"]
  s.extensions = ["ext/amalgalite/extconf.rb"]
  s.extra_rdoc_files = ["README.rdoc", "HISTORY.rdoc", "LICENSE", "lib/amalgalite/aggregate.rb", "lib/amalgalite/blob.rb", "lib/amalgalite/boolean.rb", "lib/amalgalite/busy_timeout.rb", "lib/amalgalite/column.rb", "lib/amalgalite/core_ext/kernel/require.rb", "lib/amalgalite/csv_table_importer.rb", "lib/amalgalite/database.rb", "lib/amalgalite/function.rb", "lib/amalgalite/index.rb", "lib/amalgalite/memory_database.rb", "lib/amalgalite/packer.rb", "lib/amalgalite/paths.rb", "lib/amalgalite/profile_tap.rb", "lib/amalgalite/progress_handler.rb", "lib/amalgalite/requires.rb", "lib/amalgalite/schema.rb", "lib/amalgalite/sqlite3/constants.rb", "lib/amalgalite/sqlite3/database/function.rb", "lib/amalgalite/sqlite3/database/status.rb", "lib/amalgalite/sqlite3/status.rb", "lib/amalgalite/sqlite3/version.rb", "lib/amalgalite/sqlite3.rb", "lib/amalgalite/statement.rb", "lib/amalgalite/table.rb", "lib/amalgalite/taps/console.rb", "lib/amalgalite/taps/io.rb", "lib/amalgalite/taps.rb", "lib/amalgalite/trace_tap.rb", "lib/amalgalite/type_map.rb", "lib/amalgalite/type_maps/default_map.rb", "lib/amalgalite/type_maps/storage_map.rb", "lib/amalgalite/type_maps/text_map.rb", "lib/amalgalite/version.rb", "lib/amalgalite/view.rb", "lib/amalgalite.rb"]
  s.files = ["bin/amalgalite-pack", "README.rdoc", "HISTORY.rdoc", "LICENSE", "lib/amalgalite/aggregate.rb", "lib/amalgalite/blob.rb", "lib/amalgalite/boolean.rb", "lib/amalgalite/busy_timeout.rb", "lib/amalgalite/column.rb", "lib/amalgalite/core_ext/kernel/require.rb", "lib/amalgalite/csv_table_importer.rb", "lib/amalgalite/database.rb", "lib/amalgalite/function.rb", "lib/amalgalite/index.rb", "lib/amalgalite/memory_database.rb", "lib/amalgalite/packer.rb", "lib/amalgalite/paths.rb", "lib/amalgalite/profile_tap.rb", "lib/amalgalite/progress_handler.rb", "lib/amalgalite/requires.rb", "lib/amalgalite/schema.rb", "lib/amalgalite/sqlite3/constants.rb", "lib/amalgalite/sqlite3/database/function.rb", "lib/amalgalite/sqlite3/database/status.rb", "lib/amalgalite/sqlite3/status.rb", "lib/amalgalite/sqlite3/version.rb", "lib/amalgalite/sqlite3.rb", "lib/amalgalite/statement.rb", "lib/amalgalite/table.rb", "lib/amalgalite/taps/console.rb", "lib/amalgalite/taps/io.rb", "lib/amalgalite/taps.rb", "lib/amalgalite/trace_tap.rb", "lib/amalgalite/type_map.rb", "lib/amalgalite/type_maps/default_map.rb", "lib/amalgalite/type_maps/storage_map.rb", "lib/amalgalite/type_maps/text_map.rb", "lib/amalgalite/version.rb", "lib/amalgalite/view.rb", "lib/amalgalite.rb", "ext/amalgalite/extconf.rb"]
  s.homepage = "http://copiousfreetime.rubyforge.org/amalgalite/"
  s.rdoc_options = ["--main", "README.rdoc"]
  s.require_paths = ["lib"]
  s.rubyforge_project = "copiousfreetime"
  s.rubygems_version = "1.8.23.2"
  s.summary = "Amalgalite embeds the SQLite database engine in a ruby extension"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<arrayfields>, ["~> 4.7.4"])
      s.add_runtime_dependency(%q<fastercsv>, ["~> 1.5.4"])
      s.add_development_dependency(%q<rake>, ["~> 0.8.7"])
      s.add_development_dependency(%q<configuration>, ["~> 1.2.0"])
      s.add_development_dependency(%q<rspec>, ["~> 2.5.1"])
      s.add_development_dependency(%q<rake-compiler>, ["~> 0.7.6"])
      s.add_development_dependency(%q<zip>, ["~> 2.0.2"])
      s.add_development_dependency(%q<rcov>, ["~> 0.9.9"])
    else
      s.add_dependency(%q<arrayfields>, ["~> 4.7.4"])
      s.add_dependency(%q<fastercsv>, ["~> 1.5.4"])
      s.add_dependency(%q<rake>, ["~> 0.8.7"])
      s.add_dependency(%q<configuration>, ["~> 1.2.0"])
      s.add_dependency(%q<rspec>, ["~> 2.5.1"])
      s.add_dependency(%q<rake-compiler>, ["~> 0.7.6"])
      s.add_dependency(%q<zip>, ["~> 2.0.2"])
      s.add_dependency(%q<rcov>, ["~> 0.9.9"])
    end
  else
    s.add_dependency(%q<arrayfields>, ["~> 4.7.4"])
    s.add_dependency(%q<fastercsv>, ["~> 1.5.4"])
    s.add_dependency(%q<rake>, ["~> 0.8.7"])
    s.add_dependency(%q<configuration>, ["~> 1.2.0"])
    s.add_dependency(%q<rspec>, ["~> 2.5.1"])
    s.add_dependency(%q<rake-compiler>, ["~> 0.7.6"])
    s.add_dependency(%q<zip>, ["~> 2.0.2"])
    s.add_dependency(%q<rcov>, ["~> 0.9.9"])
  end
end
