        LIST

;==========================================================================
;  MPASM PIC18F8680 processor include
; 
;  (c) Copyright 1999-2013 Microchip Technology, All rights reserved
;==========================================================================

        NOLIST

;==========================================================================
;  This header file defines configurations, registers, and other useful
;  bits of information for the PIC18F8680 microcontroller.  These names
;  are taken to match the data sheets as closely as possible.
;
;  Note that the processor must be selected before this file is included.
;  The processor may be selected the following ways:
;
;       1. Command line switch:
;               C:\MPASM MYFILE.ASM /PIC18F8680
;       2. LIST directive in the source file
;               LIST   P=PIC18F8680
;       3. Processor Type entry in the MPASM full-screen interface
;       4. Setting the processor in the MPLAB Project Dialog
;==========================================================================

;==========================================================================
;
;       Verify Processor
;
;==========================================================================
        IFNDEF __18F8680
           MESSG "Processor-header file mismatch.  Verify selected processor."
        ENDIF

;==========================================================================
;       18xxxx Family        EQUates
;==========================================================================
FSR0            EQU 0
FSR1            EQU 1
FSR2            EQU 2

FAST            EQU 1

W               EQU 0
A               EQU 0
ACCESS          EQU 0
BANKED          EQU 1
;==========================================================================

;==========================================================================
;       16Cxxx/17Cxxx Substitutions
;==========================================================================
  #define DDRA  TRISA      ; PIC17Cxxx SFR substitution
  #define DDRB  TRISB      ; PIC17Cxxx SFR substitution
  #define DDRC  TRISC      ; PIC17Cxxx SFR substitution
  #define DDRD  TRISD      ; PIC17Cxxx SFR substitution
  #define DDRE  TRISE      ; PIC17Cxxx SFR substitution

;==========================================================================
;
;       Register Definitions
;
;==========================================================================

;----- Register Files -----------------------------------------------------
RXF6SIDH         EQU  H'0D60'
RXF6SIDL         EQU  H'0D61'
RXF6EIDH         EQU  H'0D62'
RXF6EIDL         EQU  H'0D63'
RXF7SIDH         EQU  H'0D64'
RXF7SIDL         EQU  H'0D65'
RXF7EIDH         EQU  H'0D66'
RXF7EIDL         EQU  H'0D67'
RXF8SIDH         EQU  H'0D68'
RXF8SIDL         EQU  H'0D69'
RXF8EIDH         EQU  H'0D6A'
RXF8EIDL         EQU  H'0D6B'
RXF9SIDH         EQU  H'0D70'
RXF9SIDL         EQU  H'0D71'
RXF9EIDH         EQU  H'0D72'
RXF9EIDL         EQU  H'0D73'
RXF10SIDH        EQU  H'0D74'
RXF10SIDL        EQU  H'0D75'
RXF10EIDH        EQU  H'0D76'
RXF10EIDL        EQU  H'0D77'
RXF11SIDH        EQU  H'0D78'
RXF11SIDL        EQU  H'0D79'
RXF11EIDH        EQU  H'0D7A'
RXF11EIDL        EQU  H'0D7B'
RXF12SIDH        EQU  H'0D80'
RXF12SIDL        EQU  H'0D81'
RXF12EIDH        EQU  H'0D82'
RXF12EIDL        EQU  H'0D83'
RXF13SIDH        EQU  H'0D84'
RXF13SIDL        EQU  H'0D85'
RXF13EIDH        EQU  H'0D86'
RXF13EIDL        EQU  H'0D87'
RXF14SIDH        EQU  H'0D88'
RXF14SIDL        EQU  H'0D89'
RXF14EIDH        EQU  H'0D8A'
RXF14EIDL        EQU  H'0D8B'
RXF15SIDH        EQU  H'0D90'
RXF15SIDL        EQU  H'0D91'
RXF15EIDH        EQU  H'0D92'
RXF15EIDL        EQU  H'0D93'
RXFCON0          EQU  H'0DD4'
RXFCON1          EQU  H'0DD5'
SDFLC            EQU  H'0DD8'
RXFBCON0         EQU  H'0DE0'
RXFBCON1         EQU  H'0DE1'
RXFBCON2         EQU  H'0DE2'
RXFBCON3         EQU  H'0DE3'
RXFBCON4         EQU  H'0DE4'
RXFBCON5         EQU  H'0DE5'
RXFBCON6         EQU  H'0DE6'
RXFBCON7         EQU  H'0DE7'
MSEL0            EQU  H'0DF0'
MSEL1            EQU  H'0DF1'
MSEL2            EQU  H'0DF2'
MSEL3            EQU  H'0DF3'
BSEL0            EQU  H'0DF8'
BIE0             EQU  H'0DFA'
TXBIE            EQU  H'0DFC'
B0CON            EQU  H'0E20'
B0SIDH           EQU  H'0E21'
B0SIDL           EQU  H'0E22'
B0EIDH           EQU  H'0E23'
B0EIDL           EQU  H'0E24'
B0DLC            EQU  H'0E25'
B0D0             EQU  H'0E26'
B0D1             EQU  H'0E27'
B0D2             EQU  H'0E28'
B0D3             EQU  H'0E29'
B0D4             EQU  H'0E2A'
B0D5             EQU  H'0E2B'
B0D6             EQU  H'0E2C'
B0D7             EQU  H'0E2D'
CANSTAT_RO9      EQU  H'0E2E'
CANCON_RO9       EQU  H'0E2F'
B1CON            EQU  H'0E30'
B1SIDH           EQU  H'0E31'
B1SIDL           EQU  H'0E32'
B1EIDH           EQU  H'0E33'
B1EIDL           EQU  H'0E34'
B1DLC            EQU  H'0E35'
B1D0             EQU  H'0E36'
B1D1             EQU  H'0E37'
B1D2             EQU  H'0E38'
B1D3             EQU  H'0E39'
B1D4             EQU  H'0E3A'
B1D5             EQU  H'0E3B'
B1D6             EQU  H'0E3C'
B1D7             EQU  H'0E3D'
CANSTAT_RO8      EQU  H'0E3E'
CANCON_RO8       EQU  H'0E3F'
B2CON            EQU  H'0E40'
B2SIDH           EQU  H'0E41'
B2SIDL           EQU  H'0E42'
B2EIDH           EQU  H'0E43'
B2EIDL           EQU  H'0E44'
B2DLC            EQU  H'0E45'
B2D0             EQU  H'0E46'
B2D1             EQU  H'0E47'
B2D2             EQU  H'0E48'
B2D3             EQU  H'0E49'
B2D4             EQU  H'0E4A'
B2D5             EQU  H'0E4B'
B2D6             EQU  H'0E4C'
B2D7             EQU  H'0E4D'
CANSTAT_RO7      EQU  H'0E4E'
CANCON_RO7       EQU  H'0E4F'
B3CON            EQU  H'0E50'
B3SIDH           EQU  H'0E51'
B3SIDL           EQU  H'0E52'
B3EIDH           EQU  H'0E53'
B3EIDL           EQU  H'0E54'
B3DLC            EQU  H'0E55'
B3D0             EQU  H'0E56'
B3D1             EQU  H'0E57'
B3D2             EQU  H'0E58'
B3D3             EQU  H'0E59'
B3D4             EQU  H'0E5A'
B3D5             EQU  H'0E5B'
B3D6             EQU  H'0E5C'
B3D7             EQU  H'0E5D'
CANSTAT_RO6      EQU  H'0E5E'
CANCON_RO6       EQU  H'0E5F'
B4CON            EQU  H'0E60'
B4SIDH           EQU  H'0E61'
B4SIDL           EQU  H'0E62'
B4EIDH           EQU  H'0E63'
B4EIDL           EQU  H'0E64'
B4DLC            EQU  H'0E65'
B4D0             EQU  H'0E66'
B4D1             EQU  H'0E67'
B4D2             EQU  H'0E68'
B4D3             EQU  H'0E69'
B4D4             EQU  H'0E6A'
B4D5             EQU  H'0E6B'
B4D6             EQU  H'0E6C'
B4D7             EQU  H'0E6D'
CANSTAT_RO5      EQU  H'0E6E'
CANCON_RO5       EQU  H'0E6F'
B5CON            EQU  H'0E70'
B5SIDH           EQU  H'0E71'
B5SIDL           EQU  H'0E72'
B5EIDH           EQU  H'0E73'
B5EIDL           EQU  H'0E74'
B5DLC            EQU  H'0E75'
B5D0             EQU  H'0E76'
B5D1             EQU  H'0E77'
B5D2             EQU  H'0E78'
B5D3             EQU  H'0E79'
B5D4             EQU  H'0E7A'
B5D5             EQU  H'0E7B'
B5D6             EQU  H'0E7C'
B5D7             EQU  H'0E7D'
CANSTAT_RO4      EQU  H'0E7E'
CANCON_RO4       EQU  H'0E7F'
RXF0SIDH         EQU  H'0F00'
RXF0SIDL         EQU  H'0F01'
RXF0EIDH         EQU  H'0F02'
RXF0EIDL         EQU  H'0F03'
RXF1SIDH         EQU  H'0F04'
RXF1SIDL         EQU  H'0F05'
RXF1EIDH         EQU  H'0F06'
RXF1EIDL         EQU  H'0F07'
RXF2SIDH         EQU  H'0F08'
RXF2SIDL         EQU  H'0F09'
RXF2EIDH         EQU  H'0F0A'
RXF2EIDL         EQU  H'0F0B'
RXF3SIDH         EQU  H'0F0C'
RXF3SIDL         EQU  H'0F0D'
RXF3EIDH         EQU  H'0F0E'
RXF3EIDL         EQU  H'0F0F'
RXF4SIDH         EQU  H'0F10'
RXF4SIDL         EQU  H'0F11'
RXF4EIDH         EQU  H'0F12'
RXF4EIDL         EQU  H'0F13'
RXF5SIDH         EQU  H'0F14'
RXF5SIDL         EQU  H'0F15'
RXF5EIDH         EQU  H'0F16'
RXF5EIDL         EQU  H'0F17'
RXM0SIDH         EQU  H'0F18'
RXM0SIDL         EQU  H'0F19'
RXM0EIDH         EQU  H'0F1A'
RXM0EIDL         EQU  H'0F1B'
RXM1SIDH         EQU  H'0F1C'
RXM1SIDL         EQU  H'0F1D'
RXM1EIDH         EQU  H'0F1E'
RXM1EIDL         EQU  H'0F1F'
TXB2CON          EQU  H'0F20'
TXB2SIDH         EQU  H'0F21'
TXB2SIDL         EQU  H'0F22'
TXB2EIDH         EQU  H'0F23'
TXB2EIDL         EQU  H'0F24'
TXB2DLC          EQU  H'0F25'
TXB2D0           EQU  H'0F26'
TXB2D1           EQU  H'0F27'
TXB2D2           EQU  H'0F28'
TXB2D3           EQU  H'0F29'
TXB2D4           EQU  H'0F2A'
TXB2D5           EQU  H'0F2B'
TXB2D6           EQU  H'0F2C'
TXB2D7           EQU  H'0F2D'
CANSTAT_RO3      EQU  H'0F2E'
CANCON_RO3       EQU  H'0F2F'
TXB1CON          EQU  H'0F30'
TXB1SIDH         EQU  H'0F31'
TXB1SIDL         EQU  H'0F32'
TXB1EIDH         EQU  H'0F33'
TXB1EIDL         EQU  H'0F34'
TXB1DLC          EQU  H'0F35'
TXB1D0           EQU  H'0F36'
TXB1D1           EQU  H'0F37'
TXB1D2           EQU  H'0F38'
TXB1D3           EQU  H'0F39'
TXB1D4           EQU  H'0F3A'
TXB1D5           EQU  H'0F3B'
TXB1D6           EQU  H'0F3C'
TXB1D7           EQU  H'0F3D'
CANSTAT_RO2      EQU  H'0F3E'
CANCON_RO2       EQU  H'0F3F'
TXB0CON          EQU  H'0F40'
TXB0SIDH         EQU  H'0F41'
TXB0SIDL         EQU  H'0F42'
TXB0EIDH         EQU  H'0F43'
TXB0EIDL         EQU  H'0F44'
TXB0DLC          EQU  H'0F45'
TXB0D0           EQU  H'0F46'
TXB0D1           EQU  H'0F47'
TXB0D2           EQU  H'0F48'
TXB0D3           EQU  H'0F49'
TXB0D4           EQU  H'0F4A'
TXB0D5           EQU  H'0F4B'
TXB0D6           EQU  H'0F4C'
TXB0D7           EQU  H'0F4D'
CANSTAT_RO1      EQU  H'0F4E'
CANCON_RO1       EQU  H'0F4F'
RXB1CON          EQU  H'0F50'
RXB1SIDH         EQU  H'0F51'
RXB1SIDL         EQU  H'0F52'
RXB1EIDH         EQU  H'0F53'
RXB1EIDL         EQU  H'0F54'
RXB1DLC          EQU  H'0F55'
RXB1D0           EQU  H'0F56'
RXB1D1           EQU  H'0F57'
RXB1D2           EQU  H'0F58'
RXB1D3           EQU  H'0F59'
RXB1D4           EQU  H'0F5A'
RXB1D5           EQU  H'0F5B'
RXB1D6           EQU  H'0F5C'
RXB1D7           EQU  H'0F5D'
CANSTAT_RO0      EQU  H'0F5E'
CANCON_RO0       EQU  H'0F5F'
RXB0CON          EQU  H'0F60'
RXB0SIDH         EQU  H'0F61'
RXB0SIDL         EQU  H'0F62'
RXB0EIDH         EQU  H'0F63'
RXB0EIDL         EQU  H'0F64'
RXB0DLC          EQU  H'0F65'
RXB0D0           EQU  H'0F66'
RXB0D1           EQU  H'0F67'
RXB0D2           EQU  H'0F68'
RXB0D3           EQU  H'0F69'
RXB0D4           EQU  H'0F6A'
RXB0D5           EQU  H'0F6B'
RXB0D6           EQU  H'0F6C'
RXB0D7           EQU  H'0F6D'
CANSTAT          EQU  H'0F6E'
CANCON           EQU  H'0F6F'
BRGCON1          EQU  H'0F70'
BRGCON2          EQU  H'0F71'
BRGCON3          EQU  H'0F72'
CIOCON           EQU  H'0F73'
COMSTAT          EQU  H'0F74'
RXERRCNT         EQU  H'0F75'
TXERRCNT         EQU  H'0F76'
ECANCON          EQU  H'0F77'
ECCP1DEL         EQU  H'0F79'
BAUDCON          EQU  H'0F7E'
SPBRGH           EQU  H'0F7F'
PORTA            EQU  H'0F80'
PORTB            EQU  H'0F81'
PORTC            EQU  H'0F82'
PORTD            EQU  H'0F83'
PORTE            EQU  H'0F84'
PORTF            EQU  H'0F85'
PORTG            EQU  H'0F86'
PORTH            EQU  H'0F87'
PORTJ            EQU  H'0F88'
LATA             EQU  H'0F89'
LATB             EQU  H'0F8A'
LATC             EQU  H'0F8B'
LATD             EQU  H'0F8C'
LATE             EQU  H'0F8D'
LATF             EQU  H'0F8E'
LATG             EQU  H'0F8F'
LATH             EQU  H'0F90'
LATJ             EQU  H'0F91'
DDRA             EQU  H'0F92'
TRISA            EQU  H'0F92'
DDRB             EQU  H'0F93'
TRISB            EQU  H'0F93'
DDRC             EQU  H'0F94'
TRISC            EQU  H'0F94'
DDRD             EQU  H'0F95'
TRISD            EQU  H'0F95'
DDRE             EQU  H'0F96'
TRISE            EQU  H'0F96'
DDRF             EQU  H'0F97'
TRISF            EQU  H'0F97'
DDRG             EQU  H'0F98'
TRISG            EQU  H'0F98'
DDRH             EQU  H'0F99'
TRISH            EQU  H'0F99'
DDRJ             EQU  H'0F9A'
TRISJ            EQU  H'0F9A'
MEMCON           EQU  H'0F9C'
PIE1             EQU  H'0F9D'
PIR1             EQU  H'0F9E'
IPR1             EQU  H'0F9F'
PIE2             EQU  H'0FA0'
PIR2             EQU  H'0FA1'
IPR2             EQU  H'0FA2'
PIE3             EQU  H'0FA3'
PIR3             EQU  H'0FA4'
IPR3             EQU  H'0FA5'
EECON1           EQU  H'0FA6'
EECON2           EQU  H'0FA7'
EEDATA           EQU  H'0FA8'
EEADR            EQU  H'0FA9'
EEADRH           EQU  H'0FAA'
RCSTA            EQU  H'0FAB'
RCSTA1           EQU  H'0FAB'
TXSTA            EQU  H'0FAC'
TXSTA1           EQU  H'0FAC'
TXREG            EQU  H'0FAD'
TXREG1           EQU  H'0FAD'
RCREG            EQU  H'0FAE'
RCREG1           EQU  H'0FAE'
SPBRG            EQU  H'0FAF'
SPBRG1           EQU  H'0FAF'
PSPCON           EQU  H'0FB0'
T3CON            EQU  H'0FB1'
TMR3             EQU  H'0FB2'
TMR3L            EQU  H'0FB2'
TMR3H            EQU  H'0FB3'
CMCON            EQU  H'0FB4'
CVRCON           EQU  H'0FB5'
ECCP1AS          EQU  H'0FB6'
CCP2CON          EQU  H'0FBA'
CCPR2            EQU  H'0FBB'
CCPR2L           EQU  H'0FBB'
CCPR2H           EQU  H'0FBC'
CCP1CON          EQU  H'0FBD'
CCPR1            EQU  H'0FBE'
CCPR1L           EQU  H'0FBE'
CCPR1H           EQU  H'0FBF'
ADCON2           EQU  H'0FC0'
ADCON1           EQU  H'0FC1'
ADCON0           EQU  H'0FC2'
ADRES            EQU  H'0FC3'
ADRESL           EQU  H'0FC3'
ADRESH           EQU  H'0FC4'
SSPCON2          EQU  H'0FC5'
SSPCON1          EQU  H'0FC6'
SSPSTAT          EQU  H'0FC7'
SSPADD           EQU  H'0FC8'
SSPBUF           EQU  H'0FC9'
T2CON            EQU  H'0FCA'
PR2              EQU  H'0FCB'
TMR2             EQU  H'0FCC'
T1CON            EQU  H'0FCD'
TMR1             EQU  H'0FCE'
TMR1L            EQU  H'0FCE'
TMR1H            EQU  H'0FCF'
RCON             EQU  H'0FD0'
WDTCON           EQU  H'0FD1'
LVDCON           EQU  H'0FD2'
OSCCON           EQU  H'0FD3'
T0CON            EQU  H'0FD5'
TMR0             EQU  H'0FD6'
TMR0L            EQU  H'0FD6'
TMR0H            EQU  H'0FD7'
STATUS           EQU  H'0FD8'
FSR2L            EQU  H'0FD9'
FSR2H            EQU  H'0FDA'
PLUSW2           EQU  H'0FDB'
PREINC2          EQU  H'0FDC'
POSTDEC2         EQU  H'0FDD'
POSTINC2         EQU  H'0FDE'
INDF2            EQU  H'0FDF'
BSR              EQU  H'0FE0'
FSR1L            EQU  H'0FE1'
FSR1H            EQU  H'0FE2'
PLUSW1           EQU  H'0FE3'
PREINC1          EQU  H'0FE4'
POSTDEC1         EQU  H'0FE5'
POSTINC1         EQU  H'0FE6'
INDF1            EQU  H'0FE7'
WREG             EQU  H'0FE8'
FSR0L            EQU  H'0FE9'
FSR0H            EQU  H'0FEA'
PLUSW0           EQU  H'0FEB'
PREINC0          EQU  H'0FEC'
POSTDEC0         EQU  H'0FED'
POSTINC0         EQU  H'0FEE'
INDF0            EQU  H'0FEF'
INTCON3          EQU  H'0FF0'
INTCON2          EQU  H'0FF1'
INTCON           EQU  H'0FF2'
PROD             EQU  H'0FF3'
PRODL            EQU  H'0FF3'
PRODH            EQU  H'0FF4'
TABLAT           EQU  H'0FF5'
TBLPTR           EQU  H'0FF6'
TBLPTRL          EQU  H'0FF6'
TBLPTRH          EQU  H'0FF7'
TBLPTRU          EQU  H'0FF8'
PC               EQU  H'0FF9'
PCL              EQU  H'0FF9'
PCLATH           EQU  H'0FFA'
PCLATU           EQU  H'0FFB'
STKPTR           EQU  H'0FFC'
TOS              EQU  H'0FFD'
TOSL             EQU  H'0FFD'
TOSH             EQU  H'0FFE'
TOSU             EQU  H'0FFF'

;----- RXF6SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF6SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF6EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF6EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF7SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF7SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF7EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF7EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF8SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF8SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF8EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF8EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF9SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF9SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF9EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF9EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF10SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF10SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF10EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF10EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF11SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF11SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF11EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF11EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF12SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF12SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF12EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF12EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF13SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF13SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF13EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF13EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF14SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF14SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF14EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF14EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF15SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF15SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF15EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF15EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXFCON0 Bits -----------------------------------------------------
RXF0EN           EQU  H'0000'
RXF1EN           EQU  H'0001'
RXF2EN           EQU  H'0002'
RXF3EN           EQU  H'0003'
RXF4EN           EQU  H'0004'
RXF5EN           EQU  H'0005'
RXF6EN           EQU  H'0006'
RXF7EN           EQU  H'0007'


;----- RXFCON1 Bits -----------------------------------------------------
RXF8EN           EQU  H'0000'
RXF9EN           EQU  H'0001'
RXF10EN          EQU  H'0002'
RXF11EN          EQU  H'0003'
RXF12EN          EQU  H'0004'
RXF13EN          EQU  H'0005'
RXF14EN          EQU  H'0006'
RXF15EN          EQU  H'0007'


;----- SDFLC Bits -----------------------------------------------------
DFLC0            EQU  H'0000'
DFLC1            EQU  H'0001'
DFLC2            EQU  H'0002'
DFLC3            EQU  H'0003'
DFLC4            EQU  H'0004'


;----- RXFBCON0 Bits -----------------------------------------------------
F0BP_0           EQU  H'0000'
F0BP_1           EQU  H'0001'
F0BP_2           EQU  H'0002'
F0BP_3           EQU  H'0003'
F1BP_0           EQU  H'0004'
F1BP_1           EQU  H'0005'
F1BP_2           EQU  H'0006'
F1BP_3           EQU  H'0007'


;----- RXFBCON1 Bits -----------------------------------------------------
F2BP_0           EQU  H'0000'
F2BP_1           EQU  H'0001'
F2BP_2           EQU  H'0002'
F2BP_3           EQU  H'0003'
F3BP_0           EQU  H'0004'
F3BP_1           EQU  H'0005'
F3BP_2           EQU  H'0006'
F3BP_3           EQU  H'0007'


;----- RXFBCON2 Bits -----------------------------------------------------
F4BP_0           EQU  H'0000'
F4BP_1           EQU  H'0001'
F4BP_2           EQU  H'0002'
F4BP_3           EQU  H'0003'
F5BP_0           EQU  H'0004'
F5BP_1           EQU  H'0005'
F5BP_2           EQU  H'0006'
F5BP_3           EQU  H'0007'


;----- RXFBCON3 Bits -----------------------------------------------------
F6BP_0           EQU  H'0000'
F6BP_1           EQU  H'0001'
F6BP_2           EQU  H'0002'
F6BP_3           EQU  H'0003'
F7BP_0           EQU  H'0004'
F7BP_1           EQU  H'0005'
F7BP_2           EQU  H'0006'
F7BP_3           EQU  H'0007'


;----- RXFBCON4 Bits -----------------------------------------------------
F8BP_0           EQU  H'0000'
F8BP_1           EQU  H'0001'
F8BP_2           EQU  H'0002'
F8BP_3           EQU  H'0003'
F9BP_0           EQU  H'0004'
F9BP_1           EQU  H'0005'
F9BP_2           EQU  H'0006'
F9BP_3           EQU  H'0007'


;----- RXFBCON5 Bits -----------------------------------------------------
F10BP_0          EQU  H'0000'
F10BP_1          EQU  H'0001'
F10BP_2          EQU  H'0002'
F10BP_3          EQU  H'0003'
F11BP_0          EQU  H'0004'
F11BP_1          EQU  H'0005'
F11BP_2          EQU  H'0006'
F11BP_3          EQU  H'0007'


;----- RXFBCON6 Bits -----------------------------------------------------
F12BP_0          EQU  H'0000'
F12BP_1          EQU  H'0001'
F12BP_2          EQU  H'0002'
F12BP_3          EQU  H'0003'
F13BP_0          EQU  H'0004'
F13BP_1          EQU  H'0005'
F13BP_2          EQU  H'0006'
F13BP_3          EQU  H'0007'


;----- RXFBCON7 Bits -----------------------------------------------------
F14BP_0          EQU  H'0000'
F14BP_1          EQU  H'0001'
F14BP_2          EQU  H'0002'
F14BP_3          EQU  H'0003'
F15BP_0          EQU  H'0004'
F15BP_1          EQU  H'0005'
F15BP_2          EQU  H'0006'
F15BP_3          EQU  H'0007'


;----- MSEL0 Bits -----------------------------------------------------
FIL0_0           EQU  H'0000'
FIL0_1           EQU  H'0001'
FIL1_0           EQU  H'0002'
FIL1_1           EQU  H'0003'
FIL2_0           EQU  H'0004'
FIL2_1           EQU  H'0005'
FIL3_0           EQU  H'0006'
FIL3_1           EQU  H'0007'


;----- MSEL1 Bits -----------------------------------------------------
FIL4_0           EQU  H'0000'
FIL4_1           EQU  H'0001'
FIL5_0           EQU  H'0002'
FIL5_1           EQU  H'0003'
FIL6_0           EQU  H'0004'
FIL6_1           EQU  H'0005'
FIL7_0           EQU  H'0006'
FIL7_1           EQU  H'0007'


;----- MSEL2 Bits -----------------------------------------------------
FIL8_0           EQU  H'0000'
FIL8_1           EQU  H'0001'
FIL9_0           EQU  H'0002'
FIL9_1           EQU  H'0003'
FIL10_0          EQU  H'0004'
FIL10_1          EQU  H'0005'
FIL11_0          EQU  H'0006'
FIL11_1          EQU  H'0007'


;----- MSEL3 Bits -----------------------------------------------------
FIL12_0          EQU  H'0000'
FIL12_1          EQU  H'0001'
FIL13_0          EQU  H'0002'
FIL13_1          EQU  H'0003'
FIL14_0          EQU  H'0004'
FIL14_1          EQU  H'0005'
FIL15_0          EQU  H'0006'
FIL15_1          EQU  H'0007'


;----- BSEL0 Bits -----------------------------------------------------
B0TXEN           EQU  H'0002'
B1TXEN           EQU  H'0003'
B2TXEN           EQU  H'0004'
B3TXEN           EQU  H'0005'
B4TXEN           EQU  H'0006'
B5TXEN           EQU  H'0007'


;----- BIE0 Bits -----------------------------------------------------
RXB0IE           EQU  H'0000'
RXB1IE           EQU  H'0001'
B0IE             EQU  H'0002'
B1IE             EQU  H'0003'
B2IE             EQU  H'0004'
B3IE             EQU  H'0005'
B4IE             EQU  H'0006'
B5IE             EQU  H'0007'


;----- TXBIE Bits -----------------------------------------------------
TXB0IE           EQU  H'0002'
TXB1IE           EQU  H'0003'
TXB2IE           EQU  H'0004'


;----- B0CON Bits -----------------------------------------------------
FILHIT0_TXPRI0   EQU  H'0000'
FILHIT1_TXPRI1   EQU  H'0001'
FILHIT2_RTREN    EQU  H'0002'
FILHIT3_TXREQ    EQU  H'0003'
FILHIT4_TXERR    EQU  H'0004'
RXRTRRO_TXLARB   EQU  H'0005'
RXM1_TXABT       EQU  H'0006'
RXFUL_TXBIF      EQU  H'0007'

FILHIT0          EQU  H'0000'
FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
FILHIT3          EQU  H'0003'
FILHIT4          EQU  H'0004'
RTRRO            EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
RTREN            EQU  H'0002'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'

RTRRO_TXLARB     EQU  H'0005'


;----- B0SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- B0SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- B0EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- B0EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- B0DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_B0DLC        EQU  H'0004'
RB1_B0DLC        EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'
TXRTR            EQU  H'0006'


;----- B0D0 Bits -----------------------------------------------------
B0D00            EQU  H'0000'
B0D01            EQU  H'0001'
B0D02            EQU  H'0002'
B0D03            EQU  H'0003'
B0D04            EQU  H'0004'
B0D05            EQU  H'0005'
B0D06            EQU  H'0006'
B0D07            EQU  H'0007'


;----- B0D1 Bits -----------------------------------------------------
B0D10            EQU  H'0000'
B0D11            EQU  H'0001'
B0D12            EQU  H'0002'
B0D13            EQU  H'0003'
B0D14            EQU  H'0004'
B0D15            EQU  H'0005'
B0D16            EQU  H'0006'
B0D17            EQU  H'0007'


;----- B0D2 Bits -----------------------------------------------------
B0D20            EQU  H'0000'
B0D21            EQU  H'0001'
B0D22            EQU  H'0002'
B0D23            EQU  H'0003'
B0D24            EQU  H'0004'
B0D25            EQU  H'0005'
B0D26            EQU  H'0006'
B0D27            EQU  H'0007'


;----- B0D3 Bits -----------------------------------------------------
B0D30            EQU  H'0000'
B0D31            EQU  H'0001'
B0D32            EQU  H'0002'
B0D33            EQU  H'0003'
B0D34            EQU  H'0004'
B0D35            EQU  H'0005'
B0D36            EQU  H'0006'
B0D37            EQU  H'0007'


;----- B0D4 Bits -----------------------------------------------------
B0D40            EQU  H'0000'
B0D41            EQU  H'0001'
B0D42            EQU  H'0002'
B0D43            EQU  H'0003'
B0D44            EQU  H'0004'
B0D45            EQU  H'0005'
B0D46            EQU  H'0006'
B0D47            EQU  H'0007'


;----- B0D5 Bits -----------------------------------------------------
B0D50            EQU  H'0000'
B0D51            EQU  H'0001'
B0D52            EQU  H'0002'
B0D53            EQU  H'0003'
B0D54            EQU  H'0004'
B0D55            EQU  H'0005'
B0D56            EQU  H'0006'
B0D57            EQU  H'0007'


;----- B0D6 Bits -----------------------------------------------------
B0D60            EQU  H'0000'
B0D61            EQU  H'0001'
B0D62            EQU  H'0002'
B0D63            EQU  H'0003'
B0D64            EQU  H'0004'
B0D65            EQU  H'0005'
B0D66            EQU  H'0006'
B0D67            EQU  H'0007'


;----- B0D7 Bits -----------------------------------------------------
B0D70            EQU  H'0000'
B0D71            EQU  H'0001'
B0D72            EQU  H'0002'
B0D73            EQU  H'0003'
B0D74            EQU  H'0004'
B0D75            EQU  H'0005'
B0D76            EQU  H'0006'
B0D77            EQU  H'0007'


;----- CANSTAT_RO9 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO9 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- B1CON Bits -----------------------------------------------------
FILHIT0_TXPRI0   EQU  H'0000'
FILHIT1_TXPRI1   EQU  H'0001'
FILHIT2_RTREN    EQU  H'0002'
FILHIT3_TXREQ    EQU  H'0003'
FILHIT4_TXERR    EQU  H'0004'
RTRRO_TXLARB     EQU  H'0005'
RXM1_TXABT       EQU  H'0006'
RXFUL_TXBIF      EQU  H'0007'

FILHIT0          EQU  H'0000'
FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
FILHIT3          EQU  H'0003'
FILHIT4          EQU  H'0004'
RTRRO            EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
RTREN            EQU  H'0002'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'


;----- B1SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- B1SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- B1EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- B1EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- B1DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_B1DLC        EQU  H'0004'
RB1_B1DLC        EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'
TXRTR            EQU  H'0006'


;----- B1D0 Bits -----------------------------------------------------
B1D00            EQU  H'0000'
B1D01            EQU  H'0001'
B1D02            EQU  H'0002'
B1D03            EQU  H'0003'
B1D04            EQU  H'0004'
B1D05            EQU  H'0005'
B1D06            EQU  H'0006'
B1D07            EQU  H'0007'


;----- B1D1 Bits -----------------------------------------------------
B1D10            EQU  H'0000'
B1D11            EQU  H'0001'
B1D12            EQU  H'0002'
B1D13            EQU  H'0003'
B1D14            EQU  H'0004'
B1D15            EQU  H'0005'
B1D16            EQU  H'0006'
B1D17            EQU  H'0007'


;----- B1D2 Bits -----------------------------------------------------
B1D20            EQU  H'0000'
B1D21            EQU  H'0001'
B1D22            EQU  H'0002'
B1D23            EQU  H'0003'
B1D24            EQU  H'0004'
B1D25            EQU  H'0005'
B1D26            EQU  H'0006'
B1D27            EQU  H'0007'


;----- B1D3 Bits -----------------------------------------------------
B1D30            EQU  H'0000'
B1D31            EQU  H'0001'
B1D32            EQU  H'0002'
B1D33            EQU  H'0003'
B1D34            EQU  H'0004'
B1D35            EQU  H'0005'
B1D36            EQU  H'0006'
B1D37            EQU  H'0007'


;----- B1D4 Bits -----------------------------------------------------
B1D40            EQU  H'0000'
B1D41            EQU  H'0001'
B1D42            EQU  H'0002'
B1D43            EQU  H'0003'
B1D44            EQU  H'0004'
B1D45            EQU  H'0005'
B1D46            EQU  H'0006'
B1D47            EQU  H'0007'


;----- B1D5 Bits -----------------------------------------------------
B1D50            EQU  H'0000'
B1D51            EQU  H'0001'
B1D52            EQU  H'0002'
B1D53            EQU  H'0003'
B1D54            EQU  H'0004'
B1D55            EQU  H'0005'
B1D56            EQU  H'0006'
B1D57            EQU  H'0007'


;----- B1D6 Bits -----------------------------------------------------
B1D60            EQU  H'0000'
B1D61            EQU  H'0001'
B1D62            EQU  H'0002'
B1D63            EQU  H'0003'
B1D64            EQU  H'0004'
B1D65            EQU  H'0005'
B1D66            EQU  H'0006'
B1D67            EQU  H'0007'


;----- B1D7 Bits -----------------------------------------------------
B1D70            EQU  H'0000'
B1D71            EQU  H'0001'
B1D72            EQU  H'0002'
B1D73            EQU  H'0003'
B1D74            EQU  H'0004'
B1D75            EQU  H'0005'
B1D76            EQU  H'0006'
B1D77            EQU  H'0007'


;----- CANSTAT_RO8 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO8 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- B2CON Bits -----------------------------------------------------
FILHIT0_TXPRI0   EQU  H'0000'
FILHIT1_TXPRI1   EQU  H'0001'
FILHIT2_RTREN    EQU  H'0002'
FILHIT3_TXREQ    EQU  H'0003'
FILHIT4_TXERR    EQU  H'0004'
RTRRO_TXLARB     EQU  H'0005'
RXM1_TXABT       EQU  H'0006'
RXFUL_TXBIF      EQU  H'0007'

FILHIT0          EQU  H'0000'
FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
FILHIT3          EQU  H'0003'
FILHIT4          EQU  H'0004'
RTRRO            EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
RTREN            EQU  H'0002'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'


;----- B2SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- B2SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- B2EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- B2EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- B2DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_B2DLC        EQU  H'0004'
RB1_B2DLC        EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'
TXRTR            EQU  H'0006'


;----- B2D0 Bits -----------------------------------------------------
B2D00            EQU  H'0000'
B2D01            EQU  H'0001'
B2D02            EQU  H'0002'
B2D03            EQU  H'0003'
B2D04            EQU  H'0004'
B2D05            EQU  H'0005'
B2D06            EQU  H'0006'
B2D07            EQU  H'0007'


;----- B2D1 Bits -----------------------------------------------------
B2D10            EQU  H'0000'
B2D11            EQU  H'0001'
B2D12            EQU  H'0002'
B2D13            EQU  H'0003'
B2D14            EQU  H'0004'
B2D15            EQU  H'0005'
B2D16            EQU  H'0006'
B2D17            EQU  H'0007'


;----- B2D2 Bits -----------------------------------------------------
B2D20            EQU  H'0000'
B2D21            EQU  H'0001'
B2D22            EQU  H'0002'
B2D23            EQU  H'0003'
B2D24            EQU  H'0004'
B2D25            EQU  H'0005'
B2D26            EQU  H'0006'
B2D27            EQU  H'0007'


;----- B2D3 Bits -----------------------------------------------------
B2D30            EQU  H'0000'
B2D31            EQU  H'0001'
B2D32            EQU  H'0002'
B2D33            EQU  H'0003'
B2D34            EQU  H'0004'
B2D35            EQU  H'0005'
B2D36            EQU  H'0006'
B2D37            EQU  H'0007'


;----- B2D4 Bits -----------------------------------------------------
B2D40            EQU  H'0000'
B2D41            EQU  H'0001'
B2D42            EQU  H'0002'
B2D43            EQU  H'0003'
B2D44            EQU  H'0004'
B2D45            EQU  H'0005'
B2D46            EQU  H'0006'
B2D47            EQU  H'0007'


;----- B2D5 Bits -----------------------------------------------------
B2D50            EQU  H'0000'
B2D51            EQU  H'0001'
B2D52            EQU  H'0002'
B2D53            EQU  H'0003'
B2D54            EQU  H'0004'
B2D55            EQU  H'0005'
B2D56            EQU  H'0006'
B2D57            EQU  H'0007'


;----- B2D6 Bits -----------------------------------------------------
B2D60            EQU  H'0000'
B2D61            EQU  H'0001'
B2D62            EQU  H'0002'
B2D63            EQU  H'0003'
B2D64            EQU  H'0004'
B2D65            EQU  H'0005'
B2D66            EQU  H'0006'
B2D67            EQU  H'0007'


;----- B2D7 Bits -----------------------------------------------------
B2D70            EQU  H'0000'
B2D71            EQU  H'0001'
B2D72            EQU  H'0002'
B2D73            EQU  H'0003'
B2D74            EQU  H'0004'
B2D75            EQU  H'0005'
B2D76            EQU  H'0006'
B2D77            EQU  H'0007'


;----- CANSTAT_RO7 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO7 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- B3CON Bits -----------------------------------------------------
FILHIT0_TXPRI0   EQU  H'0000'
FILHIT1_TXPRI1   EQU  H'0001'
FILHIT2_RTREN    EQU  H'0002'
FILHIT3_TXREQ    EQU  H'0003'
FILHIT4_TXERR    EQU  H'0004'
RTRRO_TXLARB     EQU  H'0005'
RXM1_TXABT       EQU  H'0006'
RXFUL_TXBIF      EQU  H'0007'

FILHIT0          EQU  H'0000'
FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
FILHIT3          EQU  H'0003'
FILHIT4          EQU  H'0004'
RTRRO            EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
RTREN            EQU  H'0002'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'


;----- B3SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- B3SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- B3EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- B3EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- B3DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_B3DLC        EQU  H'0004'
RB1_B3DLC        EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'
TXRTR            EQU  H'0006'


;----- B3D0 Bits -----------------------------------------------------
B3D00            EQU  H'0000'
B3D01            EQU  H'0001'
B3D02            EQU  H'0002'
B3D03            EQU  H'0003'
B3D04            EQU  H'0004'
B3D05            EQU  H'0005'
B3D06            EQU  H'0006'
B3D07            EQU  H'0007'


;----- B3D1 Bits -----------------------------------------------------
B3D10            EQU  H'0000'
B3D11            EQU  H'0001'
B3D12            EQU  H'0002'
B3D13            EQU  H'0003'
B3D14            EQU  H'0004'
B3D15            EQU  H'0005'
B3D16            EQU  H'0006'
B3D17            EQU  H'0007'


;----- B3D2 Bits -----------------------------------------------------
B3D20            EQU  H'0000'
B3D21            EQU  H'0001'
B3D22            EQU  H'0002'
B3D23            EQU  H'0003'
B3D24            EQU  H'0004'
B3D25            EQU  H'0005'
B3D26            EQU  H'0006'
B3D27            EQU  H'0007'


;----- B3D3 Bits -----------------------------------------------------
B3D30            EQU  H'0000'
B3D31            EQU  H'0001'
B3D32            EQU  H'0002'
B3D33            EQU  H'0003'
B3D34            EQU  H'0004'
B3D35            EQU  H'0005'
B3D36            EQU  H'0006'
B3D37            EQU  H'0007'


;----- B3D4 Bits -----------------------------------------------------
B3D40            EQU  H'0000'
B3D41            EQU  H'0001'
B3D42            EQU  H'0002'
B3D43            EQU  H'0003'
B3D44            EQU  H'0004'
B3D45            EQU  H'0005'
B3D46            EQU  H'0006'
B3D47            EQU  H'0007'


;----- B3D5 Bits -----------------------------------------------------
B3D50            EQU  H'0000'
B3D51            EQU  H'0001'
B3D52            EQU  H'0002'
B3D53            EQU  H'0003'
B3D54            EQU  H'0004'
B3D55            EQU  H'0005'
B3D56            EQU  H'0006'
B3D57            EQU  H'0007'


;----- B3D6 Bits -----------------------------------------------------
B3D60            EQU  H'0000'
B3D61            EQU  H'0001'
B3D62            EQU  H'0002'
B3D63            EQU  H'0003'
B3D64            EQU  H'0004'
B3D65            EQU  H'0005'
B3D66            EQU  H'0006'
B3D67            EQU  H'0007'


;----- B3D7 Bits -----------------------------------------------------
B3D70            EQU  H'0000'
B3D71            EQU  H'0001'
B3D72            EQU  H'0002'
B3D73            EQU  H'0003'
B3D74            EQU  H'0004'
B3D75            EQU  H'0005'
B3D76            EQU  H'0006'
B3D77            EQU  H'0007'


;----- CANSTAT_RO6 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO6 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- B4CON Bits -----------------------------------------------------
FILHIT0_TXPRI0   EQU  H'0000'
FILHIT1_TXPRI1   EQU  H'0001'
FILHIT2_RTREN    EQU  H'0002'
FILHIT3_TXREQ    EQU  H'0003'
FILHIT4_TXERR    EQU  H'0004'
RTRRO_TXLARB     EQU  H'0005'
RXM1_TXABT       EQU  H'0006'
RXFUL_TXBIF      EQU  H'0007'

FILHIT0          EQU  H'0000'
FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
FILHIT3          EQU  H'0003'
FILHIT4          EQU  H'0004'
RTRRO            EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
RTREN            EQU  H'0002'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'


;----- B4SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- B4SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- B4EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- B4EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- B4DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_B4DLC        EQU  H'0004'
RB1_B4DLC        EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'
TXRTR            EQU  H'0006'


;----- B4D0 Bits -----------------------------------------------------
B4D00            EQU  H'0000'
B4D01            EQU  H'0001'
B4D02            EQU  H'0002'
B4D03            EQU  H'0003'
B4D04            EQU  H'0004'
B4D05            EQU  H'0005'
B4D06            EQU  H'0006'
B4D07            EQU  H'0007'


;----- B4D1 Bits -----------------------------------------------------
B4D10            EQU  H'0000'
B4D11            EQU  H'0001'
B4D12            EQU  H'0002'
B4D13            EQU  H'0003'
B4D14            EQU  H'0004'
B4D15            EQU  H'0005'
B4D16            EQU  H'0006'
B4D17            EQU  H'0007'


;----- B4D2 Bits -----------------------------------------------------
B4D20            EQU  H'0000'
B4D21            EQU  H'0001'
B4D22            EQU  H'0002'
B4D23            EQU  H'0003'
B4D24            EQU  H'0004'
B4D25            EQU  H'0005'
B4D26            EQU  H'0006'
B4D27            EQU  H'0007'


;----- B4D3 Bits -----------------------------------------------------
B4D30            EQU  H'0000'
B4D31            EQU  H'0001'
B4D32            EQU  H'0002'
B4D33            EQU  H'0003'
B4D34            EQU  H'0004'
B4D35            EQU  H'0005'
B4D36            EQU  H'0006'
B4D37            EQU  H'0007'


;----- B4D4 Bits -----------------------------------------------------
B4D40            EQU  H'0000'
B4D41            EQU  H'0001'
B4D42            EQU  H'0002'
B4D43            EQU  H'0003'
B4D44            EQU  H'0004'
B4D45            EQU  H'0005'
B4D46            EQU  H'0006'
B4D47            EQU  H'0007'


;----- B4D5 Bits -----------------------------------------------------
B4D50            EQU  H'0000'
B4D51            EQU  H'0001'
B4D52            EQU  H'0002'
B4D53            EQU  H'0003'
B4D54            EQU  H'0004'
B4D55            EQU  H'0005'
B4D56            EQU  H'0006'
B4D57            EQU  H'0007'


;----- B4D6 Bits -----------------------------------------------------
B4D60            EQU  H'0000'
B4D61            EQU  H'0001'
B4D62            EQU  H'0002'
B4D63            EQU  H'0003'
B4D64            EQU  H'0004'
B4D65            EQU  H'0005'
B4D66            EQU  H'0006'
B4D67            EQU  H'0007'


;----- B4D7 Bits -----------------------------------------------------
B4D70            EQU  H'0000'
B4D71            EQU  H'0001'
B4D72            EQU  H'0002'
B4D73            EQU  H'0003'
B4D74            EQU  H'0004'
B4D75            EQU  H'0005'
B4D76            EQU  H'0006'
B4D77            EQU  H'0007'

B46D77           EQU  H'0007'


;----- CANSTAT_RO5 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO5 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- B5CON Bits -----------------------------------------------------
FILHIT0_TXPRI0   EQU  H'0000'
FILHIT1_TXPRI1   EQU  H'0001'
FILHIT2_RTREN    EQU  H'0002'
FILHIT3_TXREQ    EQU  H'0003'
FILHIT4_TXERR    EQU  H'0004'
RTRRO_TXLARB     EQU  H'0005'
RXM1_TXABT       EQU  H'0006'
RXFUL_TXBIF      EQU  H'0007'

FILHIT0          EQU  H'0000'
FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
FILHIT3          EQU  H'0003'
FILHIT4          EQU  H'0004'
RTRRO            EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
RTREN            EQU  H'0002'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'


;----- B5SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- B5SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- B5EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- B5EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- B5DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_B5DLC        EQU  H'0004'
RB1_B5DLC        EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'


;----- B5D0 Bits -----------------------------------------------------
B5D00            EQU  H'0000'
B5D01            EQU  H'0001'
B5D02            EQU  H'0002'
B5D03            EQU  H'0003'
B5D04            EQU  H'0004'
B5D05            EQU  H'0005'
B5D06            EQU  H'0006'
B5D07            EQU  H'0007'

B57D07           EQU  H'0007'


;----- B5D1 Bits -----------------------------------------------------
B5D10            EQU  H'0000'
B5D11            EQU  H'0001'
B5D12            EQU  H'0002'
B5D13            EQU  H'0003'
B5D14            EQU  H'0004'
B5D15            EQU  H'0005'
B5D16            EQU  H'0006'
B5D17            EQU  H'0007'


;----- B5D2 Bits -----------------------------------------------------
B5D20            EQU  H'0000'
B5D21            EQU  H'0001'
B5D22            EQU  H'0002'
B5D23            EQU  H'0003'
B5D24            EQU  H'0004'
B5D25            EQU  H'0005'
B5D26            EQU  H'0006'
B5D27            EQU  H'0007'

B57D23           EQU  H'0003'


;----- B5D3 Bits -----------------------------------------------------
B5D30            EQU  H'0000'
B5D31            EQU  H'0001'
B5D32            EQU  H'0002'
B5D33            EQU  H'0003'
B5D34            EQU  H'0004'
B5D35            EQU  H'0005'
B5D36            EQU  H'0006'
B5D37            EQU  H'0007'


;----- B5D4 Bits -----------------------------------------------------
B5D40            EQU  H'0000'
B5D41            EQU  H'0001'
B5D42            EQU  H'0002'
B5D43            EQU  H'0003'
B5D44            EQU  H'0004'
B5D45            EQU  H'0005'
B5D46            EQU  H'0006'
B5D47            EQU  H'0007'


;----- B5D5 Bits -----------------------------------------------------
B5D50            EQU  H'0000'
B5D51            EQU  H'0001'
B5D52            EQU  H'0002'
B5D53            EQU  H'0003'
B5D54            EQU  H'0004'
B5D55            EQU  H'0005'
B5D56            EQU  H'0006'
B5D57            EQU  H'0007'


;----- B5D6 Bits -----------------------------------------------------
B5D60            EQU  H'0000'
B5D61            EQU  H'0001'
B5D62            EQU  H'0002'
B5D63            EQU  H'0003'
B5D64            EQU  H'0004'
B5D65            EQU  H'0005'
B5D66            EQU  H'0006'
B5D67            EQU  H'0007'


;----- B5D7 Bits -----------------------------------------------------
B5D70            EQU  H'0000'
B5D71            EQU  H'0001'
B5D72            EQU  H'0002'
B5D73            EQU  H'0003'
B5D74            EQU  H'0004'
B5D75            EQU  H'0005'
B5D76            EQU  H'0006'
B5D77            EQU  H'0007'


;----- CANSTAT_RO4 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO4 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- RXF0SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF0SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF0EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF0EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF1SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF1SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF1EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF1EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF2SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF2SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF2EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF2EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF3SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF3SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF3EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF3EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF4SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF4SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF4EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF4EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXF5SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXF5SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDE            EQU  H'0003'


;----- RXF5EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXF5EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXM0SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXM0SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDM            EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'

EXIDEN           EQU  H'0003'


;----- RXM0EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXM0EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXM1SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXM1SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDEN           EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'


;----- RXM1EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXM1EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- TXB2CON Bits -----------------------------------------------------
TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'

TXBIFBXB2CON     EQU  H'0007'


;----- TXB2SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- TXB2SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDE            EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'


;----- TXB2EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- TXB2EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- TXB2DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
TXRTR            EQU  H'0006'


;----- TXB2D0 Bits -----------------------------------------------------
TXB2D00          EQU  H'0000'
TXB2D01          EQU  H'0001'
TXB2D02          EQU  H'0002'
TXB2D03          EQU  H'0003'
TXB2D04          EQU  H'0004'
TXB2D05          EQU  H'0005'
TXB2D06          EQU  H'0006'
TXB2D07          EQU  H'0007'


;----- TXB2D1 Bits -----------------------------------------------------
TXB2D10          EQU  H'0000'
TXB2D11          EQU  H'0001'
TXB2D12          EQU  H'0002'
TXB2D13          EQU  H'0003'
TXB2D14          EQU  H'0004'
TXB2D15          EQU  H'0005'
TXB2D16          EQU  H'0006'
TXB2D17          EQU  H'0007'


;----- TXB2D2 Bits -----------------------------------------------------
TXB2D20          EQU  H'0000'
TXB2D21          EQU  H'0001'
TXB2D22          EQU  H'0002'
TXB2D23          EQU  H'0003'
TXB2D24          EQU  H'0004'
TXB2D25          EQU  H'0005'
TXB2D26          EQU  H'0006'
TXB2D27          EQU  H'0007'


;----- TXB2D3 Bits -----------------------------------------------------
TXB2D30          EQU  H'0000'
TXB2D31          EQU  H'0001'
TXB2D32          EQU  H'0002'
TXB2D33          EQU  H'0003'
TXB2D34          EQU  H'0004'
TXB2D35          EQU  H'0005'
TXB2D36          EQU  H'0006'
TXB2D37          EQU  H'0007'


;----- TXB2D4 Bits -----------------------------------------------------
TXB2D40          EQU  H'0000'
TXB2D41          EQU  H'0001'
TXB2D42          EQU  H'0002'
TXB2D43          EQU  H'0003'
TXB2D44          EQU  H'0004'
TXB2D45          EQU  H'0005'
TXB2D46          EQU  H'0006'
TXB2D47          EQU  H'0007'


;----- TXB2D5 Bits -----------------------------------------------------
TXB2D50          EQU  H'0000'
TXB2D51          EQU  H'0001'
TXB2D52          EQU  H'0002'
TXB2D53          EQU  H'0003'
TXB2D54          EQU  H'0004'
TXB2D55          EQU  H'0005'
TXB2D56          EQU  H'0006'
TXB2D57          EQU  H'0007'


;----- TXB2D6 Bits -----------------------------------------------------
TXB2D60          EQU  H'0000'
TXB2D61          EQU  H'0001'
TXB2D62          EQU  H'0002'
TXB2D63          EQU  H'0003'
TXB2D64          EQU  H'0004'
TXB2D65          EQU  H'0005'
TXB2D66          EQU  H'0006'
TXB2D67          EQU  H'0007'


;----- TXB2D7 Bits -----------------------------------------------------
TXB2D70          EQU  H'0000'
TXB2D71          EQU  H'0001'
TXB2D72          EQU  H'0002'
TXB2D73          EQU  H'0003'
TXB2D74          EQU  H'0004'
TXB2D75          EQU  H'0005'
TXB2D76          EQU  H'0006'
TXB2D77          EQU  H'0007'


;----- CANSTAT_RO3 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO3 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- TXB1CON Bits -----------------------------------------------------
TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'

TXBIFTXB1CON     EQU  H'0007'


;----- TXB1SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- TXB1SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDE            EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'


;----- TXB1EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- TXB1EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- TXB1DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
TXRTR            EQU  H'0006'


;----- TXB1D0 Bits -----------------------------------------------------
TXB1D00          EQU  H'0000'
TXB1D01          EQU  H'0001'
TXB1D02          EQU  H'0002'
TXB1D03          EQU  H'0003'
TXB1D04          EQU  H'0004'
TXB1D05          EQU  H'0005'
TXB1D06          EQU  H'0006'
TXB1D07          EQU  H'0007'


;----- TXB1D1 Bits -----------------------------------------------------
TXB1D10          EQU  H'0000'
TXB1D11          EQU  H'0001'
TXB1D12          EQU  H'0002'
TXB1D13          EQU  H'0003'
TXB1D14          EQU  H'0004'
TXB1D15          EQU  H'0005'
TXB1D16          EQU  H'0006'
TXB1D17          EQU  H'0007'


;----- TXB1D2 Bits -----------------------------------------------------
TXB1D20          EQU  H'0000'
TXB1D21          EQU  H'0001'
TXB1D22          EQU  H'0002'
TXB1D23          EQU  H'0003'
TXB1D24          EQU  H'0004'
TXB1D25          EQU  H'0005'
TXB1D26          EQU  H'0006'
TXB1D27          EQU  H'0007'


;----- TXB1D3 Bits -----------------------------------------------------
TXB1D30          EQU  H'0000'
TXB1D31          EQU  H'0001'
TXB1D32          EQU  H'0002'
TXB1D33          EQU  H'0003'
TXB1D34          EQU  H'0004'
TXB1D35          EQU  H'0005'
TXB1D36          EQU  H'0006'
TXB1D37          EQU  H'0007'


;----- TXB1D4 Bits -----------------------------------------------------
TXB1D40          EQU  H'0000'
TXB1D41          EQU  H'0001'
TXB1D42          EQU  H'0002'
TXB1D43          EQU  H'0003'
TXB1D44          EQU  H'0004'
TXB1D45          EQU  H'0005'
TXB1D46          EQU  H'0006'
TXB1D47          EQU  H'0007'


;----- TXB1D5 Bits -----------------------------------------------------
TXB1D50          EQU  H'0000'
TXB1D51          EQU  H'0001'
TXB1D52          EQU  H'0002'
TXB1D53          EQU  H'0003'
TXB1D54          EQU  H'0004'
TXB1D55          EQU  H'0005'
TXB1D56          EQU  H'0006'
TXB1D57          EQU  H'0007'


;----- TXB1D6 Bits -----------------------------------------------------
TXB1D60          EQU  H'0000'
TXB1D61          EQU  H'0001'
TXB1D62          EQU  H'0002'
TXB1D63          EQU  H'0003'
TXB1D64          EQU  H'0004'
TXB1D65          EQU  H'0005'
TXB1D66          EQU  H'0006'
TXB1D67          EQU  H'0007'


;----- TXB1D7 Bits -----------------------------------------------------
TXB1D70          EQU  H'0000'
TXB1D71          EQU  H'0001'
TXB1D72          EQU  H'0002'
TXB1D73          EQU  H'0003'
TXB1D74          EQU  H'0004'
TXB1D75          EQU  H'0005'
TXB1D76          EQU  H'0006'
TXB1D77          EQU  H'0007'


;----- CANSTAT_RO2 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO2 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- TXB0CON Bits -----------------------------------------------------
TXPRI0           EQU  H'0000'
TXPRI1           EQU  H'0001'
TXREQ            EQU  H'0003'
TXERR            EQU  H'0004'
TXLARB           EQU  H'0005'
TXABT            EQU  H'0006'
TXBIF            EQU  H'0007'


;----- TXB0SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- TXB0SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXIDE            EQU  H'0003'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'


;----- TXB0EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- TXB0EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- TXB0DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
TXRTR            EQU  H'0006'


;----- TXB0D0 Bits -----------------------------------------------------
TXB0D00          EQU  H'0000'
TXB0D01          EQU  H'0001'
TXB0D02          EQU  H'0002'
TXB0D03          EQU  H'0003'
TXB0D04          EQU  H'0004'
TXB0D05          EQU  H'0005'
TXB0D06          EQU  H'0006'
TXB0D07          EQU  H'0007'


;----- TXB0D1 Bits -----------------------------------------------------
TXB0D10          EQU  H'0000'
TXB0D11          EQU  H'0001'
TXB0D12          EQU  H'0002'
TXB0D13          EQU  H'0003'
TXB0D14          EQU  H'0004'
TXB0D15          EQU  H'0005'
TXB0D16          EQU  H'0006'
TXB0D17          EQU  H'0007'


;----- TXB0D2 Bits -----------------------------------------------------
TXB0D20          EQU  H'0000'
TXB0D21          EQU  H'0001'
TXB0D22          EQU  H'0002'
TXB0D23          EQU  H'0003'
TXB0D24          EQU  H'0004'
TXB0D25          EQU  H'0005'
TXB0D26          EQU  H'0006'
TXB0D27          EQU  H'0007'


;----- TXB0D3 Bits -----------------------------------------------------
TXB0D30          EQU  H'0000'
TXB0D31          EQU  H'0001'
TXB0D32          EQU  H'0002'
TXB0D33          EQU  H'0003'
TXB0D34          EQU  H'0004'
TXB0D35          EQU  H'0005'
TXB0D36          EQU  H'0006'
TXB0D37          EQU  H'0007'


;----- TXB0D4 Bits -----------------------------------------------------
TXB0D40          EQU  H'0000'
TXB0D41          EQU  H'0001'
TXB0D42          EQU  H'0002'
TXB0D43          EQU  H'0003'
TXB0D44          EQU  H'0004'
TXB0D45          EQU  H'0005'
TXB0D46          EQU  H'0006'
TXB0D47          EQU  H'0007'


;----- TXB0D5 Bits -----------------------------------------------------
TXB0D50          EQU  H'0000'
TXB0D51          EQU  H'0001'
TXB0D52          EQU  H'0002'
TXB0D53          EQU  H'0003'
TXB0D54          EQU  H'0004'
TXB0D55          EQU  H'0005'
TXB0D56          EQU  H'0006'
TXB0D57          EQU  H'0007'


;----- TXB0D6 Bits -----------------------------------------------------
TXB0D60          EQU  H'0000'
TXB0D61          EQU  H'0001'
TXB0D62          EQU  H'0002'
TXB0D63          EQU  H'0003'
TXB0D64          EQU  H'0004'
TXB0D65          EQU  H'0005'
TXB0D66          EQU  H'0006'
TXB0D67          EQU  H'0007'


;----- TXB0D7 Bits -----------------------------------------------------
TXB0D70          EQU  H'0000'
TXB0D71          EQU  H'0001'
TXB0D72          EQU  H'0002'
TXB0D73          EQU  H'0003'
TXB0D74          EQU  H'0004'
TXB0D75          EQU  H'0005'
TXB0D76          EQU  H'0006'
TXB0D77          EQU  H'0007'


;----- CANSTAT_RO1 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO1 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- RXB1CON Bits -----------------------------------------------------
FILHIT0          EQU  H'0000'
FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
RXRTRRO_FILHIT3  EQU  H'0003'
FILHIT4          EQU  H'0004'
RXM0_RTRRO       EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

RXRTRRO          EQU  H'0003'
RXM0             EQU  H'0005'

FILHIT3          EQU  H'0003'
RTRRO            EQU  H'0005'

RXRTRR0          EQU  H'0003'

RTRRO_FILHIT3    EQU  H'0003'


;----- RXB1SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXB1SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'


;----- RXB1EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXB1EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXB1DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_RXB1DLC      EQU  H'0004'
RB1_RXB1DLC      EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'


;----- RXB1D0 Bits -----------------------------------------------------
RXB1D00          EQU  H'0000'
RXB1D01          EQU  H'0001'
RXB1D02          EQU  H'0002'
RXB1D03          EQU  H'0003'
RXB1D04          EQU  H'0004'
RXB1D05          EQU  H'0005'
RXB1D06          EQU  H'0006'
RXB1D07          EQU  H'0007'


;----- RXB1D1 Bits -----------------------------------------------------
RXB1D10          EQU  H'0000'
RXB1D11          EQU  H'0001'
RXB1D12          EQU  H'0002'
RXB1D13          EQU  H'0003'
RXB1D14          EQU  H'0004'
RXB1D15          EQU  H'0005'
RXB1D16          EQU  H'0006'
RXB1D17          EQU  H'0007'


;----- RXB1D2 Bits -----------------------------------------------------
RXB1D20          EQU  H'0000'
RXB1D21          EQU  H'0001'
RXB1D22          EQU  H'0002'
RXB1D23          EQU  H'0003'
RXB1D24          EQU  H'0004'
RXB1D25          EQU  H'0005'
RXB1D26          EQU  H'0006'
RXB1D27          EQU  H'0007'


;----- RXB1D3 Bits -----------------------------------------------------
RXB1D30          EQU  H'0000'
RXB1D31          EQU  H'0001'
RXB1D32          EQU  H'0002'
RXB1D33          EQU  H'0003'
RXB1D34          EQU  H'0004'
RXB1D35          EQU  H'0005'
RXB1D36          EQU  H'0006'
RXB1D37          EQU  H'0007'


;----- RXB1D4 Bits -----------------------------------------------------
RXB1D40          EQU  H'0000'
RXB1D41          EQU  H'0001'
RXB1D42          EQU  H'0002'
RXB1D43          EQU  H'0003'
RXB1D44          EQU  H'0004'
RXB1D45          EQU  H'0005'
RXB1D46          EQU  H'0006'
RXB1D47          EQU  H'0007'


;----- RXB1D5 Bits -----------------------------------------------------
RXB1D50          EQU  H'0000'
RXB1D51          EQU  H'0001'
RXB1D52          EQU  H'0002'
RXB1D53          EQU  H'0003'
RXB1D54          EQU  H'0004'
RXB1D55          EQU  H'0005'
RXB1D56          EQU  H'0006'
RXB1D57          EQU  H'0007'


;----- RXB1D6 Bits -----------------------------------------------------
RXB1D60          EQU  H'0000'
RXB1D61          EQU  H'0001'
RXB1D62          EQU  H'0002'
RXB1D63          EQU  H'0003'
RXB1D64          EQU  H'0004'
RXB1D65          EQU  H'0005'
RXB1D66          EQU  H'0006'
RXB1D67          EQU  H'0007'


;----- RXB1D7 Bits -----------------------------------------------------
RXB1D70          EQU  H'0000'
RXB1D71          EQU  H'0001'
RXB1D72          EQU  H'0002'
RXB1D73          EQU  H'0003'
RXB1D74          EQU  H'0004'
RXB1D75          EQU  H'0005'
RXB1D76          EQU  H'0006'
RXB1D77          EQU  H'0007'


;----- CANSTAT_RO0 Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'


;----- CANCON_RO0 Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'


;----- RXB0CON Bits -----------------------------------------------------
FILHIT0          EQU  H'0000'
JTOFF_FILHIT1    EQU  H'0001'
RXB0DBEN_FILHIT2 EQU  H'0002'
RXRTRRO_FILHIT3  EQU  H'0003'
FILHIT4          EQU  H'0004'
RXM0_RTRRO       EQU  H'0005'
RXM1             EQU  H'0006'
RXFUL            EQU  H'0007'

JTOFF            EQU  H'0001'
RXB0DBEN         EQU  H'0002'
RXRTRRO          EQU  H'0003'
RXM0             EQU  H'0005'

FILHIT1          EQU  H'0001'
FILHIT2          EQU  H'0002'
FILHIT3          EQU  H'0003'
RTRRO            EQU  H'0005'

RTRR0            EQU  H'0005'

RTRRO_FILHIT3    EQU  H'0003'


;----- RXB0SIDH Bits -----------------------------------------------------
SID3             EQU  H'0000'
SID4             EQU  H'0001'
SID5             EQU  H'0002'
SID6             EQU  H'0003'
SID7             EQU  H'0004'
SID8             EQU  H'0005'
SID9             EQU  H'0006'
SID10            EQU  H'0007'


;----- RXB0SIDL Bits -----------------------------------------------------
EID16            EQU  H'0000'
EID17            EQU  H'0001'
EXID             EQU  H'0003'
SRR              EQU  H'0004'
SID0             EQU  H'0005'
SID1             EQU  H'0006'
SID2             EQU  H'0007'


;----- RXB0EIDH Bits -----------------------------------------------------
EID8             EQU  H'0000'
EID9             EQU  H'0001'
EID10            EQU  H'0002'
EID11            EQU  H'0003'
EID12            EQU  H'0004'
EID13            EQU  H'0005'
EID14            EQU  H'0006'
EID15            EQU  H'0007'


;----- RXB0EIDL Bits -----------------------------------------------------
EID0             EQU  H'0000'
EID1             EQU  H'0001'
EID2             EQU  H'0002'
EID3             EQU  H'0003'
EID4             EQU  H'0004'
EID5             EQU  H'0005'
EID6             EQU  H'0006'
EID7             EQU  H'0007'


;----- RXB0DLC Bits -----------------------------------------------------
DLC0             EQU  H'0000'
DLC1             EQU  H'0001'
DLC2             EQU  H'0002'
DLC3             EQU  H'0003'
RB0_RXB0DLC      EQU  H'0004'
RB1_RXB0DLC      EQU  H'0005'
RXRTR            EQU  H'0006'

RESRB0           EQU  H'0004'
RESRB1           EQU  H'0005'


;----- RXB0D0 Bits -----------------------------------------------------
RXB0D00          EQU  H'0000'
RXB0D01          EQU  H'0001'
RXB0D02          EQU  H'0002'
RXB0D03          EQU  H'0003'
RXB0D04          EQU  H'0004'
RXB0D05          EQU  H'0005'
RXB0D06          EQU  H'0006'
RXB0D07          EQU  H'0007'


;----- RXB0D1 Bits -----------------------------------------------------
RXB0D10          EQU  H'0000'
RXB0D11          EQU  H'0001'
RXB0D12          EQU  H'0002'
RXB0D13          EQU  H'0003'
RXB0D14          EQU  H'0004'
RXB0D15          EQU  H'0005'
RXB0D16          EQU  H'0006'
RXB0D17          EQU  H'0007'


;----- RXB0D2 Bits -----------------------------------------------------
RXB0D20          EQU  H'0000'
RXB0D21          EQU  H'0001'
RXB0D22          EQU  H'0002'
RXB0D23          EQU  H'0003'
RXB0D24          EQU  H'0004'
RXB0D25          EQU  H'0005'
RXB0D26          EQU  H'0006'
RXB0D27          EQU  H'0007'


;----- RXB0D3 Bits -----------------------------------------------------
RXB0D30          EQU  H'0000'
RXB0D31          EQU  H'0001'
RXB0D32          EQU  H'0002'
RXB0D33          EQU  H'0003'
RXB0D34          EQU  H'0004'
RXB0D35          EQU  H'0005'
RXB0D36          EQU  H'0006'
RXB0D37          EQU  H'0007'


;----- RXB0D4 Bits -----------------------------------------------------
RXB0D40          EQU  H'0000'
RXB0D41          EQU  H'0001'
RXB0D42          EQU  H'0002'
RXB0D43          EQU  H'0003'
RXB0D44          EQU  H'0004'
RXB0D45          EQU  H'0005'
RXB0D46          EQU  H'0006'
RXB0D47          EQU  H'0007'


;----- RXB0D5 Bits -----------------------------------------------------
RXB0D50          EQU  H'0000'
RXB0D51          EQU  H'0001'
RXB0D52          EQU  H'0002'
RXB0D53          EQU  H'0003'
RXB0D54          EQU  H'0004'
RXB0D55          EQU  H'0005'
RXB0D56          EQU  H'0006'
RXB0D57          EQU  H'0007'


;----- RXB0D6 Bits -----------------------------------------------------
RXB0D60          EQU  H'0000'
RXB0D61          EQU  H'0001'
RXB0D62          EQU  H'0002'
RXB0D63          EQU  H'0003'
RXB0D64          EQU  H'0004'
RXB0D65          EQU  H'0005'
RXB0D66          EQU  H'0006'
RXB0D67          EQU  H'0007'


;----- RXB0D7 Bits -----------------------------------------------------
RXB0D70          EQU  H'0000'
RXB0D71          EQU  H'0001'
RXB0D72          EQU  H'0002'
RXB0D73          EQU  H'0003'
RXB0D74          EQU  H'0004'
RXB0D75          EQU  H'0005'
RXB0D76          EQU  H'0006'
RXB0D77          EQU  H'0007'


;----- CANSTAT Bits -----------------------------------------------------
EICODE0          EQU  H'0000'
EICODE1_ICODE0   EQU  H'0001'
EICODE2_ICODE1   EQU  H'0002'
EICODE3_ICODE2   EQU  H'0003'
EICODE4          EQU  H'0004'
OPMODE0          EQU  H'0005'
OPMODE1          EQU  H'0006'
OPMODE2          EQU  H'0007'

ICODE0           EQU  H'0001'
ICODE1           EQU  H'0002'
ICODE2           EQU  H'0003'

EICODE1          EQU  H'0001'
EICODE2          EQU  H'0002'
EICODE3          EQU  H'0003'


;----- CANCON Bits -----------------------------------------------------
FP0              EQU  H'0000'
WIN0_FP1         EQU  H'0001'
WIN1_FP2         EQU  H'0002'
WIN2_FP3         EQU  H'0003'
ABAT             EQU  H'0004'
REQOP0           EQU  H'0005'
REQOP1           EQU  H'0006'
REQOP2           EQU  H'0007'

WIN0             EQU  H'0001'
WIN1             EQU  H'0002'
WIN2             EQU  H'0003'

FP1              EQU  H'0001'
FP2              EQU  H'0002'
FP3              EQU  H'0003'


;----- BRGCON1 Bits -----------------------------------------------------
BRP0             EQU  H'0000'
BRP1             EQU  H'0001'
BRP2             EQU  H'0002'
BRP3             EQU  H'0003'
BRP4             EQU  H'0004'
BRP5             EQU  H'0005'
SJW0             EQU  H'0006'
SJW1             EQU  H'0007'


;----- BRGCON2 Bits -----------------------------------------------------
PRSEG0           EQU  H'0000'
PRSEG1           EQU  H'0001'
PRSEG2           EQU  H'0002'
SEG1PH0          EQU  H'0003'
SEG1PH1          EQU  H'0004'
SEG1PH2          EQU  H'0005'
SAM              EQU  H'0006'
SEG2PHT          EQU  H'0007'

SEG2PHTS         EQU  H'0007'


;----- BRGCON3 Bits -----------------------------------------------------
SEG2PH0          EQU  H'0000'
SEG2PH1          EQU  H'0001'
SEG2PH2          EQU  H'0002'
WAKFIL           EQU  H'0006'
WAKDIS           EQU  H'0007'


;----- CIOCON Bits -----------------------------------------------------
CANCAP           EQU  H'0004'
ENDRHI           EQU  H'0005'
TX2EN            EQU  H'0006'
TX2SRC           EQU  H'0007'


;----- COMSTAT Bits -----------------------------------------------------
EWARN            EQU  H'0000'
RXWARN           EQU  H'0001'
TXWARN           EQU  H'0002'
RXBP             EQU  H'0003'
TXBP             EQU  H'0004'
TXBO             EQU  H'0005'
RXBnOVFL         EQU  H'0006'
RXB0OVFL_NOT_FIFOEMPTY EQU  H'0007'

RXB1OVFL         EQU  H'0006'
RXB0OVFL         EQU  H'0007'

FIFOEMPTY        EQU  H'0007'

NOT_FIFOEMPTY    EQU  H'0007'


;----- RXERRCNT Bits -----------------------------------------------------
REC0             EQU  H'0000'
REC1             EQU  H'0001'
REC2             EQU  H'0002'
REC3             EQU  H'0003'
REC4             EQU  H'0004'
REC5             EQU  H'0005'
REC6             EQU  H'0006'
REC7             EQU  H'0007'


;----- TXERRCNT Bits -----------------------------------------------------
TEC0             EQU  H'0000'
TEC1             EQU  H'0001'
TEC2             EQU  H'0002'
TEC3             EQU  H'0003'
TEC4             EQU  H'0004'
TEC5             EQU  H'0005'
TEC6             EQU  H'0006'
TEC7             EQU  H'0007'


;----- ECANCON Bits -----------------------------------------------------
EWIN0            EQU  H'0000'
EWIN1            EQU  H'0001'
EWIN2            EQU  H'0002'
EWIN3            EQU  H'0003'
EWIN4            EQU  H'0004'
FIFOWM           EQU  H'0005'
MDSEL0           EQU  H'0006'
MDSEL1           EQU  H'0007'

F                EQU  H'0005'


;----- ECCP1DEL Bits -----------------------------------------------------
PRSEN            EQU  H'0007'

PDC0             EQU  H'0000'
PDC1             EQU  H'0001'
PDC2             EQU  H'0002'
PDC3             EQU  H'0003'
PDC4             EQU  H'0004'
PDC5             EQU  H'0005'
PDC6             EQU  H'0006'


;----- BAUDCON Bits -----------------------------------------------------
ABDEN            EQU  H'0000'
WUE              EQU  H'0001'
BRG16            EQU  H'0003'
SCKP             EQU  H'0004'
RCIDL            EQU  H'0006'


;----- PORTA Bits -----------------------------------------------------
RA0              EQU  H'0000'
RA1              EQU  H'0001'
RA2              EQU  H'0002'
RA3              EQU  H'0003'
RA4              EQU  H'0004'
RA5              EQU  H'0005'
RA6              EQU  H'0006'

AN0              EQU  H'0000'
AN1              EQU  H'0001'
AN2              EQU  H'0002'
AN3              EQU  H'0003'
T0CKI            EQU  H'0004'
AN4              EQU  H'0005'
OSC2             EQU  H'0006'

VREFM            EQU  H'0002'
VREFP            EQU  H'0003'
LVDIN            EQU  H'0005'
CLKO             EQU  H'0006'


;----- PORTB Bits -----------------------------------------------------
RB0_PORTB        EQU  H'0000'
RB1_PORTB        EQU  H'0001'
RB2              EQU  H'0002'
RB3              EQU  H'0003'
RB4              EQU  H'0004'
RB5              EQU  H'0005'
RB6              EQU  H'0006'
RB7              EQU  H'0007'

INT0             EQU  H'0000'
INT1             EQU  H'0001'
INT2             EQU  H'0002'
INT3             EQU  H'0003'
KBI0             EQU  H'0004'
KBI1             EQU  H'0005'
KBI2             EQU  H'0006'
KBI3             EQU  H'0007'

PGM              EQU  H'0005'
PGC              EQU  H'0006'
PGD              EQU  H'0007'


;----- PORTC Bits -----------------------------------------------------
RC0              EQU  H'0000'
RC1              EQU  H'0001'
RC2              EQU  H'0002'
RC3              EQU  H'0003'
RC4              EQU  H'0004'
RC5              EQU  H'0005'
RC6              EQU  H'0006'
RC7              EQU  H'0007'

T1OSO            EQU  H'0000'
T1OSI            EQU  H'0001'
CCP1             EQU  H'0002'
SCK              EQU  H'0003'
SDI              EQU  H'0004'
SDO              EQU  H'0005'
TX               EQU  H'0006'
RX               EQU  H'0007'

T13CKI           EQU  H'0000'
P1A              EQU  H'0002'
SCL              EQU  H'0003'
SDA              EQU  H'0004'
CK               EQU  H'0006'
; DT is a reserved word
; DT               EQU  H'0007'


;----- PORTD Bits -----------------------------------------------------
RD0              EQU  H'0000'
RD1              EQU  H'0001'
RD2              EQU  H'0002'
RD3              EQU  H'0003'
RD4              EQU  H'0004'
RD5              EQU  H'0005'
RD6              EQU  H'0006'
RD7              EQU  H'0007'

PSP0             EQU  H'0000'
PSP1             EQU  H'0001'
PSP2             EQU  H'0002'
PSP3             EQU  H'0003'
PSP4             EQU  H'0004'
PSP5             EQU  H'0005'
PSP6             EQU  H'0006'
PSP7             EQU  H'0007'

AD0              EQU  H'0000'
AD1              EQU  H'0001'
AD2              EQU  H'0002'
AD3              EQU  H'0003'
AD4              EQU  H'0004'
AD5              EQU  H'0005'
AD6              EQU  H'0006'
AD7              EQU  H'0007'


;----- PORTE Bits -----------------------------------------------------
RE0              EQU  H'0000'
RE1              EQU  H'0001'
RE2              EQU  H'0002'
RE3              EQU  H'0003'
RE4              EQU  H'0004'
RE5              EQU  H'0005'
RE6              EQU  H'0006'
RE7              EQU  H'0007'

RD               EQU  H'0000'
WR               EQU  H'0001'
CS               EQU  H'0002'

AD8              EQU  H'0000'
AD9              EQU  H'0001'
AD10             EQU  H'0002'
AD11             EQU  H'0003'
AD12             EQU  H'0004'
AD13             EQU  H'0005'
AD14             EQU  H'0006'
AD15             EQU  H'0007'


;----- PORTF Bits -----------------------------------------------------
RF0              EQU  H'0000'
RF1              EQU  H'0001'
RF2              EQU  H'0002'
RF3              EQU  H'0003'
RF4              EQU  H'0004'
RF5              EQU  H'0005'
RF6              EQU  H'0006'
RF7              EQU  H'0007'

AN5              EQU  H'0000'
AN6              EQU  H'0001'
AN7              EQU  H'0002'
AN8              EQU  H'0003'
AN9              EQU  H'0004'
AN10             EQU  H'0005'
AN11             EQU  H'0006'
SS               EQU  H'0007'

C2OUTF           EQU  H'0001'
C1OUTF           EQU  H'0002'
CVREFF           EQU  H'0005'


;----- PORTG Bits -----------------------------------------------------
RG0              EQU  H'0000'
RG1              EQU  H'0001'
RG2              EQU  H'0002'
RG3              EQU  H'0003'
RG4              EQU  H'0004'
RG5              EQU  H'0005'

CANTX1           EQU  H'0000'
CANTX2           EQU  H'0001'
CANRX            EQU  H'0002'
P1D              EQU  H'0004'
MCLR             EQU  H'0005'


;----- PORTH Bits -----------------------------------------------------
RH0              EQU  H'0000'
RH1              EQU  H'0001'
RH2              EQU  H'0002'
RH3              EQU  H'0003'
RH4              EQU  H'0004'
RH5              EQU  H'0005'
RH6              EQU  H'0006'
RH7              EQU  H'0007'

AD16             EQU  H'0000'
AD17             EQU  H'0001'
AD18             EQU  H'0002'
AD19             EQU  H'0003'
AN12             EQU  H'0004'
AN13             EQU  H'0005'
AN14             EQU  H'0006'
AN15             EQU  H'0007'


;----- PORTJ Bits -----------------------------------------------------
RJ0              EQU  H'0000'
RJ1              EQU  H'0001'
RJ2              EQU  H'0002'
RJ3              EQU  H'0003'
RJ4              EQU  H'0004'
RJ5              EQU  H'0005'
RJ6              EQU  H'0006'
RJ7              EQU  H'0007'

ALE              EQU  H'0000'
OE               EQU  H'0001'
WRL              EQU  H'0002'
WRH              EQU  H'0003'
BA0              EQU  H'0004'
CE               EQU  H'0005'
LB               EQU  H'0006'
UB               EQU  H'0007'


;----- LATA Bits -----------------------------------------------------
LATA0            EQU  H'0000'
LATA1            EQU  H'0001'
LATA2            EQU  H'0002'
LATA3            EQU  H'0003'
LATA4            EQU  H'0004'
LATA5            EQU  H'0005'
LATA6            EQU  H'0006'


;----- LATB Bits -----------------------------------------------------
LATB0            EQU  H'0000'
LATB1            EQU  H'0001'
LATB2            EQU  H'0002'
LATB3            EQU  H'0003'
LATB4            EQU  H'0004'
LATB5            EQU  H'0005'
LATB6            EQU  H'0006'
LATB7            EQU  H'0007'


;----- LATC Bits -----------------------------------------------------
LATC0            EQU  H'0000'
LATC1            EQU  H'0001'
LATC2            EQU  H'0002'
LATC3            EQU  H'0003'
LATC4            EQU  H'0004'
LATC5            EQU  H'0005'
LATC6            EQU  H'0006'
LATC7            EQU  H'0007'


;----- LATD Bits -----------------------------------------------------
LATD0            EQU  H'0000'
LATD1            EQU  H'0001'
LATD2            EQU  H'0002'
LATD3            EQU  H'0003'
LATD4            EQU  H'0004'
LATD5            EQU  H'0005'
LATD6            EQU  H'0006'
LATD7            EQU  H'0007'


;----- LATE Bits -----------------------------------------------------
LATE0            EQU  H'0000'
LATE1            EQU  H'0001'
LATE2            EQU  H'0002'
LATE3            EQU  H'0003'
LATE4            EQU  H'0004'
LATE5            EQU  H'0005'
LATE6            EQU  H'0006'
LATE7            EQU  H'0007'


;----- LATF Bits -----------------------------------------------------
LATF0            EQU  H'0000'
LATF1            EQU  H'0001'
LATF2            EQU  H'0002'
LATF3            EQU  H'0003'
LATF4            EQU  H'0004'
LATF5            EQU  H'0005'
LATF6            EQU  H'0006'
LATF7            EQU  H'0007'


;----- LATG Bits -----------------------------------------------------
LATG0            EQU  H'0000'
LATG1            EQU  H'0001'
LATG2            EQU  H'0002'
LATG3            EQU  H'0003'
LATG4            EQU  H'0004'


;----- LATH Bits -----------------------------------------------------
LATH0            EQU  H'0000'
LATH1            EQU  H'0001'
LATH2            EQU  H'0002'
LATH3            EQU  H'0003'
LATH4            EQU  H'0004'
LATH5            EQU  H'0005'
LATH6            EQU  H'0006'
LATH7            EQU  H'0007'


;----- LATJ Bits -----------------------------------------------------
LATJ0            EQU  H'0000'
LATJ1            EQU  H'0001'
LATJ2            EQU  H'0002'
LATJ3            EQU  H'0003'
LATJ4            EQU  H'0004'
LATJ5            EQU  H'0005'
LATJ6            EQU  H'0006'
LATJ7            EQU  H'0007'


;----- DDRA Bits -----------------------------------------------------
TRISA0           EQU  H'0000'
TRISA1           EQU  H'0001'
TRISA2           EQU  H'0002'
TRISA3           EQU  H'0003'
TRISA4           EQU  H'0004'
TRISA5           EQU  H'0005'
TRISA6           EQU  H'0006'

RA0              EQU  H'0000'
RA1              EQU  H'0001'
RA2              EQU  H'0002'
RA3              EQU  H'0003'
RA4              EQU  H'0004'
RA5              EQU  H'0005'
RA6              EQU  H'0006'


;----- TRISA Bits -----------------------------------------------------
TRISA0           EQU  H'0000'
TRISA1           EQU  H'0001'
TRISA2           EQU  H'0002'
TRISA3           EQU  H'0003'
TRISA4           EQU  H'0004'
TRISA5           EQU  H'0005'
TRISA6           EQU  H'0006'

RA0              EQU  H'0000'
RA1              EQU  H'0001'
RA2              EQU  H'0002'
RA3              EQU  H'0003'
RA4              EQU  H'0004'
RA5              EQU  H'0005'
RA6              EQU  H'0006'


;----- DDRB Bits -----------------------------------------------------
TRISB0           EQU  H'0000'
TRISB1           EQU  H'0001'
TRISB2           EQU  H'0002'
TRISB3           EQU  H'0003'
TRISB4           EQU  H'0004'
TRISB5           EQU  H'0005'
TRISB6           EQU  H'0006'
TRISB7           EQU  H'0007'

RB0_DDRB         EQU  H'0000'
RB1_DDRB         EQU  H'0001'
RB2              EQU  H'0002'
RB3              EQU  H'0003'
RB4              EQU  H'0004'
RB5              EQU  H'0005'
RB6              EQU  H'0006'
RB7              EQU  H'0007'


;----- TRISB Bits -----------------------------------------------------
TRISB0           EQU  H'0000'
TRISB1           EQU  H'0001'
TRISB2           EQU  H'0002'
TRISB3           EQU  H'0003'
TRISB4           EQU  H'0004'
TRISB5           EQU  H'0005'
TRISB6           EQU  H'0006'
TRISB7           EQU  H'0007'

RB0_TRISB        EQU  H'0000'
RB1_TRISB        EQU  H'0001'
RB2              EQU  H'0002'
RB3              EQU  H'0003'
RB4              EQU  H'0004'
RB5              EQU  H'0005'
RB6              EQU  H'0006'
RB7              EQU  H'0007'


;----- DDRC Bits -----------------------------------------------------
TRISC0           EQU  H'0000'
TRISC1           EQU  H'0001'
TRISC2           EQU  H'0002'
TRISC3           EQU  H'0003'
TRISC4           EQU  H'0004'
TRISC5           EQU  H'0005'
TRISC6           EQU  H'0006'
TRISC7           EQU  H'0007'

RC0              EQU  H'0000'
RC1              EQU  H'0001'
RC2              EQU  H'0002'
RC3              EQU  H'0003'
RC4              EQU  H'0004'
RC5              EQU  H'0005'
RC6              EQU  H'0006'
RC7              EQU  H'0007'


;----- TRISC Bits -----------------------------------------------------
TRISC0           EQU  H'0000'
TRISC1           EQU  H'0001'
TRISC2           EQU  H'0002'
TRISC3           EQU  H'0003'
TRISC4           EQU  H'0004'
TRISC5           EQU  H'0005'
TRISC6           EQU  H'0006'
TRISC7           EQU  H'0007'

RC0              EQU  H'0000'
RC1              EQU  H'0001'
RC2              EQU  H'0002'
RC3              EQU  H'0003'
RC4              EQU  H'0004'
RC5              EQU  H'0005'
RC6              EQU  H'0006'
RC7              EQU  H'0007'


;----- DDRD Bits -----------------------------------------------------
TRISD0           EQU  H'0000'
TRISD1           EQU  H'0001'
TRISD2           EQU  H'0002'
TRISD3           EQU  H'0003'
TRISD4           EQU  H'0004'
TRISD5           EQU  H'0005'
TRISD6           EQU  H'0006'
TRISD7           EQU  H'0007'

RD0              EQU  H'0000'
RD1              EQU  H'0001'
RD2              EQU  H'0002'
RD3              EQU  H'0003'
RD4              EQU  H'0004'
RD5              EQU  H'0005'
RD6              EQU  H'0006'
RD7              EQU  H'0007'


;----- TRISD Bits -----------------------------------------------------
TRISD0           EQU  H'0000'
TRISD1           EQU  H'0001'
TRISD2           EQU  H'0002'
TRISD3           EQU  H'0003'
TRISD4           EQU  H'0004'
TRISD5           EQU  H'0005'
TRISD6           EQU  H'0006'
TRISD7           EQU  H'0007'

RD0              EQU  H'0000'
RD1              EQU  H'0001'
RD2              EQU  H'0002'
RD3              EQU  H'0003'
RD4              EQU  H'0004'
RD5              EQU  H'0005'
RD6              EQU  H'0006'
RD7              EQU  H'0007'


;----- DDRE Bits -----------------------------------------------------
TRISE0           EQU  H'0000'
TRISE1           EQU  H'0001'
TRISE2           EQU  H'0002'
TRISE3           EQU  H'0003'
TRISE4           EQU  H'0004'
TRISE5           EQU  H'0005'
TRISE6           EQU  H'0006'
TRISE7           EQU  H'0007'

RE0              EQU  H'0000'
RE1              EQU  H'0001'
RE2              EQU  H'0002'
RE3              EQU  H'0003'
RE4              EQU  H'0004'
RE5              EQU  H'0005'
RE6              EQU  H'0006'
RE7              EQU  H'0007'


;----- TRISE Bits -----------------------------------------------------
TRISE0           EQU  H'0000'
TRISE1           EQU  H'0001'
TRISE2           EQU  H'0002'
TRISE3           EQU  H'0003'
TRISE4           EQU  H'0004'
TRISE5           EQU  H'0005'
TRISE6           EQU  H'0006'
TRISE7           EQU  H'0007'

RE0              EQU  H'0000'
RE1              EQU  H'0001'
RE2              EQU  H'0002'
RE3              EQU  H'0003'
RE4              EQU  H'0004'
RE5              EQU  H'0005'
RE6              EQU  H'0006'
RE7              EQU  H'0007'


;----- DDRF Bits -----------------------------------------------------
TRISF0           EQU  H'0000'
TRISF1           EQU  H'0001'
TRISF2           EQU  H'0002'
TRISF3           EQU  H'0003'
TRISF4           EQU  H'0004'
TRISF5           EQU  H'0005'
TRISF6           EQU  H'0006'
TRISF7           EQU  H'0007'

RF0              EQU  H'0000'
RF1              EQU  H'0001'
RF2              EQU  H'0002'
RF3              EQU  H'0003'
RF4              EQU  H'0004'
RF5              EQU  H'0005'
RF6              EQU  H'0006'
RF7              EQU  H'0007'


;----- TRISF Bits -----------------------------------------------------
TRISF0           EQU  H'0000'
TRISF1           EQU  H'0001'
TRISF2           EQU  H'0002'
TRISF3           EQU  H'0003'
TRISF4           EQU  H'0004'
TRISF5           EQU  H'0005'
TRISF6           EQU  H'0006'
TRISF7           EQU  H'0007'

RF0              EQU  H'0000'
RF1              EQU  H'0001'
RF2              EQU  H'0002'
RF3              EQU  H'0003'
RF4              EQU  H'0004'
RF5              EQU  H'0005'
RF6              EQU  H'0006'
RF7              EQU  H'0007'


;----- DDRG Bits -----------------------------------------------------
TRISG0           EQU  H'0000'
TRISG1           EQU  H'0001'
TRISG2           EQU  H'0002'
TRISG3           EQU  H'0003'
TRISG4           EQU  H'0004'

RG0              EQU  H'0000'
RG1              EQU  H'0001'
RG2              EQU  H'0002'
RG3              EQU  H'0003'
RG4              EQU  H'0004'


;----- TRISG Bits -----------------------------------------------------
TRISG0           EQU  H'0000'
TRISG1           EQU  H'0001'
TRISG2           EQU  H'0002'
TRISG3           EQU  H'0003'
TRISG4           EQU  H'0004'

RG0              EQU  H'0000'
RG1              EQU  H'0001'
RG2              EQU  H'0002'
RG3              EQU  H'0003'
RG4              EQU  H'0004'


;----- DDRH Bits -----------------------------------------------------
TRISH0           EQU  H'0000'
TRISH1           EQU  H'0001'
TRISH2           EQU  H'0002'
TRISH3           EQU  H'0003'
TRISH4           EQU  H'0004'
TRISH5           EQU  H'0005'
TRISH6           EQU  H'0006'
TRISH7           EQU  H'0007'

RH0              EQU  H'0000'
RH1              EQU  H'0001'
RH2              EQU  H'0002'
RH3              EQU  H'0003'
RH4              EQU  H'0004'
RH5              EQU  H'0005'
RH6              EQU  H'0006'
RH7              EQU  H'0007'


;----- TRISH Bits -----------------------------------------------------
TRISH0           EQU  H'0000'
TRISH1           EQU  H'0001'
TRISH2           EQU  H'0002'
TRISH3           EQU  H'0003'
TRISH4           EQU  H'0004'
TRISH5           EQU  H'0005'
TRISH6           EQU  H'0006'
TRISH7           EQU  H'0007'

RH0              EQU  H'0000'
RH1              EQU  H'0001'
RH2              EQU  H'0002'
RH3              EQU  H'0003'
RH4              EQU  H'0004'
RH5              EQU  H'0005'
RH6              EQU  H'0006'
RH7              EQU  H'0007'


;----- DDRJ Bits -----------------------------------------------------
TRISJ0           EQU  H'0000'
TRISJ1           EQU  H'0001'
TRISJ2           EQU  H'0002'
TRISJ3           EQU  H'0003'
TRISJ4           EQU  H'0004'
TRISJ5           EQU  H'0005'
TRISJ6           EQU  H'0006'
TRISJ7           EQU  H'0007'

RJ0              EQU  H'0000'
RJ1              EQU  H'0001'
RJ2              EQU  H'0002'
RJ3              EQU  H'0003'
RJ4              EQU  H'0004'
RJ5              EQU  H'0005'
RJ6              EQU  H'0006'
RJ7              EQU  H'0007'


;----- TRISJ Bits -----------------------------------------------------
TRISJ0           EQU  H'0000'
TRISJ1           EQU  H'0001'
TRISJ2           EQU  H'0002'
TRISJ3           EQU  H'0003'
TRISJ4           EQU  H'0004'
TRISJ5           EQU  H'0005'
TRISJ6           EQU  H'0006'
TRISJ7           EQU  H'0007'

RJ0              EQU  H'0000'
RJ1              EQU  H'0001'
RJ2              EQU  H'0002'
RJ3              EQU  H'0003'
RJ4              EQU  H'0004'
RJ5              EQU  H'0005'
RJ6              EQU  H'0006'
RJ7              EQU  H'0007'


;----- MEMCON Bits -----------------------------------------------------
EBDIS            EQU  H'0007'

WM0              EQU  H'0000'
WM1              EQU  H'0001'
WAIT0            EQU  H'0004'
WAIT1            EQU  H'0005'


;----- PIE1 Bits -----------------------------------------------------
TMR1IE           EQU  H'0000'
TMR2IE           EQU  H'0001'
CCP1IE           EQU  H'0002'
SSPIE            EQU  H'0003'
TXIE             EQU  H'0004'
RCIE             EQU  H'0005'
ADIE             EQU  H'0006'
PSPIE            EQU  H'0007'


;----- PIR1 Bits -----------------------------------------------------
TMR1IF           EQU  H'0000'
TMR2IF           EQU  H'0001'
CCP1IF           EQU  H'0002'
SSPIF            EQU  H'0003'
TXIF             EQU  H'0004'
RCIF             EQU  H'0005'
ADIF             EQU  H'0006'
PSPIF            EQU  H'0007'


;----- IPR1 Bits -----------------------------------------------------
TMR1IP           EQU  H'0000'
TMR2IP           EQU  H'0001'
CCP1IP           EQU  H'0002'
SSPIP            EQU  H'0003'
TXIP             EQU  H'0004'
RCIP             EQU  H'0005'
ADIP             EQU  H'0006'
PSPIP            EQU  H'0007'


;----- PIE2 Bits -----------------------------------------------------
CCP2IE           EQU  H'0000'
TMR3IE           EQU  H'0001'
LVDIE            EQU  H'0002'
BCLIE            EQU  H'0003'
EEIE             EQU  H'0004'
CMIE             EQU  H'0006'


;----- PIR2 Bits -----------------------------------------------------
CCP2IF           EQU  H'0000'
TMR3IF           EQU  H'0001'
LVDIF            EQU  H'0002'
BCLIF            EQU  H'0003'
EEIF             EQU  H'0004'
CMIF             EQU  H'0006'


;----- IPR2 Bits -----------------------------------------------------
CCP2IP           EQU  H'0000'
TMR3IP           EQU  H'0001'
LVDIP            EQU  H'0002'
BCLIP            EQU  H'0003'
EEIP             EQU  H'0004'
CMIP             EQU  H'0006'


;----- PIE3 Bits -----------------------------------------------------
RXB0IE           EQU  H'0000'
RXB1IE           EQU  H'0001'
TXB0IE           EQU  H'0002'
TXB1IE           EQU  H'0003'
TXB2IE           EQU  H'0004'
ERRIE            EQU  H'0005'
WAKIE            EQU  H'0006'
IRXIE            EQU  H'0007'

FIFOWMIE         EQU  H'0000'
RXBnIE           EQU  H'0001'
TXBnIE           EQU  H'0004'


;----- PIR3 Bits -----------------------------------------------------
RXB0IF           EQU  H'0000'
RXB1IF           EQU  H'0001'
TXB0IF           EQU  H'0002'
TXB1IF           EQU  H'0003'
TXB2IF           EQU  H'0004'
ERRIF            EQU  H'0005'
WAKIF            EQU  H'0006'
IRXIF            EQU  H'0007'

FIFOWMIF         EQU  H'0000'
RXBnIF           EQU  H'0001'
TXBnIF           EQU  H'0004'


;----- IPR3 Bits -----------------------------------------------------
RXB0IP           EQU  H'0000'
RXB1IP           EQU  H'0001'
TXB0IP           EQU  H'0002'
TXB1IP           EQU  H'0003'
TXB2IP           EQU  H'0004'
ERRIP            EQU  H'0005'
WAKIP            EQU  H'0006'
IRXIP            EQU  H'0007'

FIFOWMIP         EQU  H'0000'
RXBnIP           EQU  H'0001'
TXBnIP           EQU  H'0004'


;----- EECON1 Bits -----------------------------------------------------
RD               EQU  H'0000'
WR               EQU  H'0001'
WREN             EQU  H'0002'
WRERR            EQU  H'0003'
FREE             EQU  H'0004'
CFGS             EQU  H'0006'
EEPGD            EQU  H'0007'


;----- RCSTA Bits -----------------------------------------------------
RX9D             EQU  H'0000'
OERR             EQU  H'0001'
FERR             EQU  H'0002'
ADDEN            EQU  H'0003'
CREN             EQU  H'0004'
SREN             EQU  H'0005'
RX9              EQU  H'0006'
SPEN             EQU  H'0007'

ADEN             EQU  H'0003'

RX9D1            EQU  H'0000'
OERR1            EQU  H'0001'
FERR1            EQU  H'0002'
ADDEN1           EQU  H'0003'
CREN1            EQU  H'0004'
SREN1            EQU  H'0005'
RX91             EQU  H'0006'
SPEN1            EQU  H'0007'


;----- RCSTA1 Bits -----------------------------------------------------
RX9D             EQU  H'0000'
OERR             EQU  H'0001'
FERR             EQU  H'0002'
ADDEN            EQU  H'0003'
CREN             EQU  H'0004'
SREN             EQU  H'0005'
RX9              EQU  H'0006'
SPEN             EQU  H'0007'

ADEN             EQU  H'0003'

RX9D1            EQU  H'0000'
OERR1            EQU  H'0001'
FERR1            EQU  H'0002'
ADDEN1           EQU  H'0003'
CREN1            EQU  H'0004'
SREN1            EQU  H'0005'
RX91             EQU  H'0006'
SPEN1            EQU  H'0007'


;----- TXSTA Bits -----------------------------------------------------
TX9D             EQU  H'0000'
TRMT             EQU  H'0001'
BRGH             EQU  H'0002'
SENDB            EQU  H'0003'
SYNC             EQU  H'0004'
TXEN             EQU  H'0005'
TX9              EQU  H'0006'
CSRC             EQU  H'0007'

TX9D1            EQU  H'0000'
TRMT1            EQU  H'0001'
BRGH1            EQU  H'0002'
SENDB1           EQU  H'0003'
SYNC1            EQU  H'0004'
TXEN1            EQU  H'0005'
TX91             EQU  H'0006'
CSRC1            EQU  H'0007'


;----- TXSTA1 Bits -----------------------------------------------------
TX9D             EQU  H'0000'
TRMT             EQU  H'0001'
BRGH             EQU  H'0002'
SENDB            EQU  H'0003'
SYNC             EQU  H'0004'
TXEN             EQU  H'0005'
TX9              EQU  H'0006'
CSRC             EQU  H'0007'

TX9D1            EQU  H'0000'
TRMT1            EQU  H'0001'
BRGH1            EQU  H'0002'
SENDB1           EQU  H'0003'
SYNC1            EQU  H'0004'
TXEN1            EQU  H'0005'
TX91             EQU  H'0006'
CSRC1            EQU  H'0007'


;----- PSPCON Bits -----------------------------------------------------
PSPMODE          EQU  H'0004'
IBOV             EQU  H'0005'
OBF              EQU  H'0006'
IBF              EQU  H'0007'


;----- T3CON Bits -----------------------------------------------------
TMR3ON           EQU  H'0000'
TMR3CS           EQU  H'0001'
NOT_T3SYNC       EQU  H'0002'
T3CCP1           EQU  H'0003'
T3CCP2           EQU  H'0006'
RD16             EQU  H'0007'

T3SYNC           EQU  H'0002'
T3CKPS0          EQU  H'0004'
T3CKPS1          EQU  H'0005'

T3NSYNC          EQU  H'0002'


;----- CMCON Bits -----------------------------------------------------
CIS              EQU  H'0003'
C1INV            EQU  H'0004'
C2INV            EQU  H'0005'
C1OUT            EQU  H'0006'
C2OUT            EQU  H'0007'

CM0              EQU  H'0000'
CM1              EQU  H'0001'
CM2              EQU  H'0002'


;----- CVRCON Bits -----------------------------------------------------
CVRSS            EQU  H'0004'
CVRR             EQU  H'0005'
CVROE            EQU  H'0006'
CVREN            EQU  H'0007'

CVR0             EQU  H'0000'
CVR1             EQU  H'0001'
CVR2             EQU  H'0002'
CVR3             EQU  H'0003'
CVREF            EQU  H'0004'


;----- ECCP1AS Bits -----------------------------------------------------
ECCPASE          EQU  H'0007'

PSSBD0           EQU  H'0000'
PSSBD1           EQU  H'0001'
PSSAC0           EQU  H'0002'
PSSAC1           EQU  H'0003'
ECCPAS0          EQU  H'0004'
ECCPAS1          EQU  H'0005'
ECCPAS2          EQU  H'0006'


;----- CCP2CON Bits -----------------------------------------------------
CCP2M0           EQU  H'0000'
CCP2M1           EQU  H'0001'
CCP2M2           EQU  H'0002'
CCP2M3           EQU  H'0003'
DC2B0            EQU  H'0004'
DC2B1            EQU  H'0005'


;----- CCP1CON Bits -----------------------------------------------------
CCP1M0           EQU  H'0000'
CCP1M1           EQU  H'0001'
CCP1M2           EQU  H'0002'
CCP1M3           EQU  H'0003'
DC1B0            EQU  H'0004'
DC1B1            EQU  H'0005'
P1M0             EQU  H'0006'
P1M1             EQU  H'0007'


;----- ADCON2 Bits -----------------------------------------------------
ADFM             EQU  H'0007'

ADCS0            EQU  H'0000'
ADCS1            EQU  H'0001'
ADCS2            EQU  H'0002'
ACQT0            EQU  H'0003'
ACQT1            EQU  H'0004'
ACQT2            EQU  H'0005'


;----- ADCON1 Bits -----------------------------------------------------
PCFG0            EQU  H'0000'
PCFG1            EQU  H'0001'
PCFG2            EQU  H'0002'
PCFG3            EQU  H'0003'
VCFG0            EQU  H'0004'
VCFG1            EQU  H'0005'


;----- ADCON0 Bits -----------------------------------------------------
ADON             EQU  H'0000'
GO_NOT_DONE      EQU  H'0001'

GO_DONE          EQU  H'0001'
CHS0             EQU  H'0002'
CHS1             EQU  H'0003'
CHS2             EQU  H'0004'
CHS3             EQU  H'0005'

DONE             EQU  H'0001'

GO               EQU  H'0001'

NOT_DONE         EQU  H'0001'


;----- SSPCON2 Bits -----------------------------------------------------
SEN              EQU  H'0000'
RSEN             EQU  H'0001'
PEN              EQU  H'0002'
RCEN             EQU  H'0003'
ACKEN            EQU  H'0004'
ACKDT            EQU  H'0005'
ACKSTAT          EQU  H'0006'
GCEN             EQU  H'0007'


;----- SSPCON1 Bits -----------------------------------------------------
CKP              EQU  H'0004'
SSPEN            EQU  H'0005'
SSPOV            EQU  H'0006'
WCOL             EQU  H'0007'

SSPM0            EQU  H'0000'
SSPM1            EQU  H'0001'
SSPM2            EQU  H'0002'
SSPM3            EQU  H'0003'


;----- SSPSTAT Bits -----------------------------------------------------
BF               EQU  H'0000'
UA               EQU  H'0001'
R_NOT_W          EQU  H'0002'
S                EQU  H'0003'
P                EQU  H'0004'
D_NOT_A          EQU  H'0005'
CKE              EQU  H'0006'
SMP              EQU  H'0007'

R_W              EQU  H'0002'
D_A              EQU  H'0005'

I2C_READ         EQU  H'0002'
I2C_START        EQU  H'0003'
I2C_STOP         EQU  H'0004'
I2C_DAT          EQU  H'0005'

NOT_W            EQU  H'0002'
NOT_A            EQU  H'0005'

NOT_WRITE        EQU  H'0002'
NOT_ADDRESS      EQU  H'0005'

READ_WRITE       EQU  H'0002'
DATA_ADDRESS     EQU  H'0005'

R                EQU  H'0002'
D                EQU  H'0005'


;----- T2CON Bits -----------------------------------------------------
TMR2ON           EQU  H'0002'

T2CKPS0          EQU  H'0000'
T2CKPS1          EQU  H'0001'
T2OUTPS0         EQU  H'0003'
T2OUTPS1         EQU  H'0004'
T2OUTPS2         EQU  H'0005'
T2OUTPS3         EQU  H'0006'


;----- T1CON Bits -----------------------------------------------------
TMR1ON           EQU  H'0000'
TMR1CS           EQU  H'0001'
NOT_T1SYNC       EQU  H'0002'
T1OSCEN          EQU  H'0003'
RD16             EQU  H'0007'

T1SYNC           EQU  H'0002'
T1CKPS0          EQU  H'0004'
T1CKPS1          EQU  H'0005'

T1INSYNC         EQU  H'0002'


;----- RCON Bits -----------------------------------------------------
NOT_BOR          EQU  H'0000'
NOT_POR          EQU  H'0001'
NOT_PD           EQU  H'0002'
NOT_TO           EQU  H'0003'
NOT_RI           EQU  H'0004'
IPEN             EQU  H'0007'

BOR              EQU  H'0000'
POR              EQU  H'0001'
PD               EQU  H'0002'
TO               EQU  H'0003'
RI               EQU  H'0004'
NOT_IPEN         EQU  H'0007'


;----- WDTCON Bits -----------------------------------------------------
SWDTEN           EQU  H'0000'

SWDTE            EQU  H'0000'


;----- LVDCON Bits -----------------------------------------------------
LVDEN            EQU  H'0004'
IRVST            EQU  H'0005'

LVDL0            EQU  H'0000'
LVDL1            EQU  H'0001'
LVDL2            EQU  H'0002'
LVDL3            EQU  H'0003'

LVV0             EQU  H'0000'
LVV1             EQU  H'0001'
LVV2             EQU  H'0002'
LVV3             EQU  H'0003'
BGST             EQU  H'0005'


;----- OSCCON Bits -----------------------------------------------------
SCS0             EQU  H'0000'
SCS1             EQU  H'0001'
PLLEN            EQU  H'0002'
LOCK             EQU  H'0003'

SCS              EQU  H'0000'


;----- T0CON Bits -----------------------------------------------------
PSA              EQU  H'0003'
T0SE             EQU  H'0004'
T0CS             EQU  H'0005'
T08BIT           EQU  H'0006'
TMR0ON           EQU  H'0007'

T0PS0            EQU  H'0000'
T0PS1            EQU  H'0001'
T0PS2            EQU  H'0002'


;----- STATUS Bits -----------------------------------------------------
C                EQU  H'0000'
DC               EQU  H'0001'
Z                EQU  H'0002'
OV               EQU  H'0003'
N                EQU  H'0004'


;----- INTCON3 Bits -----------------------------------------------------
INT1IF           EQU  H'0000'
INT2IF           EQU  H'0001'
INT3IF           EQU  H'0002'
INT1IE           EQU  H'0003'
INT2IE           EQU  H'0004'
INT3IE           EQU  H'0005'
INT1IP           EQU  H'0006'
INT2IP           EQU  H'0007'

INT1F            EQU  H'0000'
INT2F            EQU  H'0001'
INT3F            EQU  H'0002'
INT1E            EQU  H'0003'
INT2E            EQU  H'0004'
INT3E            EQU  H'0005'
INT1P            EQU  H'0006'
INT2P            EQU  H'0007'


;----- INTCON2 Bits -----------------------------------------------------
RBIP             EQU  H'0000'
INT3IP           EQU  H'0001'
TMR0IP           EQU  H'0002'
INTEDG3          EQU  H'0003'
INTEDG2          EQU  H'0004'
INTEDG1          EQU  H'0005'
INTEDG0          EQU  H'0006'
NOT_RBPU         EQU  H'0007'

INT3P            EQU  H'0001'
T0IP             EQU  H'0002'
RBPU             EQU  H'0007'


;----- INTCON Bits -----------------------------------------------------
RBIF             EQU  H'0000'
INT0IF           EQU  H'0001'
TMR0IF           EQU  H'0002'
RBIE             EQU  H'0003'
INT0IE           EQU  H'0004'
TMR0IE           EQU  H'0005'
PEIE_GIEL        EQU  H'0006'
GIE_GIEH         EQU  H'0007'

INT0F            EQU  H'0001'
T0IF             EQU  H'0002'
INT0E            EQU  H'0004'
T0IE             EQU  H'0005'
PEIE             EQU  H'0006'
GIE              EQU  H'0007'

GIEL             EQU  H'0006'
GIEH             EQU  H'0007'


;----- STKPTR Bits -----------------------------------------------------
STKUNF           EQU  H'0006'
STKFUL           EQU  H'0007'

STKPTR0          EQU  H'0000'
STKPTR1          EQU  H'0001'
STKPTR2          EQU  H'0002'
STKPTR3          EQU  H'0003'
STKPTR4          EQU  H'0004'
STKOVF           EQU  H'0007'



;==========================================================================
;
;       RAM Definitions
;
;==========================================================================
       __MAXRAM  H'0FFF'
       __BADRAM  H'0D00'-H'0D5F'
       __BADRAM  H'0D6C'-H'0D6F'
       __BADRAM  H'0D7C'-H'0D7F'
       __BADRAM  H'0D8C'-H'0D8F'
       __BADRAM  H'0D94'-H'0DD3'
       __BADRAM  H'0DD6'-H'0DD7'
       __BADRAM  H'0DD9'-H'0DDF'
       __BADRAM  H'0DE8'-H'0DEF'
       __BADRAM  H'0DF4'-H'0DF7'
       __BADRAM  H'0DF9'
       __BADRAM  H'0DFB'
       __BADRAM  H'0DFD'-H'0E1F'
       __BADRAM  H'0E80'-H'0EFF'
       __BADRAM  H'0F78'
       __BADRAM  H'0F7A'-H'0F7D'
       __BADRAM  H'0F9B'
       __BADRAM  H'0FB7'-H'0FB9'
       __BADRAM  H'0FD4'

;==========================================================================
;
;   IMPORTANT: For the PIC18 devices, the __CONFIG directive has been
;              superseded by the CONFIG directive.  The following settings
;              are available for this device.
;
;   Oscillator:
;     OSC = LP             LP oscillator
;     OSC = XT             XT oscillator
;     OSC = HS             HS oscillator
;     OSC = RC             RC oscillator with OSC2 configured as divide by 4 clock output
;     OSC = EC             EC oscillator with OSC2 configured as divide by 4 clock output
;     OSC = ECIO           EC oscillator with OSC2 configured as RA6
;     OSC = HSPLL          HS oscillator with HW enabled 4x PLL
;     OSC = RCIO           RC oscillator with OSC2 configured as RA6
;     OSC = ECIOPLL        EC oscillator with OSC2 configured as RA6 and HW enabled 4x PLL
;     OSC = ECIOSWPLL      EC oscillator with OSC2 configured as RA6 and SW enabled 4x PLL
;     OSC = HSSWPLL        HS oscillator with SW enabled 4x PLL
;
;   Osc. Switch Enable:
;     OSCS = ON            Timer1 oscillator system clock switch option is enabled (oscillator switching is enabled)
;     OSCS = OFF           Oscillator system clock switch option is disabled (main oscillator is source)
;
;   Power Up Timer:
;     PWRT = ON            PWRT enabled
;     PWRT = OFF           PWRT disabled
;
;   Brown Out Detect:
;     BOR = OFF            Brown-out Reset disabled
;     BOR = ON             Brown-out Reset enabled
;
;   Brown Out Voltage:
;     BORV = 45            VBOR set to 4.5V
;     BORV = 42            VBOR set to 4.2V
;     BORV = 27            VBOR set to 2.7V
;     BORV = 20            VBOR set to 2.0V
;
;   Watchdog Timer:
;     WDT = OFF            WDT disabled (control is placed on the SWDTEN bit)
;     WDT = ON             WDT enabled
;
;   Watchdog Postscaler:
;     WDTPS = 1            1:1
;     WDTPS = 2            1:2
;     WDTPS = 4            1:4
;     WDTPS = 8            1:8
;     WDTPS = 16           1:16
;     WDTPS = 32           1:32
;     WDTPS = 64           1:64
;     WDTPS = 128          1:128
;     WDTPS = 256          1:256
;     WDTPS = 512          1:512
;     WDTPS = 1024         1:1024
;     WDTPS = 2048         1:2048
;     WDTPS = 4096         1:4096
;     WDTPS = 8192         1:8192
;     WDTPS = 16384        1:16384
;     WDTPS = 32768        1:32768
;
;   Processor Mode:
;     MODE = EM            Extended Microcontroller mode
;     MODE = MPB           Microprocessor with Boot Block mode
;     MODE = MP            Microprocessor mode
;     MODE = MC            Microcontroller mode
;
;   External Bus Wait:
;     WAIT = ON            Wait selections for table reads and table writes are determined by WAIT1:WAIT0 bits (MEMCOM<5:4>)
;     WAIT = OFF           Wait selections unavailable for table reads and table writes
;
;   CCP2 Mux:
;     CCP2MX = OFF         CCP2 is multiplexed with RB3 in Extended Microcontroller, Microprocessor or Microprocessor with Boot Block mode. Or with RE7 in Microcontroller mode.
;     CCP2MX = ON          CCP2 input/output is multiplexed with RC1
;
;   ECCP Mux:
;     ECCPMX = PORTH       P1B, P1C are multiplexed with RH7, RH6
;     ECCPMX = PORTE       P1B, P1C are multiplexed with RE6, RE5
;
;   MCLR enable:
;     MCLRE = OFF          RG5 input enabled, MCLR disabled
;     MCLRE = ON           MCLR pin enabled, RG5 input pin disabled
;
;   Stack Overflow Reset:
;     STVR = OFF           Stack full/underflow will not cause Reset
;     STVR = ON            Stack full/underflow will cause Reset
;
;   Low Voltage Program:
;     LVP = OFF            Low-voltage ICSP disabled
;     LVP = ON             Low-voltage ICSP enabled
;
;   Background Debugger Enable bit:
;     DEBUG = ON           Background debugger enabled. RB6 and RB7 are dedicated to in-circuit debug.
;     DEBUG = OFF          Background debugger disabled. RB6 and RB7 configured as general purpose I/O pins.
;
;   Code Protect 000800-0003FFF:
;     CP0 = ON             Block 0 (000800-003FFFh) code-protected
;     CP0 = OFF            Block 0 (000800-003FFFh) not code-protected
;
;   Code Protect 0004000-007FFF:
;     CP1 = ON             Block 1 (004000-007FFFh) code-protected
;     CP1 = OFF            Block 1 (004000-007FFFh) not code-protected
;
;   Code Protect 008000-00BFFF:
;     CP2 = ON             Block 2 (008000-00BFFFh) code-protected
;     CP2 = OFF            Block 2 (008000-00BFFFh) not code-protected
;
;   Code Protect 00C000-00FFFF:
;     CP3 = ON             Block 3 (00C000-00FFFFh)  code-protected
;     CP3 = OFF            Block 3 (00C000-00FFFFh) not code-protected
;
;   Code Protect Boot:
;     CPB = ON             Boot block (000000-0007FFh) code-protected
;     CPB = OFF            Boot block (000000-0007FFh) not code-protected
;
;   Data EE Read Protect:
;     CPD = ON             Data EEPROM code-protected
;     CPD = OFF            Data EEPROM not code-protected
;
;   Table Write Protect 00800-003FFF:
;     WRT0 = ON            Block 0 (000800-003FFFh) write-protected
;     WRT0 = OFF           Block 0 (000800-003FFFh) not write-protected
;
;   Table Write Protect 004000-007FFF:
;     WRT1 = ON            Block 1 (004000-007FFFh) write-protected
;     WRT1 = OFF           Block 1 (004000-007FFFh) not write-protected
;
;   Table Write Protect 08000-0BFFF:
;     WRT2 = ON            Block 2 (008000-00BFFFh) write-protected
;     WRT2 = OFF           Block 2 (008000-00BFFFh) not write-protected
;
;   Table Write Protect 0C000-0FFFF:
;     WRT3 = ON            Block 3 (00C000-00FFFFh) write-protected
;     WRT3 = OFF           Block 3 (00C000-00FFFFh) not write-protected
;
;   Config. Write Protect:
;     WRTC = ON            Configuration registers (300000-3000FFh) write-protected
;     WRTC = OFF           Configuration registers (300000-3000FFh) not write-protected
;
;   Table Write Protect Boot:
;     WRTB = ON            Boot block (000000-0007FFh) write-protected
;     WRTB = OFF           Boot block (000000-0007FFh) not write-protected
;
;   Data EE Write Protect:
;     WRTD = ON            Data EEPROM write-protected
;     WRTD = OFF           Data EEPROM not write-protected
;
;   Table Read Protect 00800-003FFF:
;     EBTR0 = ON           Block 0 (000800-003FFFh) protected from table reads executed in other blocks
;     EBTR0 = OFF          Block 0 (000800-003FFFh) not protected from table reads executed in other blocks
;
;   Table Read Protect 004000-07FFF:
;     EBTR1 = ON           Block 1 (004000-007FFFh) protected from table reads executed in other blocks
;     EBTR1 = OFF          Block 1 (004000-007FFFh) not protected from table reads executed in other blocks
;
;   Table Read Protect 08000-0BFFF:
;     EBTR2 = ON           Block 2 (008000-00BFFFh) protected from table reads executed in other blocks
;     EBTR2 = OFF          Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks
;
;   Table Read Protect 0C000-0FFFF:
;     EBTR3 = ON           Block 3 (00C000-00FFFFh) protected from table reads executed in other blocks
;     EBTR3 = OFF          Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks
;
;   Table Read Protect Boot:
;     EBTRB = ON           Boot block (000000-0007FFh) protected from table reads executed in other blocks
;     EBTRB = OFF          Boot block (000000-0007FFh) not protected from table reads executed in other blocks
;
;==========================================================================
;==========================================================================
;
;       Configuration Bits
;
;   NAME            Address
;   CONFIG1H        300001h
;   CONFIG2L        300002h
;   CONFIG2H        300003h
;   CONFIG3L        300004h
;   CONFIG3H        300005h
;   CONFIG4L        300006h
;   CONFIG5L        300008h
;   CONFIG5H        300009h
;   CONFIG6L        30000Ah
;   CONFIG6H        30000Bh
;   CONFIG7L        30000Ch
;   CONFIG7H        30000Dh
;
;==========================================================================

; The following is an assignment of address values for all of the
; configuration registers for the purpose of table reads
_CONFIG1H        EQU  H'300001'
_CONFIG2L        EQU  H'300002'
_CONFIG2H        EQU  H'300003'
_CONFIG3L        EQU  H'300004'
_CONFIG3H        EQU  H'300005'
_CONFIG4L        EQU  H'300006'
_CONFIG5L        EQU  H'300008'
_CONFIG5H        EQU  H'300009'
_CONFIG6L        EQU  H'30000A'
_CONFIG6H        EQU  H'30000B'
_CONFIG7L        EQU  H'30000C'
_CONFIG7H        EQU  H'30000D'

;----- CONFIG1H Options --------------------------------------------------
_OSC_LP_1H           EQU  H'F0'    ; LP oscillator
_OSC_XT_1H           EQU  H'F1'    ; XT oscillator
_OSC_HS_1H           EQU  H'F2'    ; HS oscillator
_OSC_RC_1H           EQU  H'F3'    ; RC oscillator with OSC2 configured as divide by 4 clock output
_OSC_EC_1H           EQU  H'F4'    ; EC oscillator with OSC2 configured as divide by 4 clock output
_OSC_ECIO_1H         EQU  H'F5'    ; EC oscillator with OSC2 configured as RA6
_OSC_HSPLL_1H        EQU  H'F6'    ; HS oscillator with HW enabled 4x PLL
_OSC_RCIO_1H         EQU  H'F7'    ; RC oscillator with OSC2 configured as RA6
_OSC_ECIOPLL_1H      EQU  H'FC'    ; EC oscillator with OSC2 configured as RA6 and HW enabled 4x PLL
_OSC_ECIOSWPLL_1H    EQU  H'FD'    ; EC oscillator with OSC2 configured as RA6 and SW enabled 4x PLL
_OSC_HSSWPLL_1H      EQU  H'FE'    ; HS oscillator with SW enabled 4x PLL

_OSCS_ON_1H          EQU  H'DF'    ; Timer1 oscillator system clock switch option is enabled (oscillator switching is enabled)
_OSCS_OFF_1H         EQU  H'FF'    ; Oscillator system clock switch option is disabled (main oscillator is source)

;----- CONFIG2L Options --------------------------------------------------
_PWRT_ON_2L          EQU  H'FE'    ; PWRT enabled
_PWRT_OFF_2L         EQU  H'FF'    ; PWRT disabled

_BOR_OFF_2L          EQU  H'FD'    ; Brown-out Reset disabled
_BOR_ON_2L           EQU  H'FF'    ; Brown-out Reset enabled

_BORV_45_2L          EQU  H'F3'    ; VBOR set to 4.5V
_BORV_42_2L          EQU  H'F7'    ; VBOR set to 4.2V
_BORV_27_2L          EQU  H'FB'    ; VBOR set to 2.7V
_BORV_20_2L          EQU  H'FF'    ; VBOR set to 2.0V

;----- CONFIG2H Options --------------------------------------------------
_WDT_OFF_2H          EQU  H'FE'    ; WDT disabled (control is placed on the SWDTEN bit)
_WDT_ON_2H           EQU  H'FF'    ; WDT enabled

_WDTPS_1_2H          EQU  H'E1'    ; 1:1
_WDTPS_2_2H          EQU  H'E3'    ; 1:2
_WDTPS_4_2H          EQU  H'E5'    ; 1:4
_WDTPS_8_2H          EQU  H'E7'    ; 1:8
_WDTPS_16_2H         EQU  H'E9'    ; 1:16
_WDTPS_32_2H         EQU  H'EB'    ; 1:32
_WDTPS_64_2H         EQU  H'ED'    ; 1:64
_WDTPS_128_2H        EQU  H'EF'    ; 1:128
_WDTPS_256_2H        EQU  H'F1'    ; 1:256
_WDTPS_512_2H        EQU  H'F3'    ; 1:512
_WDTPS_1024_2H       EQU  H'F5'    ; 1:1024
_WDTPS_2048_2H       EQU  H'F7'    ; 1:2048
_WDTPS_4096_2H       EQU  H'F9'    ; 1:4096
_WDTPS_8192_2H       EQU  H'FB'    ; 1:8192
_WDTPS_16384_2H      EQU  H'FD'    ; 1:16384
_WDTPS_32768_2H      EQU  H'FF'    ; 1:32768

;----- CONFIG3L Options --------------------------------------------------
_MODE_EM_3L          EQU  H'FC'    ; Extended Microcontroller mode
_MODE_MPB_3L         EQU  H'FD'    ; Microprocessor with Boot Block mode
_MODE_MP_3L          EQU  H'FE'    ; Microprocessor mode
_MODE_MC_3L          EQU  H'FF'    ; Microcontroller mode

_WAIT_ON_3L          EQU  H'7F'    ; Wait selections for table reads and table writes are determined by WAIT1:WAIT0 bits (MEMCOM<5:4>)
_WAIT_OFF_3L         EQU  H'FF'    ; Wait selections unavailable for table reads and table writes

;----- CONFIG3H Options --------------------------------------------------
_CCP2MX_OFF_3H       EQU  H'FE'    ; CCP2 is multiplexed with RB3 in Extended Microcontroller, Microprocessor or Microprocessor with Boot Block mode. Or with RE7 in Microcontroller mode.
_CCP2MX_ON_3H        EQU  H'FF'    ; CCP2 input/output is multiplexed with RC1

_ECCPMX_PORTH_3H     EQU  H'FD'    ; P1B, P1C are multiplexed with RH7, RH6
_ECCPMX_PORTE_3H     EQU  H'FF'    ; P1B, P1C are multiplexed with RE6, RE5

_MCLRE_OFF_3H        EQU  H'7F'    ; RG5 input enabled, MCLR disabled
_MCLRE_ON_3H         EQU  H'FF'    ; MCLR pin enabled, RG5 input pin disabled

;----- CONFIG4L Options --------------------------------------------------
_STVR_OFF_4L         EQU  H'FE'    ; Stack full/underflow will not cause Reset
_STVR_ON_4L          EQU  H'FF'    ; Stack full/underflow will cause Reset

_LVP_OFF_4L          EQU  H'FB'    ; Low-voltage ICSP disabled
_LVP_ON_4L           EQU  H'FF'    ; Low-voltage ICSP enabled

_DEBUG_ON_4L         EQU  H'7F'    ; Background debugger enabled. RB6 and RB7 are dedicated to in-circuit debug.
_DEBUG_OFF_4L        EQU  H'FF'    ; Background debugger disabled. RB6 and RB7 configured as general purpose I/O pins.

;----- CONFIG5L Options --------------------------------------------------
_CP0_ON_5L           EQU  H'FE'    ; Block 0 (000800-003FFFh) code-protected
_CP0_OFF_5L          EQU  H'FF'    ; Block 0 (000800-003FFFh) not code-protected

_CP1_ON_5L           EQU  H'FD'    ; Block 1 (004000-007FFFh) code-protected
_CP1_OFF_5L          EQU  H'FF'    ; Block 1 (004000-007FFFh) not code-protected

_CP2_ON_5L           EQU  H'FB'    ; Block 2 (008000-00BFFFh) code-protected
_CP2_OFF_5L          EQU  H'FF'    ; Block 2 (008000-00BFFFh) not code-protected

_CP3_ON_5L           EQU  H'F7'    ; Block 3 (00C000-00FFFFh)  code-protected
_CP3_OFF_5L          EQU  H'FF'    ; Block 3 (00C000-00FFFFh) not code-protected

;----- CONFIG5H Options --------------------------------------------------
_CPB_ON_5H           EQU  H'BF'    ; Boot block (000000-0007FFh) code-protected
_CPB_OFF_5H          EQU  H'FF'    ; Boot block (000000-0007FFh) not code-protected

_CPD_ON_5H           EQU  H'7F'    ; Data EEPROM code-protected
_CPD_OFF_5H          EQU  H'FF'    ; Data EEPROM not code-protected

;----- CONFIG6L Options --------------------------------------------------
_WRT0_ON_6L          EQU  H'FE'    ; Block 0 (000800-003FFFh) write-protected
_WRT0_OFF_6L         EQU  H'FF'    ; Block 0 (000800-003FFFh) not write-protected

_WRT1_ON_6L          EQU  H'FD'    ; Block 1 (004000-007FFFh) write-protected
_WRT1_OFF_6L         EQU  H'FF'    ; Block 1 (004000-007FFFh) not write-protected

_WRT2_ON_6L          EQU  H'FB'    ; Block 2 (008000-00BFFFh) write-protected
_WRT2_OFF_6L         EQU  H'FF'    ; Block 2 (008000-00BFFFh) not write-protected

_WRT3_ON_6L          EQU  H'F7'    ; Block 3 (00C000-00FFFFh) write-protected
_WRT3_OFF_6L         EQU  H'FF'    ; Block 3 (00C000-00FFFFh) not write-protected

;----- CONFIG6H Options --------------------------------------------------
_WRTC_ON_6H          EQU  H'DF'    ; Configuration registers (300000-3000FFh) write-protected
_WRTC_OFF_6H         EQU  H'FF'    ; Configuration registers (300000-3000FFh) not write-protected

_WRTB_ON_6H          EQU  H'BF'    ; Boot block (000000-0007FFh) write-protected
_WRTB_OFF_6H         EQU  H'FF'    ; Boot block (000000-0007FFh) not write-protected

_WRTD_ON_6H          EQU  H'7F'    ; Data EEPROM write-protected
_WRTD_OFF_6H         EQU  H'FF'    ; Data EEPROM not write-protected

;----- CONFIG7L Options --------------------------------------------------
_EBTR0_ON_7L         EQU  H'FE'    ; Block 0 (000800-003FFFh) protected from table reads executed in other blocks
_EBTR0_OFF_7L        EQU  H'FF'    ; Block 0 (000800-003FFFh) not protected from table reads executed in other blocks

_EBTR1_ON_7L         EQU  H'FD'    ; Block 1 (004000-007FFFh) protected from table reads executed in other blocks
_EBTR1_OFF_7L        EQU  H'FF'    ; Block 1 (004000-007FFFh) not protected from table reads executed in other blocks

_EBTR2_ON_7L         EQU  H'FB'    ; Block 2 (008000-00BFFFh) protected from table reads executed in other blocks
_EBTR2_OFF_7L        EQU  H'FF'    ; Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks

_EBTR3_ON_7L         EQU  H'F7'    ; Block 3 (00C000-00FFFFh) protected from table reads executed in other blocks
_EBTR3_OFF_7L        EQU  H'FF'    ; Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks

;----- CONFIG7H Options --------------------------------------------------
_EBTRB_ON_7H         EQU  H'BF'    ; Boot block (000000-0007FFh) protected from table reads executed in other blocks
_EBTRB_OFF_7H        EQU  H'FF'    ; Boot block (000000-0007FFh) not protected from table reads executed in other blocks


;----- DEVID Equates --------------------------------------------------
_DEVID1          EQU  H'3FFFFE'
_DEVID2          EQU  H'3FFFFF'

;----- IDLOC Equates --------------------------------------------------
_IDLOC0          EQU  H'200000'
_IDLOC1          EQU  H'200001'
_IDLOC2          EQU  H'200002'
_IDLOC3          EQU  H'200003'
_IDLOC4          EQU  H'200004'
_IDLOC5          EQU  H'200005'
_IDLOC6          EQU  H'200006'
_IDLOC7          EQU  H'200007'

        LIST
