/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.model;

import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.Location;
import org.python.pydev.parser.jython.SimpleNode;

public class ItemPointer {
    public final Object file;
    public final Location start;
    public final Location end;
    public final Definition definition;
    public final String zipFilePath;

    public ItemPointer(Object file) {
        this(file, new Location(), new Location());
    }

    public ItemPointer(Object file, SimpleNode n) {
        int line = n.beginLine;
        int col = n.beginColumn;
        this.file = file;
        this.start = new Location(line - 1, col - 1);
        this.end = new Location(line - 1, col - 1);
        this.definition = null;
        this.zipFilePath = null;
    }

    public ItemPointer(Object file, Location start, Location end) {
        this(file, start, end, null, null);
    }

    public ItemPointer(Object file, Location start, Location end, Definition definition, String zipFilePath) {
        this.file = file;
        this.start = start;
        this.end = end;
        this.definition = definition;
        this.zipFilePath = zipFilePath;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ItemPointer [");
        buffer.append(this.file);
        buffer.append(" - ");
        buffer.append(this.start);
        buffer.append(" - ");
        buffer.append(this.end);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemPointer)) {
            return false;
        }
        ItemPointer i = (ItemPointer)obj;
        if (!i.file.equals(this.file)) {
            return false;
        }
        if (!i.start.equals(this.start)) {
            return false;
        }
        return i.end.equals(this.end);
    }

    public int hashCode() {
        int colLineBasedHash = (this.end.column + this.start.line + 7) * 3;
        if (this.file != null) {
            return this.file.hashCode() + colLineBasedHash;
        }
        return colLineBasedHash;
    }
}

