/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.CipherStrings;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class SSLContext
extends RubyObject {
    private static final long serialVersionUID = -6203496135962974777L;
    private static final HashMap<String, String> SSL_VERSION_OSSL2JSSE = new LinkedHashMap<String, String>(16);
    private static final Map<String, String[]> ENABLED_PROTOCOLS = new HashMap<String, String[]>(8);
    private static ObjectAllocator SSLCONTEXT_ALLOCATOR;
    private String ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
    private String protocol = "SSL";
    private boolean protocolForServer = true;
    private boolean protocolForClient = true;
    private PKey t_key;
    private X509Cert t_cert;
    private int verifyResult = 1;
    private InternalContext internalContext;

    public static void createSSLContext(Ruby runtime, RubyModule _SSL) {
        RubyClass _SSLContext = _SSL.defineClassUnder("SSLContext", runtime.getObject(), SSLCONTEXT_ALLOCATOR);
        String[] attributes = new String[]{"cert", "key", "client_ca", "ca_file", "ca_path", "timeout", "verify_mode", "verify_depth", "verify_callback", "options", "cert_store", "extra_chain_cert", "client_cert_cb", "tmp_dh_callback", "session_id_context"};
        ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < attributes.length; ++i) {
            _SSLContext.addReadWriteAttribute(context, attributes[i]);
        }
        _SSLContext.defineAlias("ssl_timeout", "timeout");
        _SSLContext.defineAlias("ssl_timeout=", "timeout=");
        _SSLContext.defineAnnotatedMethods(SSLContext.class);
        Set<String> methodKeys = SSL_VERSION_OSSL2JSSE.keySet();
        RubyArray methods = runtime.newArray(methodKeys.size());
        for (String method : methodKeys) {
            methods.append((IRubyObject)runtime.newSymbol(method));
        }
        _SSLContext.defineConstant("METHODS", (IRubyObject)methods);
    }

    public SSLContext(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static RaiseException newSSLError(Ruby runtime, String message) {
        RubyModule _SSL = (RubyModule)runtime.getModule("OpenSSL").getConstant("SSL");
        return Utils.newError(runtime, _SSL.getClass("SSLError"), message, false);
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args) {
        return this;
    }

    @JRubyMethod
    public IRubyObject setup(ThreadContext context) {
        X509Cert cert;
        PKey key;
        Ruby runtime = context.runtime;
        if (this.isFrozen()) {
            return runtime.getNil();
        }
        this.freeze(context);
        this.internalContext = new InternalContext();
        this.internalContext.protocol = this.protocol;
        this.internalContext.protocolForServer = this.protocolForServer;
        this.internalContext.protocolForClient = this.protocolForClient;
        X509Store certStore = this.getCertStore();
        this.internalContext.store = certStore != null ? certStore.getStore() : new Store();
        IRubyObject value = this.getInstanceVariable("@extra_chain_cert");
        if (value != null && !value.isNil()) {
            this.internalContext.extraChainCert = new ArrayList<X509AuxCertificate>();
            for (X509Cert x : this.convertToX509Certs(context, value)) {
                this.internalContext.extraChainCert.add(x.getAuxCert());
            }
        }
        if ((value = this.getInstanceVariable("@key")) != null && !value.isNil()) {
            if (!(value instanceof PKey)) {
                throw runtime.newTypeError("OpenSSL::PKey::PKey expected but got @key = " + value.inspect());
            }
            key = (PKey)value;
        } else {
            key = this.getCallbackKey(context);
        }
        value = this.getInstanceVariable("@cert");
        if (value != null && !value.isNil()) {
            if (!(value instanceof X509Cert)) {
                throw runtime.newTypeError("OpenSSL::X509::Certificate expected but got @cert = " + value.inspect());
            }
            cert = (X509Cert)value;
        } else {
            cert = this.getCallbackCert(context);
        }
        if (key != null && cert != null) {
            this.internalContext.keyAlgorithm = key.getAlgorithm();
            this.internalContext.privateKey = key.getPrivateKey();
            this.internalContext.cert = cert.getAuxCert();
        }
        if ((value = this.getInstanceVariable("@client_ca")) != null && !value.isNil()) {
            if (value.respondsTo("each")) {
                for (X509Cert x : this.convertToX509Certs(context, value)) {
                    this.internalContext.clientCert.add(x.getAuxCert());
                }
            } else {
                if (!(value instanceof X509Cert)) {
                    throw runtime.newTypeError("OpenSSL::X509::Certificate expected but got @client_ca = " + value.inspect());
                }
                this.internalContext.clientCert.add(((X509Cert)value).getAuxCert());
            }
        }
        String caFile = this.getCaFile();
        String caPath = this.getCaPath();
        if (caFile != null || caPath != null) {
            try {
                if (this.internalContext.store.loadLocations(caFile, caPath) == 0) {
                    runtime.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, "can't set verify locations");
                }
            }
            catch (Exception e) {
                throw SSLContext.newSSLError(runtime, e.getMessage());
            }
        }
        this.internalContext.verifyMode = (value = this.getInstanceVariable("@verify_mode")) != null && !value.isNil() ? RubyNumeric.fix2int((IRubyObject)value) : 0;
        value = this.getInstanceVariable("@verify_callback");
        if (value != null && !value.isNil()) {
            this.internalContext.store.setExtraData(1, value);
        } else {
            this.internalContext.store.setExtraData(1, null);
        }
        value = this.getInstanceVariable("@timeout");
        if (value != null && !value.isNil()) {
            this.internalContext.timeout = RubyNumeric.fix2int((IRubyObject)value);
        }
        if ((value = this.getInstanceVariable("@verify_depth")) != null && !value.isNil()) {
            this.internalContext.store.setDepth(RubyNumeric.fix2int((IRubyObject)value));
        } else {
            this.internalContext.store.setDepth(-1);
        }
        try {
            this.internalContext.init();
        }
        catch (GeneralSecurityException gse) {
            throw SSLContext.newSSLError(runtime, gse.getMessage());
        }
        return runtime.getTrue();
    }

    @JRubyMethod
    public IRubyObject ciphers(ThreadContext context) {
        return context.runtime.newArray(this.matchedCiphers(context));
    }

    private List<RubyArray> matchedCiphers(ThreadContext context) {
        Ruby runtime = context.runtime;
        ArrayList<RubyArray> cipherList = new ArrayList<RubyArray>();
        try {
            String[] supported = this.getCipherSuites(this.createDummySSLEngine());
            List<CipherStrings.Def> ciphs = CipherStrings.getMatchingCiphers(this.ciphers, supported);
            cipherList.ensureCapacity(ciphs.size());
            for (CipherStrings.Def def : ciphs) {
                RubyArray cipher = runtime.newArray(4);
                cipher.set(0, (Object)runtime.newString(def.name));
                cipher.set(1, (Object)runtime.newString(this.sslVersionString(def.algorithms)));
                cipher.set(2, (Object)runtime.newFixnum(def.strength_bits));
                cipher.set(3, (Object)runtime.newFixnum(def.alg_bits));
                cipherList.add(cipher);
            }
        }
        catch (GeneralSecurityException gse) {
            throw SSLContext.newSSLError(runtime, gse.getMessage());
        }
        return cipherList;
    }

    @JRubyMethod(name={"ciphers="})
    public IRubyObject set_ciphers(ThreadContext context, IRubyObject val) {
        if (val.isNil()) {
            this.ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
        } else if (val instanceof RubyArray) {
            StringBuilder builder = new StringBuilder();
            String sep = "";
            for (IRubyObject obj : ((RubyArray)val).toJavaArray()) {
                builder.append(sep).append(obj.toString());
                sep = ":";
            }
            this.ciphers = builder.toString();
        } else {
            this.ciphers = val.convertToString().toString();
            if (this.ciphers.equals("DEFAULT")) {
                this.ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
            }
        }
        if (this.matchedCiphers(context).isEmpty()) {
            throw SSLContext.newSSLError(context.runtime, "no cipher match");
        }
        return val;
    }

    @JRubyMethod(name={"ssl_version="})
    public IRubyObject set_ssl_version(IRubyObject version) {
        String versionStr = version instanceof RubyString ? version.convertToString().toString() : version.toString();
        String mapped = SSL_VERSION_OSSL2JSSE.get(versionStr);
        if (mapped == null) {
            throw SSLContext.newSSLError(this.getRuntime(), String.format("unknown SSL method `%s'.", versionStr));
        }
        this.protocol = mapped;
        this.protocolForServer = !versionStr.endsWith("_client");
        this.protocolForClient = !versionStr.endsWith("_server");
        return version;
    }

    boolean isProtocolForServer() {
        return this.protocolForServer;
    }

    boolean isProtocolForClient() {
        return this.protocolForClient;
    }

    int getLastVerifyResult() {
        return this.verifyResult;
    }

    void setLastVerifyResult(int verifyResult) {
        this.verifyResult = verifyResult;
    }

    SSLEngine createDummySSLEngine() throws GeneralSecurityException {
        javax.net.ssl.SSLContext sslContext = SecurityHelper.getSSLContext(this.protocol);
        sslContext.init(null, null, null);
        return sslContext.createSSLEngine();
    }

    SSLEngine createSSLEngine(String peerHost, int peerPort) throws NoSuchAlgorithmException, KeyManagementException {
        SSLEngine engine = peerHost == null || peerHost.length() == 0 ? this.internalContext.getSSLContext().createSSLEngine() : this.internalContext.getSSLContext().createSSLEngine(peerHost, peerPort);
        engine.setEnabledCipherSuites(this.getCipherSuites(engine));
        engine.setEnabledProtocols(this.getEnabledProtocols(engine));
        return engine;
    }

    private String[] getCipherSuites(SSLEngine engine) {
        List<CipherStrings.Def> ciphs = CipherStrings.getMatchingCiphers(this.ciphers, engine.getSupportedCipherSuites());
        String[] result = new String[ciphs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ciphs.get((int)i).cipherSuite;
        }
        return result;
    }

    private String[] getEnabledProtocols(SSLEngine engine) {
        ArrayList<String> candidates = new ArrayList<String>();
        long options = this.getOptions();
        String[] enabledProtocols = ENABLED_PROTOCOLS.get(this.protocol);
        if (enabledProtocols != null) {
            String[] engineProtocols = engine.getEnabledProtocols();
            for (String enabled : enabledProtocols) {
                if ((options & 0x1000000L) != 0L && enabled.equals("SSLv2") || (options & 0x2000000L) != 0L && enabled.equals("SSLv3") || (options & 0x4000000L) != 0L && enabled.equals("TLSv1")) continue;
                for (String allowed : engineProtocols) {
                    if (!allowed.equals(enabled)) continue;
                    candidates.add(allowed);
                }
            }
        }
        return candidates.toArray(new String[candidates.size()]);
    }

    private String sslVersionString(long bits) {
        StringBuilder sb = new StringBuilder(17);
        boolean first = true;
        if ((bits & 0x2000000L) != 0L) {
            if (!first) {
                sb.append('/');
            }
            first = false;
            sb.append("TLSv1/SSLv3");
        }
        if ((bits & 0x1000000L) != 0L) {
            if (!first) {
                sb.append('/');
            }
            sb.append("SSLv2");
        }
        return sb.toString();
    }

    private PKey getCallbackKey(ThreadContext context) {
        if (this.t_key != null) {
            return this.t_key;
        }
        this.initFromCallback(context);
        return this.t_key;
    }

    private X509Cert getCallbackCert(ThreadContext context) {
        if (this.t_cert != null) {
            return this.t_cert;
        }
        this.initFromCallback(context);
        return this.t_cert;
    }

    private void initFromCallback(ThreadContext context) {
        IRubyObject callback = this.getInstanceVariable("@client_cert_cb");
        if (callback != null && !callback.isNil()) {
            IRubyObject arr = callback.callMethod(context, "call", (IRubyObject)this);
            if (!(arr instanceof RubyArray)) {
                throw context.runtime.newTypeError("expected @client_cert_cb.call to return an Array but got: " + arr.getMetaClass().getName());
            }
            IRubyObject cert = ((RubyArray)arr).entry(0);
            IRubyObject key = ((RubyArray)arr).entry(1);
            if (!(cert instanceof X509Cert)) {
                throw context.runtime.newTypeError(cert.inspect() + " is not an instance of OpenSSL::X509::Certificate");
            }
            if (!(key instanceof PKey)) {
                throw context.runtime.newTypeError(key.inspect() + " is not an instance of OpenSSL::PKey::PKey");
            }
            this.t_cert = (X509Cert)cert;
            this.t_key = (PKey)key;
        }
    }

    private X509Store getCertStore() {
        IRubyObject value = this.getInstanceVariable("@cert_store");
        if (value instanceof X509Store) {
            return (X509Store)value;
        }
        return null;
    }

    private String getCaFile() {
        IRubyObject value = this.getInstanceVariable("@ca_file");
        if (value != null && !value.isNil()) {
            return value.convertToString().toString();
        }
        return null;
    }

    private String getCaPath() {
        IRubyObject value = this.getInstanceVariable("@ca_path");
        if (value != null && !value.isNil()) {
            return value.convertToString().toString();
        }
        return null;
    }

    private long getOptions() {
        IRubyObject value = this.getInstanceVariable("@options");
        if (value != null && !value.isNil()) {
            return RubyNumeric.fix2long((IRubyObject)value);
        }
        return 0L;
    }

    private X509Cert[] convertToX509Certs(ThreadContext context, IRubyObject value) {
        final ArrayList result = new ArrayList();
        RubyModule _SSLContext = context.runtime.getClassFromPath("OpenSSL::SSL::SSLContext");
        final RubyModule _Certificate = context.runtime.getClassFromPath("OpenSSL::X509::Certificate");
        Utils.invoke(context, value, "each", CallBlock.newCallClosure((IRubyObject)value, (RubyModule)_SSLContext, (Arity)Arity.NO_ARGUMENTS, (BlockCallback)new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
                IRubyObject cert = args[0];
                if (_Certificate.isInstance(cert)) {
                    throw context.runtime.newTypeError("wrong argument : " + cert.inspect() + " is not a " + _Certificate.getName());
                }
                result.add((X509Cert)cert);
                return context.runtime.getNil();
            }
        }, (ThreadContext)context));
        return result.toArray(new X509Cert[result.size()]);
    }

    static {
        SSL_VERSION_OSSL2JSSE.put("TLSv1", "TLSv1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_server", "TLSv1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_client", "TLSv1");
        ENABLED_PROTOCOLS.put("TLSv1", new String[]{"TLSv1"});
        SSL_VERSION_OSSL2JSSE.put("SSLv2", "SSLv2");
        SSL_VERSION_OSSL2JSSE.put("SSLv2_server", "SSLv2");
        SSL_VERSION_OSSL2JSSE.put("SSLv2_client", "SSLv2");
        ENABLED_PROTOCOLS.put("SSLv2", new String[]{"SSLv2"});
        SSL_VERSION_OSSL2JSSE.put("SSLv3", "SSLv3");
        SSL_VERSION_OSSL2JSSE.put("SSLv3_server", "SSLv3");
        SSL_VERSION_OSSL2JSSE.put("SSLv3_client", "SSLv3");
        ENABLED_PROTOCOLS.put("SSLv3", new String[]{"SSLv3"});
        SSL_VERSION_OSSL2JSSE.put("SSLv23", "SSL");
        SSL_VERSION_OSSL2JSSE.put("SSLv23_server", "SSL");
        SSL_VERSION_OSSL2JSSE.put("SSLv23_client", "SSL");
        ENABLED_PROTOCOLS.put("SSL", new String[]{"SSLv2", "SSLv3", "TLSv1"});
        SSL_VERSION_OSSL2JSSE.put("TLS", "TLS");
        ENABLED_PROTOCOLS.put("TLS", new String[]{"TLSv1", "TLSv1.1"});
        SSL_VERSION_OSSL2JSSE.put("TLSv1.1", "TLSv1.1");
        ENABLED_PROTOCOLS.put("TLSv1.1", new String[]{"TLSv1.1"});
        SSLCONTEXT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new SSLContext(runtime, klass);
            }
        };
    }

    private static class TrustManagerImpl
    implements X509TrustManager {
        final InternalContext internalContext;

        TrustManagerImpl(InternalContext internalContext) {
            this.internalContext = internalContext;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted("ssl_client", chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted("ssl_server", chain);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            if (this.internalContext == null) {
                return null;
            }
            ArrayList<X509AuxCertificate> chain = new ArrayList<X509AuxCertificate>();
            chain.addAll(this.internalContext.clientCert);
            return chain.toArray(new X509Certificate[0]);
        }

        private void checkTrusted(String purpose, X509Certificate[] chain) throws CertificateException {
            if (this.internalContext == null) {
                throw new CertificateException("uninitialized trust manager");
            }
            if (chain != null && chain.length > 0) {
                if ((this.internalContext.verifyMode & 1) != 0) {
                    StoreContext storeContext = this.internalContext.createStoreContext(purpose);
                    if (storeContext == null) {
                        throw new CertificateException("couldn't initialize store");
                    }
                    storeContext.setCertificate(chain[0]);
                    storeContext.setChain(chain);
                    this.verifyChain(storeContext);
                }
            } else if ((this.internalContext.verifyMode & 2) != 0) {
                throw new CertificateException("no peer certificate");
            }
        }

        private void verifyChain(StoreContext storeContext) throws CertificateException {
            try {
                int ok = storeContext.verifyCertificate();
                this.internalContext.setLastVerifyResultInternal(storeContext.error);
                if (ok == 0) {
                    throw new CertificateException("certificate verify failed");
                }
            }
            catch (Exception e) {
                this.internalContext.setLastVerifyResultInternal(storeContext.error);
                if (storeContext.error == 0) {
                    this.internalContext.setLastVerifyResultInternal(28);
                }
                throw new CertificateException("certificate verify failed", e);
            }
        }
    }

    private static class KeyManagerImpl
    extends X509ExtendedKeyManager {
        final InternalContext internalContext;

        KeyManagerImpl(InternalContext internalContext) {
            this.internalContext = internalContext;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            if (this.internalContext == null) {
                return null;
            }
            if (this.internalContext.privateKey == null) {
                return null;
            }
            for (int i = 0; i < keyType.length; ++i) {
                if (!keyType[i].equalsIgnoreCase(this.internalContext.keyAlgorithm)) continue;
                return keyType[i];
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            if (this.internalContext == null || this.internalContext.privateKey == null) {
                return null;
            }
            if (keyType.equalsIgnoreCase(this.internalContext.keyAlgorithm)) {
                return keyType;
            }
            return null;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            if (this.internalContext == null) {
                return null;
            }
            ArrayList<X509AuxCertificate> chain = new ArrayList<X509AuxCertificate>();
            if (this.internalContext.extraChainCert != null) {
                chain.addAll(this.internalContext.extraChainCert);
            } else if (this.internalContext.cert != null) {
                StoreContext storeCtx = this.internalContext.createStoreContext(null);
                X509AuxCertificate x = this.internalContext.cert;
                while (true) {
                    chain.add(x);
                    if (x.getIssuerDN().equals(x.getSubjectDN())) break;
                    try {
                        Name xn = new Name(x.getIssuerX500Principal());
                        X509Object[] s_obj = new X509Object[1];
                        if (storeCtx.getBySubject(1, xn, s_obj) <= 0) break;
                        x = ((Certificate)s_obj[0]).x509;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
            }
            return chain.toArray(new X509Certificate[0]);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return null;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            if (this.internalContext == null || this.internalContext.privateKey == null) {
                return null;
            }
            return this.internalContext.privateKey;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return null;
        }
    }

    private class InternalContext {
        Store store = null;
        int verifyMode = 0;
        X509AuxCertificate cert;
        String keyAlgorithm;
        PrivateKey privateKey;
        List<X509AuxCertificate> extraChainCert;
        final List<X509AuxCertificate> clientCert = new ArrayList<X509AuxCertificate>();
        int timeout = 0;
        String protocol = null;
        boolean protocolForServer = true;
        boolean protocolForClient = true;
        private javax.net.ssl.SSLContext sslContext;

        private InternalContext() {
        }

        void setLastVerifyResultInternal(int lastVerifyResult) {
            SSLContext.this.setLastVerifyResult(lastVerifyResult);
        }

        javax.net.ssl.SSLContext getSSLContext() {
            return this.sslContext;
        }

        void init() throws GeneralSecurityException {
            this.sslContext = SecurityHelper.getSSLContext(this.protocol);
            if (this.protocolForClient) {
                this.sslContext.getClientSessionContext().setSessionTimeout(this.timeout);
            }
            if (this.protocolForServer) {
                this.sslContext.getServerSessionContext().setSessionTimeout(this.timeout);
            }
            this.sslContext.init(new KeyManager[]{new KeyManagerImpl(this)}, new TrustManager[]{new TrustManagerImpl(this)}, null);
        }

        StoreContext createStoreContext(String purpose) {
            if (this.store == null) {
                return null;
            }
            StoreContext storeContext = new StoreContext();
            if (storeContext.init(this.store, null, null) == 0) {
                return null;
            }
            storeContext.setExtraData(1, this.store.getExtraData(1));
            if (purpose != null) {
                storeContext.setDefault(purpose);
            }
            storeContext.verifyParameter.inherit(this.store.verifyParameter);
            return storeContext;
        }
    }
}

