/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyRSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 3675324750727019454L;
    private static ObjectAllocator PKEYRSA_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKeyRSA(runtime, klass);
        }
    };
    private volatile transient RSAPrivateCrtKey privKey;
    private volatile transient RSAPublicKey pubKey;
    private volatile transient BigInteger rsa_e;
    private volatile transient BigInteger rsa_n;
    private volatile transient BigInteger rsa_d;
    private volatile transient BigInteger rsa_p;
    private volatile transient BigInteger rsa_q;
    private volatile transient BigInteger rsa_dmp1;
    private volatile transient BigInteger rsa_dmq1;
    private volatile transient BigInteger rsa_iqmp;

    public static void createPKeyRSA(Ruby runtime, RubyModule _PKey) {
        RubyClass _RSA = _PKey.defineClassUnder("RSA", _PKey.getClass("PKey"), PKEYRSA_ALLOCATOR);
        RubyClass _PKeyError = _PKey.getClass("PKeyError");
        _PKey.defineClassUnder("RSAError", _PKeyError, _PKeyError.getAllocator());
        _RSA.defineAnnotatedMethods(PKeyRSA.class);
        _RSA.setConstant("PKCS1_PADDING", (IRubyObject)runtime.newFixnum(1));
        _RSA.setConstant("SSLV23_PADDING", (IRubyObject)runtime.newFixnum(2));
        _RSA.setConstant("NO_PADDING", (IRubyObject)runtime.newFixnum(3));
        _RSA.setConstant("PKCS1_OAEP_PADDING", (IRubyObject)runtime.newFixnum(4));
    }

    static RubyClass _RSA(Ruby runtime) {
        return PKeyRSA._PKey(runtime).getClass("RSA");
    }

    public static RaiseException newRSAError(Ruby runtime, String message) {
        return Utils.newError(runtime, PKeyRSA._PKey(runtime).getClass("RSAError"), message);
    }

    public PKeyRSA(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public PKeyRSA(Ruby runtime, RubyClass type, RSAPrivateCrtKey privKey, RSAPublicKey pubKey) {
        super(runtime, type);
        this.privKey = privKey;
        this.pubKey = pubKey;
    }

    public PKeyRSA(Ruby runtime, RubyClass type, RSAPublicKey pubKey) {
        this(runtime, type, null, pubKey);
    }

    @Override
    PublicKey getPublicKey() {
        return this.pubKey;
    }

    @Override
    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    @Override
    String getAlgorithm() {
        return "RSA";
    }

    @JRubyMethod(name={"generate"}, meta=true, rest=true)
    public static IRubyObject generate(IRubyObject self, IRubyObject[] args) {
        BigInteger exp = RSAKeyGenParameterSpec.F4;
        if (Arity.checkArgumentCount((Ruby)self.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 2) {
            exp = args[1] instanceof RubyFixnum ? BigInteger.valueOf(RubyNumeric.num2long((IRubyObject)args[1])) : ((RubyBignum)args[1]).getValue();
        }
        int keysize = RubyNumeric.fix2int((IRubyObject)args[0]);
        PKeyRSA rsa = new PKeyRSA(self.getRuntime(), (RubyClass)self);
        PKeyRSA.rsaGenerate(rsa, keysize, exp);
        return rsa;
    }

    private static void rsaGenerate(PKeyRSA rsa, int keysize, BigInteger exp) throws RaiseException {
        try {
            KeyPairGenerator gen = SecurityHelper.getKeyPairGenerator("RSA");
            if ("IBMJCEFIPS".equals(gen.getProvider().getName())) {
                gen.initialize(keysize);
            } else {
                gen.initialize(new RSAKeyGenParameterSpec(keysize, exp), new SecureRandom());
            }
            KeyPair pair = gen.generateKeyPair();
            rsa.privKey = (RSAPrivateCrtKey)pair.getPrivate();
            rsa.pubKey = (RSAPublicKey)pair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            throw PKeyRSA.newRSAError(rsa.getRuntime(), e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw PKeyRSA.newRSAError(rsa.getRuntime(), e.getMessage());
        }
        catch (RuntimeException e) {
            throw PKeyRSA.newRSAError(rsa.getRuntime(), e.getMessage());
        }
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args, Block block) {
        KeyFactory rsaFactory;
        Ruby runtime = context.runtime;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2) == 0) {
            this.privKey = null;
            this.pubKey = null;
            return this;
        }
        IRubyObject arg = args[0];
        IRubyObject pass = null;
        if (args.length > 1) {
            pass = args[1];
        }
        if (arg instanceof RubyFixnum) {
            int keysize = RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)arg));
            BigInteger exp = RSAKeyGenParameterSpec.F4;
            if (null != pass && !pass.isNil()) {
                exp = BigInteger.valueOf(RubyNumeric.num2long((IRubyObject)pass));
            }
            PKeyRSA.rsaGenerate(this, keysize, exp);
            return this;
        }
        char[] passwd = PKeyRSA.password(pass);
        RubyString str = PKeyRSA.readInitArg(context, arg);
        Serializable key = null;
        try {
            rsaFactory = SecurityHelper.getKeyFactory("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (RSA)");
        }
        catch (RuntimeException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (RSA) " + e);
        }
        boolean noClassDef = false;
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readPrivateKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readRSAPublicKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readRSAPubKey(new StringReader(str.toString()));
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readRSAPrivateKey(rsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSLReal.debug(runtime, "PKeyRSA could not read private key", e);
            }
            catch (IOException e) {
                OpenSSLReal.debug(runtime, "PKeyRSA could not read private key", e);
            }
            catch (RuntimeException e) {
                if (PKeyRSA.isKeyGenerationFailure(e)) {
                    OpenSSLReal.debug(runtime, "PKeyRSA could not read private key", e);
                }
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readRSAPublicKey(rsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSLReal.debug(runtime, "PKeyRSA could not read public key", e);
            }
            catch (IOException e) {
                OpenSSLReal.debug(runtime, "PKeyRSA could not read public key", e);
            }
            catch (RuntimeException e) {
                if (PKeyRSA.isKeyGenerationFailure(e)) {
                    OpenSSLReal.debug(runtime, "PKeyRSA could not read public key", e);
                }
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null) {
            key = this.tryPKCS8EncodedKey(runtime, rsaFactory, str.getBytes());
        }
        if (key == null) {
            key = this.tryX509EncodedKey(runtime, rsaFactory, str.getBytes());
        }
        if (key == null) {
            throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key:");
        }
        if (key instanceof KeyPair) {
            PublicKey publicKey = ((KeyPair)key).getPublic();
            PrivateKey privateKey = ((KeyPair)key).getPrivate();
            if (!(privateKey instanceof RSAPrivateCrtKey)) {
                if (privateKey == null) {
                    throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key: (private key is null)");
                }
                throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key: (invalid key type " + privateKey.getClass().getName() + ")");
            }
            this.privKey = (RSAPrivateCrtKey)privateKey;
            this.pubKey = (RSAPublicKey)publicKey;
        } else if (key instanceof RSAPrivateCrtKey) {
            this.privKey = (RSAPrivateCrtKey)key;
            try {
                this.pubKey = (RSAPublicKey)rsaFactory.generatePublic(new RSAPublicKeySpec(this.privKey.getModulus(), this.privKey.getPublicExponent()));
            }
            catch (GeneralSecurityException e) {
                throw PKeyRSA.newRSAError(runtime, e.getMessage());
            }
            catch (RuntimeException e) {
                OpenSSLReal.debugStackTrace(runtime, e);
                throw PKeyRSA.newRSAError(runtime, e.toString());
            }
        } else if (key instanceof RSAPublicKey) {
            this.pubKey = (RSAPublicKey)key;
            this.privKey = null;
        } else {
            throw PKeyRSA.newRSAError(runtime, "Neither PUB key nor PRIV key: " + key.getClass().getName());
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"})
    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_der() {
        byte[] bytes;
        try {
            bytes = PKey.toDerRSAKey(this.pubKey, this.privKey);
        }
        catch (NoClassDefFoundError e) {
            throw PKeyRSA.newRSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(e));
        }
        catch (IOException e) {
            throw PKeyRSA.newRSAError(this.getRuntime(), e.getMessage());
        }
        return RubyString.newString((Ruby)this.getRuntime(), (byte[])bytes);
    }

    @JRubyMethod
    public IRubyObject public_key() {
        PKeyRSA val = new PKeyRSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    @JRubyMethod
    public IRubyObject params(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyHash hash = RubyHash.newHash((Ruby)runtime);
        if (this.privKey != null) {
            hash.op_aset(context, (IRubyObject)runtime.newString("iqmp"), (IRubyObject)BN.newBN(runtime, this.privKey.getCrtCoefficient()));
            hash.op_aset(context, (IRubyObject)runtime.newString("n"), (IRubyObject)BN.newBN(runtime, this.privKey.getModulus()));
            hash.op_aset(context, (IRubyObject)runtime.newString("d"), (IRubyObject)BN.newBN(runtime, this.privKey.getPrivateExponent()));
            hash.op_aset(context, (IRubyObject)runtime.newString("p"), (IRubyObject)BN.newBN(runtime, this.privKey.getPrimeP()));
            hash.op_aset(context, (IRubyObject)runtime.newString("e"), (IRubyObject)BN.newBN(runtime, this.privKey.getPublicExponent()));
            hash.op_aset(context, (IRubyObject)runtime.newString("q"), (IRubyObject)BN.newBN(runtime, this.privKey.getPrimeQ()));
            hash.op_aset(context, (IRubyObject)runtime.newString("dmq1"), (IRubyObject)BN.newBN(runtime, this.privKey.getPrimeExponentQ()));
            hash.op_aset(context, (IRubyObject)runtime.newString("dmp1"), (IRubyObject)BN.newBN(runtime, this.privKey.getPrimeExponentP()));
        } else {
            hash.op_aset(context, (IRubyObject)runtime.newString("iqmp"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash.op_aset(context, (IRubyObject)runtime.newString("n"), (IRubyObject)BN.newBN(runtime, this.pubKey.getModulus()));
            hash.op_aset(context, (IRubyObject)runtime.newString("d"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash.op_aset(context, (IRubyObject)runtime.newString("p"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash.op_aset(context, (IRubyObject)runtime.newString("e"), (IRubyObject)BN.newBN(runtime, this.pubKey.getPublicExponent()));
            hash.op_aset(context, (IRubyObject)runtime.newString("q"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash.op_aset(context, (IRubyObject)runtime.newString("dmq1"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
            hash.op_aset(context, (IRubyObject)runtime.newString("dmp1"), (IRubyObject)BN.newBN(runtime, BigInteger.ZERO));
        }
        return hash;
    }

    @JRubyMethod
    public IRubyObject to_text() {
        StringBuilder result = new StringBuilder();
        if (this.privKey != null) {
            int len = this.privKey.getModulus().bitLength();
            result.append("Private-Key: (").append(len).append(" bit)").append("\n");
            result.append("modulus:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getModulus());
            result.append("publicExponent: ").append(this.privKey.getPublicExponent()).append(" (0x").append(this.privKey.getPublicExponent().toString(16)).append(")\n");
            result.append("privateExponent:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrivateExponent());
            result.append("prime1:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeP());
            result.append("prime2:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeQ());
            result.append("exponent1:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeExponentP());
            result.append("exponent2:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeExponentQ());
            result.append("coefficient:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getCrtCoefficient());
        } else {
            int len = this.pubKey.getModulus().bitLength();
            result.append("Modulus (").append(len).append(" bit):");
            PKeyRSA.addSplittedAndFormatted(result, this.pubKey.getModulus());
            result.append("Exponent: ").append(this.pubKey.getPublicExponent()).append(" (0x").append(this.pubKey.getPublicExponent().toString(16)).append(")\n");
        }
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod(name={"export", "to_pem", "to_s"}, rest=true)
    public IRubyObject export(IRubyObject[] args) {
        StringWriter w = new StringWriter();
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2);
        CipherSpec ciph = null;
        char[] passwd = null;
        if (args.length > 0 && !args[0].isNil()) {
            Cipher c = (Cipher)args[0];
            ciph = new CipherSpec(c.getCipher(), c.getName(), c.getKeyLen() * 8);
            if (args.length > 1 && !args[1].isNil()) {
                passwd = args[1].toString().toCharArray();
            }
        }
        try {
            if (this.privKey != null) {
                PEMInputOutput.writeRSAPrivateKey(w, this.privKey, ciph, passwd);
            } else {
                PEMInputOutput.writeRSAPublicKey(w, this.pubKey);
            }
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    private String getPadding(int padding) {
        if (padding < 1 || padding > 4) {
            throw PKeyRSA.newRSAError(this.getRuntime(), null);
        }
        String p = "/ECB/PKCS1Padding";
        if (padding == 3) {
            p = "/ECB/NoPadding";
        } else if (padding == 4) {
            p = "/ECB/OAEPWithMD5AndMGF1Padding";
        } else if (padding == 2) {
            p = "/ECB/ISO9796-1Padding";
        }
        return p;
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_encrypt(ThreadContext context, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        if (this.privKey == null) {
            throw PKeyRSA.newRSAError(context.runtime, "private key needed.");
        }
        return this.doCipherRSA(context.runtime, args[0], padding, 1, this.privKey);
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_decrypt(ThreadContext context, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        if (this.privKey == null) {
            throw PKeyRSA.newRSAError(context.runtime, "private key needed.");
        }
        return this.doCipherRSA(context.runtime, args[0], padding, 2, this.privKey);
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_encrypt(ThreadContext context, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        return this.doCipherRSA(context.runtime, args[0], padding, 1, this.pubKey);
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_decrypt(ThreadContext context, IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)context.runtime, (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        return this.doCipherRSA(context.runtime, args[0], padding, 2, this.pubKey);
    }

    private RubyString doCipherRSA(Ruby runtime, IRubyObject content, int padding, int initMode, Key initKey) {
        String cipherPadding = this.getPadding(padding);
        RubyString buffer = content.convertToString();
        try {
            javax.crypto.Cipher engine = SecurityHelper.getCipher("RSA" + cipherPadding);
            engine.init(initMode, initKey);
            byte[] output = engine.doFinal(buffer.getBytes());
            return RubyString.newString((Ruby)runtime, (byte[])output);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(runtime, gse.getMessage());
        }
    }

    @JRubyMethod(name={"d="})
    public synchronized IRubyObject set_d(ThreadContext context, IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(context.runtime, "illegal modification");
        }
        this.rsa_d = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams(context);
        return value;
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(ThreadContext context, IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(context.runtime, "illegal modification");
        }
        this.rsa_p = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams(context);
        return value;
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(ThreadContext context, IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(context.runtime, "illegal modification");
        }
        this.rsa_q = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams(context);
        return value;
    }

    @JRubyMethod(name={"dmp1="})
    public synchronized IRubyObject set_dmp1(ThreadContext context, IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(context.runtime, "illegal modification");
        }
        this.rsa_dmp1 = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams(context);
        return value;
    }

    @JRubyMethod(name={"dmq1="})
    public synchronized IRubyObject set_dmq1(ThreadContext context, IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(context.runtime, "illegal modification");
        }
        this.rsa_dmq1 = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams(context);
        return value;
    }

    @JRubyMethod(name={"iqmp="})
    public synchronized IRubyObject set_iqmp(ThreadContext context, IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(context.runtime, "illegal modification");
        }
        this.rsa_iqmp = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams(context);
        return value;
    }

    @JRubyMethod(name={"iqmp"})
    public synchronized IRubyObject get_iqmp() {
        BigInteger iqmp = this.privKey != null ? this.privKey.getCrtCoefficient() : this.rsa_iqmp;
        if (iqmp != null) {
            return BN.newBN(this.getRuntime(), iqmp);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmp1"})
    public synchronized IRubyObject get_dmp1() {
        BigInteger dmp1 = this.privKey != null ? this.privKey.getPrimeExponentP() : this.rsa_dmp1;
        if (dmp1 != null) {
            return BN.newBN(this.getRuntime(), dmp1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmq1"})
    public synchronized IRubyObject get_dmq1() {
        BigInteger dmq1 = this.privKey != null ? this.privKey.getPrimeExponentQ() : this.rsa_dmq1;
        if (dmq1 != null) {
            return BN.newBN(this.getRuntime(), dmq1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"d"})
    public synchronized IRubyObject get_d() {
        BigInteger d = this.privKey != null ? this.privKey.getPrivateExponent() : this.rsa_d;
        if (d != null) {
            return BN.newBN(this.getRuntime(), d);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p"})
    public synchronized IRubyObject get_p() {
        BigInteger p = this.privKey != null ? this.privKey.getPrimeP() : this.rsa_p;
        if (p != null) {
            return BN.newBN(this.getRuntime(), p);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"q"})
    public synchronized IRubyObject get_q() {
        BigInteger q = this.privKey != null ? this.privKey.getPrimeQ() : this.rsa_q;
        if (q != null) {
            return BN.newBN(this.getRuntime(), q);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"e"})
    public synchronized IRubyObject get_e() {
        RSAPublicKey key = this.pubKey;
        BigInteger e = key != null ? key.getPublicExponent() : (this.privKey != null ? this.privKey.getPublicExponent() : this.rsa_e);
        if (e != null) {
            return BN.newBN(this.getRuntime(), e);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"e="})
    public synchronized IRubyObject set_e(ThreadContext context, IRubyObject value) {
        this.rsa_e = BN.getBigInteger(value);
        if (this.privKey == null) {
            this.generatePrivateKeyIfParams(context);
        }
        if (this.pubKey == null) {
            this.generatePublicKeyIfParams(context);
        }
        return value;
    }

    @JRubyMethod(name={"n"})
    public synchronized IRubyObject get_n() {
        RSAPublicKey key = this.pubKey;
        BigInteger n = key != null ? key.getModulus() : (this.privKey != null ? this.privKey.getModulus() : this.rsa_n);
        if (n != null) {
            return BN.newBN(this.getRuntime(), n);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"n="})
    public synchronized IRubyObject set_n(ThreadContext context, IRubyObject value) {
        this.rsa_n = BN.getBigInteger(value);
        if (this.privKey == null) {
            this.generatePrivateKeyIfParams(context);
        }
        if (this.pubKey == null) {
            this.generatePublicKeyIfParams(context);
        }
        return value;
    }

    private void generatePublicKeyIfParams(ThreadContext context) {
        BigInteger n;
        Ruby runtime = context.runtime;
        if (this.pubKey != null) {
            throw PKeyRSA.newRSAError(runtime, "illegal modification");
        }
        BigInteger e = this.rsa_e;
        if (e != null && (n = this.rsa_n) != null) {
            KeyFactory rsaFactory;
            try {
                rsaFactory = SecurityHelper.getKeyFactory("RSA");
            }
            catch (Exception ex) {
                throw runtime.newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.pubKey = (RSAPublicKey)rsaFactory.generatePublic(new RSAPublicKeySpec(n, e));
            }
            catch (InvalidKeySpecException ex) {
                throw PKeyRSA.newRSAError(runtime, "invalid parameters");
            }
            this.rsa_e = null;
            this.rsa_n = null;
        }
    }

    private void generatePrivateKeyIfParams(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(runtime, "illegal modification");
        }
        if (this.rsa_e != null && this.rsa_n != null && this.rsa_p != null && this.rsa_q != null && this.rsa_d != null && this.rsa_dmp1 != null && this.rsa_dmq1 != null && this.rsa_iqmp != null) {
            KeyFactory rsaFactory;
            try {
                rsaFactory = SecurityHelper.getKeyFactory("RSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime.newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.privKey = (RSAPrivateCrtKey)rsaFactory.generatePrivate(new RSAPrivateCrtKeySpec(this.rsa_n, this.rsa_e, this.rsa_d, this.rsa_p, this.rsa_q, this.rsa_dmp1, this.rsa_dmq1, this.rsa_iqmp));
            }
            catch (InvalidKeySpecException e) {
                throw PKeyRSA.newRSAError(runtime, "invalid parameters");
            }
            this.rsa_n = null;
            this.rsa_e = null;
            this.rsa_d = null;
            this.rsa_p = null;
            this.rsa_q = null;
            this.rsa_dmp1 = null;
            this.rsa_dmq1 = null;
            this.rsa_iqmp = null;
        }
    }
}

