/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.Config;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.HMAC;
import org.jruby.ext.openssl.NetscapeSPKI;
import org.jruby.ext.openssl.PKCS7;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Random;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class OpenSSLReal {
    private static boolean debug;

    private OpenSSLReal() {
    }

    @Deprecated
    public static void doWithBCProvider(final Runnable block) throws GeneralSecurityException {
        OpenSSLReal.getWithBCProvider(new Callable<Void>(){

            @Override
            public Void call() throws GeneralSecurityException {
                block.run();
                return null;
            }
        });
    }

    @Deprecated
    public static <T> T getWithBCProvider(Callable<T> block) throws GeneralSecurityException {
        try {
            Provider provider = SecurityHelper.getSecurityProvider();
            if (provider != null && Security.getProvider(provider.getName()) == null) {
                Security.addProvider(provider);
            }
            return block.call();
        }
        catch (NoSuchProviderException nspe) {
            throw new GeneralSecurityException(OpenSSLReal.bcExceptionMessage(nspe), nspe);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    public static String bcExceptionMessage(NoSuchProviderException nspe) {
        return "You need to configure JVM/classpath to enable BouncyCastle Security Provider: " + nspe.getMessage();
    }

    public static String bcExceptionMessage(NoClassDefFoundError ncdfe) {
        return "You need to configure JVM/classpath to enable BouncyCastle Security Provider: NoClassDefFoundError: " + ncdfe.getMessage();
    }

    public static void createOpenSSL(Ruby runtime) {
        boolean registerProvider = Boolean.getBoolean("jruby.openssl.provider.register");
        SecurityHelper.setRegisterProvider(registerProvider);
        RubyModule ossl = runtime.getOrCreateModule("OpenSSL");
        RubyClass standardError = runtime.getClass("StandardError");
        ossl.defineClassUnder("OpenSSLError", standardError, standardError.getAllocator());
        ossl.defineAnnotatedMethods(OpenSSLModule.class);
        PKey.createPKey(runtime, ossl);
        BN.createBN(runtime, ossl);
        Digest.createDigest(runtime, ossl);
        Cipher.createCipher(runtime, ossl);
        Random.createRandom(runtime, ossl);
        HMAC.createHMAC(runtime, ossl);
        Config.createConfig(runtime, ossl);
        ASN1.createASN1(runtime, ossl);
        X509.createX509(runtime, ossl);
        NetscapeSPKI.createNetscapeSPKI(runtime, ossl);
        PKCS7.createPKCS7(runtime, ossl);
        SSL.createSSL(runtime, ossl);
        runtime.getLoadService().require("jopenssl/version");
        String jopensslVersion = runtime.getClassFromPath("Jopenssl::Version").getConstant("VERSION").toString();
        ossl.setConstant("VERSION", (IRubyObject)runtime.newString("1.0.0"));
        ossl.setConstant("OPENSSL_VERSION", (IRubyObject)runtime.newString("jruby-ossl " + jopensslVersion));
        ossl.setConstant("OPENSSL_VERSION_NUMBER", (IRubyObject)runtime.newFixnum(9469999));
        OpenSSLModule.setDebug((IRubyObject)ossl, (IRubyObject)runtime.newBoolean(Boolean.getBoolean("jruby.openssl.debug")));
    }

    static boolean isDebug() {
        return debug;
    }

    static boolean isDebug(Ruby runtime) {
        RubyModule ossl = runtime.getModule("OpenSSL");
        return OpenSSLModule.getDebug((IRubyObject)ossl).isTrue();
    }

    static void debugStackTrace(Ruby runtime, Throwable e) {
        if (OpenSSLReal.isDebug(runtime)) {
            e.printStackTrace(runtime.getOut());
        }
    }

    static void debug(Ruby runtime, String msg) {
        if (OpenSSLReal.isDebug(runtime)) {
            runtime.getOut().println(msg);
        }
    }

    static void debug(Ruby runtime, String msg, Throwable e) {
        if (OpenSSLReal.isDebug(runtime)) {
            runtime.getOut().println(msg + ' ' + e);
        }
    }

    static void warn(ThreadContext context, String msg) {
        OpenSSLReal.warn(context, (IRubyObject)RubyString.newString((Ruby)context.runtime, (String)msg));
    }

    static void warn(ThreadContext context, IRubyObject msg) {
        context.runtime.getKernel().callMethod(context, "warn", msg);
    }

    @Deprecated
    public static CertificateFactory getX509CertificateFactoryBC() throws CertificateException {
        return SecurityHelper.getCertificateFactory("X.509");
    }

    @JRubyModule(name={"OpenSSL"})
    public static class OpenSSLModule {
        @JRubyMethod(name={"errors"}, meta=true)
        public static IRubyObject errors(IRubyObject self) {
            Ruby runtime = self.getRuntime();
            RubyArray result = runtime.newArray();
            for (Map.Entry<Integer, String> e : X509Error.getErrors().entrySet()) {
                result.add((Object)runtime.newString(e.getValue()));
            }
            return result;
        }

        @JRubyMethod(name={"debug"}, meta=true)
        public static IRubyObject getDebug(IRubyObject self) {
            return (IRubyObject)((RubyModule)self).getInternalVariable("debug");
        }

        @JRubyMethod(name={"debug="}, meta=true)
        public static IRubyObject setDebug(IRubyObject self, IRubyObject debug) {
            ((RubyModule)self).setInternalVariable("debug", (Object)debug);
            debug = debug.isTrue();
            return debug;
        }

        @JRubyMethod(meta=true)
        public static IRubyObject fips_mode(ThreadContext context, IRubyObject self) {
            return context.runtime.getFalse();
        }

        @JRubyMethod(name={"fips_mode="}, meta=true)
        public static IRubyObject fips_mode_set(ThreadContext context, IRubyObject self, IRubyObject value) {
            if (value.isTrue()) {
                context.runtime.getWarnings().warn("FIPS mode not supported on JRuby OpenSSL");
            }
            return self;
        }
    }

    public static interface Callable<T> {
        public T call() throws GeneralSecurityException;
    }

    @Deprecated
    public static interface Runnable {
        public void run() throws GeneralSecurityException;
    }
}

