#!/bin/sh
echo 'name: xmlhtml
version: 0.2.1
id: xmlhtml-0.2.1-024fbdca2ca705169920f98d3cb47c28

license: BSD3
copyright:
maintainer: Chris Smith <cdsmith@gmail.com>
stability:
homepage:
package-url:
synopsis: XML parser and renderer with HTML 5 quirks mode
description: Contains renderers and parsers for both XML and HTML 5
             document fragments, which share data structures so that
             it'\''s easy to work with both.  Document fragments are bits
             of documents, which are not constrained by some of the
             high-level structure rules (in particular, they may
             contain more than one root element).
             .
             Note that this is not a compliant HTML 5 parser.  Rather,
             it is a parser for HTML 5 compliant documents.  It does not
             implement the HTML 5 parsing algorithm, and should
             generally be expected to perform correctly only on
             documents that you trust to conform to HTML 5.  This is
             not a suitable library for implementing web crawlers or
             other software that will be exposed to documents from
             outside sources.  The result is also not the HTML 5
             node structure, but rather something closer to the physical
             structure.  For example, omitted start tags are not
             inserted (and so, their corresponding end tags must also be
             omitted).
category: Text
author: Chris Smith <cdsmith@gmail.com>
pkgpath: textproc/hs-xmlhtml
exposed: True
exposed-modules: Text.XmlHtml Text.XmlHtml.Cursor
                 Text.XmlHtml.HTML.Meta Text.Blaze.Renderer.XmlHtml
hidden-modules: Text.XmlHtml.Common Text.XmlHtml.TextParser
                Text.XmlHtml.XML.Parse Text.XmlHtml.XML.Render
                Text.XmlHtml.HTML.Parse Text.XmlHtml.HTML.Render
trusted: False
import-dirs: /usr/local/lib/ghc/xmlhtml-0.2.1
library-dirs: /usr/local/lib/ghc/xmlhtml-0.2.1
hs-libraries: HSxmlhtml-0.2.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         blaze-builder-0.3.1.1-ac49b512143342e2370aead8ef93c70b
         blaze-html-0.6.1.1-d9a2e0519a92c20d0751dbc779791ce7
         blaze-markup-0.5.1.5-2469a9388e0fb2943fc206e9c09e2bea
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         parsec-3.1.3-b22b2727b76201c9de9a61961208ca5b
         text-0.11.3.1-bda2125c8335eaa4aca16bb46c88465a
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-xmlhtml-0.2.1/html/xmlhtml.haddock
haddock-html: /usr/local/share/doc/hs-xmlhtml-0.2.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
