/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal;

import java.util.Collection;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingEvent;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.WritableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public class ListBinding
extends Binding {
    private boolean updating = false;
    private IObservableList modelList;
    private final IObservableList targetList;
    private final IListChangeListener targetChangeListener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
            if (ListBinding.this.updating) {
                return;
            }
            BindingEvent e = new BindingEvent(ListBinding.this.modelList, ListBinding.this.targetList, diff, 1, 0);
            if (ListBinding.this.failure(ListBinding.this.errMsg(ListBinding.this.fireBindingEvent(e)))) {
                return;
            }
            ListBinding.this.updating = true;
            try {
                ListDiff setDiff = (ListDiff)e.diff;
                ListDiffEntry[] differences = setDiff.getDifferences();
                int i = 0;
                while (i < differences.length) {
                    ListDiffEntry entry = differences[i];
                    if (entry.isAddition()) {
                        ListBinding.this.modelList.add(entry.getPosition(), entry.getElement());
                    } else {
                        ListBinding.this.modelList.remove(entry.getPosition());
                    }
                    ++i;
                }
                e.pipelinePosition = 4;
                if (ListBinding.this.failure(ListBinding.this.errMsg(ListBinding.this.fireBindingEvent(e)))) {
                    return;
                }
            }
            finally {
                ListBinding.this.updating = false;
            }
        }
    };
    private IListChangeListener modelChangeListener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
            if (ListBinding.this.updating) {
                return;
            }
            BindingEvent e = new BindingEvent(ListBinding.this.modelList, ListBinding.this.targetList, diff, 0, 0);
            if (ListBinding.this.failure(ListBinding.this.errMsg(ListBinding.this.fireBindingEvent(e)))) {
                return;
            }
            ListBinding.this.updating = true;
            try {
                ListDiff setDiff = (ListDiff)e.diff;
                ListDiffEntry[] differences = setDiff.getDifferences();
                int i = 0;
                while (i < differences.length) {
                    ListDiffEntry entry = differences[i];
                    if (entry.isAddition()) {
                        ListBinding.this.targetList.add(entry.getPosition(), entry.getElement());
                    } else {
                        ListBinding.this.targetList.remove(entry.getPosition());
                    }
                    ++i;
                }
                e.pipelinePosition = 4;
                if (ListBinding.this.failure(ListBinding.this.errMsg(ListBinding.this.fireBindingEvent(e)))) {
                    return;
                }
            }
            finally {
                ListBinding.this.updating = false;
            }
        }
    };
    private WritableValue partialValidationErrorObservable = new WritableValue(null);
    private WritableValue validationErrorObservable = new WritableValue(null);

    public ListBinding(DataBindingContext context, IObservableList targetList, IObservableList modelList, BindSpec bindSpec) {
        super(context);
        this.targetList = targetList;
        this.modelList = modelList;
        targetList.addListChangeListener(this.targetChangeListener);
        modelList.addListChangeListener(this.modelChangeListener);
        this.updateTargetFromModel();
    }

    private ValidationError errMsg(ValidationError validationError) {
        this.partialValidationErrorObservable.setValue(null);
        this.validationErrorObservable.setValue(validationError);
        return validationError;
    }

    private boolean failure(ValidationError errorMessage) {
        return errorMessage != null && errorMessage.status == 2;
    }

    public void updateTargetFromModel() {
        this.updating = true;
        try {
            this.targetList.clear();
            this.targetList.addAll((Collection)this.modelList);
        }
        finally {
            this.updating = false;
        }
    }

    public IObservableValue getValidationError() {
        return this.validationErrorObservable;
    }

    public IObservableValue getPartialValidationError() {
        return this.partialValidationErrorObservable;
    }

    public void updateModelFromTarget() {
        this.updating = true;
        try {
            this.modelList.clear();
            this.modelList.addAll((Collection)this.targetList);
        }
        finally {
            this.updating = false;
        }
    }
}

