/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

class DigestedInputStream
extends FilterInputStream {
    MessageDigest[] digest;
    byte[][] result;
    long remaining;

    DigestedInputStream(InputStream in, MessageDigest[] digest, byte[][] result, long size) {
        super(in);
        this.remaining = size;
        this.digest = new MessageDigest[digest.length];
        int i = 0;
        while (i < digest.length) {
            try {
                this.digest[i] = (MessageDigest)digest[i].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException("MessageDigest must support clone");
            }
            ++i;
        }
        this.result = result;
    }

    public synchronized void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int c = super.read();
        if (c != -1) {
            int i = 0;
            while (i < this.digest.length) {
                this.digest[i].update((byte)c);
                ++i;
            }
            --this.remaining;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining == 0L) {
            this.verifyDigests();
        }
        return c;
    }

    private void verifyDigests() throws IOException {
        int i = 0;
        while (i < this.digest.length) {
            byte[] rc = this.digest[i].digest();
            if (!MessageDigest.isEqual(this.result[i], rc)) {
                throw new IOException("Corrupted file: the digest is valid for " + this.digest[i].getAlgorithm());
            }
            ++i;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int rc = super.read(b, off, len);
        if (rc != -1) {
            int i = 0;
            while (i < this.digest.length) {
                this.digest[i].update(b, off, rc);
                ++i;
            }
            this.remaining -= (long)rc;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining <= 0L) {
            this.verifyDigests();
        }
        return rc;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    public long skip(long n) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (n - count > 0L) {
            int rc = n - count > (long)buffer.length ? buffer.length : (int)(n - count);
            if ((rc = this.read(buffer, 0, rc)) == -1) break;
            count += (long)rc;
            n -= (long)rc;
        }
        return count;
    }
}

