/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingProblem;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellEvent;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellEventListener;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public abstract class SpellingEngine
implements ISpellingEngine {
    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        IPreferenceStore preferences = PreferenceConstants.getPreferenceStore();
        if (collector != null) {
            Locale locale = this.getLocale(preferences);
            ISpellChecker checker = SpellCheckEngine.getInstance().createSpellChecker(locale, preferences);
            if (checker != null) {
                this.check(document, regions, checker, locale, collector, monitor);
            }
        }
    }

    protected abstract void check(IDocument var1, IRegion[] var2, ISpellChecker var3, Locale var4, ISpellingProblemCollector var5, IProgressMonitor var6);

    private Locale getLocale(IPreferenceStore preferences) {
        Locale defaultLocale = SpellCheckEngine.getDefaultLocale();
        String locale = preferences.getString("spelling_locale");
        if (locale.equals(defaultLocale.toString())) {
            return defaultLocale;
        }
        if (locale.length() >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        return defaultLocale;
    }

    protected static class SpellEventListener
    implements ISpellEventListener {
        private ISpellingProblemCollector fCollector;

        public SpellEventListener(ISpellingProblemCollector collector) {
            this.fCollector = collector;
        }

        public void handle(ISpellEvent event) {
            this.fCollector.accept((SpellingProblem)new JavaSpellingProblem(event));
        }
    }
}

