/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.views.launch.Decoration;

public class DecorationManager {
    private static Map fDecorations = new HashMap(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDecoration(Decoration decoration) {
        Map map = fDecorations;
        synchronized (map) {
            IDebugTarget target = decoration.getThread().getDebugTarget();
            ArrayList<Decoration> list = (ArrayList<Decoration>)fDecorations.get(target);
            if (list == null) {
                list = new ArrayList<Decoration>();
                fDecorations.put(target, list);
            }
            list.add(decoration);
        }
    }

    public static void removeDecorations(IDebugTarget target) {
        DecorationManager.doRemoveDecorations(target, null);
    }

    public static void removeDecorations(IThread thread) {
        DecorationManager.doRemoveDecorations(thread.getDebugTarget(), thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRemoveDecorations(IDebugTarget target, IThread thread) {
        ArrayList<Decoration> decorationsToRemove = new ArrayList<Decoration>();
        Map map = fDecorations;
        synchronized (map) {
            List list = (List)fDecorations.get(target);
            if (list != null) {
                ListIterator iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Decoration decoration = (Decoration)iterator.next();
                    if (thread != null && !thread.equals(decoration.getThread())) continue;
                    decorationsToRemove.add(decoration);
                    iterator.remove();
                }
            }
        }
        for (Decoration decoration : decorationsToRemove) {
            decoration.remove();
        }
    }
}

