/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.VariableValueEditorManager;
import org.eclipse.debug.internal.ui.elements.adapters.Messages;
import org.eclipse.debug.internal.ui.elements.adapters.VariableColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DefaultVariableCellModifier
implements ICellModifier {
    private IPresentationContext fContext;

    public DefaultVariableCellModifier(IPresentationContext context) {
        this.fContext = context;
    }

    public boolean canModify(Object element, String property) {
        if (VariableColumnPresentation.COLUMN_VARIABLE_VALUE.equals(property) && element instanceof IVariable) {
            return ((IVariable)element).supportsValueModification();
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (VariableColumnPresentation.COLUMN_VARIABLE_VALUE.equals(property) && element instanceof IVariable) {
            IVariable variable = (IVariable)element;
            try {
                return variable.getValue().getValueString();
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        Object oldValue = this.getValue(element, property);
        if (!value.equals(oldValue) && VariableColumnPresentation.COLUMN_VARIABLE_VALUE.equals(property) && element instanceof IVariable) {
            IVariable variable = (IVariable)element;
            IVariableValueEditor editor = VariableValueEditorManager.getDefault().getVariableValueEditor(variable.getModelIdentifier());
            Shell shell = null;
            IWorkbenchPart part = this.fContext.getPart();
            if (part != null) {
                shell = part.getSite().getShell();
            }
            if (editor != null && editor.saveVariable(variable, (String)value, shell)) {
                return;
            }
            try {
                variable.setValue((String)value);
            }
            catch (DebugException e) {
                DebugUIPlugin.errorDialog(shell, Messages.VariableColumnPresentation_4, Messages.VariableColumnPresentation_5, e.getStatus());
            }
        }
    }

    protected IPresentationContext getPresentationContext() {
        return this.fContext;
    }
}

