/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.search.ParsedDocument;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.xhtml.XHTMLContentDescriber;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;

public class HTMLSearchParticipant
extends LuceneSearchParticipant {
    private HTMLDocParser parser = new HTMLDocParser();
    private String indexPath;
    private IContentDescriber xhtmlDescriber;

    public HTMLSearchParticipant(String indexPath) {
        this.indexPath = indexPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        if (this.isXHTML(pluginId, url)) {
            SearchManager manager = BaseHelpSystem.getSearchManager();
            LuceneSearchParticipant xhtmlParticipant = manager.getParticipant("org.eclipse.help.base.xhtml");
            return xhtmlParticipant.addDocument(index, pluginId, name, url, id, doc);
        }
        try {
            try {
                try {
                    this.parser.openDocument(url);
                }
                catch (IOException iOException) {
                    Status status = new Status(4, "org.eclipse.help.base", 4, "Help document " + name + " cannot be opened.", null);
                    this.parser.closeDocument();
                    return status;
                }
                ParsedDocument parsed = new ParsedDocument(this.parser.getContentReader());
                doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
                doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
                String title = this.parser.getTitle();
                doc.add(Field.UnStored((String)"title", (String)title));
                doc.add(Field.UnStored((String)"exact_title", (String)title));
                doc.add(Field.UnIndexed((String)"raw_title", (String)title));
                doc.add(Field.UnIndexed((String)"summary", (String)this.parser.getSummary(title)));
                return Status.OK_STATUS;
            }
            finally {
                this.parser.closeDocument();
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while adding document " + name + " to index " + this.indexPath + ".", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isXHTML(String pluginId, URL url) {
        InputStream in;
        block11: {
            boolean bl;
            SearchManager manager = BaseHelpSystem.getSearchManager();
            if (!manager.isParticipantBound(pluginId, "org.eclipse.help.base.xhtml")) return false;
            if (this.xhtmlDescriber == null) {
                this.xhtmlDescriber = new XHTMLContentDescriber();
            }
            in = null;
            try {
                in = url.openStream();
                bl = this.xhtmlDescriber.describe(in, null) == 2;
                if (in == null) return bl;
            }
            catch (Exception exception) {
                try {
                    break block11;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                in.close();
                return bl;
            }
            catch (IOException iOException) {}
            return bl;
        }
        if (in == null) return false;
        try {
            in.close();
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }
}

