/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.DisplayUtils;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.osgi.util.NLS;

public class HelpApplication
implements IPlatformRunnable,
IExecutableExtension {
    private static final String APPLICATION_LOCK_FILE = ".applicationlock";
    private static final int STATUS_EXITTING = 0;
    private static final int STATUS_RESTARTING = 2;
    private static final int STATUS_RUNNING = 1;
    private static int status = 1;
    private File metadata;
    private FileLock lock;

    public static void stop() {
        status = 0;
        if (2 == BaseHelpSystem.getMode()) {
            DisplayUtils.wakeupUI();
        }
    }

    public static void restart() {
        if (status != 0) {
            status = 2;
        }
    }

    public Object run(Object args) throws Exception {
        if (status == 2) {
            return EXIT_RESTART;
        }
        this.metadata = new File(Platform.getLocation().toFile(), ".metadata/");
        if (!BaseHelpSystem.ensureWebappRunning()) {
            System.out.println(NLS.bind((String)HelpBaseResources.HelpApplication_couldNotStart, (Object)Platform.getLogFileLocation().toOSString()));
            return EXIT_OK;
        }
        if (status == 2) {
            return EXIT_RESTART;
        }
        this.writeHostAndPort();
        this.obtainLock();
        if (2 == BaseHelpSystem.getMode()) {
            DisplayUtils.runUI();
        }
        while (status == 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        this.releaseLock();
        if (status == 2) {
            return EXIT_RESTART;
        }
        return EXIT_OK;
    }

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        String value = (String)((Map)data).get("mode");
        if ("infocenter".equalsIgnoreCase(value)) {
            BaseHelpSystem.setMode(1);
        } else if ("standalone".equalsIgnoreCase(value)) {
            BaseHelpSystem.setMode(2);
        }
    }

    private void writeHostAndPort() throws IOException {
        Properties p = new Properties();
        p.put("host", WebappManager.getHost());
        p.put("port", "" + WebappManager.getPort());
        File hostPortFile = new File(this.metadata, ".connection");
        hostPortFile.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(hostPortFile);
            p.store(out, null);
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void obtainLock() {
        File lockFile = new File(this.metadata, APPLICATION_LOCK_FILE);
        try {
            RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
            this.lock = raf.getChannel().lock();
        }
        catch (IOException iOException) {
            this.lock = null;
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isRunning() {
        return status == 1;
    }
}

