/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.MarkerResolutionSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class ResolveMarkerAction
extends TaskAction {
    protected ResolveMarkerAction(TaskList tasklist, String id) {
        super(tasklist, id);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.resolve_marker_action_context");
    }

    public boolean shouldEnable(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        IMarker marker = (IMarker)selection.getFirstElement();
        if (marker == null) {
            return false;
        }
        return IDE.getMarkerHelpRegistry().hasResolutions(marker);
    }

    public void run() {
        IMarker marker = this.getMarker();
        if (marker == null) {
            return;
        }
        this.getTaskList().cancelEditing();
        IMarkerResolution[] resolutions = this.getResolutions(marker);
        if (resolutions.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TaskListMessages.Resolve_title, (String)TaskListMessages.Resolve_noResolutionsLabel);
            return;
        }
        MarkerResolutionSelectionDialog d = new MarkerResolutionSelectionDialog(this.getShell(), resolutions);
        if (d.open() != 0) {
            return;
        }
        Object[] result = d.getResult();
        if (result != null && result.length > 0) {
            ((IMarkerResolution)result[0]).run(marker);
        }
    }

    private IMarkerResolution[] getResolutions(IMarker marker) {
        return IDE.getMarkerHelpRegistry().getResolutions(marker);
    }

    private IMarker getMarker() {
        IStructuredSelection selection = (IStructuredSelection)this.getTaskList().getSelection();
        if (selection.size() != 1) {
            return null;
        }
        return (IMarker)selection.getFirstElement();
    }
}

