/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.pde.internal.build.site.PluginPathFinder;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;

public class BuildTimeSiteFactory
extends BaseSiteFactory
implements ISiteFactory,
IPDEBuildConstants {
    private Site site = null;
    private boolean urlsChanged = false;
    private String[] sitePaths;
    private static String installedBaseLocation = null;
    private boolean reportResolutionErrors;
    private PDEUIStateWrapper pdeUIState;

    public ISite createSite() throws CoreException {
        if (this.site != null && !this.urlsChanged) {
            return this.site;
        }
        this.urlsChanged = false;
        this.site = (Site)this.createSiteMapModel();
        Collection featureXMLs = this.findFeatureXMLs();
        String installedBaseURL = null;
        if (installedBaseLocation != null && !installedBaseLocation.equals("")) {
            if (!new File(installedBaseLocation).exists()) {
                String message = NLS.bind((String)Messages.error_incorrectDirectoryEntry, (Object)installedBaseLocation);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 6, message, null));
            }
            installedBaseURL = installedBaseLocation;
            Collection installedFeatures = Utils.findFiles(installedBaseLocation, "features", "feature.xml");
            if (installedFeatures != null) {
                featureXMLs.addAll(installedFeatures);
            }
            String[] linkPaths = PluginPathFinder.getPluginPaths(installedBaseURL);
            int i = 0;
            while (i < linkPaths.length) {
                Collection foundFeatures = Utils.findFiles(linkPaths[i], "features", "feature.xml");
                if (foundFeatures != null) {
                    featureXMLs.addAll(foundFeatures);
                }
                ++i;
            }
        }
        for (File featureXML : featureXMLs) {
            if (!featureXML.exists()) continue;
            try {
                URL featureURL = new URL("file:" + featureXML.getAbsolutePath());
                SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                featureRef.setSiteModel((SiteModel)this.site);
                featureRef.setURLString(featureURL.toExternalForm());
                featureRef.setType("org.eclipse.pde.build.BuildTimeFeatureFactory");
                this.site.addFeatureReferenceModel(featureRef);
            }
            catch (MalformedURLException e) {
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 20, NLS.bind((String)Messages.warning_cannotLocateSource, (Object)featureXML.getAbsolutePath()), (Throwable)e));
            }
        }
        BuildTimeSiteContentProvider contentProvider = new BuildTimeSiteContentProvider(this.sitePaths, installedBaseURL, this.pdeUIState);
        this.site.setSiteContentProvider((ISiteContentProvider)contentProvider);
        contentProvider.setSite((ISite)this.site);
        ((BuildTimeSite)this.site).setReportResolutionErrors(this.reportResolutionErrors);
        return this.site;
    }

    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 6, Messages.error_incorrectDirectoryEntry, null));
    }

    public SiteModel createSiteMapModel() {
        return new BuildTimeSite();
    }

    public static void setInstalledBaseSite(String installedBaseSite) {
        installedBaseLocation = installedBaseSite;
    }

    public void setSitePaths(String[] urls) {
        if (this.sitePaths == null) {
            this.sitePaths = urls;
            this.urlsChanged = true;
            return;
        }
        int i = 0;
        boolean found = true;
        while (found && i < this.sitePaths.length) {
            found = false;
            int j = 0;
            while (j < urls.length) {
                if (this.sitePaths[i].equals(urls[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (!found) {
            this.sitePaths = urls;
            this.urlsChanged = true;
        }
    }

    private Collection findFeatureXMLs() {
        ArrayList features = new ArrayList();
        int i = 0;
        while (i < this.sitePaths.length) {
            Collection foundFeatures = Utils.findFiles(this.sitePaths[i], "features", "feature.xml");
            if (foundFeatures != null) {
                features.addAll(foundFeatures);
            }
            ++i;
        }
        return features;
    }

    public void setReportResolutionErrors(boolean value) {
        this.reportResolutionErrors = value;
    }

    public void setInitialState(PDEUIStateWrapper uiState) {
        this.pdeUIState = uiState;
    }
}

