/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;

public class CreateExtensionAction
extends UMLCommandAction {
    protected Command createActionCommand(EditingDomain editingDomain, Collection collection) {
        if (collection.size() == 1 && collection.iterator().next() instanceof Stereotype) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void run(IAction action) {
        if (this.command != UnexecutableCommand.INSTANCE) {
            final Stereotype stereotype = (Stereotype)this.collection.iterator().next();
            EList allExtendedMetaclasses = stereotype.getAllExtendedMetaclasses();
            ArrayList choiceOfValues = new ArrayList();
            Profile profile = stereotype.getProfile();
            if (profile != null) {
                Iterator referencedMetamodels = profile.getReferencedMetamodels().iterator();
                while (referencedMetamodels.hasNext()) {
                    Model metamodel = (Model)referencedMetamodels.next();
                    Iterator ownedTypes = metamodel.getOwnedTypes().iterator();
                    while (ownedTypes.hasNext()) {
                        Object type = ownedTypes.next();
                        if (!(type instanceof Class) || !((Class)type).isMetaclass() || allExtendedMetaclasses.contains(type)) continue;
                        choiceOfValues.add(type);
                    }
                }
                Iterator referencedMetaclasses = profile.getReferencedMetaclasses().iterator();
                while (referencedMetaclasses.hasNext()) {
                    Class metaclass = (Class)referencedMetaclasses.next();
                    if (allExtendedMetaclasses.contains((Object)metaclass) || choiceOfValues.contains(metaclass)) continue;
                    choiceOfValues.add(metaclass);
                }
            }
            Collections.sort(choiceOfValues, new UMLCommandAction.TextComparator(this));
            String label = UMLEditorPlugin.INSTANCE.getString("_UI_CreateExtensionActionCommand_label");
            final FeatureEditorDialog dialog = new FeatureEditorDialog(this.workbenchPart.getSite().getShell(), this.getLabelProvider(), (Object)stereotype, (EClassifier)UMLPackage.Literals.STEREOTYPE, Collections.EMPTY_LIST, label, choiceOfValues);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, new Runnable(){

                    public void run() {
                        Iterator metaclasses = dialog.getResult().iterator();
                        while (metaclasses.hasNext()) {
                            stereotype.createExtension((Class)metaclasses.next(), false);
                        }
                    }
                }, label));
            }
        }
    }
}

