#-------------------------------------------------------------------
# WebGUI is Copyright 2001-2006 Plain Black Corporation.
#-------------------------------------------------------------------
# Please read the legal notices (docs/legal.txt) and the license
# (docs/license.txt) that came with this distribution before using
# this software.
#-------------------------------------------------------------------
# http://www.plainblack.com                     info@plainblack.com
#-------------------------------------------------------------------

use lib "../../lib";
use strict;
use Getopt::Long;
use WebGUI::Session;


my $toVersion = "7.0.7"; # make this match what version you're going to
my $quiet; # this line required


my $session = start(); # this line required

# upgrade functions go here
giveTasksMultipleResources($session);
giveTasksLagTime($session);
giveProjectsObserverGroup($session);

finish($session); # this line required



sub giveTasksMultipleResources {
	my $session = shift;
	print "\tMaking tasks handle multiple resources.\n" unless $quiet;
	$session->db->write($_) for(<<'EOT',
  CREATE TABLE PM_taskResource (
    taskResourceId varchar(22) character set utf8 collate utf8_bin NOT NULL,
    taskId varchar(22) character set utf8 collate utf8_bin NOT NULL,
    sequenceNumber int(11) NOT NULL,
    resourceKind enum('user', 'group') NOT NULL,
    resourceId varchar(22) character set utf8 collate utf8_bin NOT NULL,
    UNIQUE (taskId, resourceKind, resourceId),
    UNIQUE (taskId, sequenceNumber),
    PRIMARY KEY (taskResourceId)
  ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
EOT
				     <<'EOT',
  INSERT INTO PM_taskResource
  (taskResourceId, taskId, sequenceNumber, resourceKind, resourceId)
    SELECT taskId, taskId, 1, 'user', resourceId
      FROM PM_task WHERE resourceId IS NOT NULL;
EOT
				     <<'EOT',
  ALTER TABLE PM_task
  DROP COLUMN resourceId;
EOT
				     <<'EOT',
  ALTER TABLE PM_wobject
   ADD COLUMN resourcePopupTemplateId varchar(22) character set utf8 collate utf8_bin NOT NULL
              DEFAULT 'ProjectManagerTMPL0005',
   ADD COLUMN resourceListTemplateId varchar(22) character set utf8 collate utf8_bin NOT NULL
              DEFAULT 'ProjectManagerTMPL0006'
EOT
				    );
}

sub giveTasksLagTime {
	my $session = shift;
	print "\tGiving tasks lag time.\n" unless $quiet;
	$session->db->write($_) for(<<'EOT',
  ALTER TABLE PM_task ADD COLUMN lagTime bigint(20) DEFAULT 0;
EOT
				   );
}

sub giveProjectsObserverGroup {
	my $session = shift;
	print "\tGiving projects observer groups.\n" unless $quiet;
	$session->db->write($_) for(<<'EOT',
  ALTER TABLE PM_project
   ADD COLUMN projectObserver varchar(22) character set utf8 collate utf8_bin DEFAULT '7';
EOT
				   );
}

# ---- DO NOT EDIT BELOW THIS LINE ----

#-------------------------------------------------
sub start {
	my $configFile;
	$|=1; #disable output buffering
	GetOptions(
    		'configFile=s'=>\$configFile,
        	'quiet'=>\$quiet
	);
	my $session = WebGUI::Session->open("../..",$configFile);
	$session->user({userId=>3});
	my $versionTag = WebGUI::VersionTag->getWorking($session);
	$versionTag->set({name=>"Upgrade to ".$toVersion});
	$session->db->write("insert into webguiVersion values (".$session->db->quote($toVersion).",'upgrade',".$session->datetime->time().")");
	updateTemplates($session);
	return $session;
}

#-------------------------------------------------
sub finish {
	my $session = shift;
	my $versionTag = WebGUI::VersionTag->getWorking($session);
	$versionTag->commit;
	$session->close();
}

#-------------------------------------------------
sub updateTemplates {
	my $session = shift;
	return undef unless (-d "templates-".$toVersion);
        print "\tUpdating templates.\n" unless ($quiet);
	opendir(DIR,"templates-".$toVersion);
	my @files = readdir(DIR);
	closedir(DIR);
	my $importNode = WebGUI::Asset->getImportNode($session);
	my $newFolder = undef;
	foreach my $file (@files) {
		next unless ($file =~ /\.tmpl$/);
		open(FILE,"<templates-".$toVersion."/".$file);
		my $first = 1;
		my $create = 0;
		my $head = 0;
		my %properties = (className=>"WebGUI::Asset::Template");
		while (my $line = <FILE>) {
			if ($first) {
				$line =~ m/^\#(.*)$/;
				$properties{id} = $1;
				$first = 0;
			} elsif ($line =~ m/^\#create$/) {
				$create = 1;
			} elsif ($line =~ m/^\#(.*):(.*)$/) {
				$properties{$1} = $2;
			} elsif ($line =~ m/^~~~$/) {
				$head = 1;
			} elsif ($head) {
				$properties{headBlock} .= $line;
			} else {
				$properties{template} .= $line;	
			}
		}
		close(FILE);
		if ($create) {
			$newFolder = createNewTemplatesFolder($importNode) unless (defined $newFolder);
			my $template = $newFolder->addChild(\%properties, $properties{id});
		} else {
			my $template = WebGUI::Asset->new($session,$properties{id}, "WebGUI::Asset::Template");
			if (defined $template) {
				my $newRevision = $template->addRevision(\%properties);
			}
		}
	}
}

#-------------------------------------------------
sub createNewTemplatesFolder {
	my $importNode = shift;
	my $newFolder = $importNode->addChild({
		className=>"WebGUI::Asset::Wobject::Folder",
		title => $toVersion." New Templates",
		menuTitle => $toVersion." New Templates",
		url=> $toVersion."_new_templates",
		groupIdView=>"12"
		});
	return $newFolder;
}



