describe "Rubinius::ToolSets.create" do
  it "creates a new ToolSet" do
    m = Rubinius::ToolSets.current
    Rubinius::ToolSets.create.should_not equal(m)
  end

  it "accepts an optional name for the ToolSet" do
    ts = Rubinius::ToolSets.create :a_tool_set
    ts.name.should == "Rubinius::ToolSets::AToolSet"
  end

  it "sets .current to the ToolSet that is yielded to the block" do
    Rubinius::ToolSets.create do |ts|
      ts.should equal(Rubinius::ToolSets.current)
    end
  end

  it "resets $LOADED_FEATURES while running the block" do
    Rubinius::ToolSets.create do
      $LOADED_FEATURES.should == []
    end
  end

  it "sets the 'ToolSet' constant on the yielded ToolSet to refer to itself" do
    Rubinius::ToolSets.create :spec do |ts|
      ts.should equal(ts::ToolSet)
    end
  end
end

describe "Rubinius::ToolSets.current" do
  it "returns the ToolSet created by .create" do
    ts = Rubinius::ToolSets.create
    Rubinius::ToolSets.current.should equal(ts)
  end

  it "returns the same ToolSet on each call" do
    ts = Rubinius::ToolSets.current
    ts.should equal(Rubinius::ToolSets.current)
  end
end
