module Rubinius
  config = {}
  config[:config_file] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/config.rb"
  config[:command_line] = ["--prefix=/usr/local/lib/rubinius", "--rake=/usr/local/bin/rake20", "--gem=gem20", "--make=gmake", "--disable-llvm", "--libc=/usr/lib/libc.so.77", "--with-execinfo"]
  config[:build_make] = "gmake"
  config[:build_rake] = "/usr/local/bin/rake20"
  config[:build_perl] = "perl"
  config[:llvm] = :no
  config[:llvm_configure] = ""
  config[:llvm_version] = "3.2"
  config[:llvm_shared] = false
  config[:cc] = "cc"
  config[:cxx] = "g++"
  config[:ldshared] = "cc -shared -fPIC"
  config[:ldsharedxx] = "g++ -shared -lstdc++ -fPIC"
  config[:gcc_major] = "4.2"
  config[:user_cflags] = "-O2 -pipe"
  config[:user_cxxflags] = "-DOPENSSL_NO_STATIC_ENGINE -I/usr/local/include"
  config[:user_cppflags] = "-DOPENSSL_NO_STATIC_ENGINE -I/usr/local/include"
  config[:user_ldflags] = "-L/usr/local/lib"
  config[:system_cflags] = "-fPIC"
  config[:system_cxxflags] = ""
  config[:system_cppflags] = ""
  config[:system_ldflags] = "-pthread -rdynamic -Wl,--export-dynamic"
  config[:include_dirs] = ["/usr/local/include"]
  config[:lib_dirs] = ["/usr/local/lib"]
  config[:defines] = ["HAS_EXECINFO", "HAVE_SPT_REUSEARGV", "HAVE_CLOCK_GETTIME", "HAVE_NL_LANGINFO", "HAVE_STRNLEN", "HAVE_TM_GMTOFF", "HAVE_TM_ZONE", "HAVE_TIMEZONE", "HAVE_TZNAME", "HAVE_STRING_H", "HAVE_SYS_TIME_H", "HAVE_SYS_TIMES_H", "HAVE_SYS_TYPES_H", "HAVE_UNISTD_H", "HAVE_STDARG_H"]
  config[:curses] = "curses"
  config[:host] = "amd64-unknown-openbsd5.6"
  config[:cpu] = "amd64"
  config[:vendor] = "unknown"
  config[:os] = "openbsd"
  config[:little_endian] = true
  config[:sizeof_long] = 8
  config[:x86_32] = false
  config[:x86_64] = true
  config[:dtrace] = false
  config[:fibers] = true
  config[:debug_build] = false
  config[:sourcedir] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9"
  config[:stagingdir] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/staging"
  config[:build_prefix] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/staging"
  config[:runtime_gems_dir] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/staging/runtime/gems"
  config[:bootstrap_gems_dir] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/bootstrap/gems"
  config[:capi_includedir] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/vm/include/capi"
  config[:build_exe] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/staging/bin/rbx"
  config[:prefixdir] = "/usr/local/lib/rubinius"
  config[:bindir] = "/bin"
  config[:libdir] = "/library"
  config[:encdir] = "/library/encoding/converter"
  config[:runtimedir] = "/runtime"
  config[:kerneldir] = "/kernel"
  config[:sitedir] = "/site"
  config[:vendordir] = "/vendor"
  config[:includedir] = "/vm/include/capi"
  config[:mandir] = "/man"
  config[:gemsdir] = "/gems"
  config[:gems_cache] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/vendor/cache"
  config[:gems_list] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/gems_list.txt"
  config[:gem_files] = ["bundler-1.6.2.gem", "ffi2-generators-0.1.1.gem", "json-1.8.1.gem", "minitest-4.7.5.gem", "racc-1.4.11.gem", "rake-10.3.2.gem", "rdoc-4.1.1.gem", "rubinius-ast-2.1.3.gem", "rubinius-build_tools-2.0.0.gem", "rubinius-compiler-2.1.1.gem", "rubinius-coverage-2.0.3.gem", "rubinius-debugger-2.0.3.gem", "rubinius-developer_tools-2.0.0.gem", "rubinius-melbourne-2.1.0.0.gem", "rubinius-processor-2.1.2.gem", "rubinius-profiler-2.0.1.gem", "rubinius-toolset-2.2.0.gem", "rubysl-2.0.15.gem", "rubysl-abbrev-2.0.4.gem", "rubysl-base64-2.0.0.gem", "rubysl-benchmark-2.0.1.gem", "rubysl-bigdecimal-2.0.2.gem", "rubysl-cgi-2.0.1.gem", "rubysl-cgi-session-2.0.1.gem", "rubysl-cmath-2.0.0.gem", "rubysl-complex-2.0.0.gem", "rubysl-continuation-2.0.0.gem", "rubysl-coverage-2.0.3.gem", "rubysl-csv-2.0.2.gem", "rubysl-curses-2.0.1.gem", "rubysl-date-2.0.6.gem", "rubysl-delegate-2.0.1.gem", "rubysl-digest-2.0.3.gem", "rubysl-drb-2.0.1.gem", "rubysl-e2mmap-2.0.0.gem", "rubysl-english-2.0.0.gem", "rubysl-enumerator-2.0.0.gem", "rubysl-erb-2.0.1.gem", "rubysl-etc-2.0.3.gem", "rubysl-expect-2.0.0.gem", "rubysl-fcntl-2.0.4.gem", "rubysl-fiber-2.0.0.gem", "rubysl-fileutils-2.0.3.gem", "rubysl-find-2.0.1.gem", "rubysl-forwardable-2.0.1.gem", "rubysl-getoptlong-2.0.0.gem", "rubysl-gserver-2.0.0.gem", "rubysl-io-console-2.0.0.gem", "rubysl-io-nonblock-2.0.0.gem", "rubysl-io-wait-2.0.0.gem", "rubysl-ipaddr-2.0.0.gem", "rubysl-irb-2.0.4.gem", "rubysl-logger-2.0.0.gem", "rubysl-mathn-2.0.0.gem", "rubysl-matrix-2.1.0.gem", "rubysl-mkmf-2.0.1.gem", "rubysl-monitor-2.0.0.gem", "rubysl-mutex_m-2.0.0.gem", "rubysl-net-ftp-2.0.1.gem", "rubysl-net-http-2.0.4.gem", "rubysl-net-imap-2.0.1.gem", "rubysl-net-pop-2.0.1.gem", "rubysl-net-protocol-2.0.1.gem", "rubysl-net-smtp-2.0.1.gem", "rubysl-net-telnet-2.0.0.gem", "rubysl-nkf-2.0.1.gem", "rubysl-observer-2.0.0.gem", "rubysl-open-uri-2.0.0.gem", "rubysl-open3-2.0.0.gem", "rubysl-openssl-2.1.0.gem", "rubysl-optparse-2.0.1.gem", "rubysl-ostruct-2.0.4.gem", "rubysl-pathname-2.0.0.gem", "rubysl-prettyprint-2.0.3.gem", "rubysl-prime-2.0.1.gem", "rubysl-profile-2.0.0.gem", "rubysl-profiler-2.0.1.gem", "rubysl-pstore-2.0.0.gem", "rubysl-pty-2.0.2.gem", "rubysl-rational-2.0.1.gem", "rubysl-readline-2.0.2.gem", "rubysl-resolv-2.1.0.gem", "rubysl-rexml-2.0.2.gem", "rubysl-rinda-2.0.1.gem", "rubysl-rss-2.0.0.gem", "rubysl-scanf-2.0.0.gem", "rubysl-securerandom-2.0.0.gem", "rubysl-set-2.0.1.gem", "rubysl-shellwords-2.0.0.gem", "rubysl-singleton-2.0.0.gem", "rubysl-socket-2.0.1.gem", "rubysl-stringio-2.0.0.gem", "rubysl-strscan-2.0.0.gem", "rubysl-sync-2.0.0.gem", "rubysl-syslog-2.0.1.gem", "rubysl-tempfile-2.0.1.gem", "rubysl-test-unit-2.0.3.gem", "rubysl-thread-2.0.2.gem", "rubysl-thwait-2.0.0.gem", "rubysl-time-2.0.3.gem", "rubysl-timeout-2.0.0.gem", "rubysl-tmpdir-2.0.1.gem", "rubysl-tsort-2.0.1.gem", "rubysl-un-2.0.0.gem", "rubysl-uri-2.0.0.gem", "rubysl-weakref-2.0.0.gem", "rubysl-webrick-2.0.0.gem", "rubysl-xmlrpc-2.0.0.gem", "rubysl-yaml-2.0.4.gem", "rubysl-zlib-2.0.1.gem"]
  config[:program_name] = "rbx"
  config[:bin_links] = ["ruby", "rake", "gem", "irb", "rdoc", "ri", "erb"]
  config[:use_bin_links] = true
  config[:rpath] = true
  config[:windows] = false
  config[:darwin] = false
  config[:bsd] = true
  config[:linux] = false
  config[:vendor_zlib] = false
  config[:vm_release_h] = "/usr/obj/rubinius-2.2.9/rubinius-2.2.9/vm/gen/release.h"
  config[:bootstrap_gems] = ["ffi2-generators", "rubysl-etc", "rubysl-fileutils", "rubysl-mkmf", "rubysl-shellwords", "rubysl-date", "rubysl-delegate", "rubysl-digest", "rubysl-etc", "rubysl-fcntl", "rubysl-fileutils", "rubysl-monitor", "rubysl-openssl", "rubysl-optparse", "rubysl-stringio", "rubysl-strscan", "rubysl-tempfile", "rubysl-thread", "rubysl-tmpdir", "rubysl-uri", "rubysl-yaml", "rubysl-zlib"]
  config[:runtime_gems] = ["rubinius-ast", "rubinius-compiler", "rubinius-melbourne", "rubinius-processor", "rubinius-toolset"]
  config[:ruby_version] = "2.1.0"
  config[:version] = "2.2.9"
  config[:libversion] = "2.2"
  config[:patch_version] = "9"
  config[:release_date] = "2014-06-10"
  config[:revision] = "8694b613fb41a8391f8ddbd473e1f050d6349514"

  if Rubinius.constants.map { |x| x.to_s }.include?("BUILD_CONFIG")
    self::BUILD_CONFIG.replace config
  else
    self::BUILD_CONFIG = config 
  end
end
