/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private boolean changed = false;
    protected AbstractInterpreterEditor pathEditor;

    protected abstract AbstractInterpreterEditor getInterpreterEditor(Composite var1);

    protected abstract IInterpreterManager getInterpreterManager();

    public AbstractInterpreterPreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.changed = false;
    }

    protected boolean checkChangedAndMarkUnchanged() {
        boolean ret = this.changed || this.pathEditor.checkChangedAndMarkUnchanged();
        this.changed = false;
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.changed = true;
        super.performApply();
    }

    protected void performDefaults() {
    }

    public boolean performCancel() {
        this.changed = false;
        return super.performCancel();
    }

    public boolean performOk() {
        super.performOk();
        if (this.checkChangedAndMarkUnchanged()) {
            this.restoreModules();
            this.getInterpreterManager().saveInterpretersInfoModulesManager();
        }
        return true;
    }

    protected void doRestore(IProgressMonitor monitor) {
        IInterpreterManager iMan = this.getInterpreterManager();
        iMan.restorePythopathForAllInterpreters(monitor);
        IInterpreterInfo[] iInterpreterInfoArray = iMan.getInterpreterInfos();
        int n = iInterpreterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInfo interpreter = iInterpreterInfoArray[n2];
            AbstractShell.stopServerShell(interpreter, 1);
            ++n2;
        }
    }

    protected void setInfos(List<IInterpreterInfo> allButTheseInterpreters, IProgressMonitor monitor) {
        IInterpreterManager iMan = this.getInterpreterManager();
        iMan.setInfos(allButTheseInterpreters);
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.pathEditor = this.getInterpreterEditor(p);
        this.addField(this.pathEditor);
    }

    protected void restoreModules() {
        final IInterpreterInfo[] exesList = this.pathEditor.getExesList();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
        monitorDialog.setBlockOnOpen(false);
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Restoring PYTHONPATH", -1);
                    AbstractInterpreterPreferencesPage.this.setInfos(Arrays.asList(exesList), monitor);
                    AbstractInterpreterPreferencesPage.this.doRestore(monitor);
                    monitor.done();
                }
            };
            monitorDialog.run(true, true, operation);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }
}

