/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Range;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class IntRange
extends AbstractList
implements Range {
    private int from;
    private int to;
    private boolean reverse;

    public IntRange(int from, int to) {
        if (from > to) {
            this.from = to;
            this.to = from;
            this.reverse = true;
        } else {
            this.from = from;
            this.to = to;
        }
    }

    protected IntRange(int from, int to, boolean reverse) {
        this.from = from;
        this.to = to;
        this.reverse = reverse;
    }

    public boolean equals(Object that) {
        if (that instanceof IntRange) {
            return this.equals((IntRange)that);
        }
        if (that instanceof List) {
            return this.equals((List)that);
        }
        return false;
    }

    public boolean equals(List that) {
        int size = this.size();
        if (that.size() == size) {
            for (int i = 0; i < size; ++i) {
                if (DefaultTypeTransformation.compareEqual(this.get(i), that.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(IntRange that) {
        return this.reverse == that.reverse && this.from == that.from && this.to == that.to;
    }

    public Object get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " should not be negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " too big for range: " + this);
        }
        int value = this.reverse ? this.to - index : index + this.from;
        return new Integer(value);
    }

    public int size() {
        return this.to - this.from + 1;
    }

    public int hashCode() {
        return this.from ^ this.to + (this.reverse ? 1 : 0);
    }

    public Iterator iterator() {
        return new Iterator(){
            int index = 0;
            int size = IntRange.this.size();
            int value = IntRange.access$000(IntRange.this) ? IntRange.access$100(IntRange.this) : IntRange.access$200(IntRange.this);

            public boolean hasNext() {
                return this.index < this.size;
            }

            public Object next() {
                if (this.index++ > 0) {
                    if (this.index > this.size) {
                        return null;
                    }
                    this.value = IntRange.this.reverse ? --this.value : ++this.value;
                }
                return new Integer(this.value);
            }

            public void remove() {
                IntRange.this.remove(this.index);
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        return new IntRange(fromIndex + this.from, toIndex + this.from - 1, this.reverse);
    }

    public String toString() {
        return this.reverse ? "" + this.to + ".." + this.from : "" + this.from + ".." + this.to;
    }

    public String inspect() {
        return this.toString();
    }

    public boolean contains(Object value) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            int i = integer;
            return i >= this.from && i <= this.to;
        }
        if (value instanceof IntRange) {
            IntRange range = (IntRange)value;
            return this.from <= range.from && range.to <= this.to;
        }
        return false;
    }

    static /* synthetic */ int access$100(IntRange x0) {
        return x0.to;
    }

    static /* synthetic */ int access$200(IntRange x0) {
        return x0.from;
    }
}

