/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.utility.MPXJDateFormat;
import net.sf.mpxj.utility.MPXJNumberFormat;
import net.sf.mpxj.utility.MPXJTimeFormat;

public final class MPXJFormats {
    private Locale m_locale;
    private String m_nullText;
    private ProjectFile m_projectFile;
    private MPXJNumberFormat m_unitsDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_decimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_currencyFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_durationDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_percentageDecimalFormat = new MPXJNumberFormat();
    private MPXJDateFormat m_dateTimeFormat = new MPXJDateFormat();
    private MPXJDateFormat m_dateFormat = new MPXJDateFormat();
    private MPXJTimeFormat m_timeFormat = new MPXJTimeFormat();

    public MPXJFormats(Locale locale, String string, ProjectFile projectFile) {
        this.m_locale = locale;
        this.m_nullText = string;
        this.m_projectFile = projectFile;
        this.update();
    }

    public void update() {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        char c = projectHeader.getDecimalSeparator();
        char c2 = projectHeader.getThousandsSeparator();
        this.m_unitsDecimalFormat.applyPattern("#.##", null, c, c2);
        this.m_decimalFormat.applyPattern("0.00#", null, c, c2);
        this.m_durationDecimalFormat.applyPattern("#.##", null, c, c2);
        this.m_percentageDecimalFormat.applyPattern("##0.##", null, c, c2);
        this.updateCurrencyFormats(projectHeader, c, c2);
        this.updateDateTimeFormats(projectHeader);
    }

    private void updateCurrencyFormats(ProjectHeader projectHeader, char c, char c2) {
        String string;
        String string2;
        String string3;
        String string4 = "";
        String string5 = "";
        String string6 = this.quoteFormatCharacters(projectHeader.getCurrencySymbol());
        switch (projectHeader.getSymbolPosition()) {
            case AFTER: {
                string5 = string6;
                break;
            }
            case BEFORE: {
                string4 = string6;
                break;
            }
            case AFTER_WITH_SPACE: {
                string5 = " " + string6;
                break;
            }
            case BEFORE_WITH_SPACE: {
                string4 = string6 + " ";
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string4);
        stringBuffer.append("#0");
        int n = projectHeader.getCurrencyDigits().intValue();
        if (n > 0) {
            stringBuffer.append('.');
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("0");
            }
        }
        stringBuffer.append(string5);
        String string7 = stringBuffer.toString();
        String[] stringArray = new String[7];
        stringArray[0] = string7 + ";(" + string7 + ")";
        stringBuffer.insert(string4.length(), "#,#");
        stringArray[1] = string3 = stringBuffer.toString();
        stringArray[2] = string3 + ";(" + string3 + ")";
        stringBuffer.setLength(0);
        stringBuffer.append("#0");
        if (n > 0) {
            stringBuffer.append('.');
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("0");
            }
        }
        stringArray[3] = string2 = stringBuffer.toString();
        stringArray[4] = string2 + ";(" + string2 + ")";
        stringBuffer.insert(0, "#,#");
        stringArray[5] = string = stringBuffer.toString();
        stringArray[6] = string + ";(" + string + ")";
        this.m_currencyFormat.applyPattern(string7, stringArray, c, c2);
    }

    private String quoteFormatCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    stringBuffer.append("'");
                    stringBuffer.append(c);
                    stringBuffer.append("'");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void updateDateTimeFormats(ProjectHeader projectHeader) {
        String string = "";
        String string2 = "";
        String string3 = this.getTimeElement(projectHeader);
        char c = projectHeader.getDateSeparator();
        DateOrder dateOrder = projectHeader.getDateOrder();
        switch (dateOrder) {
            case DMY: {
                string = "dd" + c + "MM" + c + "yy";
                break;
            }
            case MDY: {
                string = "MM" + c + "dd" + c + "yy";
                break;
            }
            case YMD: {
                string = "yy" + c + "MM" + c + "dd";
            }
        }
        block5 : switch (projectHeader.getDateFormat()) {
            case DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM" + c + "yy " + string3;
                        break;
                    }
                    case MDY: {
                        string2 = "MM" + c + "dd" + c + "yy " + string3;
                        break;
                    }
                    case YMD: {
                        string2 = "yy" + c + "MM" + c + "dd " + string3;
                    }
                }
                break;
            }
            case DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM" + c + "yy";
                        break;
                    }
                    case MDY: {
                        string2 = "MM" + c + "dd" + c + "yy";
                        break;
                    }
                    case YMD: {
                        string2 = "yy" + c + "MM" + c + "dd";
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMMMM yyyy " + string3;
                        break;
                    }
                    case MDY: {
                        string2 = "MMMMM dd yyyy " + string3;
                        break;
                    }
                    case YMD: {
                        string2 = "yyyy MMMMM dd " + string3;
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMMMM yyyy";
                        break;
                    }
                    case MDY: {
                        string2 = "MMMMM dd yyyy";
                        break;
                    }
                    case YMD: {
                        string2 = "yyyy MMMMM dd";
                    }
                }
                break;
            }
            case DD_MMM_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMM " + string3;
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = " MMM dd " + string3;
                    }
                }
                break;
            }
            case DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMM ''yy";
                        break;
                    }
                    case MDY: {
                        string2 = "MMM dd ''yy";
                        break;
                    }
                    case YMD: {
                        string2 = "''yy MMM dd";
                    }
                }
                break;
            }
            case DD_MMMMM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMMMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "MMMMM dd";
                    }
                }
                break;
            }
            case DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd MMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "MMM dd";
                    }
                }
                break;
            }
            case EEE_DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd" + c + "MM" + c + "yy " + string3;
                        break;
                    }
                    case MDY: {
                        string2 = "EEE MM" + c + "dd" + c + "yy " + string3;
                        break;
                    }
                    case YMD: {
                        string2 = "EEE yy" + c + "MM" + c + "dd " + string3;
                    }
                }
                break;
            }
            case EEE_DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd" + c + "MM" + c + "yy";
                        break;
                    }
                    case MDY: {
                        string2 = "EEE MM" + c + "dd" + c + "yy";
                        break;
                    }
                    case YMD: {
                        string2 = "EEE yy" + c + "MM" + c + "dd";
                    }
                }
                break;
            }
            case EEE_DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd MMM ''yy";
                        break;
                    }
                    case MDY: {
                        string2 = "EEE MM dd ''yy";
                        break;
                    }
                    case YMD: {
                        string2 = "EEE ''yy MMM dd";
                    }
                }
                break;
            }
            case EEE_HH_MM: {
                string2 = "EEE " + string3;
                break;
            }
            case DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "MM" + c + "dd";
                    }
                }
                break;
            }
            case DD: {
                string2 = "dd";
                break;
            }
            case HH_MM: {
                string2 = string3;
                break;
            }
            case EEE_DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd MMM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "EEE MMM dd";
                    }
                }
                break;
            }
            case EEE_DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "EEE dd" + c + "MM";
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        string2 = "EEE MM" + c + "dd";
                    }
                }
                break;
            }
            case EEE_DD: {
                string2 = "EEE dd";
                break;
            }
            case DD_WWW: {
                string2 = "F" + c + "'W'ww";
                break;
            }
            case DD_WWW_YY_HH_MM: {
                string2 = "F" + c + "'W'ww" + c + "yy " + string3;
                break;
            }
            case DD_MM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        string2 = "dd" + c + "MM" + c + "yyyy";
                        break block5;
                    }
                    case MDY: {
                        string2 = "MM" + c + "dd" + c + "yyyy";
                        break block5;
                    }
                    case YMD: {
                        string2 = "yyyy" + c + "MM" + c + "dd";
                    }
                }
            }
        }
        this.m_dateTimeFormat.applyPattern(string2);
        this.m_dateFormat.applyPattern(string);
        this.m_timeFormat.applyPattern(string3);
        this.m_dateTimeFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_dateFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_timeFormat.setNullText(this.m_nullText);
        this.m_dateTimeFormat.setAmPmText(projectHeader.getAMText(), projectHeader.getPMText());
        this.m_timeFormat.setAmPmText(projectHeader.getAMText(), projectHeader.getPMText());
    }

    private String getTimeElement(ProjectHeader projectHeader) {
        char c = projectHeader.getTimeSeparator();
        ProjectTimeFormat projectTimeFormat = projectHeader.getTimeFormat();
        String string = projectTimeFormat == null || projectTimeFormat == ProjectTimeFormat.TWELVE_HOUR ? "hh" + c + "mm a" : "HH" + c + "mm";
        return string;
    }

    public NumberFormat getUnitsDecimalFormat() {
        return this.m_unitsDecimalFormat;
    }

    public NumberFormat getDecimalFormat() {
        return this.m_decimalFormat;
    }

    public NumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    public NumberFormat getDurationDecimalFormat() {
        return this.m_durationDecimalFormat;
    }

    public NumberFormat getPercentageDecimalFormat() {
        return this.m_percentageDecimalFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public String getNullText() {
        return this.m_nullText;
    }
}

