/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.MapRow;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.WbsRowComparator;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.InputStreamTokenizer;
import net.sf.mpxj.utility.MPXJNumberFormat;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimaveraXERFileReader
extends AbstractProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    boolean m_skipTable;
    private Map<String, List<Row>> m_tables;
    private String m_currentTableName;
    private List<Row> m_currentTable;
    private String[] m_currentFieldNames;
    private String m_defaultCurrencyName;
    private Map<String, MPXJNumberFormat> m_currencyMap = new HashMap<String, MPXJNumberFormat>();
    private MPXJNumberFormat m_numberFormat;
    private Row m_defaultCurrencyData;
    private DateFormat m_df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final List<Row> EMPTY_TABLE = new LinkedList<Row>();
    private List<ProjectListener> m_projectListeners;
    private static final Map<String, RecordType> RECORD_TYPE_MAP = new HashMap<String, RecordType>();
    private static final Map<String, FieldType> FIELD_TYPE_MAP;
    private static final Set<String> REQUIRED_TABLES;
    private static final WbsRowComparator WBS_ROW_COMPARATOR;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public void setProjectID(int n) {
        this.m_projectID = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new MPXJNumberFormat();
            this.processFile(inputStream);
            this.m_reader = new PrimaveraReader();
            ProjectFile projectFile = this.m_reader.getProject();
            projectFile.addProjectListeners(this.m_projectListeners);
            this.processProjectID();
            this.processProjectHeader();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            projectFile.updateStructure();
            ProjectFile projectFile2 = projectFile;
            Object var5_4 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            return projectFile2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        try {
            LinkedList<ProjectFile> linkedList = new LinkedList<ProjectFile>();
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new MPXJNumberFormat();
            this.processFile(inputStream);
            List<Row> list = this.getRows("project", null, null);
            for (Row row : list) {
                this.setProjectID(row.getInt("proj_id"));
                this.m_reader = new PrimaveraReader();
                ProjectFile projectFile = this.m_reader.getProject();
                projectFile.addProjectListeners(this.m_projectListeners);
                this.processProjectHeader();
                this.processCalendars();
                this.processResources();
                this.processTasks();
                this.processPredecessors();
                this.processAssignments();
                this.m_reader = null;
                projectFile.updateStructure();
                linkedList.add(projectFile);
            }
            LinkedList<ProjectFile> linkedList2 = linkedList;
            Object var8_7 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            return linkedList2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            throw throwable;
        }
    }

    private void processFile(InputStream inputStream) throws MPXJException {
        int n = 1;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[6];
            byArray[0] = (byte)bufferedInputStream.read();
            bufferedInputStream.mark(1024);
            bufferedInputStream.read(byArray, 1, 5);
            if (!new String(byArray).equals("ERMHDR")) {
                throw new MPXJException("Invalid file format");
            }
            bufferedInputStream.reset();
            InputStreamTokenizer inputStreamTokenizer = new InputStreamTokenizer(bufferedInputStream);
            inputStreamTokenizer.setDelimiter('\t');
            ArrayList<String> arrayList = new ArrayList<String>();
            while (inputStreamTokenizer.getType() != -1) {
                this.readRecord(inputStreamTokenizer, arrayList);
                if (!this.processRecord(arrayList)) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new MPXJException("Error reading file (failed at line " + n + ")", exception);
        }
    }

    private void processProjectID() {
        List<Row> list;
        if (this.m_projectID == null && !(list = this.getRows("project", null, null)).isEmpty()) {
            Row row = list.get(0);
            this.m_projectID = row.getInteger("proj_id");
        }
    }

    private void processCurrency(Row row) {
        String string = row.getString("curr_short_name");
        MPXJNumberFormat mPXJNumberFormat = new MPXJNumberFormat();
        mPXJNumberFormat.applyPattern("#.#", null, row.getString("decimal_symbol").charAt(0), row.getString("digit_group_symbol").charAt(0));
        this.m_currencyMap.put(string, mPXJNumberFormat);
        if (string.equalsIgnoreCase(this.m_defaultCurrencyName)) {
            this.m_numberFormat = mPXJNumberFormat;
            this.m_defaultCurrencyData = row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> listProjects(InputStream inputStream) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(inputStream);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            List<Row> list = this.getRows("project", null, null);
            for (Row row : list) {
                Integer n = row.getInteger("proj_id");
                String string = row.getString("proj_short_name");
                hashMap.put(n, string);
            }
            HashMap<Integer, String> hashMap2 = hashMap;
            Object var9_8 = null;
            this.m_tables = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            return hashMap2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.m_tables = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            throw throwable;
        }
    }

    private void processProjectHeader() {
        List<Row> list = this.getRows("project", "proj_id", this.m_projectID);
        this.m_reader.processProjectHeader(list);
        if (this.m_defaultCurrencyData != null) {
            this.m_reader.processDefaultCurrency(this.m_defaultCurrencyData);
        }
    }

    private void processCalendars() {
        List<Row> list = this.getRows("calendar", null, null);
        this.m_reader.processCalendars(list);
    }

    private void processResources() {
        List<Row> list = this.getRows("rsrc", null, null);
        this.m_reader.processResources(list);
    }

    private void processTasks() {
        List<Row> list = this.getRows("projwbs", "proj_id", this.m_projectID);
        List<Row> list2 = this.getRows("task", "proj_id", this.m_projectID);
        Collections.sort(list, WBS_ROW_COMPARATOR);
        this.m_reader.processTasks(list, list2);
    }

    private void processPredecessors() {
        List<Row> list = this.getRows("taskpred", "proj_id", this.m_projectID);
        this.m_reader.processPredecessors(list);
    }

    private void processAssignments() {
        List<Row> list = this.getRows("taskrsrc", "proj_id", this.m_projectID);
        this.m_reader.processAssignments(list);
    }

    private void readRecord(Tokenizer tokenizer, List<String> list) throws IOException {
        list.clear();
        while (tokenizer.nextToken() == -3) {
            list.add(tokenizer.getToken());
        }
    }

    private boolean processRecord(List<String> list) throws MPXJException {
        boolean bl = false;
        RecordType recordType = RECORD_TYPE_MAP.get(list.get(0));
        if (recordType == null) {
            throw new MPXJException("Invalid format");
        }
        switch (recordType) {
            case HEADER: {
                this.processHeader(list);
                break;
            }
            case TABLE: {
                this.m_currentTableName = list.get(1).toLowerCase();
                boolean bl2 = this.m_skipTable = !REQUIRED_TABLES.contains(this.m_currentTableName);
                if (this.m_skipTable) {
                    this.m_currentTable = null;
                    break;
                }
                this.m_currentTable = new LinkedList<Row>();
                this.m_tables.put(this.m_currentTableName, this.m_currentTable);
                break;
            }
            case FIELDS: {
                if (this.m_skipTable) {
                    this.m_currentFieldNames = null;
                    break;
                }
                this.m_currentFieldNames = list.toArray(new String[list.size()]);
                for (int i = 0; i < this.m_currentFieldNames.length; ++i) {
                    this.m_currentFieldNames[i] = this.m_currentFieldNames[i].toLowerCase();
                }
                break;
            }
            case DATA: {
                if (this.m_skipTable) break;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (int i = 1; i < list.size(); ++i) {
                    Object object;
                    String string = this.m_currentFieldNames[i];
                    String string2 = list.get(i);
                    FieldType fieldType = FIELD_TYPE_MAP.get(string);
                    if (fieldType == null) {
                        fieldType = FieldType.STRING;
                    }
                    if (string2.length() == 0) {
                        object = null;
                    } else {
                        switch (fieldType) {
                            case DATE: {
                                try {
                                    object = this.m_df.parseObject(string2);
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid date", parseException);
                                }
                            }
                            case CURRENCY: {
                                try {
                                    object = this.m_numberFormat.parse(string2).doubleValue();
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid number or number format", parseException);
                                }
                            }
                            case DOUBLE: {
                                try {
                                    object = this.m_numberFormat.parse(string2).doubleValue();
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid number or number format", parseException);
                                }
                            }
                            case DURATION: {
                                try {
                                    object = this.m_numberFormat.parse(string2).doubleValue();
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid number or number format", parseException);
                                }
                            }
                            case INTEGER: {
                                object = Integer.valueOf(string2);
                                break;
                            }
                            default: {
                                object = string2;
                            }
                        }
                    }
                    hashMap.put(string, object);
                }
                MapRow mapRow = new MapRow(hashMap);
                this.m_currentTable.add(mapRow);
                if (!this.m_currentTableName.equals("currtype")) break;
                this.processCurrency(mapRow);
                break;
            }
            case END: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void processHeader(List<String> list) {
        this.m_defaultCurrencyName = list.get(8);
    }

    private List<Row> getRows(String string, String string2, Integer n) {
        List<Row> list;
        List<Row> list2 = this.m_tables.get(string);
        if (list2 == null) {
            list = EMPTY_TABLE;
        } else if (string2 == null) {
            list = list2;
        } else {
            list = new LinkedList<Row>();
            for (Row row : list2) {
                if (!NumberUtility.equals(n, row.getInteger(string2))) continue;
                list.add(row);
            }
        }
        return list;
    }

    static {
        RECORD_TYPE_MAP.put("RMHDR", RecordType.HEADER);
        RECORD_TYPE_MAP.put("%T", RecordType.TABLE);
        RECORD_TYPE_MAP.put("%F", RecordType.FIELDS);
        RECORD_TYPE_MAP.put("%R", RecordType.DATA);
        RECORD_TYPE_MAP.put("%E", RecordType.END);
        FIELD_TYPE_MAP = new HashMap<String, FieldType>();
        FIELD_TYPE_MAP.put("proj_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("plan_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("plan_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("rsrc_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("wbs_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("orig_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_total_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("anticip_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("anticip_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("parent_wbs_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("task_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("phys_complete_pct", FieldType.DOUBLE);
        FIELD_TYPE_MAP.put("remain_drtn_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("act_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_drtn_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("cstr_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("act_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("act_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("late_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("late_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("expect_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("early_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("early_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("create_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("pred_task_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("lag_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("act_reg_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("act_reg_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("act_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("act_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("clndr_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("default_flag", FieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_name", FieldType.STRING);
        FIELD_TYPE_MAP.put("proj_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("base_clndr_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("last_chng_date", FieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_type", FieldType.STRING);
        FIELD_TYPE_MAP.put("day_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("week_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("month_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("year_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("clndr_data", FieldType.STRING);
        FIELD_TYPE_MAP.put("seq_num", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("taskrsrc_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("parent_rsrc_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("free_float_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("total_float_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("decimal_digit_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("target_qty_per_hr", FieldType.DOUBLE);
        FIELD_TYPE_MAP.put("target_lag_drtn_hr_cnt", FieldType.DURATION);
        REQUIRED_TABLES = new HashSet<String>();
        REQUIRED_TABLES.add("project");
        REQUIRED_TABLES.add("calendar");
        REQUIRED_TABLES.add("rsrc");
        REQUIRED_TABLES.add("projwbs");
        REQUIRED_TABLES.add("task");
        REQUIRED_TABLES.add("taskpred");
        REQUIRED_TABLES.add("taskrsrc");
        REQUIRED_TABLES.add("currtype");
        WBS_ROW_COMPARATOR = new WbsRowComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FieldType {
        STRING,
        INTEGER,
        DOUBLE,
        DATE,
        DURATION,
        CURRENCY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RecordType {
        HEADER,
        TABLE,
        FIELDS,
        DATA,
        END;

    }
}

