/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPPAssignmentField;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.SplitTaskFactory;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkData;
import net.sf.mpxj.TimephasedWorkNormaliser;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDITimephasedWorkNormaliser;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSPDIReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private boolean m_compatibleInput = true;
    protected ProjectFile m_projectFile;
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_projectFile.addProjectListeners(this.m_projectListeners);
            this.m_projectFile.setAutoTaskID(false);
            this.m_projectFile.setAutoTaskUniqueID(false);
            this.m_projectFile.setAutoResourceID(false);
            this.m_projectFile.setAutoResourceUniqueID(false);
            this.m_projectFile.setAutoOutlineLevel(false);
            this.m_projectFile.setAutoOutlineNumber(false);
            this.m_projectFile.setAutoWBS(false);
            this.m_projectFile.setAutoCalendarUniqueID(false);
            this.m_projectFile.setAutoAssignmentUniqueID(false);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(inputStream));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            if (this.m_compatibleInput) {
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent validationEvent) {
                        return true;
                    }
                });
            }
            Project project = (Project)unmarshaller.unmarshal((Source)sAXSource);
            HashMap<BigInteger, ProjectCalendar> hashMap = new HashMap<BigInteger, ProjectCalendar>();
            this.readProjectHeader(project);
            this.readProjectExtendedAttributes(project);
            this.readCalendars(project, hashMap);
            this.readResources(project, hashMap);
            this.readTasks(project);
            this.readAssignments(project);
            this.m_projectFile.updateUniqueCounters();
            ProjectCalendar projectCalendar = hashMap.get(project.getCalendarUID());
            if (projectCalendar != null) {
                this.m_projectFile.getProjectHeader().setCalendarName(projectCalendar.getName());
            }
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MPXJException("Failed to parse file", parserConfigurationException);
        }
        catch (JAXBException jAXBException) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)jAXBException));
        }
        catch (SAXException sAXException) {
            throw new MPXJException("Failed to parse file", sAXException);
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void readProjectHeader(Project project) {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        projectHeader.setActualsInSync(BooleanUtility.getBoolean(project.isActualsInSync()));
        projectHeader.setAdminProject(BooleanUtility.getBoolean(project.isAdminProject()));
        projectHeader.setAuthor(project.getAuthor());
        projectHeader.setAutoAddNewResourcesAndTasks(BooleanUtility.getBoolean(project.isAutoAddNewResourcesAndTasks()));
        projectHeader.setAutolink(BooleanUtility.getBoolean(project.isAutolink()));
        projectHeader.setBaselineForEarnedValue(NumberUtility.getInteger(project.getBaselineForEarnedValue()));
        projectHeader.setCalendarName(project.getCalendarUID() == null ? null : project.getCalendarUID().toString());
        projectHeader.setCategory(project.getCategory());
        projectHeader.setCompany(project.getCompany());
        projectHeader.setCreationDate(DatatypeConverter.parseDate(project.getCreationDate()));
        projectHeader.setCriticalSlackLimit(NumberUtility.getInteger(project.getCriticalSlackLimit()));
        projectHeader.setCurrencyDigits(NumberUtility.getInteger(project.getCurrencyDigits()));
        projectHeader.setCurrencyCode(project.getCurrencyCode());
        projectHeader.setCurrencySymbol(project.getCurrencySymbol());
        projectHeader.setCurrentDate(DatatypeConverter.parseDate(project.getCurrentDate()));
        projectHeader.setDaysPerMonth(NumberUtility.getInteger(project.getDaysPerMonth()));
        projectHeader.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        projectHeader.setDefaultEndTime(DatatypeConverter.parseTime(project.getDefaultFinishTime()));
        projectHeader.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        projectHeader.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate()));
        projectHeader.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate()));
        projectHeader.setDefaultStartTime(DatatypeConverter.parseTime(project.getDefaultStartTime()));
        projectHeader.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        projectHeader.setDefaultTaskType(project.getDefaultTaskType());
        projectHeader.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        projectHeader.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        projectHeader.setEditableActualCosts(BooleanUtility.getBoolean(project.isEditableActualCosts()));
        projectHeader.setExtendedCreationDate(DatatypeConverter.parseDate(project.getExtendedCreationDate()));
        projectHeader.setFinishDate(DatatypeConverter.parseDate(project.getFinishDate()));
        projectHeader.setFiscalYearStart(BooleanUtility.getBoolean(project.isFiscalYearStart()));
        projectHeader.setFiscalYearStartMonth(NumberUtility.getInteger(project.getFYStartDate()));
        projectHeader.setHonorConstraints(BooleanUtility.getBoolean(project.isHonorConstraints()));
        projectHeader.setInsertedProjectsLikeSummary(BooleanUtility.getBoolean(project.isInsertedProjectsLikeSummary()));
        projectHeader.setLastSaved(DatatypeConverter.parseDate(project.getLastSaved()));
        projectHeader.setManager(project.getManager());
        projectHeader.setMicrosoftProjectServerURL(BooleanUtility.getBoolean(project.isMicrosoftProjectServerURL()));
        projectHeader.setMinutesPerDay(NumberUtility.getInteger(project.getMinutesPerDay()));
        projectHeader.setMinutesPerWeek(NumberUtility.getInteger(project.getMinutesPerWeek()));
        projectHeader.setMoveCompletedEndsBack(BooleanUtility.getBoolean(project.isMoveCompletedEndsBack()));
        projectHeader.setMoveCompletedEndsForward(BooleanUtility.getBoolean(project.isMoveCompletedEndsForward()));
        projectHeader.setMoveRemainingStartsBack(BooleanUtility.getBoolean(project.isMoveRemainingStartsBack()));
        projectHeader.setMoveRemainingStartsForward(BooleanUtility.getBoolean(project.isMoveRemainingStartsForward()));
        projectHeader.setMultipleCriticalPaths(BooleanUtility.getBoolean(project.isMultipleCriticalPaths()));
        projectHeader.setName(project.getName());
        projectHeader.setNewTasksEffortDriven(BooleanUtility.getBoolean(project.isNewTasksEffortDriven()));
        projectHeader.setNewTasksEstimated(BooleanUtility.getBoolean(project.isNewTasksEstimated()));
        projectHeader.setNewTaskStartIsProjectStart(NumberUtility.getInt(project.getNewTaskStartDate()) == 0);
        projectHeader.setProjectExternallyEdited(BooleanUtility.getBoolean(project.isProjectExternallyEdited()));
        projectHeader.setProjectTitle(project.getTitle());
        projectHeader.setRemoveFileProperties(BooleanUtility.getBoolean(project.isRemoveFileProperties()));
        projectHeader.setRevision(NumberUtility.getInteger(project.getRevision()));
        projectHeader.setScheduleFrom(BooleanUtility.getBoolean(project.isScheduleFromStart()) ? ScheduleFrom.START : ScheduleFrom.FINISH);
        projectHeader.setSubject(project.getSubject());
        projectHeader.setSplitInProgressTasks(BooleanUtility.getBoolean(project.isSplitsInProgressTasks()));
        projectHeader.setSpreadActualCost(BooleanUtility.getBoolean(project.isSpreadActualCost()));
        projectHeader.setSpreadPercentComplete(BooleanUtility.getBoolean(project.isSpreadPercentComplete()));
        projectHeader.setStartDate(DatatypeConverter.parseDate(project.getStartDate()));
        projectHeader.setStatusDate(DatatypeConverter.parseDate(project.getStatusDate()));
        projectHeader.setSymbolPosition(project.getCurrencySymbolPosition());
        projectHeader.setUniqueID(project.getUID());
        projectHeader.setUpdatingTaskStatusUpdatesResourceStatus(BooleanUtility.getBoolean(project.isTaskUpdatesResource()));
        projectHeader.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
    }

    private void readCalendars(Project project, HashMap<BigInteger, ProjectCalendar> hashMap) {
        Object object;
        Project.Calendars calendars = project.getCalendars();
        if (calendars != null) {
            object = new LinkedList();
            for (Project.Calendars.Calendar object2 : calendars.getCalendar()) {
                this.readCalendar(object2, hashMap, (LinkedList<Pair<ProjectCalendar, BigInteger>>)object);
            }
            MSPDIReader.updateBaseCalendarNames((List<Pair<ProjectCalendar, BigInteger>>)object, hashMap);
        }
        try {
            object = this.m_projectFile.getProjectHeader();
            BigInteger bigInteger = new BigInteger(((ProjectHeader)object).getCalendarName());
            ProjectCalendar projectCalendar = hashMap.get(bigInteger);
            this.m_projectFile.setCalendar(projectCalendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void updateBaseCalendarNames(List<Pair<ProjectCalendar, BigInteger>> list, HashMap<BigInteger, ProjectCalendar> hashMap) {
        for (Pair<ProjectCalendar, BigInteger> pair : list) {
            ProjectCalendar projectCalendar = pair.getFirst();
            BigInteger bigInteger = pair.getSecond();
            ProjectCalendar projectCalendar2 = hashMap.get(bigInteger);
            if (projectCalendar2 == null) continue;
            projectCalendar.setParent(projectCalendar2);
        }
    }

    private void readCalendar(Project.Calendars.Calendar calendar, HashMap<BigInteger, ProjectCalendar> hashMap, LinkedList<Pair<ProjectCalendar, BigInteger>> linkedList) {
        Project.Calendars.Calendar.WeekDays weekDays;
        ProjectCalendar projectCalendar = BooleanUtility.getBoolean(calendar.isIsBaseCalendar()) ? this.m_projectFile.addBaseCalendar() : this.m_projectFile.addResourceCalendar();
        projectCalendar.setUniqueID(NumberUtility.getInteger(calendar.getUID()));
        projectCalendar.setName(calendar.getName());
        BigInteger bigInteger = calendar.getBaseCalendarUID();
        if (bigInteger != null) {
            linkedList.add(new Pair<ProjectCalendar, BigInteger>(projectCalendar, bigInteger));
        }
        if ((weekDays = calendar.getWeekDays()) != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay weekDay : weekDays.getWeekDay()) {
                this.readDay(projectCalendar, weekDay);
            }
        } else {
            projectCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        }
        this.readExceptions(calendar, projectCalendar);
        this.readWorkWeeks(calendar, projectCalendar);
        hashMap.put(calendar.getUID(), projectCalendar);
        this.m_projectFile.fireCalendarReadEvent(projectCalendar);
    }

    private void readDay(ProjectCalendar projectCalendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        BigInteger bigInteger = weekDay.getDayType();
        if (bigInteger != null) {
            if (bigInteger.intValue() == 0) {
                this.readExceptionDay(projectCalendar, weekDay);
            } else {
                this.readNormalDay(projectCalendar, weekDay);
            }
        }
    }

    private void readNormalDay(ProjectCalendar projectCalendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        int n = weekDay.getDayType().intValue();
        Day day = Day.getInstance(n);
        projectCalendar.setWorkingDay(day, BooleanUtility.getBoolean(weekDay.isDayWorking()));
        ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes workingTimes = weekDay.getWorkingTimes();
        if (workingTimes != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime : workingTimes.getWorkingTime()) {
                Date date = DatatypeConverter.parseTime(workingTime.getFromTime());
                Date date2 = DatatypeConverter.parseTime(workingTime.getToTime());
                if (date == null || date2 == null) continue;
                if (date.getTime() >= date2.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date2);
                    calendar.add(6, 1);
                    date2 = calendar.getTime();
                }
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar projectCalendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod timePeriod = weekDay.getTimePeriod();
        Date date = DatatypeConverter.parseDate(timePeriod.getFromDate());
        Date date2 = DatatypeConverter.parseDate(timePeriod.getToDate());
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes workingTimes = weekDay.getWorkingTimes();
        ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
        if (workingTimes != null) {
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> list = workingTimes.getWorkingTime();
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime : list) {
                Date date3 = DatatypeConverter.parseTime(workingTime.getFromTime());
                Date date4 = DatatypeConverter.parseTime(workingTime.getToTime());
                if (date3 == null || date4 == null) continue;
                if (date3.getTime() >= date4.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date4);
                    calendar.add(6, 1);
                    date4 = calendar.getTime();
                }
                projectCalendarException.addRange(new DateRange(date3, date4));
            }
        }
    }

    private void readExceptions(Project.Calendars.Calendar calendar, ProjectCalendar projectCalendar) {
        Project.Calendars.Calendar.Exceptions exceptions = calendar.getExceptions();
        if (exceptions != null) {
            for (Project.Calendars.Calendar.Exceptions.Exception exception : exceptions.getException()) {
                Date date = DatatypeConverter.parseDate(exception.getTimePeriod().getFromDate());
                Date date2 = DatatypeConverter.parseDate(exception.getTimePeriod().getToDate());
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
                Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes workingTimes = exception.getWorkingTimes();
                if (workingTimes == null) continue;
                List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> list = workingTimes.getWorkingTime();
                for (Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime workingTime : list) {
                    Date date3 = DatatypeConverter.parseTime(workingTime.getFromTime());
                    Date date4 = DatatypeConverter.parseTime(workingTime.getToTime());
                    if (date3 == null || date4 == null) continue;
                    if (date3.getTime() >= date4.getTime()) {
                        Calendar calendar2 = Calendar.getInstance();
                        calendar2.setTime(date4);
                        calendar2.add(6, 1);
                        date4 = calendar2.getTime();
                    }
                    projectCalendarException.addRange(new DateRange(date3, date4));
                }
            }
        }
    }

    private void readWorkWeeks(Project.Calendars.Calendar calendar, ProjectCalendar projectCalendar) {
        Project.Calendars.Calendar.WorkWeeks workWeeks = calendar.getWorkWeeks();
        if (workWeeks != null) {
            for (Project.Calendars.Calendar.WorkWeeks.WorkWeek workWeek : workWeeks.getWorkWeek()) {
                ProjectCalendarWeek projectCalendarWeek = projectCalendar.addWorkWeek();
                projectCalendarWeek.setName(workWeek.getName());
                Date date = DatatypeConverter.parseDate(workWeek.getTimePeriod().getFromDate());
                Date date2 = DatatypeConverter.parseDate(workWeek.getTimePeriod().getToDate());
                projectCalendarWeek.setDateRange(new DateRange(date, date2));
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays weekDays = workWeek.getWeekDays();
                if (weekDays == null) continue;
                for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay weekDay : weekDays.getWeekDay()) {
                    int n = weekDay.getDayType().intValue();
                    Day day = Day.getInstance(n);
                    projectCalendarWeek.setWorkingDay(day, BooleanUtility.getBoolean(weekDay.isDayWorking()));
                    ProjectCalendarHours projectCalendarHours = projectCalendarWeek.addCalendarHours(day);
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes workingTimes = weekDay.getWorkingTimes();
                    if (workingTimes == null) continue;
                    for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime : workingTimes.getWorkingTime()) {
                        date = DatatypeConverter.parseTime(workingTime.getFromTime());
                        date2 = DatatypeConverter.parseTime(workingTime.getToTime());
                        if (date == null || date2 == null) continue;
                        if (date.getTime() >= date2.getTime()) {
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.setTime(date2);
                            calendar2.add(6, 1);
                            date2 = calendar2.getTime();
                        }
                        projectCalendarHours.addRange(new DateRange(date, date2));
                    }
                }
            }
        }
    }

    private void readProjectExtendedAttributes(Project project) {
        Project.ExtendedAttributes extendedAttributes = project.getExtendedAttributes();
        if (extendedAttributes != null) {
            for (Project.ExtendedAttributes.ExtendedAttribute extendedAttribute : extendedAttributes.getExtendedAttribute()) {
                this.readFieldAlias(extendedAttribute);
            }
        }
    }

    private void readFieldAlias(Project.ExtendedAttributes.ExtendedAttribute extendedAttribute) {
        String string = extendedAttribute.getAlias();
        if (string != null && string.length() != 0) {
            int n = Integer.parseInt(extendedAttribute.getFieldID());
            int n2 = n & 0xFFFF0000;
            int n3 = n & 0xFFFF;
            switch (n2) {
                case 0xB400000: {
                    TaskField taskField = MPPTaskField.getInstance(n3);
                    if (taskField == null) break;
                    this.m_projectFile.setTaskFieldAlias(taskField, extendedAttribute.getAlias());
                    break;
                }
                case 0xC400000: {
                    ResourceField resourceField = MPPResourceField.getInstance(n3);
                    if (resourceField == null) break;
                    this.m_projectFile.setResourceFieldAlias(resourceField, extendedAttribute.getAlias());
                    break;
                }
            }
        }
    }

    protected void readResources(Project project, HashMap<BigInteger, ProjectCalendar> hashMap) {
        Project.Resources resources = project.getResources();
        if (resources != null) {
            for (Project.Resources.Resource resource : resources.getResource()) {
                this.readResource(resource, hashMap);
            }
        }
    }

    private void readResource(Project.Resources.Resource resource, HashMap<BigInteger, ProjectCalendar> hashMap) {
        Resource resource2 = this.m_projectFile.addResource();
        resource2.setAccrueAt(resource.getAccrueAt());
        resource2.setActveDirectoryGUID(resource.getActiveDirectoryGUID());
        resource2.setActualCost(DatatypeConverter.parseCurrency(resource.getActualCost()));
        resource2.setActualOvertimeCost(DatatypeConverter.parseCurrency(resource.getActualOvertimeCost()));
        resource2.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualOvertimeWork()));
        resource2.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualOvertimeWorkProtected()));
        resource2.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualWork()));
        resource2.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualWorkProtected()));
        resource2.setACWP(DatatypeConverter.parseCurrency(resource.getACWP()));
        resource2.setAvailableFrom(DatatypeConverter.parseDate(resource.getAvailableFrom()));
        resource2.setAvailableTo(DatatypeConverter.parseDate(resource.getAvailableTo()));
        resource2.setBCWS(DatatypeConverter.parseCurrency(resource.getBCWS()));
        resource2.setBCWP(DatatypeConverter.parseCurrency(resource.getBCWP()));
        resource2.setBookingType(resource.getBookingType());
        resource2.setBudget(BooleanUtility.getBoolean(resource.isIsBudget()));
        resource2.setCanLevel(BooleanUtility.getBoolean(resource.isCanLevel()));
        resource2.setCode(resource.getCode());
        resource2.setCost(DatatypeConverter.parseCurrency(resource.getCost()));
        resource2.setCostPerUse(DatatypeConverter.parseCurrency(resource.getCostPerUse()));
        resource2.setCostVariance(DatatypeConverter.parseCurrency(resource.getCostVariance()));
        resource2.setCreationDate(DatatypeConverter.parseDate(resource.getCreationDate()));
        resource2.setCV(DatatypeConverter.parseCurrency(resource.getCV()));
        resource2.setEmailAddress(resource.getEmailAddress());
        resource2.setGroup(resource.getGroup());
        resource2.setHyperlink(resource.getHyperlink());
        resource2.setHyperlinkAddress(resource.getHyperlinkAddress());
        resource2.setHyperlinkSubAddress(resource.getHyperlinkSubAddress());
        resource2.setID(NumberUtility.getInteger(resource.getID()));
        resource2.setInitials(resource.getInitials());
        resource2.setIsEnterprise(BooleanUtility.getBoolean(resource.isIsEnterprise()));
        resource2.setIsGeneric(BooleanUtility.getBoolean(resource.isIsGeneric()));
        resource2.setIsInactive(BooleanUtility.getBoolean(resource.isIsInactive()));
        resource2.setIsNull(BooleanUtility.getBoolean(resource.isIsNull()));
        resource2.setMaterialLabel(resource.getMaterialLabel());
        resource2.setMaxUnits(DatatypeConverter.parseUnits(resource.getMaxUnits()));
        resource2.setName(resource.getName());
        if (resource.getNotes() != null && resource.getNotes().length() != 0) {
            resource2.setNotes(resource.getNotes());
        }
        resource2.setNtAccount(resource.getNTAccount());
        resource2.setOvertimeCost(DatatypeConverter.parseCurrency(resource.getOvertimeCost()));
        resource2.setOvertimeRate(DatatypeConverter.parseRate(resource.getOvertimeRate()));
        resource2.setOvertimeRateUnits(DatatypeConverter.parseTimeUnit(resource.getOvertimeRateFormat()));
        resource2.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getOvertimeWork()));
        resource2.setPeakUnits(DatatypeConverter.parseUnits(resource.getPeakUnits()));
        resource2.setPercentWorkComplete(resource.getPercentWorkComplete());
        resource2.setPhonetics(resource.getPhonetics());
        resource2.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getRegularWork()));
        resource2.setRemainingCost(DatatypeConverter.parseCurrency(resource.getRemainingCost()));
        resource2.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(resource.getRemainingOvertimeCost()));
        resource2.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getRemainingWork()));
        resource2.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getRemainingOvertimeWork()));
        resource2.setStandardRate(DatatypeConverter.parseRate(resource.getStandardRate()));
        resource2.setStandardRateUnits(DatatypeConverter.parseTimeUnit(resource.getStandardRateFormat()));
        resource2.setSV(DatatypeConverter.parseCurrency(resource.getSV()));
        resource2.setType(resource.getType());
        resource2.setUniqueID(NumberUtility.getInteger(resource.getUID()));
        resource2.setWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getWork()));
        resource2.setWorkGroup(resource.getWorkGroup());
        resource2.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(resource.getWorkVariance()));
        if (resource2.getType() == ResourceType.MATERIAL && BooleanUtility.getBoolean(resource.isIsCostResource())) {
            resource2.setType(ResourceType.COST);
        }
        this.readResourceExtendedAttributes(resource, resource2);
        this.readResourceBaselines(resource, resource2);
        resource2.setResourceCalendar(hashMap.get(resource.getCalendarUID()));
        resource2.setOverAllocated(BooleanUtility.getBoolean(resource.isOverAllocated()));
        this.readCostRateTables(resource2, resource.getRates());
        this.readAvailabilityTable(resource2, resource.getAvailabilityPeriods());
        this.m_projectFile.fireResourceReadEvent(resource2);
    }

    private void readResourceBaselines(Project.Resources.Resource resource, Resource resource2) {
        for (Project.Resources.Resource.Baseline baseline : resource.getBaseline()) {
            int n = NumberUtility.getInt(baseline.getNumber());
            Double d = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (n == 0) {
                resource2.setBaselineCost(d);
                resource2.setBaselineWork(duration);
                continue;
            }
            resource2.setBaselineCost(n, d);
            resource2.setBaselineWork(n, duration);
        }
    }

    private void readResourceExtendedAttributes(Project.Resources.Resource resource, Resource resource2) {
        for (Project.Resources.Resource.ExtendedAttribute extendedAttribute : resource.getExtendedAttribute()) {
            int n = Integer.parseInt(extendedAttribute.getFieldID()) & 0xFFFF;
            ResourceField resourceField = MPPResourceField.getInstance(n);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, resource2, extendedAttribute.getValue(), resourceField);
        }
    }

    private void readCostRateTables(Resource resource, Project.Resources.Resource.Rates rates) {
        if (rates == null) {
            CostRateTable costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(0, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(1, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(2, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(3, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(4, costRateTable);
        } else {
            HashSet<CostRateTable> hashSet = new HashSet<CostRateTable>();
            for (Project.Resources.Resource.Rates.Rate object : rates.getRate()) {
                Rate rate = DatatypeConverter.parseRate(object.getStandardRate());
                TimeUnit timeUnit = DatatypeConverter.parseTimeUnit(object.getStandardRateFormat());
                Rate rate2 = DatatypeConverter.parseRate(object.getOvertimeRate());
                TimeUnit timeUnit2 = DatatypeConverter.parseTimeUnit(object.getOvertimeRateFormat());
                Double d = DatatypeConverter.parseCurrency(object.getCostPerUse());
                Date date = DatatypeConverter.parseDate(object.getRatesTo());
                CostRateTableEntry costRateTableEntry = new CostRateTableEntry(rate, timeUnit, rate2, timeUnit2, d, date);
                int n = object.getRateTable().intValue();
                CostRateTable costRateTable = resource.getCostRateTable(n);
                if (costRateTable == null) {
                    costRateTable = new CostRateTable();
                    resource.setCostRateTable(n, costRateTable);
                }
                costRateTable.add(costRateTableEntry);
                hashSet.add(costRateTable);
            }
            for (CostRateTable costRateTable : hashSet) {
                Collections.sort(costRateTable);
            }
        }
    }

    private void readAvailabilityTable(Resource resource, Project.Resources.Resource.AvailabilityPeriods availabilityPeriods) {
        if (availabilityPeriods != null) {
            AvailabilityTable availabilityTable = resource.getAvailability();
            List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = availabilityPeriods.getAvailabilityPeriod();
            for (Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod availabilityPeriod : list) {
                Date date = DatatypeConverter.parseDate(availabilityPeriod.getAvailableFrom());
                Date date2 = DatatypeConverter.parseDate(availabilityPeriod.getAvailableTo());
                Number number = DatatypeConverter.parseUnits(availabilityPeriod.getAvailableUnits());
                Availability availability = new Availability(date, date2, number);
                availabilityTable.add(availability);
            }
            Collections.sort(availabilityTable);
        }
    }

    private void readTasks(Project project) {
        Project.Tasks tasks = project.getTasks();
        if (tasks != null) {
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readTask(task);
            }
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
        }
        this.m_projectFile.updateStructure();
    }

    private void readTask(Project.Tasks.Task task) {
        Task task2 = this.m_projectFile.addTask();
        task2.setNull(BooleanUtility.getBoolean(task.isIsNull()));
        task2.setID(NumberUtility.getInteger(task.getID()));
        task2.setUniqueID(NumberUtility.getInteger(task.getUID()));
        if (!task2.getNull()) {
            double d;
            TimeUnit timeUnit = DatatypeConverter.parseDurationTimeUnits(task.getDurationFormat());
            task2.setActive(task.isActive() == null ? true : BooleanUtility.getBoolean(task.isActive()));
            task2.setActualCost(DatatypeConverter.parseCurrency(task.getActualCost()));
            task2.setActualDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualDuration()));
            task2.setActualFinish(DatatypeConverter.parseDate(task.getActualFinish()));
            task2.setActualOvertimeCost(DatatypeConverter.parseCurrency(task.getActualOvertimeCost()));
            task2.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualOvertimeWork()));
            task2.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualOvertimeWorkProtected()));
            task2.setActualStart(DatatypeConverter.parseDate(task.getActualStart()));
            task2.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualWork()));
            task2.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualWorkProtected()));
            task2.setACWP(DatatypeConverter.parseCurrency(task.getACWP()));
            task2.setCalendar(this.getTaskCalendar(task));
            task2.setConstraintDate(DatatypeConverter.parseDate(task.getConstraintDate()));
            task2.setConstraintType(DatatypeConverter.parseConstraintType(task.getConstraintType()));
            task2.setContact(task.getContact());
            task2.setCost(DatatypeConverter.parseCurrency(task.getCost()));
            task2.setCreateDate(DatatypeConverter.parseDate(task.getCreateDate()));
            task2.setCV(DatatypeConverter.parseCurrency(task.getCV()));
            task2.setDeadline(DatatypeConverter.parseDate(task.getDeadline()));
            task2.setDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getDuration()));
            task2.setDurationText(task.getDurationText());
            task2.setEarlyFinish(DatatypeConverter.parseDate(task.getEarlyFinish()));
            task2.setEarlyStart(DatatypeConverter.parseDate(task.getEarlyStart()));
            task2.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(task.getEarnedValueMethod()));
            task2.setEffortDriven(BooleanUtility.getBoolean(task.isEffortDriven()));
            task2.setEstimated(BooleanUtility.getBoolean(task.isEstimated()));
            task2.setExternalTask(BooleanUtility.getBoolean(task.isExternalTask()));
            task2.setProject(task.getExternalTaskProject());
            task2.setFinish(DatatypeConverter.parseDate(task.getFinish()));
            task2.setFinishText(task.getFinishText());
            task2.setFinishVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(task.getFinishVariance()));
            task2.setFixedCost(DatatypeConverter.parseCurrency(task.getFixedCost()));
            task2.setFixedCostAccrual(task.getFixedCostAccrual());
            task2.setFreeSlack(DatatypeConverter.parseDurationInThousanthsOfMinutes(task.getFreeSlack()));
            task2.setHideBar(BooleanUtility.getBoolean(task.isHideBar()));
            task2.setHyperlink(task.getHyperlink());
            task2.setHyperlinkAddress(task.getHyperlinkAddress());
            task2.setHyperlinkSubAddress(task.getHyperlinkSubAddress());
            task2.setIgnoreResourceCalendar(BooleanUtility.getBoolean(task.isIgnoreResourceCalendar()));
            task2.setLateFinish(DatatypeConverter.parseDate(task.getLateFinish()));
            task2.setLateStart(DatatypeConverter.parseDate(task.getLateStart()));
            task2.setLevelAssignments(BooleanUtility.getBoolean(task.isLevelAssignments()));
            task2.setLevelingCanSplit(BooleanUtility.getBoolean(task.isLevelingCanSplit()));
            task2.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(task.getLevelingDelayFormat()));
            if (task.getLevelingDelay() != null && task2.getLevelingDelayFormat() != null && (d = task.getLevelingDelay().doubleValue()) != 0.0) {
                task2.setLevelingDelay(Duration.convertUnits(d / 10.0, TimeUnit.MINUTES, task2.getLevelingDelayFormat(), this.m_projectFile.getProjectHeader()));
            }
            task2.setMilestone(BooleanUtility.getBoolean(task.isMilestone()));
            task2.setName(task.getName());
            if (task.getNotes() != null && task.getNotes().length() != 0) {
                task2.setNotes(task.getNotes());
            }
            task2.setOutlineLevel(NumberUtility.getInteger(task.getOutlineLevel()));
            task2.setOutlineNumber(task.getOutlineNumber());
            task2.setOverAllocated(BooleanUtility.getBoolean(task.isOverAllocated()));
            task2.setOvertimeCost(DatatypeConverter.parseCurrency(task.getOvertimeCost()));
            task2.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getOvertimeWork()));
            task2.setPercentageComplete(task.getPercentComplete());
            task2.setPercentageWorkComplete(task.getPercentWorkComplete());
            task2.setPhysicalPercentComplete(NumberUtility.getInteger(task.getPhysicalPercentComplete()));
            task2.setPreleveledFinish(DatatypeConverter.parseDate(task.getPreLeveledFinish()));
            task2.setPreleveledStart(DatatypeConverter.parseDate(task.getPreLeveledStart()));
            task2.setPriority(DatatypeConverter.parsePriority(task.getPriority()));
            task2.setRecurring(BooleanUtility.getBoolean(task.isRecurring()));
            task2.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRegularWork()));
            task2.setRemainingCost(DatatypeConverter.parseCurrency(task.getRemainingCost()));
            task2.setRemainingDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRemainingDuration()));
            task2.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(task.getRemainingOvertimeCost()));
            task2.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRemainingOvertimeWork()));
            task2.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRemainingWork()));
            task2.setResume(DatatypeConverter.parseDate(task.getResume()));
            task2.setResumeValid(BooleanUtility.getBoolean(task.isResumeValid()));
            task2.setRollup(BooleanUtility.getBoolean(task.isRollup()));
            task2.setStart(DatatypeConverter.parseDate(task.getStart()));
            task2.setStartText(task.getStartText());
            task2.setStartVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(task.getStartVariance()));
            task2.setStop(DatatypeConverter.parseDate(task.getStop()));
            task2.setSubProject(BooleanUtility.getBoolean(task.isIsSubproject()) ? new SubProject() : null);
            task2.setSubprojectName(task.getSubprojectName());
            task2.setSubprojectReadOnly(BooleanUtility.getBoolean(task.isIsSubprojectReadOnly()));
            task2.setSummary(BooleanUtility.getBoolean(task.isSummary()));
            task2.setTaskMode(BooleanUtility.getBoolean(task.isManual()) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED);
            task2.setType(task.getType());
            task2.setWBS(task.getWBS());
            task2.setWBSLevel(task.getWBSLevel());
            task2.setWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getWork()));
            task2.setWorkVariance(Duration.getInstance(NumberUtility.getDouble(task.getWorkVariance()) / 1000.0, TimeUnit.MINUTES));
            task2.setTotalSlack(DatatypeConverter.parseDurationInThousanthsOfMinutes(task.getTotalSlack()));
            task2.setCritical(BooleanUtility.getBoolean(task.isCritical()));
            this.readTaskExtendedAttributes(task, task2);
            this.readTaskBaselines(task, task2, timeUnit);
            if (task2.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                task2.setManualDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getManualDuration()));
            }
        }
        this.m_projectFile.fireTaskReadEvent(task2);
    }

    private void readTaskBaselines(Project.Tasks.Task task, Task task2, TimeUnit timeUnit) {
        for (Project.Tasks.Task.Baseline baseline : task.getBaseline()) {
            int n = NumberUtility.getInt(baseline.getNumber());
            Double d = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, baseline.getDuration());
            Date date = DatatypeConverter.parseDate(baseline.getFinish());
            Date date2 = DatatypeConverter.parseDate(baseline.getStart());
            Duration duration2 = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (n == 0) {
                task2.setBaselineCost(d);
                task2.setBaselineDuration(duration);
                task2.setBaselineFinish(date);
                task2.setBaselineStart(date2);
                task2.setBaselineWork(duration2);
                continue;
            }
            task2.setBaselineCost(n, d);
            task2.setBaselineDuration(n, duration);
            task2.setBaselineFinish(n, date);
            task2.setBaselineStart(n, date2);
            task2.setBaselineWork(n, duration2);
        }
    }

    private void readTaskExtendedAttributes(Project.Tasks.Task task, Task task2) {
        for (Project.Tasks.Task.ExtendedAttribute extendedAttribute : task.getExtendedAttribute()) {
            int n = Integer.parseInt(extendedAttribute.getFieldID()) & 0xFFFF;
            TaskField taskField = MPPTaskField.getInstance(n);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, task2, extendedAttribute.getValue(), taskField);
        }
    }

    private ProjectCalendar getTaskCalendar(Project.Tasks.Task task) {
        ProjectCalendar projectCalendar = null;
        BigInteger bigInteger = task.getCalendarUID();
        if (bigInteger != null) {
            projectCalendar = this.m_projectFile.getBaseCalendarByUniqueID(bigInteger.intValue());
        }
        return projectCalendar;
    }

    protected void readPredecessors(Project.Tasks.Task task) {
        Task task2;
        Integer n = task.getUID();
        if (n != null && (task2 = this.m_projectFile.getTaskByUniqueID(n)) != null) {
            for (Project.Tasks.Task.PredecessorLink predecessorLink : task.getPredecessorLink()) {
                this.readPredecessor(task2, predecessorLink);
            }
        }
    }

    protected void readPredecessor(Task task, Project.Tasks.Task.PredecessorLink predecessorLink) {
        Task task2;
        BigInteger bigInteger = predecessorLink.getPredecessorUID();
        if (bigInteger != null && (task2 = this.m_projectFile.getTaskByUniqueID(bigInteger.intValue())) != null) {
            RelationType relationType = predecessorLink.getType() != null ? RelationType.getInstance(predecessorLink.getType().intValue()) : RelationType.FINISH_START;
            int n = predecessorLink.getLinkLag() != null ? predecessorLink.getLinkLag().intValue() / 10 : 0;
            TimeUnit timeUnit = DatatypeConverter.parseDurationTimeUnits(predecessorLink.getLagFormat());
            Duration duration = Duration.convertUnits(n, TimeUnit.MINUTES, timeUnit, this.m_projectFile.getProjectHeader());
            Relation relation = task.addPredecessor(task2, relationType, duration);
            this.m_projectFile.fireRelationReadEvent(relation);
        }
    }

    private void readAssignments(Project project) {
        Project.Assignments assignments = project.getAssignments();
        if (assignments != null) {
            SplitTaskFactory splitTaskFactory = new SplitTaskFactory();
            MSPDITimephasedWorkNormaliser mSPDITimephasedWorkNormaliser = new MSPDITimephasedWorkNormaliser();
            for (Project.Assignments.Assignment assignment : assignments.getAssignment()) {
                this.readAssignment(assignment, splitTaskFactory, mSPDITimephasedWorkNormaliser);
            }
        }
    }

    protected ResourceAssignment readAssignment(Project.Assignments.Assignment assignment, SplitTaskFactory splitTaskFactory, TimephasedWorkNormaliser timephasedWorkNormaliser) {
        BigInteger bigInteger = assignment.getTaskUID();
        BigInteger bigInteger2 = assignment.getResourceUID();
        if (bigInteger != null && bigInteger2 != null) {
            Task task = this.m_projectFile.getTaskByUniqueID(bigInteger.intValue());
            Resource resource = this.m_projectFile.getResourceByUniqueID(bigInteger2.intValue());
            ProjectCalendar projectCalendar = null;
            if (resource != null) {
                projectCalendar = resource.getResourceCalendar();
            }
            if (projectCalendar == null) {
                projectCalendar = task.getCalendar();
            }
            if (projectCalendar == null) {
                projectCalendar = this.m_projectFile.getCalendar();
            }
            LinkedList<TimephasedWork> linkedList = this.readTimephasedAssignment(projectCalendar, assignment, 2);
            LinkedList<TimephasedWork> linkedList2 = this.readTimephasedAssignment(projectCalendar, assignment, 1);
            boolean bl = true;
            if (this.isSplit(projectCalendar, linkedList) || this.isSplit(projectCalendar, linkedList2)) {
                task.setSplits(new LinkedList<DateRange>());
                timephasedWorkNormaliser.normalise(projectCalendar, linkedList);
                timephasedWorkNormaliser.normalise(projectCalendar, linkedList2);
                splitTaskFactory.processSplitData(task, linkedList, linkedList2);
                bl = false;
            }
            TimephasedWorkData timephasedWorkData = new TimephasedWorkData(projectCalendar, timephasedWorkNormaliser, linkedList, bl);
            TimephasedWorkData timephasedWorkData2 = new TimephasedWorkData(projectCalendar, timephasedWorkNormaliser, linkedList2, bl);
            if (task != null) {
                ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
                resourceAssignment.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
                resourceAssignment.setActualFinish(DatatypeConverter.parseDate(assignment.getActualFinish()));
                resourceAssignment.setActualOvertimeCost(DatatypeConverter.parseCurrency(assignment.getActualOvertimeCost()));
                resourceAssignment.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualOvertimeWork()));
                resourceAssignment.setActualStart(DatatypeConverter.parseDate(assignment.getActualStart()));
                resourceAssignment.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualWork()));
                resourceAssignment.setACWP(DatatypeConverter.parseCurrency(assignment.getACWP()));
                resourceAssignment.setBCWP(DatatypeConverter.parseCurrency(assignment.getBCWP()));
                resourceAssignment.setBCWS(DatatypeConverter.parseCurrency(assignment.getBCWS()));
                resourceAssignment.setBudgetCost(DatatypeConverter.parseCurrency(assignment.getBudgetCost()));
                resourceAssignment.setBudgetWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getBudgetWork()));
                resourceAssignment.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
                resourceAssignment.setCostRateTableIndex(NumberUtility.getInt(assignment.getCostRateTable()));
                resourceAssignment.setCreateDate(DatatypeConverter.parseDate(assignment.getCreationDate()));
                resourceAssignment.setCV(DatatypeConverter.parseCurrency(assignment.getCV()));
                resourceAssignment.setDelay(DatatypeConverter.parseDurationInThousanthsOfMinutes(assignment.getDelay()));
                resourceAssignment.setFinish(DatatypeConverter.parseDate(assignment.getFinish()));
                resourceAssignment.setVariableRateUnits(BooleanUtility.getBoolean(assignment.isHasFixedRateUnits()) ? null : DatatypeConverter.parseTimeUnit(assignment.getRateScale()));
                resourceAssignment.setHyperlink(assignment.getHyperlink());
                resourceAssignment.setHyperlinkAddress(assignment.getHyperlinkAddress());
                resourceAssignment.setHyperlinkSubAddress(assignment.getHyperlinkSubAddress());
                resourceAssignment.setLevelingDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectHeader(), assignment.getLevelingDelay(), DatatypeConverter.parseDurationTimeUnits(assignment.getLevelingDelayFormat())));
                resourceAssignment.setNotes(assignment.getNotes());
                resourceAssignment.setOvertimeCost(DatatypeConverter.parseCurrency(assignment.getOvertimeCost()));
                resourceAssignment.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getOvertimeWork()));
                resourceAssignment.setPercentageWorkComplete(assignment.getPercentWorkComplete());
                resourceAssignment.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRegularWork()));
                resourceAssignment.setRemainingCost(DatatypeConverter.parseCurrency(assignment.getRemainingCost()));
                resourceAssignment.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(assignment.getRemainingOvertimeCost()));
                resourceAssignment.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingOvertimeWork()));
                resourceAssignment.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingWork()));
                resourceAssignment.setStart(DatatypeConverter.parseDate(assignment.getStart()));
                resourceAssignment.setSV(DatatypeConverter.parseCurrency(assignment.getSV()));
                resourceAssignment.setUniqueID(NumberUtility.getInteger(assignment.getUID()));
                resourceAssignment.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
                resourceAssignment.setVAC(DatatypeConverter.parseCurrency(assignment.getVAC()));
                resourceAssignment.setWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getWork()));
                resourceAssignment.setWorkContour(assignment.getWorkContour());
                resourceAssignment.setTimephasedActualWork(timephasedWorkData);
                resourceAssignment.setTimephasedWork(timephasedWorkData2);
                this.readAssignmentExtendedAttributes(assignment, resourceAssignment);
                this.readAssignmentBaselines(assignment, resourceAssignment);
                resourceAssignment.setCostVariance(DatatypeConverter.parseCurrency(assignment.getCostVariance()));
                resourceAssignment.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(this.m_projectFile.getProjectHeader(), assignment.getWorkVariance(), TimeUnit.HOURS));
                resourceAssignment.setStartVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectHeader(), assignment.getStartVariance(), TimeUnit.DAYS));
                resourceAssignment.setFinishVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectHeader(), assignment.getFinishVariance(), TimeUnit.DAYS));
                this.m_projectFile.fireAssignmentReadEvent(resourceAssignment);
                return resourceAssignment;
            }
        }
        return null;
    }

    private void readAssignmentBaselines(Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment) {
        for (Project.Assignments.Assignment.Baseline baseline : assignment.getBaseline()) {
            int n = NumberUtility.getInt(baseline.getNumber());
            Number number = DatatypeConverter.parseExtendedAttributeCurrency(baseline.getCost());
            Date date = DatatypeConverter.parseExtendedAttributeDate(baseline.getFinish());
            Date date2 = DatatypeConverter.parseExtendedAttributeDate(baseline.getStart());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (n == 0) {
                resourceAssignment.setBaselineCost(number);
                resourceAssignment.setBaselineFinish(date);
                resourceAssignment.setBaselineStart(date2);
                resourceAssignment.setBaselineWork(duration);
                continue;
            }
            resourceAssignment.setBaselineCost(n, number);
            resourceAssignment.setBaselineWork(n, duration);
            resourceAssignment.setBaselineStart(n, date2);
            resourceAssignment.setBaselineFinish(n, date);
        }
    }

    private void readAssignmentExtendedAttributes(Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment) {
        for (Project.Assignments.Assignment.ExtendedAttribute extendedAttribute : assignment.getExtendedAttribute()) {
            int n = Integer.parseInt(extendedAttribute.getFieldID()) & 0xFFFF;
            AssignmentField assignmentField = MPPAssignmentField.getInstance(n);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, resourceAssignment, extendedAttribute.getValue(), assignmentField);
        }
    }

    private boolean isSplit(ProjectCalendar projectCalendar, List<TimephasedWork> list) {
        boolean bl = false;
        for (TimephasedWork timephasedWork : list) {
            Duration duration;
            if (((Duration)timephasedWork.getTotalAmount()).getDuration() != 0.0 || (duration = projectCalendar.getWork(timephasedWork.getStart(), timephasedWork.getFinish(), TimeUnit.MINUTES)).getDuration() == 0.0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private LinkedList<TimephasedWork> readTimephasedAssignment(ProjectCalendar projectCalendar, Project.Assignments.Assignment assignment, int n) {
        LinkedList<TimephasedWork> linkedList = new LinkedList<TimephasedWork>();
        for (TimephasedDataType timephasedDataType : assignment.getTimephasedData()) {
            if (NumberUtility.getInt(timephasedDataType.getType()) != n) continue;
            Date date = DatatypeConverter.parseDate(timephasedDataType.getStart());
            Date date2 = DatatypeConverter.parseDate(timephasedDataType.getFinish());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.MINUTES, timephasedDataType.getValue());
            duration = duration == null ? Duration.getInstance(0, TimeUnit.MINUTES) : Duration.getInstance(NumberUtility.truncate(duration.getDuration(), 2.0), TimeUnit.MINUTES);
            TimephasedWork timephasedWork = new TimephasedWork();
            timephasedWork.setStart(date);
            timephasedWork.setFinish(date2);
            timephasedWork.setTotalAmount(duration);
            linkedList.add(timephasedWork);
        }
        return linkedList;
    }

    public void setMicrosoftProjectCompatibleInput(boolean bl) {
        this.m_compatibleInput = bl;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.mspdi.schema", (ClassLoader)MSPDIReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
    }
}

