/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Locale;
import net.sf.mpxj.CodePage;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.mpx.LocaleData;

final class LocaleUtility {
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{new Locale("EN"), new Locale("DE"), new Locale("FR"), new Locale("IT"), new Locale("PT"), new Locale("SV"), new Locale("ZH"), new Locale("ES"), new Locale("RU")};

    private LocaleUtility() {
    }

    public static void setLocale(ProjectFile projectFile, Locale locale) {
        projectFile.setDelimiter(LocaleData.getChar(locale, "FILE_DELIMITER"));
        LocaleUtility.setLocale(projectFile.getFileCreationRecord(), locale);
        LocaleUtility.setLocale(projectFile.getProjectHeader(), locale);
    }

    private static void setLocale(FileCreationRecord fileCreationRecord, Locale locale) {
        fileCreationRecord.setDelimiter(LocaleData.getChar(locale, "FILE_DELIMITER"));
        fileCreationRecord.setProgramName(LocaleData.getString(locale, "PROGRAM_NAME"));
        fileCreationRecord.setCodePage((CodePage)((Object)LocaleData.getObject(locale, "CODE_PAGE")));
    }

    private static void setLocale(ProjectHeader projectHeader, Locale locale) {
        projectHeader.setCurrencySymbol(LocaleData.getString(locale, "CURRENCY_SYMBOL"));
        projectHeader.setSymbolPosition((CurrencySymbolPosition)LocaleData.getObject(locale, "CURRENCY_SYMBOL_POSITION"));
        projectHeader.setCurrencyDigits(LocaleData.getInteger(locale, "CURRENCY_DIGITS"));
        projectHeader.setThousandsSeparator(LocaleData.getChar(locale, "CURRENCY_THOUSANDS_SEPARATOR"));
        projectHeader.setDecimalSeparator(LocaleData.getChar(locale, "CURRENCY_DECIMAL_SEPARATOR"));
        projectHeader.setDateOrder((DateOrder)LocaleData.getObject(locale, "DATE_ORDER"));
        projectHeader.setTimeFormat((ProjectTimeFormat)LocaleData.getObject(locale, "TIME_FORMAT"));
        projectHeader.setIntegerDefaultStartTime(LocaleData.getInteger(locale, "DEFAULT_START_TIME"));
        projectHeader.setDateSeparator(LocaleData.getChar(locale, "DATE_SEPARATOR"));
        projectHeader.setTimeSeparator(LocaleData.getChar(locale, "TIME_SEPARATOR"));
        projectHeader.setAMText(LocaleData.getString(locale, "AM_TEXT"));
        projectHeader.setPMText(LocaleData.getString(locale, "PM_TEXT"));
        projectHeader.setDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
        projectHeader.setBarTextDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
    }

    public static Locale[] getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }
}

