/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.transform;

import com.projity.field.InvalidFormulaException;
import com.projity.grouping.core.transform.CommonTransform;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Transformer;

public abstract class CommonTransformFactory
extends CommonTransform {
    protected String id = null;
    protected String name = null;
    protected String formulaText = null;
    protected boolean showSummary = true;
    protected boolean showEmptyLines = true;
    protected boolean showEndEmptyLines = true;
    protected String definition = null;
    protected String arguments = null;
    protected Transformer composition = null;
    protected boolean server;
    protected boolean showEmptySummaries = true;
    protected boolean showAssignments = true;
    protected boolean preserveHierarchy = true;

    public abstract CommonTransform getTransform() throws InvalidFormulaException;

    public CommonTransform getTransformFromDefinition() throws InvalidFormulaException {
        if (this.definition != null) {
            try {
                return (CommonTransform)Class.forName(this.definition).getConstructor(String.class).newInstance(this.arguments);
            }
            catch (Exception exception) {
                throw new InvalidFormulaException(exception);
            }
        }
        return null;
    }

    public String getFormulaText() {
        return this.formulaText;
    }

    public void setFormulaText(String string) {
        this.formulaText = string;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean bl) {
        this.showSummary = bl;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
        if (this.name == null) {
            this.setName(Messages.getString(string));
        }
    }

    public void setNameId(String string) {
        this.name = Messages.getString(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isShowEmptyLines() {
        return this.showEmptyLines;
    }

    public void setShowEmptyLines(boolean bl) {
        this.showEmptyLines = bl;
    }

    public boolean isShowEndEmptyLines() {
        return this.showEndEmptyLines;
    }

    public void setShowEndEmptyLines(boolean bl) {
        this.showEndEmptyLines = bl;
    }

    public boolean isShowEmptySummaries() {
        return this.showEmptySummaries;
    }

    public void setShowEmptySummaries(boolean bl) {
        this.showEmptySummaries = bl;
    }

    public boolean isShowAssignments() {
        return this.showAssignments;
    }

    public void setShowAssignments(boolean bl) {
        this.showAssignments = bl;
    }

    public boolean isPreserveHierarchy() {
        return this.preserveHierarchy;
    }

    public void setPreserveHierarchy(boolean bl) {
        this.preserveHierarchy = bl;
    }

    public boolean isServer() {
        return this.server;
    }

    public void setServer(boolean bl) {
        this.server = bl;
    }

    public Transformer getComposition() {
        return this.composition;
    }

    public void setComposition(Transformer transformer) {
        this.composition = transformer;
    }

    protected void setProperties(CommonTransform commonTransform) throws InvalidFormulaException {
        commonTransform.setShowEmptyLines(this.isShowEmptyLines());
        commonTransform.setShowEndEmptyLines(this.isShowEndEmptyLines());
        commonTransform.setShowSummary(this.isShowSummary());
        commonTransform.setShowEmptySummaries(this.isShowEmptySummaries());
        commonTransform.setShowAssignments(this.isShowAssignments());
        commonTransform.setPreserveHierarchy(this.isPreserveHierarchy());
        if (this.subTransforms != null) {
            ArrayList<CommonTransform> arrayList = new ArrayList<CommonTransform>();
            Iterator iterator = this.subTransforms.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((CommonTransformFactory)iterator.next()).getTransform());
            }
            commonTransform.setSubTransforms(arrayList);
        }
        commonTransform.setParameters(this.getParameters());
        commonTransform.setParametersMap(this.getParametersMap());
    }

    public String toString() {
        return this.getName();
    }

    public void setRedefinitionCallBack(Closure closure) {
    }

    public void addFactory(CommonTransformFactory commonTransformFactory) {
        if (commonTransformFactory.isServer() && Environment.getStandAlone()) {
            return;
        }
        if (this.subTransforms == null) {
            this.subTransforms = new ArrayList();
        }
        this.subTransforms.add(commonTransformFactory);
    }
}

