/*
 * Decompiled with CFR 0.152.
 */
package com.projity.contrib.calendar;

import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.time.DateUtils;
import org.jdesktop.swing.calendar.DateSpan;

public class ContribIntervals
extends TreeSet {
    public ContribIntervals() {
        super(new Comparator(){

            public int compare(Object object, Object object2) {
                DateSpan dateSpan = (DateSpan)object;
                DateSpan dateSpan2 = (DateSpan)object2;
                if (dateSpan.getStart() < dateSpan2.getStart() || dateSpan.getStart() == dateSpan2.getStart() && dateSpan.getEnd() < dateSpan2.getEnd()) {
                    return -1;
                }
                if (dateSpan.getStart() > dateSpan2.getStart() || dateSpan.getStart() == dateSpan2.getStart() && dateSpan.getEnd() > dateSpan2.getEnd()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public ContribIntervals(Comparator comparator) {
        super(comparator);
    }

    protected DateSpan createInterval(long l, long l2) {
        return new DateSpan(l, l2);
    }

    protected DateSpan mergeIntervals(DateSpan dateSpan, DateSpan dateSpan2) {
        return new DateSpan(Math.min(dateSpan.getStart(), dateSpan2.getStart()), Math.max(dateSpan.getEnd(), dateSpan2.getEnd()));
    }

    public boolean add(Object object) {
        DateSpan dateSpan;
        DateSpan dateSpan2 = (DateSpan)object;
        SortedSet<Object> sortedSet = this.headSet(object);
        if (sortedSet.size() > 0 && (dateSpan = (DateSpan)sortedSet.last()).getEnd() >= dateSpan2.getStart()) {
            dateSpan2 = this.mergeIntervals(dateSpan2, dateSpan);
        }
        if ((sortedSet = this.tailSet(object)).size() > 0) {
            dateSpan = (DateSpan)sortedSet.first();
            if (dateSpan2.getEnd() >= dateSpan.getStart()) {
                dateSpan2 = this.mergeIntervals(dateSpan2, dateSpan);
            }
        }
        return super.add(dateSpan2);
    }

    public boolean addAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!super.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public long getEnd() {
        return this.size() == 0 ? -1L : ((DateSpan)this.last()).getEnd();
    }

    public long getStart() {
        return this.size() == 0 ? -1L : ((DateSpan)this.first()).getStart();
    }

    public boolean containsDate(long l) {
        for (DateSpan dateSpan : this) {
            if (dateSpan.getStart() > l || l > dateSpan.getEnd()) continue;
            return true;
        }
        return false;
    }

    void eliminateWeekdayDuplicates(boolean[] blArray) {
        GregorianCalendar gregorianCalendar = ContribIntervals.calendarInstance();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DateSpan dateSpan = (DateSpan)iterator.next();
            gregorianCalendar.setTimeInMillis(dateSpan.getStart());
            int n = gregorianCalendar.get(7) - 1;
            for (int i = 0; i < 7; ++i) {
                if (!blArray[i] || i != n) continue;
                iterator.remove();
            }
        }
    }

    public static GregorianCalendar calendarInstance() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(DateUtils.UTC_TIME_ZONE);
        return gregorianCalendar;
    }
}

