#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFInfo2',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 87 => 0x69 },
	'about' => { 387 => 'about' },
	'abspeakaudiofilepath' => { 393 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 68 => 0x518 },
	'accelerometer' => { 308 => 0x3 },
	'accelerometerx' => { 252 => 0x8d },
	'accelerometery' => { 252 => 0x8e },
	'accelerometerz' => { 252 => 0x8c },
	'accessoryserialnumber' => { 252 => 0x54 },
	'accessorytype' => { 252 => 0x53 },
	'actionadvised' => { 103 => 0x2a },
	'activearea' => { 95 => 0xc68d },
	'actived-lighting' => { 182 => 0x22, 213 => 0x24 },
	'actived-lightingmode' => { 213 => 0x25 },
	'addaspectratioinfo' => { 68 => 0x80e },
	'additionalmodelinformation' => { 380 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 68 => 0x80f, 69 => 0x11, 70 => 0x13, 73 => 0x14 },
	'address' => { 130 => 'Address' },
	'adjustmentmode' => { 314 => 0x15 },
	'adobe' => { 96 => 'Adobe' },
	'adultcontentwarning' => { 383 => 'AdultContentWarning', 386 => 'adultContentWarning' },
	'advancedraw' => { 215 => 0x76a43203 },
	'advancedscenetype' => { 252 => 0x3d },
	'advisory' => { 391 => 'Advisory' },
	'ae_iso' => { 257 => 0x2, 258 => 0x4, 259 => 0x12 },
	'aeaperture' => { 257 => 0x1, 258 => 0x3, 259 => 0x11 },
	'aeaperturesteps' => { 257 => 0x8, 258 => 0xb },
	'aebautocancel' => { 68 => 0x104 },
	'aebbracketvalue' => { 62 => 0x11 },
	'aebsequence' => { 68 => 0x105 },
	'aebsequenceautocancel' => { 66 => 0x9, 67 => 0x9, 69 => 0x8, 70 => 0x9, 73 => 0x9, 74 => 0x7 },
	'aebshotcount' => { 68 => 0x106 },
	'aebxv' => { 257 => 0x4, 258 => 0x6 },
	'aeerror' => { 258 => 0x8 },
	'aeexposuretime' => { 257 => 0x0, 258 => 0x2, 259 => 0x10 },
	'aelbutton' => { 150 => 0x45 },
	'aelexposureindicator' => { 150 => 0x51 },
	'aelock' => { 150 => 0x5b, 223 => '4.2', 229 => '4.2', 233 => 0x201, 283 => 0x48, 321 => [0x86,0x286] },
	'aelockbutton' => { 222 => '16.1', 223 => '4.1', 224 => '15.1', 225 => '16.1', 226 => '16.1', 227 => '30.1', 228 => '16.1', 229 => '4.1', 231 => '17.1' },
	'aelockbuttonplusdials' => { 222 => '16.2', 227 => '32.1' },
	'aelockformb-d80' => { 231 => '3.1' },
	'aemaxaperture' => { 257 => 0x9, 258 => 0x10, 259 => 0x1c },
	'aemaxaperture2' => { 257 => 0xa, 258 => 0x11, 259 => 0x1d },
	'aemeteringmode' => { 257 => 0xc },
	'aemeteringmode2' => { 257 => '13.1' },
	'aemeteringsegments' => { 153 => 0x628, 283 => 0x209 },
	'aemicroadjustment' => { 68 => 0x111 },
	'aeminaperture' => { 257 => 0xb, 258 => 0x12, 259 => 0x1e },
	'aeminexposuretime' => { 257 => 0x5, 258 => 0x13, 259 => 0x1f },
	'aeprogrammode' => { 257 => 0x6 },
	'aesetting' => { 29 => 0x21 },
	'aewhitebalance' => { 257 => 0xd },
	'aexv' => { 257 => 0x3, 258 => 0x5 },
	'af-cpriorityselection' => { 222 => '1.1', 225 => '0.1', 226 => '0.1', 227 => '1.1', 228 => '0.1' },
	'af-onformb-d10' => { 222 => '3.3', 227 => '3.2' },
	'af-onformb-d11' => { 228 => '2.2' },
	'af-spriorityselection' => { 222 => '1.2', 227 => '1.2', 228 => '0.2' },
	'afactivation' => { 222 => '2.1', 227 => '2.1' },
	'afadjustment' => { 283 => 0x72 },
	'afandmeteringbuttons' => { 68 => 0x701 },
	'afaperture' => { 178 => 0x5, 179 => 0x5 },
	'afareaheight' => { 158 => 0x1a },
	'afareaillumination' => { 150 => 0x4b, 229 => '15.3' },
	'afareamode' => { 146 => 0x33, 150 => 0xe, 157 => 0x0, 158 => 0x5, 252 => 0xf, 305 => 0x1205, 315 => 0xa, 319 => 0x11, 320 => 0x10, 321 => 0x24, 331 => 0xb043, 349 => 0x17 },
	'afareamodesetting' => { 223 => '11.1', 224 => '0.1', 229 => '16.1', 231 => '2.1', 331 => 0x201c },
	'afareas' => { 233 => 0x304 },
	'afareawidth' => { 158 => 0x18 },
	'afareaxposition' => { 158 => 0x14, 305 => 0x1203 },
	'afareaxposition1' => { 305 => 0x1201 },
	'afareayposition' => { 158 => 0x16, 305 => 0x1204 },
	'afareayposition1' => { 305 => 0x1202 },
	'afassist' => { 66 => 0x5, 74 => 0x5, 150 => 0x48, 222 => '2.5', 223 => '0.2', 224 => '0.2', 225 => '1.1', 226 => '1.1', 227 => '2.4', 228 => '1.4', 229 => '0.2', 231 => '2.3' },
	'afassistbeam' => { 68 => 0x50e, 69 => 0x4, 70 => 0x5, 71 => 0x4, 72 => 0x4, 73 => 0x5 },
	'afassistlamp' => { 252 => 0x31 },
	'afbuttonpressed' => { 321 => [0x83,0x283] },
	'afdefocus' => { 260 => 0x6 },
	'afduringliveview' => { 68 => 0x511 },
	'affinea' => { 364 => 'AffineA' },
	'affineb' => { 364 => 'AffineB' },
	'affinec' => { 364 => 'AffineC' },
	'affined' => { 364 => 'AffineD' },
	'affinetune' => { 159 => 0x0, 233 => 0x306 },
	'affinetuneadj' => { 159 => 0x2, 190 => 0x2d1, 191 => 0x2dc, 233 => 0x307 },
	'affinetuneindex' => { 159 => 0x1 },
	'affinex' => { 364 => 'AffineX' },
	'affiney' => { 364 => 'AffineY' },
	'afilluminator' => { 319 => 0x29, 331 => 0xb044 },
	'afimageheight' => { 158 => 0x12 },
	'afimagewidth' => { 158 => 0x10 },
	'afintegrationtime' => { 260 => 0x7 },
	'afmicroadj' => { 315 => 0x17d },
	'afmicroadjmode' => { 2 => 0x1, 318 => 0x131 },
	'afmicroadjregisteredlenses' => { 318 => '305.1' },
	'afmicroadjustment' => { 68 => 0x507 },
	'afmicroadjvalue' => { 2 => 0x2, 318 => 0x130 },
	'afmode' => { 91 => 0x3009, 146 => 0x16, 314 => 0x5 },
	'afonaelockbuttonswitch' => { 68 => 0x702 },
	'afonbutton' => { 222 => '3.1' },
	'afpoint' => { 29 => 0x13, 90 => 0x18, 146 => 0x15, 157 => 0x1, 236 => 0x308, 314 => 0x1f, 315 => 0x7, 317 => 0x20, 318 => 0x19 },
	'afpointactivationarea' => { 67 => 0x11, 73 => 0x11 },
	'afpointareaexpansion' => { 68 => 0x508 },
	'afpointatshutterrelease' => { 315 => 0x9 },
	'afpointautoselection' => { 68 => 0x50b },
	'afpointbrightness' => { 68 => 0x50d, 222 => '2.4' },
	'afpointdisplayduringfocus' => { 68 => 0x50c },
	'afpointillumination' => { 67 => 0xa, 222 => '2.3', 227 => '2.3', 228 => '1.3', 231 => '2.4' },
	'afpointinfocus' => { 315 => 0x8 },
	'afpointmode' => { 264 => 0x3 },
	'afpointposition' => { 91 => 0x2021, 252 => 0x4d },
	'afpointregistration' => { 66 => 0x7 },
	'afpoints' => { 149 => 0x10 },
	'afpointselected' => { 150 => 0xd, 233 => 0x305, 283 => 0xe, 317 => [0x14,0x1c], 318 => 0x15, 331 => 0x201e },
	'afpointselected2' => { 264 => 0x4 },
	'afpointselection' => { 67 => 0xb, 222 => '1.3', 227 => '1.3' },
	'afpointselectionmethod' => { 68 => 0x50f, 69 => 0xc, 70 => 0xd, 73 => 0xd },
	'afpointset' => { 100 => 0x1022 },
	'afpointsetting' => { 319 => 0x12, 320 => 0x11 },
	'afpointsinfocus' => { 62 => 0xe, 157 => 0x2, 260 => 0xb, 283 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 17 => 0x38 },
	'afpointspotmetering' => { 67 => 0xd },
	'afpointsselected' => { 354 => 0x4 },
	'afpointsunknown1' => { 260 => 0x0 },
	'afpointsunknown2' => { 260 => 0x2 },
	'afpointsused' => { 158 => 0x8, 316 => 0x0 },
	'afpredictor' => { 260 => 0x4 },
	'afresponse' => { 182 => 0xad },
	'afresult' => { 238 => 0x1038 },
	'afsearch' => { 233 => 0x303 },
	'afsensoractive' => { 146 => 0x1 },
	'afstatus' => { 305 => 0x1200 },
	'afstatusactivesensor' => { 146 => 0x2 },
	'afstatusbottom' => { 146 => 0x8 },
	'afstatusbottom-left' => { 146 => 0x12 },
	'afstatusbottom-right' => { 146 => 0x6 },
	'afstatuscenterhorizontal' => { 146 => 0x2f },
	'afstatuscentervertical' => { 146 => 0xc },
	'afstatusleft' => { 146 => 0x2d },
	'afstatusmiddlehorizontal' => { 146 => 0xa },
	'afstatusright' => { 146 => 0x31 },
	'afstatustop' => { 146 => 0xe },
	'afstatustop-left' => { 146 => 0x10 },
	'afstatustop-right' => { 146 => 0x4 },
	'aftype' => { 315 => 0x2 },
	'afwithshutter' => { 319 => 0x2a },
	'aggregationtype' => { 384 => 'aggregationType' },
	'agreement' => { 386 => 'agreement' },
	'aiservocontinuousshooting' => { 67 => 0x15 },
	'aiservofirstimagepriority' => { 68 => 0x519 },
	'aiservoimagepriority' => { 68 => 0x503 },
	'aiservosecondimagepriority' => { 68 => 0x51a },
	'aiservotrackingmethod' => { 68 => 0x504 },
	'aiservotrackingsensitivity' => { 67 => 0x14, 68 => 0x502 },
	'album' => { 393 => 'album' },
	'alreadyapplied' => { 370 => 'AlreadyApplied' },
	'alternatetitle' => { 384 => 'alternateTitle' },
	'altitude' => { 160 => 0x6 },
	'alttapename' => { 393 => 'altTapeName' },
	'alttimecode' => { 393 => 'altTimecode' },
	'alttimecodetimeformat' => { 393 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 393 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 393 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 3 => 0x1 },
	'ambienttemperature' => { 301 => 0x14, 349 => 0x4 },
	'ambienttemperaturefahrenheit' => { 301 => 0x13 },
	'analogbalance' => { 95 => 0xc627 },
	'angleadj' => { 87 => 0x8b },
	'angleinforoll' => { 366 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 366 => 'AngleInfoYaw' },
	'anti-blur' => { 331 => 0xb04b },
	'antialiasstrength' => { 95 => 0xc632 },
	'aperturerange' => { 68 => 0x10d },
	'apertureringuse' => { 264 => '1.4' },
	'aperturesetting' => { 150 => 0x7, 319 => 0x30, 320 => 0x29, 321 => 0x1 },
	'aperturevalue' => { 77 => 0x2, 95 => 0x9202, 238 => 0x1002, 374 => 'ApertureValue' },
	'applekeywords' => { 242 => 'AAPL:Keywords' },
	'applicationnotes' => { 95 => 0x2bc, 256 => 0x2bc },
	'applicationrecordversion' => { 103 => 0x0 },
	'applyshootingmeteringmode' => { 68 => 0x10e },
	'approved' => { 376 => 'Approved' },
	'approvedby' => { 376 => 'ApprovedBy' },
	'approximatefnumber' => { 248 => 0x313, 254 => 0x3406 },
	'approximatefocusdistance' => { 367 => 'ApproximateFocusDistance' },
	'armidentifier' => { 104 => 0x78 },
	'armversion' => { 104 => 0x7a },
	'artfilter' => { 233 => 0x529 },
	'artfiltereffect' => { 233 => 0x52f },
	'artist' => { 95 => 0x13b, 244 => 'Artist', 283 => 0x22e, 389 => 'Artist', 393 => 'artist' },
	'artmode' => { 91 => 0x301b },
	'artmodeparameters' => { 91 => 0x310b },
	'artworkcopyrightnotice' => { 380 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 380 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 380 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 380 => 'ArtworkOrObject' },
	'artworksource' => { 380 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 380 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 380 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 237 => 0x1113 },
	'aspectratio' => { 4 => 0x0, 237 => 0x1112, 283 => 0x80, 319 => 0x55, 320 => 0x55, 321 => 0xa },
	'asshoticcprofile' => { 95 => 0xc68f },
	'asshotneutral' => { 95 => 0xc628 },
	'asshotpreprofilematrix' => { 95 => 0xc690 },
	'asshotprofilename' => { 95 => 0xc6f6 },
	'asshotwhitexy' => { 95 => 0xc629 },
	'assignbktbutton' => { 222 => '4.2' },
	'assignfuncbutton' => { 68 => 0x70b },
	'assistbuttonfunction' => { 66 => 0xd },
	'attributionname' => { 368 => 'attributionName' },
	'attributionurl' => { 368 => 'attributionURL' },
	'audio' => { 252 => 0x20 },
	'audiobitrate' => { 54 => 0x6c },
	'audiochannels' => { 54 => 0x70 },
	'audiochanneltype' => { 393 => 'audioChannelType' },
	'audiocompression' => { 124 => 'Compression' },
	'audiocompressor' => { 393 => 'audioCompressor' },
	'audioduration' => { 103 => 0x99 },
	'audiomoddate' => { 393 => 'audioModDate' },
	'audiooutcue' => { 103 => 0x9a },
	'audiosamplerate' => { 54 => 0x6e, 393 => 'audioSampleRate' },
	'audiosampletype' => { 393 => 'audioSampleType' },
	'audiosamplingrate' => { 103 => 0x97 },
	'audiosamplingresolution' => { 103 => 0x98 },
	'audiotype' => { 103 => 0x96 },
	'author' => { 126 => 'Author', 242 => 'Author', 244 => 'Author', 296 => 'Author', 365 => 'author', 381 => 'Author', 391 => 'Author' },
	'authorsposition' => { 382 => 'AuthorsPosition' },
	'autoaperture' => { 274 => '0.1' },
	'autobracket' => { 314 => 0x19 },
	'autobracketing' => { 100 => 0x1100, 283 => 0x18, 305 => 0x1007 },
	'autobracketingmode' => { 230 => '12.3' },
	'autobracketingset' => { 230 => '12.1' },
	'autobracketmodem' => { 222 => '21.2', 227 => '26.2' },
	'autobracketorder' => { 150 => 0x43, 222 => '21.3', 227 => '26.3', 228 => '12.2', 229 => '2.2', 230 => '12.2', 231 => '13.2' },
	'autobracketset' => { 222 => '21.1', 224 => '11.1', 225 => '12.1', 226 => '12.1', 227 => '26.1', 228 => '12.1', 229 => '2.1', 231 => '13.1' },
	'autobrightness' => { 370 => 'AutoBrightness' },
	'autocontrast' => { 370 => 'AutoContrast' },
	'autodistortioncontrol' => { 168 => 0x4 },
	'autodynamicrange' => { 100 => 0x140b },
	'autoexposure' => { 370 => 'AutoExposure' },
	'autoexposurebracketing' => { 62 => 0x10 },
	'autofocus' => { 236 => 0x209 },
	'autofp' => { 229 => '7.3', 231 => '31.4' },
	'autoiso' => { 62 => 0x1, 91 => 0x3008, 223 => '1.1', 229 => '1.1' },
	'autoisomax' => { 223 => '1.2', 229 => '1.2' },
	'autoisominshutterspeed' => { 223 => '1.3', 229 => '1.3' },
	'autolateralca' => { 370 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 14 => 0xbe, 15 => 0xbf, 18 => 0xbf, 50 => 0x2, 68 => 0x204, 87 => 0x6f },
	'autolightingoptimizeron' => { 87 => 0x6e },
	'autoportraitframed' => { 331 => 0x2016 },
	'autoredeye' => { 215 => 0xfe28a44f },
	'autorotate' => { 62 => 0x1b },
	'autoshadows' => { 370 => 'AutoShadows' },
	'autowhiteversion' => { 370 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 182 => 0x82 },
	'avaperturesetting' => { 264 => 0x13 },
	'averageblacklevel' => { 36 => 0xe7, 38 => 0xfb, 39 => 0x114 },
	'averagelv' => { 153 => 0x38 },
	'avsettingwithoutlens' => { 68 => 0x707 },
	'azimuth' => { 134 => 'Azimuth' },
	'babyage' => { 252 => [0x8010,0x33] },
	'babyname' => { 252 => 0x66 },
	'backgroundalpha' => { 388 => 'bgalpha' },
	'baseexposurecompensation' => { 264 => 0x15 },
	'baseiso' => { 62 => 0x2, 81 => 0x101c, 254 => 0x312a },
	'baselineexposure' => { 95 => 0xc62a },
	'baselineexposureoffset' => { 95 => 0xc7a5 },
	'baselinenoise' => { 95 => 0xc62b },
	'baselinesharpness' => { 95 => 0xc62c },
	'baseurl' => { 391 => 'BaseURL' },
	'batterylevel' => { 319 => 0x51, 323 => 0xc, 324 => 0x4, 325 => 0x4, 353 => 0x7 },
	'batterylevelgrip1' => { 353 => 0x6 },
	'batterylevelgrip2' => { 353 => 0x8 },
	'batteryorder' => { 222 => '12.5', 227 => '13.2', 228 => '2.1' },
	'batterystate' => { 150 => 0x60, 325 => 0x14 },
	'batterytemperature' => { 323 => 0x1, 325 => 0x2, 353 => 0x5 },
	'batteryunknown' => { 323 => 0x2, 325 => 0x0 },
	'batteryvoltage' => { 301 => 0x2a, 323 => 0x8 },
	'batteryvoltage1' => { 325 => 0x6 },
	'batteryvoltage2' => { 325 => 0x8 },
	'bayergreensplit' => { 95 => 0xc62d },
	'bayerpattern' => { 108 => 0xf902, 154 => 0x17 },
	'beatspliceparams' => { 393 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 393 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 393 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 393 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 393 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 393 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 222 => '13.1', 223 => '0.1', 224 => '2.1', 225 => '3.1', 226 => '3.1', 227 => '10.1', 229 => '0.1', 231 => '4.1' },
	'beeppitch' => { 228 => '3.1' },
	'beepvolume' => { 228 => '4.5' },
	'bestqualityscale' => { 95 => 0xc65c },
	'bestshotmode' => { 91 => 0x3007 },
	'bitdepth' => { 131 => 'BitDepth', 154 => 0x11, 187 => 0x41 },
	'bitspercomponent' => { 105 => 0x87 },
	'bitspersample' => { 95 => 0x102, 389 => 'BitsPerSample' },
	'blacklevel' => { 95 => 0xc61a, 182 => 0x3d, 238 => 0x1012 },
	'blacklevel1' => { 256 => 0x8 },
	'blacklevel2' => { 237 => 0x600, 241 => 0x600, 256 => 0x9 },
	'blacklevel3' => { 256 => 0xa },
	'blacklevelblue' => { 256 => 0x1e },
	'blackleveldeltah' => { 95 => 0xc61b },
	'blackleveldeltav' => { 95 => 0xc61c },
	'blacklevelgreen' => { 256 => 0x1d },
	'blacklevelred' => { 256 => 0x1c },
	'blacklevelrepeatdim' => { 95 => 0xc619 },
	'blackpoint' => { 283 => 0x200 },
	'blacks2012' => { 370 => 'Blacks2012' },
	'bleachbypasstoning' => { 283 => 0x7f },
	'bluebalance' => { 166 => 0x271, 238 => 0x1018, 256 => 0x12, 283 => 0x1b },
	'bluecurvelimits' => { 86 => 0x1fe },
	'bluecurvepoints' => { 86 => 0x1d4 },
	'bluehue' => { 370 => 'BlueHue' },
	'bluesaturation' => { 370 => 'BlueSaturation' },
	'blurcontrol' => { 283 => 0x82 },
	'blurwarning' => { 100 => 0x1300 },
	'bodybatteryadload' => { 262 => 0x3 },
	'bodybatteryadnoload' => { 262 => 0x2 },
	'bodybatterystate' => { 262 => '1.1' },
	'bodybatteryvoltage1' => { 262 => 0x2 },
	'bodybatteryvoltage2' => { 262 => 0x4 },
	'bodybatteryvoltage3' => { 262 => 0x6 },
	'bodybatteryvoltage4' => { 262 => 0x8 },
	'bodyfirmware' => { 306 => 0x0 },
	'bodyfirmwareversion' => { 234 => 0x104, 235 => 0x100, 238 => 0x104 },
	'bodyserialnumber' => { 306 => 0x10 },
	'bracketmode' => { 46 => 0x3 },
	'bracketsequence' => { 91 => 0x301d },
	'bracketsettings' => { 252 => 0x45 },
	'bracketshotnumber' => { 46 => 0x5, 264 => 0x9, 330 => 0x2b },
	'bracketshotnumber2' => { 330 => 0x2d },
	'bracketstep' => { 147 => 0xe },
	'bracketvalue' => { 46 => 0x4 },
	'brightness' => { 95 => 0xfe53, 125 => 'Brightness', 147 => 0x2c, 184 => 0x34, 301 => 0x25, 319 => 0x22, 331 => 0x2007, 370 => 'Brightness' },
	'brightnessadj' => { 86 => 0x114, 208 => 0x0, 218 => 0x2d, 356 => 0x8018 },
	'brightnessvalue' => { 95 => 0x9203, 153 => [0x691,0x49c3], 238 => 0x1003, 338 => 0x1140, 339 => 0x1140, 340 => 0x111c, 341 => 0x1198, 342 => 0x1174, 343 => 0x102c, 344 => 0x224, 374 => 'BrightnessValue' },
	'bulbduration' => { 62 => 0x18 },
	'burstmode' => { 111 => 0xa, 252 => 0x2a },
	'burstmode2' => { 111 => 0x18 },
	'burstshot' => { 314 => 0x34 },
	'burstspeed' => { 252 => 0x77 },
	'buttonfunctioncontroloff' => { 68 => 0x70a },
	'bwfilter' => { 147 => 0x2a, 155 => 0x39 },
	'bwmode' => { 238 => 0x203 },
	'by-line' => { 103 => 0x50 },
	'by-linetitle' => { 103 => 0x55 },
	'bytecount' => { 384 => 'byteCount' },
	'calibration' => { 314 => [0x24,0x30] },
	'calibrationilluminant1' => { 95 => 0xc65a },
	'calibrationilluminant2' => { 95 => 0xc65b },
	'cameraangle' => { 393 => 'cameraAngle' },
	'cameracalibration1' => { 95 => 0xc623 },
	'cameracalibration2' => { 95 => 0xc624 },
	'cameracalibrationsig' => { 95 => 0xc6f3 },
	'cameracolorcalibration01' => { 31 => 0x0, 37 => 0xba },
	'cameracolorcalibration02' => { 31 => 0x4, 37 => 0xbf },
	'cameracolorcalibration03' => { 31 => 0x8, 37 => 0xc4 },
	'cameracolorcalibration04' => { 31 => 0xc, 37 => 0xc9 },
	'cameracolorcalibration05' => { 31 => 0x10, 37 => 0xce },
	'cameracolorcalibration06' => { 31 => 0x14, 37 => 0xd3 },
	'cameracolorcalibration07' => { 31 => 0x18, 37 => 0xd8 },
	'cameracolorcalibration08' => { 31 => 0x1c, 37 => 0xdd },
	'cameracolorcalibration09' => { 31 => 0x20, 37 => 0xe2 },
	'cameracolorcalibration10' => { 31 => 0x24, 37 => 0xe7 },
	'cameracolorcalibration11' => { 31 => 0x28, 37 => 0xec },
	'cameracolorcalibration12' => { 31 => 0x2c, 37 => 0xf1 },
	'cameracolorcalibration13' => { 31 => 0x30, 37 => 0xf6 },
	'cameracolorcalibration14' => { 31 => 0x34, 37 => 0xfb },
	'cameracolorcalibration15' => { 31 => 0x38, 37 => 0x100 },
	'cameraid' => { 238 => 0x209, 313 => 0x209 },
	'cameraiso' => { 29 => 0x10 },
	'cameralabel' => { 95 => 0xc7a1, 393 => 'cameraLabel' },
	'cameramodel' => { 393 => 'cameraModel' },
	'cameramove' => { 393 => 'cameraMove' },
	'cameraorientation' => { 5 => 0x30, 7 => 0x7d, 9 => 0x30, 11 => 0x35, 12 => 0x30, 13 => 0x30, 14 => 0x31, 15 => 0x31, 16 => 0x35, 17 => 0x27, 18 => 0x31, 19 => 0x7d, 20 => 0x38, 21 => 0x36, 22 => 0x7d, 23 => 0x83, 24 => 0x84, 25 => 0x35, 252 => 0x8f, 286 => 0x1, 325 => [0x16,0x18], 346 => 0x28, 347 => 0x24, 348 => 0x29 },
	'cameraowner' => { 112 => 0xc353 },
	'cameraparameters' => { 238 => 0x2050 },
	'cameraprofile' => { 370 => 'CameraProfile' },
	'cameraprofiledigest' => { 370 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 95 => 0xc62f, 145 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 233 => 0x0 },
	'cameratemperature' => { 5 => 0x18, 7 => 0x1b, 9 => 0x18, 11 => 0x19, 12 => 0x18, 13 => 0x18, 14 => 0x19, 15 => 0x19, 16 => 0x19, 17 => 0x17, 18 => 0x19, 19 => 0x1b, 20 => 0x19, 21 => 0x19, 22 => 0x1b, 23 => 0x1b, 24 => 0x1b, 25 => 0x19, 26 => [0x87,0x91], 27 => [0x99,0x9f,0xa4,0xa8,0x105], 28 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 62 => 0xc, 237 => 0x1306, 248 => 0x320, 254 => 0x3402, 283 => 0x47, 311 => 0x43, 350 => 0x5 },
	'cameratemperature2' => { 287 => 0xc },
	'cameratemperature3' => { 287 => 0xe },
	'cameratemperature4' => { 287 => 0x14 },
	'cameratemperature5' => { 287 => 0x16 },
	'cameratemperaturerangemax' => { 97 => 0x5 },
	'cameratemperaturerangemin' => { 97 => 0x6 },
	'cameratype' => { 62 => 0x1a, 238 => 0x207 },
	'cameratype2' => { 234 => 0x100 },
	'canonexposuremode' => { 29 => 0x14 },
	'canonfiledescription' => { 81 => 0x805 },
	'canonfilelength' => { 51 => 0xe },
	'canonfirmwareversion' => { 51 => 0x7, 81 => 0x80b },
	'canonflashinfo' => { 81 => 0x1028 },
	'canonflashmode' => { 29 => 0x4 },
	'canonimagesize' => { 8 => 0x39, 29 => 0xa },
	'canonimagetype' => { 51 => 0x6, 81 => 0x815 },
	'canonmodelid' => { 51 => 0x10, 81 => 0x1834 },
	'canonvrd' => { 96 => 'CanonVRD' },
	'caption' => { 365 => 'caption' },
	'caption-abstract' => { 103 => 0x78 },
	'captionsauthornames' => { 373 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 373 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 382 => 'CaptionWriter' },
	'captureframerate' => { 91 => 0x4001 },
	'capturesoftware' => { 360 => 'CaptureSoftware' },
	'cardshutterlock' => { 150 => 0x49 },
	'casioimagesize' => { 91 => 0x9 },
	'catalogsets' => { 103 => 0xff, 359 => 'CatalogSets', 363 => 'CatalogSets' },
	'categories' => { 51 => 0x23, 365 => 'categories' },
	'category' => { 103 => 0xf, 232 => 0x30, 382 => 'Category' },
	'ccdboardversion' => { 248 => 0x331 },
	'ccdscanmode' => { 238 => 0x1039 },
	'ccdsensitivity' => { 205 => 0x6 },
	'ccdversion' => { 248 => 0x330 },
	'cellglobalid' => { 369 => 'cgi' },
	'celllength' => { 95 => 0x109 },
	'cellr' => { 369 => 'r' },
	'celltowerid' => { 369 => 'cellid' },
	'cellwidth' => { 95 => 0x108 },
	'centerafarea' => { 229 => '15.1' },
	'centerfocuspoint' => { 231 => '2.2' },
	'centerweightedareasize' => { 222 => '7.1', 227 => '5.1', 228 => '7.1', 229 => '6.3', 231 => '8.1' },
	'certificate' => { 397 => 'Certificate' },
	'cfapattern' => { 95 => 0xa302, 374 => 'CFAPattern' },
	'cfapattern2' => { 95 => 0x828e },
	'cfapatterncolumns' => { 374 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 374 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 374 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 95 => 0x828d },
	'channel' => { 384 => 'channel' },
	'channels' => { 124 => 'Channels' },
	'checkmark' => { 86 => 0x26a },
	'checkmark2' => { 87 => 0x8e },
	'childfontfiles' => { 398 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 222 => '10.3' },
	'chromablurradius' => { 95 => 0xc631 },
	'chromaticaberration' => { 87 => 0x66 },
	'chromaticaberrationb' => { 370 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 87 => 0x6b },
	'chromaticaberrationcorr' => { 64 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 273 => 0x1 },
	'chromaticaberrationon' => { 87 => 0x62 },
	'chromaticaberrationr' => { 370 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 87 => 0x6a },
	'chromaticaberrationsetting' => { 65 => 0x6 },
	'chrominancenoisereduction' => { 87 => 0x5e, 314 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 87 => 0x60 },
	'circgradbasedcorractive' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 370 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 370 => 'CircularGradientBasedCorrections' },
	'city' => { 103 => 0x5a, 130 => 'City', 252 => 0x6d, 382 => 'City' },
	'clarity' => { 370 => 'Clarity' },
	'clarity2012' => { 370 => 'Clarity2012' },
	'classifystate' => { 103 => 0xe1 },
	'clearretouch' => { 252 => 0x7c },
	'clearretouchvalue' => { 252 => 0xa3 },
	'client' => { 393 => 'client' },
	'clientname' => { 376 => 'ClientName' },
	'clmodeshootingspeed' => { 222 => '10.2', 227 => '11.2', 228 => '10.2', 231 => '11.1' },
	'cmcontrast' => { 241 => 0x2022 },
	'cmexposurecompensation' => { 241 => 0x2000 },
	'cmhue' => { 241 => 0x2021 },
	'cmsaturation' => { 241 => 0x2020 },
	'cmsharpness' => { 241 => 0x2023 },
	'cmwhitebalance' => { 241 => 0x2001 },
	'cmwhitebalancecomp' => { 241 => 0x2002 },
	'cmwhitebalancegraypoint' => { 241 => 0x2010 },
	'codec' => { 138 => 'Codec' },
	'codedcharacterset' => { 104 => 0x5a },
	'collectionname' => { 139 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 139 => 'Collections' },
	'collectionuri' => { 139 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 215 => 0xc89224b },
	'coloradjustment' => { 314 => 0x14 },
	'coloradjustmentmode' => { 313 => 0x210 },
	'coloranta' => { 398 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 398 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 398 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 398 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 398 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 398 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 398 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 398 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 398 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 398 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 398 => 'Colorants' },
	'colorantswatchname' => { 398 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 398 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 398 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 398 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 125 => 'ColorBalance' },
	'colorbalanceadj' => { 215 => 0x76a43202 },
	'colorbalanceblue' => { 147 => 0x1e },
	'colorbalancegreen' => { 147 => 0x1d },
	'colorbalancered' => { 147 => 0x1c },
	'colorbalanceversion' => { 167 => 0x0 },
	'colorblur' => { 87 => 0x65 },
	'colorbooster' => { 215 => 0x5f0e7d23 },
	'colorboostlevel' => { 209 => 0x1 },
	'colorboosttype' => { 209 => 0x0 },
	'colorclass' => { 291 => 0xde, 292 => 'ColorClass' },
	'colorcompensationfilter' => { 150 => [0x3a,0x5f], 152 => 0x111, 331 => 0xb022 },
	'colorcompensationfilterset' => { 319 => 0xd, 320 => 0xc, 321 => 0x18, 335 => 0xf },
	'colorcontrol' => { 238 => 0x102b },
	'colorcorrection' => { 356 => 0x8015 },
	'colordataversion' => { 35 => 0x0, 36 => 0x0, 38 => 0x0, 39 => 0x0 },
	'coloreffect' => { 252 => 0x28 },
	'colorfilter' => { 90 => 0x17, 91 => 0x3017, 147 => 0x29, 155 => [0x38,0x4d,0x4f], 289 => 0x17 },
	'colorgain' => { 187 => 0x51 },
	'colorhue' => { 182 => 0x8d },
	'colorimetricreference' => { 95 => 0xc6bf },
	'colorlabel' => { 373 => 'ColorLabel' },
	'colormatrix' => { 237 => 0x200, 238 => 0x1011, 311 => 0xa030 },
	'colormatrix1' => { 95 => 0xc621 },
	'colormatrix2' => { 95 => 0xc622, 241 => 0x200 },
	'colormatrixa' => { 283 => 0x203 },
	'colormatrixadobergb' => { 311 => 0xa032 },
	'colormatrixb' => { 283 => 0x204 },
	'colormatrixnumber' => { 238 => 0x1019 },
	'colormatrixsrgb' => { 311 => 0xa031 },
	'colormode' => { 91 => 0x3015, 100 => 0x1210, 111 => 0x66, 147 => 0x28, 150 => 0x16, 152 => 0x101, 153 => 0x36, 155 => 0x7, 182 => 0x3, 205 => 0x4, 252 => 0x32, 314 => 0x2c, 331 => 0xb029, 382 => 'ColorMode' },
	'colormoirereduction' => { 216 => 0x15 },
	'colormoirereductionmode' => { 216 => 0x5 },
	'colornoisereduction' => { 356 => 0x8029, 370 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 370 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 216 => 0x18 },
	'colornoisereductionsharpness' => { 216 => 0x1c },
	'colornoisereductionsmoothness' => { 370 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 99 => 0x2 },
	'colorprofile' => { 147 => 0x33 },
	'colorrepresentation' => { 105 => 0x3c },
	'colorsequence' => { 105 => 0x41 },
	'colorspace' => { 40 => 0x3, 51 => 0xb4, 81 => 0x10b4, 95 => 0xa001, 131 => 'ColorSpace', 148 => 0x2f, 149 => 0x25, 150 => 0x17, 182 => 0x1e, 233 => 0x507, 283 => 0x37, 311 => 0xa011, 314 => 0xb, 319 => 0x1b, 320 => 0x83, 321 => 0xe, 335 => 0x6, 374 => 'ColorSpace' },
	'colortempasshot' => { 32 => 0x4, 33 => 0x1d, 34 => 0x26, 35 => 0x43, 38 => 0x43, 39 => 0x43 },
	'colortempauto' => { 32 => 0x9, 33 => 0x22, 34 => 0x1c, 35 => 0x48, 38 => 0x48, 39 => 0x48 },
	'colortempcloudy' => { 32 => 0x22, 33 => 0x31, 34 => 0x35, 35 => 0x5c, 38 => 0x75, 39 => 0x8e, 283 => 0x55 },
	'colortempcustom' => { 35 => 0x84 },
	'colortempcustom1' => { 33 => 0x45 },
	'colortempcustom2' => { 33 => 0x4a },
	'colortempdaylight' => { 32 => 0x18, 33 => 0x27, 34 => 0x2b, 35 => 0x52, 38 => 0x6b, 39 => 0x84, 283 => 0x53 },
	'colortemperature' => { 5 => 0x73, 6 => [0x48,0x4e], 7 => 0xc0, 8 => 0x37, 9 => 0x62, 10 => 0x37, 11 => 0x7c, 12 => 0x73, 13 => 0x73, 14 => 0x77, 15 => 0x73, 16 => 0x7c, 17 => 0x58, 18 => 0x73, 19 => 0xc0, 20 => 0x7f, 21 => 0x7d, 22 => 0xc0, 23 => 0xc6, 24 => 0xc7, 25 => 0x7b, 51 => 0xae, 60 => 0x9, 81 => 0x10ae, 100 => 0x1005, 109 => 0x846, 125 => 'ColorTemperature', 148 => [0x6e,0x49], 149 => 0x3f, 150 => [0x39,0x5e], 152 => 0x10b, 155 => [0x3c,0x4c,0x4e], 248 => 0x321, 283 => 0x50, 305 => 0x1308, 331 => 0xb021, 370 => 'Temperature' },
	'colortemperatureadj' => { 356 => 0x8013 },
	'colortemperaturebg' => { 238 => 0x1013 },
	'colortemperaturerg' => { 238 => 0x1014 },
	'colortemperaturesetting' => { 150 => 0x25, 319 => 0xc, 320 => 0xb, 321 => 0x17, 335 => 0xe },
	'colortempflash' => { 32 => 0x36, 33 => 0x40, 34 => 0x49, 35 => 0x70, 38 => 0x89, 39 => 0xa2, 283 => 0x5a },
	'colortempflashdata' => { 35 => 0x24a },
	'colortempfluorescent' => { 32 => 0x2c, 33 => 0x3b, 34 => 0x3f, 35 => 0x66, 38 => 0x7f, 39 => 0x98 },
	'colortempfluorescentd' => { 283 => 0x57 },
	'colortempfluorescentn' => { 283 => 0x58 },
	'colortempfluorescentw' => { 283 => 0x59 },
	'colortempkelvin' => { 32 => 0x31, 34 => 0x44, 35 => 0x6b, 38 => 0x84, 39 => 0x9d, 252 => 0x44, 305 => 0x1307 },
	'colortempmeasured' => { 32 => 0xe, 35 => 0x4d, 38 => 0x4d, 39 => 0x4d },
	'colortemppc1' => { 34 => 0x94, 35 => 0x75 },
	'colortemppc2' => { 34 => 0x99, 35 => 0x7a },
	'colortemppc3' => { 34 => 0x9e, 35 => 0x7f },
	'colortempshade' => { 32 => 0x1d, 33 => 0x2c, 34 => 0x30, 35 => 0x57, 38 => 0x70, 39 => 0x89, 283 => 0x54 },
	'colortemptungsten' => { 32 => 0x27, 33 => 0x36, 34 => 0x3a, 35 => 0x61, 38 => 0x7a, 39 => 0x93, 283 => 0x56 },
	'colortempunknown' => { 32 => 0x13, 34 => 0x21, 38 => 0x52, 39 => 0x52 },
	'colortempunknown10' => { 32 => 0x63, 34 => 0x76, 38 => 0xa2, 39 => 0x7f },
	'colortempunknown11' => { 32 => 0x68, 34 => 0x7b, 38 => 0xa7, 39 => 0xa7 },
	'colortempunknown12' => { 32 => 0x6d, 34 => 0x80, 38 => 0xac, 39 => 0xac },
	'colortempunknown13' => { 32 => 0x72, 34 => 0x85, 38 => 0xb1, 39 => 0xb1 },
	'colortempunknown14' => { 34 => 0x8a, 38 => 0xb6, 39 => 0xb6 },
	'colortempunknown15' => { 34 => 0x8f, 38 => 0xbb, 39 => 0xbb },
	'colortempunknown16' => { 34 => 0xa3, 39 => 0xc0 },
	'colortempunknown17' => { 39 => 0xc5 },
	'colortempunknown18' => { 39 => 0xca },
	'colortempunknown19' => { 39 => 0xcf },
	'colortempunknown2' => { 32 => 0x3b, 34 => 0x4e, 38 => 0x57, 39 => 0x57 },
	'colortempunknown20' => { 39 => 0xd4 },
	'colortempunknown3' => { 32 => 0x40, 34 => 0x53, 38 => 0x5c, 39 => 0x5c },
	'colortempunknown4' => { 32 => 0x45, 34 => 0x58, 38 => 0x61, 39 => 0x61 },
	'colortempunknown5' => { 32 => 0x4a, 34 => 0x5d, 38 => 0x66, 39 => 0x66 },
	'colortempunknown6' => { 32 => 0x4f, 34 => 0x62, 38 => 0x8e, 39 => 0x6b },
	'colortempunknown7' => { 32 => 0x54, 34 => 0x67, 38 => 0x93, 39 => 0x70 },
	'colortempunknown8' => { 32 => 0x59, 34 => 0x6c, 38 => 0x98, 39 => 0x75 },
	'colortempunknown9' => { 32 => 0x5e, 34 => 0x71, 38 => 0x9d, 39 => 0x7a },
	'colortone' => { 8 => 0x6f, 10 => 0x77, 29 => 0x2a, 40 => 0x2 },
	'colortoneadj' => { 86 => 0x11e },
	'colortoneauto' => { 57 => 0x9c },
	'colortonefaithful' => { 17 => 0x107, 56 => 0x6c, 57 => 0x6c },
	'colortonelandscape' => { 17 => 0x105, 56 => 0x3c, 57 => 0x3c },
	'colortonemonochrome' => { 56 => 0x84, 57 => 0x84 },
	'colortoneneutral' => { 17 => 0x106, 56 => 0x54, 57 => 0x54 },
	'colortoneportrait' => { 17 => 0x104, 56 => 0x24, 57 => 0x24 },
	'colortonestandard' => { 17 => 0x103, 56 => 0xc, 57 => 0xc },
	'colortoneuserdef1' => { 17 => 0x109, 56 => 0x9c, 57 => 0xb4 },
	'colortoneuserdef2' => { 17 => 0x10a, 56 => 0xb4, 57 => 0xcc },
	'colortoneuserdef3' => { 17 => 0x10b, 56 => 0xcc, 57 => 0xe4 },
	'commanddials' => { 229 => '5.1' },
	'commanddialsaperturesetting' => { 222 => '17.3', 227 => '33.3', 228 => '17.3' },
	'commanddialschangemainsub' => { 222 => '17.2', 227 => '33.2', 228 => '17.2' },
	'commanddialsmenuandplayback' => { 222 => '17.4', 227 => '33.4', 228 => '17.4' },
	'commanddialsreverserotation' => { 222 => '17.1', 224 => '16.2', 225 => '17.2', 227 => '33.1', 228 => '17.1', 231 => '18.1' },
	'commanderchannel' => { 229 => '10.2', 230 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 229 => '13.1', 230 => '31.1' },
	'commandergroupa_ttlcomp' => { 231 => '32.1' },
	'commandergroupamanualoutput' => { 229 => '13.2', 230 => '28.2' },
	'commandergroupamode' => { 229 => '11.2', 230 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 229 => '14.1', 230 => '32.1' },
	'commandergroupb_ttlcomp' => { 231 => '33.1' },
	'commandergroupbmanualoutput' => { 229 => '14.2', 230 => '29.2' },
	'commandergroupbmode' => { 229 => '11.3', 230 => '29.1' },
	'commanderinternalflash' => { 229 => '11.1', 230 => '27.1' },
	'commanderinternalmanualoutput' => { 229 => '12.2', 230 => '27.2' },
	'commanderinternalttlchannel' => { 227 => '18.2' },
	'commanderinternalttlcomp' => { 229 => '12.1', 230 => '30.2', 231 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 227 => '20.1', 228 => '26.1' },
	'commanderinternalttlcompgroupa' => { 227 => '21.1', 228 => '27.1' },
	'commanderinternalttlcompgroupb' => { 227 => '22.1', 228 => '28.1' },
	'comment' => { 0 => 0x2, 96 => 'Comment', 126 => 'Comment', 244 => 'Comment' },
	'compass' => { 308 => 0x4 },
	'complianceprofile' => { 384 => 'complianceProfile' },
	'componentsconfiguration' => { 95 => 0x9101, 131 => 'Components', 374 => 'ComponentsConfiguration' },
	'componentversion' => { 81 => 0x80c },
	'composer' => { 393 => 'composer' },
	'compositionadjust' => { 282 => '0.1' },
	'compositionadjustrotation' => { 282 => 0x7 },
	'compositionadjustx' => { 282 => 0x5 },
	'compositionadjusty' => { 282 => 0x6 },
	'compressedbitsperpixel' => { 95 => 0x9102, 374 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 152 => 0x40, 238 => 0x40 },
	'compression' => { 95 => 0x103, 389 => 'Compression' },
	'compressionfactor' => { 233 => 0x50d },
	'compressionratio' => { 131 => 'Compression', 238 => 0x1034 },
	'confidencelevel' => { 366 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 86 => 0x266, 291 => 0xd6 },
	'constrainedcropwidth' => { 86 => 0x262, 291 => 0xd5 },
	'contact' => { 103 => 0x76 },
	'contentlocationcode' => { 103 => 0x1a },
	'contentlocationname' => { 103 => 0x1b },
	'continuousbracketing' => { 150 => 0x20 },
	'continuousdrive' => { 29 => 0x5 },
	'continuousshootingspeed' => { 68 => 0x610 },
	'continuousshotlimit' => { 68 => 0x611 },
	'contrast' => { 8 => 0x73, 10 => 0x75, 29 => 0xd, 90 => 0xc, 91 => [0x3012,0x20], 95 => [0xa408,0xfe54], 100 => [0x1004,0x1006], 125 => 'Contrast', 147 => 0x20, 148 => 0x31, 149 => 0x27, 150 => 0x19, 155 => 0x2, 184 => 0x33, 238 => 0x1029, 252 => 0x39, 254 => 0x300a, 283 => 0x20, 289 => 0xc, 301 => 0x24, 305 => 0x1012, 314 => 0xd, 319 => 0x1d, 320 => 0x1a, 331 => 0x2004, 370 => 'Contrast', 374 => 'Contrast' },
	'contrast2012' => { 370 => 'Contrast2012' },
	'contrastadj' => { 86 => 0x115, 218 => 0x2c, 356 => 0x8017 },
	'contrastauto' => { 57 => 0x90 },
	'contrastcurve' => { 182 => 0x8c },
	'contrastdetectaf' => { 158 => 0x4 },
	'contrastdetectafarea' => { 283 => 0x231 },
	'contrastdetectafinfocus' => { 158 => 0x1c },
	'contrastfaithful' => { 17 => 0xec, 56 => 0x60, 57 => 0x60 },
	'contrasthighlight' => { 283 => 0x6d },
	'contrasthighlightshadowadj' => { 283 => 0x6f },
	'contrastlandscape' => { 17 => 0xea, 56 => 0x30, 57 => 0x30 },
	'contrastmode' => { 252 => 0x2c },
	'contrastmonochrome' => { 17 => 0xed, 56 => 0x78, 57 => 0x78 },
	'contrastneutral' => { 17 => 0xeb, 56 => 0x48, 57 => 0x48 },
	'contrastportrait' => { 17 => 0xe9, 56 => 0x18, 57 => 0x18 },
	'contrastsetting' => { 233 => 0x505, 241 => 0x1012, 321 => 0x10, 335 => 0x8 },
	'contrastshadow' => { 283 => 0x6e },
	'contraststandard' => { 17 => 0xe8, 56 => 0x0, 57 => 0x0 },
	'contrastuserdef1' => { 17 => 0xee, 56 => 0x90, 57 => 0xa8 },
	'contrastuserdef2' => { 17 => 0xef, 56 => 0xa8, 57 => 0xc0 },
	'contrastuserdef3' => { 17 => 0xf0, 56 => 0xc0, 57 => 0xd8 },
	'contributedmedia' => { 393 => 'contributedMedia' },
	'contributedmediaduration' => { 393 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 393 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 393 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 393 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 393 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 393 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 393 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 393 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 393 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 393 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 371 => 'contributor' },
	'contributors' => { 126 => 'Contributors' },
	'controldialset' => { 150 => 0x46 },
	'controlledvocabularyterm' => { 380 => 'CVterm' },
	'controllerboardversion' => { 248 => 0x332 },
	'controlmode' => { 62 => 0x12 },
	'conversionlens' => { 234 => 0x403, 252 => 0x35 },
	'converter' => { 95 => 0xfe4d, 205 => 0xb, 370 => 'Converter' },
	'converttograyscale' => { 370 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 95 => 0x8298, 126 => 'Copyright', 244 => 'Copyright', 283 => 0x22f, 296 => 'Copyright', 381 => 'Copyright', 384 => 'copyright', 386 => 'copyright', 389 => 'Copyright', 393 => 'copyright' },
	'copyrightflag' => { 294 => 0x40a },
	'copyrightnotice' => { 103 => 0x74 },
	'copyrightowner' => { 383 => 'CopyrightOwner' },
	'copyrightownerid' => { 383 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 383 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 383 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 383 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 383 => 'CopyrightStatus' },
	'coringfilter' => { 237 => 0x310, 238 => 0x102d, 241 => 0x310 },
	'coringvalues' => { 237 => 0x311, 241 => 0x311 },
	'corporateentity' => { 384 => 'corporateEntity' },
	'country' => { 130 => 'Country', 252 => 0x69, 382 => 'Country' },
	'country-primarylocationcode' => { 103 => 0x64 },
	'country-primarylocationname' => { 103 => 0x65 },
	'countrycode' => { 181 => 0x5, 292 => 'CountryCode', 379 => 'CountryCode' },
	'coverage' => { 371 => 'coverage' },
	'coverdate' => { 384 => 'coverDate' },
	'coverdisplaydate' => { 384 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 283 => 0x28 },
	'crc32' => { 372 => 'crc32' },
	'createdate' => { 95 => 0x9004, 126 => 'CreateDate', 242 => 'CreationDate', 244 => 'create-date', 296 => 'CreationDate', 298 => 0x1, 391 => 'CreateDate' },
	'creationdate' => { 381 => 'CreationDate', 384 => 'creationDate' },
	'creationtime' => { 244 => 'Creation Time' },
	'creativestyle' => { 319 => 0x1a, 320 => 0x18, 330 => 0x41, 331 => 0xb020, 352 => 0x4a },
	'creativestylesetting' => { 321 => 0xf, 335 => 0x7 },
	'creativestylewaschanged' => { 356 => 0x8001 },
	'creator' => { 242 => 'Creator', 296 => 'Creator', 371 => 'creator', 381 => 'Creator' },
	'creatoraddress' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 379 => 'CreatorContactInfo' },
	'creatorcountry' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 391 => 'CreatorTool' },
	'creatorworkemail' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 379 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 103 => 0x6e, 382 => 'Credit' },
	'creditline' => { 386 => 'creditLine' },
	'creditlinereq' => { 396 => 'CreditLineReq' },
	'creditlinerequired' => { 383 => 'CreditLineRequired' },
	'cropactive' => { 86 => 0x244 },
	'cropangle' => { 370 => 'CropAngle' },
	'cropaspectratio' => { 86 => 0x260 },
	'cropbottom' => { 99 => 0x9, 210 => 0x36, 291 => 0xdc, 370 => 'CropBottom' },
	'cropbottommargin' => { 42 => 0x3 },
	'cropcircleactive' => { 87 => 0xd6 },
	'cropcircleradius' => { 87 => 0xd9 },
	'cropcirclex' => { 87 => 0xd7 },
	'cropcircley' => { 87 => 0xd8 },
	'cropconstraintowarp' => { 370 => 'CropConstrainToWarp' },
	'croph' => { 364 => 'CropH' },
	'cropheight' => { 86 => 0x24c, 237 => 0x615, 241 => 0x615, 370 => 'CropHeight' },
	'crophispeed' => { 182 => 0x1b },
	'cropleft' => { 86 => 0x246, 99 => 0x6, 210 => 0x1e, 237 => 0x612, 241 => 0x612, 291 => 0xd9, 370 => 'CropLeft' },
	'cropleftmargin' => { 42 => 0x0 },
	'cropmode35mm' => { 305 => 0x1018 },
	'cropoutputheight' => { 210 => 0xce },
	'cropoutputheightinches' => { 210 => 0x96 },
	'cropoutputpixels' => { 210 => 0xd6 },
	'cropoutputresolution' => { 210 => 0xb6 },
	'cropoutputscale' => { 210 => 0xbe },
	'cropoutputwidth' => { 210 => 0xc6 },
	'cropoutputwidthinches' => { 210 => 0x8e },
	'croppedareaimageheightpixels' => { 360 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 360 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 360 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 360 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 4 => 0x2, 305 => 0x1604 },
	'croppedimageleft' => { 4 => 0x3 },
	'croppedimagetop' => { 4 => 0x4 },
	'croppedimagewidth' => { 4 => 0x1, 305 => 0x1603 },
	'cropright' => { 99 => 0x8, 210 => 0x2e, 291 => 0xdb, 370 => 'CropRight' },
	'croprightmargin' => { 42 => 0x1 },
	'croprotation' => { 99 => 0xb },
	'cropscaledresolution' => { 210 => 0x9e },
	'cropsourceresolution' => { 210 => 0xae },
	'croptop' => { 86 => 0x248, 99 => 0x7, 210 => 0x26, 237 => 0x613, 241 => 0x613, 291 => 0xda, 370 => 'CropTop' },
	'croptopmargin' => { 42 => 0x2 },
	'cropunit' => { 370 => 'CropUnit' },
	'cropunits' => { 370 => 'CropUnits' },
	'cropw' => { 364 => 'CropW' },
	'cropwidth' => { 86 => 0x24a, 237 => 0x614, 241 => 0x614, 370 => 'CropWidth' },
	'cropx' => { 364 => 'CropX' },
	'cropy' => { 364 => 'CropY' },
	'crossprocess' => { 283 => 0x7b },
	'crossprocessparams' => { 283 => 0x235 },
	'currenticcprofile' => { 95 => 0xc691 },
	'currentpreprofilematrix' => { 95 => 0xc692 },
	'currentversion' => { 356 => 0xd000 },
	'curve0x' => { 364 => 'Curve0x' },
	'curve0y' => { 364 => 'Curve0y' },
	'curve1x' => { 364 => 'Curve1x' },
	'curve1y' => { 364 => 'Curve1y' },
	'curve2x' => { 364 => 'Curve2x' },
	'curve2y' => { 364 => 'Curve2y' },
	'curve3x' => { 364 => 'Curve3x' },
	'curve3y' => { 364 => 'Curve3y' },
	'curve4x' => { 364 => 'Curve4x' },
	'curve4y' => { 364 => 'Curve4y' },
	'curves' => { 215 => 0x76a43201 },
	'custom1' => { 383 => 'Custom1' },
	'custom10' => { 383 => 'Custom10' },
	'custom2' => { 383 => 'Custom2' },
	'custom3' => { 383 => 'Custom3' },
	'custom4' => { 383 => 'Custom4' },
	'custom5' => { 383 => 'Custom5' },
	'custom6' => { 383 => 'Custom6' },
	'custom7' => { 383 => 'Custom7' },
	'custom8' => { 383 => 'Custom8' },
	'custom9' => { 383 => 'Custom9' },
	'customcontrast' => { 87 => 0x4e },
	'customcontrols' => { 68 => 0x70c },
	'customdefaultunsharpfineness' => { 87 => 0xbe },
	'customdefaultunsharpstrength' => { 87 => 0xbc },
	'customdefaultunsharpthreshold' => { 87 => 0xc0 },
	'customlinear' => { 87 => 0x4f },
	'customoutputhighlightpoint' => { 87 => 0x53 },
	'customoutputshadowpoint' => { 87 => 0x54 },
	'custompicturestylefilename' => { 51 => 0x4010 },
	'customrawhighlight' => { 87 => 0x7c },
	'customrawhighlightpoint' => { 87 => 0x51 },
	'customrawshadow' => { 87 => 0x85 },
	'customrawshadowpoint' => { 87 => 0x52 },
	'customrendered' => { 95 => 0xa401, 374 => 'CustomRendered' },
	'customsaturation' => { 233 => 0x503 },
	'customsettingsalldefault' => { 222 => '0.2', 227 => '0.2' },
	'customsettingsbank' => { 222 => '0.1', 227 => '0.1' },
	'customsharpness' => { 87 => 0x50 },
	'customunsharpmaskfineness' => { 87 => 0xb8 },
	'customunsharpmaskstrength' => { 87 => 0xb6 },
	'customunsharpmaskthreshold' => { 87 => 0xba },
	'customwb_rblevels' => { 335 => 0x1a },
	'customwb_rgblevels' => { 321 => 0x19 },
	'customwbbluelevel' => { 150 => 0x36 },
	'customwberror' => { 150 => 0x37 },
	'customwbgreenlevel' => { 150 => 0x35 },
	'customwbredlevel' => { 150 => 0x34 },
	'customwbsetting' => { 150 => 0x26 },
	'd-lightinghq' => { 215 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 211 => 0x2 },
	'd-lightinghqhighlight' => { 211 => 0x1 },
	'd-lightinghqselected' => { 215 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 211 => 0x0 },
	'd-lightinghs' => { 215 => 0xce5554aa },
	'd-lightinghsadjustment' => { 212 => 0x0 },
	'd-lightinghscolorboost' => { 212 => 0x1 },
	'd-rangeoptimizerhighlight' => { 356 => 0x8024 },
	'd-rangeoptimizermode' => { 356 => 0x8022 },
	'd-rangeoptimizershadow' => { 356 => 0x802d },
	'd-rangeoptimizervalue' => { 356 => 0x8023 },
	'datacompressionmethod' => { 105 => 0x6e },
	'dataimprint' => { 147 => 0x34 },
	'date' => { 283 => 0x6, 371 => 'date' },
	'dateacquired' => { 145 => 'DateAcquired' },
	'datecreated' => { 103 => 0x37, 382 => 'DateCreated' },
	'datedisplayformat' => { 207 => 0x3 },
	'dateidentified' => { 94 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 224 => '4.2' },
	'daterecieved' => { 384 => 'dateRecieved' },
	'datesent' => { 104 => 0x46 },
	'datestampmode' => { 51 => 0x1c },
	'datetime' => { 365 => 'datetime', 389 => 'DateTime' },
	'datetimedigitized' => { 374 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 84 => 0x0, 95 => 0x9003, 123 => 0x14, 126 => 'OriginalDate', 301 => 0xb, 374 => 'DateTimeOriginal' },
	'datetimestamp' => { 111 => 0x64 },
	'datetimeutc' => { 233 => 0x908 },
	'daylightsavings' => { 63 => 0x3, 207 => 0x2 },
	'dccontinent' => { 94 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 94 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 94 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 94 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 94 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 94 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 94 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 94 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 94 => 'Event' },
	'dcfootprintspatialfit' => { 94 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 94 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 94 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 94 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 94 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 94 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 94 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 94 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 94 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 94 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 94 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 94 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 94 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 94 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 94 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 94 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 94 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 134 => 'Declination' },
	'decposition' => { 147 => 0x32 },
	'defaultblackrender' => { 95 => 0xc7a6 },
	'defaultcroporigin' => { 95 => 0xc61f },
	'defaultcropsize' => { 95 => 0xc620 },
	'defaulteraseoption' => { 68 => 0x813 },
	'defaultscale' => { 95 => 0xc61e },
	'defaultusercrop' => { 95 => 0xc7b5 },
	'defringe' => { 370 => 'Defringe' },
	'defringegreenamount' => { 370 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 370 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 370 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 370 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 370 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 370 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 182 => 0xa6, 188 => 0x6e },
	'deprecatedon' => { 368 => 'deprecatedOn' },
	'derivedfrom' => { 394 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 394 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 394 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 394 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 394 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 394 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 394 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 394 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 394 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 394 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 394 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 394 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 394 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 394 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 394 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 394 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 394 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 394 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 244 => 'Description', 371 => 'description', 391 => 'Description' },
	'destination' => { 104 => 0x5 },
	'destinationcity' => { 283 => 0x24, 288 => 0x3 },
	'destinationcitycode' => { 289 => 0x1001 },
	'destinationdst' => { 283 => 0x26, 288 => '0.3' },
	'developmentdynamicrange' => { 100 => 0x1403 },
	'devicesettingdescription' => { 374 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 374 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 374 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 374 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 68 => 0x706 },
	'digitalcreationdate' => { 103 => 0x3e },
	'digitalcreationtime' => { 103 => 0x3f },
	'digitaldeehighlightadj' => { 187 => 0x202 },
	'digitaldeeshadowadj' => { 187 => 0x200 },
	'digitaldeethreshold' => { 187 => 0x201 },
	'digitalfilter' => { 314 => 0x59 },
	'digitalfilter01' => { 270 => 0x5 },
	'digitalfilter02' => { 270 => 0x16 },
	'digitalfilter03' => { 270 => 0x27 },
	'digitalfilter04' => { 270 => 0x38 },
	'digitalfilter05' => { 270 => 0x49 },
	'digitalfilter06' => { 270 => 0x5a },
	'digitalfilter07' => { 270 => 0x6b },
	'digitalfilter08' => { 270 => 0x7c },
	'digitalfilter09' => { 270 => 0x8d },
	'digitalfilter10' => { 270 => 0x9e },
	'digitalfilter11' => { 270 => 0xaf },
	'digitalfilter12' => { 270 => 0xc0 },
	'digitalfilter13' => { 270 => 0xd1 },
	'digitalfilter14' => { 270 => 0xe2 },
	'digitalfilter15' => { 270 => 0xf3 },
	'digitalfilter16' => { 270 => 0x104 },
	'digitalfilter17' => { 270 => 0x115 },
	'digitalfilter18' => { 270 => 0x126 },
	'digitalfilter19' => { 270 => 0x137 },
	'digitalfilter20' => { 270 => 0x148 },
	'digitalgain' => { 60 => 0xb },
	'digitalgem' => { 174 => 0x0 },
	'digitalice' => { 187 => 0x100 },
	'digitalimageguid' => { 380 => 'DigImageGUID' },
	'digitalroc' => { 186 => 0x0 },
	'digitalsourcefiletype' => { 380 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 380 => 'DigitalSourceType' },
	'digitalzoom' => { 29 => 0xc, 90 => 0xa, 111 => 0x68, 125 => 'DigitalZoom', 147 => 0xc, 182 => 0x86, 205 => 0xa, 238 => 0x204, 283 => 0x1e, 289 => 0xa, 313 => 0x204, 346 => 0x12, 347 => 0x12 },
	'digitalzoomon' => { 313 => 0x21b },
	'digitalzoomratio' => { 95 => 0xa404, 340 => 0x200, 342 => 0x21c, 374 => 'DigitalZoomRatio' },
	'director' => { 393 => 'director' },
	'directorphotography' => { 393 => 'directorPhotography' },
	'directory' => { 96 => 'Directory' },
	'directoryindex' => { 5 => 0x137, 7 => 0x2dc, 9 => 0x17e, 11 => 0x238, 12 => 0x13f, 13 => 0x133, 14 => 0x1df, 15 => 0x1a7, 16 => 0x1f0, 17 => 0xcc, 18 => 0x1c7, 19 => 0x298, 20 => 0x1e7, 21 => 0x1e5, 22 => [0x27c,0x280], 23 => 0x2b6, 24 => 0x2bf, 25 => 0x1f7 },
	'directoryindex2' => { 19 => 0x29c },
	'directorynumber' => { 170 => 0x6 },
	'disclaimer' => { 244 => 'Disclaimer' },
	'discnumber' => { 393 => 'discNumber' },
	'displayallafpoints' => { 68 => 0x514 },
	'displayaperture' => { 29 => 0x23 },
	'displayedunitsx' => { 295 => 0x2 },
	'displayedunitsy' => { 295 => 0x6 },
	'distance1' => { 111 => 0x28 },
	'distance2' => { 111 => 0x2c },
	'distance3' => { 111 => 0x30 },
	'distance4' => { 111 => 0x34 },
	'distortioncontrol' => { 188 => 0x10 },
	'distortioncorrection' => { 87 => 0x67, 233 => 0x50b, 255 => '7.1', 273 => 0x0, 331 => 0x2013 },
	'distortioncorrection2' => { 237 => 0x1011 },
	'distortioncorrectionon' => { 87 => 0x63 },
	'distortionn' => { 255 => 0xc },
	'distortionparam02' => { 255 => 0x2 },
	'distortionparam04' => { 255 => 0x4 },
	'distortionparam08' => { 255 => 0x8 },
	'distortionparam09' => { 255 => 0x9 },
	'distortionparam11' => { 255 => 0xb },
	'distortionscale' => { 255 => 0x5 },
	'distributor' => { 384 => 'distributor' },
	'dloon' => { 87 => 0xdc },
	'dlosetting' => { 87 => 0xdd },
	'dlosettingapplied' => { 87 => 0xe4 },
	'dloshootingdistance' => { 87 => 0xde },
	'dloversion' => { 87 => 0xe5 },
	'dmcomment' => { 393 => 'comment' },
	'dngadobedata' => { 95 => 0xc634 },
	'dngbackwardversion' => { 95 => 0xc613 },
	'dnglensinfo' => { 95 => 0xc630 },
	'dngprivatedata' => { 95 => 0xc634 },
	'dngversion' => { 95 => 0xc612 },
	'document' => { 244 => 'Document' },
	'documentancestorid' => { 382 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 382 => 'DocumentAncestors' },
	'documenthistory' => { 103 => 0xe7 },
	'documentid' => { 394 => 'DocumentID' },
	'documentname' => { 95 => 0x10d },
	'documentnotes' => { 103 => 0xe6 },
	'doi' => { 384 => 'doi' },
	'dotrange' => { 95 => 0x150 },
	'dpp' => { 365 => 'dpp' },
	'drivemode' => { 91 => 0x3103, 147 => 0x6, 150 => 0x1e, 153 => 0xe, 233 => 0x600, 283 => 0x34, 305 => 0x1002, 314 => 0x3, 319 => 0x4, 320 => 0x7e, 321 => 0x34 },
	'drivemode2' => { 150 => 0xa, 264 => 0x7, 330 => 0xe, 335 => 0x1 },
	'drivemodesetting' => { 321 => 0x4 },
	'dspfirmwareversion' => { 283 => 0x27 },
	'duration' => { 54 => 0x6a, 124 => 'Duration', 138 => 'Duration', 393 => 'duration' },
	'durationscale' => { 393 => [\'duration','durationScale'] },
	'durationvalue' => { 393 => [\'duration','durationValue'] },
	'dustremovaldata' => { 51 => 0x97 },
	'dynamicafarea' => { 222 => '1.4', 227 => '1.4' },
	'dynamicrange' => { 100 => 0x1400 },
	'dynamicrangeexpansion' => { 283 => 0x69, 305 => 0x100e },
	'dynamicrangemax' => { 86 => 0x7c },
	'dynamicrangemin' => { 86 => 0x7a },
	'dynamicrangeoptimizer' => { 150 => 0x15, 331 => [0xb025,0xb04f], 338 => 0x1144, 339 => 0x1144, 340 => 0x1120, 341 => 0x119c, 342 => 0x1178, 343 => 0x1030, 344 => 0x228 },
	'dynamicrangeoptimizerbracket' => { 330 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 319 => 0x19, 320 => 0x17, 321 => 0xd, 335 => 0x5 },
	'dynamicrangeoptimizermode' => { 153 => 0x15, 319 => 0x18, 320 => 0x16, 330 => 0x15 },
	'dynamicrangeoptimizersetting' => { 150 => 0x27, 321 => 0xc, 335 => 0x4 },
	'dynamicrangesetting' => { 100 => 0x1402 },
	'e-dialinprogram' => { 264 => '1.3' },
	'earliestageorloweststage' => { 94 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 94 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 94 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 94 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 94 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 231 => '6.1' },
	'easyexposurecompensation' => { 222 => '6.4', 227 => '4.4', 228 => '5.2' },
	'easymode' => { 29 => 0xb },
	'edgenoisereduction' => { 216 => 0x4, 356 => 0x8028 },
	'edition' => { 384 => 'edition' },
	'editorialupdate' => { 103 => 0x8 },
	'editstatus' => { 103 => 0x7, 292 => 'EditStatus' },
	'editversionname' => { 215 => 0x3d136244 },
	'effectivelv' => { 283 => 0x2d },
	'effectivemaxaperture' => { 178 => 0x12, 179 => 0x13 },
	'eissn' => { 384 => 'eIssn' },
	'elevation' => { 134 => 'Elevation' },
	'email' => { 126 => 'EMail' },
	'embargodate' => { 384 => 'embargoDate', 386 => 'embargoDate' },
	'embeddedxmpdigest' => { 382 => 'EmbeddedXMPDigest' },
	'emissivity' => { 97 => 0x3 },
	'encryptionkey' => { 311 => 0xa020 },
	'endingpage' => { 384 => 'endingPage' },
	'enduser' => { 383 => 'EndUser' },
	'enduserid' => { 383 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 383 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 393 => 'engineer' },
	'enhancedarktones' => { 208 => 0x8 },
	'enhancement' => { 90 => 0x16, 91 => 0x3016 },
	'enhancer' => { 237 => 0x300 },
	'enhancervalues' => { 237 => 0x301 },
	'envelopenumber' => { 104 => 0x28 },
	'envelopepriority' => { 104 => 0x3c },
	'enveloperecordversion' => { 104 => 0x0 },
	'epsonimageheight' => { 238 => 0x20c },
	'epsonimagewidth' => { 238 => 0x20b },
	'epsonsoftware' => { 238 => 0x20d },
	'equipmentinstitution' => { 358 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 358 => 'EquipmentManufacturer' },
	'equipmentversion' => { 234 => 0x0 },
	'ettlii' => { 68 => 0x304, 69 => 0xd, 70 => 0xe, 71 => 0x7, 72 => 0x7, 73 => 0xe },
	'event' => { 359 => 'Event', 363 => 'Event', 380 => 'Event', 384 => 'event' },
	'eventday' => { 94 => [\'Event','EventDay'] },
	'eventearliestdate' => { 94 => [\'Event','EventEarliestDate'] },
	'eventenddayofyear' => { 94 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 94 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 94 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 94 => [\'Event','EventHabitat'] },
	'eventid' => { 94 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 94 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 94 => [\'Event','EventMonth'] },
	'eventnumber' => { 301 => 0x9 },
	'eventremarks' => { 94 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 94 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 94 => [\'Event','EventSamplingProtocol'] },
	'eventstartdayofyear' => { 94 => [\'Event','EventStartDayOfYear'] },
	'eventtime' => { 94 => [\'Event','EventEventTime'] },
	'eventverbatimeventdate' => { 94 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 94 => [\'Event','EventYear'] },
	'evsteps' => { 264 => '1.2', 266 => 0x0 },
	'evstepsize' => { 224 => '5.1', 225 => '6.1', 226 => '6.1', 229 => '0.7' },
	'exclusivityenddate' => { 386 => 'exclusivityEndDate' },
	'excursiontolerance' => { 105 => 0x82 },
	'exif' => { 96 => 'EXIF' },
	'exifbyteorder' => { 96 => 'ExifByteOrder' },
	'exifcamerainfo' => { 103 => 0xe8 },
	'exifimageheight' => { 95 => 0xa003, 374 => 'PixelYDimension' },
	'exifimagewidth' => { 95 => 0xa002, 374 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 96 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 95 => 0x9000, 374 => 'ExifVersion' },
	'exitpupilposition' => { 178 => 0x4, 179 => 0x4 },
	'expirationdate' => { 103 => 0x25, 384 => 'expirationDate', 386 => 'expirationDate' },
	'expirationtime' => { 103 => 0x26 },
	'exposure' => { 95 => 0xfe51, 370 => 'Exposure' },
	'exposure2012' => { 370 => 'Exposure2012' },
	'exposureadj' => { 213 => 0x0 },
	'exposureadj2' => { 213 => 0x12 },
	'exposureadjust' => { 314 => 0xc },
	'exposurebracketingindicatorlast' => { 150 => 0x52 },
	'exposurebracketshotnumber' => { 153 => 0x2d, 330 => 0x2f },
	'exposurebracketstepsize' => { 264 => 0x8 },
	'exposurebracketvalue' => { 182 => 0x19 },
	'exposurecompensation' => { 62 => 0x6, 77 => 0x0, 95 => 0x9204, 111 => 0x24, 125 => 'ExposureComp', 147 => 0xd, 148 => 0x53, 149 => 0x1e, 153 => 0x49c0, 238 => 0x1006, 283 => 0x16, 311 => 0xa013, 314 => [0xc,0x35,0x4d], 338 => 0x114c, 339 => 0x114c, 340 => 0x1128, 342 => 0x1180, 343 => 0x1038, 344 => 0x230, 374 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 335 => 0x2a },
	'exposurecompensationmode' => { 150 => 0x47, 153 => 0x2a },
	'exposurecompensationset' => { 321 => 0x3, 335 => 0x1e },
	'exposurecompensationsetting' => { 150 => 0x1 },
	'exposurecompstepsize' => { 222 => '6.3', 227 => '4.3' },
	'exposurecontrolstep' => { 228 => '6.1' },
	'exposurecontrolstepsize' => { 222 => '6.2', 227 => '4.2', 231 => '7.1' },
	'exposurecount' => { 100 => 0x1032 },
	'exposuredelaymode' => { 222 => '10.1', 224 => '9.1', 225 => '10.1', 226 => '10.1', 227 => '10.4', 228 => '10.1', 229 => '6.4', 231 => '11.2' },
	'exposuredifference' => { 182 => 0xe },
	'exposureindex' => { 95 => 0xa215, 374 => 'ExposureIndex' },
	'exposureindicator' => { 150 => 0x50 },
	'exposurelevelincrements' => { 66 => 0x6, 67 => 0x6, 68 => 0x101, 69 => 0x5, 70 => 0x6, 71 => 0x5, 72 => 0x5, 73 => 0x6, 74 => 0x4, 319 => 0x58, 320 => 0x58 },
	'exposurelockused' => { 360 => 'ExposureLockUsed' },
	'exposuremode' => { 95 => 0xa402, 125 => 'ExposureMode', 147 => 0x1, 148 => 0xa, 149 => 0x0, 150 => 0x0, 153 => 0x34, 233 => 0x200, 250 => 0x40d, 314 => 0x8, 331 => 0xb041, 374 => 'ExposureMode' },
	'exposuremodeinmanual' => { 68 => 0x10b },
	'exposureprogram' => { 95 => 0x8822, 305 => 0x1001, 315 => 0x17e, 319 => 0x3c, 320 => 0x3c, 321 => 0x5, 325 => 0x14, 330 => 0x3f, 335 => 0x2, 338 => 0x1175, 339 => 0x1179, 340 => 0x1155, 341 => 0x11d1, 342 => 0x11ad, 343 => 0x1065, 344 => 0x25d, 352 => 0x48, 374 => 'ExposureProgram' },
	'exposureshift' => { 233 => 0x203 },
	'exposuretime' => { 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x6, 27 => 0x7, 62 => 0x16, 95 => 0x829a, 108 => 0xfd05, 111 => 0x20, 113 => 0xfa24, 115 => 0xf104, 118 => 0x12, 120 => 0x38, 123 => 0x10, 125 => 'ExposureTime', 147 => 0x9, 148 => 0x35, 149 => 0x48, 150 => 0x8, 153 => 0x49b8, 283 => 0x12, 311 => 0xa018, 314 => [0x32,0x4a], 319 => 0x0, 320 => 0x0, 335 => 0x27, 352 => 0x10, 374 => 'ExposureTime' },
	'exposuretime2' => { 314 => [0x33,0x4b] },
	'exposuretuning' => { 182 => 0x1c },
	'exposurevalue' => { 109 => 0x3 },
	'exposurewarning' => { 100 => 0x1302 },
	'exrauto' => { 100 => 0x1033 },
	'exrmode' => { 100 => 0x1034 },
	'extendedwbdetect' => { 233 => 0x902 },
	'extender' => { 234 => 0x301 },
	'extenderfirmwareversion' => { 234 => 0x304 },
	'extendermagnification' => { 127 => 'Magnification' },
	'extendermake' => { 127 => 'Make' },
	'extendermodel' => { 127 => 'Model', 234 => 0x303 },
	'extenderserialnumber' => { 127 => 'SerialNumber', 234 => 0x302 },
	'externalflash' => { 236 => 0x1201 },
	'externalflashae1' => { 238 => 0x101f },
	'externalflashae1_0' => { 238 => 0x101b },
	'externalflashae2' => { 238 => 0x1020 },
	'externalflashae2_0' => { 238 => 0x101c },
	'externalflashbounce' => { 236 => 0x1204, 238 => 0x1026, 271 => 0x1a },
	'externalflashcompensation' => { 173 => 0x1b },
	'externalflashexposurecomp' => { 182 => 0x17, 271 => 0x19 },
	'externalflashfirmware' => { 171 => 0x6, 172 => 0x6, 173 => 0x6 },
	'externalflashflags' => { 171 => 0x8, 172 => 0x8, 173 => 0x8 },
	'externalflashguidenumber' => { 236 => 0x1203, 271 => '24.1' },
	'externalflashgvalue' => { 238 => 0x1025 },
	'externalflashmode' => { 238 => 0x1028, 271 => 0x2 },
	'externalflashzoom' => { 236 => 0x1205, 238 => 0x1027 },
	'externalsensorbrightnessvalue' => { 248 => 0x311, 254 => 0x3408 },
	'extrainfoversion' => { 323 => 0x1a },
	'eyestartaf' => { 150 => 0x40 },
	'face10position' => { 88 => 0x3f4, 89 => 0x1ec, 169 => 0x28, 268 => 0x12 },
	'face10size' => { 269 => 0x12 },
	'face11position' => { 169 => 0x2c, 268 => 0x14 },
	'face11size' => { 269 => 0x14 },
	'face12position' => { 169 => 0x30, 268 => 0x16 },
	'face12size' => { 269 => 0x16 },
	'face13position' => { 268 => 0x18 },
	'face13size' => { 269 => 0x18 },
	'face14position' => { 268 => 0x1a },
	'face14size' => { 269 => 0x1a },
	'face15position' => { 268 => 0x1c },
	'face15size' => { 269 => 0x1c },
	'face16position' => { 268 => 0x1e },
	'face16size' => { 269 => 0x1e },
	'face17position' => { 268 => 0x20 },
	'face17size' => { 269 => 0x20 },
	'face18position' => { 268 => 0x22 },
	'face18size' => { 269 => 0x22 },
	'face19position' => { 268 => 0x24 },
	'face19size' => { 269 => 0x24 },
	'face1position' => { 43 => 0x8, 88 => 0xd, 89 => 0x18, 169 => 0x4, 246 => 0x1, 268 => 0x0, 302 => 0xbc, 326 => 0x1, 327 => 0x0, 328 => 0x0, 329 => 0x5b },
	'face1size' => { 269 => 0x0 },
	'face20position' => { 268 => 0x26 },
	'face20size' => { 269 => 0x26 },
	'face21position' => { 268 => 0x28 },
	'face21size' => { 269 => 0x28 },
	'face22position' => { 268 => 0x2a },
	'face22size' => { 269 => 0x2a },
	'face23position' => { 268 => 0x2c },
	'face23size' => { 269 => 0x2c },
	'face24position' => { 268 => 0x2e },
	'face24size' => { 269 => 0x2e },
	'face25position' => { 268 => 0x30 },
	'face25size' => { 269 => 0x30 },
	'face26position' => { 268 => 0x32 },
	'face26size' => { 269 => 0x32 },
	'face27position' => { 268 => 0x34 },
	'face27size' => { 269 => 0x34 },
	'face28position' => { 268 => 0x36 },
	'face28size' => { 269 => 0x36 },
	'face29position' => { 268 => 0x38 },
	'face29size' => { 269 => 0x38 },
	'face2position' => { 43 => 0xa, 88 => 0x7c, 89 => 0x4c, 169 => 0x8, 246 => 0x5, 268 => 0x2, 302 => 0xc8, 326 => 0x6, 327 => 0x20, 328 => 0x25, 329 => 0x65 },
	'face2size' => { 269 => 0x2 },
	'face30position' => { 268 => 0x3a },
	'face30size' => { 269 => 0x3a },
	'face31position' => { 268 => 0x3c },
	'face31size' => { 269 => 0x3c },
	'face32position' => { 268 => 0x3e },
	'face32size' => { 269 => 0x3e },
	'face3position' => { 43 => 0xc, 88 => 0xeb, 89 => 0x80, 169 => 0xc, 246 => 0x9, 268 => 0x4, 302 => 0xd4, 326 => 0xb, 327 => 0x40, 328 => 0x4a, 329 => 0x6f },
	'face3size' => { 269 => 0x4 },
	'face4position' => { 43 => 0xe, 88 => 0x15a, 89 => 0xb4, 169 => 0x10, 246 => 0xd, 268 => 0x6, 302 => 0xe0, 326 => 0x10, 327 => 0x60, 328 => 0x6f, 329 => 0x79 },
	'face4size' => { 269 => 0x6 },
	'face5position' => { 43 => 0x10, 88 => 0x1c9, 89 => 0xe8, 169 => 0x14, 246 => 0x11, 268 => 0x8, 302 => 0xec, 326 => 0x15, 327 => 0x80, 328 => 0x94 },
	'face5size' => { 269 => 0x8 },
	'face6position' => { 43 => 0x12, 88 => 0x238, 89 => 0x11c, 169 => 0x18, 268 => 0xa, 302 => 0xf8, 326 => 0x1a, 327 => 0xa0, 328 => 0xb9 },
	'face6size' => { 269 => 0xa },
	'face7position' => { 43 => 0x14, 88 => 0x2a7, 89 => 0x150, 169 => 0x1c, 268 => 0xc, 302 => 0x104, 326 => 0x1f, 327 => 0xc0, 328 => 0xde },
	'face7size' => { 269 => 0xc },
	'face8position' => { 43 => 0x16, 88 => 0x316, 89 => 0x184, 169 => 0x20, 268 => 0xe, 302 => 0x110, 326 => 0x24, 327 => 0xe0, 328 => 0x103 },
	'face8size' => { 269 => 0xe },
	'face9position' => { 43 => 0x18, 88 => 0x385, 89 => 0x1b8, 169 => 0x24, 268 => 0x10 },
	'face9size' => { 269 => 0x10 },
	'facedetect' => { 283 => 0x76 },
	'facedetectarea' => { 237 => 0x1201 },
	'facedetectframecrop' => { 237 => 0x1207 },
	'facedetectframesize' => { 43 => 0x3, 88 => 0x1, 89 => 0x4, 169 => 0x1, 237 => 0x1203, 283 => 0x77, 302 => 0xb6 },
	'facedetection' => { 321 => 0x30, 335 => 0x19 },
	'faceid' => { 366 => 'FaceID' },
	'faceinfounknown' => { 91 => 0x2089 },
	'faceorientation' => { 89 => 0x8 },
	'faceposition' => { 267 => 0x2, 312 => 0x4 },
	'facepositions' => { 100 => 0x4103 },
	'facesdetected' => { 43 => 0x2, 44 => 0x2, 45 => 0x3, 88 => 0x0, 89 => 0x2, 91 => 0x211c, 100 => 0x4100, 169 => 0x3, 237 => 0x1200, 252 => 0x3f, 267 => 0x0, 302 => 0xb5, 312 => 0x0, 326 => 0x0, 329 => 0x3, 337 => 0x30 },
	'facesrecognized' => { 247 => 0x0 },
	'facewidth' => { 44 => 0x1 },
	'faithfuloutputhighlightpoint' => { 87 => 0x38 },
	'faithfuloutputshadowpoint' => { 87 => 0x39 },
	'faithfulrawcolortone' => { 87 => 0x31 },
	'faithfulrawcontrast' => { 87 => 0x33 },
	'faithfulrawhighlight' => { 87 => 0x79 },
	'faithfulrawhighlightpoint' => { 87 => 0x36 },
	'faithfulrawlinear' => { 87 => 0x34 },
	'faithfulrawsaturation' => { 87 => 0x32 },
	'faithfulrawshadow' => { 87 => 0x82 },
	'faithfulrawshadowpoint' => { 87 => 0x37 },
	'faithfulrawsharpness' => { 87 => 0x35 },
	'faithfulunsharpmaskfineness' => { 87 => 0xac },
	'faithfulunsharpmaskstrength' => { 87 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 87 => 0xae },
	'femicroadjustment' => { 68 => 0x110 },
	'ffid' => { 372 => 'ffid' },
	'fieldcount' => { 238 => 0x103f },
	'filecreatedate' => { 96 => 'FileCreateDate' },
	'filedatarate' => { 393 => 'fileDataRate' },
	'fileformat' => { 79 => 0x0, 104 => 0x14, 314 => [0x22,0x26], 331 => 0xb000 },
	'fileindex' => { 5 => 0x143, 7 => 0x2d0, 9 => 0x172, 11 => 0x22c, 12 => 0x133, 13 => 0x13f, 14 => 0x1d3, 15 => 0x19b, 16 => 0x1e4, 17 => 0xd0, 18 => 0x1bb, 19 => 0x28c, 20 => 0x1db, 21 => 0x1d9, 22 => [0x270,0x274], 23 => 0x2aa, 24 => 0x2b3, 25 => 0x1eb, 253 => 0x0 },
	'fileindex2' => { 19 => 0x290 },
	'filemodifydate' => { 96 => 'FileModifyDate' },
	'filename' => { 96 => 'FileName' },
	'filenameasdelivered' => { 383 => 'FileNameAsDelivered' },
	'filenumber' => { 46 => 0x1, 51 => 0x8, 81 => 0x1817, 92 => 'FileNumber', 170 => 0x8 },
	'filenumbermemory' => { 147 => 0x1a },
	'filenumbersequence' => { 222 => '12.2', 224 => '3.1', 225 => '4.1', 226 => '4.1', 227 => '11.1', 228 => '4.3', 231 => '5.2' },
	'filesource' => { 95 => 0xa300, 100 => 0x8000, 374 => 'FileSource' },
	'fileversion' => { 104 => 0x16 },
	'fillflashautoreduction' => { 66 => 0xe, 67 => 0xe, 74 => 0xa },
	'filllight' => { 370 => 'FillLight' },
	'fillorder' => { 95 => 0x10a },
	'filmmode' => { 100 => 0x1401, 250 => 0x412, 252 => 0x42 },
	'filmtype' => { 187 => 0x2 },
	'filtereffect' => { 46 => 0xe, 184 => 0x37 },
	'filtereffectauto' => { 57 => 0xa0 },
	'filtereffectfaithful' => { 56 => 0x70, 57 => 0x70 },
	'filtereffectlandscape' => { 56 => 0x40, 57 => 0x40 },
	'filtereffectmonochrome' => { 17 => 0xff, 56 => 0x88, 57 => 0x88 },
	'filtereffectneutral' => { 56 => 0x58, 57 => 0x58 },
	'filtereffectportrait' => { 56 => 0x28, 57 => 0x28 },
	'filtereffectstandard' => { 56 => 0x10, 57 => 0x10 },
	'filtereffectuserdef1' => { 56 => 0xa0, 57 => 0xb8 },
	'filtereffectuserdef2' => { 56 => 0xb8, 57 => 0xd0 },
	'filtereffectuserdef3' => { 56 => 0xd0, 57 => 0xe8 },
	'finderdisplayduringexposure' => { 67 => 0x1 },
	'finesharpness' => { 283 => 0x70 },
	'finetuneoptcenterweighted' => { 222 => '7.2', 231 => '9.1' },
	'finetuneoptmatrixmetering' => { 222 => '8.1', 227 => '6.1', 231 => '8.2' },
	'finetuneoptspotmetering' => { 222 => '8.2', 227 => '6.2', 231 => '9.2' },
	'firmware' => { 238 => 0x405, 314 => [0x17,0x3b,0x57], 367 => 'Firmware' },
	'firmwaredate' => { 90 => 0x15, 91 => 0x2001, 301 => 0x4 },
	'firmwareid' => { 154 => 0x0 },
	'firmwarename' => { 311 => 0xa001 },
	'firmwarerevision' => { 17 => 0xa4, 51 => 0x1e, 303 => 0x0 },
	'firmwarerevision2' => { 303 => 0xc },
	'firmwareversion' => { 5 => 0x10b, 9 => 0x136, 12 => 0xff, 13 => 0x107, 109 => 0xce5, 123 => 0x57, 125 => 'FirmwareVersion', 252 => 0x2, 254 => 0x3109, 283 => 0x230, 305 => 0x2 },
	'firstphotodate' => { 360 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 383 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 103 => 0x16 },
	'flash' => { 92 => 'Flash', 95 => 0x9209, 148 => 0x1f, 149 => 0x15, 374 => 'Flash' },
	'flashaction' => { 321 => [0x87,0x287] },
	'flashaction2' => { 335 => 0x30 },
	'flashactivity' => { 29 => 0x1c },
	'flashbatterylevel' => { 35 => 0x249 },
	'flashbias' => { 252 => 0x24 },
	'flashbits' => { 29 => 0x1d },
	'flashbuttonfunction' => { 68 => 0x70e },
	'flashchargelevel' => { 238 => 0x1010 },
	'flashcolorfilter' => { 173 => 0x10 },
	'flashcommandermode' => { 171 => '9.1', 172 => '9.1', 173 => '9.1' },
	'flashcompensation' => { 171 => 0xa, 172 => 0xa, 173 => 0xa, 367 => 'FlashCompensation' },
	'flashcontrol' => { 321 => 0x21 },
	'flashcontrolbuilt-in' => { 227 => '16.1', 228 => '23.1', 230 => '23.1' },
	'flashcontrolmode' => { 171 => '9.2', 172 => '9.2', 173 => '9.2', 233 => 0x404 },
	'flashcurtain' => { 252 => 0x48 },
	'flashdefault' => { 150 => 0x42 },
	'flashdevice' => { 238 => 0x1005 },
	'flashdistance' => { 91 => 0x2034 },
	'flashenergy' => { 95 => 0xa20b, 374 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 182 => 0x18 },
	'flashexposurecomp' => { 62 => 0xf, 100 => 0x1011, 128 => 'ExposureComp', 147 => 0x23, 152 => 0x104, 153 => 0x49c1, 182 => 0x12, 233 => 0x401, 238 => 0x1023, 283 => 0x4d, 305 => 0x100b, 314 => [0x3a,0x56], 331 => 0x104 },
	'flashexposurecomp2' => { 203 => 0x4d2 },
	'flashexposurecomp3' => { 173 => 0x1d },
	'flashexposurecomp4' => { 173 => 0x27 },
	'flashexposurecompset' => { 150 => 0x10, 257 => 0xe, 321 => 0x23, 335 => 0x1f },
	'flashexposurecompset2' => { 335 => 0x2c },
	'flashexposureindicator' => { 150 => 0x54 },
	'flashexposureindicatorlast' => { 150 => 0x56 },
	'flashexposureindicatornext' => { 150 => 0x55 },
	'flashexposurelock' => { 46 => 0x19 },
	'flashfired' => { 111 => 0x5d, 128 => 'Fired', 147 => 0x14, 202 => '590.3', 252 => 0x8007, 374 => [\'Flash','FlashFired'] },
	'flashfiring' => { 68 => 0x306, 69 => 0x6, 70 => 0x7, 73 => 0x7 },
	'flashfirmwareversion' => { 234 => 0x1002 },
	'flashfocallength' => { 171 => 0xb, 172 => 0xc, 173 => 0xc },
	'flashfunction' => { 153 => 0x31, 374 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 171 => 0xe, 172 => 0xf, 173 => 0xf },
	'flashgroupacompensation' => { 171 => 0x11, 172 => 0x12, 173 => 0x13 },
	'flashgroupacontrolmode' => { 171 => 0xf, 172 => '16.1', 173 => '17.1' },
	'flashgroupaoutput' => { 171 => 0x11, 172 => 0x12, 173 => 0x13 },
	'flashgroupbcompensation' => { 171 => 0x12, 172 => 0x13, 173 => 0x14 },
	'flashgroupbcontrolmode' => { 171 => 0x10, 172 => '17.1', 173 => '18.1' },
	'flashgroupboutput' => { 171 => 0x12, 172 => 0x13, 173 => 0x14 },
	'flashgroupccompensation' => { 172 => 0x14, 173 => 0x15 },
	'flashgroupccontrolmode' => { 172 => '17.2', 173 => '18.2' },
	'flashgroupcoutput' => { 172 => 0x14, 173 => 0x15 },
	'flashguidenumber' => { 62 => 0xd, 78 => 0x0, 128 => 'GuideNumber' },
	'flashintensity' => { 90 => [0x19,0x5], 233 => 0x405 },
	'flashlevel' => { 223 => 0x9, 331 => 0xb048 },
	'flashmake' => { 128 => 'Make' },
	'flashmanufacturer' => { 145 => 'FlashManufacturer' },
	'flashmetering' => { 147 => 0x3f, 150 => 0x1c },
	'flashmeteringmode' => { 5 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 18 => 0x15, 20 => 0x15, 25 => 0x15 },
	'flashmeteringsegments' => { 283 => 0x20a },
	'flashmode' => { 90 => 0x4, 111 => 0x5c, 128 => 'Mode', 147 => 0x2, 148 => 0x20, 149 => 0x16, 150 => 0xf, 182 => 0x87, 233 => 0x400, 238 => 0x1004, 283 => 0xc, 289 => 0x4, 304 => 0x20, 305 => 0x100a, 313 => 0x225, 319 => 0x23, 320 => 0x1f, 321 => 0x20, 335 => 0x10, 374 => [\'Flash','FlashMode'] },
	'flashmodel' => { 128 => 'Model', 145 => 'FlashModel', 234 => 0x1001 },
	'flashoptions' => { 264 => 0x2 },
	'flashoptions2' => { 264 => 0x10 },
	'flashoutput' => { 35 => 0x248, 62 => 0x21, 171 => 0xa, 172 => 0xa, 173 => 0xa },
	'flashpixversion' => { 95 => 0xa000, 374 => 'FlashpixVersion' },
	'flashredeyemode' => { 374 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 233 => 0x403 },
	'flashreturn' => { 374 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 128 => 'SerialNumber', 234 => 0x1003 },
	'flashsetting' => { 182 => 0x8 },
	'flashshutterspeed' => { 222 => '20.2', 227 => '15.2', 228 => '22.2', 229 => '7.2', 230 => '22.2', 231 => '23.1' },
	'flashsource' => { 171 => 0x4, 172 => 0x4, 173 => 0x4 },
	'flashstatus' => { 271 => 0x0, 345 => 0x31 },
	'flashsyncspeed' => { 222 => '20.1', 227 => '15.1', 228 => '22.1', 230 => '22.1' },
	'flashsyncspeedav' => { 66 => 0x3, 68 => 0x10f, 69 => 0x2, 70 => 0x3, 71 => 0x2, 72 => 0x2, 73 => 0x3, 74 => 0x6 },
	'flashthreshold' => { 78 => 0x1 },
	'flashtype' => { 128 => 'Type', 150 => 0x59, 182 => 0x9, 234 => 0x1000 },
	'flashwarning' => { 228 => '30.1', 229 => '7.1', 231 => '31.1', 252 => 0x62 },
	'flexiblespotposition' => { 331 => 0x201d },
	'flickerreduce' => { 313 => 0x218 },
	'fliphorizontal' => { 215 => 0x76a43206 },
	'fnumber' => { 5 => 0x3, 7 => 0x3, 9 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x5, 27 => 0x6, 62 => 0x15, 95 => 0x829d, 108 => 0xfd04, 111 => 0x1e, 113 => 0xfa23, 115 => 0xf103, 118 => 0x13, 120 => 0x3c, 123 => 0xc, 132 => 'FNumber', 147 => 0xa, 148 => 0x36, 149 => 0x47, 150 => 0x9, 153 => 0x49c7, 283 => 0x13, 311 => 0xa019, 314 => [0x31,0x49], 319 => 0x1, 320 => 0x1, 335 => 0x26, 374 => 'FNumber' },
	'focallength' => { 5 => 0x1d, 6 => 0xa, 7 => 0x23, 8 => 0x9, 9 => 0x1d, 10 => 0x9, 11 => 0x1e, 12 => 0x1d, 13 => 0x1d, 14 => 0x1e, 15 => 0x1e, 16 => 0x1e, 17 => 0x28, 18 => 0x1e, 19 => 0x23, 20 => 0x1e, 21 => 0x1e, 22 => 0x23, 23 => 0x23, 24 => 0x23, 25 => 0x1e, 48 => 0x1, 91 => 0x1d, 95 => 0x920a, 118 => 0x1d, 132 => 'FocalLength', 147 => 0x12, 178 => 0xa, 179 => 0xb, 274 => 0x9, 283 => 0x1d, 305 => 0x1500, 317 => 0xe, 342 => 0x1278, 343 => 0x1134, 344 => 0x32c, 374 => 'FocalLength' },
	'focallength2' => { 335 => 0x29 },
	'focallengthin35mmformat' => { 95 => 0xa405, 311 => 0xa01a, 374 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 317 => 0x10 },
	'focalplanediagonal' => { 234 => 0x103, 238 => 0x205 },
	'focalplaneresolutionunit' => { 95 => 0xa210, 374 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 95 => 0xa20e, 374 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 48 => 0x2 },
	'focalplanexunknown' => { 48 => 0x2 },
	'focalplaneyresolution' => { 95 => 0xa20f, 374 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 48 => 0x3 },
	'focalplaneyunknown' => { 48 => 0x3 },
	'focaltype' => { 8 => 0x2d, 48 => 0x0 },
	'focalunits' => { 29 => 0x19 },
	'focus' => { 205 => 0x8 },
	'focusarea' => { 147 => 0x31 },
	'focusareaselection' => { 229 => '15.2' },
	'focuscontinuous' => { 29 => 0x20 },
	'focusdisplayaiservoandmf' => { 68 => 0x515 },
	'focusdistance' => { 132 => 'FocusDistance', 147 => 0x13, 153 => 0x49bb, 178 => 0x9, 179 => 0xa, 236 => 0x305 },
	'focusdistancelower' => { 5 => 0x45, 7 => 0x8e, 9 => 0x45, 11 => 0x56, 12 => 0x45, 13 => 0x45, 14 => 0x52, 15 => 0x52, 16 => 0x56, 18 => 0x52, 19 => 0x8e, 20 => 0x59, 21 => 0x57, 22 => 0x8e, 23 => 0x94, 24 => 0x95, 25 => 0x56, 46 => 0x15, 62 => 0x14 },
	'focusdistanceupper' => { 5 => 0x43, 7 => 0x8c, 9 => 0x43, 11 => 0x54, 12 => 0x43, 13 => 0x43, 14 => 0x50, 15 => 0x50, 16 => 0x54, 18 => 0x50, 19 => 0x8c, 20 => 0x57, 21 => 0x55, 22 => 0x8c, 23 => 0x92, 24 => 0x93, 25 => 0x54, 46 => 0x14, 62 => 0x13 },
	'focusholdbutton' => { 150 => 0x44 },
	'focusinfoversion' => { 236 => 0x0 },
	'focusingscreen' => { 67 => 0x0, 68 => 0x80b, 73 => 0x0 },
	'focuslocked' => { 146 => 0x14 },
	'focusmode' => { 29 => 0x7, 90 => 0x3, 91 => [0x3003,0xd], 100 => 0x1021, 111 => 0x38, 125 => 'FocusMode', 147 => 0x30, 149 => 0xe, 150 => 0xc, 182 => 0x7, 233 => 0x301, 238 => 0x100b, 252 => 0x7, 283 => 0xd, 289 => 0x3, 305 => 0x1006, 315 => 0xb, 317 => [0x15,0x1d], 319 => 0x4d, 320 => 0x4d, 331 => [0xb042,0xb04e,0x201b], 335 => 0x13, 349 => 0x16 },
	'focusmode2' => { 264 => '3.1', 335 => 0x32 },
	'focusmodesetting' => { 223 => '10.1', 318 => 0x14, 319 => 0x10, 320 => 0xf, 321 => 0x6 },
	'focusmodeswitch' => { 150 => 0x58, 319 => 0x2e },
	'focuspixel' => { 100 => 0x1023 },
	'focuspointwrap' => { 222 => '2.2', 227 => '2.2', 228 => '1.2', 231 => '2.5' },
	'focusposition' => { 178 => 0x8, 179 => 0x8, 283 => 0x10, 330 => 0x9bb },
	'focusprocess' => { 233 => 0x302 },
	'focusrange' => { 29 => 0x12, 238 => 0x100a },
	'focussetting' => { 314 => 0x6 },
	'focusstatus' => { 317 => 0x19, 319 => 0x53, 320 => 0x53 },
	'focusstepcount' => { 236 => 0x301, 238 => 0x100e },
	'focusstepinfinity' => { 236 => 0x303, 238 => 0x103b },
	'focusstepnear' => { 236 => 0x304, 238 => 0x103c },
	'focustrackinglockon' => { 222 => ['1.5','4.1'], 227 => '3.1', 228 => '0.4' },
	'focuswarning' => { 100 => 0x1301 },
	'foldername' => { 147 => 0x27 },
	'foldernumber' => { 319 => 0x9a, 321 => [0x402,0x114,0x316] },
	'fontcomposite' => { 398 => [\'Fonts','FontsComposite'] },
	'fontface' => { 398 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 398 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 398 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 398 => [\'Fonts','FontsFontName'] },
	'fonts' => { 398 => 'Fonts' },
	'fonttype' => { 398 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 398 => [\'Fonts','FontsVersionString'] },
	'for' => { 296 => 'For' },
	'format' => { 371 => 'format', 391 => 'Format' },
	'forwardlock' => { 388 => 'forwardlock' },
	'forwardmatrix1' => { 95 => 0xc714 },
	'forwardmatrix2' => { 95 => 0xc715 },
	'framecount' => { 54 => [0x2,0x4] },
	'frameheight' => { 100 => 0x3822 },
	'framenum' => { 291 => 0xd7 },
	'framenumber' => { 100 => 0x8003, 153 => 0x3c, 283 => 0x29 },
	'framerate' => { 54 => [0x1,0x6], 95 => 0xc764, 100 => 0x3820 },
	'framewidth' => { 100 => 0x3821 },
	'freebytes' => { 81 => 0x1 },
	'freememorycardimages' => { 148 => [0x37,0x54], 149 => [0x2d,0x4a], 150 => 0x32 },
	'fujiflashmode' => { 100 => 0x1010 },
	'fullimagesize' => { 331 => 0xb02b },
	'fullpanoheightpixels' => { 360 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 360 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 305 => 0x100d },
	'fullsizeimage' => { 131 => 'data' },
	'fullsizeimagename' => { 131 => '1Name' },
	'fullsizeimagetype' => { 131 => '0Type' },
	'funcbutton' => { 222 => ['14.1','15.1'], 227 => '28.1', 228 => '13.1', 231 => '14.1' },
	'funcbuttonplusdials' => { 222 => ['14.2','15.2'], 227 => '31.1' },
	'functionbutton' => { 226 => '13.1', 229 => '5.2' },
	'gainbase' => { 237 => 0x610 },
	'gaincontrol' => { 95 => 0xa407, 374 => 'GainControl' },
	'gamma' => { 95 => 0xa500, 375 => 'Gamma' },
	'gammacompensatedvalue' => { 105 => 0x91 },
	'geimagesize' => { 100 => 0x1304 },
	'gemake' => { 101 => 0x300 },
	'gemodel' => { 101 => 0x207 },
	'genre' => { 384 => 'genre', 393 => 'genre' },
	'geography' => { 385 => 'geography' },
	'geologicalcontext' => { 94 => 'GeologicalContext' },
	'geologicalcontextbed' => { 94 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 94 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 94 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 94 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 94 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 96 => 'Geosync' },
	'geotag' => { 96 => 'Geotag' },
	'geotiffasciiparams' => { 95 => 0x87b1 },
	'geotiffdirectory' => { 95 => 0x87af },
	'geotiffdoubleparams' => { 95 => 0x87b0 },
	'geotime' => { 96 => 'Geotime' },
	'globalaltitude' => { 294 => 0x419 },
	'globalangle' => { 294 => 0x40d },
	'good' => { 393 => 'good' },
	'gpsaltitude' => { 102 => 0x6, 129 => 'Altitude', 374 => 'GPSAltitude' },
	'gpsaltituderef' => { 102 => 0x5, 374 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 102 => 0x1c, 374 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 102 => 0x1d },
	'gpsdatetime' => { 129 => 'DateTime', 374 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 102 => 0x18, 129 => 'Bearing', 374 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 102 => 0x17, 374 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 102 => 0x1a, 129 => 'Distance', 374 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 102 => 0x19, 374 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 102 => 0x14, 374 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 102 => 0x13 },
	'gpsdestlongitude' => { 102 => 0x16, 374 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 102 => 0x15 },
	'gpsdifferential' => { 102 => 0x1e, 129 => 'Differential', 374 => 'GPSDifferential' },
	'gpsdop' => { 102 => 0xb, 374 => 'GPSDOP' },
	'gpshpositioningerror' => { 102 => 0x1f, 374 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 102 => 0x11, 374 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 102 => 0x10, 374 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 102 => 0x2, 129 => 'Latitude', 374 => 'GPSLatitude' },
	'gpslatituderef' => { 102 => 0x1 },
	'gpslongitude' => { 102 => 0x4, 129 => 'Longitude', 374 => 'GPSLongitude' },
	'gpslongituderef' => { 102 => 0x3 },
	'gpsmapdatum' => { 102 => 0x12, 129 => 'Datum', 374 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 102 => 0xa, 129 => 'MeasureMode', 374 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 102 => 0x1b, 374 => 'GPSProcessingMethod' },
	'gpssatellites' => { 102 => 0x8, 129 => 'Satellites', 374 => 'GPSSatellites' },
	'gpsspeed' => { 102 => 0xd, 129 => 'Speed', 374 => 'GPSSpeed' },
	'gpsspeedref' => { 102 => 0xc, 374 => 'GPSSpeedRef' },
	'gpsstatus' => { 102 => 0x9, 374 => 'GPSStatus' },
	'gpstimestamp' => { 102 => 0x7 },
	'gpstrack' => { 102 => 0xf, 129 => 'Heading', 374 => 'GPSTrack' },
	'gpstrackref' => { 102 => 0xe, 374 => 'GPSTrackRef' },
	'gpsversionid' => { 102 => 0x0, 374 => 'GPSVersionID' },
	'gradation' => { 233 => 0x50f },
	'gradientbasedcorractive' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 370 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 370 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 370 => 'GrainAmount' },
	'grainfrequency' => { 370 => 'GrainFrequency' },
	'grainsize' => { 370 => 'GrainSize' },
	'graymixeraqua' => { 370 => 'GrayMixerAqua' },
	'graymixerblue' => { 370 => 'GrayMixerBlue' },
	'graymixergreen' => { 370 => 'GrayMixerGreen' },
	'graymixermagenta' => { 370 => 'GrayMixerMagenta' },
	'graymixerorange' => { 370 => 'GrayMixerOrange' },
	'graymixerpurple' => { 370 => 'GrayMixerPurple' },
	'graymixerred' => { 370 => 'GrayMixerRed' },
	'graymixeryellow' => { 370 => 'GrayMixerYellow' },
	'graypoint' => { 356 => 0x8021 },
	'grayresponseunit' => { 95 => 0x122 },
	'greencurvelimits' => { 86 => 0x1c4 },
	'greencurvepoints' => { 86 => 0x19a },
	'greenhue' => { 370 => 'GreenHue' },
	'greensaturation' => { 370 => 'GreenSaturation' },
	'griddisplay' => { 222 => '13.3', 224 => '2.2', 227 => '10.5', 228 => '3.4', 229 => '6.1', 231 => '4.2' },
	'gripbatteryadload' => { 262 => 0x5 },
	'gripbatteryadnoload' => { 262 => 0x4 },
	'gripbatterystate' => { 262 => '1.2' },
	'halftonehints' => { 95 => 0x141 },
	'hardlink' => { 96 => 'HardLink' },
	'hasalternative' => { 384 => 'hasAlternative' },
	'hascorrection' => { 384 => 'hasCorrection' },
	'hascrop' => { 370 => 'HasCrop' },
	'hasextendedxmp' => { 395 => 'HasExtendedXMP' },
	'haspreviousversion' => { 384 => 'hasPreviousVersion' },
	'hassettings' => { 370 => 'HasSettings' },
	'hastranslation' => { 384 => 'hasTranslation' },
	'hdr' => { 175 => 0x4, 252 => 0x9e, 283 => 0x85, 331 => 0x200a },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 175 => 0x0 },
	'hdrlevel' => { 175 => 0x5, 321 => 0x2e, 335 => 0x17 },
	'hdrlevel2' => { 175 => 0x7 },
	'hdrsetting' => { 321 => 0x2d, 335 => 0x16, 338 => 0x1148, 339 => 0x1148, 340 => 0x1124, 341 => 0x11a0, 342 => 0x117c, 343 => 0x1034, 344 => 0x22c },
	'hdrsmoothing' => { 175 => 0x6 },
	'headline' => { 103 => 0x69, 382 => 'Headline' },
	'hierarchicalkeywords' => { 140 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 140 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 140 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 140 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 140 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 362 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 94 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 256 => 0x1a },
	'highisomultipliergreen' => { 256 => 0x19 },
	'highisomultiplierred' => { 256 => 0x18 },
	'highisonoisereduction' => { 14 => 0xbc, 15 => 0xbd, 18 => 0xbd, 25 => 0xc9, 68 => 0x202, 100 => 0x100e, 182 => 0xb1, 283 => 0x71, 319 => 0x2c, 320 => 0x26, 321 => 0x26, 331 => 0x2009, 335 => 0x12 },
	'highisonoisereduction2' => { 331 => 0xb050 },
	'highlight' => { 314 => 0xf },
	'highlightcolordistortreduct' => { 356 => 0x8026 },
	'highlightprotection' => { 214 => 0x6 },
	'highlightrecovery' => { 370 => 'HighlightRecovery' },
	'highlights' => { 364 => 'Highlights' },
	'highlights2012' => { 370 => 'Highlights2012' },
	'highlighttone' => { 100 => 0x1041 },
	'highlighttonepriority' => { 11 => 0x7, 14 => 0x7, 15 => 0x7, 16 => 0x7, 18 => 0x7, 20 => 0x7, 25 => 0x7, 68 => 0x203 },
	'highlowkeyadj' => { 283 => 0x6c },
	'highspeedsync' => { 150 => 0x5 },
	'histogramxml' => { 215 => 0x83a1a25 },
	'history' => { 382 => 'History', 394 => 'History' },
	'historyaction' => { 394 => [\'History','HistoryAction'] },
	'historychanged' => { 394 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 394 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 394 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 394 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 394 => [\'History','HistoryWhen'] },
	'hometowncity' => { 91 => 0x3006, 283 => 0x23, 288 => 0x2 },
	'hometowncitycode' => { 289 => 0x1000 },
	'hometowndst' => { 283 => 0x25, 288 => '0.2' },
	'hostcomputer' => { 95 => 0x13c },
	'hue' => { 155 => 0x3b, 283 => 0x67 },
	'hueadj' => { 218 => 0x2f, 356 => 0x8019 },
	'hueadjust' => { 305 => 0x1016 },
	'hueadjustment' => { 148 => 0x4a, 149 => 0x40, 182 => 0x92, 184 => 0x36 },
	'hueadjustmentaqua' => { 370 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 370 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 370 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 370 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 370 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 370 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 370 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 370 => 'HueAdjustmentYellow' },
	'huesetting' => { 241 => 0x1011 },
	'icc_profile' => { 96 => 'ICC_Profile' },
	'iccprofilename' => { 382 => 'ICCProfile' },
	'idccreativestyle' => { 356 => 0x8000 },
	'idcpreviewlength' => { 356 => 0x202 },
	'idcpreviewstart' => { 356 => 0x201 },
	'identification' => { 94 => 'Identification' },
	'identificationid' => { 94 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 94 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 94 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 94 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 94 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 94 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 371 => 'identifier', 391 => 'Identifier' },
	'illumination' => { 229 => '0.5' },
	'imageadjustment' => { 182 => 0x80, 205 => 0x5 },
	'imagealterationconstraints' => { 383 => 'ImageAlterationConstraints' },
	'imagearea' => { 192 => 0x10, 195 => 0x10 },
	'imageareaoffset' => { 283 => 0x38 },
	'imageauthentication' => { 182 => 0x20 },
	'imageboundary' => { 182 => 0x16 },
	'imagecount' => { 182 => 0xa5, 333 => 0x11b, 345 => 0x32 },
	'imagecount2' => { 345 => 0x4c },
	'imagecreator' => { 383 => 'ImageCreator' },
	'imagecreatorid' => { 383 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 383 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 383 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 182 => 0xa2 },
	'imagedescription' => { 95 => 0x10e, 389 => 'ImageDescription' },
	'imageduplicationconstraints' => { 383 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 215 => 0xfe443a45 },
	'imageeditcount' => { 283 => 0x41 },
	'imageediting' => { 283 => 0x32 },
	'imageeffects' => { 305 => 0x1010 },
	'imagefileconstraints' => { 383 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 383 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 383 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 100 => 0x1436 },
	'imageheight' => { 95 => 0x101, 154 => 0xc, 389 => 'ImageLength' },
	'imagehistory' => { 95 => 0x9213 },
	'imageidnumber' => { 248 => 0x340 },
	'imagenumber' => { 95 => 0x9211, 125 => 'ImageNumber', 148 => 0xae, 149 => 0x5e, 319 => 0x9b, 321 => [0x400,'276.1',0x314], 367 => 'ImageNumber' },
	'imagenumber2' => { 149 => 0x62 },
	'imageoptimization' => { 182 => 0xa9 },
	'imageorientation' => { 103 => 0x83 },
	'imageprocessing' => { 182 => 0x1a },
	'imageprocessingversion' => { 237 => 0x0 },
	'imagequality' => { 125 => 'ImageQuality', 194 => '723.2', 195 => '732.2', 202 => '708.1', 252 => 0x1 },
	'imagequality2' => { 233 => 0x603 },
	'imageref' => { 378 => 'ImageRef' },
	'imagereview' => { 223 => '0.4', 229 => '0.4' },
	'imagereviewtime' => { 223 => '2.1', 224 => '19.1', 225 => '20.1', 226 => '20.1', 227 => '9.2', 228 => '20.1', 231 => '21.2' },
	'imagesize' => { 131 => 'ImageSize' },
	'imagesizerestriction' => { 386 => 'imageSizeRestriction' },
	'imagesourcedata' => { 95 => 0x935c },
	'imagestabilization' => { 29 => 0x22, 91 => 0x3020, 100 => 0x1422, 125 => 'ImageStabilization', 148 => 0xbd, 149 => 0x71, 150 => 0x57, 151 => 0x0, 152 => [0x18,0x107,0x113], 153 => 0x49c2, 182 => 0xac, 233 => 0x604, 236 => 0x1600, 252 => 0x1a, 324 => 0x12, 325 => 0x11, 331 => 0xb026 },
	'imagestabilization2' => { 323 => 0xa },
	'imagestabilizationsetting' => { 153 => 0x14, 319 => 0x3d, 320 => 0x3d, 330 => 0x14 },
	'imagestyle' => { 319 => 0x2d, 320 => 0x27 },
	'imagesupplier' => { 383 => 'ImageSupplier' },
	'imagesupplierid' => { 383 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 383 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 383 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 97 => 0x1 },
	'imagetemperaturemin' => { 97 => 0x2 },
	'imagetone' => { 283 => 0x4f },
	'imagetype' => { 103 => 0x82, 383 => 'ImageType' },
	'imageuniqueid' => { 51 => 0x28, 95 => 0xa420, 374 => 'ImageUniqueID' },
	'imagewidth' => { 95 => 0x100, 154 => 0xe, 389 => 'ImageWidth' },
	'incrementaltemperature' => { 370 => 'IncrementalTemperature' },
	'incrementaltint' => { 370 => 'IncrementalTint' },
	'industry' => { 384 => 'industry', 385 => 'industry' },
	'infobuttonwhenshooting' => { 68 => 0x409 },
	'infraredilluminator' => { 301 => 0x28 },
	'ingredients' => { 394 => 'Ingredients' },
	'ingredientsalternatepaths' => { 394 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 394 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 394 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 394 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 394 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 394 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 394 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 394 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 394 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 394 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 394 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 394 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 394 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 394 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 394 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 394 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 394 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 360 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 360 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 360 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 360 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 222 => '4.4' },
	'initialzoomsetting' => { 222 => '9.3', 227 => '27.3' },
	'inkset' => { 95 => 0x14c },
	'instanceid' => { 394 => 'InstanceID' },
	'instantplaybacksetup' => { 150 => 0x3e },
	'instantplaybacktime' => { 150 => 0x3d },
	'instructions' => { 382 => 'Instructions' },
	'instrument' => { 393 => 'instrument' },
	'intellectualgenre' => { 379 => 'IntellectualGenre' },
	'intelligentauto' => { 331 => 0xb052 },
	'intelligentcontrast' => { 41 => 0x4 },
	'intelligentd-range' => { 252 => 0x79 },
	'intelligentexposure' => { 252 => 0x5d },
	'intelligentresolution' => { 252 => 0x70 },
	'interchangecolorspace' => { 105 => 0x40 },
	'internalflash' => { 147 => 0x2b, 222 => '23.1', 223 => '8.1', 224 => '22.1', 226 => '23.1', 229 => '8.1', 231 => '24.1', 236 => 0x1208 },
	'internalflashae1' => { 238 => 0x1021 },
	'internalflashae1_0' => { 238 => 0x101d },
	'internalflashae2' => { 238 => 0x1022 },
	'internalflashae2_0' => { 238 => 0x101e },
	'internalflashmode' => { 271 => 0x1 },
	'internalflashstrength' => { 271 => 0x3 },
	'internalflashtable' => { 238 => 0x1024 },
	'internalndfilter' => { 252 => 0x9d },
	'internalserialnumber' => { 51 => 0x96, 61 => 0x9, 100 => 0x10, 153 => 0x49dc, 232 => 0x18, 234 => 0x102, 252 => 0x25, 263 => 0x4, 305 => 0x5, 345 => 0xf0 },
	'interopindex' => { 95 => 0x1, 375 => 'InteroperabilityIndex' },
	'interopversion' => { 95 => 0x2 },
	'intervallength' => { 147 => 0x10 },
	'intervalmode' => { 147 => 0x26 },
	'intervalnumber' => { 147 => 0x11 },
	'introtime' => { 393 => 'introTime' },
	'introtimescale' => { 393 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 393 => [\'introTime','introTimeValue'] },
	'iptc' => { 96 => 'IPTC' },
	'iptc-naa' => { 95 => 0x83bb, 256 => 0x83bb },
	'iptcbitspersample' => { 105 => 0x56 },
	'iptcdigest' => { 294 => 0x425 },
	'iptcimageheight' => { 105 => 0x1e },
	'iptcimagerotation' => { 105 => 0x66 },
	'iptcimagewidth' => { 105 => 0x14 },
	'iptclastedited' => { 380 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 105 => 0xa },
	'iptcpixelheight' => { 105 => 0x32 },
	'iptcpixelwidth' => { 105 => 0x28 },
	'isbn' => { 384 => 'isbn' },
	'iscorrectionof' => { 384 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 87 => 0x3 },
	'iso' => { 5 => 0x6, 7 => 0x6, 8 => 0x75, 9 => 0x6, 10 => 0x79, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x0, 27 => 0x1, 90 => 0x14, 91 => [0x3014,0x14], 95 => 0x8827, 108 => 0xfd06, 109 => 0x1784, 111 => 0x60, 113 => [0xfa2e,0xfa46], 114 => [0x27,0x28], 115 => 0xf105, 118 => 0x14, 120 => 0x4e, 123 => 0x34, 125 => 'ISO', 147 => 0x8, 153 => 0x49ba, 176 => 0x0, 182 => 0x2, 256 => 0x17, 283 => [0x8b,0x14], 289 => 0x14, 311 => 0xa014, 374 => 'ISOSpeedRatings' },
	'iso2' => { 176 => 0x6, 189 => 0x265, 190 => 0x25c, 191 => 0x265, 192 => 0x221, 193 => 0x25d, 194 => 0x256, 195 => 0x25d, 197 => 0x2b5, 200 => 0x265, 204 => 0x2b5 },
	'isoauto' => { 264 => '14.4' },
	'isoautoparameters' => { 283 => 0x7a },
	'isodisplay' => { 224 => '2.3', 225 => '3.3', 226 => '3.3', 228 => '3.3', 231 => '4.3' },
	'isoexpansion' => { 68 => 0x103, 69 => 0x7, 70 => 0x8, 73 => 0x8, 176 => 0x4 },
	'isoexpansion2' => { 176 => 0xa },
	'isofloor' => { 264 => 0x6 },
	'isoselection' => { 182 => 0xf },
	'isosensitivitystep' => { 228 => '6.2' },
	'isosetting' => { 111 => 0x5e, 125 => 'ISOSetting', 147 => 0x24, 148 => 0x26, 149 => 0x1c, 150 => 0x13, 155 => 0x6, 182 => 0x13, 264 => '17.3', 304 => 0x27, 319 => 0x16, 320 => 0x14, 321 => 0x2 },
	'isospeed' => { 95 => 0x8833, 375 => 'ISOSpeed' },
	'isospeedexpansion' => { 67 => 0x3 },
	'isospeedincrements' => { 68 => 0x102 },
	'isospeedlatitudeyyy' => { 95 => 0x8834, 375 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 95 => 0x8835, 375 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 68 => 0x103 },
	'isostepsize' => { 222 => '6.1', 227 => '4.1' },
	'isovalue' => { 238 => 0x1001 },
	'issn' => { 384 => 'issn' },
	'issueidentifier' => { 384 => 'issueIdentifier' },
	'issuename' => { 384 => 'issueName' },
	'istranslationof' => { 384 => 'isTranslationOf' },
	'jobid' => { 103 => 0xb8 },
	'jobname' => { 376 => 'JobName' },
	'jobref' => { 392 => 'JobRef' },
	'jobrefid' => { 392 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 392 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 392 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 376 => 'JobStatus' },
	'jpegquality' => { 8 => 0x66, 254 => 0x3034, 331 => 0xb047 },
	'jpegsize' => { 254 => 0x303a },
	'jpgfromraw' => { 81 => 0x2007, 92 => 'JpgFromRaw', 256 => 0x2e },
	'jpgfromrawlength' => { 95 => [0x117,0x202] },
	'jpgfromrawstart' => { 95 => [0x111,0x201] },
	'jpgrecordedpixels' => { 264 => '14.1' },
	'jurisdiction' => { 368 => 'jurisdiction' },
	'kelvinwb_01' => { 272 => 0x5 },
	'kelvinwb_02' => { 272 => 0x9 },
	'kelvinwb_03' => { 272 => 0xd },
	'kelvinwb_04' => { 272 => 0x11 },
	'kelvinwb_05' => { 272 => 0x15 },
	'kelvinwb_06' => { 272 => 0x19 },
	'kelvinwb_07' => { 272 => 0x1d },
	'kelvinwb_08' => { 272 => 0x21 },
	'kelvinwb_09' => { 272 => 0x25 },
	'kelvinwb_10' => { 272 => 0x29 },
	'kelvinwb_11' => { 272 => 0x2d },
	'kelvinwb_12' => { 272 => 0x31 },
	'kelvinwb_13' => { 272 => 0x35 },
	'kelvinwb_14' => { 272 => 0x39 },
	'kelvinwb_15' => { 272 => 0x3d },
	'kelvinwb_16' => { 272 => 0x41 },
	'kelvinwb_daylight' => { 272 => 0x1 },
	'key' => { 393 => 'key' },
	'keyword' => { 384 => 'keyword' },
	'keywordinfo' => { 140 => 'Keywords' },
	'keywords' => { 103 => 0x19, 126 => 'Keywords', 242 => 'Keywords', 296 => 'Keywords', 365 => 'keywords', 381 => 'Keywords', 391 => 'Keywords' },
	'killdate' => { 384 => 'killDate' },
	'kodakimageheight' => { 108 => 0xf908, 111 => 0xe, 113 => [0xfa1e,0xfa52], 119 => 0x70 },
	'kodakimagewidth' => { 108 => 0xf907, 111 => 0xc, 113 => [0xfa1d,0xfa51], 119 => 0x6c },
	'kodakinfotype' => { 108 => 0xfa00 },
	'kodakmaker' => { 119 => 0x8 },
	'kodakmodel' => { 111 => 0x0, 119 => 0x28 },
	'label' => { 244 => 'Label', 391 => 'Label' },
	'labelname1' => { 378 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 378 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 252 => 0x6f },
	'landscapeoutputhighlightpoint' => { 87 => 0x26 },
	'landscapeoutputshadowpoint' => { 87 => 0x27 },
	'landscaperawcolortone' => { 87 => 0x1f },
	'landscaperawcontrast' => { 87 => 0x21 },
	'landscaperawhighlight' => { 87 => 0x77 },
	'landscaperawhighlightpoint' => { 87 => 0x24 },
	'landscaperawlinear' => { 87 => 0x22 },
	'landscaperawsaturation' => { 87 => 0x20 },
	'landscaperawshadow' => { 87 => 0x80 },
	'landscaperawshadowpoint' => { 87 => 0x25 },
	'landscaperawsharpness' => { 87 => 0x23 },
	'landscapeunsharpmaskfineness' => { 87 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 87 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 87 => 0xa2 },
	'language' => { 371 => 'language' },
	'languageidentifier' => { 103 => 0x87 },
	'largestvalidinteriorrectheight' => { 360 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 360 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 360 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 360 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 147 => 0x1b },
	'lastkeywordiptc' => { 145 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 145 => 'LastKeywordXMP' },
	'lastphotodate' => { 360 => 'LastPhotoDate' },
	'lasturl' => { 394 => 'LastURL' },
	'lateralchromaticaberration' => { 331 => 0x2012 },
	'latestageorhigheststage' => { 94 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 94 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 94 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 94 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 94 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 274 => 0x2 },
	'lc10' => { 274 => 0xb },
	'lc11' => { 274 => 0xc },
	'lc12' => { 274 => 0xd },
	'lc14' => { 274 => 0xf },
	'lc15' => { 274 => 0x10 },
	'lc2' => { 274 => 0x3 },
	'lc3' => { 274 => 0x4 },
	'lc4' => { 274 => 0x5 },
	'lc5' => { 274 => 0x6 },
	'lc6' => { 274 => 0x7 },
	'lc7' => { 274 => 0x8 },
	'lcddisplayatpoweron' => { 68 => 0x811, 72 => 0xa },
	'lcddisplayreturntoshoot' => { 73 => 0x12 },
	'lcdillumination' => { 222 => '17.5', 227 => '10.3', 228 => '4.2', 231 => '5.4' },
	'lcdilluminationduringbulb' => { 68 => 0x408 },
	'lcdpanels' => { 67 => 0x8 },
	'lcheditor' => { 215 => 0x8ae85e },
	'legacyiptcdigest' => { 382 => 'LegacyIPTCDigest' },
	'legalcode' => { 368 => 'legalcode' },
	'lens' => { 95 => 0xfdea, 182 => 0x84, 367 => 'Lens' },
	'lensafstopbutton' => { 66 => 0x11, 67 => 0x13, 68 => 0x506, 69 => 0x10, 70 => 0x12, 73 => 0x13, 74 => 0x9 },
	'lensaperturerange' => { 314 => [0x30,0x48] },
	'lensdistortionparams' => { 238 => 0x206 },
	'lensdrivenoaf' => { 68 => 0x505 },
	'lensfirmware' => { 306 => 0x20, 311 => 0xa004 },
	'lensfirmwareversion' => { 234 => 0x204, 252 => 0x60 },
	'lensfocalrange' => { 314 => [0xa,0x2a] },
	'lensformat' => { 345 => 0x106, 351 => 0x603, 352 => 0x5d },
	'lensfstops' => { 177 => 0x7, 178 => 0xc, 179 => 0xd, 182 => 0x8b, 274 => '0.3' },
	'lensid' => { 367 => 'LensID' },
	'lensidnumber' => { 177 => 0x6, 178 => 0xb, 179 => 0xc },
	'lensinfo' => { 95 => 0xa432, 280 => 0x2a, 367 => 'LensInfo', 375 => 'LensSpecification' },
	'lenskind' => { 274 => 0x1 },
	'lensmake' => { 95 => 0xa433, 132 => 'Make', 375 => 'LensMake' },
	'lensmanualdistortionamount' => { 370 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 145 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 314 => 0x2b },
	'lensmodel' => { 5 => 0x937, 12 => 0x92b, 13 => 0x933, 51 => 0x95, 95 => 0xa434, 132 => 'Model', 145 => 'LensModel', 180 => 0x18a, 234 => 0x203, 250 => 0x303, 280 => 0xc, 375 => 'LensModel' },
	'lensmount' => { 321 => 0x99, 345 => 0x105, 351 => 0x604, 352 => 0x5e, 355 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 370 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 370 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 370 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 370 => 'LensProfileEnable' },
	'lensprofilefilename' => { 370 => 'LensProfileFilename' },
	'lensprofilename' => { 370 => 'LensProfileName' },
	'lensprofilesetup' => { 370 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 370 => 'LensProfileVignettingScale' },
	'lensproperties' => { 234 => 0x20b },
	'lensserialnumber' => { 49 => 0x0, 95 => 0xa435, 132 => 'SerialNumber', 234 => 0x202, 252 => 0x52, 306 => 0x30, 367 => 'LensSerialNumber', 375 => 'LensSerialNumber' },
	'lensshutterlock' => { 150 => 0x4a },
	'lensspec' => { 317 => 0x0, 318 => 0x0, 331 => 0xb02a },
	'lenstemperature' => { 238 => 0x1008 },
	'lenstype' => { 5 => 0xe2, 6 => 0xd, 7 => 0x1a7, 8 => 0xc, 9 => 0x111, 10 => 0xc, 11 => 0x14f, 12 => 0xd6, 13 => 0xde, 14 => 0xf6, 15 => 0xea, 16 => 0xff, 17 => [0xc,0x97], 18 => 0xe6, 19 => 0x153, 20 => 0xea, 21 => 0xe8, 22 => 0x127, 23 => 0x161, 24 => 0x166, 25 => 0x112, 29 => 0x16, 152 => 0x10c, 153 => 0x49bd, 182 => 0x83, 234 => 0x201, 245 => 0x16, 248 => 0x310, 251 => 0x303, 252 => 0x51, 254 => 0x3405, 275 => 0x0, 276 => 0x0, 277 => 0x1, 278 => 0x1, 279 => 0x1, 281 => 0x0, 311 => 0xa003, 314 => 0x27, 331 => 0xb027, 345 => 0x109, 351 => 0x608, 352 => 0x62 },
	'lenstype2' => { 321 => 0x3f7, 345 => 0x107, 351 => 0x605, 352 => 0x60, 355 => 0x9 },
	'levelgaugepitch' => { 233 => 0x904 },
	'levelgaugeroll' => { 233 => 0x903 },
	'levelindicator' => { 257 => 0x15 },
	'levelorientation' => { 282 => 0x0 },
	'license' => { 368 => 'license' },
	'licensee' => { 383 => 'Licensee' },
	'licenseeid' => { 383 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 383 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 383 => 'LicenseeImageNotes' },
	'licenseename' => { 383 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 383 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 383 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 383 => 'LicenseeTransactionID' },
	'licenseid' => { 383 => 'LicenseID' },
	'licensestartdate' => { 383 => 'LicenseStartDate' },
	'licensetransactiondate' => { 383 => 'LicenseTransactionDate' },
	'licensetype' => { 372 => 'licensetype' },
	'licensor' => { 383 => 'Licensor' },
	'licensorcity' => { 383 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 383 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 383 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 383 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 383 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 383 => 'LicensorImageID' },
	'licensorname' => { 383 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 383 => 'LicensorNotes' },
	'licensorpostalcode' => { 383 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 383 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 383 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 383 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 383 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 383 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 383 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 383 => 'LicensorTransactionID' },
	'licensorurl' => { 383 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 238 => 0x1009 },
	'lightingmode' => { 91 => 0x302a },
	'lightreading' => { 283 => 0x15 },
	'lightsource' => { 95 => 0x9208, 182 => 0x90, 241 => 0x1000, 374 => 'LightSource' },
	'lightsourcespecial' => { 313 => 0x21d },
	'lightswitch' => { 231 => '0.1' },
	'lightvaluecenter' => { 238 => 0x103d },
	'lightvalueperiphery' => { 238 => 0x103e },
	'linearitylimitblue' => { 256 => 0x10 },
	'linearitylimitgreen' => { 256 => 0xf },
	'linearitylimitred' => { 256 => 0xe },
	'linearityuppermargin' => { 36 => [0x2ba,0x2d1,0x2d5], 38 => 0x1e5, 39 => 0x1fe },
	'linearizationtable' => { 95 => 0xc618 },
	'linearresponselimit' => { 95 => 0xc62e },
	'linkaetoafpoint' => { 264 => '14.2' },
	'lithostratigraphicterms' => { 94 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 224 => '32.1', 231 => '34.1' },
	'liveviewafareamode' => { 228 => '34.1' },
	'liveviewafmethod' => { 335 => 0x20 },
	'liveviewafmode' => { 228 => '34.2' },
	'liveviewafsetting' => { 321 => 0x36 },
	'liveviewexposuresimulation' => { 68 => 0x810 },
	'liveviewfocusmode' => { 321 => [0x8b,0x28b] },
	'liveviewmetering' => { 321 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 225 => '20.2', 226 => '20.2', 228 => '20.2' },
	'liveviewshooting' => { 46 => 0x13 },
	'localcaption' => { 103 => 0x79 },
	'localizedcameramodel' => { 95 => 0xc615 },
	'locallocationname' => { 311 => 0x30 },
	'location' => { 181 => 0x9, 252 => 0x67, 363 => 'Location', 379 => 'Location', 384 => 'location' },
	'locationareacode' => { 369 => 'lac' },
	'locationcreated' => { 380 => 'LocationCreated' },
	'locationcreatedcity' => { 380 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 380 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 380 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 380 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 380 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 380 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 181 => 0x0 },
	'locationname' => { 311 => 0x31 },
	'locationshown' => { 380 => 'LocationShown' },
	'locationshowncity' => { 380 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 380 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 380 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 380 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 380 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 380 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 68 => 0x709 },
	'logcomment' => { 393 => 'logComment' },
	'longexposurenoisereduction' => { 68 => 0x201, 69 => 0x1, 70 => 0x2, 71 => 0x1, 72 => 0x1, 73 => 0x2, 74 => 0x1, 252 => 0x49, 319 => 0x2b, 320 => 0x25, 321 => 0x25, 331 => 0x2008, 335 => 0x11, 352 => 0x44 },
	'longexposurenoisereduction2' => { 46 => 0x8 },
	'loop' => { 393 => 'loop' },
	'lowestbiostratigraphiczone' => { 94 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 370 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 370 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 370 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 370 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 370 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 370 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 370 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 370 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 86 => 0x150 },
	'luminancecurvepoints' => { 86 => 0x126 },
	'luminancenoisereduction' => { 87 => 0x5f, 314 => 0x1b },
	'luminancenoisereductioncontrast' => { 370 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 370 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 87 => 0x6d },
	'luminancesmoothing' => { 370 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 68 => 0x40b },
	'lyrics' => { 393 => 'lyrics' },
	'm16cversion' => { 248 => 0x333 },
	'macro' => { 100 => 0x1020, 101 => 0x202, 238 => 0x202, 304 => 0x21, 313 => 0x202, 331 => 0xb040 },
	'macroled' => { 236 => 0x120a },
	'macromagnification' => { 5 => 0x1b, 9 => 0x1b, 12 => 0x1b, 13 => 0x1b, 17 => 0x1b, 18 => 0x1b, 46 => 0x10 },
	'macromode' => { 29 => 0x1, 147 => 0xb, 233 => 0x300, 252 => 0x1c, 305 => 0x1009 },
	'magicfilter' => { 233 => 0x52c },
	'magnifiedview' => { 70 => 0x11, 72 => 0x9 },
	'maindialexposurecomp' => { 229 => '0.6' },
	'make' => { 82 => 0x0, 95 => 0x10f, 125 => 'Make', 244 => 'Make', 256 => 0x10f, 389 => 'Make' },
	'makernote' => { 374 => 'MakerNote' },
	'makernoteapple' => { 93 => 'MakN', 95 => 0x927c },
	'makernotecanon' => { 93 => 'MakN', 95 => 0x927c },
	'makernotecasio' => { 93 => 'MakN', 95 => 0x927c },
	'makernotecasio2' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteflir' => { 93 => 'MakN', 95 => 0x927c },
	'makernotefujifilm' => { 93 => 'MakN', 95 => 0x927c },
	'makernotege' => { 93 => 'MakN', 95 => 0x927c },
	'makernotege2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehasselblad' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp6' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteisl' => { 93 => 'MakN', 95 => 0x927c },
	'makernotejvc' => { 93 => 'MakN', 95 => 0x927c },
	'makernotejvctext' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak10' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak1a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak1b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak5' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak6a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak6b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak7' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak8a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak8b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak8c' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak9' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodakunknown' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekyocera' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica2' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica3' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica4' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica5' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica6' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteminolta' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteminolta2' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteminolta3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenikon' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenikon2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenikon3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenintendo' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteoffset' => { 313 => 0xff },
	'makernoteolympus' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteolympus2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepanasonic' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepanasonic2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax5' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax6' => { 93 => 'MakN', 95 => 0x927c },
	'makernotephaseone' => { 93 => 'MakN', 95 => 0x927c },
	'makernotereconyx' => { 93 => 'MakN', 95 => 0x927c },
	'makernotericoh' => { 93 => 'MakN', 95 => 0x927c },
	'makernotericohtext' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesafety' => { 95 => 0xc635 },
	'makernotesamsung1a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesamsung1b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesamsung2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesanyo' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesanyoc4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesanyopatch' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesigma' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony5' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesonyericsson' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesonysrf' => { 93 => 'MakN', 95 => 0x927c },
	'makernotetype' => { 305 => 0x1 },
	'makernoteunknown' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteunknownbinary' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteunknowntext' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteversion' => { 152 => 0x0, 182 => 0x1, 238 => 0x0, 252 => 0x8000, 309 => 0x0, 311 => 0x1, 314 => [0x1d,0x1f], 322 => 0x2000 },
	'managedfrom' => { 394 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 394 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 394 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 394 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 394 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 394 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 394 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 394 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 394 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 394 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 394 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 394 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 394 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 394 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 394 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 394 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 394 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 394 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 394 => 'Manager' },
	'managervariant' => { 394 => 'ManagerVariant' },
	'manageto' => { 394 => 'ManageTo' },
	'manageui' => { 394 => 'ManageUI' },
	'manifest' => { 394 => 'Manifest' },
	'manifestlinkform' => { 394 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 394 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 394 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 394 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 394 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 394 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 394 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 394 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 394 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 394 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 394 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 394 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 394 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 394 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 394 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 394 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 394 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 394 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 394 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 394 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 394 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 394 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 233 => 0x900, 252 => 0x86 },
	'manometerreading' => { 233 => 0x901 },
	'manualafpointselectpattern' => { 68 => 0x513 },
	'manualflash' => { 236 => 0x1209 },
	'manualflashoutput' => { 29 => 0x29, 223 => '8.2', 224 => '22.2', 225 => '23.1', 226 => '23.2', 227 => '16.2', 228 => '23.2', 229 => '8.2', 230 => '23.2', 231 => '24.2', 305 => 0x100c },
	'manualflashstrength' => { 233 => 0x406 },
	'manualfocusdistance' => { 182 => 0x85, 238 => 0x100c, 313 => 0x223 },
	'manualtv' => { 67 => 0x5, 68 => 0x705 },
	'manufacturedate' => { 263 => 0x1 },
	'manufacturedate1' => { 307 => 0x4 },
	'manufacturedate2' => { 307 => 0x5 },
	'marked' => { 381 => 'Marked', 397 => 'Marked' },
	'markers' => { 393 => 'markers' },
	'markerscomment' => { 393 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 393 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 393 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 393 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 393 => [\'markers','markersCuePointType'] },
	'markersduration' => { 393 => [\'markers','markersDuration'] },
	'markerslocation' => { 393 => [\'markers','markersLocation'] },
	'markersname' => { 393 => [\'markers','markersName'] },
	'markersprobability' => { 393 => [\'markers','markersProbability'] },
	'markersspeaker' => { 393 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 393 => [\'markers','markersStartTime'] },
	'markerstarget' => { 393 => [\'markers','markersTarget'] },
	'markerstype' => { 393 => [\'markers','markersType'] },
	'maskedareas' => { 95 => 0xc68e },
	'masterdocumentid' => { 103 => 0xb9 },
	'mastergain' => { 187 => 0x50 },
	'maxaperture' => { 29 => 0x1a, 115 => 0x6103, 132 => 'MaxAperture', 147 => 0x17, 153 => 0x49c5, 234 => 0x20a, 274 => '14.1', 345 => 0x0 },
	'maxapertureatmaxfocal' => { 100 => 0x1407, 132 => 'MaxApertureAtMaxFocal', 177 => 0xb, 178 => 0x10, 179 => 0x11, 234 => 0x206 },
	'maxapertureatminfocal' => { 100 => 0x1406, 177 => 0xa, 178 => 0xf, 179 => 0x10, 234 => 0x205 },
	'maxaperturevalue' => { 95 => 0x9205, 374 => 'MaxApertureValue' },
	'maxavailheight' => { 380 => 'MaxAvailHeight' },
	'maxavailwidth' => { 380 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 222 => 0xb, 227 => 0xc, 228 => 0xb },
	'maxfaces' => { 237 => 0x1202 },
	'maxfocallength' => { 5 => 0xe6, 6 => 0x10, 7 => 0x1ab, 8 => 0x13, 9 => 0x115, 10 => 0x13, 11 => 0x153, 12 => 0xda, 14 => 0xfa, 15 => 0xee, 16 => 0x103, 17 => 0x95, 18 => 0xea, 19 => 0x157, 20 => 0xee, 21 => 0xec, 22 => 0x12b, 23 => 0x165, 24 => 0x16a, 25 => 0x116, 29 => 0x17, 100 => 0x1405, 132 => 'MaxFocalLength', 177 => 0x9, 178 => 0xe, 179 => 0xf, 234 => 0x208, 342 => 0x127c, 343 => 0x1138, 344 => 0x330 },
	'maximumdensityrange' => { 105 => 0x8c },
	'maxpagesize' => { 398 => 'MaxPageSize' },
	'maxpagesizeh' => { 398 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 398 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 398 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 95 => 0x119 },
	'maxstorage' => { 388 => 'maxstorage' },
	'mb-d10batteries' => { 222 => '12.6' },
	'mb-d10batterytype' => { 227 => '13.3' },
	'mb-d11batterytype' => { 228 => '2.3' },
	'mb-d80batteries' => { 229 => '6.5' },
	'mb-d80batterytype' => { 231 => '3.2' },
	'mcuversion' => { 177 => 0xc, 178 => 0x11, 179 => 0x12 },
	'md5digest' => { 133 => 'zmd5' },
	'measuredev' => { 25 => 0x9, 62 => 0x3, 81 => 0x1814, 125 => 'MeasuredEV' },
	'measuredev2' => { 11 => 0x8, 25 => 0x8, 62 => 0x17 },
	'measuredev3' => { 11 => 0x9 },
	'measuredlv' => { 153 => 0x690, 248 => 0x312, 254 => 0x3407 },
	'measuredrggb' => { 52 => 0x1 },
	'measuredrggbdata' => { 35 => 0x287 },
	'measurementaccuracy' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 94 => 'MeasurementOrFact' },
	'measurementremarks' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 383 => 'MediaConstraints' },
	'mediacreatedate' => { 297 => 0x1 },
	'mediamodifydate' => { 297 => 0x2 },
	'mediasummarycode' => { 383 => 'MediaSummaryCode' },
	'memorycardconfiguration' => { 325 => 0x16 },
	'menubuttondisplayposition' => { 66 => 0xb, 69 => 0xa, 70 => 0xb, 73 => 0xb },
	'menubuttonreturn' => { 74 => 0xb },
	'menumonitorofftime' => { 227 => '8.2', 228 => '21.1', 231 => '22.1' },
	'metadatadate' => { 391 => 'MetadataDate' },
	'metadatamoddate' => { 393 => 'metadataModDate' },
	'metaversion' => { 337 => 0x34 },
	'meterinfo1row1' => { 332 => 0x0 },
	'meterinfo1row2' => { 332 => 0x6c },
	'meterinfo1row3' => { 332 => 0xd8 },
	'meterinfo1row4' => { 332 => 0x144 },
	'meterinfo1row5' => { 332 => 0x1b0 },
	'meterinfo1row6' => { 332 => 0x21c },
	'meterinfo1row7' => { 332 => 0x288 },
	'meterinfo2row1' => { 332 => 0x2f4 },
	'meterinfo2row2' => { 332 => 0x378 },
	'meterinfo2row3' => { 332 => 0x3fc },
	'meterinfo2row4' => { 332 => 0x480 },
	'meterinfo2row5' => { 332 => 0x504 },
	'meterinfo2row6' => { 332 => 0x588 },
	'meterinfo2row7' => { 332 => 0x60c },
	'meterinfo2row8' => { 332 => 0x690 },
	'meterinfo2row9' => { 332 => 0x714 },
	'metering' => { 223 => '6.1' },
	'meteringmode' => { 29 => 0x11, 95 => 0x9207, 111 => 0x1c, 147 => 0x7, 148 => 0x25, 150 => 0x12, 233 => 0x202, 283 => 0x17, 314 => 0x9, 319 => 0x15, 320 => 0x13, 321 => 0x7, 335 => 0x3, 338 => 0x1174, 339 => 0x1178, 340 => 0x1154, 341 => 0x11d0, 342 => 0x11ac, 343 => 0x1064, 344 => 0x25c, 374 => 'MeteringMode' },
	'meteringmode2' => { 264 => '2.1' },
	'meteringmode3' => { 264 => '16.1' },
	'meteringoffscaleindicator' => { 150 => 0x53 },
	'meteringtime' => { 222 => '22.2', 223 => '3.2', 224 => '17.1', 225 => '18.1', 227 => '7.3', 228 => '18.1', 229 => '3.2', 231 => '19.1' },
	'mieversion' => { 133 => '0Vers' },
	'minaperture' => { 29 => 0x1b, 132 => 'MinAperture', 274 => '0.2', 345 => 0x1 },
	'minfocallength' => { 5 => 0xe4, 6 => 0xe, 7 => 0x1a9, 8 => 0x11, 9 => 0x113, 10 => 0x11, 11 => 0x151, 12 => 0xd8, 14 => 0xf8, 15 => 0xec, 16 => 0x101, 17 => 0x93, 18 => 0xe8, 19 => 0x155, 20 => 0xec, 21 => 0xea, 22 => 0x129, 23 => 0x163, 24 => 0x168, 25 => 0x114, 29 => 0x18, 100 => 0x1404, 132 => 'MinFocalLength', 177 => 0x8, 178 => 0xd, 179 => 0xe, 234 => 0x207, 342 => 0x127a, 343 => 0x1136, 344 => 0x32e },
	'minoltadate' => { 147 => 0x15 },
	'minoltaimagesize' => { 147 => 0x4, 148 => 0xc, 149 => 0x2, 152 => 0x103 },
	'minoltamodelid' => { 147 => 0x25 },
	'minoltaquality' => { 147 => 0x5, 148 => 0xd, 149 => 0x3, 152 => [0x102,0x103] },
	'minoltatime' => { 147 => 0x16 },
	'minormodelagedisclosure' => { 383 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 95 => 0x118 },
	'mirrorlockup' => { 66 => 0xc, 67 => 0xc, 68 => 0x60f, 69 => 0xb, 70 => 0xc, 71 => 0x6, 72 => 0x6, 73 => 0xc, 74 => 0x3 },
	'mobilecountrycode' => { 369 => 'mcc' },
	'mobilenetworkcode' => { 369 => 'mnc' },
	'moddate' => { 244 => 'modify-date', 381 => 'ModDate' },
	'modedialposition' => { 325 => 0x14 },
	'model' => { 82 => 0x6, 95 => 0x110, 125 => 'Model', 244 => 'Model', 256 => 0x110, 389 => 'Model' },
	'modelage' => { 380 => 'ModelAge' },
	'modelid' => { 232 => 0x0 },
	'modelingflash' => { 222 => '21.4', 227 => '26.4', 228 => '30.2', 229 => '7.4', 230 => '30.1', 231 => '31.3' },
	'modelreleaseid' => { 383 => 'ModelReleaseID' },
	'modelreleasestatus' => { 383 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 346 => 0x52, 347 => 0x46 },
	'modificationdate' => { 384 => 'modificationDate' },
	'modifiedcolortemp' => { 53 => 0x9 },
	'modifieddigitalgain' => { 53 => 0xb },
	'modifiedparamflag' => { 47 => 0x1 },
	'modifiedpicturestyle' => { 53 => 0xa },
	'modifiedsaturation' => { 233 => 0x504 },
	'modifiedsensorbluelevel' => { 53 => 0x5 },
	'modifiedsensorredlevel' => { 53 => 0x4 },
	'modifiedsharpness' => { 53 => 0x2 },
	'modifiedsharpnessfreq' => { 53 => 0x3 },
	'modifiedtonecurve' => { 53 => 0x1 },
	'modifiedwhitebalance' => { 53 => 0x8 },
	'modifiedwhitebalanceblue' => { 53 => 0x7 },
	'modifiedwhitebalancered' => { 53 => 0x6 },
	'modifydate' => { 95 => 0x132, 126 => 'ModifyDate', 242 => 'ModDate', 243 => 'tIME', 296 => 'ModDate', 298 => 0x2, 391 => 'ModifyDate' },
	'moirefilter' => { 95 => 0xfe58, 370 => 'MoireFilter' },
	'monitordisplayoff' => { 150 => 0x4c },
	'monitorofftime' => { 222 => '18.2', 223 => '3.1', 229 => '3.1' },
	'monochromecontrast' => { 87 => 0x3c },
	'monochromefiltereffect' => { 87 => 0x3a, 283 => 0x73 },
	'monochromelinear' => { 87 => 0x3d },
	'monochromeoutputhighlightpoint' => { 87 => 0x41 },
	'monochromeoutputshadowpoint' => { 87 => 0x42 },
	'monochromerawhighlight' => { 87 => 0x7a },
	'monochromerawhighlightpoint' => { 87 => 0x3f },
	'monochromerawshadow' => { 87 => 0x83 },
	'monochromerawshadowpoint' => { 87 => 0x40 },
	'monochromesharpness' => { 87 => 0x3e },
	'monochrometoning' => { 283 => 0x74 },
	'monochrometoningeffect' => { 87 => 0x3b },
	'monochromeunsharpmaskfineness' => { 87 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 87 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 87 => 0xb4 },
	'monthdaycreated' => { 111 => 0x12, 120 => 0xe },
	'moonphase' => { 301 => 0x12 },
	'morepermissions' => { 368 => 'morePermissions' },
	'motionsensitivity' => { 301 => 0x29 },
	'multiburstimageheight' => { 331 => 0x1002 },
	'multiburstimagewidth' => { 331 => 0x1001 },
	'multiburstmode' => { 331 => 0x1000 },
	'multicontrollerwhilemetering' => { 68 => 0x517 },
	'multiexposureautogain' => { 183 => 0x3 },
	'multiexposuremode' => { 183 => 0x1 },
	'multiexposureshots' => { 183 => 0x2 },
	'multiframenoisereduction' => { 321 => 0x35, 331 => 0x200b, 335 => 0x15 },
	'multifunctionlock' => { 68 => 0x70f },
	'multipleexposuremode' => { 237 => 0x101c },
	'multipleexposureset' => { 264 => '10.1' },
	'multisample' => { 187 => 0x40 },
	'multiselector' => { 222 => '9.4', 227 => '27.4' },
	'multiselectorliveview' => { 222 => '4.3' },
	'multiselectorplaybackmode' => { 222 => ['13.5','9.2'], 227 => '27.2' },
	'multiselectorshootmode' => { 222 => '9.1', 227 => '27.1' },
	'mycolormode' => { 55 => 0x2 },
	'nativedigest' => { 374 => 'NativeDigest', 389 => 'NativeDigest' },
	'ncdfileinfo' => { 109 => 0x414 },
	'ndfilter' => { 62 => 0x1c, 233 => 0x204, 305 => 0x1019 },
	'nefbitdepth' => { 182 => 0xe22 },
	'nefcompression' => { 182 => 0x93 },
	'neflinearizationtable' => { 182 => 0x96 },
	'neutraldensityfilter' => { 283 => 0x88 },
	'neutraloutputhighlightpoint' => { 87 => 0x2f },
	'neutraloutputshadowpoint' => { 87 => 0x30 },
	'neutralrawcolortone' => { 87 => 0x28 },
	'neutralrawcontrast' => { 87 => 0x2a },
	'neutralrawhighlight' => { 87 => 0x78 },
	'neutralrawhighlightpoint' => { 87 => 0x2d },
	'neutralrawlinear' => { 87 => 0x2b },
	'neutralrawsaturation' => { 87 => 0x29 },
	'neutralrawshadow' => { 87 => 0x81 },
	'neutralrawshadowpoint' => { 87 => 0x2e },
	'neutralrawsharpness' => { 87 => 0x2c },
	'neutralunsharpmaskfineness' => { 87 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 87 => 0xa8 },
	'neutraunsharpmaskstrength' => { 87 => 0xa4 },
	'newrawimagedigest' => { 95 => 0xc7a7 },
	'newsphotoversion' => { 105 => 0x0 },
	'nickname' => { 391 => 'Nickname' },
	'nikoncapturedata' => { 182 => 0xe01 },
	'nikoncaptureeditversions' => { 182 => 0xe13 },
	'nikoncaptureoutput' => { 182 => 0xe1e },
	'nikoncaptureversion' => { 182 => 0xe09 },
	'nikoniccprofile' => { 182 => 0xe1d },
	'nikonimagesize' => { 194 => '723.1', 195 => '732.1', 202 => 0x2c4 },
	'noisefilter' => { 233 => 0x527 },
	'noiseprofile' => { 95 => 0xc761 },
	'noisereduction' => { 100 => 0x100b, 148 => 0xb0, 149 => 0x60, 150 => 0x3f, 182 => 0x95, 215 => 0x753dcbc0, 216 => 0x17, 233 => 0x50a, 238 => 0x103a, 252 => 0x2d, 283 => 0x49, 305 => 0x100f, 307 => 0x2a },
	'noisereduction2' => { 237 => 0x1010 },
	'noisereductionapplied' => { 95 => 0xc6f7 },
	'noisereductionintensity' => { 216 => 0x9 },
	'noisereductionmethod' => { 216 => 0x11 },
	'noisereductionmode' => { 356 => 0x801e },
	'noisereductionsharpness' => { 216 => 0xd },
	'noisereductionvalue' => { 356 => 0x8027 },
	'nomemorycard' => { 222 => '22.1', 223 => '0.3', 224 => '2.4', 225 => '3.2', 226 => '3.2', 227 => '33.7', 228 => '3.2', 229 => '0.3', 231 => '4.5' },
	'nominalmaxaperture' => { 274 => 0xa },
	'nominalminaperture' => { 274 => '10.1' },
	'normalwhitelevel' => { 36 => [0x2b8,0x2cf,0x2d3], 38 => 0x1e3, 39 => 0x1fc },
	'notes' => { 357 => 'Notes', 365 => 'notes' },
	'npages' => { 398 => 'NPages' },
	'nrwdata' => { 182 => 0x14 },
	'nullrecord' => { 81 => 0x0 },
	'number' => { 384 => 'number' },
	'numberofbeats' => { 393 => 'numberOfBeats' },
	'numberoffocuspoints' => { 226 => '0.2', 228 => '0.3' },
	'numfacepositions' => { 246 => 0x0 },
	'numindexentries' => { 105 => 0x54 },
	'object' => { 384 => 'object' },
	'objectattributereference' => { 103 => 0x4 },
	'objectcycle' => { 103 => 0x4b },
	'objectdistance' => { 90 => 0x6, 91 => 0x2022 },
	'objectname' => { 103 => 0x5 },
	'objectpreviewdata' => { 103 => 0xca },
	'objectpreviewfileformat' => { 103 => 0xc8 },
	'objectpreviewfileversion' => { 103 => 0xc9 },
	'objecttypereference' => { 103 => 0x3 },
	'occurrence' => { 94 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 94 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 94 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 94 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 94 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 94 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 94 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 94 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 94 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 94 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 94 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 94 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 94 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 94 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 94 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 94 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 94 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 94 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 94 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 94 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 94 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 94 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 94 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 94 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 374 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 374 => [\'OECF','OECFNames'] },
	'oecfrows' => { 374 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 374 => [\'OECF','OECFValues'] },
	'offsetschema' => { 95 => 0xea1d },
	'okbutton' => { 228 => '15.1', 231 => '16.1' },
	'oldsubfiletype' => { 95 => 0xff },
	'olympusimageheight' => { 238 => 0x102f },
	'olympusimagewidth' => { 238 => 0x102e },
	'onetouchwb' => { 238 => 0x302 },
	'opticalzoom' => { 113 => 0xfa3d, 115 => [0x6006,0xf006], 116 => 0x1000, 117 => 0xf, 120 => 0x1e, 132 => 'OpticalZoom' },
	'opticalzoomcode' => { 62 => 0xa },
	'opticalzoommode' => { 252 => 0x34 },
	'opticalzoomon' => { 313 => 0x219 },
	'optionenddate' => { 386 => 'optionEndDate' },
	'opto-electricconvfactor' => { 374 => 'OECF' },
	'ordernumber' => { 100 => 0x8002 },
	'organisationinimagecode' => { 380 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 380 => 'OrganisationInImageName' },
	'organization' => { 384 => 'organization' },
	'orientation' => { 95 => 0x112, 256 => 0x112, 389 => 'Orientation' },
	'orientation2' => { 335 => 0x2e },
	'orientationlinkedafpoint' => { 68 => 0x516 },
	'originalbestqualitysize' => { 95 => 0xc792 },
	'originaldecisiondata' => { 92 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 51 => 0x83 },
	'originaldefaultcropsize' => { 95 => 0xc793 },
	'originaldefaultfinalsize' => { 95 => 0xc791 },
	'originaldirectory' => { 250 => 0x408 },
	'originaldocumentid' => { 394 => 'OriginalDocumentID' },
	'originalfilename' => { 81 => 0x816, 109 => 0x3e9, 121 => 0x20, 250 => 0x407, 361 => 'OriginalFilename' },
	'originalimageheight' => { 64 => 0xc, 99 => 0x1 },
	'originalimagewidth' => { 64 => 0xb, 99 => 0x0 },
	'originalrawfiledata' => { 95 => 0xc68c },
	'originalrawfiledigest' => { 95 => 0xc71d },
	'originalrawfilename' => { 95 => 0xc68b },
	'originaltransmissionreference' => { 103 => 0x67 },
	'originatingprogram' => { 103 => 0x41 },
	'originplatform' => { 384 => 'originPlatform' },
	'os' => { 372 => 'os' },
	'otherconditions' => { 383 => 'OtherConditions' },
	'otherconstraints' => { 383 => 'OtherConstraints' },
	'otherimage' => { 92 => 'OtherImage' },
	'otherimageinfo' => { 383 => 'OtherImageInfo' },
	'otherimagelength' => { 95 => 0x202 },
	'otherimagestart' => { 95 => 0x201 },
	'otherlicensedocuments' => { 383 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 383 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 383 => 'OtherLicenseRequirements' },
	'outcue' => { 393 => 'outCue' },
	'outcuescale' => { 393 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 393 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 161 => 0x3 },
	'outputimagewidth' => { 161 => 0x2 },
	'outputresolution' => { 161 => 0x4 },
	'owner' => { 397 => 'Owner' },
	'ownerid' => { 103 => 0xbc },
	'ownername' => { 13 => 0x10f, 51 => 0x9, 81 => 0x810, 95 => [0xa430,0xfde8], 125 => 'OwnerName', 367 => 'OwnerName', 375 => 'CameraOwnerName' },
	'padding' => { 95 => 0xea1c },
	'pageimage' => { 391 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 391 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 391 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 391 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 391 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 391 => 'PageInfo' },
	'pagename' => { 95 => 0x11d },
	'pagenumber' => { 95 => 0x129 },
	'pagerange' => { 384 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 370 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 370 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 252 => 0x26 },
	'panasonicimageheight' => { 252 => 0x4c },
	'panasonicimagewidth' => { 252 => 0x4b },
	'panasonicrawversion' => { 256 => 0x1 },
	'panasonictitle' => { 95 => 0xc6d2 },
	'panasonictitle2' => { 95 => 0xc6d3 },
	'panoramacropbottom' => { 336 => 0x7 },
	'panoramacropleft' => { 336 => 0x4 },
	'panoramacropright' => { 336 => 0x6 },
	'panoramacroptop' => { 336 => 0x5 },
	'panoramadirection' => { 58 => 0x5, 336 => 0x3 },
	'panoramaframeheight' => { 336 => 0x9 },
	'panoramaframenumber' => { 58 => 0x2 },
	'panoramaframewidth' => { 336 => 0x8 },
	'panoramafullheight' => { 336 => 0x2 },
	'panoramafullwidth' => { 336 => 0x1 },
	'panoramamode' => { 111 => 0x3c, 233 => 0x601 },
	'panoramasize3d' => { 321 => 0x38 },
	'panoramasourceheight' => { 336 => 0xb },
	'panoramasourcewidth' => { 336 => 0xa },
	'panoramicstitchcameramotion' => { 143 => 'PanoramicStitchCameraMotion', 144 => 0x1 },
	'panoramicstitchmaptype' => { 143 => 'PanoramicStitchMapType', 144 => 0x2 },
	'panoramicstitchphi0' => { 143 => 'PanoramicStitchPhi0', 144 => 0x5 },
	'panoramicstitchphi1' => { 143 => 'PanoramicStitchPhi1', 144 => 0x6 },
	'panoramicstitchtheta0' => { 143 => 'PanoramicStitchTheta0', 144 => 0x3 },
	'panoramicstitchtheta1' => { 143 => 'PanoramicStitchTheta1', 144 => 0x4 },
	'panoramicstitchversion' => { 144 => 0x0 },
	'pantry' => { 394 => 'Pantry' },
	'parallax' => { 100 => 0xb211, 232 => 0x28 },
	'parametricdarks' => { 370 => 'ParametricDarks' },
	'parametrichighlights' => { 370 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 370 => 'ParametricHighlightSplit' },
	'parametriclights' => { 370 => 'ParametricLights' },
	'parametricmidtonesplit' => { 370 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 370 => 'ParametricShadows' },
	'parametricshadowsplit' => { 370 => 'ParametricShadowSplit' },
	'parentmeid' => { 361 => 'ParentMEID' },
	'parentreference1' => { 378 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 378 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 393 => 'partOfCompilation' },
	'patientbirthdate' => { 358 => 'PatientDOB' },
	'patientid' => { 358 => 'PatientID' },
	'patientname' => { 358 => 'PatientName' },
	'patientsex' => { 358 => 'PatientSex' },
	'pdfversion' => { 381 => 'PDFVersion' },
	'pentaximagesize' => { 283 => 0x9 },
	'pentaxmodelid' => { 263 => 0x0, 283 => 0x5 },
	'pentaxmodeltype' => { 283 => 0x1 },
	'pentaxversion' => { 283 => 0x0 },
	'people' => { 359 => 'People', 363 => 'People' },
	'perchannelblacklevel' => { 35 => 0xc4, 36 => [0x2b4,0x2cb,0x2cf], 38 => 0x1df, 39 => 0x1f8 },
	'peripheralillumcentralradius' => { 356 => 0x8030 },
	'peripheralillumcentralvalue' => { 356 => 0x8031 },
	'peripheralillumination' => { 87 => 0x68 },
	'peripheralilluminationon' => { 87 => 0x64 },
	'peripheralillumperiphvalue' => { 356 => 0x8032 },
	'peripherallighting' => { 64 => 0x2 },
	'peripherallightingsetting' => { 65 => 0x5 },
	'peripherallightingvalue' => { 64 => 0x6 },
	'permissions' => { 386 => 'permissions' },
	'permits' => { 368 => 'permits' },
	'person' => { 384 => 'person' },
	'personality' => { 361 => 'Personality' },
	'personinimage' => { 380 => 'PersonInImage' },
	'perspectiveaspect' => { 370 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 370 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 370 => 'PerspectiveRotate' },
	'perspectivescale' => { 370 => 'PerspectiveScale' },
	'perspectiveupright' => { 370 => 'PerspectiveUpright' },
	'perspectivevertical' => { 370 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 76 => 0x1 },
	'pf10retainprogramshift' => { 76 => 0xb },
	'pf13drivepriority' => { 76 => 0xe },
	'pf14disablefocussearch' => { 76 => 0xf },
	'pf15disableafassistbeam' => { 76 => 0x10 },
	'pf16autofocuspointshoot' => { 76 => 0x11 },
	'pf17disableafpointsel' => { 76 => 0x12 },
	'pf18enableautoafpointsel' => { 76 => 0x13 },
	'pf19continuousshootspeed' => { 76 => 0x14 },
	'pf19shootingspeedhigh' => { 75 => 0xa },
	'pf19shootingspeedlow' => { 75 => 0x9 },
	'pf1disableshootingmodes' => { 76 => 0x2 },
	'pf1value' => { 75 => 0x1 },
	'pf20limitcontinousshots' => { 76 => 0x15 },
	'pf20maxcontinousshots' => { 75 => 0xb },
	'pf21enablequietoperation' => { 76 => 0x16 },
	'pf23felocktime' => { 75 => 0xd },
	'pf23postreleasetime' => { 75 => 0xe },
	'pf23settimerlengths' => { 76 => 0x18 },
	'pf23shutterbuttontime' => { 75 => 0xc },
	'pf24lightlcdduringbulb' => { 76 => 0x19 },
	'pf25aemode' => { 75 => 0xf },
	'pf25afmode' => { 75 => 0x12 },
	'pf25afpointsel' => { 75 => 0x13 },
	'pf25colormatrix' => { 75 => 0x17 },
	'pf25defaultclearsettings' => { 76 => 0x1a },
	'pf25drivemode' => { 75 => 0x11 },
	'pf25imagesize' => { 75 => 0x14 },
	'pf25meteringmode' => { 75 => 0x10 },
	'pf25parameters' => { 75 => 0x16 },
	'pf25wbmode' => { 75 => 0x15 },
	'pf26shortenreleaselag' => { 76 => 0x1b },
	'pf27reversedialrotation' => { 76 => 0x1c },
	'pf27value' => { 75 => 0x18 },
	'pf28noquickdialexpcomp' => { 76 => 0x1d },
	'pf29quickdialswitchoff' => { 76 => 0x1e },
	'pf2disablemeteringmodes' => { 76 => 0x3 },
	'pf2value' => { 75 => 0x2 },
	'pf30enlargementmode' => { 76 => 0x1f },
	'pf31originaldecisiondata' => { 76 => 0x20 },
	'pf3manualexposuremetering' => { 76 => 0x4 },
	'pf3value' => { 75 => 0x3 },
	'pf4exposuretimelimits' => { 76 => 0x5 },
	'pf4exposuretimemax' => { 75 => 0x5 },
	'pf4exposuretimemin' => { 75 => 0x4 },
	'pf5aperturelimits' => { 76 => 0x6 },
	'pf5aperturemax' => { 75 => 0x7 },
	'pf5aperturemin' => { 75 => 0x6 },
	'pf6presetshootingmodes' => { 76 => 0x7 },
	'pf7bracketcontinuousshoot' => { 76 => 0x8 },
	'pf8bracketshots' => { 75 => 0x8 },
	'pf8setbracketshots' => { 76 => 0x9 },
	'pf9changebracketsequence' => { 76 => 0xa },
	'phasedetectaf' => { 158 => 0x6 },
	'phonenumber' => { 126 => 'Phone' },
	'photoeffect' => { 29 => 0x28 },
	'photoeffecthistoryxml' => { 215 => 0xe9651831 },
	'photoeffects' => { 215 => 0xab5eca5e },
	'photoeffectsblue' => { 217 => 0x8 },
	'photoeffectsgreen' => { 217 => 0x6 },
	'photoeffectsred' => { 217 => 0x4 },
	'photoeffectstype' => { 217 => 0x0 },
	'photographicsensitivity' => { 375 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 222 => '17.6', 227 => '33.6' },
	'photometricinterpretation' => { 95 => 0x106, 389 => 'PhotometricInterpretation' },
	'photoshopquality' => { 293 => 0x0 },
	'photostyle' => { 252 => 0x89 },
	'picklabel' => { 373 => 'PickLabel' },
	'pictinfo' => { 313 => 0x208 },
	'picturecontrol' => { 215 => 0xe2173c47 },
	'picturecontrolactive' => { 218 => 0x0 },
	'picturecontroladjust' => { 184 => 0x30 },
	'picturecontrolbase' => { 184 => 0x18 },
	'picturecontroldata' => { 182 => [0xbd,0x23] },
	'picturecontrolmode' => { 218 => 0x13 },
	'picturecontrolname' => { 184 => 0x4 },
	'picturecontrolquickadjust' => { 184 => 0x31 },
	'pictureeffect' => { 331 => 0x200e },
	'pictureeffect2' => { 338 => 0x1163, 339 => 0x1167, 340 => 0x1143, 341 => 0x11bf, 342 => 0x119b, 343 => 0x1053, 344 => 0x24b, 352 => 0x46 },
	'picturefinish' => { 148 => 0x71 },
	'picturemode' => { 100 => 0x1031, 233 => 0x520, 283 => [0xb,0x33], 314 => 0x3d },
	'picturemode2' => { 264 => 0x0 },
	'picturemodebwfilter' => { 233 => 0x525 },
	'picturemodecontrast' => { 233 => 0x523 },
	'picturemodeeffect' => { 233 => 0x52d },
	'picturemodehue' => { 233 => 0x522 },
	'picturemodesaturation' => { 233 => 0x521 },
	'picturemodesharpness' => { 233 => 0x524 },
	'picturemodetone' => { 233 => 0x526 },
	'picturestyle' => { 6 => [0x4b,0x51], 7 => 0xf4, 8 => 0x6c, 9 => 0x86, 10 => 0x73, 14 => 0xab, 15 => 0xa7, 16 => 0xb0, 17 => 0x6c, 18 => 0xa7, 19 => 0xf4, 20 => 0xb3, 22 => 0xf4, 23 => 0xfa, 60 => 0xa, 87 => 0x2 },
	'picturewizard' => { 311 => 0x21 },
	'picturewizardcolor' => { 310 => 0x1 },
	'picturewizardcontrast' => { 310 => 0x4 },
	'picturewizardmode' => { 310 => 0x0 },
	'picturewizardsaturation' => { 310 => 0x2 },
	'picturewizardsharpness' => { 310 => 0x3 },
	'pitchangle' => { 252 => 0x91, 282 => 0x2 },
	'planarconfiguration' => { 95 => 0x11c, 389 => 'PlanarConfiguration' },
	'platenames' => { 398 => 'PlateNames' },
	'playbackmenustime' => { 224 => '20.1', 225 => '21.1', 226 => '21.1' },
	'playbackmonitorofftime' => { 227 => '8.1', 228 => '35.1', 231 => '21.1' },
	'playdisplay' => { 150 => 0x4e },
	'plusversion' => { 383 => 'Version' },
	'pmversion' => { 292 => 'PMVersion' },
	'pngwarning' => { 244 => 'Warning' },
	'poilevel' => { 181 => 0x8 },
	'portraitoutputhighlightpoint' => { 87 => 0x1d },
	'portraitoutputshadowpoint' => { 87 => 0x1e },
	'portraitrawcolortone' => { 87 => 0x16 },
	'portraitrawcontrast' => { 87 => 0x18 },
	'portraitrawhighlight' => { 87 => 0x76 },
	'portraitrawhighlightpoint' => { 87 => 0x1b },
	'portraitrawlinear' => { 87 => 0x19 },
	'portraitrawsaturation' => { 87 => 0x17 },
	'portraitrawshadow' => { 87 => 0x7f },
	'portraitrawshadowpoint' => { 87 => 0x1c },
	'portraitrawsharpness' => { 87 => 0x1a },
	'portraitrefiner' => { 91 => 0x302b },
	'portraitunsharpmaskfineness' => { 87 => 0x9a },
	'portraitunsharpmaskstrength' => { 87 => 0x98 },
	'portraitunsharpmaskthreshold' => { 87 => 0x9c },
	'poseheadingdegrees' => { 360 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 360 => 'PosePitchDegrees' },
	'poserolldegrees' => { 360 => 'PoseRollDegrees' },
	'postalcode' => { 130 => 'PostalCode' },
	'postcropvignetteamount' => { 370 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 370 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 370 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 370 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 370 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 370 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 329 => 0xb },
	'potentialface2position' => { 329 => 0x15 },
	'potentialface3position' => { 329 => 0x1f },
	'potentialface4position' => { 329 => 0x29 },
	'potentialface5position' => { 329 => 0x33 },
	'potentialface6position' => { 329 => 0x3d },
	'potentialface7position' => { 329 => 0x47 },
	'potentialface8position' => { 329 => 0x51 },
	'powersource' => { 262 => '0.1' },
	'poweruptime' => { 182 => 0xb6 },
	'precaptureframes' => { 238 => 0x300 },
	'predictor' => { 95 => 0x13d },
	'preflashreturnstrength' => { 195 => 0x28a },
	'prefs' => { 103 => 0xdd, 292 => 'Prefs' },
	'preservedfilename' => { 394 => 'PreservedFileName' },
	'presetwhitebalance' => { 150 => 0x24, 356 => 0x8002 },
	'presetwhitebalanceadj' => { 356 => 0x8014 },
	'previewapplicationname' => { 95 => 0xc716 },
	'previewapplicationversion' => { 95 => 0xc717 },
	'previewbutton' => { 222 => ['14.1','15.1'], 227 => '29.1', 228 => '14.1' },
	'previewbuttonplusdials' => { 222 => ['14.2','15.2'], 227 => '31.2' },
	'previewcolorspace' => { 95 => 0xc71a },
	'previewcropbottom' => { 291 => 0xef },
	'previewcropleft' => { 291 => 0xec },
	'previewcropright' => { 291 => 0xee },
	'previewcroptop' => { 291 => 0xed },
	'previewdate' => { 299 => 0x0 },
	'previewdatetime' => { 95 => 0xc71b },
	'previewimage' => { 91 => 0x2000, 92 => 'PreviewImage', 96 => 'PreviewImage', 98 => 0x4, 135 => 'data', 152 => 0x81, 238 => 0x280, 251 => 0x300, 331 => 0x2001 },
	'previewimageborders' => { 283 => 0x3e },
	'previewimageheight' => { 59 => 0x4, 113 => 0xfa58 },
	'previewimagelength' => { 59 => 0x2, 91 => 0x3, 95 => [0x117,0x202], 152 => 0x89, 185 => 0x202, 233 => 0x102, 238 => 0x1037, 283 => 0x3, 304 => 0x1e, 309 => 0x3, 314 => [0x1b,0x1d], 322 => 0x202 },
	'previewimagename' => { 135 => '1Name' },
	'previewimagesize' => { 91 => 0x2, 118 => 0x2, 135 => 'ImageSize', 283 => 0x2, 314 => [0x1c,0x1e], 331 => 0xb02c },
	'previewimagestart' => { 59 => 0x5, 91 => 0x4, 95 => [0x111,0x201], 152 => 0x88, 185 => 0x201, 233 => 0x101, 238 => 0x1036, 283 => 0x4, 304 => 0x1c, 309 => 0x2, 314 => [0x1a,0x1c], 322 => 0x201 },
	'previewimagetype' => { 135 => '0Type' },
	'previewimagevalid' => { 233 => 0x100, 238 => 0x1035 },
	'previewimagewidth' => { 59 => 0x3, 113 => 0xfa57 },
	'previewquality' => { 59 => 0x1 },
	'previewsettingsdigest' => { 95 => 0xc719 },
	'previewsettingsname' => { 95 => 0xc718 },
	'primaryafpoint' => { 158 => 0x7 },
	'primarychromaticities' => { 95 => 0x13f, 389 => 'PrimaryChromaticities' },
	'printim' => { 95 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 150 => 0x1d, 319 => 0x28 },
	'privatertkinfo' => { 362 => 'privateRTKInfo' },
	'processingsoftware' => { 95 => 0xb },
	'processversion' => { 370 => 'ProcessVersion' },
	'producer' => { 242 => 'Producer', 381 => 'Producer' },
	'productid' => { 104 => 0x32 },
	'productioncode' => { 263 => 0x2 },
	'productorserviceconstraints' => { 383 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 95 => 0xc6f4 },
	'profilecopyright' => { 95 => 0xc6fe },
	'profileembedpolicy' => { 95 => 0xc6fd },
	'profilehuesatmapdata1' => { 95 => 0xc6fa },
	'profilehuesatmapdata2' => { 95 => 0xc6fb },
	'profilehuesatmapdims' => { 95 => 0xc6f9 },
	'profilehuesatmapencoding' => { 95 => 0xc7a3 },
	'profilelooktabledata' => { 95 => 0xc726 },
	'profilelooktabledims' => { 95 => 0xc725 },
	'profilelooktableencoding' => { 95 => 0xc7a4 },
	'profilename' => { 95 => 0xc6f8 },
	'profiletonecurve' => { 95 => 0xc6fc },
	'programiso' => { 252 => 0x3c },
	'programline' => { 264 => '1.1' },
	'programmode' => { 155 => 0x5 },
	'programshift' => { 182 => 0xd },
	'programversion' => { 103 => 0x46 },
	'prohibits' => { 368 => 'prohibits' },
	'projectiontype' => { 360 => 'ProjectionType' },
	'projectname' => { 393 => 'projectName' },
	'projectref' => { 393 => 'projectRef' },
	'projectrefpath' => { 393 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 393 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 383 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 383 => 'PropertyReleaseStatus' },
	'province-state' => { 103 => 0x5f },
	'publicationdate' => { 384 => 'publicationDate' },
	'publicationname' => { 384 => 'publicationName' },
	'publisher' => { 371 => 'publisher' },
	'pulldown' => { 393 => 'pullDown' },
	'quality' => { 0 => 0x1, 29 => 0x3, 90 => 0x2, 91 => 0x3002, 100 => 0x1000, 111 => 0x9, 182 => 0x4, 205 => 0x3, 238 => 0x201, 248 => 0x300, 283 => 0x8, 289 => 0x2, 314 => 0x16, 319 => 0x56, 320 => 0x56, 321 => 0xb, 331 => 0x102 },
	'quality2' => { 338 => 0x1170, 339 => 0x1174, 340 => 0x1150, 342 => 0x11a8, 343 => 0x1060, 344 => 0x258, 346 => 0x29, 347 => 0x25, 348 => 0x2a },
	'qualitymode' => { 91 => 0x8 },
	'quantizationmethod' => { 105 => 0x78 },
	'quickadjust' => { 218 => 0x2a },
	'quickcontroldialinmeter' => { 68 => 0x703 },
	'quickfix' => { 215 => 0x416391c6 },
	'quickshot' => { 313 => 0x213 },
	'rangefinder' => { 224 => '4.1', 225 => '5.1', 226 => '5.1' },
	'rasterizedcaption' => { 103 => 0x7d },
	'rating' => { 95 => 0x4746, 291 => 0xdf, 331 => 0x2002, 365 => 'rating', 372 => 'rating', 391 => 'Rating' },
	'ratingpercent' => { 95 => 0x4749, 145 => 'Rating' },
	'rawandjpgrecording' => { 66 => 0x8, 152 => 0x109, 264 => 0xd },
	'rawbrightnessadj' => { 86 => 0x38 },
	'rawcoloradj' => { 86 => 0x2e },
	'rawcropbottom' => { 291 => 0xd4 },
	'rawcropleft' => { 291 => 0xd1 },
	'rawcropright' => { 291 => 0xd3 },
	'rawcroptop' => { 291 => 0xd2 },
	'rawcustomsaturation' => { 86 => 0x30 },
	'rawcustomtone' => { 86 => 0x34 },
	'rawdatauniqueid' => { 95 => 0xc65d },
	'rawdepth' => { 154 => 0x10 },
	'rawdevartfilter' => { 240 => 0x121 },
	'rawdevautogradation' => { 240 => 0x119 },
	'rawdevcolorspace' => { 239 => 0x108, 240 => 0x109 },
	'rawdevcontrastvalue' => { 239 => 0x106, 240 => 0x105 },
	'rawdeveditstatus' => { 239 => 0x10b },
	'rawdevelopmentprocess' => { 283 => 0x62 },
	'rawdevengine' => { 239 => 0x109, 240 => 0x10b },
	'rawdevexposurebiasvalue' => { 239 => 0x100, 240 => 0x100 },
	'rawdevgradation' => { 240 => 0x112 },
	'rawdevgraypoint' => { 239 => 0x103, 240 => 0x104 },
	'rawdevmemorycoloremphasis' => { 239 => 0x105, 240 => 0x108 },
	'rawdevnoisereduction' => { 239 => 0x10a, 240 => 0x10a },
	'rawdevpicturemode' => { 240 => 0x10c },
	'rawdevpm_bwfilter' => { 240 => 0x110 },
	'rawdevpmcontrast' => { 240 => 0x10e },
	'rawdevpmnoisefilter' => { 240 => 0x120 },
	'rawdevpmpicturetone' => { 240 => 0x111 },
	'rawdevpmsaturation' => { 240 => 0x10d },
	'rawdevpmsharpness' => { 240 => 0x10f },
	'rawdevsaturation3' => { 240 => 0x113 },
	'rawdevsaturationemphasis' => { 239 => 0x104, 240 => 0x107 },
	'rawdevsettings' => { 239 => 0x10c },
	'rawdevsharpnessvalue' => { 239 => 0x107, 240 => 0x106 },
	'rawdevversion' => { 239 => 0x0, 240 => 0x0 },
	'rawdevwbfineadjustment' => { 239 => 0x102, 240 => 0x103 },
	'rawdevwhitebalance' => { 240 => 0x101 },
	'rawdevwhitebalancevalue' => { 239 => 0x101, 240 => 0x102 },
	'rawfile' => { 95 => 0xfe4c },
	'rawfilename' => { 370 => 'RawFileName' },
	'rawimagecenter' => { 182 => 0x99 },
	'rawimagedigest' => { 95 => 0xc71c },
	'rawimagesize' => { 283 => 0x39 },
	'rawinfoversion' => { 241 => 0x0 },
	'rawjpgheight' => { 83 => 0x4 },
	'rawjpgquality' => { 46 => 0x6, 83 => 0x1 },
	'rawjpgsize' => { 46 => 0x7, 83 => 0x2 },
	'rawjpgwidth' => { 83 => 0x3 },
	'rawmeasuredrggb' => { 34 => 0x26a, 36 => 0x280, 38 => 0x194, 39 => 0x1ad },
	'rawrppused' => { 365 => 'rawrppused' },
	'rawtopreviewgain' => { 95 => 0xc7a8 },
	'reardisplay' => { 222 => '12.3' },
	'recognizedface1age' => { 247 => 0x20 },
	'recognizedface1name' => { 247 => 0x4 },
	'recognizedface1position' => { 247 => 0x18 },
	'recognizedface2age' => { 247 => 0x50 },
	'recognizedface2name' => { 247 => 0x34 },
	'recognizedface2position' => { 247 => 0x48 },
	'recognizedface3age' => { 247 => 0x80 },
	'recognizedface3name' => { 247 => 0x64 },
	'recognizedface3position' => { 247 => 0x78 },
	'recognizedfaceflags' => { 252 => 0x63 },
	'recommendedexposureindex' => { 95 => 0x8832, 375 => 'RecommendedExposureIndex' },
	'record' => { 94 => 'Record' },
	'recordbasisofrecord' => { 94 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 94 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 94 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 94 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 94 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 94 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 150 => 0x4d },
	'recorddynamicproperties' => { 94 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 81 => 0x1804 },
	'recordinformationwithheld' => { 94 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 305 => 0x1000 },
	'recordingmode' => { 90 => 0x1, 289 => 0x1 },
	'recordinstitutioncode' => { 94 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 94 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 29 => 0x9, 91 => 0x3000 },
	'recordownerinstitutioncode' => { 94 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 313 => 0x217 },
	'redbalance' => { 166 => 0x270, 238 => 0x1017, 256 => 0x11, 283 => 0x1c },
	'redcurvelimits' => { 86 => 0x18a },
	'redcurvepoints' => { 86 => 0x160 },
	'redeyecorrection' => { 219 => 0x0 },
	'redeyeinfo' => { 370 => 'RedEyeInfo' },
	'redeyereduction' => { 150 => 0x41, 321 => 0x28 },
	'redhue' => { 370 => 'RedHue' },
	'redsaturation' => { 370 => 'RedSaturation' },
	'reductionmatrix1' => { 95 => 0xc625 },
	'reductionmatrix2' => { 95 => 0xc626 },
	'reelname' => { 95 => 0xc789 },
	'reference1' => { 378 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 378 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 95 => 0x214, 389 => 'ReferenceBlackWhite' },
	'referencedate' => { 103 => 0x2f },
	'referencenumber' => { 103 => 0x32 },
	'references' => { 126 => 'References' },
	'referenceservice' => { 103 => 0x2d },
	'regionappliedtodimensions' => { 141 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 141 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 141 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 141 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 141 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 141 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 141 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 141 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 141 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 141 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 141 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 141 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 383 => 'RegionConstraints' },
	'regiondescription' => { 141 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 141 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 141 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 141 => 'Regions' },
	'regioninfodateregionsvalid' => { 142 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 142 => 'RegionInfo' },
	'regioninforegions' => { 142 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 141 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 141 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 142 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 141 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 141 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 380 => 'RegistryId' },
	'registryitemid' => { 380 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 380 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 124 => 'data' },
	'relatedaudiofilename' => { 124 => '1Name' },
	'relatedaudiofiletype' => { 124 => '0Type' },
	'relatedimagefileformat' => { 95 => 0x1000 },
	'relatedimageheight' => { 95 => 0x1002 },
	'relatedimagewidth' => { 95 => 0x1001 },
	'relatedresourceid' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 95 => 0xa004, 374 => 'RelatedSoundFile' },
	'relatedvideofile' => { 138 => 'data' },
	'relatedvideofilename' => { 138 => '1Name' },
	'relatedvideofiletype' => { 138 => '0Type' },
	'relation' => { 371 => 'relation' },
	'relationshipaccordingto' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 393 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 393 => 'relativeTimestamp' },
	'relativetimestampscale' => { 393 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 393 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 222 => '17.8', 227 => '33.8', 228 => '17.6' },
	'releasedate' => { 103 => 0x1e, 393 => 'releaseDate' },
	'releasemode' => { 91 => 0x3001, 331 => 0xb049 },
	'releasemode2' => { 338 => 0x112c, 339 => [0x112c,0x8], 340 => [0x1108,0x8], 341 => [0x1184,0x8], 342 => [0x1160,0x8], 343 => [0x4,0x1018], 344 => [0x4,0x210], 346 => 0x10, 347 => 0x10, 348 => 0x9, 352 => 0x34 },
	'releasemode3' => { 338 => 0x1128, 339 => 0x1128, 340 => 0x1104, 341 => 0x1180, 342 => 0x115c, 343 => 0x1014, 344 => 0x20c },
	'releasesetting' => { 81 => 0x1016 },
	'releasetime' => { 103 => 0x23 },
	'remoteonduration' => { 223 => '3.4', 224 => '17.2', 225 => '18.2', 226 => '18.2', 228 => '18.2', 229 => '4.3', 231 => '19.2' },
	'renditionclass' => { 394 => 'RenditionClass' },
	'renditionof' => { 394 => 'RenditionOf' },
	'renditionofalternatepaths' => { 394 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 394 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 394 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 394 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 394 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 394 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 394 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 394 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 394 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 394 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 394 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 394 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 394 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 394 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 394 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 394 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 394 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 394 => 'RenditionParams' },
	'repeatingflashcount' => { 171 => 0xd, 172 => 0xe, 173 => 0xe, 227 => '17.2', 228 => '24.2', 229 => '9.2', 230 => '24.2', 231 => '25.2' },
	'repeatingflashcountbuilt-in' => { 203 => 0x4db },
	'repeatingflashcountexternal' => { 203 => 0x4c3 },
	'repeatingflashoutput' => { 227 => '17.1', 228 => '24.1', 229 => '9.1', 230 => '24.1', 231 => '25.1' },
	'repeatingflashoutputexternal' => { 203 => 0x4c0 },
	'repeatingflashrate' => { 171 => 0xc, 172 => 0xd, 173 => 0xd, 227 => '18.1', 228 => '25.1', 229 => '10.1', 230 => '25.1', 231 => '26.1' },
	'repeatingflashratebuilt-in' => { 203 => 0x4da },
	'repeatingflashrateexternal' => { 203 => 0x4c2 },
	'requires' => { 368 => 'requires' },
	'resampleparams' => { 393 => 'resampleParams' },
	'resampleparamsquality' => { 393 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 313 => 0x21e },
	'resolution' => { 131 => 'Resolution' },
	'resolutionmode' => { 314 => 0x4 },
	'resolutionunit' => { 95 => 0x128, 106 => 0x2, 389 => 'ResolutionUnit' },
	'resourceid' => { 94 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 94 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 94 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictions' => { 386 => 'restrictions' },
	'retouchareafeather' => { 370 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 370 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 370 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 370 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 370 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 370 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 370 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 370 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 370 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 370 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 370 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 370 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 370 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 370 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 370 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 370 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 370 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 370 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 370 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 370 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 370 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 370 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 370 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 370 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 370 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 370 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 370 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 370 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 370 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 370 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 370 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 370 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 370 => 'RetouchAreas' },
	'retouchareaseed' => { 370 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 370 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 370 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 370 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 182 => 0x9e },
	'retouchinfo' => { 370 => 'RetouchInfo' },
	'reuse' => { 383 => 'Reuse' },
	'reuseallowed' => { 396 => 'ReuseAllowed' },
	'reuseprohibited' => { 386 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 226 => '5.2' },
	'reverseindicators' => { 222 => '12.1', 224 => '4.3', 225 => '5.2', 226 => '5.4', 227 => '33.5', 228 => '5.1', 231 => '6.2' },
	'reverseshutterspeedaperture' => { 226 => '5.3' },
	'revision' => { 372 => 'revision' },
	'rgbcurvelimits' => { 86 => 0x238 },
	'rgbcurvepoints' => { 86 => 0x20e },
	'richtextcomment' => { 377 => 'RichTextComment' },
	'ricohdate' => { 304 => 0x6 },
	'ricohimageheight' => { 304 => 0x2 },
	'ricohimagewidth' => { 304 => 0x0 },
	'rightascension' => { 134 => 'RightAscension' },
	'rights' => { 371 => 'rights' },
	'rightsagent' => { 384 => 'rightsAgent', 386 => 'rightsAgent' },
	'rightsowner' => { 386 => 'rightsOwner' },
	'rollangle' => { 252 => 0x90, 282 => 0x1 },
	'romoperationmode' => { 81 => 0x80d },
	'rotation' => { 26 => 0x17, 27 => 0x18, 80 => 0x3, 86 => 0x26e, 99 => 0x4, 134 => 'Rotation', 148 => [0x65,0x50], 149 => 0x46, 150 => 0x5a, 153 => 0x10, 202 => '590.1', 215 => 0x76a43207, 252 => 0x30, 264 => '17.2', 291 => 0xd8, 319 => 0x3f, 320 => 0x3f, 330 => 0x10 },
	'routedto' => { 376 => 'RoutedTo' },
	'routing' => { 296 => 'Routing' },
	'routingnotes' => { 376 => 'RoutingNotes' },
	'rowsperstrip' => { 95 => 0x116 },
	'rpp' => { 365 => 'rpp' },
	'safetyshift' => { 68 => 0x108 },
	'safetyshiftinavortv' => { 66 => 0x10, 67 => 0x10, 69 => 0xf, 70 => 0x10, 73 => 0x10 },
	'samplebits' => { 124 => 'SampleBits' },
	'samplerate' => { 124 => 'SampleRate' },
	'samplesperpixel' => { 95 => 0x115, 389 => 'SamplesPerPixel' },
	'samplestructure' => { 105 => 0x5a },
	'sanyoquality' => { 313 => 0x201 },
	'sanyothumbnail' => { 313 => 0x100 },
	'saturation' => { 8 => 0x6e, 10 => 0x76, 29 => 0xe, 40 => 0x1, 90 => 0xd, 91 => [0x3013,0x1f], 95 => [0xa409,0xfe55], 100 => 0x1003, 125 => 'Saturation', 147 => 0x1f, 148 => 0x32, 149 => 0x28, 150 => 0x1a, 155 => 0x1, 182 => [0x94,0xaa], 184 => 0x35, 252 => 0x40, 254 => 0x300d, 283 => 0x1f, 289 => 0xd, 301 => 0x27, 304 => 0x28, 305 => 0x1013, 314 => 0x10, 319 => 0x1e, 320 => 0x1b, 331 => 0x2005, 370 => 'Saturation', 374 => 'Saturation' },
	'saturationadj' => { 86 => 0x116, 214 => 0x1, 218 => 0x2e, 356 => 0x8016 },
	'saturationadjustmentaqua' => { 370 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 370 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 370 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 370 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 370 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 370 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 370 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 370 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 57 => 0x98 },
	'saturationfaithful' => { 17 => 0xfe, 56 => 0x68, 57 => 0x68 },
	'saturationlandscape' => { 17 => 0xfc, 56 => 0x38, 57 => 0x38 },
	'saturationmonochrome' => { 56 => 0x80, 57 => 0x80 },
	'saturationneutral' => { 17 => 0xfd, 56 => 0x50, 57 => 0x50 },
	'saturationportrait' => { 17 => 0xfb, 56 => 0x20, 57 => 0x20 },
	'saturationsetting' => { 241 => 0x1010, 321 => 0x11, 335 => 0x9 },
	'saturationstandard' => { 17 => 0xfa, 56 => 0x8, 57 => 0x8 },
	'saturationuserdef1' => { 17 => 0x100, 56 => 0x98, 57 => 0xb0 },
	'saturationuserdef2' => { 17 => 0x101, 56 => 0xb0, 57 => 0xc8 },
	'saturationuserdef3' => { 17 => 0x102, 56 => 0xc8, 57 => 0xe0 },
	'saveid' => { 394 => 'SaveID' },
	'scaletype' => { 393 => 'scaleType' },
	'scanimageenhancer' => { 187 => 0x60 },
	'scanningdirection' => { 105 => 0x64 },
	'scene' => { 379 => 'Scene', 393 => 'scene' },
	'scenearea' => { 236 => 0x211, 238 => 0x1031 },
	'sceneassist' => { 182 => 0x9c },
	'scenecapturetype' => { 95 => 0xa406, 374 => 'SceneCaptureType' },
	'scenedetect' => { 236 => 0x210, 238 => 0x1030 },
	'scenedetectdata' => { 236 => 0x212, 238 => 0x1033 },
	'scenemode' => { 113 => 0xfa02, 152 => 0x100, 182 => 0x8f, 233 => 0x509, 238 => 0x403, 252 => 0x8001, 258 => 0xf, 331 => 0xb023 },
	'scenemodeused' => { 115 => [0x6002,0xf002] },
	'sceneselect' => { 313 => 0x21f },
	'scenetype' => { 95 => 0xa301, 374 => 'SceneType' },
	'screentips' => { 222 => '12.7', 227 => '13.1', 228 => '4.4', 231 => '5.1' },
	'section' => { 384 => 'section' },
	'securityclassification' => { 95 => 0x9212 },
	'selectableafpoint' => { 68 => 0x509 },
	'selectafareaselectmode' => { 68 => 0x512 },
	'selftimer' => { 29 => 0x2, 252 => 0x2e, 313 => 0x214 },
	'selftimer2' => { 62 => 0x1d },
	'selftimerinterval' => { 228 => '19.2' },
	'selftimermode' => { 95 => 0x882b },
	'selftimershotcount' => { 224 => '18.2', 225 => '19.2', 226 => '19.2', 228 => '19.3', 231 => '20.2' },
	'selftimertime' => { 81 => 0x1806, 150 => 0x1f, 222 => '18.1', 223 => '3.3', 224 => '18.1', 225 => '19.1', 226 => '19.1', 227 => '7.2', 228 => '19.1', 229 => '3.3', 231 => '20.1' },
	'seminfo' => { 95 => 0x8546 },
	'sensingmethod' => { 95 => 0xa217, 374 => 'SensingMethod' },
	'sensitivityadjust' => { 283 => 0x40 },
	'sensitivitysteps' => { 264 => ['14.3','17.4'], 266 => 0x1 },
	'sensitivitytype' => { 95 => 0x8830, 375 => 'SensitivityType' },
	'sensorareas' => { 311 => 0xa010 },
	'sensorbitdepth' => { 254 => 0x312d },
	'sensorbluelevel' => { 60 => 0x5 },
	'sensorcalibration' => { 237 => 0x805 },
	'sensorcleaning' => { 74 => 0xd },
	'sensorfullheight' => { 108 => 0xf904 },
	'sensorfullwidth' => { 108 => 0xf903 },
	'sensorheight' => { 108 => 0xf901, 113 => 0xfa21, 154 => 0x8, 254 => 0x312c, 305 => 0x1602 },
	'sensorpixelsize' => { 182 => 0x9a },
	'sensorredlevel' => { 60 => 0x4 },
	'sensorsize' => { 125 => 'SensorSize', 283 => 0x35 },
	'sensortemperature' => { 236 => 0x1500, 238 => 0x1007, 314 => [0x39,0x55] },
	'sensorwidth' => { 108 => 0xf900, 113 => 0xfa20, 154 => 0xa, 254 => 0x312b, 305 => 0x1601 },
	'sequence' => { 301 => 0x7 },
	'sequencefilenumber' => { 339 => 0x4, 340 => 0x4, 341 => 0x4, 342 => 0x4, 346 => 0xc, 347 => 0xc, 348 => 0x1a },
	'sequenceimagenumber' => { 339 => 0x0, 340 => 0x0, 341 => 0x0, 342 => 0x0, 346 => 0x8, 347 => 0x8, 348 => 0x12, 352 => 0x24 },
	'sequencelength' => { 346 => 0x22, 347 => 0x1e, 348 => [0x16,0x1e] },
	'sequencenumber' => { 62 => 0x9, 91 => 0x301c, 100 => 0x1101, 111 => 0x1d, 203 => 0x51c, 252 => 0x2b, 321 => [0x10c,0x30c], 331 => 0xb04a },
	'sequenceshotinterval' => { 313 => 0x224 },
	'sequentialshot' => { 313 => 0x20e },
	'serialnumber' => { 51 => 0xc, 81 => 0x180b, 95 => [0xa431,0xfde9], 108 => 0xfa04, 110 => 0xfa00, 112 => 0xc354, 113 => 0xfa19, 122 => 0x0, 125 => 'SerialNumber', 182 => [0xa0,0x1d], 234 => 0x101, 238 => [0x404,0x101a], 248 => 0x303, 254 => 0x3103, 283 => 0x229, 301 => 0x15, 305 => 0x5, 314 => 0x2, 367 => 'SerialNumber', 375 => 'BodySerialNumber' },
	'serialnumberformat' => { 51 => 0x15, 81 => 0x183b },
	'seriesdatetime' => { 358 => 'SeriesDateTime' },
	'seriesdescription' => { 358 => 'SeriesDescription' },
	'seriesmodality' => { 358 => 'SeriesModality' },
	'seriesnumber' => { 358 => 'SeriesNumber' },
	'serviceidentifier' => { 104 => 0x1e },
	'setbuttoncrosskeysfunc' => { 71 => 0x0, 72 => 0x0 },
	'setbuttonwhenshooting' => { 66 => 0x1, 68 => 0x704, 74 => 0xc },
	'setfunctionwhenshooting' => { 69 => 0x0, 70 => 0x1, 73 => 0x1 },
	'shadingcompensation' => { 233 => 0x50c, 252 => 0x8a },
	'shadingcompensation2' => { 237 => 0x1012 },
	'shadow' => { 314 => 0xe },
	'shadowcorrection' => { 283 => 0x79 },
	'shadowprotection' => { 214 => 0x0 },
	'shadows' => { 95 => 0xfe52, 364 => 'Shadows', 370 => 'Shadows' },
	'shadows2012' => { 370 => 'Shadows2012' },
	'shadowscale' => { 95 => 0xc633 },
	'shadowtint' => { 370 => 'ShadowTint' },
	'shadowtone' => { 100 => 0x1040 },
	'shakereduction' => { 284 => 0x1, 285 => 0x1 },
	'sharpendetail' => { 370 => 'SharpenDetail' },
	'sharpenedgemasking' => { 370 => 'SharpenEdgeMasking' },
	'sharpening' => { 254 => 0x300b },
	'sharpeningadj' => { 218 => 0x2b },
	'sharpenradius' => { 370 => 'SharpenRadius' },
	'sharpness' => { 6 => [0x42,0x48], 8 => 0x72, 10 => 0x74, 29 => 0xf, 60 => 0x2, 90 => 0xb, 91 => [0x3011,0x21], 95 => [0xa40a,0xfe56], 100 => 0x1001, 111 => 0x6b, 120 => 0x37, 125 => 'Sharpness', 147 => 0x21, 148 => 0x30, 149 => 0x26, 150 => 0x18, 155 => 0x3, 182 => 0x6, 184 => 0x32, 238 => 0x100f, 252 => 0x41, 283 => 0x21, 289 => 0xb, 301 => 0x26, 304 => 0x22, 305 => [0x1003,0x1014], 314 => 0x11, 319 => 0x1c, 320 => 0x19, 331 => 0x2006, 370 => 'Sharpness', 374 => 'Sharpness' },
	'sharpnessadj' => { 86 => 0x25a, 356 => 0x801a },
	'sharpnessauto' => { 57 => 0x94 },
	'sharpnessfactor' => { 238 => 0x102a },
	'sharpnessfaithful' => { 17 => 0xf5, 56 => 0x64, 57 => 0x64 },
	'sharpnessfrequency' => { 6 => [0x41,0x47], 60 => 0x3 },
	'sharpnesslandscape' => { 17 => 0xf3, 56 => 0x34, 57 => 0x34 },
	'sharpnessmonochrome' => { 17 => 0xf6, 56 => 0x7c, 57 => 0x7c },
	'sharpnessneutral' => { 17 => 0xf4, 56 => 0x4c, 57 => 0x4c },
	'sharpnessovershoot' => { 356 => 0x801b },
	'sharpnessportrait' => { 17 => 0xf2, 56 => 0x1c, 57 => 0x1c },
	'sharpnesssetting' => { 233 => 0x506, 241 => 0x1013, 321 => 0x12, 335 => 0xa },
	'sharpnessstandard' => { 17 => 0xf1, 56 => 0x4, 57 => 0x4 },
	'sharpnessthreshold' => { 356 => 0x801d },
	'sharpnessundershoot' => { 356 => 0x801c },
	'sharpnessuserdef1' => { 17 => 0xf7, 56 => 0x94, 57 => 0xac },
	'sharpnessuserdef2' => { 17 => 0xf8, 56 => 0xac, 57 => 0xc4 },
	'sharpnessuserdef3' => { 17 => 0xf9, 56 => 0xc4, 57 => 0xdc },
	'shootinginfodisplay' => { 222 => '13.2', 227 => '10.2', 228 => '4.1', 231 => '5.3' },
	'shootinginfomonitorofftime' => { 227 => '9.1', 228 => '21.2', 231 => '22.2' },
	'shootingmode' => { 125 => 'ShootingMode', 182 => 0x89, 252 => 0x1f },
	'shootingmodesetting' => { 223 => '5.1' },
	'shortdescription' => { 372 => 'shortdescription' },
	'shortdocumentid' => { 103 => 0xba },
	'shortownername' => { 17 => 0xac },
	'shortreleasetimelag' => { 68 => 0x80d },
	'shotdate' => { 393 => 'shotDate' },
	'shotday' => { 393 => 'shotDay' },
	'shotlocation' => { 393 => 'shotLocation' },
	'shotname' => { 393 => 'shotName' },
	'shotnumber' => { 393 => 'shotNumber' },
	'shotnumbersincepowerup' => { 334 => 0x44e, 346 => 0x1a, 347 => 0x16, 348 => 0xa },
	'shotnumbersincepowerup2' => { 321 => 0x200 },
	'shotsize' => { 393 => 'shotSize' },
	'shutter-aelock' => { 66 => 0x4, 68 => 0x701, 69 => 0x3, 70 => 0x4, 71 => 0x3, 72 => 0x3, 73 => 0x4, 74 => 0x2 },
	'shutteraelbutton' => { 67 => 0x4 },
	'shutterbuttonafonbutton' => { 68 => 0x701 },
	'shuttercount' => { 9 => 0x176, 46 => 0x1, 182 => 0xa7, 188 => [0x6a,0x157,0x24d], 189 => 0x286, 190 => 0x279, 191 => 0x284, 192 => 0x242, 193 => 0x280, 194 => 0x276, 195 => [0x27d,0x27f], 196 => 0x246, 197 => 0x2d6, 198 => 0x321, 199 => 0xbd8, 200 => 0x287, 201 => 0x320, 202 => 0x24a, 203 => 0x5fb, 204 => 0x2d5, 283 => 0x5d, 330 => 0x846, 333 => [0x125,0x14a] },
	'shuttercurtainsync' => { 66 => 0xf, 67 => 0xf, 68 => 0x305, 69 => 0xe, 70 => 0xf, 71 => 0x8, 72 => 0x8, 73 => 0xf, 74 => 0x8 },
	'shuttermode' => { 111 => 0x1b },
	'shutterreleasebuttonae-l' => { 222 => '17.7', 224 => '16.1', 225 => '17.1', 226 => '17.1', 227 => '7.1', 228 => '17.5', 231 => '18.2' },
	'shutterreleasemethod' => { 81 => 0x1010 },
	'shutterreleasenocfcard' => { 66 => 0x2, 67 => 0x2, 74 => 0xf },
	'shutterreleasetiming' => { 81 => 0x1011 },
	'shutterspeedrange' => { 68 => 0x10c },
	'shutterspeedsetting' => { 150 => 0x6, 319 => 0x2f, 320 => 0x28, 321 => 0x0 },
	'shutterspeedvalue' => { 77 => 0x1, 95 => 0x9201, 238 => 0x1000, 374 => 'ShutterSpeedValue' },
	'shuttertype' => { 252 => 0x9f },
	'sidecarforextension' => { 382 => 'SidecarForExtension' },
	'similarityindex' => { 103 => 0xe4 },
	'singleframebracketing' => { 150 => 0x21 },
	'slaveflashmeteringsegments' => { 283 => 0x20b },
	'slowshutter' => { 62 => 0x8 },
	'slowsync' => { 100 => 0x1030 },
	'smartrange' => { 311 => 0xa012 },
	'smileshutter' => { 321 => 0x31 },
	'smileshuttermode' => { 321 => 0x27 },
	'smoothness' => { 95 => 0xfe57, 370 => 'Smoothness' },
	'softskineffect' => { 331 => 0x200f },
	'software' => { 95 => 0x131, 126 => 'Software', 244 => 'Software', 314 => 0x18, 389 => 'Software' },
	'softwareversion' => { 313 => 0x207 },
	'sonydatetime' => { 337 => 0x6, 339 => 0x1b6, 340 => 0x210, 341 => 0x1fe, 342 => 0x22c },
	'sonydatetime2' => { 345 => 0x51 },
	'sonyexposuretime' => { 345 => 0x3a },
	'sonyexposuretime2' => { 352 => 0xe },
	'sonyfnumber' => { 345 => 0x3c, 352 => 0x14 },
	'sonyimageheight' => { 337 => 0x1a, 346 => 0x44, 347 => 0x3f, 348 => 0x47 },
	'sonyimagesize' => { 150 => 0x3b, 319 => 0x54, 320 => 0x54, 321 => 0x9 },
	'sonyimagewidth' => { 337 => 0x1c },
	'sonymaxaperturevalue' => { 352 => 0x16 },
	'sonymodelid' => { 331 => 0xb001 },
	'sonyquality' => { 150 => 0x3c },
	'source' => { 103 => 0x73, 244 => 'Source', 371 => 'source', 372 => 'source', 382 => 'Source' },
	'sourcedirectoryindex' => { 270 => 0x0 },
	'sourcefileindex' => { 270 => 0x2 },
	'sourcephotoscount' => { 360 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 374 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 374 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 374 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 374 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 374 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 393 => 'speakerPlacement' },
	'specialeffectlevel' => { 91 => 0x3030 },
	'specialeffectmode' => { 91 => 0x2076 },
	'specialeffectsetting' => { 91 => 0x3031 },
	'specialinstructions' => { 103 => 0x28 },
	'specialmode' => { 238 => 0x200, 313 => 0x200 },
	'spectralsensitivity' => { 95 => 0x8824, 374 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 36 => [0x2b9,0x2d0,0x2d4], 38 => 0x1e4, 39 => 0x1fd },
	'splittoningbalance' => { 370 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 370 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 370 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 370 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 370 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 147 => 0x2d },
	'spotfocuspointy' => { 147 => 0x2e },
	'spotmeteringmode' => { 29 => 0x27 },
	'spotmeterlinktoafpoint' => { 68 => 0x107 },
	'sractive' => { 264 => '17.1' },
	'srawquality' => { 29 => 0x2e },
	'srfocallength' => { 284 => 0x3 },
	'srhalfpresstime' => { 284 => 0x2 },
	'srresult' => { 284 => 0x0, 285 => 0x0 },
	'standardoutputhighlightpoint' => { 87 => 0x14 },
	'standardoutputsensitivity' => { 95 => 0x8831, 375 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 87 => 0x15 },
	'standardrawcolortone' => { 87 => 0xd },
	'standardrawcontrast' => { 87 => 0xf },
	'standardrawhighlight' => { 87 => 0x75 },
	'standardrawhighlightpoint' => { 87 => 0x12 },
	'standardrawlinear' => { 87 => 0x10 },
	'standardrawsaturation' => { 87 => 0xe },
	'standardrawshadow' => { 87 => 0x7e },
	'standardrawshadowpoint' => { 87 => 0x13 },
	'standardrawsharpness' => { 87 => 0x11 },
	'standardunsharpmaskfineness' => { 87 => 0x94 },
	'standardunsharpmaskstrength' => { 87 => 0x92 },
	'standardunsharpmaskthreshold' => { 87 => 0x96 },
	'standbytimer' => { 226 => '18.1' },
	'startingpage' => { 384 => 'startingPage' },
	'startmovieshooting' => { 68 => 0x70d },
	'starttimecode' => { 393 => 'startTimecode' },
	'starttimecodetimeformat' => { 393 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 393 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 393 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 130 => 'State', 252 => 0x6b, 382 => 'State' },
	'status' => { 359 => 'Status', 363 => 'Status' },
	'stitchingsoftware' => { 360 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 338 => 0x113e, 339 => 0x113e, 340 => 0x111a, 341 => 0x1196, 342 => 0x1172, 343 => 0x102a, 344 => 0x222 },
	'storagemethod' => { 154 => 0x12 },
	'straightenangle' => { 215 => 0x2fc08431 },
	'stretchmode' => { 393 => 'stretchMode' },
	'studydatetime' => { 358 => 'StudyDateTime' },
	'studydescription' => { 358 => 'StudyDescription' },
	'studyid' => { 358 => 'StudyID' },
	'studyphysician' => { 358 => 'StudyPhysician' },
	'sub-location' => { 103 => 0x5c },
	'subfiledata' => { 133 => 'data' },
	'subfiledirectory' => { 133 => '1Directory' },
	'subfilemimetype' => { 133 => '2MIME' },
	'subfilename' => { 133 => '1Name' },
	'subfileresource' => { 133 => 'rsrc' },
	'subfiletype' => { 95 => 0xfe, 133 => '0Type' },
	'subject' => { 242 => 'Subject', 296 => 'Subject', 371 => 'subject', 381 => 'Subject', 394 => 'subject' },
	'subjectarea' => { 95 => 0x9214, 374 => 'SubjectArea' },
	'subjectcode' => { 379 => 'SubjectCode' },
	'subjectdistance' => { 95 => 0x9206, 111 => 0x3e, 374 => 'SubjectDistance' },
	'subjectdistancerange' => { 95 => 0xa40c, 374 => 'SubjectDistanceRange' },
	'subjectlocation' => { 95 => 0xa214, 374 => 'SubjectLocation' },
	'subjectprogram' => { 147 => 0x22 },
	'subjectreference' => { 103 => 0xc },
	'sublabels4' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 378 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 378 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 95 => 0x9290 },
	'subsectimedigitized' => { 95 => 0x9292 },
	'subsectimeoriginal' => { 95 => 0x9291 },
	'subsection1' => { 384 => 'subsection1' },
	'subsection2' => { 384 => 'subsection2' },
	'subsection3' => { 384 => 'subsection3' },
	'subsection4' => { 384 => 'subsection4' },
	'subversionfilename' => { 378 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 378 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 378 => 'SubVersions' },
	'superimposeddisplay' => { 66 => 0xa, 68 => 0x510, 69 => 0x9, 70 => 0xa, 73 => 0xa, 74 => 0xe },
	'supermacro' => { 51 => 0x1a },
	'supplementalcategories' => { 103 => 0x14, 382 => 'SupplementalCategories' },
	'supplementaltype' => { 105 => 0x37 },
	'svisosetting' => { 264 => 0x14 },
	'sweeppanoramadirection' => { 252 => 0x93, 321 => 0x33 },
	'sweeppanoramafieldofview' => { 252 => 0x94 },
	'sweeppanoramasize' => { 321 => 0x32 },
	'switchtoregisteredafpoint' => { 67 => 0x12, 68 => 0x50a },
	'tagged' => { 291 => 0xdd, 292 => 'Tagged', 365 => 'tagged' },
	'tagslist' => { 373 => 'TagsList' },
	'tagstructure' => { 378 => 'TagStructure' },
	'takenumber' => { 393 => 'takeNumber' },
	'tapename' => { 393 => 'tapeName' },
	'targetaperture' => { 62 => 0x4 },
	'targetcompressionratio' => { 79 => 0x1 },
	'targetdistancesetting' => { 81 => 0x1807 },
	'targetexposuretime' => { 62 => 0x5 },
	'targetimagetype' => { 81 => 0x100a },
	'taxon' => { 94 => 'Taxon' },
	'taxonacceptednameusage' => { 94 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 94 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 94 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 94 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 94 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 94 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 94 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 94 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 94 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 94 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 94 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 94 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 94 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 94 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 94 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 94 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 94 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 94 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 94 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 94 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 94 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 94 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 94 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 94 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 94 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 94 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 94 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 94 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 94 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 94 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 94 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 94 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 94 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 384 => 'teaser' },
	'teleconverter' => { 152 => 0x105, 331 => 0x105 },
	'tempo' => { 393 => 'tempo' },
	'termsandconditionstext' => { 383 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 383 => 'TermsAndConditionsURL' },
	'textencoding' => { 181 => 0x4 },
	'textlayername' => { 382 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 382 => 'TextLayers' },
	'textlayertext' => { 382 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 252 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 95 => 0x107 },
	'thumbnailfilename' => { 81 => 0x817 },
	'thumbnailformat' => { 391 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 113 => 0xfa55, 391 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 81 => 0x2008, 92 => 'ThumbnailImage', 98 => 0x3, 136 => 'data', 238 => 0x100, 391 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 136 => '1Name' },
	'thumbnailimagesize' => { 136 => 'ImageSize' },
	'thumbnailimagetype' => { 136 => '0Type' },
	'thumbnailimagevalidarea' => { 51 => 0x13 },
	'thumbnaillength' => { 95 => 0x202 },
	'thumbnailoffset' => { 95 => 0x201 },
	'thumbnails' => { 391 => 'Thumbnails' },
	'thumbnailwidth' => { 113 => 0xfa54, 391 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 384 => 'ticker' },
	'tilelength' => { 95 => 0x143 },
	'tilewidth' => { 95 => 0x142 },
	'time' => { 109 => 0x401, 283 => 0x7 },
	'timecodes' => { 95 => 0xc763 },
	'timecreated' => { 103 => 0x3c, 111 => 0x14, 120 => 0x10, 292 => 'TimeCreated' },
	'timeperiod' => { 384 => 'timePeriod' },
	'timerfunctionbutton' => { 223 => '5.2', 224 => '12.1', 225 => '13.1' },
	'timerlength' => { 68 => 0x80c },
	'timerrecording' => { 252 => 0x96 },
	'timescaleparams' => { 393 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 393 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 393 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 393 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 104 => 0x50 },
	'timesignature' => { 393 => 'timeSignature' },
	'timesincepoweron' => { 252 => 0x29 },
	'timestamp' => { 9 => 0x45e, 17 => 0x11c, 232 => 0x8, 244 => 'TimeStamp', 366 => 'Timestamp' },
	'timestamp1' => { 9 => 0x45a },
	'timezone' => { 63 => 0x1, 207 => 0x0 },
	'timezonecity' => { 63 => 0x2 },
	'timezonecode' => { 84 => 0x1 },
	'timezoneinfo' => { 84 => 0x2 },
	'timezoneoffset' => { 95 => 0x882a },
	'tint' => { 370 => 'Tint' },
	'title' => { 126 => 'Title', 242 => 'Title', 244 => 'Title', 252 => 0x65, 296 => 'Title', 371 => 'title', 381 => 'Title', 391 => 'Title' },
	'tonecomp' => { 182 => 0x81 },
	'tonecurve' => { 60 => 0x1, 283 => 0x402, 370 => 'ToneCurve' },
	'tonecurve1' => { 311 => 0xa040 },
	'tonecurve2' => { 311 => 0xa041 },
	'tonecurve3' => { 311 => 0xa042 },
	'tonecurve4' => { 311 => 0xa043 },
	'tonecurveactive' => { 86 => 0x110 },
	'tonecurveblue' => { 370 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 356 => 0x9003 },
	'tonecurvebluey' => { 356 => 0x9007 },
	'tonecurvebrightnessx' => { 356 => 0x9000 },
	'tonecurvebrightnessy' => { 356 => 0x9004 },
	'tonecurvefilename' => { 109 => 0x1391 },
	'tonecurvegreen' => { 370 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 356 => 0x9002 },
	'tonecurvegreeny' => { 356 => 0x9006 },
	'tonecurveinterpolation' => { 86 => 0x159 },
	'tonecurvemode' => { 86 => 0x113 },
	'tonecurvename' => { 370 => 'ToneCurveName' },
	'tonecurvename2012' => { 370 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 86 => 0x3c },
	'tonecurvepv2012' => { 370 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 370 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 370 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 370 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 370 => 'ToneCurveRed' },
	'tonecurveredx' => { 356 => 0x9001 },
	'tonecurveredy' => { 356 => 0x9005 },
	'tonecurves' => { 283 => 0x403 },
	'tonelevel' => { 233 => 0x52e },
	'toningeffect' => { 46 => 0xf, 182 => 0xb3, 184 => 0x38, 305 => 0x1015 },
	'toningeffectauto' => { 57 => 0xa4 },
	'toningeffectfaithful' => { 56 => 0x74, 57 => 0x74 },
	'toningeffectlandscape' => { 56 => 0x44, 57 => 0x44 },
	'toningeffectmonochrome' => { 17 => 0x108, 56 => 0x8c, 57 => 0x8c },
	'toningeffectneutral' => { 56 => 0x5c, 57 => 0x5c },
	'toningeffectportrait' => { 56 => 0x2c, 57 => 0x2c },
	'toningeffectstandard' => { 56 => 0x14, 57 => 0x14 },
	'toningeffectuserdef1' => { 56 => 0xa4, 57 => 0xbc },
	'toningeffectuserdef2' => { 56 => 0xbc, 57 => 0xd4 },
	'toningeffectuserdef3' => { 56 => 0xd4, 57 => 0xec },
	'toningsaturation' => { 184 => 0x39 },
	'totalzoom' => { 111 => 0x62 },
	'touchae' => { 252 => 0xab },
	'trackcreatedate' => { 300 => 0x1 },
	'trackmodifydate' => { 300 => 0x2 },
	'tracknumber' => { 393 => 'trackNumber' },
	'tracks' => { 393 => 'Tracks' },
	'tracksframerate' => { 393 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 393 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 393 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 393 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 393 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 393 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 393 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 393 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 393 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 393 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 393 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 393 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 393 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 393 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 393 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 393 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 393 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 133 => 'zmie' },
	'transferfunction' => { 95 => 0x12d, 389 => 'TransferFunction' },
	'transform' => { 252 => [0x8012,0x59] },
	'transmissionreference' => { 382 => 'TransmissionReference' },
	'trapped' => { 242 => 'Trapped', 381 => 'Trapped' },
	'travelday' => { 252 => 0x36 },
	'triggermode' => { 301 => 0x6 },
	'tstop' => { 95 => 0xc772 },
	'ttl_da_adown' => { 271 => 0x5 },
	'ttl_da_aup' => { 271 => 0x4 },
	'ttl_da_bdown' => { 271 => 0x7 },
	'ttl_da_bup' => { 271 => 0x6 },
	'tungstenawb' => { 261 => 0x1 },
	'tvexposuretimesetting' => { 264 => 0x12 },
	'type' => { 371 => 'type', 388 => 'type' },
	'typestatus' => { 94 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 95 => 0xc614 },
	'uniquedocumentid' => { 103 => 0xbb },
	'uniqueobjectname' => { 104 => 0x64 },
	'unknownblock' => { 283 => 0x405 },
	'unknownblock1' => { 237 => 0x635 },
	'unknownblock2' => { 237 => 0x636 },
	'unknownblock3' => { 237 => 0x1103 },
	'unknownblock4' => { 237 => 0x1104 },
	'unknowncontrast' => { 87 => 0x45 },
	'unknownev' => { 109 => 0x1 },
	'unknownlinear' => { 87 => 0x46 },
	'unknownnumber' => { 81 => 0x180b },
	'unknownoutputhighlightpoint' => { 87 => 0x4a },
	'unknownoutputshadowpoint' => { 87 => 0x4b },
	'unknownrawhighlight' => { 87 => 0x7b },
	'unknownrawhighlightpoint' => { 87 => 0x48 },
	'unknownrawshadow' => { 87 => 0x84 },
	'unknownrawshadowpoint' => { 87 => 0x49 },
	'unknownsharpness' => { 87 => 0x47 },
	'unknowntemperature' => { 97 => 0x4 },
	'unsharp1color' => { 220 => 0x13 },
	'unsharp1halowidth' => { 220 => 0x19 },
	'unsharp1intensity' => { 220 => 0x17 },
	'unsharp1threshold' => { 220 => 0x1b },
	'unsharp2color' => { 220 => 0x2e },
	'unsharp2halowidth' => { 220 => 0x34 },
	'unsharp2intensity' => { 220 => 0x32 },
	'unsharp2threshold' => { 220 => 0x36 },
	'unsharp3color' => { 220 => 0x49 },
	'unsharp3halowidth' => { 220 => 0x4f },
	'unsharp3intensity' => { 220 => 0x4d },
	'unsharp3threshold' => { 220 => 0x51 },
	'unsharp4color' => { 220 => 0x64 },
	'unsharp4halowidth' => { 220 => 0x6a },
	'unsharp4intensity' => { 220 => 0x68 },
	'unsharp4threshold' => { 220 => 0x6c },
	'unsharpcount' => { 220 => 0x0 },
	'unsharpmask' => { 87 => 0x90, 215 => 0x76a43200 },
	'uprightcentermode' => { 370 => 'UprightCenterMode' },
	'uprightcenternormx' => { 370 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 370 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 370 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 370 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 370 => 'UprightFocalMode' },
	'uprightpreview' => { 370 => 'UprightPreview' },
	'uprighttransform_0' => { 370 => 'UprightTransform_0' },
	'uprighttransform_1' => { 370 => 'UprightTransform_1' },
	'uprighttransform_2' => { 370 => 'UprightTransform_2' },
	'uprighttransform_3' => { 370 => 'UprightTransform_3' },
	'uprighttransform_4' => { 370 => 'UprightTransform_4' },
	'uprighttransformcount' => { 370 => 'UprightTransformCount' },
	'uprightversion' => { 370 => 'UprightVersion' },
	'urgency' => { 103 => 0xa, 382 => 'Urgency' },
	'url' => { 126 => 'URL', 244 => 'URL', 294 => 0x40b, 384 => 'url' },
	'usablemeteringmodes' => { 68 => 0x10a },
	'usableshootingmodes' => { 68 => 0x109 },
	'usage' => { 385 => 'usage' },
	'usagefee' => { 386 => 'usageFee' },
	'usageterms' => { 397 => 'UsageTerms' },
	'useguidelines' => { 368 => 'useGuidelines' },
	'usepanoramaviewer' => { 360 => 'UsePanoramaViewer' },
	'usercomment' => { 81 => 0x805, 95 => 0x9286, 374 => 'UserComment' },
	'userdef1picturestyle' => { 17 => 0x10c, 56 => 0xd8, 57 => 0xf0 },
	'userdef2picturestyle' => { 17 => 0x10e, 56 => 0xda, 57 => 0xf2 },
	'userdef3picturestyle' => { 17 => 0x110, 56 => 0xdc, 57 => 0xf4 },
	'userfields' => { 363 => 'UserFields' },
	'userlabel' => { 301 => 0x2b },
	'userprofile' => { 248 => 0x302, 254 => 0x3038 },
	'usmlenselectronicmf' => { 67 => 0x7, 68 => 0x501 },
	'utmeasting' => { 137 => 'Easting' },
	'utmmapdatum' => { 137 => 'Datum' },
	'utmnorthing' => { 137 => 'Northing' },
	'utmzone' => { 137 => 'Zone' },
	'uv-irfiltercorrection' => { 248 => 0x325 },
	'validbits' => { 237 => 0x611, 238 => 0x102c },
	'validpixeldepth' => { 241 => 0x611 },
	'variousmodes' => { 111 => 0x26 },
	'variousmodes2' => { 111 => 0x3a },
	'variprogram' => { 182 => 0xab },
	'version' => { 100 => 0x0, 296 => 'Version', 370 => 'Version' },
	'versioncreatedate' => { 356 => 0xd100 },
	'versionid' => { 394 => 'VersionID' },
	'versionidentifier' => { 384 => 'versionIdentifier' },
	'versionmodifydate' => { 356 => 0xd101 },
	'versions' => { 394 => 'Versions' },
	'versionscomments' => { 394 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 394 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 394 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 394 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 394 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 394 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 394 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 394 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 394 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 394 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 394 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 222 => '3.2' },
	'vfdisplayillumination' => { 68 => 0x510 },
	'vibrance' => { 364 => 'Vibrance', 370 => 'Vibrance' },
	'vibrationreduction' => { 188 => [0x75,0x82,0x1ae], 196 => '586.1', 202 => '590.2', 206 => 0x4 },
	'videoalphamode' => { 393 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 393 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 393 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 393 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 54 => 0x74 },
	'videocolorspace' => { 393 => 'videoColorSpace' },
	'videocompressor' => { 393 => 'videoCompressor' },
	'videofieldorder' => { 393 => 'videoFieldOrder' },
	'videoframerate' => { 393 => 'videoFrameRate' },
	'videoframesize' => { 393 => 'videoFrameSize' },
	'videoframesizeh' => { 393 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 393 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 393 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 393 => 'videoModDate' },
	'videopixelaspectratio' => { 393 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 393 => 'videoPixelDepth' },
	'videoquality' => { 91 => 0x4003 },
	'viewfinderdisplay' => { 222 => '12.4' },
	'viewfinderwarning' => { 222 => '13.4', 228 => '3.5', 229 => '6.2', 231 => '4.4' },
	'viewfinderwarnings' => { 68 => 0x40a },
	'viewinfoduringexposure' => { 68 => 0x407 },
	'viewingmode' => { 321 => 0x2f, 335 => 0x18 },
	'viewingmode2' => { 321 => [0x85,0x285] },
	'vignetteamount' => { 370 => 'VignetteAmount' },
	'vignettecontrol' => { 182 => 0x2a, 215 => 0x76a43205 },
	'vignettecontrolintensity' => { 215 => 0xac6bd5c0 },
	'vignettemidpoint' => { 370 => 'VignetteMidpoint' },
	'vignetting' => { 305 => 0x1011 },
	'vignettingcorrection' => { 273 => 0x2, 331 => 0x2011 },
	'voicememo' => { 313 => 0x216 },
	'volume' => { 384 => 'volume' },
	'vr_0x66' => { 188 => 0x66 },
	'vrdoffset' => { 51 => 0xd0 },
	'vrmode' => { 206 => 0x6 },
	'wb_bluelevel3500k' => { 153 => 0x19a },
	'wb_bluelevel6500k' => { 153 => 0x18a },
	'wb_bluelevelcustom' => { 153 => 0x18e },
	'wb_bluelevelscloudy' => { 153 => 0x106 },
	'wb_bluelevelsdaylight' => { 153 => 0xea },
	'wb_bluelevelsflash' => { 153 => 0x122 },
	'wb_bluelevelsfluorescent' => { 153 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 153 => 0x254 },
	'wb_bluelevelsshade' => { 153 => 0x176 },
	'wb_bluelevelstungsten' => { 153 => 0xce },
	'wb_gbrglevels' => { 153 => 0xae, 156 => 0x4 },
	'wb_glevel' => { 237 => 0x11f },
	'wb_glevel3000k' => { 237 => 0x113 },
	'wb_glevel3300k' => { 237 => 0x114 },
	'wb_glevel3600k' => { 237 => 0x115 },
	'wb_glevel3900k' => { 237 => 0x116 },
	'wb_glevel4000k' => { 237 => 0x117 },
	'wb_glevel4300k' => { 237 => 0x118 },
	'wb_glevel4500k' => { 237 => 0x119 },
	'wb_glevel4800k' => { 237 => 0x11a },
	'wb_glevel5300k' => { 237 => 0x11b },
	'wb_glevel6000k' => { 237 => 0x11c },
	'wb_glevel6600k' => { 237 => 0x11d },
	'wb_glevel7500k' => { 237 => 0x11e },
	'wb_grbglevels' => { 165 => 0x0 },
	'wb_rbgglevels' => { 162 => 0x0 },
	'wb_rblevels' => { 182 => 0xc, 237 => 0x100 },
	'wb_rblevels3000k' => { 237 => 0x102 },
	'wb_rblevels3300k' => { 237 => 0x103 },
	'wb_rblevels3500k' => { 153 => 0x430 },
	'wb_rblevels3600k' => { 237 => 0x104 },
	'wb_rblevels3900k' => { 237 => 0x105 },
	'wb_rblevels4000k' => { 237 => 0x106 },
	'wb_rblevels4300k' => { 237 => 0x107 },
	'wb_rblevels4500k' => { 237 => 0x108 },
	'wb_rblevels4800k' => { 237 => 0x109 },
	'wb_rblevels5300k' => { 237 => 0x10a },
	'wb_rblevels6000k' => { 237 => 0x10b },
	'wb_rblevels6500k' => { 153 => 0x420 },
	'wb_rblevels6600k' => { 237 => 0x10c },
	'wb_rblevels7500k' => { 237 => 0x10d },
	'wb_rblevelsauto' => { 241 => 0x110 },
	'wb_rblevelscloudy' => { 153 => 0x3f0, 155 => 0x10, 241 => 0x121 },
	'wb_rblevelscoolwhitef' => { 153 => 0x308, 155 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 241 => 0x132 },
	'wb_rblevelscustom' => { 153 => 0x424 },
	'wb_rblevelscwb1' => { 237 => 0x10e },
	'wb_rblevelscwb2' => { 237 => 0x10f },
	'wb_rblevelscwb3' => { 237 => 0x110 },
	'wb_rblevelscwb4' => { 237 => 0x111 },
	'wb_rblevelsdaylight' => { 153 => [0x3ec,0x528], 155 => 0xc },
	'wb_rblevelsdaylightf' => { 155 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 241 => 0x130 },
	'wb_rblevelsdaywhitef' => { 155 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 241 => 0x131 },
	'wb_rblevelseveningsunlight' => { 241 => 0x124 },
	'wb_rblevelsfineweather' => { 241 => 0x122 },
	'wb_rblevelsflash' => { 153 => [0x3f4,0x304], 155 => 0x18 },
	'wb_rblevelsshade' => { 153 => 0x418, 155 => 0x20, 241 => 0x120 },
	'wb_rblevelstungsten' => { 153 => 0x3e8, 155 => 0x8, 241 => 0x123 },
	'wb_rblevelsunknown' => { 155 => 0x1c },
	'wb_rblevelsused' => { 241 => 0x100 },
	'wb_rblevelswhitef' => { 155 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 241 => 0x133 },
	'wb_redlevel3500k' => { 153 => 0x198 },
	'wb_redlevel6500k' => { 153 => 0x188 },
	'wb_redlevelcustom' => { 153 => 0x18c },
	'wb_redlevelscloudy' => { 153 => 0xf8 },
	'wb_redlevelsdaylight' => { 153 => 0xdc },
	'wb_redlevelsflash' => { 153 => 0x114 },
	'wb_redlevelsfluorescent' => { 153 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 153 => 0x1be },
	'wb_redlevelsshade' => { 153 => 0x168 },
	'wb_redlevelstungsten' => { 153 => 0xc0 },
	'wb_rgbglevels' => { 164 => 0x0 },
	'wb_rgblevels' => { 153 => [0x546,0x96], 249 => 0xd, 250 => 0x413, 254 => 0x3036, 338 => 0x117c, 339 => 0x1180, 340 => 0x115c, 341 => 0x11d8, 342 => 0x11b4, 343 => 0x106c, 344 => 0x264 },
	'wb_rggbblacklevels' => { 30 => 0x25 },
	'wb_rggblevels' => { 156 => 0x4, 163 => 0x0 },
	'wb_rggblevelsasshot' => { 32 => 0x0, 33 => 0x19, 34 => 0x22, 35 => 0x3f, 38 => 0x3f, 39 => 0x3f },
	'wb_rggblevelsauto' => { 30 => 0x1, 32 => 0x5, 33 => 0x1e, 34 => 0x18, 35 => 0x44, 38 => 0x44, 39 => 0x44, 311 => 0xa022 },
	'wb_rggblevelsblack' => { 311 => 0xa028 },
	'wb_rggblevelscloudy' => { 30 => 0xd, 32 => 0x1e, 33 => 0x2d, 34 => 0x31, 35 => 0x58, 38 => 0x71, 39 => 0x8a, 283 => 0x20f, 290 => 0x14 },
	'wb_rggblevelscustom' => { 30 => 0x1d, 35 => 0x80 },
	'wb_rggblevelscustom1' => { 33 => 0x41 },
	'wb_rggblevelscustom2' => { 33 => 0x46 },
	'wb_rggblevelsdaylight' => { 30 => 0x5, 32 => 0x14, 33 => 0x23, 34 => 0x27, 35 => 0x4e, 38 => 0x67, 39 => 0x80, 283 => 0x20d, 290 => 0x2 },
	'wb_rggblevelsflash' => { 30 => 0x19, 32 => 0x32, 33 => 0x3c, 34 => 0x45, 35 => 0x6c, 38 => 0x85, 39 => 0x9e, 283 => 0x214, 290 => 0x41 },
	'wb_rggblevelsfluorescent' => { 30 => 0x15, 32 => 0x28, 33 => 0x37, 34 => 0x3b, 35 => 0x62, 38 => 0x7b, 39 => 0x94 },
	'wb_rggblevelsfluorescentd' => { 283 => 0x211, 290 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 290 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 283 => 0x212, 290 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 283 => 0x213, 290 => 0x38 },
	'wb_rggblevelsilluminator1' => { 311 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 311 => 0xa024 },
	'wb_rggblevelskelvin' => { 30 => 0x21, 32 => 0x2d, 34 => 0x40, 35 => 0x67, 38 => 0x80, 39 => 0x99 },
	'wb_rggblevelsmeasured' => { 32 => 0xa, 35 => 0x49, 38 => 0x49, 39 => 0x49 },
	'wb_rggblevelspc1' => { 34 => 0x90, 35 => 0x71 },
	'wb_rggblevelspc2' => { 34 => 0x95, 35 => 0x76 },
	'wb_rggblevelspc3' => { 34 => 0x9a, 35 => 0x7b },
	'wb_rggblevelsshade' => { 30 => 0x9, 32 => 0x19, 33 => 0x28, 34 => 0x2c, 35 => 0x53, 38 => 0x6c, 39 => 0x85, 283 => 0x20e, 290 => 0xb },
	'wb_rggblevelstungsten' => { 30 => 0x11, 32 => 0x23, 33 => 0x32, 34 => 0x36, 35 => 0x5d, 38 => 0x76, 39 => 0x8f, 283 => 0x210, 290 => 0x1d },
	'wb_rggblevelsuncorrected' => { 311 => 0xa021 },
	'wb_rggblevelsunknown' => { 32 => 0xf, 34 => 0x1d, 38 => 0x4e, 39 => 0x4e, 290 => 0x53 },
	'wb_rggblevelsunknown10' => { 32 => 0x5f, 34 => 0x72, 38 => 0x9e, 39 => 0x7b },
	'wb_rggblevelsunknown11' => { 32 => 0x64, 34 => 0x77, 38 => 0xa3, 39 => 0xa3 },
	'wb_rggblevelsunknown12' => { 32 => 0x69, 34 => 0x7c, 38 => 0xa8, 39 => 0xa8 },
	'wb_rggblevelsunknown13' => { 32 => 0x6e, 34 => 0x81, 38 => 0xad, 39 => 0xad },
	'wb_rggblevelsunknown14' => { 34 => 0x86, 38 => 0xb2, 39 => 0xb2 },
	'wb_rggblevelsunknown15' => { 34 => 0x8b, 38 => 0xb7, 39 => 0xb7 },
	'wb_rggblevelsunknown16' => { 34 => 0x9f, 39 => 0xbc },
	'wb_rggblevelsunknown17' => { 39 => 0xc1 },
	'wb_rggblevelsunknown18' => { 39 => 0xc6 },
	'wb_rggblevelsunknown19' => { 39 => 0xcb },
	'wb_rggblevelsunknown2' => { 32 => 0x37, 34 => 0x4a, 38 => 0x53, 39 => 0x53 },
	'wb_rggblevelsunknown20' => { 39 => 0xd0 },
	'wb_rggblevelsunknown3' => { 32 => 0x3c, 34 => 0x4f, 38 => 0x58, 39 => 0x58 },
	'wb_rggblevelsunknown4' => { 32 => 0x41, 34 => 0x54, 38 => 0x5d, 39 => 0x5d },
	'wb_rggblevelsunknown5' => { 32 => 0x46, 34 => 0x59, 38 => 0x62, 39 => 0x62 },
	'wb_rggblevelsunknown6' => { 32 => 0x4b, 34 => 0x5e, 38 => 0x8a, 39 => 0x67 },
	'wb_rggblevelsunknown7' => { 32 => 0x50, 34 => 0x63, 38 => 0x8f, 39 => 0x6c },
	'wb_rggblevelsunknown8' => { 32 => 0x55, 34 => 0x68, 38 => 0x94, 39 => 0x71 },
	'wb_rggblevelsunknown9' => { 32 => 0x5a, 34 => 0x6d, 38 => 0x99, 39 => 0x76 },
	'wb_rggblevelsuserselected' => { 290 => 0x5c },
	'wbadjbluebalance' => { 221 => 0x8 },
	'wbadjcolortemp' => { 86 => 0x1a },
	'wbadjlighting' => { 221 => 0x14 },
	'wbadjmode' => { 221 => 0x10 },
	'wbadjredbalance' => { 221 => 0x0 },
	'wbadjrggblevels' => { 86 => 0x6 },
	'wbadjtemperature' => { 221 => 0x18 },
	'wbadjtint' => { 221 => 0x25 },
	'wbbluelevel' => { 248 => 0x324, 252 => 0x8006, 256 => 0x26 },
	'wbbracketmode' => { 46 => 0x9 },
	'wbbracketshotnumber' => { 153 => 0x2b, 305 => 0x101a },
	'wbbracketvalueab' => { 46 => 0xc },
	'wbbracketvaluegm' => { 46 => 0xd },
	'wbfinetuneactive' => { 86 => 0x24 },
	'wbfinetunesaturation' => { 86 => 0x28 },
	'wbfinetunetone' => { 86 => 0x2c },
	'wbgreenlevel' => { 248 => 0x323, 252 => 0x8005, 256 => 0x25 },
	'wbmediaimagesizesetting' => { 68 => 0x708 },
	'wbmode' => { 155 => 0x4, 238 => 0x1015 },
	'wbredlevel' => { 248 => 0x322, 252 => 0x8004, 256 => 0x24 },
	'wbscale' => { 156 => 0x0 },
	'wbshiftab' => { 60 => 0xc, 252 => 0x46, 265 => 0x10 },
	'wbshiftab_gm' => { 331 => 0x2014 },
	'wbshiftgm' => { 60 => 0xd, 252 => 0x47, 265 => 0x11 },
	'webstatement' => { 397 => 'WebStatement' },
	'whitebalance' => { 5 => 0x6f, 6 => [0x44,0x4a], 7 => 0xbc, 8 => 0x36, 9 => 0x5e, 10 => 0x36, 11 => 0x78, 12 => 0x6f, 13 => 0x6f, 14 => 0x73, 15 => 0x6f, 16 => 0x78, 17 => 0x54, 18 => 0x6f, 19 => 0xbc, 20 => 0x7b, 22 => 0xbc, 23 => 0xc2, 25 => 0x77, 60 => 0x8, 62 => 0x7, 90 => 0x7, 91 => [0x19,0x2012], 95 => [0xa403,0xfe4e], 100 => 0x1002, 109 => 0x3fc, 110 => 0xfa0d, 111 => 0x40, 147 => 0x3, 148 => 0xe, 149 => 0x4, 150 => 0xb, 152 => 0x115, 182 => 0x5, 205 => 0x7, 248 => 0x304, 252 => 0x3, 254 => 0x3033, 283 => 0x19, 289 => 0x7, 304 => 0x26, 305 => 0x1003, 314 => [0x3c,0x7,0x58], 331 => [0x115,0xb054], 370 => 'WhiteBalance', 374 => 'WhiteBalance' },
	'whitebalance2' => { 233 => 0x500 },
	'whitebalanceadj' => { 86 => 0x18, 215 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 261 => 0x0 },
	'whitebalancebias' => { 91 => 0x2011, 238 => 0x304, 252 => 0x23 },
	'whitebalanceblue' => { 60 => 0x7 },
	'whitebalancebracket' => { 233 => 0x502, 238 => 0x303 },
	'whitebalancebracketing' => { 150 => 0x22, 153 => 0x2c, 330 => 0x2c },
	'whitebalancecomp' => { 241 => 0x1001 },
	'whitebalancefinetune' => { 100 => 0x100a, 150 => 0x38, 152 => 0x112, 182 => 0xb, 305 => 0x1004, 319 => 0x6, 331 => 0x112 },
	'whitebalancemode' => { 283 => 0x1a },
	'whitebalancered' => { 60 => 0x6 },
	'whitebalanceset' => { 264 => 0xa },
	'whitebalancesetting' => { 150 => 0x23, 321 => 0x16, 335 => 0xd },
	'whitebalancetemperature' => { 233 => 0x501 },
	'whiteboard' => { 238 => 0x301 },
	'whitelevel' => { 95 => 0xc61d },
	'whitepoint' => { 95 => 0x13e, 283 => 0x201, 389 => 'WhitePoint' },
	'whites2012' => { 370 => 'Whites2012' },
	'wideadapter' => { 305 => 0x1017 },
	'widefocuszone' => { 147 => 0x2f },
	'widerange' => { 313 => 0x20f },
	'wordcount' => { 384 => 'wordCount' },
	'workcolorspace' => { 86 => 0x270 },
	'worktodo' => { 376 => 'WorkToDo' },
	'worldtimelocation' => { 252 => 0x3a, 283 => 0x22, 288 => '0.1' },
	'writer-editor' => { 103 => 0x7a },
	'x3filllight' => { 314 => 0x12 },
	'xml' => { 107 => 'xml ' },
	'xmp' => { 85 => 0xffff00f6, 96 => 'XMP' },
	'xmptoolkit' => { 390 => 'xmptk' },
	'xpauthor' => { 95 => 0x9c9d },
	'xpcomment' => { 95 => 0x9c9c },
	'xpkeywords' => { 95 => 0x9c9e },
	'xposition' => { 95 => 0x11e },
	'xpsubject' => { 95 => 0x9c9f },
	'xptitle' => { 95 => 0x9c9b },
	'xresolution' => { 95 => 0x11a, 106 => 0x3, 295 => 0x0, 389 => 'XResolution' },
	'xyresolution' => { 99 => 0x3 },
	'ycbcrcoefficients' => { 95 => 0x211, 389 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 95 => 0x213, 389 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 95 => 0x212, 389 => 'YCbCrSubSampling' },
	'yearcreated' => { 111 => 0x10, 120 => 0xc },
	'yposition' => { 95 => 0x11f },
	'yresolution' => { 95 => 0x11b, 106 => 0x5, 295 => 0x4, 389 => 'YResolution' },
	'zonematching' => { 152 => 0x10a, 155 => [0x3a,0x4a], 331 => 0xb024 },
	'zonematchingmode' => { 150 => 0x14 },
	'zonematchingon' => { 149 => 0x75 },
	'zonematchingvalue' => { 319 => 0x1f },
	'zoomedpreviewlength' => { 238 => 0xf05 },
	'zoomedpreviewsize' => { 238 => 0xf06 },
	'zoomedpreviewstart' => { 238 => 0xf04 },
	'zoomsourcewidth' => { 29 => 0x24 },
	'zoomstepcount' => { 236 => 0x300, 238 => 0x100d },
	'zoomtargetwidth' => { 29 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfoa100' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'platform' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencetemperature' => 1,
	'referencevirtual' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimage' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsdaylight' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2014, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
