
# meshping.nss - Cisco Mesh Ping Utility
# Copyright (c) 2008-2009 Chris Mason <chris@noodles.org.uk>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

$ns4_version = "4.3.1";

$script_version = <<SV;
Cisco Mesh Ping Utility v4.0
Copyright (c) 2008-2009 Chris Mason <chris\@noodles.org.uk>
SV

sub main {
  my $sO = new ScriptObject;

  my ($hostName, $ipAddress) = (undef, undef);
  my @oISIS = $sO->cmd ("show isis database detail | include Hostname:|Router ID:");
  for (my $i = 0; $i < $#oISIS + 1; $i++) {
    if ($oISIS[$i] =~ m/hostname:\s+(\S+)/i) {
      $hostName = $1;
    }
    elsif ($oISIS[$i] =~ m/router\s+id:\s+(\S+)/i) {
      if (defined $hostName) {
        $ipAddress = $1;

        my $rPing = $sO->cmd ("ping " . $ipAddress);
        if ($rPing =~ m/success\s+rate\s+is\s+(\d+)\s+percent.+=\s+\d+\/(\d+)\/\d+\s+ms/i) {
          if ($1 == 0) {
            print ">> Ping (" . $sO->dvar ("node") . " to " . $ipAddress . "): \e[31;1mFailed\e[0m [0%]\n";
          }
          elsif ($1 < 100) {
            print ">> Ping (" . $sO->dvar ("node") . " to " . $ipAddress . "): \e[33;1mPassed\e[0m [" . $1 . "%] (AvRTT = " . $2 . "ms)\n";
          }
          else {
            print ">> Ping (" . $sO->dvar ("node") . " to " . $ipAddress . "): \e[32;1mOK\e[0m [" . $1 . "%] (AvRTT = " . $2 . "ms)\n";
          }
        }
        else {
          print ">> Ping (" . $sO->dvar ("node") . " to " . $ipAddress . "): \e[31;1mError\e[0m\n";
        }
      }
      $hostName = undef;
      $ipAddress = undef;
    }
    last if ($sO->break);
  }
  100;
}

1;
