/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0  
 
THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE, 
MERCHANTABLITY OR NON-INFRINGEMENT. 
 
See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

var TypeScript;
(function (TypeScript) {
    TypeScript.DiagnosticCode = {
        error_TS_0_1: "error TS{0}: {1}",
        warning_TS_0_1: "warning TS{0}: {1}",
        Unrecognized_escape_sequence: "Unrecognized escape sequence.",
        Unexpected_character_0: "Unexpected character {0}.",
        Missing_close_quote_character: "Missing close quote character.",
        Identifier_expected: "Identifier expected.",
        _0_keyword_expected: "'{0}' keyword expected.",
        _0_expected: "'{0}' expected.",
        Identifier_expected_0_is_a_keyword: "Identifier expected; '{0}' is a keyword.",
        Automatic_semicolon_insertion_not_allowed: "Automatic semicolon insertion not allowed.",
        Unexpected_token_0_expected: "Unexpected token; '{0}' expected.",
        Trailing_separator_not_allowed: "Trailing separator not allowed.",
        AsteriskSlash_expected: "'*/' expected.",
        public_or_private_modifier_must_precede_static: "'public' or 'private' modifier must precede 'static'.",
        Unexpected_token: "Unexpected token.",
        Catch_clause_parameter_cannot_have_a_type_annotation: "Catch clause parameter cannot have a type annotation.",
        Rest_parameter_must_be_last_in_list: "Rest parameter must be last in list.",
        Parameter_cannot_have_question_mark_and_initializer: "Parameter cannot have question mark and initializer.",
        Required_parameter_cannot_follow_optional_parameter: "Required parameter cannot follow optional parameter.",
        Index_signatures_cannot_have_rest_parameters: "Index signatures cannot have rest parameters.",
        Index_signature_parameter_cannot_have_accessibility_modifiers: "Index signature parameter cannot have accessibility modifiers.",
        Index_signature_parameter_cannot_have_a_question_mark: "Index signature parameter cannot have a question mark.",
        Index_signature_parameter_cannot_have_an_initializer: "Index signature parameter cannot have an initializer.",
        Index_signature_must_have_a_type_annotation: "Index signature must have a type annotation.",
        Index_signature_parameter_must_have_a_type_annotation: "Index signature parameter must have a type annotation.",
        Index_signature_parameter_type_must_be_string_or_number: "Index signature parameter type must be 'string' or 'number'.",
        extends_clause_already_seen: "'extends' clause already seen.",
        extends_clause_must_precede_implements_clause: "'extends' clause must precede 'implements' clause.",
        Classes_can_only_extend_a_single_class: "Classes can only extend a single class.",
        implements_clause_already_seen: "'implements' clause already seen.",
        Accessibility_modifier_already_seen: "Accessibility modifier already seen.",
        _0_modifier_must_precede_1_modifier: "'{0}' modifier must precede '{1}' modifier.",
        _0_modifier_already_seen: "'{0}' modifier already seen.",
        _0_modifier_cannot_appear_on_a_class_element: "'{0}' modifier cannot appear on a class element.",
        Interface_declaration_cannot_have_implements_clause: "Interface declaration cannot have 'implements' clause.",
        super_invocation_cannot_have_type_arguments: "'super' invocation cannot have type arguments.",
        Only_ambient_modules_can_use_quoted_names: "Only ambient modules can use quoted names.",
        Statements_are_not_allowed_in_ambient_contexts: "Statements are not allowed in ambient contexts.",
        Implementations_are_not_allowed_in_ambient_contexts: "Implementations are not allowed in ambient contexts.",
        declare_modifier_not_allowed_for_code_already_in_an_ambient_context: "'declare' modifier not allowed for code already in an ambient context.",
        Initializers_are_not_allowed_in_ambient_contexts: "Initializers are not allowed in ambient contexts.",
        Parameter_property_declarations_can_only_be_used_in_a_non_ambient_constructor_declaration: "Parameter property declarations can only be used in a non-ambient constructor declaration.",
        Function_implementation_expected: "Function implementation expected.",
        Constructor_implementation_expected: "Constructor implementation expected.",
        Function_overload_name_must_be_0: "Function overload name must be '{0}'.",
        _0_modifier_cannot_appear_on_a_module_element: "'{0}' modifier cannot appear on a module element.",
        declare_modifier_cannot_appear_on_an_interface_declaration: "'declare' modifier cannot appear on an interface declaration.",
        declare_modifier_required_for_top_level_element: "'declare' modifier required for top level element.",
        Rest_parameter_cannot_be_optional: "Rest parameter cannot be optional.",
        Rest_parameter_cannot_have_an_initializer: "Rest parameter cannot have an initializer.",
        set_accessor_must_have_one_and_only_one_parameter: "'set' accessor must have one and only one parameter.",
        set_accessor_parameter_cannot_be_optional: "'set' accessor parameter cannot be optional.",
        set_accessor_parameter_cannot_have_an_initializer: "'set' accessor parameter cannot have an initializer.",
        set_accessor_cannot_have_rest_parameter: "'set' accessor cannot have rest parameter.",
        get_accessor_cannot_have_parameters: "'get' accessor cannot have parameters.",
        Modifiers_cannot_appear_here: "Modifiers cannot appear here.",
        Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: "Accessors are only available when targeting ECMAScript 5 and higher.",
        Class_name_cannot_be_0: "Class name cannot be '{0}'.",
        Interface_name_cannot_be_0: "Interface name cannot be '{0}'.",
        Enum_name_cannot_be_0: "Enum name cannot be '{0}'.",
        Module_name_cannot_be_0: "Module name cannot be '{0}'.",
        Enum_member_must_have_initializer: "Enum member must have initializer.",
        Export_assignment_cannot_be_used_in_internal_modules: "Export assignment cannot be used in internal modules.",
        Export_assignment_not_allowed_in_module_with_exported_element: "Export assignment not allowed in module with exported element.",
        Module_cannot_have_multiple_export_assignments: "Module cannot have multiple export assignments.",
        Ambient_enum_elements_can_only_have_integer_literal_initializers: "Ambient enum elements can only have integer literal initializers.",
        module_class_interface_enum_import_or_statement: "module, class, interface, enum, import or statement",
        constructor_function_accessor_or_variable: "constructor, function, accessor or variable",
        statement: "statement",
        case_or_default_clause: "case or default clause",
        identifier: "identifier",
        call_construct_index_property_or_function_signature: "call, construct, index, property or function signature",
        expression: "expression",
        type_name: "type name",
        property_or_accessor: "property or accessor",
        parameter: "parameter",
        type: "type",
        type_parameter: "type parameter",
        declare_modifier_not_allowed_on_import_declaration: "'declare' modifier not allowed on import declaration.",
        Function_overload_must_be_static: "Function overload must be static.",
        Function_overload_must_not_be_static: "Function overload must not be static.",
        Parameter_property_declarations_cannot_be_used_in_a_constructor_overload: "Parameter property declarations cannot be used in a constructor overload.",
        Invalid_reference_directive_syntax: "Invalid 'reference' directive syntax.",
        Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher: "Octal literals are not available when targeting ECMAScript 5 and higher.",
        Accessors_are_not_allowed_in_ambient_contexts: "Accessors are not allowed in ambient contexts.",
        _0_modifier_cannot_appear_on_a_constructor_declaration: "'{0}' modifier cannot appear on a constructor declaration.",
        _0_modifier_cannot_appear_on_a_parameter: "'{0}' modifier cannot appear on a parameter.",
        Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: "Only a single variable declaration is allowed in a 'for...in' statement.",
        Type_parameters_cannot_appear_on_a_constructor_declaration: "Type parameters cannot appear on a constructor declaration.",
        Type_annotation_cannot_appear_on_a_constructor_declaration: "Type annotation cannot appear on a constructor declaration.",
        Duplicate_identifier_0: "Duplicate identifier '{0}'.",
        The_name_0_does_not_exist_in_the_current_scope: "The name '{0}' does not exist in the current scope.",
        The_name_0_does_not_refer_to_a_value: "The name '{0}' does not refer to a value.",
        super_can_only_be_used_inside_a_class_instance_method: "'super' can only be used inside a class instance method.",
        The_left_hand_side_of_an_assignment_expression_must_be_a_variable_property_or_indexer: "The left-hand side of an assignment expression must be a variable, property or indexer.",
        Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: "Value of type '{0}' is not callable. Did you mean to include 'new'?",
        Value_of_type_0_is_not_callable: "Value of type '{0}' is not callable.",
        Value_of_type_0_is_not_newable: "Value of type '{0}' is not newable.",
        Value_of_type_0_is_not_indexable_by_type_1: "Value of type '{0}' is not indexable by type '{1}'.",
        Operator_0_cannot_be_applied_to_types_1_and_2: "Operator '{0}' cannot be applied to types '{1}' and '{2}'.",
        Operator_0_cannot_be_applied_to_types_1_and_2_3: "Operator '{0}' cannot be applied to types '{1}' and '{2}': {3}",
        Cannot_convert_0_to_1: "Cannot convert '{0}' to '{1}'.",
        Cannot_convert_0_to_1_NL_2: "Cannot convert '{0}' to '{1}':{NL}{2}",
        Expected_var_class_interface_or_module: "Expected var, class, interface, or module.",
        Operator_0_cannot_be_applied_to_type_1: "Operator '{0}' cannot be applied to type '{1}'.",
        Getter_0_already_declared: "Getter '{0}' already declared.",
        Setter_0_already_declared: "Setter '{0}' already declared.",
        Exported_class_0_extends_private_class_1: "Exported class '{0}' extends private class '{1}'.",
        Exported_class_0_implements_private_interface_1: "Exported class '{0}' implements private interface '{1}'.",
        Exported_interface_0_extends_private_interface_1: "Exported interface '{0}' extends private interface '{1}'.",
        Exported_class_0_extends_class_from_inaccessible_module_1: "Exported class '{0}' extends class from inaccessible module {1}.",
        Exported_class_0_implements_interface_from_inaccessible_module_1: "Exported class '{0}' implements interface from inaccessible module {1}.",
        Exported_interface_0_extends_interface_from_inaccessible_module_1: "Exported interface '{0}' extends interface from inaccessible module {1}.",
        Public_static_property_0_of_exported_class_has_or_is_using_private_type_1: "Public static property '{0}' of exported class has or is using private type '{1}'.",
        Public_property_0_of_exported_class_has_or_is_using_private_type_1: "Public property '{0}' of exported class has or is using private type '{1}'.",
        Property_0_of_exported_interface_has_or_is_using_private_type_1: "Property '{0}' of exported interface has or is using private type '{1}'.",
        Exported_variable_0_has_or_is_using_private_type_1: "Exported variable '{0}' has or is using private type '{1}'.",
        Public_static_property_0_of_exported_class_is_using_inaccessible_module_1: "Public static property '{0}' of exported class is using inaccessible module {1}.",
        Public_property_0_of_exported_class_is_using_inaccessible_module_1: "Public property '{0}' of exported class is using inaccessible module {1}.",
        Property_0_of_exported_interface_is_using_inaccessible_module_1: "Property '{0}' of exported interface is using inaccessible module {1}.",
        Exported_variable_0_is_using_inaccessible_module_1: "Exported variable '{0}' is using inaccessible module {1}.",
        Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_type_1: "Parameter '{0}' of constructor from exported class has or is using private type '{1}'.",
        Parameter_0_of_public_static_property_setter_from_exported_class_has_or_is_using_private_type_1: "Parameter '{0}' of public static property setter from exported class has or is using private type '{1}'.",
        Parameter_0_of_public_property_setter_from_exported_class_has_or_is_using_private_type_1: "Parameter '{0}' of public property setter from exported class has or is using private type '{1}'.",
        Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_type_1: "Parameter '{0}' of constructor signature from exported interface has or is using private type '{1}'.",
        Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_type_1: "Parameter '{0}' of call signature from exported interface has or is using private type '{1}'.",
        Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_type_1: "Parameter '{0}' of public static method from exported class has or is using private type '{1}'.",
        Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_type_1: "Parameter '{0}' of public method from exported class has or is using private type '{1}'.",
        Parameter_0_of_method_from_exported_interface_has_or_is_using_private_type_1: "Parameter '{0}' of method from exported interface has or is using private type '{1}'.",
        Parameter_0_of_exported_function_has_or_is_using_private_type_1: "Parameter '{0}' of exported function has or is using private type '{1}'.",
        Parameter_0_of_constructor_from_exported_class_is_using_inaccessible_module_1: "Parameter '{0}' of constructor from exported class is using inaccessible module {1}.",
        Parameter_0_of_public_static_property_setter_from_exported_class_is_using_inaccessible_module_1: "Parameter '{0}' of public static property setter from exported class is using inaccessible module {1}.",
        Parameter_0_of_public_property_setter_from_exported_class_is_using_inaccessible_module_1: "Parameter '{0}' of public property setter from exported class is using inaccessible module {1}.",
        Parameter_0_of_constructor_signature_from_exported_interface_is_using_inaccessible_module_1: "Parameter '{0}' of constructor signature from exported interface is using inaccessible module {1}.",
        Parameter_0_of_call_signature_from_exported_interface_is_using_inaccessible_module_1: "Parameter '{0}' of call signature from exported interface is using inaccessible module {1}",
        Parameter_0_of_public_static_method_from_exported_class_is_using_inaccessible_module_1: "Parameter '{0}' of public static method from exported class is using inaccessible module {1}.",
        Parameter_0_of_public_method_from_exported_class_is_using_inaccessible_module_1: "Parameter '{0}' of public method from exported class is using inaccessible module {1}.",
        Parameter_0_of_method_from_exported_interface_is_using_inaccessible_module_1: "Parameter '{0}' of method from exported interface is using inaccessible module {1}.",
        Parameter_0_of_exported_function_is_using_inaccessible_module_1: "Parameter '{0}' of exported function is using inaccessible module {1}.",
        Return_type_of_public_static_property_getter_from_exported_class_has_or_is_using_private_type_0: "Return type of public static property getter from exported class has or is using private type '{0}'.",
        Return_type_of_public_property_getter_from_exported_class_has_or_is_using_private_type_0: "Return type of public property getter from exported class has or is using private type '{0}'.",
        Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_type_0: "Return type of constructor signature from exported interface has or is using private type '{0}'.",
        Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_type_0: "Return type of call signature from exported interface has or is using private type '{0}'.",
        Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_type_0: "Return type of index signature from exported interface has or is using private type '{0}'.",
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_type_0: "Return type of public static method from exported class has or is using private type '{0}'.",
        Return_type_of_public_method_from_exported_class_has_or_is_using_private_type_0: "Return type of public method from exported class has or is using private type '{0}'.",
        Return_type_of_method_from_exported_interface_has_or_is_using_private_type_0: "Return type of method from exported interface has or is using private type '{0}'.",
        Return_type_of_exported_function_has_or_is_using_private_type_0: "Return type of exported function has or is using private type '{0}'.",
        Return_type_of_public_static_property_getter_from_exported_class_is_using_inaccessible_module_0: "Return type of public static property getter from exported class is using inaccessible module {0}.",
        Return_type_of_public_property_getter_from_exported_class_is_using_inaccessible_module_0: "Return type of public property getter from exported class is using inaccessible module {0}.",
        Return_type_of_constructor_signature_from_exported_interface_is_using_inaccessible_module_0: "Return type of constructor signature from exported interface is using inaccessible module {0}.",
        Return_type_of_call_signature_from_exported_interface_is_using_inaccessible_module_0: "Return type of call signature from exported interface is using inaccessible module {0}.",
        Return_type_of_index_signature_from_exported_interface_is_using_inaccessible_module_0: "Return type of index signature from exported interface is using inaccessible module {0}.",
        Return_type_of_public_static_method_from_exported_class_is_using_inaccessible_module_0: "Return type of public static method from exported class is using inaccessible module {0}.",
        Return_type_of_public_method_from_exported_class_is_using_inaccessible_module_0: "Return type of public method from exported class is using inaccessible module {0}.",
        Return_type_of_method_from_exported_interface_is_using_inaccessible_module_0: "Return type of method from exported interface is using inaccessible module {0}.",
        Return_type_of_exported_function_is_using_inaccessible_module_0: "Return type of exported function is using inaccessible module {0}.",
        new_T_cannot_be_used_to_create_an_array_Use_new_Array_T_instead: "'new T[]' cannot be used to create an array. Use 'new Array<T>()' instead.",
        A_parameter_list_must_follow_a_generic_type_argument_list_expected: "A parameter list must follow a generic type argument list. '(' expected.",
        Multiple_constructor_implementations_are_not_allowed: "Multiple constructor implementations are not allowed.",
        Unable_to_resolve_external_module_0: "Unable to resolve external module '{0}'.",
        Module_cannot_be_aliased_to_a_non_module_type: "Module cannot be aliased to a non-module type.",
        A_class_may_only_extend_another_class: "A class may only extend another class.",
        A_class_may_only_implement_another_class_or_interface: "A class may only implement another class or interface.",
        An_interface_may_only_extend_another_class_or_interface: "An interface may only extend another class or interface.",
        Unable_to_resolve_type: "Unable to resolve type.",
        Unable_to_resolve_type_of_0: "Unable to resolve type of '{0}'.",
        Unable_to_resolve_type_parameter_constraint: "Unable to resolve type parameter constraint.",
        Type_parameter_constraint_cannot_be_a_primitive_type: "Type parameter constraint cannot be a primitive type.",
        Supplied_parameters_do_not_match_any_signature_of_call_target: "Supplied parameters do not match any signature of call target.",
        Supplied_parameters_do_not_match_any_signature_of_call_target_NL_0: "Supplied parameters do not match any signature of call target:{NL}{0}",
        Invalid_new_expression: "Invalid 'new' expression.",
        Call_signatures_used_in_a_new_expression_must_have_a_void_return_type: "Call signatures used in a 'new' expression must have a 'void' return type.",
        Could_not_select_overload_for_new_expression: "Could not select overload for 'new' expression.",
        Type_0_does_not_satisfy_the_constraint_1_for_type_parameter_2: "Type '{0}' does not satisfy the constraint '{1}' for type parameter '{2}'.",
        Could_not_select_overload_for_call_expression: "Could not select overload for 'call' expression.",
        Cannot_invoke_an_expression_whose_type_lacks_a_call_signature: "Cannot invoke an expression whose type lacks a call signature.",
        Calls_to_super_are_only_valid_inside_a_class: "Calls to 'super' are only valid inside a class.",
        Generic_type_0_requires_1_type_argument_s: "Generic type '{0}' requires {1} type argument(s).",
        Type_of_array_literal_cannot_be_determined_Best_common_type_could_not_be_found_for_array_elements: "Type of array literal cannot be determined. Best common type could not be found for array elements.",
        Could_not_find_enclosing_symbol_for_dotted_name_0: "Could not find enclosing symbol for dotted name '{0}'.",
        The_property_0_does_not_exist_on_value_of_type_1: "The property '{0}' does not exist on value of type '{1}'.",
        Could_not_find_symbol_0: "Could not find symbol '{0}'.",
        get_and_set_accessor_must_have_the_same_type: "'get' and 'set' accessor must have the same type.",
        this_cannot_be_referenced_in_current_location: "'this' cannot be referenced in current location.",
        Static_members_cannot_reference_class_type_parameters: "Static members cannot reference class type parameters.",
        Class_0_is_recursively_referenced_as_a_base_type_of_itself: "Class '{0}' is recursively referenced as a base type of itself.",
        Interface_0_is_recursively_referenced_as_a_base_type_of_itself: "Interface '{0}' is recursively referenced as a base type of itself.",
        super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class.",
        super_cannot_be_referenced_in_non_derived_classes: "'super' cannot be referenced in non-derived classes.",
        A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_or_has_parameter_properties: "A 'super' call must be the first statement in the constructor when a class contains initialized properties or has parameter properties.",
        Constructors_for_derived_classes_must_contain_a_super_call: "Constructors for derived classes must contain a 'super' call.",
        Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: "Super calls are not permitted outside constructors or in nested functions inside constructors.",
        _0_1_is_inaccessible: "'{0}.{1}' is inaccessible.",
        this_cannot_be_referenced_within_module_bodies: "'this' cannot be referenced within module bodies.",
        Invalid_expression_types_not_known_to_support_the_addition_operator: "Invalid '+' expression - types not known to support the addition operator.",
        The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type: "The right-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type.",
        The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type: "The left-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type.",
        The_type_of_a_unary_arithmetic_operation_operand_must_be_of_type_any_number_or_an_enum_type: "The type of a unary arithmetic operation operand must be of type 'any', 'number' or an enum type.",
        Variable_declarations_of_a_for_statement_cannot_use_a_type_annotation: "Variable declarations of a 'for' statement cannot use a type annotation.",
        Variable_declarations_of_a_for_statement_must_be_of_types_string_or_any: "Variable declarations of a 'for' statement must be of types 'string' or 'any'.",
        The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter: "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter.",
        The_left_hand_side_of_an_in_expression_must_be_of_types_any_string_or_number: "The left-hand side of an 'in' expression must be of types 'any', 'string' or 'number'.",
        The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: "The right-hand side of an 'in' expression must be of type 'any', an object type or a type parameter.",
        The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter.",
        The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type: "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type.",
        Setters_cannot_return_a_value: "Setters cannot return a value.",
        Tried_to_query_type_of_uninitialized_module_0: "Tried to query type of uninitialized module '{0}'.",
        Tried_to_set_variable_type_to_uninitialized_module_type_0: "Tried to set variable type to uninitialized module type '{0}'.",
        Type_0_does_not_have_type_parameters: "Type '{0}' does not have type parameters.",
        Getters_must_return_a_value: "Getters must return a value.",
        Getter_and_setter_accessors_do_not_agree_in_visibility: "Getter and setter accessors do not agree in visibility.",
        Invalid_left_hand_side_of_assignment_expression: "Invalid left-hand side of assignment expression.",
        Function_declared_a_non_void_return_type_but_has_no_return_expression: "Function declared a non-void return type, but has no return expression.",
        Cannot_resolve_return_type_reference: "Cannot resolve return type reference.",
        Constructors_cannot_have_a_return_type_of_void: "Constructors cannot have a return type of 'void'.",
        Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'.",
        All_symbols_within_a_with_block_will_be_resolved_to_any: "All symbols within a with block will be resolved to 'any'.",
        Import_declarations_in_an_internal_module_cannot_reference_an_external_module: "Import declarations in an internal module cannot reference an external module.",
        Class_0_declares_interface_1_but_does_not_implement_it_NL_2: "Class {0} declares interface {1} but does not implement it:{NL}{2}",
        Class_0_declares_class_1_as_an_interface_but_does_not_implement_it_NL_2: "Class {0} declares class {1} as an interface but does not implement it:{NL}{2}",
        The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_property_or_indexer: "The operand of an increment or decrement operator must be a variable, property or indexer.",
        this_cannot_be_referenced_in_static_initializers_in_a_class_body: "'this' cannot be referenced in static initializers in a class body.",
        Class_0_cannot_extend_class_1_NL_2: "Class '{0}' cannot extend class '{1}':{NL}{2}",
        Interface_0_cannot_extend_class_1_NL_2: "Interface '{0}' cannot extend class '{1}':{NL}{2}",
        Interface_0_cannot_extend_interface_1_NL_2: "Interface '{0}' cannot extend interface '{1}':{NL}{2}",
        Duplicate_overload_signature_for_0: "Duplicate overload signature for '{0}'.",
        Duplicate_constructor_overload_signature: "Duplicate constructor overload signature.",
        Duplicate_overload_call_signature: "Duplicate overload call signature.",
        Duplicate_overload_construct_signature: "Duplicate overload construct signature.",
        Overload_signature_is_not_compatible_with_function_definition: "Overload signature is not compatible with function definition.",
        Overload_signature_is_not_compatible_with_function_definition_NL_0: "Overload signature is not compatible with function definition:{NL}{0}",
        Overload_signatures_must_all_be_public_or_private: "Overload signatures must all be public or private.",
        Overload_signatures_must_all_be_exported_or_not_exported: "Overload signatures must all be exported or not exported.",
        Overload_signatures_must_all_be_ambient_or_non_ambient: "Overload signatures must all be ambient or non-ambient.",
        Overload_signatures_must_all_be_optional_or_required: "Overload signatures must all be optional or required.",
        Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature: "Specialized overload signature is not assignable to any non-specialized signature.",
        this_cannot_be_referenced_in_constructor_arguments: "'this' cannot be referenced in constructor arguments.",
        Instance_member_cannot_be_accessed_off_a_class: "Instance member cannot be accessed off a class.",
        Untyped_function_calls_may_not_accept_type_arguments: "Untyped function calls may not accept type arguments.",
        Non_generic_functions_may_not_accept_type_arguments: "Non-generic functions may not accept type arguments.",
        A_generic_type_may_not_reference_itself_with_a_wrapped_form_of_its_own_type_parameters: "A generic type may not reference itself with a wrapped form of its own type parameters.",
        Rest_parameters_must_be_array_types: "Rest parameters must be array types.",
        Overload_signature_implementation_cannot_use_specialized_type: "Overload signature implementation cannot use specialized type.",
        Export_assignments_may_only_be_used_at_the_top_level_of_external_modules: "Export assignments may only be used at the top-level of external modules.",
        Export_assignments_may_only_be_made_with_variables_functions_classes_interfaces_enums_and_internal_modules: "Export assignments may only be made with variables, functions, classes, interfaces, enums and internal modules.",
        Only_public_methods_of_the_base_class_are_accessible_via_the_super_keyword: "Only public methods of the base class are accessible via the 'super' keyword.",
        Numeric_indexer_type_0_must_be_assignable_to_string_indexer_type_1: "Numeric indexer type '{0}' must be assignable to string indexer type '{1}'.",
        Numeric_indexer_type_0_must_be_assignable_to_string_indexer_type_1_NL_2: "Numeric indexer type '{0}' must be assignable to string indexer type '{1}':{NL}{2}",
        All_numerically_named_properties_must_be_assignable_to_numeric_indexer_type_0: "All numerically named properties must be assignable to numeric indexer type '{0}'.",
        All_numerically_named_properties_must_be_assignable_to_numeric_indexer_type_0_NL_1: "All numerically named properties must be assignable to numeric indexer type '{0}':{NL}{1}",
        All_named_properties_must_be_assignable_to_string_indexer_type_0: "All named properties must be assignable to string indexer type '{0}'.",
        All_named_properties_must_be_assignable_to_string_indexer_type_0_NL_1: "All named properties must be assignable to string indexer type '{0}':{NL}{1}",
        Generic_type_references_must_include_all_type_arguments: "Generic type references must include all type arguments.",
        Default_arguments_are_only_allowed_in_implementation: "Default arguments are only allowed in implementation.",
        Overloads_cannot_differ_only_by_return_type: "Overloads cannot differ only by return type.",
        Function_expression_declared_a_non_void_return_type_but_has_no_return_expression: "Function expression declared a non-void return type, but has no return expression.",
        Import_declaration_referencing_identifier_from_internal_module_can_only_be_made_with_variables_functions_classes_interfaces_enums_and_internal_modules: "Import declaration referencing identifier from internal module can only be made with variables, functions, classes, interfaces, enums and internal modules.",
        Could_not_find_symbol_0_in_module_1: "Could not find symbol '{0}' in module '{1}'.",
        Unable_to_resolve_module_reference_0: "Unable to resolve module reference '{0}'.",
        Could_not_find_module_0_in_module_1: "Could not find module '{0}' in module '{1}'.",
        Exported_import_declaration_0_is_assigned_value_with_type_that_has_or_is_using_private_type_1: "Exported import declaration '{0}' is assigned value with type that has or is using private type '{1}'.",
        Exported_import_declaration_0_is_assigned_value_with_type_that_is_using_inaccessible_module_1: "Exported import declaration '{0}' is assigned value with type that is using inaccessible module '{1}'.",
        Exported_import_declaration_0_is_assigned_type_that_has_or_is_using_private_type_1: "Exported import declaration '{0}' is assigned type that has or is using private type '{1}'.",
        Exported_import_declaration_0_is_assigned_type_that_is_using_inaccessible_module_1: "Exported import declaration '{0}' is assigned type that is using inaccessible module '{1}'.",
        Exported_import_declaration_0_is_assigned_container_that_is_or_is_using_inaccessible_module_1: "Exported import declaration '{0}' is assigned container that is or is using inaccessible module '{1}'.",
        Type_name_0_in_extends_clause_does_not_reference_constructor_function_for_1: "Type name '{0}' in extends clause does not reference constructor function for '{1}'.",
        Internal_module_reference_0_in_import_declaration_does_not_reference_module_instance_for_1: "Internal module reference '{0}' in import declaration does not reference module instance for '{1}'.",
        Module_0_cannot_merge_with_previous_declaration_of_1_in_a_different_file_2: "Module '{0}' cannot merge with previous declaration of '{1}' in a different file '{2}'.",
        Interface_0_cannot_simultaneously_extend_types_1_and_2_NL_3: "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}':{NL}{3}",
        Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it: "Initializer of parameter '{0}' cannot reference identifier '{1}' declared after it.",
        Ambient_external_module_declaration_cannot_be_reopened: "Ambient external module declaration cannot be reopened.",
        All_declarations_of_merged_declaration_0_must_be_exported_or_not_exported: "All declarations of merged declaration '{0}' must be exported or not exported.",
        super_cannot_be_referenced_in_constructor_arguments: "'super' cannot be referenced in constructor arguments.",
        Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: "Return type of constructor signature must be assignable to the instance type of the class.",
        Ambient_external_module_declaration_must_be_defined_in_global_context: "Ambient external module declaration must be defined in global context.",
        Ambient_external_module_declaration_cannot_specify_relative_module_name: "Ambient external module declaration cannot specify relative module name.",
        Import_declaration_in_an_ambient_external_module_declaration_cannot_reference_external_module_through_relative_external_module_name: "Import declaration in an ambient external module declaration cannot reference external module through relative external module name.",
        Could_not_find_the_best_common_type_of_types_of_all_return_statement_expressions: "Could not find the best common type of types of all return statement expressions.",
        Import_declaration_cannot_refer_to_external_module_reference_when_noResolve_option_is_set: "Import declaration cannot refer to external module reference when --noResolve option is set.",
        Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference.",
        continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: "'continue' statement can only be used within an enclosing iteration statement.",
        break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: "'break' statement can only be used within an enclosing iteration or switch statement.",
        Jump_target_not_found: "Jump target not found.",
        Jump_target_cannot_cross_function_boundary: "Jump target cannot cross function boundary.",
        Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference: "Duplicate identifier '_super'. Compiler uses '_super' to capture base class reference.",
        Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference.",
        Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: "Expression resolves to '_super' that compiler uses to capture base class reference.",
        TypeParameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_type_1: "TypeParameter '{0}' of constructor signature from exported interface has or is using private type '{1}'.",
        TypeParameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_type_1: "TypeParameter '{0}' of call signature from exported interface has or is using private type '{1}'.",
        TypeParameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_type_1: "TypeParameter '{0}' of public static method from exported class has or is using private type '{1}'.",
        TypeParameter_0_of_public_method_from_exported_class_has_or_is_using_private_type_1: "TypeParameter '{0}' of public method from exported class has or is using private type '{1}'.",
        TypeParameter_0_of_method_from_exported_interface_has_or_is_using_private_type_1: "TypeParameter '{0}' of method from exported interface has or is using private type '{1}'.",
        TypeParameter_0_of_exported_function_has_or_is_using_private_type_1: "TypeParameter '{0}' of exported function has or is using private type '{1}'.",
        TypeParameter_0_of_constructor_signature_from_exported_interface_is_using_inaccessible_module_1: "TypeParameter '{0}' of constructor signature from exported interface is using inaccessible module {1}.",
        TypeParameter_0_of_call_signature_from_exported_interface_is_using_inaccessible_module_1: "TypeParameter '{0}' of call signature from exported interface is using inaccessible module {1}",
        TypeParameter_0_of_public_static_method_from_exported_class_is_using_inaccessible_module_1: "TypeParameter '{0}' of public static method from exported class is using inaccessible module {1}.",
        TypeParameter_0_of_public_method_from_exported_class_is_using_inaccessible_module_1: "TypeParameter '{0}' of public method from exported class is using inaccessible module {1}.",
        TypeParameter_0_of_method_from_exported_interface_is_using_inaccessible_module_1: "TypeParameter '{0}' of method from exported interface is using inaccessible module {1}.",
        TypeParameter_0_of_exported_function_is_using_inaccessible_module_1: "TypeParameter '{0}' of exported function is using inaccessible module {1}.",
        TypeParameter_0_of_exported_class_has_or_is_using_private_type_1: "TypeParameter '{0}' of exported class has or is using private type '{1}'.",
        TypeParameter_0_of_exported_interface_has_or_is_using_private_type_1: "TypeParameter '{0}' of exported interface has or is using private type '{1}'.",
        TypeParameter_0_of_exported_class_is_using_inaccessible_module_1: "TypeParameter '{0}' of exported class is using inaccessible module {1}.",
        TypeParameter_0_of_exported_interface_is_using_inaccessible_module_1: "TypeParameter '{0}' of exported interface is using inaccessible module {1}.",
        Duplicate_identifier_i_Compiler_uses_i_to_initialize_rest_parameter: "Duplicate identifier '_i'. Compiler uses '_i' to initialize rest parameter.",
        Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters.",
        Type_of_conditional_0_must_be_identical_to_1_or_2: "Type of conditional '{0}' must be identical to '{1}' or '{2}'.",
        Type_of_conditional_0_must_be_identical_to_1_2_or_3: "Type of conditional '{0}' must be identical to '{1}', '{2}' or '{3}'.",
        Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_an_external_module: "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of an external module.",
        Constraint_of_a_type_parameter_cannot_reference_any_type_parameter_from_the_same_type_parameter_list: "Constraint of a type parameter cannot reference any type parameter from the same type parameter list.",
        Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor.",
        Parameter_0_cannot_be_referenced_in_its_initializer: "Parameter '{0}' cannot be referenced in its initializer.",
        Duplicate_string_index_signature: "Duplicate string index signature.",
        Duplicate_number_index_signature: "Duplicate number index signature.",
        All_declarations_of_an_interface_must_have_identical_type_parameters: "All declarations of an interface must have identical type parameters.",
        Expression_resolves_to_variable_declaration_i_that_compiler_uses_to_initialize_rest_parameter: "Expression resolves to variable declaration '_i' that compiler uses to initialize rest parameter.",
        Type_0_is_missing_property_1_from_type_2: "Type '{0}' is missing property '{1}' from type '{2}'.",
        Types_of_property_0_of_types_1_and_2_are_incompatible: "Types of property '{0}' of types '{1}' and '{2}' are incompatible.",
        Types_of_property_0_of_types_1_and_2_are_incompatible_NL_3: "Types of property '{0}' of types '{1}' and '{2}' are incompatible:{NL}{3}",
        Property_0_defined_as_private_in_type_1_is_defined_as_public_in_type_2: "Property '{0}' defined as private in type '{1}' is defined as public in type '{2}'.",
        Property_0_defined_as_public_in_type_1_is_defined_as_private_in_type_2: "Property '{0}' defined as public in type '{1}' is defined as private in type '{2}'.",
        Types_0_and_1_define_property_2_as_private: "Types '{0}' and '{1}' define property '{2}' as private.",
        Call_signatures_of_types_0_and_1_are_incompatible: "Call signatures of types '{0}' and '{1}' are incompatible.",
        Call_signatures_of_types_0_and_1_are_incompatible_NL_2: "Call signatures of types '{0}' and '{1}' are incompatible:{NL}{2}",
        Type_0_requires_a_call_signature_but_type_1_lacks_one: "Type '{0}' requires a call signature, but type '{1}' lacks one.",
        Construct_signatures_of_types_0_and_1_are_incompatible: "Construct signatures of types '{0}' and '{1}' are incompatible.",
        Construct_signatures_of_types_0_and_1_are_incompatible_NL_2: "Construct signatures of types '{0}' and '{1}' are incompatible:{NL}{2}",
        Type_0_requires_a_construct_signature_but_type_1_lacks_one: "Type '{0}' requires a construct signature, but type '{1}' lacks one.",
        Index_signatures_of_types_0_and_1_are_incompatible: "Index signatures of types '{0}' and '{1}' are incompatible.",
        Index_signatures_of_types_0_and_1_are_incompatible_NL_2: "Index signatures of types '{0}' and '{1}' are incompatible:{NL}{2}",
        Call_signature_expects_0_or_fewer_parameters: "Call signature expects {0} or fewer parameters.",
        Could_not_apply_type_0_to_argument_1_which_is_of_type_2: "Could not apply type '{0}' to argument {1} which is of type '{2}'.",
        Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function.",
        Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function.",
        Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor.",
        Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_property: "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member property.",
        Types_of_static_property_0_of_class_1_and_class_2_are_incompatible: "Types of static property '{0}' of class '{1}' and class '{2}' are incompatible.",
        Types_of_static_property_0_of_class_1_and_class_2_are_incompatible_NL_3: "Types of static property '{0}' of class '{1}' and class '{2}' are incompatible:{NL}{3}",
        Type_reference_cannot_refer_to_container_0: "Type reference cannot refer to container '{0}'.",
        Type_reference_must_refer_to_type: "Type reference must refer to type.",
        In_enums_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_the_first_enum_element: "In enums with multiple declarations only one declaration can omit an initializer for the first enum element.",
        _0_overload_s: " (+ {0} overload(s))",
        Variable_declaration_cannot_have_the_same_name_as_an_import_declaration: "Variable declaration cannot have the same name as an import declaration.",
        Signature_expected_0_type_arguments_got_1_instead: "Signature expected {0} type arguments, got {1} instead.",
        Property_0_defined_as_optional_in_type_1_but_is_required_in_type_2: "Property '{0}' defined as optional in type '{1}', but is required in type '{2}'.",
        Types_0_and_1_originating_in_infinitely_expanding_type_reference_do_not_refer_to_same_named_type: "Types '{0}' and '{1}' originating in infinitely expanding type reference do not refer to same named type.",
        Types_0_and_1_originating_in_infinitely_expanding_type_reference_have_incompatible_type_arguments: "Types '{0}' and '{1}' originating in infinitely expanding type reference have incompatible type arguments.",
        Types_0_and_1_originating_in_infinitely_expanding_type_reference_have_incompatible_type_arguments_NL_2: "Types '{0}' and '{1}' originating in infinitely expanding type reference have incompatible type arguments:{NL}{2}",
        Named_properties_0_of_types_1_and_2_are_not_identical: "Named properties '{0}' of types '{1}' and '{2}' are not identical.",
        Types_of_string_indexer_of_types_0_and_1_are_not_identical: "Types of string indexer of types '{0}' and '{1}' are not identical.",
        Types_of_number_indexer_of_types_0_and_1_are_not_identical: "Types of number indexer of types '{0}' and '{1}' are not identical.",
        Type_of_number_indexer_in_type_0_is_not_assignable_to_string_indexer_type_in_type_1_NL_2: "Type of number indexer in type '{0}' is not assignable to string indexer type in type '{1}'.{NL}{2}",
        Type_of_property_0_in_type_1_is_not_assignable_to_string_indexer_type_in_type_2_NL_3: "Type of property '{0}' in type '{1}' is not assignable to string indexer type in type '{2}'.{NL}{3}",
        Type_of_property_0_in_type_1_is_not_assignable_to_number_indexer_type_in_type_2_NL_3: "Type of property '{0}' in type '{1}' is not assignable to number indexer type in type '{2}'.{NL}{3}",
        Static_property_0_defined_as_private_in_type_1_is_defined_as_public_in_type_2: "Static property '{0}' defined as private in type '{1}' is defined as public in type '{2}'.",
        Static_property_0_defined_as_public_in_type_1_is_defined_as_private_in_type_2: "Static property '{0}' defined as public in type '{1}' is defined as private in type '{2}'.",
        Types_0_and_1_define_static_property_2_as_private: "Types '{0}' and '{1}' define static property '{2}' as private.",
        Current_host_does_not_support_0_option: "Current host does not support '{0}' option.",
        ECMAScript_target_version_0_not_supported_Specify_a_valid_target_version_1_default_or_2: "ECMAScript target version '{0}' not supported.  Specify a valid target version: '{1}' (default), or '{2}'",
        Module_code_generation_0_not_supported: "Module code generation '{0}' not supported.",
        Could_not_find_file_0: "Could not find file: '{0}'.",
        A_file_cannot_have_a_reference_to_itself: "A file cannot have a reference to itself.",
        Cannot_resolve_referenced_file_0: "Cannot resolve referenced file: '{0}'.",
        Cannot_find_the_common_subdirectory_path_for_the_input_files: "Cannot find the common subdirectory path for the input files.",
        Emit_Error_0: "Emit Error: {0}.",
        Cannot_read_file_0_1: "Cannot read file '{0}': {1}",
        Unsupported_file_encoding: "Unsupported file encoding.",
        Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1: "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'.",
        Unsupported_locale_0: "Unsupported locale: '{0}'.",
        Execution_Failed_NL: "Execution Failed.{NL}",
        Invalid_call_to_up: "Invalid call to 'up'",
        Invalid_call_to_down: "Invalid call to 'down'",
        Base64_value_0_finished_with_a_continuation_bit: "Base64 value '{0}' finished with a continuation bit.",
        Unknown_option_0: "Unknown option '{0}'",
        Expected_0_arguments_to_message_got_1_instead: "Expected {0} arguments to message, got {1} instead.",
        Expected_the_message_0_to_have_1_arguments_but_it_had_2: "Expected the message '{0}' to have {1} arguments, but it had {2}",
        Could_not_delete_file_0: "Could not delete file '{0}'",
        Could_not_create_directory_0: "Could not create directory '{0}'",
        Error_while_executing_file_0: "Error while executing file '{0}': ",
        Cannot_compile_external_modules_unless_the_module_flag_is_provided: "Cannot compile external modules unless the '--module' flag is provided.",
        Option_mapRoot_cannot_be_specified_without_specifying_sourcemap_option: "Option mapRoot cannot be specified without specifying sourcemap option.",
        Option_sourceRoot_cannot_be_specified_without_specifying_sourcemap_option: "Option sourceRoot cannot be specified without specifying sourcemap option.",
        Options_mapRoot_and_sourceRoot_cannot_be_specified_without_specifying_sourcemap_option: "Options mapRoot and sourceRoot cannot be specified without specifying sourcemap option.",
        Option_0_specified_without_1: "Option '{0}' specified without '{1}'",
        codepage_option_not_supported_on_current_platform: "'codepage' option not supported on current platform.",
        Concatenate_and_emit_output_to_single_file: "Concatenate and emit output to single file.",
        Generates_corresponding_0_file: "Generates corresponding {0} file.",
        Specifies_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations: "Specifies the location where debugger should locate map files instead of generated locations.",
        Specifies_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: "Specifies the location where debugger should locate TypeScript files instead of source locations.",
        Watch_input_files: "Watch input files.",
        Redirect_output_structure_to_the_directory: "Redirect output structure to the directory.",
        Do_not_emit_comments_to_output: "Do not emit comments to output.",
        Skip_resolution_and_preprocessing: "Skip resolution and preprocessing.",
        Specify_ECMAScript_target_version_0_default_or_1: "Specify ECMAScript target version: '{0}' (default), or '{1}'",
        Specify_module_code_generation_0_or_1: "Specify module code generation: '{0}' or '{1}'",
        Print_this_message: "Print this message.",
        Print_the_compiler_s_version_0: "Print the compiler's version: {0}",
        Allow_use_of_deprecated_0_keyword_when_referencing_an_external_module: "Allow use of deprecated '{0}' keyword when referencing an external module.",
        Specify_locale_for_errors_and_messages_For_example_0_or_1: "Specify locale for errors and messages. For example '{0}' or '{1}'",
        Syntax_0: "Syntax:   {0}",
        options: "options",
        file1: "file",
        Examples: "Examples:",
        Options: "Options:",
        Insert_command_line_options_and_files_from_a_file: "Insert command line options and files from a file.",
        Version_0: "Version {0}",
        Use_the_0_flag_to_see_options: "Use the '{0}' flag to see options.",
        NL_Recompiling_0: "{NL}Recompiling ({0}):",
        STRING: "STRING",
        KIND: "KIND",
        file2: "FILE",
        VERSION: "VERSION",
        LOCATION: "LOCATION",
        DIRECTORY: "DIRECTORY",
        NUMBER: "NUMBER",
        Specify_the_codepage_to_use_when_opening_source_files: "Specify the codepage to use when opening source files.",
        Additional_locations: "Additional locations:",
        This_version_of_the_Javascript_runtime_does_not_support_the_0_function: "This version of the Javascript runtime does not support the '{0}' function.",
        Unknown_rule: "Unknown rule.",
        Invalid_line_number_0: "Invalid line number ({0})",
        Warn_on_expressions_and_declarations_with_an_implied_any_type: "Warn on expressions and declarations with an implied 'any' type.",
        Variable_0_implicitly_has_an_any_type: "Variable '{0}' implicitly has an 'any' type.",
        Parameter_0_of_1_implicitly_has_an_any_type: "Parameter '{0}' of '{1}' implicitly has an 'any' type.",
        Parameter_0_of_function_type_implicitly_has_an_any_type: "Parameter '{0}' of function type implicitly has an 'any' type.",
        Member_0_of_object_type_implicitly_has_an_any_type: "Member '{0}' of object type implicitly has an 'any' type.",
        new_expression_which_lacks_a_constructor_signature_implicitly_has_an_any_type: "'new' expression, which lacks a constructor signature, implicitly has an 'any' type.",
        _0_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: "'{0}', which lacks return-type annotation, implicitly has an 'any' return type.",
        Function_expression_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: "Function expression, which lacks return-type annotation, implicitly has an 'any' return type.",
        Parameter_0_of_lambda_function_implicitly_has_an_any_type: "Parameter '{0}' of lambda function implicitly has an 'any' type.",
        Constructor_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: "Constructor signature, which lacks return-type annotation, implicitly has an 'any' return type.",
        Lambda_Function_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: "Lambda Function, which lacks return-type annotation, implicitly has an 'any' return type.",
        Array_Literal_implicitly_has_an_any_type_from_widening: "Array Literal implicitly has an 'any' type from widening.",
        _0_which_lacks_get_accessor_and_parameter_type_annotation_on_set_accessor_implicitly_has_an_any_type: "'{0}', which lacks 'get' accessor and parameter type annotation on 'set' accessor, implicitly has an 'any' type.",
        Index_signature_of_object_type_implicitly_has_an_any_type: "Index signature of object type implicitly has an 'any' type.",
        Object_literal_s_property_0_implicitly_has_an_any_type_from_widening: "Object literal's property '{0}' implicitly has an 'any' type from widening."
    };
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var ArrayUtilities = (function () {
        function ArrayUtilities() {
        }
        ArrayUtilities.isArray = function (value) {
            return Object.prototype.toString.apply(value, []) === '[object Array]';
        };

        ArrayUtilities.sequenceEquals = function (array1, array2, equals) {
            if (array1 === array2) {
                return true;
            }

            if (array1 === null || array2 === null) {
                return false;
            }

            if (array1.length !== array2.length) {
                return false;
            }

            for (var i = 0, n = array1.length; i < n; i++) {
                if (!equals(array1[i], array2[i])) {
                    return false;
                }
            }

            return true;
        };

        ArrayUtilities.contains = function (array, value) {
            for (var i = 0; i < array.length; i++) {
                if (array[i] === value) {
                    return true;
                }
            }

            return false;
        };

        ArrayUtilities.groupBy = function (array, func) {
            var result = {};

            for (var i = 0, n = array.length; i < n; i++) {
                var v = array[i];
                var k = func(v);

                var list = result[k] || [];
                list.push(v);
                result[k] = list;
            }

            return result;
        };

        ArrayUtilities.distinct = function (array, equalsFn) {
            var result = [];

            for (var i = 0, n = array.length; i < n; i++) {
                var current = array[i];
                for (var j = 0; j < result.length; j++) {
                    if (equalsFn(result[j], current)) {
                        break;
                    }
                }

                if (j === result.length) {
                    result.push(current);
                }
            }

            return result;
        };

        ArrayUtilities.min = function (array, func) {
            var min = func(array[0]);

            for (var i = 1; i < array.length; i++) {
                var next = func(array[i]);
                if (next < min) {
                    min = next;
                }
            }

            return min;
        };

        ArrayUtilities.max = function (array, func) {
            var max = func(array[0]);

            for (var i = 1; i < array.length; i++) {
                var next = func(array[i]);
                if (next > max) {
                    max = next;
                }
            }

            return max;
        };

        ArrayUtilities.last = function (array) {
            if (array.length === 0) {
                throw TypeScript.Errors.argumentOutOfRange('array');
            }

            return array[array.length - 1];
        };

        ArrayUtilities.lastOrDefault = function (array, predicate) {
            for (var i = array.length - 1; i >= 0; i--) {
                var v = array[i];
                if (predicate(v, i)) {
                    return v;
                }
            }

            return null;
        };

        ArrayUtilities.firstOrDefault = function (array, func) {
            for (var i = 0, n = array.length; i < n; i++) {
                var value = array[i];
                if (func(value, i)) {
                    return value;
                }
            }

            return null;
        };

        ArrayUtilities.first = function (array, func) {
            for (var i = 0, n = array.length; i < n; i++) {
                var value = array[i];
                if (!func || func(value, i)) {
                    return value;
                }
            }

            throw TypeScript.Errors.invalidOperation();
        };

        ArrayUtilities.sum = function (array, func) {
            var result = 0;

            for (var i = 0, n = array.length; i < n; i++) {
                result += func(array[i]);
            }

            return result;
        };

        ArrayUtilities.select = function (values, func) {
            var result = new Array(values.length);

            for (var i = 0; i < values.length; i++) {
                result[i] = func(values[i]);
            }

            return result;
        };

        ArrayUtilities.where = function (values, func) {
            var result = new Array();

            for (var i = 0; i < values.length; i++) {
                if (func(values[i])) {
                    result.push(values[i]);
                }
            }

            return result;
        };

        ArrayUtilities.any = function (array, func) {
            for (var i = 0, n = array.length; i < n; i++) {
                if (func(array[i])) {
                    return true;
                }
            }

            return false;
        };

        ArrayUtilities.all = function (array, func) {
            for (var i = 0, n = array.length; i < n; i++) {
                if (!func(array[i])) {
                    return false;
                }
            }

            return true;
        };

        ArrayUtilities.binarySearch = function (array, value) {
            var low = 0;
            var high = array.length - 1;

            while (low <= high) {
                var middle = low + ((high - low) >> 1);
                var midValue = array[middle];

                if (midValue === value) {
                    return middle;
                } else if (midValue > value) {
                    high = middle - 1;
                } else {
                    low = middle + 1;
                }
            }

            return ~low;
        };

        ArrayUtilities.createArray = function (length, defaultValue) {
            var result = new Array(length);
            for (var i = 0; i < length; i++) {
                result[i] = defaultValue;
            }

            return result;
        };

        ArrayUtilities.grow = function (array, length, defaultValue) {
            var count = length - array.length;
            for (var i = 0; i < count; i++) {
                array.push(defaultValue);
            }
        };

        ArrayUtilities.copy = function (sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
            for (var i = 0; i < length; i++) {
                destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
            }
        };

        ArrayUtilities.indexOf = function (array, predicate) {
            for (var i = 0, n = array.length; i < n; i++) {
                if (predicate(array[i])) {
                    return i;
                }
            }

            return -1;
        };
        return ArrayUtilities;
    })();
    TypeScript.ArrayUtilities = ArrayUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (BitVector) {
        var pool = [];
        var Constants;
        (function (Constants) {
            Constants[Constants["MaxBitsPerEncodedNumber"] = 30] = "MaxBitsPerEncodedNumber";
            Constants[Constants["BitsPerEncodedBiStateValue"] = 1] = "BitsPerEncodedBiStateValue";

            Constants[Constants["BitsPerEncodedTriStateValue"] = 2] = "BitsPerEncodedTriStateValue";

            Constants[Constants["BiStateEncodedTrue"] = 1] = "BiStateEncodedTrue";
            Constants[Constants["BiStateClearBitsMask"] = 1] = "BiStateClearBitsMask";

            Constants[Constants["TriStateEncodedFalse"] = 1] = "TriStateEncodedFalse";
            Constants[Constants["TriStateEncodedTrue"] = 2] = "TriStateEncodedTrue";
            Constants[Constants["TriStateClearBitsMask"] = 3] = "TriStateClearBitsMask";
        })(Constants || (Constants = {}));

        var BitVectorImpl = (function () {
            function BitVectorImpl(allowUndefinedValues) {
                this.allowUndefinedValues = allowUndefinedValues;
                this.isReleased = false;
                this.bits = [];
            }
            BitVectorImpl.prototype.computeTriStateArrayIndex = function (index) {
                var encodedValuesPerNumber = 30 /* MaxBitsPerEncodedNumber */ / 2 /* BitsPerEncodedTriStateValue */;

                return (index / encodedValuesPerNumber) >>> 0;
            };

            BitVectorImpl.prototype.computeBiStateArrayIndex = function (index) {
                var encodedValuesPerNumber = 30 /* MaxBitsPerEncodedNumber */ / 1 /* BitsPerEncodedBiStateValue */;

                return (index / encodedValuesPerNumber) >>> 0;
            };

            BitVectorImpl.prototype.computeTriStateEncodedValueIndex = function (index) {
                var encodedValuesPerNumber = 30 /* MaxBitsPerEncodedNumber */ / 2 /* BitsPerEncodedTriStateValue */;

                return (index % encodedValuesPerNumber) * 2 /* BitsPerEncodedTriStateValue */;
            };

            BitVectorImpl.prototype.computeBiStateEncodedValueIndex = function (index) {
                var encodedValuesPerNumber = 30 /* MaxBitsPerEncodedNumber */ / 1 /* BitsPerEncodedBiStateValue */;

                return (index % encodedValuesPerNumber) * 1 /* BitsPerEncodedBiStateValue */;
            };

            BitVectorImpl.prototype.valueAt = function (index) {
                TypeScript.Debug.assert(!this.isReleased, "Should not use a released bitvector");
                if (this.allowUndefinedValues) {
                    var arrayIndex = this.computeTriStateArrayIndex(index);
                    var encoded = this.bits[arrayIndex];
                    if (encoded === undefined) {
                        return undefined;
                    }

                    var bitIndex = this.computeTriStateEncodedValueIndex(index);
                    if (encoded & (2 /* TriStateEncodedTrue */ << bitIndex)) {
                        return true;
                    } else if (encoded & (1 /* TriStateEncodedFalse */ << bitIndex)) {
                        return false;
                    } else {
                        return undefined;
                    }
                } else {
                    var arrayIndex = this.computeBiStateArrayIndex(index);
                    var encoded = this.bits[arrayIndex];
                    if (encoded === undefined) {
                        return false;
                    }

                    var bitIndex = this.computeBiStateEncodedValueIndex(index);
                    if (encoded & (1 /* BiStateEncodedTrue */ << bitIndex)) {
                        return true;
                    } else {
                        return false;
                    }
                }
            };

            BitVectorImpl.prototype.setValueAt = function (index, value) {
                TypeScript.Debug.assert(!this.isReleased, "Should not use a released bitvector");
                if (this.allowUndefinedValues) {
                    TypeScript.Debug.assert(value === true || value === false || value === undefined, "value must only be true, false or undefined.");

                    var arrayIndex = this.computeTriStateArrayIndex(index);
                    var encoded = this.bits[arrayIndex];
                    if (encoded === undefined) {
                        if (value === undefined) {
                            return;
                        }

                        encoded = 0;
                    }

                    var bitIndex = this.computeTriStateEncodedValueIndex(index);

                    var clearMask = ~(3 /* TriStateClearBitsMask */ << bitIndex);
                    encoded = encoded & clearMask;

                    if (value === true) {
                        encoded = encoded | (2 /* TriStateEncodedTrue */ << bitIndex);
                    } else if (value === false) {
                        encoded = encoded | (1 /* TriStateEncodedFalse */ << bitIndex);
                    }

                    this.bits[arrayIndex] = encoded;
                } else {
                    TypeScript.Debug.assert(value === true || value === false, "value must only be true or false.");

                    var arrayIndex = this.computeBiStateArrayIndex(index);
                    var encoded = this.bits[arrayIndex];
                    if (encoded === undefined) {
                        if (value === false) {
                            return;
                        }

                        encoded = 0;
                    }

                    var bitIndex = this.computeBiStateEncodedValueIndex(index);

                    encoded = encoded & ~(1 /* BiStateClearBitsMask */ << bitIndex);

                    if (value) {
                        encoded = encoded | (1 /* BiStateEncodedTrue */ << bitIndex);
                    }

                    this.bits[arrayIndex] = encoded;
                }
            };

            BitVectorImpl.prototype.release = function () {
                TypeScript.Debug.assert(!this.isReleased, "Should not use a released bitvector");
                this.isReleased = true;
                this.bits.length = 0;
                pool.push(this);
            };
            return BitVectorImpl;
        })();

        function getBitVector(allowUndefinedValues) {
            if (pool.length === 0) {
                return new BitVectorImpl(allowUndefinedValues);
            }

            var vector = pool.pop();
            vector.isReleased = false;
            vector.allowUndefinedValues = allowUndefinedValues;

            return vector;
        }
        BitVector.getBitVector = getBitVector;
    })(TypeScript.BitVector || (TypeScript.BitVector = {}));
    var BitVector = TypeScript.BitVector;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (BitMatrix) {
        var pool = [];

        var BitMatrixImpl = (function () {
            function BitMatrixImpl(allowUndefinedValues) {
                this.allowUndefinedValues = allowUndefinedValues;
                this.isReleased = false;
                this.vectors = [];
            }
            BitMatrixImpl.prototype.valueAt = function (x, y) {
                TypeScript.Debug.assert(!this.isReleased, "Should not use a released bitvector");
                var vector = this.vectors[x];
                if (!vector) {
                    return this.allowUndefinedValues ? undefined : false;
                }

                return vector.valueAt(y);
            };

            BitMatrixImpl.prototype.setValueAt = function (x, y, value) {
                TypeScript.Debug.assert(!this.isReleased, "Should not use a released bitvector");
                var vector = this.vectors[x];
                if (!vector) {
                    if (value === undefined) {
                        return;
                    }

                    vector = TypeScript.BitVector.getBitVector(this.allowUndefinedValues);
                    this.vectors[x] = vector;
                }

                vector.setValueAt(y, value);
            };

            BitMatrixImpl.prototype.release = function () {
                TypeScript.Debug.assert(!this.isReleased, "Should not use a released bitvector");
                this.isReleased = true;

                for (var name in this.vectors) {
                    if (this.vectors.hasOwnProperty(name)) {
                        var vector = this.vectors[name];
                        vector.release();
                    }
                }

                this.vectors.length = 0;
                pool.push(this);
            };
            return BitMatrixImpl;
        })();

        function getBitMatrix(allowUndefinedValues) {
            if (pool.length === 0) {
                return new BitMatrixImpl(allowUndefinedValues);
            }

            var matrix = pool.pop();
            matrix.isReleased = false;
            matrix.allowUndefinedValues = allowUndefinedValues;

            return matrix;
        }
        BitMatrix.getBitMatrix = getBitMatrix;
    })(TypeScript.BitMatrix || (TypeScript.BitMatrix = {}));
    var BitMatrix = TypeScript.BitMatrix;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Constants) {
        Constants[Constants["Max31BitInteger"] = 1073741823] = "Max31BitInteger";
        Constants[Constants["Min31BitInteger"] = -1073741824] = "Min31BitInteger";
    })(TypeScript.Constants || (TypeScript.Constants = {}));
    var Constants = TypeScript.Constants;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (AssertionLevel) {
        AssertionLevel[AssertionLevel["None"] = 0] = "None";
        AssertionLevel[AssertionLevel["Normal"] = 1] = "Normal";
        AssertionLevel[AssertionLevel["Aggressive"] = 2] = "Aggressive";
        AssertionLevel[AssertionLevel["VeryAggressive"] = 3] = "VeryAggressive";
    })(TypeScript.AssertionLevel || (TypeScript.AssertionLevel = {}));
    var AssertionLevel = TypeScript.AssertionLevel;

    var Debug = (function () {
        function Debug() {
        }
        Debug.shouldAssert = function (level) {
            return this.currentAssertionLevel >= level;
        };

        Debug.assert = function (expression, message, verboseDebugInfo) {
            if (typeof message === "undefined") { message = ""; }
            if (typeof verboseDebugInfo === "undefined") { verboseDebugInfo = null; }
            if (!expression) {
                var verboseDebugString = "";
                if (verboseDebugInfo) {
                    verboseDebugString = "\r\nVerbose Debug Information:" + verboseDebugInfo();
                }

                throw new Error("Debug Failure. False expression: " + message + verboseDebugString);
            }
        };

        Debug.fail = function (message) {
            Debug.assert(false, message);
        };
        Debug.currentAssertionLevel = 0 /* None */;
        return Debug;
    })();
    TypeScript.Debug = Debug;
})(TypeScript || (TypeScript = {}));
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var TypeScript;
(function (TypeScript) {
    TypeScript.LocalizedDiagnosticMessages = null;

    var Location = (function () {
        function Location(fileName, lineMap, start, length) {
            this._fileName = fileName;
            this._lineMap = lineMap;
            this._start = start;
            this._length = length;
        }
        Location.prototype.fileName = function () {
            return this._fileName;
        };

        Location.prototype.lineMap = function () {
            return this._lineMap;
        };

        Location.prototype.line = function () {
            return this._lineMap ? this._lineMap.getLineNumberFromPosition(this.start()) : 0;
        };

        Location.prototype.character = function () {
            return this._lineMap ? this._lineMap.getLineAndCharacterFromPosition(this.start()).character() : 0;
        };

        Location.prototype.start = function () {
            return this._start;
        };

        Location.prototype.length = function () {
            return this._length;
        };

        Location.equals = function (location1, location2) {
            return location1._fileName === location2._fileName && location1._start === location2._start && location1._length === location2._length;
        };
        return Location;
    })();
    TypeScript.Location = Location;

    var Diagnostic = (function (_super) {
        __extends(Diagnostic, _super);
        function Diagnostic(fileName, lineMap, start, length, diagnosticKey, _arguments, additionalLocations) {
            if (typeof _arguments === "undefined") { _arguments = null; }
            if (typeof additionalLocations === "undefined") { additionalLocations = null; }
            _super.call(this, fileName, lineMap, start, length);
            this._diagnosticKey = diagnosticKey;
            this._arguments = (_arguments && _arguments.length > 0) ? _arguments : null;
            this._additionalLocations = (additionalLocations && additionalLocations.length > 0) ? additionalLocations : null;
        }
        Diagnostic.prototype.toJSON = function (key) {
            var result = {};
            result.start = this.start();
            result.length = this.length();

            result.diagnosticCode = this._diagnosticKey;

            var _arguments = this.arguments();
            if (_arguments && _arguments.length > 0) {
                result.arguments = _arguments;
            }

            return result;
        };

        Diagnostic.prototype.diagnosticKey = function () {
            return this._diagnosticKey;
        };

        Diagnostic.prototype.arguments = function () {
            return this._arguments;
        };

        Diagnostic.prototype.text = function () {
            return TypeScript.getLocalizedText(this._diagnosticKey, this._arguments);
        };

        Diagnostic.prototype.message = function () {
            return TypeScript.getDiagnosticMessage(this._diagnosticKey, this._arguments);
        };

        Diagnostic.prototype.additionalLocations = function () {
            return this._additionalLocations || [];
        };

        Diagnostic.equals = function (diagnostic1, diagnostic2) {
            return Location.equals(diagnostic1, diagnostic2) && diagnostic1._diagnosticKey === diagnostic2._diagnosticKey && TypeScript.ArrayUtilities.sequenceEquals(diagnostic1._arguments, diagnostic2._arguments, function (v1, v2) {
                return v1 === v2;
            });
        };

        Diagnostic.prototype.info = function () {
            return getDiagnosticInfoFromKey(this.diagnosticKey());
        };
        return Diagnostic;
    })(Location);
    TypeScript.Diagnostic = Diagnostic;

    function newLine() {
        return TypeScript.Environment ? TypeScript.Environment.newLine : "\r\n";
    }
    TypeScript.newLine = newLine;

    function getLargestIndex(diagnostic) {
        var largest = -1;
        var regex = /\{(\d+)\}/g;

        var match;
        while (match = regex.exec(diagnostic)) {
            var val = parseInt(match[1]);
            if (!isNaN(val) && val > largest) {
                largest = val;
            }
        }

        return largest;
    }

    function getDiagnosticInfoFromKey(diagnosticKey) {
        var result = TypeScript.diagnosticInformationMap[diagnosticKey];
        TypeScript.Debug.assert(result);
        return result;
    }

    function getLocalizedText(diagnosticKey, args) {
        if (TypeScript.LocalizedDiagnosticMessages) {
        }

        var diagnosticMessageText = TypeScript.LocalizedDiagnosticMessages ? TypeScript.LocalizedDiagnosticMessages[diagnosticKey] : diagnosticKey;
        TypeScript.Debug.assert(diagnosticMessageText !== undefined && diagnosticMessageText !== null);

        var actualCount = args ? args.length : 0;

        var expectedCount = 1 + getLargestIndex(diagnosticKey);

        if (expectedCount !== actualCount) {
            throw new Error(getLocalizedText(TypeScript.DiagnosticCode.Expected_0_arguments_to_message_got_1_instead, [expectedCount, actualCount]));
        }

        var valueCount = 1 + getLargestIndex(diagnosticMessageText);
        if (valueCount !== expectedCount) {
            throw new Error(getLocalizedText(TypeScript.DiagnosticCode.Expected_the_message_0_to_have_1_arguments_but_it_had_2, [diagnosticMessageText, expectedCount, valueCount]));
        }

        diagnosticMessageText = diagnosticMessageText.replace(/{(\d+)}/g, function (match, num) {
            return typeof args[num] !== 'undefined' ? args[num] : match;
        });

        diagnosticMessageText = diagnosticMessageText.replace(/{(NL)}/g, function (match) {
            return TypeScript.newLine();
        });

        return diagnosticMessageText;
    }
    TypeScript.getLocalizedText = getLocalizedText;

    function getDiagnosticMessage(diagnosticKey, args) {
        var diagnostic = getDiagnosticInfoFromKey(diagnosticKey);
        var diagnosticMessageText = getLocalizedText(diagnosticKey, args);

        var message;
        if (diagnostic.category === 1 /* Error */) {
            message = getLocalizedText(TypeScript.DiagnosticCode.error_TS_0_1, [diagnostic.code, diagnosticMessageText]);
        } else if (diagnostic.category === 0 /* Warning */) {
            message = getLocalizedText(TypeScript.DiagnosticCode.warning_TS_0_1, [diagnostic.code, diagnosticMessageText]);
        } else {
            message = diagnosticMessageText;
        }

        return message;
    }
    TypeScript.getDiagnosticMessage = getDiagnosticMessage;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Errors = (function () {
        function Errors() {
        }
        Errors.argument = function (argument, message) {
            return new Error("Invalid argument: " + argument + ". " + message);
        };

        Errors.argumentOutOfRange = function (argument) {
            return new Error("Argument out of range: " + argument);
        };

        Errors.argumentNull = function (argument) {
            return new Error("Argument null: " + argument);
        };

        Errors.abstract = function () {
            return new Error("Operation not implemented properly by subclass.");
        };

        Errors.notYetImplemented = function () {
            return new Error("Not yet implemented.");
        };

        Errors.invalidOperation = function (message) {
            return new Error("Invalid operation: " + message);
        };
        return Errors;
    })();
    TypeScript.Errors = Errors;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var Hash = (function () {
        function Hash() {
        }
        Hash.computeFnv1aCharArrayHashCode = function (text, start, len) {
            var hashCode = Hash.FNV_BASE;
            var end = start + len;

            for (var i = start; i < end; i++) {
                hashCode = TypeScript.IntegerUtilities.integerMultiplyLow32Bits(hashCode ^ text[i], Hash.FNV_PRIME);
            }

            return hashCode;
        };

        Hash.computeSimple31BitCharArrayHashCode = function (key, start, len) {
            var hash = 0;

            for (var i = 0; i < len; i++) {
                var ch = key[start + i];

                hash = ((((hash << 5) - hash) | 0) + ch) | 0;
            }

            return hash & 0x7FFFFFFF;
        };

        Hash.computeSimple31BitStringHashCode = function (key) {
            var hash = 0;

            var start = 0;
            var len = key.length;

            for (var i = 0; i < len; i++) {
                var ch = key.charCodeAt(start + i);

                hash = ((((hash << 5) - hash) | 0) + ch) | 0;
            }

            return hash & 0x7FFFFFFF;
        };

        Hash.computeMurmur2StringHashCode = function (key, seed) {
            var m = 0x5bd1e995;
            var r = 24;

            var numberOfCharsLeft = key.length;
            var h = Math.abs(seed ^ numberOfCharsLeft);

            var index = 0;
            while (numberOfCharsLeft >= 2) {
                var c1 = key.charCodeAt(index);
                var c2 = key.charCodeAt(index + 1);

                var k = Math.abs(c1 | (c2 << 16));

                k = TypeScript.IntegerUtilities.integerMultiplyLow32Bits(k, m);
                k ^= k >> r;
                k = TypeScript.IntegerUtilities.integerMultiplyLow32Bits(k, m);

                h = TypeScript.IntegerUtilities.integerMultiplyLow32Bits(h, m);
                h ^= k;

                index += 2;
                numberOfCharsLeft -= 2;
            }

            if (numberOfCharsLeft === 1) {
                h ^= key.charCodeAt(index);
                h = TypeScript.IntegerUtilities.integerMultiplyLow32Bits(h, m);
            }

            h ^= h >> 13;
            h = TypeScript.IntegerUtilities.integerMultiplyLow32Bits(h, m);
            h ^= h >> 15;

            return h;
        };

        Hash.getPrime = function (min) {
            for (var i = 0; i < Hash.primes.length; i++) {
                var num = Hash.primes[i];
                if (num >= min) {
                    return num;
                }
            }

            throw TypeScript.Errors.notYetImplemented();
        };

        Hash.expandPrime = function (oldSize) {
            var num = oldSize << 1;
            if (num > 2146435069 && 2146435069 > oldSize) {
                return 2146435069;
            }
            return Hash.getPrime(num);
        };

        Hash.combine = function (value, currentHash) {
            return (((currentHash << 5) + currentHash) + value) & 0x7FFFFFFF;
        };
        Hash.FNV_BASE = 2166136261;
        Hash.FNV_PRIME = 16777619;

        Hash.primes = [
            3, 7, 11, 17, 23, 29, 37, 47, 59, 71, 89, 107, 131, 163, 197, 239, 293, 353, 431, 521,
            631, 761, 919, 1103, 1327, 1597, 1931, 2333, 2801, 3371, 4049, 4861, 5839, 7013, 8419,
            10103, 12143, 14591, 17519, 21023, 25229, 30293, 36353, 43627, 52361, 62851, 75431,
            90523, 108631, 130363, 156437, 187751, 225307, 270371, 324449, 389357, 467237, 560689,
            672827, 807403, 968897, 1162687, 1395263, 1674319, 2009191, 2411033, 2893249, 3471899,
            4166287, 4999559, 5999471, 7199369];
        return Hash;
    })();
    TypeScript.Hash = Hash;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Collections) {
        Collections.DefaultHashTableCapacity = 1024;

        var HashTableEntry = (function () {
            function HashTableEntry(Key, Value, HashCode, Next) {
                this.Key = Key;
                this.Value = Value;
                this.HashCode = HashCode;
                this.Next = Next;
            }
            return HashTableEntry;
        })();

        var HashTable = (function () {
            function HashTable(capacity, hash) {
                this.hash = hash;
                this.count = 0;
                var size = TypeScript.Hash.getPrime(capacity);
                this.entries = TypeScript.ArrayUtilities.createArray(size, null);
            }
            HashTable.prototype.set = function (key, value) {
                this.addOrSet(key, value, false);
            };

            HashTable.prototype.add = function (key, value) {
                this.addOrSet(key, value, true);
            };

            HashTable.prototype.containsKey = function (key) {
                var hashCode = this.computeHashCode(key);
                var entry = this.findEntry(key, hashCode);
                return entry !== null;
            };

            HashTable.prototype.get = function (key) {
                var hashCode = this.computeHashCode(key);
                var entry = this.findEntry(key, hashCode);

                return entry === null ? null : entry.Value;
            };

            HashTable.prototype.computeHashCode = function (key) {
                var hashCode = this.hash === null ? key.hashCode : this.hash(key);

                hashCode = hashCode & 0x7FFFFFFF;
                TypeScript.Debug.assert(hashCode >= 0);

                return hashCode;
            };

            HashTable.prototype.addOrSet = function (key, value, throwOnExistingEntry) {
                var hashCode = this.computeHashCode(key);

                var entry = this.findEntry(key, hashCode);
                if (entry !== null) {
                    if (throwOnExistingEntry) {
                        throw TypeScript.Errors.argument('key', "Key was already in table.");
                    }

                    entry.Key = key;
                    entry.Value = value;
                    return;
                }

                return this.addEntry(key, value, hashCode);
            };

            HashTable.prototype.findEntry = function (key, hashCode) {
                for (var e = this.entries[hashCode % this.entries.length]; e !== null; e = e.Next) {
                    if (e.HashCode === hashCode && key === e.Key) {
                        return e;
                    }
                }

                return null;
            };

            HashTable.prototype.addEntry = function (key, value, hashCode) {
                var index = hashCode % this.entries.length;

                var e = new HashTableEntry(key, value, hashCode, this.entries[index]);

                this.entries[index] = e;

                if (this.count >= (this.entries.length / 2)) {
                    this.grow();
                }

                this.count++;
                return e.Key;
            };

            HashTable.prototype.grow = function () {
                var newSize = TypeScript.Hash.expandPrime(this.entries.length);

                var oldEntries = this.entries;
                var newEntries = TypeScript.ArrayUtilities.createArray(newSize, null);

                this.entries = newEntries;

                for (var i = 0; i < oldEntries.length; i++) {
                    var e = oldEntries[i];

                    while (e !== null) {
                        var newIndex = e.HashCode % newSize;
                        var tmp = e.Next;
                        e.Next = newEntries[newIndex];
                        newEntries[newIndex] = e;
                        e = tmp;
                    }
                }
            };
            return HashTable;
        })();
        Collections.HashTable = HashTable;

        function createHashTable(capacity, hash) {
            if (typeof capacity === "undefined") { capacity = Collections.DefaultHashTableCapacity; }
            if (typeof hash === "undefined") { hash = null; }
            return new HashTable(capacity, hash);
        }
        Collections.createHashTable = createHashTable;

        var currentHashCode = 1;
        function identityHashCode(value) {
            if (value.__hash === undefined) {
                value.__hash = currentHashCode;
                currentHashCode++;
            }

            return value.__hash;
        }
        Collections.identityHashCode = identityHashCode;
    })(TypeScript.Collections || (TypeScript.Collections = {}));
    var Collections = TypeScript.Collections;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    TypeScript.nodeMakeDirectoryTime = 0;
    TypeScript.nodeCreateBufferTime = 0;
    TypeScript.nodeWriteFileSyncTime = 0;

    (function (ByteOrderMark) {
        ByteOrderMark[ByteOrderMark["None"] = 0] = "None";
        ByteOrderMark[ByteOrderMark["Utf8"] = 1] = "Utf8";
        ByteOrderMark[ByteOrderMark["Utf16BigEndian"] = 2] = "Utf16BigEndian";
        ByteOrderMark[ByteOrderMark["Utf16LittleEndian"] = 3] = "Utf16LittleEndian";
    })(TypeScript.ByteOrderMark || (TypeScript.ByteOrderMark = {}));
    var ByteOrderMark = TypeScript.ByteOrderMark;

    var FileInformation = (function () {
        function FileInformation(contents, byteOrderMark) {
            this.contents = contents;
            this.byteOrderMark = byteOrderMark;
        }
        return FileInformation;
    })();
    TypeScript.FileInformation = FileInformation;

    TypeScript.Environment = (function () {
        function getWindowsScriptHostEnvironment() {
            try  {
                var fso = new ActiveXObject("Scripting.FileSystemObject");
            } catch (e) {
                return null;
            }

            var streamObjectPool = [];

            function getStreamObject() {
                if (streamObjectPool.length > 0) {
                    return streamObjectPool.pop();
                } else {
                    return new ActiveXObject("ADODB.Stream");
                }
            }

            function releaseStreamObject(obj) {
                streamObjectPool.push(obj);
            }

            var args = [];
            for (var i = 0; i < WScript.Arguments.length; i++) {
                args[i] = WScript.Arguments.Item(i);
            }

            return {
                newLine: "\r\n",
                currentDirectory: function () {
                    return WScript.CreateObject("WScript.Shell").CurrentDirectory;
                },
                supportsCodePage: function () {
                    return WScript.ReadFile;
                },
                readFile: function (path, codepage) {
                    try  {
                        if (codepage !== null && this.supportsCodePage()) {
                            try  {
                                var contents = WScript.ReadFile(path, codepage);
                                return new FileInformation(contents, 0 /* None */);
                            } catch (e) {
                            }
                        }

                        var streamObj = getStreamObject();
                        streamObj.Open();
                        streamObj.Type = 2;

                        streamObj.Charset = 'x-ansi';

                        streamObj.LoadFromFile(path);
                        var bomChar = streamObj.ReadText(2);

                        streamObj.Position = 0;

                        var byteOrderMark = 0 /* None */;

                        if (bomChar.charCodeAt(0) === 0xFE && bomChar.charCodeAt(1) === 0xFF) {
                            streamObj.Charset = 'unicode';
                            byteOrderMark = 2 /* Utf16BigEndian */;
                        } else if (bomChar.charCodeAt(0) === 0xFF && bomChar.charCodeAt(1) === 0xFE) {
                            streamObj.Charset = 'unicode';
                            byteOrderMark = 3 /* Utf16LittleEndian */;
                        } else if (bomChar.charCodeAt(0) === 0xEF && bomChar.charCodeAt(1) === 0xBB) {
                            streamObj.Charset = 'utf-8';
                            byteOrderMark = 1 /* Utf8 */;
                        } else {
                            streamObj.Charset = 'utf-8';
                        }

                        var contents = streamObj.ReadText(-1);
                        streamObj.Close();
                        releaseStreamObject(streamObj);
                        return new FileInformation(contents, byteOrderMark);
                    } catch (err) {
                        var message;
                        if (err.number === -2147024809) {
                            message = TypeScript.getDiagnosticMessage(TypeScript.DiagnosticCode.Unsupported_file_encoding, null);
                        } else {
                            message = TypeScript.getDiagnosticMessage(TypeScript.DiagnosticCode.Cannot_read_file_0_1, [path, err.message]);
                        }

                        throw new Error(message);
                    }
                },
                writeFile: function (path, contents, writeByteOrderMark) {
                    var textStream = getStreamObject();
                    textStream.Charset = 'utf-8';
                    textStream.Open();
                    textStream.WriteText(contents, 0);

                    if (!writeByteOrderMark) {
                        textStream.Position = 3;
                    } else {
                        textStream.Position = 0;
                    }

                    var fileStream = getStreamObject();
                    fileStream.Type = 1;
                    fileStream.Open();

                    textStream.CopyTo(fileStream);

                    fileStream.Flush();
                    fileStream.SaveToFile(path, 2);
                    fileStream.Close();

                    textStream.Flush();
                    textStream.Close();
                },
                fileExists: function (path) {
                    return fso.FileExists(path);
                },
                deleteFile: function (path) {
                    if (fso.FileExists(path)) {
                        fso.DeleteFile(path, true);
                    }
                },
                directoryExists: function (path) {
                    return fso.FolderExists(path);
                },
                listFiles: function (path, spec, options) {
                    options = options || {};
                    function filesInFolder(folder, root) {
                        var paths = [];
                        var fc;

                        if (options.recursive) {
                            fc = new Enumerator(folder.subfolders);

                            for (; !fc.atEnd(); fc.moveNext()) {
                                paths = paths.concat(filesInFolder(fc.item(), root + "\\" + fc.item().Name));
                            }
                        }

                        fc = new Enumerator(folder.files);

                        for (; !fc.atEnd(); fc.moveNext()) {
                            if (!spec || fc.item().Name.match(spec)) {
                                paths.push(root + "\\" + fc.item().Name);
                            }
                        }

                        return paths;
                    }

                    var folder = fso.GetFolder(path);
                    var paths = [];

                    return filesInFolder(folder, path);
                },
                arguments: args,
                standardOut: WScript.StdOut
            };
        }
        ;

        function getNodeEnvironment() {
            var _fs = require('fs');
            var _path = require('path');
            var _module = require('module');
            var _os = require('os');

            return {
                newLine: _os.EOL,
                currentDirectory: function () {
                    return process.cwd();
                },
                supportsCodePage: function () {
                    return false;
                },
                readFile: function (file, codepage) {
                    if (codepage !== null) {
                        throw new Error(TypeScript.getDiagnosticMessage(TypeScript.DiagnosticCode.codepage_option_not_supported_on_current_platform, null));
                    }

                    var buffer = _fs.readFileSync(file);
                    switch (buffer[0]) {
                        case 0xFE:
                            if (buffer[1] === 0xFF) {
                                var i = 0;
                                while ((i + 1) < buffer.length) {
                                    var temp = buffer[i];
                                    buffer[i] = buffer[i + 1];
                                    buffer[i + 1] = temp;
                                    i += 2;
                                }
                                return new FileInformation(buffer.toString("ucs2", 2), 2 /* Utf16BigEndian */);
                            }
                            break;
                        case 0xFF:
                            if (buffer[1] === 0xFE) {
                                return new FileInformation(buffer.toString("ucs2", 2), 3 /* Utf16LittleEndian */);
                            }
                            break;
                        case 0xEF:
                            if (buffer[1] === 0xBB) {
                                return new FileInformation(buffer.toString("utf8", 3), 1 /* Utf8 */);
                            }
                    }

                    return new FileInformation(buffer.toString("utf8", 0), 0 /* None */);
                },
                writeFile: function (path, contents, writeByteOrderMark) {
                    function mkdirRecursiveSync(path) {
                        var stats = _fs.statSync(path);
                        if (stats.isFile()) {
                            throw "\"" + path + "\" exists but isn't a directory.";
                        } else if (stats.isDirectory()) {
                            return;
                        } else {
                            mkdirRecursiveSync(_path.dirname(path));
                            _fs.mkdirSync(path, 509);
                        }
                    }
                    var start = new Date().getTime();
                    mkdirRecursiveSync(_path.dirname(path));
                    TypeScript.nodeMakeDirectoryTime += new Date().getTime() - start;

                    if (writeByteOrderMark) {
                        contents = '\uFEFF' + contents;
                    }

                    var start = new Date().getTime();

                    var chunkLength = 4 * 1024;
                    var fileDescriptor = _fs.openSync(path, "w");
                    try  {
                        for (var index = 0; index < contents.length; index += chunkLength) {
                            var bufferStart = new Date().getTime();
                            var buffer = new Buffer(contents.substr(index, chunkLength), "utf8");
                            TypeScript.nodeCreateBufferTime += new Date().getTime() - bufferStart;

                            _fs.writeSync(fileDescriptor, buffer, 0, buffer.length, null);
                        }
                    } finally {
                        _fs.closeSync(fileDescriptor);
                    }

                    TypeScript.nodeWriteFileSyncTime += new Date().getTime() - start;
                },
                fileExists: function (path) {
                    return _fs.existsSync(path);
                },
                deleteFile: function (path) {
                    try  {
                        _fs.unlinkSync(path);
                    } catch (e) {
                    }
                },
                directoryExists: function (path) {
                    return _fs.existsSync(path) && _fs.statSync(path).isDirectory();
                },
                listFiles: function dir(path, spec, options) {
                    options = options || {};

                    function filesInFolder(folder) {
                        var paths = [];

                        var files = _fs.readdirSync(folder);
                        for (var i = 0; i < files.length; i++) {
                            var stat = _fs.statSync(folder + "\\" + files[i]);
                            if (options.recursive && stat.isDirectory()) {
                                paths = paths.concat(filesInFolder(folder + "\\" + files[i]));
                            } else if (stat.isFile() && (!spec || files[i].match(spec))) {
                                paths.push(folder + "\\" + files[i]);
                            }
                        }

                        return paths;
                    }

                    return filesInFolder(path);
                },
                arguments: process.argv.slice(2),
                standardOut: {
                    Write: function (str) {
                        process.stdout.write(str);
                    },
                    WriteLine: function (str) {
                        process.stdout.write(str + '\n');
                    },
                    Close: function () {
                    }
                }
            };
        }
        ;

        if (typeof WScript !== "undefined" && typeof ActiveXObject === "function") {
            return getWindowsScriptHostEnvironment();
        } else if (typeof module !== 'undefined' && module.exports) {
            return getNodeEnvironment();
        } else {
            return null;
        }
    })();
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (IntegerUtilities) {
        function integerDivide(numerator, denominator) {
            return (numerator / denominator) >> 0;
        }
        IntegerUtilities.integerDivide = integerDivide;

        function integerMultiplyLow32Bits(n1, n2) {
            var n1Low16 = n1 & 0x0000ffff;
            var n1High16 = n1 >>> 16;

            var n2Low16 = n2 & 0x0000ffff;
            var n2High16 = n2 >>> 16;

            var resultLow32 = (((n1 & 0xffff0000) * n2) >>> 0) + (((n1 & 0x0000ffff) * n2) >>> 0) >>> 0;
            return resultLow32;
        }
        IntegerUtilities.integerMultiplyLow32Bits = integerMultiplyLow32Bits;

        function integerMultiplyHigh32Bits(n1, n2) {
            var n1Low16 = n1 & 0x0000ffff;
            var n1High16 = n1 >>> 16;

            var n2Low16 = n2 & 0x0000ffff;
            var n2High16 = n2 >>> 16;

            var resultHigh32 = n1High16 * n2High16 + ((((n1Low16 * n2Low16) >>> 17) + n1Low16 * n2High16) >>> 15);
            return resultHigh32;
        }
        IntegerUtilities.integerMultiplyHigh32Bits = integerMultiplyHigh32Bits;

        function isInteger(text) {
            return /^[0-9]+$/.test(text);
        }
        IntegerUtilities.isInteger = isInteger;

        function isHexInteger(text) {
            return /^0(x|X)[0-9a-fA-F]+$/.test(text);
        }
        IntegerUtilities.isHexInteger = isHexInteger;
    })(TypeScript.IntegerUtilities || (TypeScript.IntegerUtilities = {}));
    var IntegerUtilities = TypeScript.IntegerUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var LineMap = (function () {
        function LineMap(_computeLineStarts, length) {
            this._computeLineStarts = _computeLineStarts;
            this.length = length;
            this._lineStarts = null;
        }
        LineMap.prototype.toJSON = function (key) {
            return { lineStarts: this.lineStarts(), length: this.length };
        };

        LineMap.prototype.equals = function (other) {
            return this.length === other.length && TypeScript.ArrayUtilities.sequenceEquals(this.lineStarts(), other.lineStarts(), function (v1, v2) {
                return v1 === v2;
            });
        };

        LineMap.prototype.lineStarts = function () {
            if (this._lineStarts === null) {
                this._lineStarts = this._computeLineStarts();
            }

            return this._lineStarts;
        };

        LineMap.prototype.lineCount = function () {
            return this.lineStarts().length;
        };

        LineMap.prototype.getPosition = function (line, character) {
            return this.lineStarts()[line] + character;
        };

        LineMap.prototype.getLineNumberFromPosition = function (position) {
            if (position < 0 || position > this.length) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            if (position === this.length) {
                return this.lineCount() - 1;
            }

            var lineNumber = TypeScript.ArrayUtilities.binarySearch(this.lineStarts(), position);
            if (lineNumber < 0) {
                lineNumber = (~lineNumber) - 1;
            }

            return lineNumber;
        };

        LineMap.prototype.getLineStartPosition = function (lineNumber) {
            return this.lineStarts()[lineNumber];
        };

        LineMap.prototype.fillLineAndCharacterFromPosition = function (position, lineAndCharacter) {
            if (position < 0 || position > this.length) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            var lineNumber = this.getLineNumberFromPosition(position);
            lineAndCharacter.line = lineNumber;
            lineAndCharacter.character = position - this.lineStarts()[lineNumber];
        };

        LineMap.prototype.getLineAndCharacterFromPosition = function (position) {
            if (position < 0 || position > this.length) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            var lineNumber = this.getLineNumberFromPosition(position);

            return new TypeScript.LineAndCharacter(lineNumber, position - this.lineStarts()[lineNumber]);
        };
        LineMap.empty = new LineMap(function () {
            return [0];
        }, 0);
        return LineMap;
    })();
    TypeScript.LineMap = LineMap;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var LineAndCharacter = (function () {
        function LineAndCharacter(line, character) {
            this._line = 0;
            this._character = 0;
            if (line < 0) {
                throw TypeScript.Errors.argumentOutOfRange("line");
            }

            if (character < 0) {
                throw TypeScript.Errors.argumentOutOfRange("character");
            }

            this._line = line;
            this._character = character;
        }
        LineAndCharacter.prototype.line = function () {
            return this._line;
        };

        LineAndCharacter.prototype.character = function () {
            return this._character;
        };
        return LineAndCharacter;
    })();
    TypeScript.LineAndCharacter = LineAndCharacter;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var MathPrototype = (function () {
        function MathPrototype() {
        }
        MathPrototype.max = function (a, b) {
            return a >= b ? a : b;
        };

        MathPrototype.min = function (a, b) {
            return a <= b ? a : b;
        };
        return MathPrototype;
    })();
    TypeScript.MathPrototype = MathPrototype;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Collections) {
        Collections.DefaultStringTableCapacity = 256;

        var StringTableEntry = (function () {
            function StringTableEntry(Text, HashCode, Next) {
                this.Text = Text;
                this.HashCode = HashCode;
                this.Next = Next;
            }
            return StringTableEntry;
        })();

        var StringTable = (function () {
            function StringTable(capacity) {
                this.count = 0;
                var size = TypeScript.Hash.getPrime(capacity);
                this.entries = TypeScript.ArrayUtilities.createArray(size, null);
            }
            StringTable.prototype.addCharArray = function (key, start, len) {
                var hashCode = TypeScript.Hash.computeSimple31BitCharArrayHashCode(key, start, len) & 0x7FFFFFFF;

                var entry = this.findCharArrayEntry(key, start, len, hashCode);
                if (entry !== null) {
                    return entry.Text;
                }

                var slice = key.slice(start, start + len);
                return this.addEntry(TypeScript.StringUtilities.fromCharCodeArray(slice), hashCode);
            };

            StringTable.prototype.findCharArrayEntry = function (key, start, len, hashCode) {
                for (var e = this.entries[hashCode % this.entries.length]; e !== null; e = e.Next) {
                    if (e.HashCode === hashCode && StringTable.textCharArrayEquals(e.Text, key, start, len)) {
                        return e;
                    }
                }

                return null;
            };

            StringTable.prototype.addEntry = function (text, hashCode) {
                var index = hashCode % this.entries.length;

                var e = new StringTableEntry(text, hashCode, this.entries[index]);

                this.entries[index] = e;

                if (this.count === this.entries.length) {
                    this.grow();
                }

                this.count++;
                return e.Text;
            };

            StringTable.prototype.grow = function () {
                var newSize = TypeScript.Hash.expandPrime(this.entries.length);

                var oldEntries = this.entries;
                var newEntries = TypeScript.ArrayUtilities.createArray(newSize, null);

                this.entries = newEntries;

                for (var i = 0; i < oldEntries.length; i++) {
                    var e = oldEntries[i];
                    while (e !== null) {
                        var newIndex = e.HashCode % newSize;
                        var tmp = e.Next;
                        e.Next = newEntries[newIndex];
                        newEntries[newIndex] = e;
                        e = tmp;
                    }
                }
            };

            StringTable.textCharArrayEquals = function (text, array, start, length) {
                if (text.length !== length) {
                    return false;
                }

                var s = start;
                for (var i = 0; i < length; i++) {
                    if (text.charCodeAt(i) !== array[s]) {
                        return false;
                    }

                    s++;
                }

                return true;
            };
            return StringTable;
        })();
        Collections.StringTable = StringTable;

        Collections.DefaultStringTable = new StringTable(Collections.DefaultStringTableCapacity);
    })(TypeScript.Collections || (TypeScript.Collections = {}));
    var Collections = TypeScript.Collections;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var StringUtilities = (function () {
        function StringUtilities() {
        }
        StringUtilities.isString = function (value) {
            return Object.prototype.toString.apply(value, []) === '[object String]';
        };

        StringUtilities.fromCharCodeArray = function (array) {
            return String.fromCharCode.apply(null, array);
        };

        StringUtilities.endsWith = function (string, value) {
            return string.substring(string.length - value.length, string.length) === value;
        };

        StringUtilities.startsWith = function (string, value) {
            return string.substr(0, value.length) === value;
        };

        StringUtilities.copyTo = function (source, sourceIndex, destination, destinationIndex, count) {
            for (var i = 0; i < count; i++) {
                destination[destinationIndex + i] = source.charCodeAt(sourceIndex + i);
            }
        };

        StringUtilities.repeat = function (value, count) {
            return Array(count + 1).join(value);
        };

        StringUtilities.stringEquals = function (val1, val2) {
            return val1 === val2;
        };
        return StringUtilities;
    })();
    TypeScript.StringUtilities = StringUtilities;
})(TypeScript || (TypeScript = {}));
var global = Function("return this").call(null);

var TypeScript;
(function (TypeScript) {
    var Clock;
    (function (Clock) {
        Clock.now;
        Clock.resolution;

        if (typeof WScript !== "undefined" && typeof global['WScript'].InitializeProjection !== "undefined") {
            global['WScript'].InitializeProjection();

            Clock.now = function () {
                return TestUtilities.QueryPerformanceCounter();
            };

            Clock.resolution = TestUtilities.QueryPerformanceFrequency();
        } else {
            Clock.now = function () {
                return Date.now();
            };

            Clock.resolution = 1000;
        }
    })(Clock || (Clock = {}));

    var Timer = (function () {
        function Timer() {
            this.time = 0;
        }
        Timer.prototype.start = function () {
            this.time = 0;
            this.startTime = Clock.now();
        };

        Timer.prototype.end = function () {
            this.time = (Clock.now() - this.startTime);
        };
        return Timer;
    })();
    TypeScript.Timer = Timer;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (DiagnosticCategory) {
        DiagnosticCategory[DiagnosticCategory["Warning"] = 0] = "Warning";
        DiagnosticCategory[DiagnosticCategory["Error"] = 1] = "Error";
        DiagnosticCategory[DiagnosticCategory["Message"] = 2] = "Message";
        DiagnosticCategory[DiagnosticCategory["NoPrefix"] = 3] = "NoPrefix";
    })(TypeScript.DiagnosticCategory || (TypeScript.DiagnosticCategory = {}));
    var DiagnosticCategory = TypeScript.DiagnosticCategory;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    TypeScript.diagnosticInformationMap = {
        "error TS{0}: {1}": {
            "code": 0,
            "category": 3 /* NoPrefix */
        },
        "warning TS{0}: {1}": {
            "code": 1,
            "category": 3 /* NoPrefix */
        },
        "Unrecognized escape sequence.": {
            "code": 1000,
            "category": 1 /* Error */
        },
        "Unexpected character {0}.": {
            "code": 1001,
            "category": 1 /* Error */
        },
        "Missing close quote character.": {
            "code": 1002,
            "category": 1 /* Error */
        },
        "Identifier expected.": {
            "code": 1003,
            "category": 1 /* Error */
        },
        "'{0}' keyword expected.": {
            "code": 1004,
            "category": 1 /* Error */
        },
        "'{0}' expected.": {
            "code": 1005,
            "category": 1 /* Error */
        },
        "Identifier expected; '{0}' is a keyword.": {
            "code": 1006,
            "category": 1 /* Error */
        },
        "Automatic semicolon insertion not allowed.": {
            "code": 1007,
            "category": 1 /* Error */
        },
        "Unexpected token; '{0}' expected.": {
            "code": 1008,
            "category": 1 /* Error */
        },
        "Trailing separator not allowed.": {
            "code": 1009,
            "category": 1 /* Error */
        },
        "'*/' expected.": {
            "code": 1010,
            "category": 1 /* Error */
        },
        "'public' or 'private' modifier must precede 'static'.": {
            "code": 1011,
            "category": 1 /* Error */
        },
        "Unexpected token.": {
            "code": 1012,
            "category": 1 /* Error */
        },
        "Catch clause parameter cannot have a type annotation.": {
            "code": 1013,
            "category": 1 /* Error */
        },
        "Rest parameter must be last in list.": {
            "code": 1014,
            "category": 1 /* Error */
        },
        "Parameter cannot have question mark and initializer.": {
            "code": 1015,
            "category": 1 /* Error */
        },
        "Required parameter cannot follow optional parameter.": {
            "code": 1016,
            "category": 1 /* Error */
        },
        "Index signatures cannot have rest parameters.": {
            "code": 1017,
            "category": 1 /* Error */
        },
        "Index signature parameter cannot have accessibility modifiers.": {
            "code": 1018,
            "category": 1 /* Error */
        },
        "Index signature parameter cannot have a question mark.": {
            "code": 1019,
            "category": 1 /* Error */
        },
        "Index signature parameter cannot have an initializer.": {
            "code": 1020,
            "category": 1 /* Error */
        },
        "Index signature must have a type annotation.": {
            "code": 1021,
            "category": 1 /* Error */
        },
        "Index signature parameter must have a type annotation.": {
            "code": 1022,
            "category": 1 /* Error */
        },
        "Index signature parameter type must be 'string' or 'number'.": {
            "code": 1023,
            "category": 1 /* Error */
        },
        "'extends' clause already seen.": {
            "code": 1024,
            "category": 1 /* Error */
        },
        "'extends' clause must precede 'implements' clause.": {
            "code": 1025,
            "category": 1 /* Error */
        },
        "Classes can only extend a single class.": {
            "code": 1026,
            "category": 1 /* Error */
        },
        "'implements' clause already seen.": {
            "code": 1027,
            "category": 1 /* Error */
        },
        "Accessibility modifier already seen.": {
            "code": 1028,
            "category": 1 /* Error */
        },
        "'{0}' modifier must precede '{1}' modifier.": {
            "code": 1029,
            "category": 1 /* Error */
        },
        "'{0}' modifier already seen.": {
            "code": 1030,
            "category": 1 /* Error */
        },
        "'{0}' modifier cannot appear on a class element.": {
            "code": 1031,
            "category": 1 /* Error */
        },
        "Interface declaration cannot have 'implements' clause.": {
            "code": 1032,
            "category": 1 /* Error */
        },
        "'super' invocation cannot have type arguments.": {
            "code": 1034,
            "category": 1 /* Error */
        },
        "Only ambient modules can use quoted names.": {
            "code": 1035,
            "category": 1 /* Error */
        },
        "Statements are not allowed in ambient contexts.": {
            "code": 1036,
            "category": 1 /* Error */
        },
        "Implementations are not allowed in ambient contexts.": {
            "code": 1037,
            "category": 1 /* Error */
        },
        "'declare' modifier not allowed for code already in an ambient context.": {
            "code": 1038,
            "category": 1 /* Error */
        },
        "Initializers are not allowed in ambient contexts.": {
            "code": 1039,
            "category": 1 /* Error */
        },
        "Parameter property declarations can only be used in a non-ambient constructor declaration.": {
            "code": 1040,
            "category": 1 /* Error */
        },
        "Function implementation expected.": {
            "code": 1041,
            "category": 1 /* Error */
        },
        "Constructor implementation expected.": {
            "code": 1042,
            "category": 1 /* Error */
        },
        "Function overload name must be '{0}'.": {
            "code": 1043,
            "category": 1 /* Error */
        },
        "'{0}' modifier cannot appear on a module element.": {
            "code": 1044,
            "category": 1 /* Error */
        },
        "'declare' modifier cannot appear on an interface declaration.": {
            "code": 1045,
            "category": 1 /* Error */
        },
        "'declare' modifier required for top level element.": {
            "code": 1046,
            "category": 1 /* Error */
        },
        "Rest parameter cannot be optional.": {
            "code": 1047,
            "category": 1 /* Error */
        },
        "Rest parameter cannot have an initializer.": {
            "code": 1048,
            "category": 1 /* Error */
        },
        "'set' accessor must have one and only one parameter.": {
            "code": 1049,
            "category": 1 /* Error */
        },
        "'set' accessor parameter cannot be optional.": {
            "code": 1051,
            "category": 1 /* Error */
        },
        "'set' accessor parameter cannot have an initializer.": {
            "code": 1052,
            "category": 1 /* Error */
        },
        "'set' accessor cannot have rest parameter.": {
            "code": 1053,
            "category": 1 /* Error */
        },
        "'get' accessor cannot have parameters.": {
            "code": 1054,
            "category": 1 /* Error */
        },
        "Modifiers cannot appear here.": {
            "code": 1055,
            "category": 1 /* Error */
        },
        "Accessors are only available when targeting ECMAScript 5 and higher.": {
            "code": 1056,
            "category": 1 /* Error */
        },
        "Class name cannot be '{0}'.": {
            "code": 1057,
            "category": 1 /* Error */
        },
        "Interface name cannot be '{0}'.": {
            "code": 1058,
            "category": 1 /* Error */
        },
        "Enum name cannot be '{0}'.": {
            "code": 1059,
            "category": 1 /* Error */
        },
        "Module name cannot be '{0}'.": {
            "code": 1060,
            "category": 1 /* Error */
        },
        "Enum member must have initializer.": {
            "code": 1061,
            "category": 1 /* Error */
        },
        "Export assignment cannot be used in internal modules.": {
            "code": 1063,
            "category": 1 /* Error */
        },
        "Export assignment not allowed in module with exported element.": {
            "code": 1064,
            "category": 1 /* Error */
        },
        "Module cannot have multiple export assignments.": {
            "code": 1065,
            "category": 1 /* Error */
        },
        "Ambient enum elements can only have integer literal initializers.": {
            "code": 1066,
            "category": 1 /* Error */
        },
        "module, class, interface, enum, import or statement": {
            "code": 1067,
            "category": 3 /* NoPrefix */
        },
        "constructor, function, accessor or variable": {
            "code": 1068,
            "category": 3 /* NoPrefix */
        },
        "statement": {
            "code": 1069,
            "category": 3 /* NoPrefix */
        },
        "case or default clause": {
            "code": 1070,
            "category": 3 /* NoPrefix */
        },
        "identifier": {
            "code": 1071,
            "category": 3 /* NoPrefix */
        },
        "call, construct, index, property or function signature": {
            "code": 1072,
            "category": 3 /* NoPrefix */
        },
        "expression": {
            "code": 1073,
            "category": 3 /* NoPrefix */
        },
        "type name": {
            "code": 1074,
            "category": 3 /* NoPrefix */
        },
        "property or accessor": {
            "code": 1075,
            "category": 3 /* NoPrefix */
        },
        "parameter": {
            "code": 1076,
            "category": 3 /* NoPrefix */
        },
        "type": {
            "code": 1077,
            "category": 3 /* NoPrefix */
        },
        "type parameter": {
            "code": 1078,
            "category": 3 /* NoPrefix */
        },
        "'declare' modifier not allowed on import declaration.": {
            "code": 1079,
            "category": 1 /* Error */
        },
        "Function overload must be static.": {
            "code": 1080,
            "category": 1 /* Error */
        },
        "Function overload must not be static.": {
            "code": 1081,
            "category": 1 /* Error */
        },
        "Parameter property declarations cannot be used in a constructor overload.": {
            "code": 1083,
            "category": 1 /* Error */
        },
        "Invalid 'reference' directive syntax.": {
            "code": 1084,
            "category": 1 /* Error */
        },
        "Octal literals are not available when targeting ECMAScript 5 and higher.": {
            "code": 1085,
            "category": 1 /* Error */
        },
        "Accessors are not allowed in ambient contexts.": {
            "code": 1086,
            "category": 1 /* Error */
        },
        "'{0}' modifier cannot appear on a constructor declaration.": {
            "code": 1089,
            "category": 1 /* Error */
        },
        "'{0}' modifier cannot appear on a parameter.": {
            "code": 1090,
            "category": 1 /* Error */
        },
        "Only a single variable declaration is allowed in a 'for...in' statement.": {
            "code": 1091,
            "category": 1 /* Error */
        },
        "Type parameters cannot appear on a constructor declaration.": {
            "code": 1091,
            "category": 1 /* Error */
        },
        "Type annotation cannot appear on a constructor declaration.": {
            "code": 1092,
            "category": 1 /* Error */
        },
        "Duplicate identifier '{0}'.": {
            "code": 2000,
            "category": 1 /* Error */
        },
        "The name '{0}' does not exist in the current scope.": {
            "code": 2001,
            "category": 1 /* Error */
        },
        "The name '{0}' does not refer to a value.": {
            "code": 2002,
            "category": 1 /* Error */
        },
        "'super' can only be used inside a class instance method.": {
            "code": 2003,
            "category": 1 /* Error */
        },
        "The left-hand side of an assignment expression must be a variable, property or indexer.": {
            "code": 2004,
            "category": 1 /* Error */
        },
        "Value of type '{0}' is not callable. Did you mean to include 'new'?": {
            "code": 2161,
            "category": 1 /* Error */
        },
        "Value of type '{0}' is not callable.": {
            "code": 2006,
            "category": 1 /* Error */
        },
        "Value of type '{0}' is not newable.": {
            "code": 2007,
            "category": 1 /* Error */
        },
        "Value of type '{0}' is not indexable by type '{1}'.": {
            "code": 2008,
            "category": 1 /* Error */
        },
        "Operator '{0}' cannot be applied to types '{1}' and '{2}'.": {
            "code": 2009,
            "category": 1 /* Error */
        },
        "Operator '{0}' cannot be applied to types '{1}' and '{2}': {3}": {
            "code": 2010,
            "category": 1 /* Error */
        },
        "Cannot convert '{0}' to '{1}'.": {
            "code": 2011,
            "category": 1 /* Error */
        },
        "Cannot convert '{0}' to '{1}':{NL}{2}": {
            "code": 2012,
            "category": 1 /* Error */
        },
        "Expected var, class, interface, or module.": {
            "code": 2013,
            "category": 1 /* Error */
        },
        "Operator '{0}' cannot be applied to type '{1}'.": {
            "code": 2014,
            "category": 1 /* Error */
        },
        "Getter '{0}' already declared.": {
            "code": 2015,
            "category": 1 /* Error */
        },
        "Setter '{0}' already declared.": {
            "code": 2016,
            "category": 1 /* Error */
        },
        "Exported class '{0}' extends private class '{1}'.": {
            "code": 2018,
            "category": 1 /* Error */
        },
        "Exported class '{0}' implements private interface '{1}'.": {
            "code": 2019,
            "category": 1 /* Error */
        },
        "Exported interface '{0}' extends private interface '{1}'.": {
            "code": 2020,
            "category": 1 /* Error */
        },
        "Exported class '{0}' extends class from inaccessible module {1}.": {
            "code": 2021,
            "category": 1 /* Error */
        },
        "Exported class '{0}' implements interface from inaccessible module {1}.": {
            "code": 2022,
            "category": 1 /* Error */
        },
        "Exported interface '{0}' extends interface from inaccessible module {1}.": {
            "code": 2023,
            "category": 1 /* Error */
        },
        "Public static property '{0}' of exported class has or is using private type '{1}'.": {
            "code": 2024,
            "category": 1 /* Error */
        },
        "Public property '{0}' of exported class has or is using private type '{1}'.": {
            "code": 2025,
            "category": 1 /* Error */
        },
        "Property '{0}' of exported interface has or is using private type '{1}'.": {
            "code": 2026,
            "category": 1 /* Error */
        },
        "Exported variable '{0}' has or is using private type '{1}'.": {
            "code": 2027,
            "category": 1 /* Error */
        },
        "Public static property '{0}' of exported class is using inaccessible module {1}.": {
            "code": 2028,
            "category": 1 /* Error */
        },
        "Public property '{0}' of exported class is using inaccessible module {1}.": {
            "code": 2029,
            "category": 1 /* Error */
        },
        "Property '{0}' of exported interface is using inaccessible module {1}.": {
            "code": 2030,
            "category": 1 /* Error */
        },
        "Exported variable '{0}' is using inaccessible module {1}.": {
            "code": 2031,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of constructor from exported class has or is using private type '{1}'.": {
            "code": 2032,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public static property setter from exported class has or is using private type '{1}'.": {
            "code": 2033,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public property setter from exported class has or is using private type '{1}'.": {
            "code": 2034,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of constructor signature from exported interface has or is using private type '{1}'.": {
            "code": 2035,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of call signature from exported interface has or is using private type '{1}'.": {
            "code": 2036,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public static method from exported class has or is using private type '{1}'.": {
            "code": 2037,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public method from exported class has or is using private type '{1}'.": {
            "code": 2038,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of method from exported interface has or is using private type '{1}'.": {
            "code": 2039,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of exported function has or is using private type '{1}'.": {
            "code": 2040,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of constructor from exported class is using inaccessible module {1}.": {
            "code": 2041,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public static property setter from exported class is using inaccessible module {1}.": {
            "code": 2042,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public property setter from exported class is using inaccessible module {1}.": {
            "code": 2043,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of constructor signature from exported interface is using inaccessible module {1}.": {
            "code": 2044,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of call signature from exported interface is using inaccessible module {1}": {
            "code": 2045,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public static method from exported class is using inaccessible module {1}.": {
            "code": 2046,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of public method from exported class is using inaccessible module {1}.": {
            "code": 2047,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of method from exported interface is using inaccessible module {1}.": {
            "code": 2048,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of exported function is using inaccessible module {1}.": {
            "code": 2049,
            "category": 1 /* Error */
        },
        "Return type of public static property getter from exported class has or is using private type '{0}'.": {
            "code": 2050,
            "category": 1 /* Error */
        },
        "Return type of public property getter from exported class has or is using private type '{0}'.": {
            "code": 2051,
            "category": 1 /* Error */
        },
        "Return type of constructor signature from exported interface has or is using private type '{0}'.": {
            "code": 2052,
            "category": 1 /* Error */
        },
        "Return type of call signature from exported interface has or is using private type '{0}'.": {
            "code": 2053,
            "category": 1 /* Error */
        },
        "Return type of index signature from exported interface has or is using private type '{0}'.": {
            "code": 2054,
            "category": 1 /* Error */
        },
        "Return type of public static method from exported class has or is using private type '{0}'.": {
            "code": 2055,
            "category": 1 /* Error */
        },
        "Return type of public method from exported class has or is using private type '{0}'.": {
            "code": 2056,
            "category": 1 /* Error */
        },
        "Return type of method from exported interface has or is using private type '{0}'.": {
            "code": 2057,
            "category": 1 /* Error */
        },
        "Return type of exported function has or is using private type '{0}'.": {
            "code": 2058,
            "category": 1 /* Error */
        },
        "Return type of public static property getter from exported class is using inaccessible module {0}.": {
            "code": 2059,
            "category": 1 /* Error */
        },
        "Return type of public property getter from exported class is using inaccessible module {0}.": {
            "code": 2060,
            "category": 1 /* Error */
        },
        "Return type of constructor signature from exported interface is using inaccessible module {0}.": {
            "code": 2061,
            "category": 1 /* Error */
        },
        "Return type of call signature from exported interface is using inaccessible module {0}.": {
            "code": 2062,
            "category": 1 /* Error */
        },
        "Return type of index signature from exported interface is using inaccessible module {0}.": {
            "code": 2063,
            "category": 1 /* Error */
        },
        "Return type of public static method from exported class is using inaccessible module {0}.": {
            "code": 2064,
            "category": 1 /* Error */
        },
        "Return type of public method from exported class is using inaccessible module {0}.": {
            "code": 2065,
            "category": 1 /* Error */
        },
        "Return type of method from exported interface is using inaccessible module {0}.": {
            "code": 2066,
            "category": 1 /* Error */
        },
        "Return type of exported function is using inaccessible module {0}.": {
            "code": 2067,
            "category": 1 /* Error */
        },
        "'new T[]' cannot be used to create an array. Use 'new Array<T>()' instead.": {
            "code": 2068,
            "category": 1 /* Error */
        },
        "A parameter list must follow a generic type argument list. '(' expected.": {
            "code": 2069,
            "category": 1 /* Error */
        },
        "Multiple constructor implementations are not allowed.": {
            "code": 2070,
            "category": 1 /* Error */
        },
        "Unable to resolve external module '{0}'.": {
            "code": 2071,
            "category": 1 /* Error */
        },
        "Module cannot be aliased to a non-module type.": {
            "code": 2072,
            "category": 1 /* Error */
        },
        "A class may only extend another class.": {
            "code": 2073,
            "category": 1 /* Error */
        },
        "A class may only implement another class or interface.": {
            "code": 2074,
            "category": 1 /* Error */
        },
        "An interface may only extend another class or interface.": {
            "code": 2075,
            "category": 1 /* Error */
        },
        "Unable to resolve type.": {
            "code": 2077,
            "category": 1 /* Error */
        },
        "Unable to resolve type of '{0}'.": {
            "code": 2078,
            "category": 1 /* Error */
        },
        "Unable to resolve type parameter constraint.": {
            "code": 2079,
            "category": 1 /* Error */
        },
        "Type parameter constraint cannot be a primitive type.": {
            "code": 2080,
            "category": 1 /* Error */
        },
        "Supplied parameters do not match any signature of call target.": {
            "code": 2081,
            "category": 1 /* Error */
        },
        "Supplied parameters do not match any signature of call target:{NL}{0}": {
            "code": 2082,
            "category": 1 /* Error */
        },
        "Invalid 'new' expression.": {
            "code": 2083,
            "category": 1 /* Error */
        },
        "Call signatures used in a 'new' expression must have a 'void' return type.": {
            "code": 2084,
            "category": 1 /* Error */
        },
        "Could not select overload for 'new' expression.": {
            "code": 2085,
            "category": 1 /* Error */
        },
        "Type '{0}' does not satisfy the constraint '{1}' for type parameter '{2}'.": {
            "code": 2086,
            "category": 1 /* Error */
        },
        "Could not select overload for 'call' expression.": {
            "code": 2087,
            "category": 1 /* Error */
        },
        "Cannot invoke an expression whose type lacks a call signature.": {
            "code": 2088,
            "category": 1 /* Error */
        },
        "Calls to 'super' are only valid inside a class.": {
            "code": 2089,
            "category": 1 /* Error */
        },
        "Generic type '{0}' requires {1} type argument(s).": {
            "code": 2090,
            "category": 1 /* Error */
        },
        "Type of array literal cannot be determined. Best common type could not be found for array elements.": {
            "code": 2092,
            "category": 1 /* Error */
        },
        "Could not find enclosing symbol for dotted name '{0}'.": {
            "code": 2093,
            "category": 1 /* Error */
        },
        "The property '{0}' does not exist on value of type '{1}'.": {
            "code": 2094,
            "category": 1 /* Error */
        },
        "Could not find symbol '{0}'.": {
            "code": 2095,
            "category": 1 /* Error */
        },
        "'get' and 'set' accessor must have the same type.": {
            "code": 2096,
            "category": 1 /* Error */
        },
        "'this' cannot be referenced in current location.": {
            "code": 2097,
            "category": 1 /* Error */
        },
        "Static members cannot reference class type parameters.": {
            "code": 2099,
            "category": 1 /* Error */
        },
        "Class '{0}' is recursively referenced as a base type of itself.": {
            "code": 2100,
            "category": 1 /* Error */
        },
        "Interface '{0}' is recursively referenced as a base type of itself.": {
            "code": 2101,
            "category": 1 /* Error */
        },
        "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class.": {
            "code": 2102,
            "category": 1 /* Error */
        },
        "'super' cannot be referenced in non-derived classes.": {
            "code": 2103,
            "category": 1 /* Error */
        },
        "A 'super' call must be the first statement in the constructor when a class contains initialized properties or has parameter properties.": {
            "code": 2104,
            "category": 1 /* Error */
        },
        "Constructors for derived classes must contain a 'super' call.": {
            "code": 2105,
            "category": 1 /* Error */
        },
        "Super calls are not permitted outside constructors or in nested functions inside constructors.": {
            "code": 2106,
            "category": 1 /* Error */
        },
        "'{0}.{1}' is inaccessible.": {
            "code": 2107,
            "category": 1 /* Error */
        },
        "'this' cannot be referenced within module bodies.": {
            "code": 2108,
            "category": 1 /* Error */
        },
        "Invalid '+' expression - types not known to support the addition operator.": {
            "code": 2111,
            "category": 1 /* Error */
        },
        "The right-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type.": {
            "code": 2112,
            "category": 1 /* Error */
        },
        "The left-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type.": {
            "code": 2113,
            "category": 1 /* Error */
        },
        "The type of a unary arithmetic operation operand must be of type 'any', 'number' or an enum type.": {
            "code": 2114,
            "category": 1 /* Error */
        },
        "Variable declarations of a 'for' statement cannot use a type annotation.": {
            "code": 2115,
            "category": 1 /* Error */
        },
        "Variable declarations of a 'for' statement must be of types 'string' or 'any'.": {
            "code": 2116,
            "category": 1 /* Error */
        },
        "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter.": {
            "code": 2117,
            "category": 1 /* Error */
        },
        "The left-hand side of an 'in' expression must be of types 'any', 'string' or 'number'.": {
            "code": 2118,
            "category": 1 /* Error */
        },
        "The right-hand side of an 'in' expression must be of type 'any', an object type or a type parameter.": {
            "code": 2119,
            "category": 1 /* Error */
        },
        "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter.": {
            "code": 2120,
            "category": 1 /* Error */
        },
        "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type.": {
            "code": 2121,
            "category": 1 /* Error */
        },
        "Setters cannot return a value.": {
            "code": 2122,
            "category": 1 /* Error */
        },
        "Tried to query type of uninitialized module '{0}'.": {
            "code": 2123,
            "category": 1 /* Error */
        },
        "Tried to set variable type to uninitialized module type '{0}'.": {
            "code": 2124,
            "category": 1 /* Error */
        },
        "Type '{0}' does not have type parameters.": {
            "code": 2125,
            "category": 1 /* Error */
        },
        "Getters must return a value.": {
            "code": 2126,
            "category": 1 /* Error */
        },
        "Getter and setter accessors do not agree in visibility.": {
            "code": 2127,
            "category": 1 /* Error */
        },
        "Invalid left-hand side of assignment expression.": {
            "code": 2130,
            "category": 1 /* Error */
        },
        "Function declared a non-void return type, but has no return expression.": {
            "code": 2131,
            "category": 1 /* Error */
        },
        "Cannot resolve return type reference.": {
            "code": 2132,
            "category": 1 /* Error */
        },
        "Constructors cannot have a return type of 'void'.": {
            "code": 2133,
            "category": 1 /* Error */
        },
        "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'.": {
            "code": 2134,
            "category": 1 /* Error */
        },
        "All symbols within a with block will be resolved to 'any'.": {
            "code": 2135,
            "category": 1 /* Error */
        },
        "Import declarations in an internal module cannot reference an external module.": {
            "code": 2136,
            "category": 1 /* Error */
        },
        "Class {0} declares interface {1} but does not implement it:{NL}{2}": {
            "code": 2137,
            "category": 1 /* Error */
        },
        "Class {0} declares class {1} as an interface but does not implement it:{NL}{2}": {
            "code": 2138,
            "category": 1 /* Error */
        },
        "The operand of an increment or decrement operator must be a variable, property or indexer.": {
            "code": 2139,
            "category": 1 /* Error */
        },
        "'this' cannot be referenced in static initializers in a class body.": {
            "code": 2140,
            "category": 1 /* Error */
        },
        "Class '{0}' cannot extend class '{1}':{NL}{2}": {
            "code": 2141,
            "category": 1 /* Error */
        },
        "Interface '{0}' cannot extend class '{1}':{NL}{2}": {
            "code": 2142,
            "category": 1 /* Error */
        },
        "Interface '{0}' cannot extend interface '{1}':{NL}{2}": {
            "code": 2143,
            "category": 1 /* Error */
        },
        "Duplicate overload signature for '{0}'.": {
            "code": 2144,
            "category": 1 /* Error */
        },
        "Duplicate constructor overload signature.": {
            "code": 2145,
            "category": 1 /* Error */
        },
        "Duplicate overload call signature.": {
            "code": 2146,
            "category": 1 /* Error */
        },
        "Duplicate overload construct signature.": {
            "code": 2147,
            "category": 1 /* Error */
        },
        "Overload signature is not compatible with function definition.": {
            "code": 2148,
            "category": 1 /* Error */
        },
        "Overload signature is not compatible with function definition:{NL}{0}": {
            "code": 2149,
            "category": 1 /* Error */
        },
        "Overload signatures must all be public or private.": {
            "code": 2150,
            "category": 1 /* Error */
        },
        "Overload signatures must all be exported or not exported.": {
            "code": 2151,
            "category": 1 /* Error */
        },
        "Overload signatures must all be ambient or non-ambient.": {
            "code": 2152,
            "category": 1 /* Error */
        },
        "Overload signatures must all be optional or required.": {
            "code": 2153,
            "category": 1 /* Error */
        },
        "Specialized overload signature is not assignable to any non-specialized signature.": {
            "code": 2154,
            "category": 1 /* Error */
        },
        "'this' cannot be referenced in constructor arguments.": {
            "code": 2155,
            "category": 1 /* Error */
        },
        "Instance member cannot be accessed off a class.": {
            "code": 2157,
            "category": 1 /* Error */
        },
        "Untyped function calls may not accept type arguments.": {
            "code": 2158,
            "category": 1 /* Error */
        },
        "Non-generic functions may not accept type arguments.": {
            "code": 2159,
            "category": 1 /* Error */
        },
        "A generic type may not reference itself with a wrapped form of its own type parameters.": {
            "code": 2160,
            "category": 1 /* Error */
        },
        "Rest parameters must be array types.": {
            "code": 2162,
            "category": 1 /* Error */
        },
        "Overload signature implementation cannot use specialized type.": {
            "code": 2163,
            "category": 1 /* Error */
        },
        "Export assignments may only be used at the top-level of external modules.": {
            "code": 2164,
            "category": 1 /* Error */
        },
        "Export assignments may only be made with variables, functions, classes, interfaces, enums and internal modules.": {
            "code": 2165,
            "category": 1 /* Error */
        },
        "Only public methods of the base class are accessible via the 'super' keyword.": {
            "code": 2166,
            "category": 1 /* Error */
        },
        "Numeric indexer type '{0}' must be assignable to string indexer type '{1}'.": {
            "code": 2167,
            "category": 1 /* Error */
        },
        "Numeric indexer type '{0}' must be assignable to string indexer type '{1}':{NL}{2}": {
            "code": 2168,
            "category": 1 /* Error */
        },
        "All numerically named properties must be assignable to numeric indexer type '{0}'.": {
            "code": 2169,
            "category": 1 /* Error */
        },
        "All numerically named properties must be assignable to numeric indexer type '{0}':{NL}{1}": {
            "code": 2170,
            "category": 1 /* Error */
        },
        "All named properties must be assignable to string indexer type '{0}'.": {
            "code": 2171,
            "category": 1 /* Error */
        },
        "All named properties must be assignable to string indexer type '{0}':{NL}{1}": {
            "code": 2172,
            "category": 1 /* Error */
        },
        "Generic type references must include all type arguments.": {
            "code": 2173,
            "category": 1 /* Error */
        },
        "Default arguments are only allowed in implementation.": {
            "code": 2174,
            "category": 1 /* Error */
        },
        "Overloads cannot differ only by return type.": {
            "code": 2175,
            "category": 1 /* Error */
        },
        "Function expression declared a non-void return type, but has no return expression.": {
            "code": 2176,
            "category": 1 /* Error */
        },
        "Import declaration referencing identifier from internal module can only be made with variables, functions, classes, interfaces, enums and internal modules.": {
            "code": 2177,
            "category": 1 /* Error */
        },
        "Could not find symbol '{0}' in module '{1}'.": {
            "code": 2178,
            "category": 1 /* Error */
        },
        "Unable to resolve module reference '{0}'.": {
            "code": 2179,
            "category": 1 /* Error */
        },
        "Could not find module '{0}' in module '{1}'.": {
            "code": 2180,
            "category": 1 /* Error */
        },
        "Exported import declaration '{0}' is assigned value with type that has or is using private type '{1}'.": {
            "code": 2181,
            "category": 1 /* Error */
        },
        "Exported import declaration '{0}' is assigned value with type that is using inaccessible module '{1}'.": {
            "code": 2182,
            "category": 1 /* Error */
        },
        "Exported import declaration '{0}' is assigned type that has or is using private type '{1}'.": {
            "code": 2183,
            "category": 1 /* Error */
        },
        "Exported import declaration '{0}' is assigned type that is using inaccessible module '{1}'.": {
            "code": 2184,
            "category": 1 /* Error */
        },
        "Exported import declaration '{0}' is assigned container that is or is using inaccessible module '{1}'.": {
            "code": 2185,
            "category": 1 /* Error */
        },
        "Type name '{0}' in extends clause does not reference constructor function for '{1}'.": {
            "code": 2186,
            "category": 1 /* Error */
        },
        "Internal module reference '{0}' in import declaration does not reference module instance for '{1}'.": {
            "code": 2187,
            "category": 1 /* Error */
        },
        "Module '{0}' cannot merge with previous declaration of '{1}' in a different file '{2}'.": {
            "code": 2188,
            "category": 1 /* Error */
        },
        "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}':{NL}{3}": {
            "code": 2189,
            "category": 1 /* Error */
        },
        "Initializer of parameter '{0}' cannot reference identifier '{1}' declared after it.": {
            "code": 2190,
            "category": 1 /* Error */
        },
        "Ambient external module declaration cannot be reopened.": {
            "code": 2191,
            "category": 1 /* Error */
        },
        "All declarations of merged declaration '{0}' must be exported or not exported.": {
            "code": 2192,
            "category": 1 /* Error */
        },
        "'super' cannot be referenced in constructor arguments.": {
            "code": 2193,
            "category": 1 /* Error */
        },
        "Return type of constructor signature must be assignable to the instance type of the class.": {
            "code": 2194,
            "category": 1 /* Error */
        },
        "Ambient external module declaration must be defined in global context.": {
            "code": 2195,
            "category": 1 /* Error */
        },
        "Ambient external module declaration cannot specify relative module name.": {
            "code": 2196,
            "category": 1 /* Error */
        },
        "Import declaration in an ambient external module declaration cannot reference external module through relative external module name.": {
            "code": 2197,
            "category": 1 /* Error */
        },
        "Could not find the best common type of types of all return statement expressions.": {
            "code": 2198,
            "category": 1 /* Error */
        },
        "Import declaration cannot refer to external module reference when --noResolve option is set.": {
            "code": 2199,
            "category": 1 /* Error */
        },
        "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference.": {
            "code": 2200,
            "category": 1 /* Error */
        },
        "'continue' statement can only be used within an enclosing iteration statement.": {
            "code": 2201,
            "category": 1 /* Error */
        },
        "'break' statement can only be used within an enclosing iteration or switch statement.": {
            "code": 2202,
            "category": 1 /* Error */
        },
        "Jump target not found.": {
            "code": 2203,
            "category": 1 /* Error */
        },
        "Jump target cannot cross function boundary.": {
            "code": 2204,
            "category": 1 /* Error */
        },
        "Duplicate identifier '_super'. Compiler uses '_super' to capture base class reference.": {
            "code": 2205,
            "category": 1 /* Error */
        },
        "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference.": {
            "code": 2206,
            "category": 1 /* Error */
        },
        "Expression resolves to '_super' that compiler uses to capture base class reference.": {
            "code": 2207,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of constructor signature from exported interface has or is using private type '{1}'.": {
            "code": 2208,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of call signature from exported interface has or is using private type '{1}'.": {
            "code": 2209,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of public static method from exported class has or is using private type '{1}'.": {
            "code": 2210,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of public method from exported class has or is using private type '{1}'.": {
            "code": 2211,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of method from exported interface has or is using private type '{1}'.": {
            "code": 2212,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of exported function has or is using private type '{1}'.": {
            "code": 2213,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of constructor signature from exported interface is using inaccessible module {1}.": {
            "code": 2214,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of call signature from exported interface is using inaccessible module {1}": {
            "code": 2215,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of public static method from exported class is using inaccessible module {1}.": {
            "code": 2216,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of public method from exported class is using inaccessible module {1}.": {
            "code": 2217,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of method from exported interface is using inaccessible module {1}.": {
            "code": 2218,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of exported function is using inaccessible module {1}.": {
            "code": 2219,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of exported class has or is using private type '{1}'.": {
            "code": 2220,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of exported interface has or is using private type '{1}'.": {
            "code": 2221,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of exported class is using inaccessible module {1}.": {
            "code": 2222,
            "category": 1 /* Error */
        },
        "TypeParameter '{0}' of exported interface is using inaccessible module {1}.": {
            "code": 2223,
            "category": 1 /* Error */
        },
        "Duplicate identifier '_i'. Compiler uses '_i' to initialize rest parameter.": {
            "code": 2224,
            "category": 1 /* Error */
        },
        "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters.": {
            "code": 2225,
            "category": 1 /* Error */
        },
        "Type of conditional '{0}' must be identical to '{1}' or '{2}'.": {
            "code": 2226,
            "category": 1 /* Error */
        },
        "Type of conditional '{0}' must be identical to '{1}', '{2}' or '{3}'.": {
            "code": 2227,
            "category": 1 /* Error */
        },
        "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of an external module.": {
            "code": 2228,
            "category": 1 /* Error */
        },
        "Constraint of a type parameter cannot reference any type parameter from the same type parameter list.": {
            "code": 2229,
            "category": 1 /* Error */
        },
        "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor.": {
            "code": 2230,
            "category": 1 /* Error */
        },
        "Parameter '{0}' cannot be referenced in its initializer.": {
            "code": 2231,
            "category": 1 /* Error */
        },
        "Duplicate string index signature.": {
            "code": 2232,
            "category": 1 /* Error */
        },
        "Duplicate number index signature.": {
            "code": 2233,
            "category": 1 /* Error */
        },
        "All declarations of an interface must have identical type parameters.": {
            "code": 2234,
            "category": 1 /* Error */
        },
        "Expression resolves to variable declaration '_i' that compiler uses to initialize rest parameter.": {
            "code": 2235,
            "category": 1 /* Error */
        },
        "Type '{0}' is missing property '{1}' from type '{2}'.": {
            "code": 4000,
            "category": 3 /* NoPrefix */
        },
        "Types of property '{0}' of types '{1}' and '{2}' are incompatible.": {
            "code": 4001,
            "category": 3 /* NoPrefix */
        },
        "Types of property '{0}' of types '{1}' and '{2}' are incompatible:{NL}{3}": {
            "code": 4002,
            "category": 3 /* NoPrefix */
        },
        "Property '{0}' defined as private in type '{1}' is defined as public in type '{2}'.": {
            "code": 4003,
            "category": 3 /* NoPrefix */
        },
        "Property '{0}' defined as public in type '{1}' is defined as private in type '{2}'.": {
            "code": 4004,
            "category": 3 /* NoPrefix */
        },
        "Types '{0}' and '{1}' define property '{2}' as private.": {
            "code": 4005,
            "category": 3 /* NoPrefix */
        },
        "Call signatures of types '{0}' and '{1}' are incompatible.": {
            "code": 4006,
            "category": 3 /* NoPrefix */
        },
        "Call signatures of types '{0}' and '{1}' are incompatible:{NL}{2}": {
            "code": 4007,
            "category": 3 /* NoPrefix */
        },
        "Type '{0}' requires a call signature, but type '{1}' lacks one.": {
            "code": 4008,
            "category": 3 /* NoPrefix */
        },
        "Construct signatures of types '{0}' and '{1}' are incompatible.": {
            "code": 4009,
            "category": 3 /* NoPrefix */
        },
        "Construct signatures of types '{0}' and '{1}' are incompatible:{NL}{2}": {
            "code": 4010,
            "category": 3 /* NoPrefix */
        },
        "Type '{0}' requires a construct signature, but type '{1}' lacks one.": {
            "code": 4011,
            "category": 3 /* NoPrefix */
        },
        "Index signatures of types '{0}' and '{1}' are incompatible.": {
            "code": 4012,
            "category": 3 /* NoPrefix */
        },
        "Index signatures of types '{0}' and '{1}' are incompatible:{NL}{2}": {
            "code": 4013,
            "category": 3 /* NoPrefix */
        },
        "Call signature expects {0} or fewer parameters.": {
            "code": 4014,
            "category": 3 /* NoPrefix */
        },
        "Could not apply type '{0}' to argument {1} which is of type '{2}'.": {
            "code": 4015,
            "category": 3 /* NoPrefix */
        },
        "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function.": {
            "code": 4016,
            "category": 3 /* NoPrefix */
        },
        "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function.": {
            "code": 4017,
            "category": 3 /* NoPrefix */
        },
        "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor.": {
            "code": 4018,
            "category": 3 /* NoPrefix */
        },
        "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member property.": {
            "code": 4019,
            "category": 3 /* NoPrefix */
        },
        "Types of static property '{0}' of class '{1}' and class '{2}' are incompatible.": {
            "code": 4020,
            "category": 3 /* NoPrefix */
        },
        "Types of static property '{0}' of class '{1}' and class '{2}' are incompatible:{NL}{3}": {
            "code": 4021,
            "category": 3 /* NoPrefix */
        },
        "Type reference cannot refer to container '{0}'.": {
            "code": 4022,
            "category": 1 /* Error */
        },
        "Type reference must refer to type.": {
            "code": 4023,
            "category": 1 /* Error */
        },
        "In enums with multiple declarations only one declaration can omit an initializer for the first enum element.": {
            "code": 4024,
            "category": 1 /* Error */
        },
        " (+ {0} overload(s))": {
            "code": 4025,
            "category": 2 /* Message */
        },
        "Variable declaration cannot have the same name as an import declaration.": {
            "code": 4026,
            "category": 1 /* Error */
        },
        "Signature expected {0} type arguments, got {1} instead.": {
            "code": 4027,
            "category": 1 /* Error */
        },
        "Property '{0}' defined as optional in type '{1}', but is required in type '{2}'.": {
            "code": 4028,
            "category": 3 /* NoPrefix */
        },
        "Types '{0}' and '{1}' originating in infinitely expanding type reference do not refer to same named type.": {
            "code": 4029,
            "category": 3 /* NoPrefix */
        },
        "Types '{0}' and '{1}' originating in infinitely expanding type reference have incompatible type arguments.": {
            "code": 4030,
            "category": 3 /* NoPrefix */
        },
        "Types '{0}' and '{1}' originating in infinitely expanding type reference have incompatible type arguments:{NL}{2}": {
            "code": 4031,
            "category": 3 /* NoPrefix */
        },
        "Named properties '{0}' of types '{1}' and '{2}' are not identical.": {
            "code": 4032,
            "category": 3 /* NoPrefix */
        },
        "Types of string indexer of types '{0}' and '{1}' are not identical.": {
            "code": 4033,
            "category": 3 /* NoPrefix */
        },
        "Types of number indexer of types '{0}' and '{1}' are not identical.": {
            "code": 4034,
            "category": 3 /* NoPrefix */
        },
        "Type of number indexer in type '{0}' is not assignable to string indexer type in type '{1}'.{NL}{2}": {
            "code": 4035,
            "category": 3 /* NoPrefix */
        },
        "Type of property '{0}' in type '{1}' is not assignable to string indexer type in type '{2}'.{NL}{3}": {
            "code": 4036,
            "category": 3 /* NoPrefix */
        },
        "Type of property '{0}' in type '{1}' is not assignable to number indexer type in type '{2}'.{NL}{3}": {
            "code": 4037,
            "category": 3 /* NoPrefix */
        },
        "Static property '{0}' defined as private in type '{1}' is defined as public in type '{2}'.": {
            "code": 4038,
            "category": 3 /* NoPrefix */
        },
        "Static property '{0}' defined as public in type '{1}' is defined as private in type '{2}'.": {
            "code": 4039,
            "category": 3 /* NoPrefix */
        },
        "Types '{0}' and '{1}' define static property '{2}' as private.": {
            "code": 4040,
            "category": 3 /* NoPrefix */
        },
        "Current host does not support '{0}' option.": {
            "code": 5001,
            "category": 1 /* Error */
        },
        "ECMAScript target version '{0}' not supported.  Specify a valid target version: '{1}' (default), or '{2}'": {
            "code": 5002,
            "category": 1 /* Error */
        },
        "Module code generation '{0}' not supported.": {
            "code": 5003,
            "category": 1 /* Error */
        },
        "Could not find file: '{0}'.": {
            "code": 5004,
            "category": 1 /* Error */
        },
        "A file cannot have a reference to itself.": {
            "code": 5006,
            "category": 1 /* Error */
        },
        "Cannot resolve referenced file: '{0}'.": {
            "code": 5007,
            "category": 1 /* Error */
        },
        "Cannot find the common subdirectory path for the input files.": {
            "code": 5009,
            "category": 1 /* Error */
        },
        "Emit Error: {0}.": {
            "code": 5011,
            "category": 1 /* Error */
        },
        "Cannot read file '{0}': {1}": {
            "code": 5012,
            "category": 1 /* Error */
        },
        "Unsupported file encoding.": {
            "code": 5013,
            "category": 3 /* NoPrefix */
        },
        "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'.": {
            "code": 5014,
            "category": 1 /* Error */
        },
        "Unsupported locale: '{0}'.": {
            "code": 5015,
            "category": 1 /* Error */
        },
        "Execution Failed.{NL}": {
            "code": 5016,
            "category": 1 /* Error */
        },
        "Invalid call to 'up'": {
            "code": 5019,
            "category": 1 /* Error */
        },
        "Invalid call to 'down'": {
            "code": 5020,
            "category": 1 /* Error */
        },
        "Base64 value '{0}' finished with a continuation bit.": {
            "code": 5021,
            "category": 1 /* Error */
        },
        "Unknown option '{0}'": {
            "code": 5023,
            "category": 1 /* Error */
        },
        "Expected {0} arguments to message, got {1} instead.": {
            "code": 5024,
            "category": 1 /* Error */
        },
        "Expected the message '{0}' to have {1} arguments, but it had {2}": {
            "code": 5025,
            "category": 1 /* Error */
        },
        "Could not delete file '{0}'": {
            "code": 5034,
            "category": 1 /* Error */
        },
        "Could not create directory '{0}'": {
            "code": 5035,
            "category": 1 /* Error */
        },
        "Error while executing file '{0}': ": {
            "code": 5036,
            "category": 1 /* Error */
        },
        "Cannot compile external modules unless the '--module' flag is provided.": {
            "code": 5037,
            "category": 1 /* Error */
        },
        "Option mapRoot cannot be specified without specifying sourcemap option.": {
            "code": 5038,
            "category": 1 /* Error */
        },
        "Option sourceRoot cannot be specified without specifying sourcemap option.": {
            "code": 5039,
            "category": 1 /* Error */
        },
        "Options mapRoot and sourceRoot cannot be specified without specifying sourcemap option.": {
            "code": 5040,
            "category": 1 /* Error */
        },
        "Option '{0}' specified without '{1}'": {
            "code": 5041,
            "category": 1 /* Error */
        },
        "'codepage' option not supported on current platform.": {
            "code": 5042,
            "category": 1 /* Error */
        },
        "Concatenate and emit output to single file.": {
            "code": 6001,
            "category": 2 /* Message */
        },
        "Generates corresponding {0} file.": {
            "code": 6002,
            "category": 2 /* Message */
        },
        "Specifies the location where debugger should locate map files instead of generated locations.": {
            "code": 6003,
            "category": 2 /* Message */
        },
        "Specifies the location where debugger should locate TypeScript files instead of source locations.": {
            "code": 6004,
            "category": 2 /* Message */
        },
        "Watch input files.": {
            "code": 6005,
            "category": 2 /* Message */
        },
        "Redirect output structure to the directory.": {
            "code": 6006,
            "category": 2 /* Message */
        },
        "Do not emit comments to output.": {
            "code": 6009,
            "category": 2 /* Message */
        },
        "Skip resolution and preprocessing.": {
            "code": 6010,
            "category": 2 /* Message */
        },
        "Specify ECMAScript target version: '{0}' (default), or '{1}'": {
            "code": 6015,
            "category": 2 /* Message */
        },
        "Specify module code generation: '{0}' or '{1}'": {
            "code": 6016,
            "category": 2 /* Message */
        },
        "Print this message.": {
            "code": 6017,
            "category": 2 /* Message */
        },
        "Print the compiler's version: {0}": {
            "code": 6019,
            "category": 2 /* Message */
        },
        "Allow use of deprecated '{0}' keyword when referencing an external module.": {
            "code": 6021,
            "category": 2 /* Message */
        },
        "Specify locale for errors and messages. For example '{0}' or '{1}'": {
            "code": 6022,
            "category": 2 /* Message */
        },
        "Syntax:   {0}": {
            "code": 6023,
            "category": 2 /* Message */
        },
        "options": {
            "code": 6024,
            "category": 2 /* Message */
        },
        "file1": {
            "code": 6025,
            "category": 2 /* Message */
        },
        "Examples:": {
            "code": 6026,
            "category": 2 /* Message */
        },
        "Options:": {
            "code": 6027,
            "category": 2 /* Message */
        },
        "Insert command line options and files from a file.": {
            "code": 6030,
            "category": 2 /* Message */
        },
        "Version {0}": {
            "code": 6029,
            "category": 2 /* Message */
        },
        "Use the '{0}' flag to see options.": {
            "code": 6031,
            "category": 2 /* Message */
        },
        "{NL}Recompiling ({0}):": {
            "code": 6032,
            "category": 2 /* Message */
        },
        "STRING": {
            "code": 6033,
            "category": 2 /* Message */
        },
        "KIND": {
            "code": 6034,
            "category": 2 /* Message */
        },
        "file2": {
            "code": 6035,
            "category": 2 /* Message */
        },
        "VERSION": {
            "code": 6036,
            "category": 2 /* Message */
        },
        "LOCATION": {
            "code": 6037,
            "category": 2 /* Message */
        },
        "DIRECTORY": {
            "code": 6038,
            "category": 2 /* Message */
        },
        "NUMBER": {
            "code": 6039,
            "category": 2 /* Message */
        },
        "Specify the codepage to use when opening source files.": {
            "code": 6040,
            "category": 2 /* Message */
        },
        "Additional locations:": {
            "code": 6041,
            "category": 2 /* Message */
        },
        "This version of the Javascript runtime does not support the '{0}' function.": {
            "code": 7000,
            "category": 1 /* Error */
        },
        "Unknown rule.": {
            "code": 7002,
            "category": 1 /* Error */
        },
        "Invalid line number ({0})": {
            "code": 7003,
            "category": 1 /* Error */
        },
        "Warn on expressions and declarations with an implied 'any' type.": {
            "code": 7004,
            "category": 2 /* Message */
        },
        "Variable '{0}' implicitly has an 'any' type.": {
            "code": 7005,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of '{1}' implicitly has an 'any' type.": {
            "code": 7006,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of function type implicitly has an 'any' type.": {
            "code": 7007,
            "category": 1 /* Error */
        },
        "Member '{0}' of object type implicitly has an 'any' type.": {
            "code": 7008,
            "category": 1 /* Error */
        },
        "'new' expression, which lacks a constructor signature, implicitly has an 'any' type.": {
            "code": 7009,
            "category": 1 /* Error */
        },
        "'{0}', which lacks return-type annotation, implicitly has an 'any' return type.": {
            "code": 7010,
            "category": 1 /* Error */
        },
        "Function expression, which lacks return-type annotation, implicitly has an 'any' return type.": {
            "code": 7011,
            "category": 1 /* Error */
        },
        "Parameter '{0}' of lambda function implicitly has an 'any' type.": {
            "code": 7012,
            "category": 1 /* Error */
        },
        "Constructor signature, which lacks return-type annotation, implicitly has an 'any' return type.": {
            "code": 7013,
            "category": 1 /* Error */
        },
        "Lambda Function, which lacks return-type annotation, implicitly has an 'any' return type.": {
            "code": 7014,
            "category": 1 /* Error */
        },
        "Array Literal implicitly has an 'any' type from widening.": {
            "code": 7015,
            "category": 1 /* Error */
        },
        "'{0}', which lacks 'get' accessor and parameter type annotation on 'set' accessor, implicitly has an 'any' type.": {
            "code": 7016,
            "category": 1 /* Error */
        },
        "Index signature of object type implicitly has an 'any' type.": {
            "code": 7017,
            "category": 1 /* Error */
        },
        "Object literal's property '{0}' implicitly has an 'any' type from widening.": {
            "code": 7018,
            "category": 1 /* Error */
        }
    };
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (CharacterCodes) {
        CharacterCodes[CharacterCodes["nullCharacter"] = 0] = "nullCharacter";
        CharacterCodes[CharacterCodes["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";

        CharacterCodes[CharacterCodes["lineFeed"] = 10] = "lineFeed";
        CharacterCodes[CharacterCodes["carriageReturn"] = 13] = "carriageReturn";
        CharacterCodes[CharacterCodes["lineSeparator"] = 0x2028] = "lineSeparator";
        CharacterCodes[CharacterCodes["paragraphSeparator"] = 0x2029] = "paragraphSeparator";

        CharacterCodes[CharacterCodes["nextLine"] = 0x0085] = "nextLine";

        CharacterCodes[CharacterCodes["space"] = 0x0020] = "space";
        CharacterCodes[CharacterCodes["nonBreakingSpace"] = 0x00A0] = "nonBreakingSpace";
        CharacterCodes[CharacterCodes["enQuad"] = 0x2000] = "enQuad";
        CharacterCodes[CharacterCodes["emQuad"] = 0x2001] = "emQuad";
        CharacterCodes[CharacterCodes["enSpace"] = 0x2002] = "enSpace";
        CharacterCodes[CharacterCodes["emSpace"] = 0x2003] = "emSpace";
        CharacterCodes[CharacterCodes["threePerEmSpace"] = 0x2004] = "threePerEmSpace";
        CharacterCodes[CharacterCodes["fourPerEmSpace"] = 0x2005] = "fourPerEmSpace";
        CharacterCodes[CharacterCodes["sixPerEmSpace"] = 0x2006] = "sixPerEmSpace";
        CharacterCodes[CharacterCodes["figureSpace"] = 0x2007] = "figureSpace";
        CharacterCodes[CharacterCodes["punctuationSpace"] = 0x2008] = "punctuationSpace";
        CharacterCodes[CharacterCodes["thinSpace"] = 0x2009] = "thinSpace";
        CharacterCodes[CharacterCodes["hairSpace"] = 0x200A] = "hairSpace";
        CharacterCodes[CharacterCodes["zeroWidthSpace"] = 0x200B] = "zeroWidthSpace";
        CharacterCodes[CharacterCodes["narrowNoBreakSpace"] = 0x202F] = "narrowNoBreakSpace";
        CharacterCodes[CharacterCodes["ideographicSpace"] = 0x3000] = "ideographicSpace";

        CharacterCodes[CharacterCodes["_"] = 95] = "_";
        CharacterCodes[CharacterCodes["$"] = 36] = "$";

        CharacterCodes[CharacterCodes["_0"] = 48] = "_0";
        CharacterCodes[CharacterCodes["_7"] = 55] = "_7";
        CharacterCodes[CharacterCodes["_9"] = 57] = "_9";

        CharacterCodes[CharacterCodes["a"] = 97] = "a";
        CharacterCodes[CharacterCodes["b"] = 98] = "b";
        CharacterCodes[CharacterCodes["c"] = 99] = "c";
        CharacterCodes[CharacterCodes["d"] = 100] = "d";
        CharacterCodes[CharacterCodes["e"] = 101] = "e";
        CharacterCodes[CharacterCodes["f"] = 102] = "f";
        CharacterCodes[CharacterCodes["g"] = 103] = "g";
        CharacterCodes[CharacterCodes["h"] = 104] = "h";
        CharacterCodes[CharacterCodes["i"] = 105] = "i";
        CharacterCodes[CharacterCodes["k"] = 107] = "k";
        CharacterCodes[CharacterCodes["l"] = 108] = "l";
        CharacterCodes[CharacterCodes["m"] = 109] = "m";
        CharacterCodes[CharacterCodes["n"] = 110] = "n";
        CharacterCodes[CharacterCodes["o"] = 111] = "o";
        CharacterCodes[CharacterCodes["p"] = 112] = "p";
        CharacterCodes[CharacterCodes["q"] = 113] = "q";
        CharacterCodes[CharacterCodes["r"] = 114] = "r";
        CharacterCodes[CharacterCodes["s"] = 115] = "s";
        CharacterCodes[CharacterCodes["t"] = 116] = "t";
        CharacterCodes[CharacterCodes["u"] = 117] = "u";
        CharacterCodes[CharacterCodes["v"] = 118] = "v";
        CharacterCodes[CharacterCodes["w"] = 119] = "w";
        CharacterCodes[CharacterCodes["x"] = 120] = "x";
        CharacterCodes[CharacterCodes["y"] = 121] = "y";
        CharacterCodes[CharacterCodes["z"] = 122] = "z";

        CharacterCodes[CharacterCodes["A"] = 65] = "A";
        CharacterCodes[CharacterCodes["E"] = 69] = "E";
        CharacterCodes[CharacterCodes["F"] = 70] = "F";
        CharacterCodes[CharacterCodes["X"] = 88] = "X";
        CharacterCodes[CharacterCodes["Z"] = 90] = "Z";

        CharacterCodes[CharacterCodes["ampersand"] = 38] = "ampersand";
        CharacterCodes[CharacterCodes["asterisk"] = 42] = "asterisk";
        CharacterCodes[CharacterCodes["at"] = 64] = "at";
        CharacterCodes[CharacterCodes["backslash"] = 92] = "backslash";
        CharacterCodes[CharacterCodes["bar"] = 124] = "bar";
        CharacterCodes[CharacterCodes["caret"] = 94] = "caret";
        CharacterCodes[CharacterCodes["closeBrace"] = 125] = "closeBrace";
        CharacterCodes[CharacterCodes["closeBracket"] = 93] = "closeBracket";
        CharacterCodes[CharacterCodes["closeParen"] = 41] = "closeParen";
        CharacterCodes[CharacterCodes["colon"] = 58] = "colon";
        CharacterCodes[CharacterCodes["comma"] = 44] = "comma";
        CharacterCodes[CharacterCodes["dot"] = 46] = "dot";
        CharacterCodes[CharacterCodes["doubleQuote"] = 34] = "doubleQuote";
        CharacterCodes[CharacterCodes["equals"] = 61] = "equals";
        CharacterCodes[CharacterCodes["exclamation"] = 33] = "exclamation";
        CharacterCodes[CharacterCodes["greaterThan"] = 62] = "greaterThan";
        CharacterCodes[CharacterCodes["lessThan"] = 60] = "lessThan";
        CharacterCodes[CharacterCodes["minus"] = 45] = "minus";
        CharacterCodes[CharacterCodes["openBrace"] = 123] = "openBrace";
        CharacterCodes[CharacterCodes["openBracket"] = 91] = "openBracket";
        CharacterCodes[CharacterCodes["openParen"] = 40] = "openParen";
        CharacterCodes[CharacterCodes["percent"] = 37] = "percent";
        CharacterCodes[CharacterCodes["plus"] = 43] = "plus";
        CharacterCodes[CharacterCodes["question"] = 63] = "question";
        CharacterCodes[CharacterCodes["semicolon"] = 59] = "semicolon";
        CharacterCodes[CharacterCodes["singleQuote"] = 39] = "singleQuote";
        CharacterCodes[CharacterCodes["slash"] = 47] = "slash";
        CharacterCodes[CharacterCodes["tilde"] = 126] = "tilde";

        CharacterCodes[CharacterCodes["backspace"] = 8] = "backspace";
        CharacterCodes[CharacterCodes["formFeed"] = 12] = "formFeed";
        CharacterCodes[CharacterCodes["byteOrderMark"] = 0xFEFF] = "byteOrderMark";
        CharacterCodes[CharacterCodes["tab"] = 9] = "tab";
        CharacterCodes[CharacterCodes["verticalTab"] = 11] = "verticalTab";
    })(TypeScript.CharacterCodes || (TypeScript.CharacterCodes = {}));
    var CharacterCodes = TypeScript.CharacterCodes;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    

    (function (ScriptSnapshot) {
        var StringScriptSnapshot = (function () {
            function StringScriptSnapshot(text) {
                this.text = text;
                this._lineStartPositions = null;
            }
            StringScriptSnapshot.prototype.getText = function (start, end) {
                return this.text.substring(start, end);
            };

            StringScriptSnapshot.prototype.getLength = function () {
                return this.text.length;
            };

            StringScriptSnapshot.prototype.getLineStartPositions = function () {
                if (!this._lineStartPositions) {
                    this._lineStartPositions = TypeScript.TextUtilities.parseLineStarts(this.text);
                }

                return this._lineStartPositions;
            };

            StringScriptSnapshot.prototype.getTextChangeRangeSinceVersion = function (scriptVersion) {
                throw TypeScript.Errors.notYetImplemented();
            };
            return StringScriptSnapshot;
        })();

        function fromString(text) {
            return new StringScriptSnapshot(text);
        }
        ScriptSnapshot.fromString = fromString;
    })(TypeScript.ScriptSnapshot || (TypeScript.ScriptSnapshot = {}));
    var ScriptSnapshot = TypeScript.ScriptSnapshot;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (LineMap1) {
        function fromSimpleText(text) {
            return new TypeScript.LineMap(function () {
                return TypeScript.TextUtilities.parseLineStarts({ charCodeAt: function (index) {
                        return text.charCodeAt(index);
                    }, length: text.length() });
            }, text.length());
        }
        LineMap1.fromSimpleText = fromSimpleText;

        function fromScriptSnapshot(scriptSnapshot) {
            return new TypeScript.LineMap(function () {
                return scriptSnapshot.getLineStartPositions();
            }, scriptSnapshot.getLength());
        }
        LineMap1.fromScriptSnapshot = fromScriptSnapshot;

        function fromString(text) {
            return new TypeScript.LineMap(function () {
                return TypeScript.TextUtilities.parseLineStarts(text);
            }, text.length);
        }
        LineMap1.fromString = fromString;
    })(TypeScript.LineMap1 || (TypeScript.LineMap1 = {}));
    var LineMap1 = TypeScript.LineMap1;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (TextFactory) {
        function getStartAndLengthOfLineBreakEndingAt(text, index, info) {
            var c = text.charCodeAt(index);
            if (c === 10 /* lineFeed */) {
                if (index > 0 && text.charCodeAt(index - 1) === 13 /* carriageReturn */) {
                    info.startPosition = index - 1;
                    info.length = 2;
                } else {
                    info.startPosition = index;
                    info.length = 1;
                }
            } else if (TypeScript.TextUtilities.isAnyLineBreakCharacter(c)) {
                info.startPosition = index;
                info.length = 1;
            } else {
                info.startPosition = index + 1;
                info.length = 0;
            }
        }

        var LinebreakInfo = (function () {
            function LinebreakInfo(startPosition, length) {
                this.startPosition = startPosition;
                this.length = length;
            }
            return LinebreakInfo;
        })();

        var TextLine = (function () {
            function TextLine(text, body, lineBreakLength, lineNumber) {
                this._text = null;
                this._textSpan = null;
                if (text === null) {
                    throw TypeScript.Errors.argumentNull('text');
                }
                TypeScript.Debug.assert(lineBreakLength >= 0);
                TypeScript.Debug.assert(lineNumber >= 0);
                this._text = text;
                this._textSpan = body;
                this._lineBreakLength = lineBreakLength;
                this._lineNumber = lineNumber;
            }
            TextLine.prototype.start = function () {
                return this._textSpan.start();
            };

            TextLine.prototype.end = function () {
                return this._textSpan.end();
            };

            TextLine.prototype.endIncludingLineBreak = function () {
                return this.end() + this._lineBreakLength;
            };

            TextLine.prototype.extent = function () {
                return this._textSpan;
            };

            TextLine.prototype.extentIncludingLineBreak = function () {
                return TypeScript.TextSpan.fromBounds(this.start(), this.endIncludingLineBreak());
            };

            TextLine.prototype.toString = function () {
                return this._text.toString(this._textSpan);
            };

            TextLine.prototype.lineNumber = function () {
                return this._lineNumber;
            };
            return TextLine;
        })();

        var TextBase = (function () {
            function TextBase() {
                this.linebreakInfo = new LinebreakInfo(0, 0);
                this.lastLineFoundForPosition = null;
            }
            TextBase.prototype.length = function () {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.charCodeAt = function (position) {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.checkSubSpan = function (span) {
                if (span.start() < 0 || span.start() > this.length() || span.end() > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("span");
                }
            };

            TextBase.prototype.toString = function (span) {
                if (typeof span === "undefined") { span = null; }
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.subText = function (span) {
                this.checkSubSpan(span);

                return new SubText(this, span);
            };

            TextBase.prototype.substr = function (start, length, intern) {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.lineCount = function () {
                return this._lineStarts().length;
            };

            TextBase.prototype.lines = function () {
                var lines = [];

                var length = this.lineCount();
                for (var i = 0; i < length; ++i) {
                    lines[i] = this.getLineFromLineNumber(i);
                }

                return lines;
            };

            TextBase.prototype.lineMap = function () {
                var _this = this;
                return new TypeScript.LineMap(function () {
                    return _this._lineStarts();
                }, this.length());
            };

            TextBase.prototype._lineStarts = function () {
                throw TypeScript.Errors.abstract();
            };

            TextBase.prototype.getLineFromLineNumber = function (lineNumber) {
                var lineStarts = this._lineStarts();

                if (lineNumber < 0 || lineNumber >= lineStarts.length) {
                    throw TypeScript.Errors.argumentOutOfRange("lineNumber");
                }

                var first = lineStarts[lineNumber];
                if (lineNumber === lineStarts.length - 1) {
                    return new TextLine(this, new TypeScript.TextSpan(first, this.length() - first), 0, lineNumber);
                } else {
                    getStartAndLengthOfLineBreakEndingAt(this, lineStarts[lineNumber + 1] - 1, this.linebreakInfo);
                    return new TextLine(this, new TypeScript.TextSpan(first, this.linebreakInfo.startPosition - first), this.linebreakInfo.length, lineNumber);
                }
            };

            TextBase.prototype.getLineFromPosition = function (position) {
                var lastFound = this.lastLineFoundForPosition;
                if (lastFound !== null && lastFound.start() <= position && lastFound.endIncludingLineBreak() > position) {
                    return lastFound;
                }

                var lineNumber = this.getLineNumberFromPosition(position);

                var result = this.getLineFromLineNumber(lineNumber);
                this.lastLineFoundForPosition = result;
                return result;
            };

            TextBase.prototype.getLineNumberFromPosition = function (position) {
                if (position < 0 || position > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                if (position === this.length()) {
                    return this.lineCount() - 1;
                }

                var lineNumber = TypeScript.ArrayUtilities.binarySearch(this._lineStarts(), position);
                if (lineNumber < 0) {
                    lineNumber = (~lineNumber) - 1;
                }

                return lineNumber;
            };

            TextBase.prototype.getLinePosition = function (position) {
                if (position < 0 || position > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                var lineNumber = this.getLineNumberFromPosition(position);

                return new TypeScript.LineAndCharacter(lineNumber, position - this._lineStarts()[lineNumber]);
            };
            return TextBase;
        })();

        var SubText = (function (_super) {
            __extends(SubText, _super);
            function SubText(text, span) {
                _super.call(this);
                this._lazyLineStarts = null;

                if (text === null) {
                    throw TypeScript.Errors.argumentNull("text");
                }

                if (span.start() < 0 || span.start() >= text.length() || span.end() < 0 || span.end() > text.length()) {
                    throw TypeScript.Errors.argument("span");
                }

                this.text = text;
                this.span = span;
            }
            SubText.prototype.length = function () {
                return this.span.length();
            };

            SubText.prototype.charCodeAt = function (position) {
                if (position < 0 || position > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                return this.text.charCodeAt(this.span.start() + position);
            };

            SubText.prototype.subText = function (span) {
                this.checkSubSpan(span);

                return new SubText(this.text, this.getCompositeSpan(span.start(), span.length()));
            };

            SubText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                var span = this.getCompositeSpan(sourceIndex, count);
                this.text.copyTo(span.start(), destination, destinationIndex, span.length());
            };

            SubText.prototype.substr = function (start, length, intern) {
                var startInOriginalText = this.span.start() + start;
                return this.text.substr(startInOriginalText, length, intern);
            };

            SubText.prototype.getCompositeSpan = function (start, length) {
                var compositeStart = TypeScript.MathPrototype.min(this.text.length(), this.span.start() + start);
                var compositeEnd = TypeScript.MathPrototype.min(this.text.length(), compositeStart + length);
                return new TypeScript.TextSpan(compositeStart, compositeEnd - compositeStart);
            };

            SubText.prototype._lineStarts = function () {
                var _this = this;
                if (!this._lazyLineStarts) {
                    this._lazyLineStarts = TypeScript.TextUtilities.parseLineStarts({ charCodeAt: function (index) {
                            return _this.charCodeAt(index);
                        }, length: this.length() });
                }

                return this._lazyLineStarts;
            };
            return SubText;
        })(TextBase);

        var StringText = (function (_super) {
            __extends(StringText, _super);
            function StringText(data) {
                _super.call(this);
                this.source = null;
                this._lazyLineStarts = null;

                if (data === null) {
                    throw TypeScript.Errors.argumentNull("data");
                }

                this.source = data;
            }
            StringText.prototype.length = function () {
                return this.source.length;
            };

            StringText.prototype.charCodeAt = function (position) {
                if (position < 0 || position >= this.source.length) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }

                return this.source.charCodeAt(position);
            };

            StringText.prototype.substr = function (start, length, intern) {
                return this.source.substr(start, length);
            };

            StringText.prototype.toString = function (span) {
                if (typeof span === "undefined") { span = null; }
                if (span === null) {
                    span = new TypeScript.TextSpan(0, this.length());
                }

                this.checkSubSpan(span);

                if (span.start() === 0 && span.length() === this.length()) {
                    return this.source;
                }

                return this.source.substr(span.start(), span.length());
            };

            StringText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                TypeScript.StringUtilities.copyTo(this.source, sourceIndex, destination, destinationIndex, count);
            };

            StringText.prototype._lineStarts = function () {
                if (this._lazyLineStarts === null) {
                    this._lazyLineStarts = TypeScript.TextUtilities.parseLineStarts(this.source);
                }

                return this._lazyLineStarts;
            };
            return StringText;
        })(TextBase);

        function createText(value) {
            return new StringText(value);
        }
        TextFactory.createText = createText;
    })(TypeScript.TextFactory || (TypeScript.TextFactory = {}));
    var TextFactory = TypeScript.TextFactory;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    (function (SimpleText) {
        var SimpleSubText = (function () {
            function SimpleSubText(text, span) {
                this.text = null;
                this.span = null;
                if (text === null) {
                    throw TypeScript.Errors.argumentNull("text");
                }

                if (span.start() < 0 || span.start() >= text.length() || span.end() < 0 || span.end() > text.length()) {
                    throw TypeScript.Errors.argument("span");
                }

                this.text = text;
                this.span = span;
            }
            SimpleSubText.prototype.checkSubSpan = function (span) {
                if (span.start() < 0 || span.start() > this.length() || span.end() > this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("span");
                }
            };

            SimpleSubText.prototype.checkSubPosition = function (position) {
                if (position < 0 || position >= this.length()) {
                    throw TypeScript.Errors.argumentOutOfRange("position");
                }
            };

            SimpleSubText.prototype.length = function () {
                return this.span.length();
            };

            SimpleSubText.prototype.subText = function (span) {
                this.checkSubSpan(span);

                return new SimpleSubText(this.text, this.getCompositeSpan(span.start(), span.length()));
            };

            SimpleSubText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                var span = this.getCompositeSpan(sourceIndex, count);
                this.text.copyTo(span.start(), destination, destinationIndex, span.length());
            };

            SimpleSubText.prototype.substr = function (start, length, intern) {
                var span = this.getCompositeSpan(start, length);
                return this.text.substr(span.start(), span.length(), intern);
            };

            SimpleSubText.prototype.getCompositeSpan = function (start, length) {
                var compositeStart = TypeScript.MathPrototype.min(this.text.length(), this.span.start() + start);
                var compositeEnd = TypeScript.MathPrototype.min(this.text.length(), compositeStart + length);
                return new TypeScript.TextSpan(compositeStart, compositeEnd - compositeStart);
            };

            SimpleSubText.prototype.charCodeAt = function (index) {
                this.checkSubPosition(index);
                return this.text.charCodeAt(this.span.start() + index);
            };

            SimpleSubText.prototype.lineMap = function () {
                return TypeScript.LineMap1.fromSimpleText(this);
            };
            return SimpleSubText;
        })();

        var SimpleStringText = (function () {
            function SimpleStringText(value) {
                this.value = value;
                this._lineMap = null;
            }
            SimpleStringText.prototype.length = function () {
                return this.value.length;
            };

            SimpleStringText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                TypeScript.StringUtilities.copyTo(this.value, sourceIndex, destination, destinationIndex, count);
            };

            SimpleStringText.prototype.substr = function (start, length, intern) {
                if (intern) {
                    var array = length <= SimpleStringText.charArray.length ? SimpleStringText.charArray : TypeScript.ArrayUtilities.createArray(length, 0);
                    this.copyTo(start, array, 0, length);
                    return TypeScript.Collections.DefaultStringTable.addCharArray(array, 0, length);
                }

                return this.value.substr(start, length);
            };

            SimpleStringText.prototype.subText = function (span) {
                return new SimpleSubText(this, span);
            };

            SimpleStringText.prototype.charCodeAt = function (index) {
                return this.value.charCodeAt(index);
            };

            SimpleStringText.prototype.lineMap = function () {
                if (!this._lineMap) {
                    this._lineMap = TypeScript.LineMap1.fromString(this.value);
                }

                return this._lineMap;
            };
            SimpleStringText.charArray = TypeScript.ArrayUtilities.createArray(1024, 0);
            return SimpleStringText;
        })();

        var SimpleScriptSnapshotText = (function () {
            function SimpleScriptSnapshotText(scriptSnapshot) {
                this.scriptSnapshot = scriptSnapshot;
            }
            SimpleScriptSnapshotText.prototype.charCodeAt = function (index) {
                return this.scriptSnapshot.getText(index, index + 1).charCodeAt(0);
            };

            SimpleScriptSnapshotText.prototype.length = function () {
                return this.scriptSnapshot.getLength();
            };

            SimpleScriptSnapshotText.prototype.copyTo = function (sourceIndex, destination, destinationIndex, count) {
                var text = this.scriptSnapshot.getText(sourceIndex, sourceIndex + count);
                TypeScript.StringUtilities.copyTo(text, 0, destination, destinationIndex, count);
            };

            SimpleScriptSnapshotText.prototype.substr = function (start, length, intern) {
                return this.scriptSnapshot.getText(start, start + length);
            };

            SimpleScriptSnapshotText.prototype.subText = function (span) {
                return new SimpleSubText(this, span);
            };

            SimpleScriptSnapshotText.prototype.lineMap = function () {
                var _this = this;
                return new TypeScript.LineMap(function () {
                    return _this.scriptSnapshot.getLineStartPositions();
                }, this.length());
            };
            return SimpleScriptSnapshotText;
        })();

        function fromString(value) {
            return new SimpleStringText(value);
        }
        SimpleText.fromString = fromString;

        function fromScriptSnapshot(scriptSnapshot) {
            return new SimpleScriptSnapshotText(scriptSnapshot);
        }
        SimpleText.fromScriptSnapshot = fromScriptSnapshot;
    })(TypeScript.SimpleText || (TypeScript.SimpleText = {}));
    var SimpleText = TypeScript.SimpleText;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (TextUtilities) {
        function parseLineStarts(text) {
            var length = text.length;

            if (0 === length) {
                var result = new Array();
                result.push(0);
                return result;
            }

            var position = 0;
            var index = 0;
            var arrayBuilder = new Array();
            var lineNumber = 0;

            while (index < length) {
                var c = text.charCodeAt(index);
                var lineBreakLength;

                if (c > 13 /* carriageReturn */ && c <= 127) {
                    index++;
                    continue;
                } else if (c === 13 /* carriageReturn */ && index + 1 < length && text.charCodeAt(index + 1) === 10 /* lineFeed */) {
                    lineBreakLength = 2;
                } else if (c === 10 /* lineFeed */) {
                    lineBreakLength = 1;
                } else {
                    lineBreakLength = TextUtilities.getLengthOfLineBreak(text, index);
                }

                if (0 === lineBreakLength) {
                    index++;
                } else {
                    arrayBuilder.push(position);
                    index += lineBreakLength;
                    position = index;
                    lineNumber++;
                }
            }

            arrayBuilder.push(position);

            return arrayBuilder;
        }
        TextUtilities.parseLineStarts = parseLineStarts;

        function getLengthOfLineBreakSlow(text, index, c) {
            if (c === 13 /* carriageReturn */) {
                var next = index + 1;
                return (next < text.length) && 10 /* lineFeed */ === text.charCodeAt(next) ? 2 : 1;
            } else if (isAnyLineBreakCharacter(c)) {
                return 1;
            } else {
                return 0;
            }
        }
        TextUtilities.getLengthOfLineBreakSlow = getLengthOfLineBreakSlow;

        function getLengthOfLineBreak(text, index) {
            var c = text.charCodeAt(index);

            if (c > 13 /* carriageReturn */ && c <= 127) {
                return 0;
            }

            return getLengthOfLineBreakSlow(text, index, c);
        }
        TextUtilities.getLengthOfLineBreak = getLengthOfLineBreak;

        function isAnyLineBreakCharacter(c) {
            return c === 10 /* lineFeed */ || c === 13 /* carriageReturn */ || c === 133 /* nextLine */ || c === 8232 /* lineSeparator */ || c === 8233 /* paragraphSeparator */;
        }
        TextUtilities.isAnyLineBreakCharacter = isAnyLineBreakCharacter;
    })(TypeScript.TextUtilities || (TypeScript.TextUtilities = {}));
    var TextUtilities = TypeScript.TextUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var TextSpan = (function () {
        function TextSpan(start, length) {
            if (start < 0) {
                TypeScript.Errors.argument("start");
            }

            if (length < 0) {
                TypeScript.Errors.argument("length");
            }

            this._start = start;
            this._length = length;
        }
        TextSpan.prototype.start = function () {
            return this._start;
        };

        TextSpan.prototype.length = function () {
            return this._length;
        };

        TextSpan.prototype.end = function () {
            return this._start + this._length;
        };

        TextSpan.prototype.isEmpty = function () {
            return this._length === 0;
        };

        TextSpan.prototype.containsPosition = function (position) {
            return position >= this._start && position < this.end();
        };

        TextSpan.prototype.containsTextSpan = function (span) {
            return span._start >= this._start && span.end() <= this.end();
        };

        TextSpan.prototype.overlapsWith = function (span) {
            var overlapStart = TypeScript.MathPrototype.max(this._start, span._start);
            var overlapEnd = TypeScript.MathPrototype.min(this.end(), span.end());

            return overlapStart < overlapEnd;
        };

        TextSpan.prototype.overlap = function (span) {
            var overlapStart = TypeScript.MathPrototype.max(this._start, span._start);
            var overlapEnd = TypeScript.MathPrototype.min(this.end(), span.end());

            if (overlapStart < overlapEnd) {
                return TextSpan.fromBounds(overlapStart, overlapEnd);
            }

            return null;
        };

        TextSpan.prototype.intersectsWithTextSpan = function (span) {
            return span._start <= this.end() && span.end() >= this._start;
        };

        TextSpan.prototype.intersectsWith = function (start, length) {
            var end = start + length;
            return start <= this.end() && end >= this._start;
        };

        TextSpan.prototype.intersectsWithPosition = function (position) {
            return position <= this.end() && position >= this._start;
        };

        TextSpan.prototype.intersection = function (span) {
            var intersectStart = TypeScript.MathPrototype.max(this._start, span._start);
            var intersectEnd = TypeScript.MathPrototype.min(this.end(), span.end());

            if (intersectStart <= intersectEnd) {
                return TextSpan.fromBounds(intersectStart, intersectEnd);
            }

            return null;
        };

        TextSpan.fromBounds = function (start, end) {
            TypeScript.Debug.assert(start >= 0);
            TypeScript.Debug.assert(end - start >= 0);
            return new TextSpan(start, end - start);
        };
        return TextSpan;
    })();
    TypeScript.TextSpan = TextSpan;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var TextChangeRange = (function () {
        function TextChangeRange(span, newLength) {
            if (newLength < 0) {
                throw TypeScript.Errors.argumentOutOfRange("newLength");
            }

            this._span = span;
            this._newLength = newLength;
        }
        TextChangeRange.prototype.span = function () {
            return this._span;
        };

        TextChangeRange.prototype.newLength = function () {
            return this._newLength;
        };

        TextChangeRange.prototype.newSpan = function () {
            return new TypeScript.TextSpan(this.span().start(), this.newLength());
        };

        TextChangeRange.prototype.isUnchanged = function () {
            return this.span().isEmpty() && this.newLength() === 0;
        };

        TextChangeRange.collapseChangesFromSingleVersion = function (changes) {
            var diff = 0;
            var start = 1073741823 /* Max31BitInteger */;
            var end = 0;

            for (var i = 0; i < changes.length; i++) {
                var change = changes[i];
                diff += change.newLength() - change.span().length();

                if (change.span().start() < start) {
                    start = change.span().start();
                }

                if (change.span().end() > end) {
                    end = change.span().end();
                }
            }

            if (start > end) {
                return null;
            }

            var combined = TypeScript.TextSpan.fromBounds(start, end);
            var newLen = combined.length() + diff;

            return new TextChangeRange(combined, newLen);
        };

        TextChangeRange.collapseChangesAcrossMultipleVersions = function (changes) {
            if (changes.length === 0) {
                return TextChangeRange.unchanged;
            }

            if (changes.length === 1) {
                return changes[0];
            }

            var change0 = changes[0];

            var oldStartN = change0.span().start();
            var oldEndN = change0.span().end();
            var newEndN = oldStartN + change0.newLength();

            for (var i = 1; i < changes.length; i++) {
                var nextChange = changes[i];

                var oldStart1 = oldStartN;
                var oldEnd1 = oldEndN;
                var newEnd1 = newEndN;

                var oldStart2 = nextChange.span().start();
                var oldEnd2 = nextChange.span().end();
                var newEnd2 = oldStart2 + nextChange.newLength();

                oldStartN = TypeScript.MathPrototype.min(oldStart1, oldStart2);
                oldEndN = TypeScript.MathPrototype.max(oldEnd1, oldEnd1 + (oldEnd2 - newEnd1));
                newEndN = TypeScript.MathPrototype.max(newEnd2, newEnd2 + (newEnd1 - oldEnd2));
            }

            return new TextChangeRange(TypeScript.TextSpan.fromBounds(oldStartN, oldEndN), newEndN - oldStartN);
        };
        TextChangeRange.unchanged = new TextChangeRange(new TypeScript.TextSpan(0, 0), 0);
        return TextChangeRange;
    })();
    TypeScript.TextChangeRange = TextChangeRange;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var CharacterInfo = (function () {
        function CharacterInfo() {
        }
        CharacterInfo.isDecimalDigit = function (c) {
            return c >= 48 /* _0 */ && c <= 57 /* _9 */;
        };
        CharacterInfo.isOctalDigit = function (c) {
            return c >= 48 /* _0 */ && c <= 55 /* _7 */;
        };

        CharacterInfo.isHexDigit = function (c) {
            return CharacterInfo.isDecimalDigit(c) || (c >= 65 /* A */ && c <= 70 /* F */) || (c >= 97 /* a */ && c <= 102 /* f */);
        };

        CharacterInfo.hexValue = function (c) {
            return CharacterInfo.isDecimalDigit(c) ? (c - 48 /* _0 */) : (c >= 65 /* A */ && c <= 70 /* F */) ? c - 65 /* A */ + 10 : c - 97 /* a */ + 10;
        };

        CharacterInfo.isWhitespace = function (ch) {
            switch (ch) {
                case 32 /* space */:
                case 160 /* nonBreakingSpace */:
                case 8192 /* enQuad */:
                case 8193 /* emQuad */:
                case 8194 /* enSpace */:
                case 8195 /* emSpace */:
                case 8196 /* threePerEmSpace */:
                case 8197 /* fourPerEmSpace */:
                case 8198 /* sixPerEmSpace */:
                case 8199 /* figureSpace */:
                case 8200 /* punctuationSpace */:
                case 8201 /* thinSpace */:
                case 8202 /* hairSpace */:
                case 8203 /* zeroWidthSpace */:
                case 8239 /* narrowNoBreakSpace */:
                case 12288 /* ideographicSpace */:

                case 9 /* tab */:
                case 11 /* verticalTab */:
                case 12 /* formFeed */:
                case 65279 /* byteOrderMark */:
                    return true;
            }

            return false;
        };

        CharacterInfo.isLineTerminator = function (ch) {
            switch (ch) {
                case 13 /* carriageReturn */:
                case 10 /* lineFeed */:
                case 8233 /* paragraphSeparator */:
                case 8232 /* lineSeparator */:
                    return true;
            }

            return false;
        };
        return CharacterInfo;
    })();
    TypeScript.CharacterInfo = CharacterInfo;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxConstants) {
        SyntaxConstants[SyntaxConstants["TriviaNewLineMask"] = 0x00000001] = "TriviaNewLineMask";
        SyntaxConstants[SyntaxConstants["TriviaCommentMask"] = 0x00000002] = "TriviaCommentMask";
        SyntaxConstants[SyntaxConstants["TriviaFullWidthShift"] = 2] = "TriviaFullWidthShift";

        SyntaxConstants[SyntaxConstants["NodeDataComputed"] = 0x00000001] = "NodeDataComputed";
        SyntaxConstants[SyntaxConstants["NodeIncrementallyUnusableMask"] = 0x00000002] = "NodeIncrementallyUnusableMask";
        SyntaxConstants[SyntaxConstants["NodeParsedInStrictModeMask"] = 0x00000004] = "NodeParsedInStrictModeMask";
        SyntaxConstants[SyntaxConstants["NodeFullWidthShift"] = 3] = "NodeFullWidthShift";

        SyntaxConstants[SyntaxConstants["IsVariableWidthKeyword"] = 1 << 31] = "IsVariableWidthKeyword";
    })(TypeScript.SyntaxConstants || (TypeScript.SyntaxConstants = {}));
    var SyntaxConstants = TypeScript.SyntaxConstants;
})(TypeScript || (TypeScript = {}));
var FormattingOptions = (function () {
    function FormattingOptions(useTabs, spacesPerTab, indentSpaces, newLineCharacter) {
        this.useTabs = useTabs;
        this.spacesPerTab = spacesPerTab;
        this.indentSpaces = indentSpaces;
        this.newLineCharacter = newLineCharacter;
    }
    FormattingOptions.defaultOptions = new FormattingOptions(false, 4, 4, "\r\n");
    return FormattingOptions;
})();
var TypeScript;
(function (TypeScript) {
    (function (Indentation) {
        function columnForEndOfToken(token, syntaxInformationMap, options) {
            return columnForStartOfToken(token, syntaxInformationMap, options) + token.width();
        }
        Indentation.columnForEndOfToken = columnForEndOfToken;

        function columnForStartOfToken(token, syntaxInformationMap, options) {
            var firstTokenInLine = syntaxInformationMap.firstTokenInLineContainingToken(token);
            var leadingTextInReverse = [];

            var current = token;
            while (current !== firstTokenInLine) {
                current = syntaxInformationMap.previousToken(current);

                if (current === firstTokenInLine) {
                    leadingTextInReverse.push(current.trailingTrivia().fullText());
                    leadingTextInReverse.push(current.text());
                } else {
                    leadingTextInReverse.push(current.fullText());
                }
            }

            collectLeadingTriviaTextToStartOfLine(firstTokenInLine, leadingTextInReverse);

            return columnForLeadingTextInReverse(leadingTextInReverse, options);
        }
        Indentation.columnForStartOfToken = columnForStartOfToken;

        function columnForStartOfFirstTokenInLineContainingToken(token, syntaxInformationMap, options) {
            var firstTokenInLine = syntaxInformationMap.firstTokenInLineContainingToken(token);
            var leadingTextInReverse = [];

            collectLeadingTriviaTextToStartOfLine(firstTokenInLine, leadingTextInReverse);

            return columnForLeadingTextInReverse(leadingTextInReverse, options);
        }
        Indentation.columnForStartOfFirstTokenInLineContainingToken = columnForStartOfFirstTokenInLineContainingToken;

        function collectLeadingTriviaTextToStartOfLine(firstTokenInLine, leadingTextInReverse) {
            var leadingTrivia = firstTokenInLine.leadingTrivia();

            for (var i = leadingTrivia.count() - 1; i >= 0; i--) {
                var trivia = leadingTrivia.syntaxTriviaAt(i);
                if (trivia.kind() === 5 /* NewLineTrivia */) {
                    break;
                }

                if (trivia.kind() === 6 /* MultiLineCommentTrivia */) {
                    var lineSegments = TypeScript.Syntax.splitMultiLineCommentTriviaIntoMultipleLines(trivia);
                    leadingTextInReverse.push(TypeScript.ArrayUtilities.last(lineSegments));

                    if (lineSegments.length > 0) {
                        break;
                    }
                }

                leadingTextInReverse.push(trivia.fullText());
            }
        }

        function columnForLeadingTextInReverse(leadingTextInReverse, options) {
            var column = 0;

            for (var i = leadingTextInReverse.length - 1; i >= 0; i--) {
                var text = leadingTextInReverse[i];
                column = columnForPositionInStringWorker(text, text.length, column, options);
            }

            return column;
        }

        function columnForPositionInString(input, position, options) {
            return columnForPositionInStringWorker(input, position, 0, options);
        }
        Indentation.columnForPositionInString = columnForPositionInString;

        function columnForPositionInStringWorker(input, position, startColumn, options) {
            var column = startColumn;
            var spacesPerTab = options.spacesPerTab;

            for (var j = 0; j < position; j++) {
                var ch = input.charCodeAt(j);

                if (ch === 9 /* tab */) {
                    column += spacesPerTab - column % spacesPerTab;
                } else {
                    column++;
                }
            }

            return column;
        }

        function indentationString(column, options) {
            var numberOfTabs = 0;
            var numberOfSpaces = TypeScript.MathPrototype.max(0, column);

            if (options.useTabs) {
                numberOfTabs = Math.floor(column / options.spacesPerTab);
                numberOfSpaces -= numberOfTabs * options.spacesPerTab;
            }

            return TypeScript.StringUtilities.repeat('\t', numberOfTabs) + TypeScript.StringUtilities.repeat(' ', numberOfSpaces);
        }
        Indentation.indentationString = indentationString;

        function indentationTrivia(column, options) {
            return TypeScript.Syntax.whitespace(this.indentationString(column, options));
        }
        Indentation.indentationTrivia = indentationTrivia;

        function firstNonWhitespacePosition(value) {
            for (var i = 0; i < value.length; i++) {
                var ch = value.charCodeAt(i);
                if (!TypeScript.CharacterInfo.isWhitespace(ch)) {
                    return i;
                }
            }

            return value.length;
        }
        Indentation.firstNonWhitespacePosition = firstNonWhitespacePosition;
    })(TypeScript.Indentation || (TypeScript.Indentation = {}));
    var Indentation = TypeScript.Indentation;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (LanguageVersion) {
        LanguageVersion[LanguageVersion["EcmaScript3"] = 0] = "EcmaScript3";
        LanguageVersion[LanguageVersion["EcmaScript5"] = 1] = "EcmaScript5";
    })(TypeScript.LanguageVersion || (TypeScript.LanguageVersion = {}));
    var LanguageVersion = TypeScript.LanguageVersion;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var ParseOptions = (function () {
        function ParseOptions(languageVersion, allowAutomaticSemicolonInsertion) {
            this._languageVersion = languageVersion;
            this._allowAutomaticSemicolonInsertion = allowAutomaticSemicolonInsertion;
        }
        ParseOptions.prototype.toJSON = function (key) {
            return { allowAutomaticSemicolonInsertion: this._allowAutomaticSemicolonInsertion };
        };

        ParseOptions.prototype.languageVersion = function () {
            return this._languageVersion;
        };

        ParseOptions.prototype.allowAutomaticSemicolonInsertion = function () {
            return this._allowAutomaticSemicolonInsertion;
        };
        return ParseOptions;
    })();
    TypeScript.ParseOptions = ParseOptions;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var PositionedElement = (function () {
        function PositionedElement(parent, element, fullStart) {
            this._parent = parent;
            this._element = element;
            this._fullStart = fullStart;
        }
        PositionedElement.create = function (parent, element, fullStart) {
            if (element === null) {
                return null;
            }

            if (element.isNode()) {
                return new PositionedNode(parent, element, fullStart);
            } else if (element.isToken()) {
                return new PositionedToken(parent, element, fullStart);
            } else if (element.isList()) {
                return new PositionedList(parent, element, fullStart);
            } else if (element.isSeparatedList()) {
                return new PositionedSeparatedList(parent, element, fullStart);
            } else {
                throw TypeScript.Errors.invalidOperation();
            }
        };

        PositionedElement.prototype.parent = function () {
            return this._parent;
        };

        PositionedElement.prototype.parentElement = function () {
            return this._parent && this._parent._element;
        };

        PositionedElement.prototype.element = function () {
            return this._element;
        };

        PositionedElement.prototype.kind = function () {
            return this.element().kind();
        };

        PositionedElement.prototype.childIndex = function (child) {
            return TypeScript.Syntax.childIndex(this.element(), child);
        };

        PositionedElement.prototype.childCount = function () {
            return this.element().childCount();
        };

        PositionedElement.prototype.childAt = function (index) {
            var offset = TypeScript.Syntax.childOffsetAt(this.element(), index);
            return PositionedElement.create(this, this.element().childAt(index), this.fullStart() + offset);
        };

        PositionedElement.prototype.childStart = function (child) {
            var offset = TypeScript.Syntax.childOffset(this.element(), child);
            return this.fullStart() + offset + child.leadingTriviaWidth();
        };

        PositionedElement.prototype.childEnd = function (child) {
            var offset = TypeScript.Syntax.childOffset(this.element(), child);
            return this.fullStart() + offset + child.leadingTriviaWidth() + child.width();
        };

        PositionedElement.prototype.childStartAt = function (index) {
            var offset = TypeScript.Syntax.childOffsetAt(this.element(), index);
            var child = this.element().childAt(index);
            return this.fullStart() + offset + child.leadingTriviaWidth();
        };

        PositionedElement.prototype.childEndAt = function (index) {
            var offset = TypeScript.Syntax.childOffsetAt(this.element(), index);
            var child = this.element().childAt(index);
            return this.fullStart() + offset + child.leadingTriviaWidth() + child.width();
        };

        PositionedElement.prototype.getPositionedChild = function (child) {
            var offset = TypeScript.Syntax.childOffset(this.element(), child);
            return PositionedElement.create(this, child, this.fullStart() + offset);
        };

        PositionedElement.prototype.fullStart = function () {
            return this._fullStart;
        };

        PositionedElement.prototype.fullEnd = function () {
            return this.fullStart() + this.element().fullWidth();
        };

        PositionedElement.prototype.fullWidth = function () {
            return this.element().fullWidth();
        };

        PositionedElement.prototype.start = function () {
            return this.fullStart() + this.element().leadingTriviaWidth();
        };

        PositionedElement.prototype.end = function () {
            return this.fullStart() + this.element().leadingTriviaWidth() + this.element().width();
        };

        PositionedElement.prototype.root = function () {
            var current = this;
            while (current.parent() !== null) {
                current = current.parent();
            }

            return current;
        };

        PositionedElement.prototype.containingNode = function () {
            var current = this.parent();

            while (current !== null && !current.element().isNode()) {
                current = current.parent();
            }

            return current;
        };
        return PositionedElement;
    })();
    TypeScript.PositionedElement = PositionedElement;

    var PositionedNodeOrToken = (function (_super) {
        __extends(PositionedNodeOrToken, _super);
        function PositionedNodeOrToken(parent, nodeOrToken, fullStart) {
            _super.call(this, parent, nodeOrToken, fullStart);
        }
        PositionedNodeOrToken.prototype.nodeOrToken = function () {
            return this.element();
        };
        return PositionedNodeOrToken;
    })(PositionedElement);
    TypeScript.PositionedNodeOrToken = PositionedNodeOrToken;

    var PositionedNode = (function (_super) {
        __extends(PositionedNode, _super);
        function PositionedNode(parent, node, fullStart) {
            _super.call(this, parent, node, fullStart);
        }
        PositionedNode.prototype.node = function () {
            return this.element();
        };
        return PositionedNode;
    })(PositionedNodeOrToken);
    TypeScript.PositionedNode = PositionedNode;

    var PositionedToken = (function (_super) {
        __extends(PositionedToken, _super);
        function PositionedToken(parent, token, fullStart) {
            _super.call(this, parent, token, fullStart);
        }
        PositionedToken.prototype.token = function () {
            return this.element();
        };

        PositionedToken.prototype.previousToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var triviaList = this.token().leadingTrivia();
            if (includeSkippedTokens && triviaList && triviaList.hasSkippedToken()) {
                var currentTriviaEndPosition = this.start();
                for (var i = triviaList.count() - 1; i >= 0; i--) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    if (trivia.isSkippedToken()) {
                        return new PositionedSkippedToken(this, trivia.skippedToken(), currentTriviaEndPosition - trivia.fullWidth());
                    }

                    currentTriviaEndPosition -= trivia.fullWidth();
                }
            }

            var start = this.fullStart();
            if (start === 0) {
                return null;
            }

            return this.root().node().findToken(start - 1, includeSkippedTokens);
        };

        PositionedToken.prototype.nextToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            if (this.token().tokenKind === 10 /* EndOfFileToken */) {
                return null;
            }

            var triviaList = this.token().trailingTrivia();
            if (includeSkippedTokens && triviaList && triviaList.hasSkippedToken()) {
                var fullStart = this.end();
                for (var i = 0, n = triviaList.count(); i < n; i++) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    if (trivia.isSkippedToken()) {
                        return new PositionedSkippedToken(this, trivia.skippedToken(), fullStart);
                    }

                    fullStart += trivia.fullWidth();
                }
            }

            return this.root().node().findToken(this.fullEnd(), includeSkippedTokens);
        };
        return PositionedToken;
    })(PositionedNodeOrToken);
    TypeScript.PositionedToken = PositionedToken;

    var PositionedList = (function (_super) {
        __extends(PositionedList, _super);
        function PositionedList(parent, list, fullStart) {
            _super.call(this, parent, list, fullStart);
        }
        PositionedList.prototype.list = function () {
            return this.element();
        };
        return PositionedList;
    })(PositionedElement);
    TypeScript.PositionedList = PositionedList;

    var PositionedSeparatedList = (function (_super) {
        __extends(PositionedSeparatedList, _super);
        function PositionedSeparatedList(parent, list, fullStart) {
            _super.call(this, parent, list, fullStart);
        }
        PositionedSeparatedList.prototype.list = function () {
            return this.element();
        };
        return PositionedSeparatedList;
    })(PositionedElement);
    TypeScript.PositionedSeparatedList = PositionedSeparatedList;

    var PositionedSkippedToken = (function (_super) {
        __extends(PositionedSkippedToken, _super);
        function PositionedSkippedToken(parentToken, token, fullStart) {
            _super.call(this, parentToken.parent(), token, fullStart);
            this._parentToken = parentToken;
        }
        PositionedSkippedToken.prototype.parentToken = function () {
            return this._parentToken;
        };

        PositionedSkippedToken.prototype.previousToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var start = this.fullStart();

            if (includeSkippedTokens) {
                var previousToken;

                if (start >= this.parentToken().end()) {
                    previousToken = TypeScript.Syntax.findSkippedTokenInTrailingTriviaList(this.parentToken(), start - 1);

                    if (previousToken) {
                        return previousToken;
                    }

                    return this.parentToken();
                } else {
                    previousToken = TypeScript.Syntax.findSkippedTokenInLeadingTriviaList(this.parentToken(), start - 1);

                    if (previousToken) {
                        return previousToken;
                    }
                }
            }

            var start = this.parentToken().fullStart();
            if (start === 0) {
                return null;
            }

            return this.root().node().findToken(start - 1, includeSkippedTokens);
        };

        PositionedSkippedToken.prototype.nextToken = function (includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            if (this.token().tokenKind === 10 /* EndOfFileToken */) {
                return null;
            }

            if (includeSkippedTokens) {
                var end = this.end();
                var nextToken;

                if (end <= this.parentToken().start()) {
                    nextToken = TypeScript.Syntax.findSkippedTokenInLeadingTriviaList(this.parentToken(), end);

                    if (nextToken) {
                        return nextToken;
                    }

                    return this.parentToken();
                } else {
                    nextToken = TypeScript.Syntax.findSkippedTokenInTrailingTriviaList(this.parentToken(), end);

                    if (nextToken) {
                        return nextToken;
                    }
                }
            }

            return this.root().node().findToken(this.parentToken().fullEnd(), includeSkippedTokens);
        };
        return PositionedSkippedToken;
    })(PositionedToken);
    TypeScript.PositionedSkippedToken = PositionedSkippedToken;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxKind) {
        SyntaxKind[SyntaxKind["None"] = 0] = "None";
        SyntaxKind[SyntaxKind["List"] = 1] = "List";
        SyntaxKind[SyntaxKind["SeparatedList"] = 2] = "SeparatedList";
        SyntaxKind[SyntaxKind["TriviaList"] = 3] = "TriviaList";

        SyntaxKind[SyntaxKind["WhitespaceTrivia"] = 4] = "WhitespaceTrivia";
        SyntaxKind[SyntaxKind["NewLineTrivia"] = 5] = "NewLineTrivia";
        SyntaxKind[SyntaxKind["MultiLineCommentTrivia"] = 6] = "MultiLineCommentTrivia";
        SyntaxKind[SyntaxKind["SingleLineCommentTrivia"] = 7] = "SingleLineCommentTrivia";
        SyntaxKind[SyntaxKind["SkippedTokenTrivia"] = 8] = "SkippedTokenTrivia";

        SyntaxKind[SyntaxKind["ErrorToken"] = 9] = "ErrorToken";
        SyntaxKind[SyntaxKind["EndOfFileToken"] = 10] = "EndOfFileToken";

        SyntaxKind[SyntaxKind["IdentifierName"] = 11] = "IdentifierName";

        SyntaxKind[SyntaxKind["RegularExpressionLiteral"] = 12] = "RegularExpressionLiteral";
        SyntaxKind[SyntaxKind["NumericLiteral"] = 13] = "NumericLiteral";
        SyntaxKind[SyntaxKind["StringLiteral"] = 14] = "StringLiteral";

        SyntaxKind[SyntaxKind["BreakKeyword"] = 15] = "BreakKeyword";
        SyntaxKind[SyntaxKind["CaseKeyword"] = 16] = "CaseKeyword";
        SyntaxKind[SyntaxKind["CatchKeyword"] = 17] = "CatchKeyword";
        SyntaxKind[SyntaxKind["ContinueKeyword"] = 18] = "ContinueKeyword";
        SyntaxKind[SyntaxKind["DebuggerKeyword"] = 19] = "DebuggerKeyword";
        SyntaxKind[SyntaxKind["DefaultKeyword"] = 20] = "DefaultKeyword";
        SyntaxKind[SyntaxKind["DeleteKeyword"] = 21] = "DeleteKeyword";
        SyntaxKind[SyntaxKind["DoKeyword"] = 22] = "DoKeyword";
        SyntaxKind[SyntaxKind["ElseKeyword"] = 23] = "ElseKeyword";
        SyntaxKind[SyntaxKind["FalseKeyword"] = 24] = "FalseKeyword";
        SyntaxKind[SyntaxKind["FinallyKeyword"] = 25] = "FinallyKeyword";
        SyntaxKind[SyntaxKind["ForKeyword"] = 26] = "ForKeyword";
        SyntaxKind[SyntaxKind["FunctionKeyword"] = 27] = "FunctionKeyword";
        SyntaxKind[SyntaxKind["IfKeyword"] = 28] = "IfKeyword";
        SyntaxKind[SyntaxKind["InKeyword"] = 29] = "InKeyword";
        SyntaxKind[SyntaxKind["InstanceOfKeyword"] = 30] = "InstanceOfKeyword";
        SyntaxKind[SyntaxKind["NewKeyword"] = 31] = "NewKeyword";
        SyntaxKind[SyntaxKind["NullKeyword"] = 32] = "NullKeyword";
        SyntaxKind[SyntaxKind["ReturnKeyword"] = 33] = "ReturnKeyword";
        SyntaxKind[SyntaxKind["SwitchKeyword"] = 34] = "SwitchKeyword";
        SyntaxKind[SyntaxKind["ThisKeyword"] = 35] = "ThisKeyword";
        SyntaxKind[SyntaxKind["ThrowKeyword"] = 36] = "ThrowKeyword";
        SyntaxKind[SyntaxKind["TrueKeyword"] = 37] = "TrueKeyword";
        SyntaxKind[SyntaxKind["TryKeyword"] = 38] = "TryKeyword";
        SyntaxKind[SyntaxKind["TypeOfKeyword"] = 39] = "TypeOfKeyword";
        SyntaxKind[SyntaxKind["VarKeyword"] = 40] = "VarKeyword";
        SyntaxKind[SyntaxKind["VoidKeyword"] = 41] = "VoidKeyword";
        SyntaxKind[SyntaxKind["WhileKeyword"] = 42] = "WhileKeyword";
        SyntaxKind[SyntaxKind["WithKeyword"] = 43] = "WithKeyword";

        SyntaxKind[SyntaxKind["ClassKeyword"] = 44] = "ClassKeyword";
        SyntaxKind[SyntaxKind["ConstKeyword"] = 45] = "ConstKeyword";
        SyntaxKind[SyntaxKind["EnumKeyword"] = 46] = "EnumKeyword";
        SyntaxKind[SyntaxKind["ExportKeyword"] = 47] = "ExportKeyword";
        SyntaxKind[SyntaxKind["ExtendsKeyword"] = 48] = "ExtendsKeyword";
        SyntaxKind[SyntaxKind["ImportKeyword"] = 49] = "ImportKeyword";
        SyntaxKind[SyntaxKind["SuperKeyword"] = 50] = "SuperKeyword";

        SyntaxKind[SyntaxKind["ImplementsKeyword"] = 51] = "ImplementsKeyword";
        SyntaxKind[SyntaxKind["InterfaceKeyword"] = 52] = "InterfaceKeyword";
        SyntaxKind[SyntaxKind["LetKeyword"] = 53] = "LetKeyword";
        SyntaxKind[SyntaxKind["PackageKeyword"] = 54] = "PackageKeyword";
        SyntaxKind[SyntaxKind["PrivateKeyword"] = 55] = "PrivateKeyword";
        SyntaxKind[SyntaxKind["ProtectedKeyword"] = 56] = "ProtectedKeyword";
        SyntaxKind[SyntaxKind["PublicKeyword"] = 57] = "PublicKeyword";
        SyntaxKind[SyntaxKind["StaticKeyword"] = 58] = "StaticKeyword";
        SyntaxKind[SyntaxKind["YieldKeyword"] = 59] = "YieldKeyword";

        SyntaxKind[SyntaxKind["AnyKeyword"] = 60] = "AnyKeyword";
        SyntaxKind[SyntaxKind["BooleanKeyword"] = 61] = "BooleanKeyword";
        SyntaxKind[SyntaxKind["ConstructorKeyword"] = 62] = "ConstructorKeyword";
        SyntaxKind[SyntaxKind["DeclareKeyword"] = 63] = "DeclareKeyword";
        SyntaxKind[SyntaxKind["GetKeyword"] = 64] = "GetKeyword";
        SyntaxKind[SyntaxKind["ModuleKeyword"] = 65] = "ModuleKeyword";
        SyntaxKind[SyntaxKind["RequireKeyword"] = 66] = "RequireKeyword";
        SyntaxKind[SyntaxKind["NumberKeyword"] = 67] = "NumberKeyword";
        SyntaxKind[SyntaxKind["SetKeyword"] = 68] = "SetKeyword";
        SyntaxKind[SyntaxKind["StringKeyword"] = 69] = "StringKeyword";

        SyntaxKind[SyntaxKind["OpenBraceToken"] = 70] = "OpenBraceToken";
        SyntaxKind[SyntaxKind["CloseBraceToken"] = 71] = "CloseBraceToken";
        SyntaxKind[SyntaxKind["OpenParenToken"] = 72] = "OpenParenToken";
        SyntaxKind[SyntaxKind["CloseParenToken"] = 73] = "CloseParenToken";
        SyntaxKind[SyntaxKind["OpenBracketToken"] = 74] = "OpenBracketToken";
        SyntaxKind[SyntaxKind["CloseBracketToken"] = 75] = "CloseBracketToken";
        SyntaxKind[SyntaxKind["DotToken"] = 76] = "DotToken";
        SyntaxKind[SyntaxKind["DotDotDotToken"] = 77] = "DotDotDotToken";
        SyntaxKind[SyntaxKind["SemicolonToken"] = 78] = "SemicolonToken";
        SyntaxKind[SyntaxKind["CommaToken"] = 79] = "CommaToken";
        SyntaxKind[SyntaxKind["LessThanToken"] = 80] = "LessThanToken";
        SyntaxKind[SyntaxKind["GreaterThanToken"] = 81] = "GreaterThanToken";
        SyntaxKind[SyntaxKind["LessThanEqualsToken"] = 82] = "LessThanEqualsToken";
        SyntaxKind[SyntaxKind["GreaterThanEqualsToken"] = 83] = "GreaterThanEqualsToken";
        SyntaxKind[SyntaxKind["EqualsEqualsToken"] = 84] = "EqualsEqualsToken";
        SyntaxKind[SyntaxKind["EqualsGreaterThanToken"] = 85] = "EqualsGreaterThanToken";
        SyntaxKind[SyntaxKind["ExclamationEqualsToken"] = 86] = "ExclamationEqualsToken";
        SyntaxKind[SyntaxKind["EqualsEqualsEqualsToken"] = 87] = "EqualsEqualsEqualsToken";
        SyntaxKind[SyntaxKind["ExclamationEqualsEqualsToken"] = 88] = "ExclamationEqualsEqualsToken";
        SyntaxKind[SyntaxKind["PlusToken"] = 89] = "PlusToken";
        SyntaxKind[SyntaxKind["MinusToken"] = 90] = "MinusToken";
        SyntaxKind[SyntaxKind["AsteriskToken"] = 91] = "AsteriskToken";
        SyntaxKind[SyntaxKind["PercentToken"] = 92] = "PercentToken";
        SyntaxKind[SyntaxKind["PlusPlusToken"] = 93] = "PlusPlusToken";
        SyntaxKind[SyntaxKind["MinusMinusToken"] = 94] = "MinusMinusToken";
        SyntaxKind[SyntaxKind["LessThanLessThanToken"] = 95] = "LessThanLessThanToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanToken"] = 96] = "GreaterThanGreaterThanToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanGreaterThanToken"] = 97] = "GreaterThanGreaterThanGreaterThanToken";
        SyntaxKind[SyntaxKind["AmpersandToken"] = 98] = "AmpersandToken";
        SyntaxKind[SyntaxKind["BarToken"] = 99] = "BarToken";
        SyntaxKind[SyntaxKind["CaretToken"] = 100] = "CaretToken";
        SyntaxKind[SyntaxKind["ExclamationToken"] = 101] = "ExclamationToken";
        SyntaxKind[SyntaxKind["TildeToken"] = 102] = "TildeToken";
        SyntaxKind[SyntaxKind["AmpersandAmpersandToken"] = 103] = "AmpersandAmpersandToken";
        SyntaxKind[SyntaxKind["BarBarToken"] = 104] = "BarBarToken";
        SyntaxKind[SyntaxKind["QuestionToken"] = 105] = "QuestionToken";
        SyntaxKind[SyntaxKind["ColonToken"] = 106] = "ColonToken";
        SyntaxKind[SyntaxKind["EqualsToken"] = 107] = "EqualsToken";
        SyntaxKind[SyntaxKind["PlusEqualsToken"] = 108] = "PlusEqualsToken";
        SyntaxKind[SyntaxKind["MinusEqualsToken"] = 109] = "MinusEqualsToken";
        SyntaxKind[SyntaxKind["AsteriskEqualsToken"] = 110] = "AsteriskEqualsToken";
        SyntaxKind[SyntaxKind["PercentEqualsToken"] = 111] = "PercentEqualsToken";
        SyntaxKind[SyntaxKind["LessThanLessThanEqualsToken"] = 112] = "LessThanLessThanEqualsToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanEqualsToken"] = 113] = "GreaterThanGreaterThanEqualsToken";
        SyntaxKind[SyntaxKind["GreaterThanGreaterThanGreaterThanEqualsToken"] = 114] = "GreaterThanGreaterThanGreaterThanEqualsToken";
        SyntaxKind[SyntaxKind["AmpersandEqualsToken"] = 115] = "AmpersandEqualsToken";
        SyntaxKind[SyntaxKind["BarEqualsToken"] = 116] = "BarEqualsToken";
        SyntaxKind[SyntaxKind["CaretEqualsToken"] = 117] = "CaretEqualsToken";
        SyntaxKind[SyntaxKind["SlashToken"] = 118] = "SlashToken";
        SyntaxKind[SyntaxKind["SlashEqualsToken"] = 119] = "SlashEqualsToken";

        SyntaxKind[SyntaxKind["SourceUnit"] = 120] = "SourceUnit";

        SyntaxKind[SyntaxKind["QualifiedName"] = 121] = "QualifiedName";

        SyntaxKind[SyntaxKind["ObjectType"] = 122] = "ObjectType";
        SyntaxKind[SyntaxKind["FunctionType"] = 123] = "FunctionType";
        SyntaxKind[SyntaxKind["ArrayType"] = 124] = "ArrayType";
        SyntaxKind[SyntaxKind["ConstructorType"] = 125] = "ConstructorType";
        SyntaxKind[SyntaxKind["GenericType"] = 126] = "GenericType";
        SyntaxKind[SyntaxKind["TypeQuery"] = 127] = "TypeQuery";

        SyntaxKind[SyntaxKind["InterfaceDeclaration"] = 128] = "InterfaceDeclaration";
        SyntaxKind[SyntaxKind["FunctionDeclaration"] = 129] = "FunctionDeclaration";
        SyntaxKind[SyntaxKind["ModuleDeclaration"] = 130] = "ModuleDeclaration";
        SyntaxKind[SyntaxKind["ClassDeclaration"] = 131] = "ClassDeclaration";
        SyntaxKind[SyntaxKind["EnumDeclaration"] = 132] = "EnumDeclaration";
        SyntaxKind[SyntaxKind["ImportDeclaration"] = 133] = "ImportDeclaration";
        SyntaxKind[SyntaxKind["ExportAssignment"] = 134] = "ExportAssignment";

        SyntaxKind[SyntaxKind["MemberFunctionDeclaration"] = 135] = "MemberFunctionDeclaration";
        SyntaxKind[SyntaxKind["MemberVariableDeclaration"] = 136] = "MemberVariableDeclaration";
        SyntaxKind[SyntaxKind["ConstructorDeclaration"] = 137] = "ConstructorDeclaration";
        SyntaxKind[SyntaxKind["IndexMemberDeclaration"] = 138] = "IndexMemberDeclaration";

        SyntaxKind[SyntaxKind["GetAccessor"] = 139] = "GetAccessor";
        SyntaxKind[SyntaxKind["SetAccessor"] = 140] = "SetAccessor";

        SyntaxKind[SyntaxKind["PropertySignature"] = 141] = "PropertySignature";
        SyntaxKind[SyntaxKind["CallSignature"] = 142] = "CallSignature";
        SyntaxKind[SyntaxKind["ConstructSignature"] = 143] = "ConstructSignature";
        SyntaxKind[SyntaxKind["IndexSignature"] = 144] = "IndexSignature";
        SyntaxKind[SyntaxKind["MethodSignature"] = 145] = "MethodSignature";

        SyntaxKind[SyntaxKind["Block"] = 146] = "Block";
        SyntaxKind[SyntaxKind["IfStatement"] = 147] = "IfStatement";
        SyntaxKind[SyntaxKind["VariableStatement"] = 148] = "VariableStatement";
        SyntaxKind[SyntaxKind["ExpressionStatement"] = 149] = "ExpressionStatement";
        SyntaxKind[SyntaxKind["ReturnStatement"] = 150] = "ReturnStatement";
        SyntaxKind[SyntaxKind["SwitchStatement"] = 151] = "SwitchStatement";
        SyntaxKind[SyntaxKind["BreakStatement"] = 152] = "BreakStatement";
        SyntaxKind[SyntaxKind["ContinueStatement"] = 153] = "ContinueStatement";
        SyntaxKind[SyntaxKind["ForStatement"] = 154] = "ForStatement";
        SyntaxKind[SyntaxKind["ForInStatement"] = 155] = "ForInStatement";
        SyntaxKind[SyntaxKind["EmptyStatement"] = 156] = "EmptyStatement";
        SyntaxKind[SyntaxKind["ThrowStatement"] = 157] = "ThrowStatement";
        SyntaxKind[SyntaxKind["WhileStatement"] = 158] = "WhileStatement";
        SyntaxKind[SyntaxKind["TryStatement"] = 159] = "TryStatement";
        SyntaxKind[SyntaxKind["LabeledStatement"] = 160] = "LabeledStatement";
        SyntaxKind[SyntaxKind["DoStatement"] = 161] = "DoStatement";
        SyntaxKind[SyntaxKind["DebuggerStatement"] = 162] = "DebuggerStatement";
        SyntaxKind[SyntaxKind["WithStatement"] = 163] = "WithStatement";

        SyntaxKind[SyntaxKind["PlusExpression"] = 164] = "PlusExpression";
        SyntaxKind[SyntaxKind["NegateExpression"] = 165] = "NegateExpression";
        SyntaxKind[SyntaxKind["BitwiseNotExpression"] = 166] = "BitwiseNotExpression";
        SyntaxKind[SyntaxKind["LogicalNotExpression"] = 167] = "LogicalNotExpression";
        SyntaxKind[SyntaxKind["PreIncrementExpression"] = 168] = "PreIncrementExpression";
        SyntaxKind[SyntaxKind["PreDecrementExpression"] = 169] = "PreDecrementExpression";
        SyntaxKind[SyntaxKind["DeleteExpression"] = 170] = "DeleteExpression";
        SyntaxKind[SyntaxKind["TypeOfExpression"] = 171] = "TypeOfExpression";
        SyntaxKind[SyntaxKind["VoidExpression"] = 172] = "VoidExpression";
        SyntaxKind[SyntaxKind["CommaExpression"] = 173] = "CommaExpression";
        SyntaxKind[SyntaxKind["AssignmentExpression"] = 174] = "AssignmentExpression";
        SyntaxKind[SyntaxKind["AddAssignmentExpression"] = 175] = "AddAssignmentExpression";
        SyntaxKind[SyntaxKind["SubtractAssignmentExpression"] = 176] = "SubtractAssignmentExpression";
        SyntaxKind[SyntaxKind["MultiplyAssignmentExpression"] = 177] = "MultiplyAssignmentExpression";
        SyntaxKind[SyntaxKind["DivideAssignmentExpression"] = 178] = "DivideAssignmentExpression";
        SyntaxKind[SyntaxKind["ModuloAssignmentExpression"] = 179] = "ModuloAssignmentExpression";
        SyntaxKind[SyntaxKind["AndAssignmentExpression"] = 180] = "AndAssignmentExpression";
        SyntaxKind[SyntaxKind["ExclusiveOrAssignmentExpression"] = 181] = "ExclusiveOrAssignmentExpression";
        SyntaxKind[SyntaxKind["OrAssignmentExpression"] = 182] = "OrAssignmentExpression";
        SyntaxKind[SyntaxKind["LeftShiftAssignmentExpression"] = 183] = "LeftShiftAssignmentExpression";
        SyntaxKind[SyntaxKind["SignedRightShiftAssignmentExpression"] = 184] = "SignedRightShiftAssignmentExpression";
        SyntaxKind[SyntaxKind["UnsignedRightShiftAssignmentExpression"] = 185] = "UnsignedRightShiftAssignmentExpression";
        SyntaxKind[SyntaxKind["ConditionalExpression"] = 186] = "ConditionalExpression";
        SyntaxKind[SyntaxKind["LogicalOrExpression"] = 187] = "LogicalOrExpression";
        SyntaxKind[SyntaxKind["LogicalAndExpression"] = 188] = "LogicalAndExpression";
        SyntaxKind[SyntaxKind["BitwiseOrExpression"] = 189] = "BitwiseOrExpression";
        SyntaxKind[SyntaxKind["BitwiseExclusiveOrExpression"] = 190] = "BitwiseExclusiveOrExpression";
        SyntaxKind[SyntaxKind["BitwiseAndExpression"] = 191] = "BitwiseAndExpression";
        SyntaxKind[SyntaxKind["EqualsWithTypeConversionExpression"] = 192] = "EqualsWithTypeConversionExpression";
        SyntaxKind[SyntaxKind["NotEqualsWithTypeConversionExpression"] = 193] = "NotEqualsWithTypeConversionExpression";
        SyntaxKind[SyntaxKind["EqualsExpression"] = 194] = "EqualsExpression";
        SyntaxKind[SyntaxKind["NotEqualsExpression"] = 195] = "NotEqualsExpression";
        SyntaxKind[SyntaxKind["LessThanExpression"] = 196] = "LessThanExpression";
        SyntaxKind[SyntaxKind["GreaterThanExpression"] = 197] = "GreaterThanExpression";
        SyntaxKind[SyntaxKind["LessThanOrEqualExpression"] = 198] = "LessThanOrEqualExpression";
        SyntaxKind[SyntaxKind["GreaterThanOrEqualExpression"] = 199] = "GreaterThanOrEqualExpression";
        SyntaxKind[SyntaxKind["InstanceOfExpression"] = 200] = "InstanceOfExpression";
        SyntaxKind[SyntaxKind["InExpression"] = 201] = "InExpression";
        SyntaxKind[SyntaxKind["LeftShiftExpression"] = 202] = "LeftShiftExpression";
        SyntaxKind[SyntaxKind["SignedRightShiftExpression"] = 203] = "SignedRightShiftExpression";
        SyntaxKind[SyntaxKind["UnsignedRightShiftExpression"] = 204] = "UnsignedRightShiftExpression";
        SyntaxKind[SyntaxKind["MultiplyExpression"] = 205] = "MultiplyExpression";
        SyntaxKind[SyntaxKind["DivideExpression"] = 206] = "DivideExpression";
        SyntaxKind[SyntaxKind["ModuloExpression"] = 207] = "ModuloExpression";
        SyntaxKind[SyntaxKind["AddExpression"] = 208] = "AddExpression";
        SyntaxKind[SyntaxKind["SubtractExpression"] = 209] = "SubtractExpression";
        SyntaxKind[SyntaxKind["PostIncrementExpression"] = 210] = "PostIncrementExpression";
        SyntaxKind[SyntaxKind["PostDecrementExpression"] = 211] = "PostDecrementExpression";
        SyntaxKind[SyntaxKind["MemberAccessExpression"] = 212] = "MemberAccessExpression";
        SyntaxKind[SyntaxKind["InvocationExpression"] = 213] = "InvocationExpression";
        SyntaxKind[SyntaxKind["ArrayLiteralExpression"] = 214] = "ArrayLiteralExpression";
        SyntaxKind[SyntaxKind["ObjectLiteralExpression"] = 215] = "ObjectLiteralExpression";
        SyntaxKind[SyntaxKind["ObjectCreationExpression"] = 216] = "ObjectCreationExpression";
        SyntaxKind[SyntaxKind["ParenthesizedExpression"] = 217] = "ParenthesizedExpression";
        SyntaxKind[SyntaxKind["ParenthesizedArrowFunctionExpression"] = 218] = "ParenthesizedArrowFunctionExpression";
        SyntaxKind[SyntaxKind["SimpleArrowFunctionExpression"] = 219] = "SimpleArrowFunctionExpression";
        SyntaxKind[SyntaxKind["CastExpression"] = 220] = "CastExpression";
        SyntaxKind[SyntaxKind["ElementAccessExpression"] = 221] = "ElementAccessExpression";
        SyntaxKind[SyntaxKind["FunctionExpression"] = 222] = "FunctionExpression";
        SyntaxKind[SyntaxKind["OmittedExpression"] = 223] = "OmittedExpression";

        SyntaxKind[SyntaxKind["VariableDeclaration"] = 224] = "VariableDeclaration";
        SyntaxKind[SyntaxKind["VariableDeclarator"] = 225] = "VariableDeclarator";

        SyntaxKind[SyntaxKind["ArgumentList"] = 226] = "ArgumentList";
        SyntaxKind[SyntaxKind["ParameterList"] = 227] = "ParameterList";
        SyntaxKind[SyntaxKind["TypeArgumentList"] = 228] = "TypeArgumentList";
        SyntaxKind[SyntaxKind["TypeParameterList"] = 229] = "TypeParameterList";

        SyntaxKind[SyntaxKind["ExtendsHeritageClause"] = 230] = "ExtendsHeritageClause";
        SyntaxKind[SyntaxKind["ImplementsHeritageClause"] = 231] = "ImplementsHeritageClause";
        SyntaxKind[SyntaxKind["EqualsValueClause"] = 232] = "EqualsValueClause";
        SyntaxKind[SyntaxKind["CaseSwitchClause"] = 233] = "CaseSwitchClause";
        SyntaxKind[SyntaxKind["DefaultSwitchClause"] = 234] = "DefaultSwitchClause";
        SyntaxKind[SyntaxKind["ElseClause"] = 235] = "ElseClause";
        SyntaxKind[SyntaxKind["CatchClause"] = 236] = "CatchClause";
        SyntaxKind[SyntaxKind["FinallyClause"] = 237] = "FinallyClause";

        SyntaxKind[SyntaxKind["TypeParameter"] = 238] = "TypeParameter";
        SyntaxKind[SyntaxKind["Constraint"] = 239] = "Constraint";

        SyntaxKind[SyntaxKind["SimplePropertyAssignment"] = 240] = "SimplePropertyAssignment";

        SyntaxKind[SyntaxKind["FunctionPropertyAssignment"] = 241] = "FunctionPropertyAssignment";

        SyntaxKind[SyntaxKind["Parameter"] = 242] = "Parameter";
        SyntaxKind[SyntaxKind["EnumElement"] = 243] = "EnumElement";
        SyntaxKind[SyntaxKind["TypeAnnotation"] = 244] = "TypeAnnotation";
        SyntaxKind[SyntaxKind["ExternalModuleReference"] = 245] = "ExternalModuleReference";
        SyntaxKind[SyntaxKind["ModuleNameModuleReference"] = 246] = "ModuleNameModuleReference";
        SyntaxKind[SyntaxKind["Last"] = SyntaxKind.ModuleNameModuleReference] = "Last";

        SyntaxKind[SyntaxKind["FirstStandardKeyword"] = SyntaxKind.BreakKeyword] = "FirstStandardKeyword";
        SyntaxKind[SyntaxKind["LastStandardKeyword"] = SyntaxKind.WithKeyword] = "LastStandardKeyword";

        SyntaxKind[SyntaxKind["FirstFutureReservedKeyword"] = SyntaxKind.ClassKeyword] = "FirstFutureReservedKeyword";
        SyntaxKind[SyntaxKind["LastFutureReservedKeyword"] = SyntaxKind.SuperKeyword] = "LastFutureReservedKeyword";

        SyntaxKind[SyntaxKind["FirstFutureReservedStrictKeyword"] = SyntaxKind.ImplementsKeyword] = "FirstFutureReservedStrictKeyword";
        SyntaxKind[SyntaxKind["LastFutureReservedStrictKeyword"] = SyntaxKind.YieldKeyword] = "LastFutureReservedStrictKeyword";

        SyntaxKind[SyntaxKind["FirstTypeScriptKeyword"] = SyntaxKind.AnyKeyword] = "FirstTypeScriptKeyword";
        SyntaxKind[SyntaxKind["LastTypeScriptKeyword"] = SyntaxKind.StringKeyword] = "LastTypeScriptKeyword";

        SyntaxKind[SyntaxKind["FirstKeyword"] = SyntaxKind.FirstStandardKeyword] = "FirstKeyword";
        SyntaxKind[SyntaxKind["LastKeyword"] = SyntaxKind.LastTypeScriptKeyword] = "LastKeyword";

        SyntaxKind[SyntaxKind["FirstToken"] = SyntaxKind.ErrorToken] = "FirstToken";
        SyntaxKind[SyntaxKind["LastToken"] = SyntaxKind.SlashEqualsToken] = "LastToken";

        SyntaxKind[SyntaxKind["FirstPunctuation"] = SyntaxKind.OpenBraceToken] = "FirstPunctuation";
        SyntaxKind[SyntaxKind["LastPunctuation"] = SyntaxKind.SlashEqualsToken] = "LastPunctuation";

        SyntaxKind[SyntaxKind["FirstFixedWidth"] = SyntaxKind.FirstKeyword] = "FirstFixedWidth";
        SyntaxKind[SyntaxKind["LastFixedWidth"] = SyntaxKind.LastPunctuation] = "LastFixedWidth";

        SyntaxKind[SyntaxKind["FirstTrivia"] = SyntaxKind.WhitespaceTrivia] = "FirstTrivia";
        SyntaxKind[SyntaxKind["LastTrivia"] = SyntaxKind.SkippedTokenTrivia] = "LastTrivia";
    })(TypeScript.SyntaxKind || (TypeScript.SyntaxKind = {}));
    var SyntaxKind = TypeScript.SyntaxKind;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxFacts) {
        var textToKeywordKind = {
            "any": 60 /* AnyKeyword */,
            "boolean": 61 /* BooleanKeyword */,
            "break": 15 /* BreakKeyword */,
            "case": 16 /* CaseKeyword */,
            "catch": 17 /* CatchKeyword */,
            "class": 44 /* ClassKeyword */,
            "continue": 18 /* ContinueKeyword */,
            "const": 45 /* ConstKeyword */,
            "constructor": 62 /* ConstructorKeyword */,
            "debugger": 19 /* DebuggerKeyword */,
            "declare": 63 /* DeclareKeyword */,
            "default": 20 /* DefaultKeyword */,
            "delete": 21 /* DeleteKeyword */,
            "do": 22 /* DoKeyword */,
            "else": 23 /* ElseKeyword */,
            "enum": 46 /* EnumKeyword */,
            "export": 47 /* ExportKeyword */,
            "extends": 48 /* ExtendsKeyword */,
            "false": 24 /* FalseKeyword */,
            "finally": 25 /* FinallyKeyword */,
            "for": 26 /* ForKeyword */,
            "function": 27 /* FunctionKeyword */,
            "get": 64 /* GetKeyword */,
            "if": 28 /* IfKeyword */,
            "implements": 51 /* ImplementsKeyword */,
            "import": 49 /* ImportKeyword */,
            "in": 29 /* InKeyword */,
            "instanceof": 30 /* InstanceOfKeyword */,
            "interface": 52 /* InterfaceKeyword */,
            "let": 53 /* LetKeyword */,
            "module": 65 /* ModuleKeyword */,
            "new": 31 /* NewKeyword */,
            "null": 32 /* NullKeyword */,
            "number": 67 /* NumberKeyword */,
            "package": 54 /* PackageKeyword */,
            "private": 55 /* PrivateKeyword */,
            "protected": 56 /* ProtectedKeyword */,
            "public": 57 /* PublicKeyword */,
            "require": 66 /* RequireKeyword */,
            "return": 33 /* ReturnKeyword */,
            "set": 68 /* SetKeyword */,
            "static": 58 /* StaticKeyword */,
            "string": 69 /* StringKeyword */,
            "super": 50 /* SuperKeyword */,
            "switch": 34 /* SwitchKeyword */,
            "this": 35 /* ThisKeyword */,
            "throw": 36 /* ThrowKeyword */,
            "true": 37 /* TrueKeyword */,
            "try": 38 /* TryKeyword */,
            "typeof": 39 /* TypeOfKeyword */,
            "var": 40 /* VarKeyword */,
            "void": 41 /* VoidKeyword */,
            "while": 42 /* WhileKeyword */,
            "with": 43 /* WithKeyword */,
            "yield": 59 /* YieldKeyword */,
            "{": 70 /* OpenBraceToken */,
            "}": 71 /* CloseBraceToken */,
            "(": 72 /* OpenParenToken */,
            ")": 73 /* CloseParenToken */,
            "[": 74 /* OpenBracketToken */,
            "]": 75 /* CloseBracketToken */,
            ".": 76 /* DotToken */,
            "...": 77 /* DotDotDotToken */,
            ";": 78 /* SemicolonToken */,
            ",": 79 /* CommaToken */,
            "<": 80 /* LessThanToken */,
            ">": 81 /* GreaterThanToken */,
            "<=": 82 /* LessThanEqualsToken */,
            ">=": 83 /* GreaterThanEqualsToken */,
            "==": 84 /* EqualsEqualsToken */,
            "=>": 85 /* EqualsGreaterThanToken */,
            "!=": 86 /* ExclamationEqualsToken */,
            "===": 87 /* EqualsEqualsEqualsToken */,
            "!==": 88 /* ExclamationEqualsEqualsToken */,
            "+": 89 /* PlusToken */,
            "-": 90 /* MinusToken */,
            "*": 91 /* AsteriskToken */,
            "%": 92 /* PercentToken */,
            "++": 93 /* PlusPlusToken */,
            "--": 94 /* MinusMinusToken */,
            "<<": 95 /* LessThanLessThanToken */,
            ">>": 96 /* GreaterThanGreaterThanToken */,
            ">>>": 97 /* GreaterThanGreaterThanGreaterThanToken */,
            "&": 98 /* AmpersandToken */,
            "|": 99 /* BarToken */,
            "^": 100 /* CaretToken */,
            "!": 101 /* ExclamationToken */,
            "~": 102 /* TildeToken */,
            "&&": 103 /* AmpersandAmpersandToken */,
            "||": 104 /* BarBarToken */,
            "?": 105 /* QuestionToken */,
            ":": 106 /* ColonToken */,
            "=": 107 /* EqualsToken */,
            "+=": 108 /* PlusEqualsToken */,
            "-=": 109 /* MinusEqualsToken */,
            "*=": 110 /* AsteriskEqualsToken */,
            "%=": 111 /* PercentEqualsToken */,
            "<<=": 112 /* LessThanLessThanEqualsToken */,
            ">>=": 113 /* GreaterThanGreaterThanEqualsToken */,
            ">>>=": 114 /* GreaterThanGreaterThanGreaterThanEqualsToken */,
            "&=": 115 /* AmpersandEqualsToken */,
            "|=": 116 /* BarEqualsToken */,
            "^=": 117 /* CaretEqualsToken */,
            "/": 118 /* SlashToken */,
            "/=": 119 /* SlashEqualsToken */
        };

        var kindToText = new Array();

        for (var name in textToKeywordKind) {
            if (textToKeywordKind.hasOwnProperty(name)) {
                kindToText[textToKeywordKind[name]] = name;
            }
        }

        kindToText[62 /* ConstructorKeyword */] = "constructor";

        function getTokenKind(text) {
            if (textToKeywordKind.hasOwnProperty(text)) {
                return textToKeywordKind[text];
            }

            return 0 /* None */;
        }
        SyntaxFacts.getTokenKind = getTokenKind;

        function getText(kind) {
            var result = kindToText[kind];
            return result !== undefined ? result : null;
        }
        SyntaxFacts.getText = getText;

        function isTokenKind(kind) {
            return kind >= 9 /* FirstToken */ && kind <= 119 /* LastToken */;
        }
        SyntaxFacts.isTokenKind = isTokenKind;

        function isAnyKeyword(kind) {
            return kind >= 15 /* FirstKeyword */ && kind <= 69 /* LastKeyword */;
        }
        SyntaxFacts.isAnyKeyword = isAnyKeyword;

        function isStandardKeyword(kind) {
            return kind >= 15 /* FirstStandardKeyword */ && kind <= 43 /* LastStandardKeyword */;
        }
        SyntaxFacts.isStandardKeyword = isStandardKeyword;

        function isFutureReservedKeyword(kind) {
            return kind >= 44 /* FirstFutureReservedKeyword */ && kind <= 50 /* LastFutureReservedKeyword */;
        }
        SyntaxFacts.isFutureReservedKeyword = isFutureReservedKeyword;

        function isFutureReservedStrictKeyword(kind) {
            return kind >= 51 /* FirstFutureReservedStrictKeyword */ && kind <= 59 /* LastFutureReservedStrictKeyword */;
        }
        SyntaxFacts.isFutureReservedStrictKeyword = isFutureReservedStrictKeyword;

        function isAnyPunctuation(kind) {
            return kind >= 70 /* FirstPunctuation */ && kind <= 119 /* LastPunctuation */;
        }
        SyntaxFacts.isAnyPunctuation = isAnyPunctuation;

        function isPrefixUnaryExpressionOperatorToken(tokenKind) {
            return getPrefixUnaryExpressionFromOperatorToken(tokenKind) !== 0 /* None */;
        }
        SyntaxFacts.isPrefixUnaryExpressionOperatorToken = isPrefixUnaryExpressionOperatorToken;

        function isBinaryExpressionOperatorToken(tokenKind) {
            return getBinaryExpressionFromOperatorToken(tokenKind) !== 0 /* None */;
        }
        SyntaxFacts.isBinaryExpressionOperatorToken = isBinaryExpressionOperatorToken;

        function getPrefixUnaryExpressionFromOperatorToken(tokenKind) {
            switch (tokenKind) {
                case 89 /* PlusToken */:
                    return 164 /* PlusExpression */;
                case 90 /* MinusToken */:
                    return 165 /* NegateExpression */;
                case 102 /* TildeToken */:
                    return 166 /* BitwiseNotExpression */;
                case 101 /* ExclamationToken */:
                    return 167 /* LogicalNotExpression */;
                case 93 /* PlusPlusToken */:
                    return 168 /* PreIncrementExpression */;
                case 94 /* MinusMinusToken */:
                    return 169 /* PreDecrementExpression */;

                default:
                    return 0 /* None */;
            }
        }
        SyntaxFacts.getPrefixUnaryExpressionFromOperatorToken = getPrefixUnaryExpressionFromOperatorToken;

        function getPostfixUnaryExpressionFromOperatorToken(tokenKind) {
            switch (tokenKind) {
                case 93 /* PlusPlusToken */:
                    return 210 /* PostIncrementExpression */;
                case 94 /* MinusMinusToken */:
                    return 211 /* PostDecrementExpression */;
                default:
                    return 0 /* None */;
            }
        }
        SyntaxFacts.getPostfixUnaryExpressionFromOperatorToken = getPostfixUnaryExpressionFromOperatorToken;

        function getBinaryExpressionFromOperatorToken(tokenKind) {
            switch (tokenKind) {
                case 91 /* AsteriskToken */:
                    return 205 /* MultiplyExpression */;

                case 118 /* SlashToken */:
                    return 206 /* DivideExpression */;

                case 92 /* PercentToken */:
                    return 207 /* ModuloExpression */;

                case 89 /* PlusToken */:
                    return 208 /* AddExpression */;

                case 90 /* MinusToken */:
                    return 209 /* SubtractExpression */;

                case 95 /* LessThanLessThanToken */:
                    return 202 /* LeftShiftExpression */;

                case 96 /* GreaterThanGreaterThanToken */:
                    return 203 /* SignedRightShiftExpression */;

                case 97 /* GreaterThanGreaterThanGreaterThanToken */:
                    return 204 /* UnsignedRightShiftExpression */;

                case 80 /* LessThanToken */:
                    return 196 /* LessThanExpression */;

                case 81 /* GreaterThanToken */:
                    return 197 /* GreaterThanExpression */;

                case 82 /* LessThanEqualsToken */:
                    return 198 /* LessThanOrEqualExpression */;

                case 83 /* GreaterThanEqualsToken */:
                    return 199 /* GreaterThanOrEqualExpression */;

                case 30 /* InstanceOfKeyword */:
                    return 200 /* InstanceOfExpression */;

                case 29 /* InKeyword */:
                    return 201 /* InExpression */;

                case 84 /* EqualsEqualsToken */:
                    return 192 /* EqualsWithTypeConversionExpression */;

                case 86 /* ExclamationEqualsToken */:
                    return 193 /* NotEqualsWithTypeConversionExpression */;

                case 87 /* EqualsEqualsEqualsToken */:
                    return 194 /* EqualsExpression */;

                case 88 /* ExclamationEqualsEqualsToken */:
                    return 195 /* NotEqualsExpression */;

                case 98 /* AmpersandToken */:
                    return 191 /* BitwiseAndExpression */;

                case 100 /* CaretToken */:
                    return 190 /* BitwiseExclusiveOrExpression */;

                case 99 /* BarToken */:
                    return 189 /* BitwiseOrExpression */;

                case 103 /* AmpersandAmpersandToken */:
                    return 188 /* LogicalAndExpression */;

                case 104 /* BarBarToken */:
                    return 187 /* LogicalOrExpression */;

                case 116 /* BarEqualsToken */:
                    return 182 /* OrAssignmentExpression */;

                case 115 /* AmpersandEqualsToken */:
                    return 180 /* AndAssignmentExpression */;

                case 117 /* CaretEqualsToken */:
                    return 181 /* ExclusiveOrAssignmentExpression */;

                case 112 /* LessThanLessThanEqualsToken */:
                    return 183 /* LeftShiftAssignmentExpression */;

                case 113 /* GreaterThanGreaterThanEqualsToken */:
                    return 184 /* SignedRightShiftAssignmentExpression */;

                case 114 /* GreaterThanGreaterThanGreaterThanEqualsToken */:
                    return 185 /* UnsignedRightShiftAssignmentExpression */;

                case 108 /* PlusEqualsToken */:
                    return 175 /* AddAssignmentExpression */;

                case 109 /* MinusEqualsToken */:
                    return 176 /* SubtractAssignmentExpression */;

                case 110 /* AsteriskEqualsToken */:
                    return 177 /* MultiplyAssignmentExpression */;

                case 119 /* SlashEqualsToken */:
                    return 178 /* DivideAssignmentExpression */;

                case 111 /* PercentEqualsToken */:
                    return 179 /* ModuloAssignmentExpression */;

                case 107 /* EqualsToken */:
                    return 174 /* AssignmentExpression */;

                case 79 /* CommaToken */:
                    return 173 /* CommaExpression */;

                default:
                    return 0 /* None */;
            }
        }
        SyntaxFacts.getBinaryExpressionFromOperatorToken = getBinaryExpressionFromOperatorToken;

        function getOperatorTokenFromBinaryExpression(tokenKind) {
            switch (tokenKind) {
                case 205 /* MultiplyExpression */:
                    return 91 /* AsteriskToken */;

                case 206 /* DivideExpression */:
                    return 118 /* SlashToken */;

                case 207 /* ModuloExpression */:
                    return 92 /* PercentToken */;

                case 208 /* AddExpression */:
                    return 89 /* PlusToken */;

                case 209 /* SubtractExpression */:
                    return 90 /* MinusToken */;

                case 202 /* LeftShiftExpression */:
                    return 95 /* LessThanLessThanToken */;

                case 203 /* SignedRightShiftExpression */:
                    return 96 /* GreaterThanGreaterThanToken */;

                case 204 /* UnsignedRightShiftExpression */:
                    return 97 /* GreaterThanGreaterThanGreaterThanToken */;

                case 196 /* LessThanExpression */:
                    return 80 /* LessThanToken */;

                case 197 /* GreaterThanExpression */:
                    return 81 /* GreaterThanToken */;

                case 198 /* LessThanOrEqualExpression */:
                    return 82 /* LessThanEqualsToken */;

                case 199 /* GreaterThanOrEqualExpression */:
                    return 83 /* GreaterThanEqualsToken */;

                case 200 /* InstanceOfExpression */:
                    return 30 /* InstanceOfKeyword */;

                case 201 /* InExpression */:
                    return 29 /* InKeyword */;

                case 192 /* EqualsWithTypeConversionExpression */:
                    return 84 /* EqualsEqualsToken */;

                case 193 /* NotEqualsWithTypeConversionExpression */:
                    return 86 /* ExclamationEqualsToken */;

                case 194 /* EqualsExpression */:
                    return 87 /* EqualsEqualsEqualsToken */;

                case 195 /* NotEqualsExpression */:
                    return 88 /* ExclamationEqualsEqualsToken */;

                case 191 /* BitwiseAndExpression */:
                    return 98 /* AmpersandToken */;

                case 190 /* BitwiseExclusiveOrExpression */:
                    return 100 /* CaretToken */;

                case 189 /* BitwiseOrExpression */:
                    return 99 /* BarToken */;

                case 188 /* LogicalAndExpression */:
                    return 103 /* AmpersandAmpersandToken */;

                case 187 /* LogicalOrExpression */:
                    return 104 /* BarBarToken */;

                case 182 /* OrAssignmentExpression */:
                    return 116 /* BarEqualsToken */;

                case 180 /* AndAssignmentExpression */:
                    return 115 /* AmpersandEqualsToken */;

                case 181 /* ExclusiveOrAssignmentExpression */:
                    return 117 /* CaretEqualsToken */;

                case 183 /* LeftShiftAssignmentExpression */:
                    return 112 /* LessThanLessThanEqualsToken */;

                case 184 /* SignedRightShiftAssignmentExpression */:
                    return 113 /* GreaterThanGreaterThanEqualsToken */;

                case 185 /* UnsignedRightShiftAssignmentExpression */:
                    return 114 /* GreaterThanGreaterThanGreaterThanEqualsToken */;

                case 175 /* AddAssignmentExpression */:
                    return 108 /* PlusEqualsToken */;

                case 176 /* SubtractAssignmentExpression */:
                    return 109 /* MinusEqualsToken */;

                case 177 /* MultiplyAssignmentExpression */:
                    return 110 /* AsteriskEqualsToken */;

                case 178 /* DivideAssignmentExpression */:
                    return 119 /* SlashEqualsToken */;

                case 179 /* ModuloAssignmentExpression */:
                    return 111 /* PercentEqualsToken */;

                case 174 /* AssignmentExpression */:
                    return 107 /* EqualsToken */;

                case 173 /* CommaExpression */:
                    return 79 /* CommaToken */;

                default:
                    return 0 /* None */;
            }
        }
        SyntaxFacts.getOperatorTokenFromBinaryExpression = getOperatorTokenFromBinaryExpression;

        function isAnyDivideToken(kind) {
            switch (kind) {
                case 118 /* SlashToken */:
                case 119 /* SlashEqualsToken */:
                    return true;
                default:
                    return false;
            }
        }
        SyntaxFacts.isAnyDivideToken = isAnyDivideToken;

        function isAnyDivideOrRegularExpressionToken(kind) {
            switch (kind) {
                case 118 /* SlashToken */:
                case 119 /* SlashEqualsToken */:
                case 12 /* RegularExpressionLiteral */:
                    return true;
                default:
                    return false;
            }
        }
        SyntaxFacts.isAnyDivideOrRegularExpressionToken = isAnyDivideOrRegularExpressionToken;
    })(TypeScript.SyntaxFacts || (TypeScript.SyntaxFacts = {}));
    var SyntaxFacts = TypeScript.SyntaxFacts;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var isKeywordStartCharacter = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);
    var isIdentifierStartCharacter = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);
    var isIdentifierPartCharacter = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);
    var isNumericLiteralStart = TypeScript.ArrayUtilities.createArray(127 /* maxAsciiCharacter */, false);

    for (var character = 0; character < 127 /* maxAsciiCharacter */; character++) {
        if (character >= 97 /* a */ && character <= 122 /* z */) {
            isIdentifierStartCharacter[character] = true;
            isIdentifierPartCharacter[character] = true;
        } else if ((character >= 65 /* A */ && character <= 90 /* Z */) || character === 95 /* _ */ || character === 36 /* $ */) {
            isIdentifierStartCharacter[character] = true;
            isIdentifierPartCharacter[character] = true;
        } else if (character >= 48 /* _0 */ && character <= 57 /* _9 */) {
            isIdentifierPartCharacter[character] = true;
            isNumericLiteralStart[character] = true;
        }
    }

    isNumericLiteralStart[46 /* dot */] = true;

    for (var keywordKind = 15 /* FirstKeyword */; keywordKind <= 69 /* LastKeyword */; keywordKind++) {
        var keyword = TypeScript.SyntaxFacts.getText(keywordKind);
        isKeywordStartCharacter[keyword.charCodeAt(0)] = true;
    }

    var Scanner = (function () {
        function Scanner(fileName, text, languageVersion, window) {
            if (typeof window === "undefined") { window = TypeScript.ArrayUtilities.createArray(2048, 0); }
            this.slidingWindow = new TypeScript.SlidingWindow(this, window, 0, text.length());
            this.fileName = fileName;
            this.text = text;
            this._languageVersion = languageVersion;
        }
        Scanner.prototype.languageVersion = function () {
            return this._languageVersion;
        };

        Scanner.prototype.fetchMoreItems = function (argument, sourceIndex, window, destinationIndex, spaceAvailable) {
            var charactersRemaining = this.text.length() - sourceIndex;
            var amountToRead = TypeScript.MathPrototype.min(charactersRemaining, spaceAvailable);
            this.text.copyTo(sourceIndex, window, destinationIndex, amountToRead);
            return amountToRead;
        };

        Scanner.prototype.currentCharCode = function () {
            return this.slidingWindow.currentItem(null);
        };

        Scanner.prototype.absoluteIndex = function () {
            return this.slidingWindow.absoluteIndex();
        };

        Scanner.prototype.setAbsoluteIndex = function (index) {
            this.slidingWindow.setAbsoluteIndex(index);
        };

        Scanner.prototype.scan = function (diagnostics, allowRegularExpression) {
            var diagnosticsLength = diagnostics.length;
            var fullStart = this.slidingWindow.absoluteIndex();
            var leadingTriviaInfo = this.scanTriviaInfo(diagnostics, false);

            var start = this.slidingWindow.absoluteIndex();
            var kindAndFlags = this.scanSyntaxToken(diagnostics, allowRegularExpression);
            var end = this.slidingWindow.absoluteIndex();

            var trailingTriviaInfo = this.scanTriviaInfo(diagnostics, true);
            var fullEnd = this.slidingWindow.absoluteIndex();

            var isVariableWidthKeyword = (kindAndFlags & -2147483648 /* IsVariableWidthKeyword */) !== 0;
            var kind = kindAndFlags & ~-2147483648 /* IsVariableWidthKeyword */;

            var token = this.createToken(fullStart, leadingTriviaInfo, start, kind, end, fullEnd, trailingTriviaInfo, isVariableWidthKeyword);

            return diagnosticsLength !== diagnostics.length ? TypeScript.Syntax.realizeToken(token) : token;
        };

        Scanner.prototype.createToken = function (fullStart, leadingTriviaInfo, start, kind, end, fullEnd, trailingTriviaInfo, isVariableWidthKeyword) {
            if (!isVariableWidthKeyword && kind >= 15 /* FirstFixedWidth */) {
                if (leadingTriviaInfo === 0) {
                    if (trailingTriviaInfo === 0) {
                        return new TypeScript.Syntax.FixedWidthTokenWithNoTrivia(kind);
                    } else {
                        var fullText = this.text.substr(fullStart, fullEnd - fullStart, false);
                        return new TypeScript.Syntax.FixedWidthTokenWithTrailingTrivia(fullText, kind, trailingTriviaInfo);
                    }
                } else if (trailingTriviaInfo === 0) {
                    var fullText = this.text.substr(fullStart, fullEnd - fullStart, false);
                    return new TypeScript.Syntax.FixedWidthTokenWithLeadingTrivia(fullText, kind, leadingTriviaInfo);
                } else {
                    var fullText = this.text.substr(fullStart, fullEnd - fullStart, false);
                    return new TypeScript.Syntax.FixedWidthTokenWithLeadingAndTrailingTrivia(fullText, kind, leadingTriviaInfo, trailingTriviaInfo);
                }
            } else {
                var width = end - start;

                var fullText = this.text.substr(fullStart, fullEnd - fullStart, false);

                if (leadingTriviaInfo === 0) {
                    if (trailingTriviaInfo === 0) {
                        return new TypeScript.Syntax.VariableWidthTokenWithNoTrivia(fullText, kind);
                    } else {
                        return new TypeScript.Syntax.VariableWidthTokenWithTrailingTrivia(fullText, kind, trailingTriviaInfo);
                    }
                } else if (trailingTriviaInfo === 0) {
                    return new TypeScript.Syntax.VariableWidthTokenWithLeadingTrivia(fullText, kind, leadingTriviaInfo);
                } else {
                    return new TypeScript.Syntax.VariableWidthTokenWithLeadingAndTrailingTrivia(fullText, kind, leadingTriviaInfo, trailingTriviaInfo);
                }
            }
        };

        Scanner.scanTrivia = function (text, start, length, isTrailing) {
            var scanner = new Scanner(null, text.subText(new TypeScript.TextSpan(start, length)), 1 /* EcmaScript5 */, Scanner.triviaWindow);
            return scanner.scanTrivia(text, start, isTrailing);
        };

        Scanner.prototype.scanTrivia = function (underlyingText, underlyingTextStart, isTrailing) {
            var trivia = new Array();

            while (true) {
                if (!this.slidingWindow.isAtEndOfSource()) {
                    var ch = this.currentCharCode();

                    switch (ch) {
                        case 32 /* space */:
                        case 160 /* nonBreakingSpace */:
                        case 8192 /* enQuad */:
                        case 8193 /* emQuad */:
                        case 8194 /* enSpace */:
                        case 8195 /* emSpace */:
                        case 8196 /* threePerEmSpace */:
                        case 8197 /* fourPerEmSpace */:
                        case 8198 /* sixPerEmSpace */:
                        case 8199 /* figureSpace */:
                        case 8200 /* punctuationSpace */:
                        case 8201 /* thinSpace */:
                        case 8202 /* hairSpace */:
                        case 8203 /* zeroWidthSpace */:
                        case 8239 /* narrowNoBreakSpace */:
                        case 12288 /* ideographicSpace */:

                        case 9 /* tab */:
                        case 11 /* verticalTab */:
                        case 12 /* formFeed */:
                        case 65279 /* byteOrderMark */:
                            trivia.push(this.scanWhitespaceTrivia(underlyingText, underlyingTextStart));
                            continue;

                        case 47 /* slash */:
                            var ch2 = this.slidingWindow.peekItemN(1);
                            if (ch2 === 47 /* slash */) {
                                trivia.push(this.scanSingleLineCommentTrivia(underlyingText, underlyingTextStart));
                                continue;
                            }

                            if (ch2 === 42 /* asterisk */) {
                                trivia.push(this.scanMultiLineCommentTrivia(underlyingText, underlyingTextStart));
                                continue;
                            }

                            throw TypeScript.Errors.invalidOperation();

                        case 13 /* carriageReturn */:
                        case 10 /* lineFeed */:
                        case 8233 /* paragraphSeparator */:
                        case 8232 /* lineSeparator */:
                            trivia.push(this.scanLineTerminatorSequenceTrivia(ch));

                            if (!isTrailing) {
                                continue;
                            }

                            break;

                        default:
                            throw TypeScript.Errors.invalidOperation();
                    }
                }

                return TypeScript.Syntax.triviaList(trivia);
            }
        };

        Scanner.prototype.scanTriviaInfo = function (diagnostics, isTrailing) {
            var width = 0;
            var hasCommentOrNewLine = 0;

            while (true) {
                var ch = this.currentCharCode();

                switch (ch) {
                    case 32 /* space */:
                    case 160 /* nonBreakingSpace */:
                    case 8192 /* enQuad */:
                    case 8193 /* emQuad */:
                    case 8194 /* enSpace */:
                    case 8195 /* emSpace */:
                    case 8196 /* threePerEmSpace */:
                    case 8197 /* fourPerEmSpace */:
                    case 8198 /* sixPerEmSpace */:
                    case 8199 /* figureSpace */:
                    case 8200 /* punctuationSpace */:
                    case 8201 /* thinSpace */:
                    case 8202 /* hairSpace */:
                    case 8203 /* zeroWidthSpace */:
                    case 8239 /* narrowNoBreakSpace */:
                    case 12288 /* ideographicSpace */:

                    case 9 /* tab */:
                    case 11 /* verticalTab */:
                    case 12 /* formFeed */:
                    case 65279 /* byteOrderMark */:
                        this.slidingWindow.moveToNextItem();
                        width++;
                        continue;

                    case 47 /* slash */:
                        var ch2 = this.slidingWindow.peekItemN(1);
                        if (ch2 === 47 /* slash */) {
                            hasCommentOrNewLine |= 2 /* TriviaCommentMask */;
                            width += this.scanSingleLineCommentTriviaLength();
                            continue;
                        }

                        if (ch2 === 42 /* asterisk */) {
                            hasCommentOrNewLine |= 2 /* TriviaCommentMask */;
                            width += this.scanMultiLineCommentTriviaLength(diagnostics);
                            continue;
                        }

                        break;

                    case 13 /* carriageReturn */:
                    case 10 /* lineFeed */:
                    case 8233 /* paragraphSeparator */:
                    case 8232 /* lineSeparator */:
                        hasCommentOrNewLine |= 1 /* TriviaNewLineMask */;
                        width += this.scanLineTerminatorSequenceLength(ch);

                        if (!isTrailing) {
                            continue;
                        }

                        break;
                }

                return (width << 2 /* TriviaFullWidthShift */) | hasCommentOrNewLine;
            }
        };

        Scanner.prototype.isNewLineCharacter = function (ch) {
            switch (ch) {
                case 13 /* carriageReturn */:
                case 10 /* lineFeed */:
                case 8233 /* paragraphSeparator */:
                case 8232 /* lineSeparator */:
                    return true;
                default:
                    return false;
            }
        };

        Scanner.prototype.scanWhitespaceTrivia = function (underlyingText, underlyingTextStart) {
            var absoluteStartIndex = this.absoluteIndex();

            var width = 0;
            while (true) {
                var ch = this.currentCharCode();

                switch (ch) {
                    case 32 /* space */:
                    case 160 /* nonBreakingSpace */:
                    case 8192 /* enQuad */:
                    case 8193 /* emQuad */:
                    case 8194 /* enSpace */:
                    case 8195 /* emSpace */:
                    case 8196 /* threePerEmSpace */:
                    case 8197 /* fourPerEmSpace */:
                    case 8198 /* sixPerEmSpace */:
                    case 8199 /* figureSpace */:
                    case 8200 /* punctuationSpace */:
                    case 8201 /* thinSpace */:
                    case 8202 /* hairSpace */:
                    case 8203 /* zeroWidthSpace */:
                    case 8239 /* narrowNoBreakSpace */:
                    case 12288 /* ideographicSpace */:

                    case 9 /* tab */:
                    case 11 /* verticalTab */:
                    case 12 /* formFeed */:
                    case 65279 /* byteOrderMark */:
                        this.slidingWindow.moveToNextItem();
                        width++;
                        continue;
                }

                break;
            }

            return TypeScript.Syntax.deferredTrivia(4 /* WhitespaceTrivia */, underlyingText, underlyingTextStart + absoluteStartIndex, width);
        };

        Scanner.prototype.scanSingleLineCommentTrivia = function (underlyingText, underlyingTextStart) {
            var absoluteStartIndex = this.slidingWindow.absoluteIndex();
            var width = this.scanSingleLineCommentTriviaLength();

            return TypeScript.Syntax.deferredTrivia(7 /* SingleLineCommentTrivia */, underlyingText, underlyingTextStart + absoluteStartIndex, width);
        };

        Scanner.prototype.scanSingleLineCommentTriviaLength = function () {
            this.slidingWindow.moveToNextItem();
            this.slidingWindow.moveToNextItem();

            var width = 2;
            while (true) {
                if (this.slidingWindow.isAtEndOfSource() || this.isNewLineCharacter(this.currentCharCode())) {
                    return width;
                }

                this.slidingWindow.moveToNextItem();
                width++;
            }
        };

        Scanner.prototype.scanMultiLineCommentTrivia = function (underlyingText, underlyingTextStart) {
            var absoluteStartIndex = this.absoluteIndex();
            var width = this.scanMultiLineCommentTriviaLength(null);

            return TypeScript.Syntax.deferredTrivia(6 /* MultiLineCommentTrivia */, underlyingText, underlyingTextStart + absoluteStartIndex, width);
        };

        Scanner.prototype.scanMultiLineCommentTriviaLength = function (diagnostics) {
            this.slidingWindow.moveToNextItem();
            this.slidingWindow.moveToNextItem();

            var width = 2;
            while (true) {
                if (this.slidingWindow.isAtEndOfSource()) {
                    if (diagnostics !== null) {
                        diagnostics.push(new TypeScript.Diagnostic(this.fileName, this.text.lineMap(), this.slidingWindow.absoluteIndex(), 0, TypeScript.DiagnosticCode.AsteriskSlash_expected, null));
                    }

                    return width;
                }

                var ch = this.currentCharCode();
                if (ch === 42 /* asterisk */ && this.slidingWindow.peekItemN(1) === 47 /* slash */) {
                    this.slidingWindow.moveToNextItem();
                    this.slidingWindow.moveToNextItem();
                    width += 2;
                    return width;
                }

                this.slidingWindow.moveToNextItem();
                width++;
            }
        };

        Scanner.prototype.scanLineTerminatorSequenceTrivia = function (ch) {
            var absoluteStartIndex = this.slidingWindow.getAndPinAbsoluteIndex();
            var width = this.scanLineTerminatorSequenceLength(ch);

            var text = this.substring(absoluteStartIndex, absoluteStartIndex + width, false);
            this.slidingWindow.releaseAndUnpinAbsoluteIndex(absoluteStartIndex);

            return TypeScript.Syntax.trivia(5 /* NewLineTrivia */, text);
        };

        Scanner.prototype.scanLineTerminatorSequenceLength = function (ch) {
            this.slidingWindow.moveToNextItem();

            if (ch === 13 /* carriageReturn */ && this.currentCharCode() === 10 /* lineFeed */) {
                this.slidingWindow.moveToNextItem();
                return 2;
            } else {
                return 1;
            }
        };

        Scanner.prototype.scanSyntaxToken = function (diagnostics, allowRegularExpression) {
            if (this.slidingWindow.isAtEndOfSource()) {
                return 10 /* EndOfFileToken */;
            }

            var character = this.currentCharCode();

            switch (character) {
                case 34 /* doubleQuote */:
                case 39 /* singleQuote */:
                    return this.scanStringLiteral(diagnostics);

                case 47 /* slash */:
                    return this.scanSlashToken(allowRegularExpression);

                case 46 /* dot */:
                    return this.scanDotToken(diagnostics);

                case 45 /* minus */:
                    return this.scanMinusToken();

                case 33 /* exclamation */:
                    return this.scanExclamationToken();

                case 61 /* equals */:
                    return this.scanEqualsToken();

                case 124 /* bar */:
                    return this.scanBarToken();

                case 42 /* asterisk */:
                    return this.scanAsteriskToken();

                case 43 /* plus */:
                    return this.scanPlusToken();

                case 37 /* percent */:
                    return this.scanPercentToken();

                case 38 /* ampersand */:
                    return this.scanAmpersandToken();

                case 94 /* caret */:
                    return this.scanCaretToken();

                case 60 /* lessThan */:
                    return this.scanLessThanToken();

                case 62 /* greaterThan */:
                    return this.advanceAndSetTokenKind(81 /* GreaterThanToken */);

                case 44 /* comma */:
                    return this.advanceAndSetTokenKind(79 /* CommaToken */);

                case 58 /* colon */:
                    return this.advanceAndSetTokenKind(106 /* ColonToken */);

                case 59 /* semicolon */:
                    return this.advanceAndSetTokenKind(78 /* SemicolonToken */);

                case 126 /* tilde */:
                    return this.advanceAndSetTokenKind(102 /* TildeToken */);

                case 40 /* openParen */:
                    return this.advanceAndSetTokenKind(72 /* OpenParenToken */);

                case 41 /* closeParen */:
                    return this.advanceAndSetTokenKind(73 /* CloseParenToken */);

                case 123 /* openBrace */:
                    return this.advanceAndSetTokenKind(70 /* OpenBraceToken */);

                case 125 /* closeBrace */:
                    return this.advanceAndSetTokenKind(71 /* CloseBraceToken */);

                case 91 /* openBracket */:
                    return this.advanceAndSetTokenKind(74 /* OpenBracketToken */);

                case 93 /* closeBracket */:
                    return this.advanceAndSetTokenKind(75 /* CloseBracketToken */);

                case 63 /* question */:
                    return this.advanceAndSetTokenKind(105 /* QuestionToken */);
            }

            if (isNumericLiteralStart[character]) {
                return this.scanNumericLiteral(diagnostics);
            }

            if (isIdentifierStartCharacter[character]) {
                var result = this.tryFastScanIdentifierOrKeyword(character);
                if (result !== 0 /* None */) {
                    return result;
                }
            }

            if (this.isIdentifierStart(this.peekCharOrUnicodeEscape())) {
                return this.slowScanIdentifierOrKeyword(diagnostics);
            }

            return this.scanDefaultCharacter(character, diagnostics);
        };

        Scanner.prototype.isIdentifierStart = function (interpretedChar) {
            if (isIdentifierStartCharacter[interpretedChar]) {
                return true;
            }

            return interpretedChar > 127 /* maxAsciiCharacter */ && TypeScript.Unicode.isIdentifierStart(interpretedChar, this._languageVersion);
        };

        Scanner.prototype.isIdentifierPart = function (interpretedChar) {
            if (isIdentifierPartCharacter[interpretedChar]) {
                return true;
            }

            return interpretedChar > 127 /* maxAsciiCharacter */ && TypeScript.Unicode.isIdentifierPart(interpretedChar, this._languageVersion);
        };

        Scanner.prototype.tryFastScanIdentifierOrKeyword = function (firstCharacter) {
            var slidingWindow = this.slidingWindow;
            var window = slidingWindow.window;

            var startIndex = slidingWindow.currentRelativeItemIndex;
            var endIndex = slidingWindow.windowCount;
            var currentIndex = startIndex;
            var character = 0;

            while (currentIndex < endIndex) {
                character = window[currentIndex];
                if (!isIdentifierPartCharacter[character]) {
                    break;
                }

                currentIndex++;
            }

            if (currentIndex === endIndex) {
                return 0 /* None */;
            } else if (character === 92 /* backslash */ || character > 127 /* maxAsciiCharacter */) {
                return 0 /* None */;
            } else {
                var kind;
                var identifierLength = currentIndex - startIndex;
                if (isKeywordStartCharacter[firstCharacter]) {
                    kind = TypeScript.ScannerUtilities.identifierKind(window, startIndex, identifierLength);
                } else {
                    kind = 11 /* IdentifierName */;
                }

                slidingWindow.setAbsoluteIndex(slidingWindow.absoluteIndex() + identifierLength);

                return kind;
            }
        };

        Scanner.prototype.slowScanIdentifierOrKeyword = function (diagnostics) {
            var startIndex = this.slidingWindow.absoluteIndex();
            var sawUnicodeEscape = false;

            do {
                var unicodeEscape = this.scanCharOrUnicodeEscape(diagnostics);
                sawUnicodeEscape = sawUnicodeEscape || unicodeEscape;
            } while(this.isIdentifierPart(this.peekCharOrUnicodeEscape()));

            var length = this.slidingWindow.absoluteIndex() - startIndex;
            var text = this.text.substr(startIndex, length, false);
            var valueText = TypeScript.Syntax.massageEscapes(text);

            var keywordKind = TypeScript.SyntaxFacts.getTokenKind(valueText);
            if (keywordKind >= 15 /* FirstKeyword */ && keywordKind <= 69 /* LastKeyword */) {
                if (sawUnicodeEscape) {
                    return keywordKind | -2147483648 /* IsVariableWidthKeyword */;
                } else {
                    return keywordKind;
                }
            }

            return 11 /* IdentifierName */;
        };

        Scanner.prototype.scanNumericLiteral = function (diagnostics) {
            if (this.isHexNumericLiteral()) {
                this.scanHexNumericLiteral();
            } else if (this.isOctalNumericLiteral()) {
                this.scanOctalNumericLiteral(diagnostics);
            } else {
                this.scanDecimalNumericLiteral();
            }

            return 13 /* NumericLiteral */;
        };

        Scanner.prototype.isOctalNumericLiteral = function () {
            return this.currentCharCode() === 48 /* _0 */ && TypeScript.CharacterInfo.isOctalDigit(this.slidingWindow.peekItemN(1));
        };

        Scanner.prototype.scanOctalNumericLiteral = function (diagnostics) {
            var position = this.absoluteIndex();

            while (TypeScript.CharacterInfo.isOctalDigit(this.currentCharCode())) {
                this.slidingWindow.moveToNextItem();
            }

            if (this.languageVersion() >= 1 /* EcmaScript5 */) {
                diagnostics.push(new TypeScript.Diagnostic(this.fileName, this.text.lineMap(), position, this.absoluteIndex() - position, TypeScript.DiagnosticCode.Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher, null));
            }
        };

        Scanner.prototype.scanDecimalDigits = function () {
            while (TypeScript.CharacterInfo.isDecimalDigit(this.currentCharCode())) {
                this.slidingWindow.moveToNextItem();
            }
        };

        Scanner.prototype.scanDecimalNumericLiteral = function () {
            this.scanDecimalDigits();

            if (this.currentCharCode() === 46 /* dot */) {
                this.slidingWindow.moveToNextItem();
            }

            this.scanDecimalDigits();

            var ch = this.currentCharCode();
            if (ch === 101 /* e */ || ch === 69 /* E */) {
                var nextChar1 = this.slidingWindow.peekItemN(1);

                if (TypeScript.CharacterInfo.isDecimalDigit(nextChar1)) {
                    this.slidingWindow.moveToNextItem();
                    this.scanDecimalDigits();
                } else if (nextChar1 === 45 /* minus */ || nextChar1 === 43 /* plus */) {
                    var nextChar2 = this.slidingWindow.peekItemN(2);
                    if (TypeScript.CharacterInfo.isDecimalDigit(nextChar2)) {
                        this.slidingWindow.moveToNextItem();
                        this.slidingWindow.moveToNextItem();
                        this.scanDecimalDigits();
                    }
                }
            }
        };

        Scanner.prototype.scanHexNumericLiteral = function () {
            this.slidingWindow.moveToNextItem();
            this.slidingWindow.moveToNextItem();

            while (TypeScript.CharacterInfo.isHexDigit(this.currentCharCode())) {
                this.slidingWindow.moveToNextItem();
            }
        };

        Scanner.prototype.isHexNumericLiteral = function () {
            if (this.currentCharCode() === 48 /* _0 */) {
                var ch = this.slidingWindow.peekItemN(1);

                if (ch === 120 /* x */ || ch === 88 /* X */) {
                    ch = this.slidingWindow.peekItemN(2);

                    return TypeScript.CharacterInfo.isHexDigit(ch);
                }
            }

            return false;
        };

        Scanner.prototype.advanceAndSetTokenKind = function (kind) {
            this.slidingWindow.moveToNextItem();
            return kind;
        };

        Scanner.prototype.scanLessThanToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 82 /* LessThanEqualsToken */;
            } else if (this.currentCharCode() === 60 /* lessThan */) {
                this.slidingWindow.moveToNextItem();
                if (this.currentCharCode() === 61 /* equals */) {
                    this.slidingWindow.moveToNextItem();
                    return 112 /* LessThanLessThanEqualsToken */;
                } else {
                    return 95 /* LessThanLessThanToken */;
                }
            } else {
                return 80 /* LessThanToken */;
            }
        };

        Scanner.prototype.scanBarToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 116 /* BarEqualsToken */;
            } else if (this.currentCharCode() === 124 /* bar */) {
                this.slidingWindow.moveToNextItem();
                return 104 /* BarBarToken */;
            } else {
                return 99 /* BarToken */;
            }
        };

        Scanner.prototype.scanCaretToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 117 /* CaretEqualsToken */;
            } else {
                return 100 /* CaretToken */;
            }
        };

        Scanner.prototype.scanAmpersandToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();
            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 115 /* AmpersandEqualsToken */;
            } else if (this.currentCharCode() === 38 /* ampersand */) {
                this.slidingWindow.moveToNextItem();
                return 103 /* AmpersandAmpersandToken */;
            } else {
                return 98 /* AmpersandToken */;
            }
        };

        Scanner.prototype.scanPercentToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 111 /* PercentEqualsToken */;
            } else {
                return 92 /* PercentToken */;
            }
        };

        Scanner.prototype.scanMinusToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();

            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 109 /* MinusEqualsToken */;
            } else if (character === 45 /* minus */) {
                this.slidingWindow.moveToNextItem();
                return 94 /* MinusMinusToken */;
            } else {
                return 90 /* MinusToken */;
            }
        };

        Scanner.prototype.scanPlusToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();
            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 108 /* PlusEqualsToken */;
            } else if (character === 43 /* plus */) {
                this.slidingWindow.moveToNextItem();
                return 93 /* PlusPlusToken */;
            } else {
                return 89 /* PlusToken */;
            }
        };

        Scanner.prototype.scanAsteriskToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 110 /* AsteriskEqualsToken */;
            } else {
                return 91 /* AsteriskToken */;
            }
        };

        Scanner.prototype.scanEqualsToken = function () {
            this.slidingWindow.moveToNextItem();
            var character = this.currentCharCode();
            if (character === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();

                if (this.currentCharCode() === 61 /* equals */) {
                    this.slidingWindow.moveToNextItem();

                    return 87 /* EqualsEqualsEqualsToken */;
                } else {
                    return 84 /* EqualsEqualsToken */;
                }
            } else if (character === 62 /* greaterThan */) {
                this.slidingWindow.moveToNextItem();
                return 85 /* EqualsGreaterThanToken */;
            } else {
                return 107 /* EqualsToken */;
            }
        };

        Scanner.prototype.isDotPrefixedNumericLiteral = function () {
            if (this.currentCharCode() === 46 /* dot */) {
                var ch = this.slidingWindow.peekItemN(1);
                return TypeScript.CharacterInfo.isDecimalDigit(ch);
            }

            return false;
        };

        Scanner.prototype.scanDotToken = function (diagnostics) {
            if (this.isDotPrefixedNumericLiteral()) {
                return this.scanNumericLiteral(diagnostics);
            }

            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 46 /* dot */ && this.slidingWindow.peekItemN(1) === 46 /* dot */) {
                this.slidingWindow.moveToNextItem();
                this.slidingWindow.moveToNextItem();
                return 77 /* DotDotDotToken */;
            } else {
                return 76 /* DotToken */;
            }
        };

        Scanner.prototype.scanSlashToken = function (allowRegularExpression) {
            if (allowRegularExpression) {
                var result = this.tryScanRegularExpressionToken();
                if (result !== 0 /* None */) {
                    return result;
                }
            }

            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();
                return 119 /* SlashEqualsToken */;
            } else {
                return 118 /* SlashToken */;
            }
        };

        Scanner.prototype.tryScanRegularExpressionToken = function () {
            var startIndex = this.slidingWindow.getAndPinAbsoluteIndex();

            this.slidingWindow.moveToNextItem();

            var inEscape = false;
            var inCharacterClass = false;
            while (true) {
                var ch = this.currentCharCode();

                if (this.isNewLineCharacter(ch) || this.slidingWindow.isAtEndOfSource()) {
                    this.slidingWindow.rewindToPinnedIndex(startIndex);
                    this.slidingWindow.releaseAndUnpinAbsoluteIndex(startIndex);
                    return 0 /* None */;
                }

                this.slidingWindow.moveToNextItem();
                if (inEscape) {
                    inEscape = false;
                    continue;
                }

                switch (ch) {
                    case 92 /* backslash */:
                        inEscape = true;
                        continue;

                    case 91 /* openBracket */:
                        inCharacterClass = true;
                        continue;

                    case 93 /* closeBracket */:
                        inCharacterClass = false;
                        continue;

                    case 47 /* slash */:
                        if (inCharacterClass) {
                            continue;
                        }

                        break;

                    default:
                        continue;
                }

                break;
            }

            while (isIdentifierPartCharacter[this.currentCharCode()]) {
                this.slidingWindow.moveToNextItem();
            }

            this.slidingWindow.releaseAndUnpinAbsoluteIndex(startIndex);
            return 12 /* RegularExpressionLiteral */;
        };

        Scanner.prototype.scanExclamationToken = function () {
            this.slidingWindow.moveToNextItem();
            if (this.currentCharCode() === 61 /* equals */) {
                this.slidingWindow.moveToNextItem();

                if (this.currentCharCode() === 61 /* equals */) {
                    this.slidingWindow.moveToNextItem();

                    return 88 /* ExclamationEqualsEqualsToken */;
                } else {
                    return 86 /* ExclamationEqualsToken */;
                }
            } else {
                return 101 /* ExclamationToken */;
            }
        };

        Scanner.prototype.scanDefaultCharacter = function (character, diagnostics) {
            var position = this.slidingWindow.absoluteIndex();
            this.slidingWindow.moveToNextItem();

            var text = String.fromCharCode(character);
            var messageText = this.getErrorMessageText(text);
            diagnostics.push(new TypeScript.Diagnostic(this.fileName, this.text.lineMap(), position, 1, TypeScript.DiagnosticCode.Unexpected_character_0, [messageText]));

            return 9 /* ErrorToken */;
        };

        Scanner.prototype.getErrorMessageText = function (text) {
            if (text === "\\") {
                return '"\\"';
            }

            return JSON.stringify(text);
        };

        Scanner.prototype.skipEscapeSequence = function (diagnostics) {
            var rewindPoint = this.slidingWindow.getAndPinAbsoluteIndex();

            this.slidingWindow.moveToNextItem();

            var ch = this.currentCharCode();
            this.slidingWindow.moveToNextItem();
            switch (ch) {
                case 120 /* x */:
                case 117 /* u */:
                    this.slidingWindow.rewindToPinnedIndex(rewindPoint);
                    var value = this.scanUnicodeOrHexEscape(diagnostics);
                    break;

                case 13 /* carriageReturn */:
                    if (this.currentCharCode() === 10 /* lineFeed */) {
                        this.slidingWindow.moveToNextItem();
                    }
                    break;

                default:
                    break;
            }

            this.slidingWindow.releaseAndUnpinAbsoluteIndex(rewindPoint);
        };

        Scanner.prototype.scanStringLiteral = function (diagnostics) {
            var quoteCharacter = this.currentCharCode();

            this.slidingWindow.moveToNextItem();

            while (true) {
                var ch = this.currentCharCode();
                if (ch === 92 /* backslash */) {
                    this.skipEscapeSequence(diagnostics);
                } else if (ch === quoteCharacter) {
                    this.slidingWindow.moveToNextItem();
                    break;
                } else if (this.isNewLineCharacter(ch) || this.slidingWindow.isAtEndOfSource()) {
                    diagnostics.push(new TypeScript.Diagnostic(this.fileName, this.text.lineMap(), TypeScript.MathPrototype.min(this.slidingWindow.absoluteIndex(), this.text.length()), 1, TypeScript.DiagnosticCode.Missing_close_quote_character, null));
                    break;
                } else {
                    this.slidingWindow.moveToNextItem();
                }
            }

            return 14 /* StringLiteral */;
        };

        Scanner.prototype.isUnicodeEscape = function (character) {
            if (character === 92 /* backslash */) {
                var ch2 = this.slidingWindow.peekItemN(1);
                if (ch2 === 117 /* u */) {
                    return true;
                }
            }

            return false;
        };

        Scanner.prototype.peekCharOrUnicodeEscape = function () {
            var character = this.currentCharCode();
            if (this.isUnicodeEscape(character)) {
                return this.peekUnicodeOrHexEscape();
            } else {
                return character;
            }
        };

        Scanner.prototype.peekUnicodeOrHexEscape = function () {
            var startIndex = this.slidingWindow.getAndPinAbsoluteIndex();

            var ch = this.scanUnicodeOrHexEscape(null);

            this.slidingWindow.rewindToPinnedIndex(startIndex);
            this.slidingWindow.releaseAndUnpinAbsoluteIndex(startIndex);

            return ch;
        };

        Scanner.prototype.scanCharOrUnicodeEscape = function (errors) {
            var ch = this.currentCharCode();
            if (ch === 92 /* backslash */) {
                var ch2 = this.slidingWindow.peekItemN(1);
                if (ch2 === 117 /* u */) {
                    this.scanUnicodeOrHexEscape(errors);
                    return true;
                }
            }

            this.slidingWindow.moveToNextItem();
            return false;
        };

        Scanner.prototype.scanUnicodeOrHexEscape = function (errors) {
            var start = this.slidingWindow.absoluteIndex();
            var character = this.currentCharCode();

            this.slidingWindow.moveToNextItem();

            character = this.currentCharCode();

            var intChar = 0;
            this.slidingWindow.moveToNextItem();

            var count = character === 117 /* u */ ? 4 : 2;

            for (var i = 0; i < count; i++) {
                var ch2 = this.currentCharCode();
                if (!TypeScript.CharacterInfo.isHexDigit(ch2)) {
                    if (errors !== null) {
                        var end = this.slidingWindow.absoluteIndex();
                        var info = this.createIllegalEscapeDiagnostic(start, end);
                        errors.push(info);
                    }

                    break;
                }

                intChar = (intChar << 4) + TypeScript.CharacterInfo.hexValue(ch2);
                this.slidingWindow.moveToNextItem();
            }

            return intChar;
        };

        Scanner.prototype.substring = function (start, end, intern) {
            var length = end - start;
            var offset = start - this.slidingWindow.windowAbsoluteStartIndex;

            if (intern) {
                return TypeScript.Collections.DefaultStringTable.addCharArray(this.slidingWindow.window, offset, length);
            } else {
                return TypeScript.StringUtilities.fromCharCodeArray(this.slidingWindow.window.slice(offset, offset + length));
            }
        };

        Scanner.prototype.createIllegalEscapeDiagnostic = function (start, end) {
            return new TypeScript.Diagnostic(this.fileName, this.text.lineMap(), start, end - start, TypeScript.DiagnosticCode.Unrecognized_escape_sequence, null);
        };

        Scanner.isValidIdentifier = function (text, languageVersion) {
            var scanner = new Scanner(null, text, languageVersion, Scanner.triviaWindow);
            var errors = new Array();
            var token = scanner.scan(errors, false);

            return errors.length === 0 && TypeScript.SyntaxFacts.isIdentifierNameOrAnyKeyword(token) && token.width() === text.length();
        };
        Scanner.triviaWindow = TypeScript.ArrayUtilities.createArray(2048, 0);
        return Scanner;
    })();
    TypeScript.Scanner = Scanner;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var ScannerUtilities = (function () {
        function ScannerUtilities() {
        }
        ScannerUtilities.identifierKind = function (array, startIndex, length) {
            switch (length) {
                case 2:
                    switch (array[startIndex]) {
                        case 100 /* d */:
                            return (array[startIndex + 1] === 111 /* o */) ? 22 /* DoKeyword */ : 11 /* IdentifierName */;
                        case 105 /* i */:
                            switch (array[startIndex + 1]) {
                                case 102 /* f */:
                                    return 28 /* IfKeyword */;
                                case 110 /* n */:
                                    return 29 /* InKeyword */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        default:
                            return 11 /* IdentifierName */;
                    }

                case 3:
                    switch (array[startIndex]) {
                        case 102 /* f */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 114 /* r */) ? 26 /* ForKeyword */ : 11 /* IdentifierName */;
                        case 110 /* n */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 119 /* w */) ? 31 /* NewKeyword */ : 11 /* IdentifierName */;
                        case 116 /* t */:
                            return (array[startIndex + 1] === 114 /* r */ && array[startIndex + 2] === 121 /* y */) ? 38 /* TryKeyword */ : 11 /* IdentifierName */;
                        case 118 /* v */:
                            return (array[startIndex + 1] === 97 /* a */ && array[startIndex + 2] === 114 /* r */) ? 40 /* VarKeyword */ : 11 /* IdentifierName */;
                        case 108 /* l */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */) ? 53 /* LetKeyword */ : 11 /* IdentifierName */;
                        case 97 /* a */:
                            return (array[startIndex + 1] === 110 /* n */ && array[startIndex + 2] === 121 /* y */) ? 60 /* AnyKeyword */ : 11 /* IdentifierName */;
                        case 103 /* g */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */) ? 64 /* GetKeyword */ : 11 /* IdentifierName */;
                        case 115 /* s */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */) ? 68 /* SetKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 4:
                    switch (array[startIndex]) {
                        case 99 /* c */:
                            return (array[startIndex + 1] === 97 /* a */ && array[startIndex + 2] === 115 /* s */ && array[startIndex + 3] === 101 /* e */) ? 16 /* CaseKeyword */ : 11 /* IdentifierName */;
                        case 101 /* e */:
                            switch (array[startIndex + 1]) {
                                case 108 /* l */:
                                    return (array[startIndex + 2] === 115 /* s */ && array[startIndex + 3] === 101 /* e */) ? 23 /* ElseKeyword */ : 11 /* IdentifierName */;
                                case 110 /* n */:
                                    return (array[startIndex + 2] === 117 /* u */ && array[startIndex + 3] === 109 /* m */) ? 46 /* EnumKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 110 /* n */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 108 /* l */ && array[startIndex + 3] === 108 /* l */) ? 32 /* NullKeyword */ : 11 /* IdentifierName */;
                        case 116 /* t */:
                            switch (array[startIndex + 1]) {
                                case 104 /* h */:
                                    return (array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 115 /* s */) ? 35 /* ThisKeyword */ : 11 /* IdentifierName */;
                                case 114 /* r */:
                                    return (array[startIndex + 2] === 117 /* u */ && array[startIndex + 3] === 101 /* e */) ? 37 /* TrueKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 118 /* v */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 100 /* d */) ? 41 /* VoidKeyword */ : 11 /* IdentifierName */;
                        case 119 /* w */:
                            return (array[startIndex + 1] === 105 /* i */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 104 /* h */) ? 43 /* WithKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 5:
                    switch (array[startIndex]) {
                        case 98 /* b */:
                            return (array[startIndex + 1] === 114 /* r */ && array[startIndex + 2] === 101 /* e */ && array[startIndex + 3] === 97 /* a */ && array[startIndex + 4] === 107 /* k */) ? 15 /* BreakKeyword */ : 11 /* IdentifierName */;
                        case 99 /* c */:
                            switch (array[startIndex + 1]) {
                                case 97 /* a */:
                                    return (array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 99 /* c */ && array[startIndex + 4] === 104 /* h */) ? 17 /* CatchKeyword */ : 11 /* IdentifierName */;
                                case 108 /* l */:
                                    return (array[startIndex + 2] === 97 /* a */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 115 /* s */) ? 44 /* ClassKeyword */ : 11 /* IdentifierName */;
                                case 111 /* o */:
                                    return (array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 116 /* t */) ? 45 /* ConstKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 102 /* f */:
                            return (array[startIndex + 1] === 97 /* a */ && array[startIndex + 2] === 108 /* l */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 101 /* e */) ? 24 /* FalseKeyword */ : 11 /* IdentifierName */;
                        case 116 /* t */:
                            return (array[startIndex + 1] === 104 /* h */ && array[startIndex + 2] === 114 /* r */ && array[startIndex + 3] === 111 /* o */ && array[startIndex + 4] === 119 /* w */) ? 36 /* ThrowKeyword */ : 11 /* IdentifierName */;
                        case 119 /* w */:
                            return (array[startIndex + 1] === 104 /* h */ && array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 101 /* e */) ? 42 /* WhileKeyword */ : 11 /* IdentifierName */;
                        case 115 /* s */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 114 /* r */) ? 50 /* SuperKeyword */ : 11 /* IdentifierName */;
                        case 121 /* y */:
                            return (array[startIndex + 1] === 105 /* i */ && array[startIndex + 2] === 101 /* e */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 100 /* d */) ? 59 /* YieldKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 6:
                    switch (array[startIndex]) {
                        case 100 /* d */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 108 /* l */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 116 /* t */ && array[startIndex + 5] === 101 /* e */) ? 21 /* DeleteKeyword */ : 11 /* IdentifierName */;
                        case 114 /* r */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 110 /* n */) ? 33 /* ReturnKeyword */ : 11 /* IdentifierName */;
                        case 115 /* s */:
                            switch (array[startIndex + 1]) {
                                case 119 /* w */:
                                    return (array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 99 /* c */ && array[startIndex + 5] === 104 /* h */) ? 34 /* SwitchKeyword */ : 11 /* IdentifierName */;
                                case 116 /* t */:
                                    switch (array[startIndex + 2]) {
                                        case 97 /* a */:
                                            return (array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 99 /* c */) ? 58 /* StaticKeyword */ : 11 /* IdentifierName */;
                                        case 114 /* r */:
                                            return (array[startIndex + 3] === 105 /* i */ && array[startIndex + 4] === 110 /* n */ && array[startIndex + 5] === 103 /* g */) ? 69 /* StringKeyword */ : 11 /* IdentifierName */;
                                        default:
                                            return 11 /* IdentifierName */;
                                    }

                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 116 /* t */:
                            return (array[startIndex + 1] === 121 /* y */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 111 /* o */ && array[startIndex + 5] === 102 /* f */) ? 39 /* TypeOfKeyword */ : 11 /* IdentifierName */;
                        case 101 /* e */:
                            return (array[startIndex + 1] === 120 /* x */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 111 /* o */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 116 /* t */) ? 47 /* ExportKeyword */ : 11 /* IdentifierName */;
                        case 105 /* i */:
                            return (array[startIndex + 1] === 109 /* m */ && array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 111 /* o */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 116 /* t */) ? 49 /* ImportKeyword */ : 11 /* IdentifierName */;
                        case 112 /* p */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 98 /* b */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 99 /* c */) ? 57 /* PublicKeyword */ : 11 /* IdentifierName */;
                        case 109 /* m */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 100 /* d */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 108 /* l */ && array[startIndex + 5] === 101 /* e */) ? 65 /* ModuleKeyword */ : 11 /* IdentifierName */;
                        case 110 /* n */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 109 /* m */ && array[startIndex + 3] === 98 /* b */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 114 /* r */) ? 67 /* NumberKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 7:
                    switch (array[startIndex]) {
                        case 100 /* d */:
                            switch (array[startIndex + 1]) {
                                case 101 /* e */:
                                    switch (array[startIndex + 2]) {
                                        case 102 /* f */:
                                            return (array[startIndex + 3] === 97 /* a */ && array[startIndex + 4] === 117 /* u */ && array[startIndex + 5] === 108 /* l */ && array[startIndex + 6] === 116 /* t */) ? 20 /* DefaultKeyword */ : 11 /* IdentifierName */;
                                        case 99 /* c */:
                                            return (array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 114 /* r */ && array[startIndex + 6] === 101 /* e */) ? 63 /* DeclareKeyword */ : 11 /* IdentifierName */;
                                        default:
                                            return 11 /* IdentifierName */;
                                    }

                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 102 /* f */:
                            return (array[startIndex + 1] === 105 /* i */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 97 /* a */ && array[startIndex + 4] === 108 /* l */ && array[startIndex + 5] === 108 /* l */ && array[startIndex + 6] === 121 /* y */) ? 25 /* FinallyKeyword */ : 11 /* IdentifierName */;
                        case 101 /* e */:
                            return (array[startIndex + 1] === 120 /* x */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 110 /* n */ && array[startIndex + 5] === 100 /* d */ && array[startIndex + 6] === 115 /* s */) ? 48 /* ExtendsKeyword */ : 11 /* IdentifierName */;
                        case 112 /* p */:
                            switch (array[startIndex + 1]) {
                                case 97 /* a */:
                                    return (array[startIndex + 2] === 99 /* c */ && array[startIndex + 3] === 107 /* k */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 103 /* g */ && array[startIndex + 6] === 101 /* e */) ? 54 /* PackageKeyword */ : 11 /* IdentifierName */;
                                case 114 /* r */:
                                    return (array[startIndex + 2] === 105 /* i */ && array[startIndex + 3] === 118 /* v */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 116 /* t */ && array[startIndex + 6] === 101 /* e */) ? 55 /* PrivateKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        case 98 /* b */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 111 /* o */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 97 /* a */ && array[startIndex + 6] === 110 /* n */) ? 61 /* BooleanKeyword */ : 11 /* IdentifierName */;
                        case 114 /* r */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 113 /* q */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 114 /* r */ && array[startIndex + 6] === 101 /* e */) ? 66 /* RequireKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 8:
                    switch (array[startIndex]) {
                        case 99 /* c */:
                            return (array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 105 /* i */ && array[startIndex + 5] === 110 /* n */ && array[startIndex + 6] === 117 /* u */ && array[startIndex + 7] === 101 /* e */) ? 18 /* ContinueKeyword */ : 11 /* IdentifierName */;
                        case 100 /* d */:
                            return (array[startIndex + 1] === 101 /* e */ && array[startIndex + 2] === 98 /* b */ && array[startIndex + 3] === 117 /* u */ && array[startIndex + 4] === 103 /* g */ && array[startIndex + 5] === 103 /* g */ && array[startIndex + 6] === 101 /* e */ && array[startIndex + 7] === 114 /* r */) ? 19 /* DebuggerKeyword */ : 11 /* IdentifierName */;
                        case 102 /* f */:
                            return (array[startIndex + 1] === 117 /* u */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 99 /* c */ && array[startIndex + 4] === 116 /* t */ && array[startIndex + 5] === 105 /* i */ && array[startIndex + 6] === 111 /* o */ && array[startIndex + 7] === 110 /* n */) ? 27 /* FunctionKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 9:
                    switch (array[startIndex]) {
                        case 105 /* i */:
                            return (array[startIndex + 1] === 110 /* n */ && array[startIndex + 2] === 116 /* t */ && array[startIndex + 3] === 101 /* e */ && array[startIndex + 4] === 114 /* r */ && array[startIndex + 5] === 102 /* f */ && array[startIndex + 6] === 97 /* a */ && array[startIndex + 7] === 99 /* c */ && array[startIndex + 8] === 101 /* e */) ? 52 /* InterfaceKeyword */ : 11 /* IdentifierName */;
                        case 112 /* p */:
                            return (array[startIndex + 1] === 114 /* r */ && array[startIndex + 2] === 111 /* o */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 99 /* c */ && array[startIndex + 6] === 116 /* t */ && array[startIndex + 7] === 101 /* e */ && array[startIndex + 8] === 100 /* d */) ? 56 /* ProtectedKeyword */ : 11 /* IdentifierName */;
                        default:
                            return 11 /* IdentifierName */;
                    }

                case 10:
                    switch (array[startIndex]) {
                        case 105 /* i */:
                            switch (array[startIndex + 1]) {
                                case 110 /* n */:
                                    return (array[startIndex + 2] === 115 /* s */ && array[startIndex + 3] === 116 /* t */ && array[startIndex + 4] === 97 /* a */ && array[startIndex + 5] === 110 /* n */ && array[startIndex + 6] === 99 /* c */ && array[startIndex + 7] === 101 /* e */ && array[startIndex + 8] === 111 /* o */ && array[startIndex + 9] === 102 /* f */) ? 30 /* InstanceOfKeyword */ : 11 /* IdentifierName */;
                                case 109 /* m */:
                                    return (array[startIndex + 2] === 112 /* p */ && array[startIndex + 3] === 108 /* l */ && array[startIndex + 4] === 101 /* e */ && array[startIndex + 5] === 109 /* m */ && array[startIndex + 6] === 101 /* e */ && array[startIndex + 7] === 110 /* n */ && array[startIndex + 8] === 116 /* t */ && array[startIndex + 9] === 115 /* s */) ? 51 /* ImplementsKeyword */ : 11 /* IdentifierName */;
                                default:
                                    return 11 /* IdentifierName */;
                            }

                        default:
                            return 11 /* IdentifierName */;
                    }

                case 11:
                    return (array[startIndex] === 99 /* c */ && array[startIndex + 1] === 111 /* o */ && array[startIndex + 2] === 110 /* n */ && array[startIndex + 3] === 115 /* s */ && array[startIndex + 4] === 116 /* t */ && array[startIndex + 5] === 114 /* r */ && array[startIndex + 6] === 117 /* u */ && array[startIndex + 7] === 99 /* c */ && array[startIndex + 8] === 116 /* t */ && array[startIndex + 9] === 111 /* o */ && array[startIndex + 10] === 114 /* r */) ? 62 /* ConstructorKeyword */ : 11 /* IdentifierName */;
                default:
                    return 11 /* IdentifierName */;
            }
        };
        return ScannerUtilities;
    })();
    TypeScript.ScannerUtilities = ScannerUtilities;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var EmptySeparatedSyntaxList = (function () {
            function EmptySeparatedSyntaxList() {
            }
            EmptySeparatedSyntaxList.prototype.kind = function () {
                return 2 /* SeparatedList */;
            };

            EmptySeparatedSyntaxList.prototype.isNode = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isToken = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isList = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isSeparatedList = function () {
                return true;
            };

            EmptySeparatedSyntaxList.prototype.toJSON = function (key) {
                return [];
            };

            EmptySeparatedSyntaxList.prototype.childCount = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.nonSeparatorCount = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.separatorCount = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.toArray = function () {
                return [];
            };

            EmptySeparatedSyntaxList.prototype.toNonSeparatorArray = function () {
                return [];
            };

            EmptySeparatedSyntaxList.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySeparatedSyntaxList.prototype.nonSeparatorAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySeparatedSyntaxList.prototype.separatorAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySeparatedSyntaxList.prototype.collectTextElements = function (elements) {
            };

            EmptySeparatedSyntaxList.prototype.firstToken = function () {
                return null;
            };

            EmptySeparatedSyntaxList.prototype.lastToken = function () {
                return null;
            };

            EmptySeparatedSyntaxList.prototype.fullWidth = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.fullText = function () {
                return "";
            };

            EmptySeparatedSyntaxList.prototype.width = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.isIncrementallyUnusable = function () {
                return false;
            };

            EmptySeparatedSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                throw TypeScript.Errors.invalidOperation();
            };

            EmptySeparatedSyntaxList.prototype.insertChildrenInto = function (array, index) {
            };

            EmptySeparatedSyntaxList.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            EmptySeparatedSyntaxList.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            EmptySeparatedSyntaxList.prototype.leadingTriviaWidth = function () {
                return 0;
            };

            EmptySeparatedSyntaxList.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            return EmptySeparatedSyntaxList;
        })();

        Syntax.emptySeparatedList = new EmptySeparatedSyntaxList();

        var SingletonSeparatedSyntaxList = (function () {
            function SingletonSeparatedSyntaxList(item) {
                this.item = item;
            }
            SingletonSeparatedSyntaxList.prototype.toJSON = function (key) {
                return [this.item];
            };

            SingletonSeparatedSyntaxList.prototype.kind = function () {
                return 2 /* SeparatedList */;
            };

            SingletonSeparatedSyntaxList.prototype.isNode = function () {
                return false;
            };
            SingletonSeparatedSyntaxList.prototype.isToken = function () {
                return false;
            };
            SingletonSeparatedSyntaxList.prototype.isList = function () {
                return false;
            };
            SingletonSeparatedSyntaxList.prototype.isSeparatedList = function () {
                return true;
            };

            SingletonSeparatedSyntaxList.prototype.childCount = function () {
                return 1;
            };
            SingletonSeparatedSyntaxList.prototype.nonSeparatorCount = function () {
                return 1;
            };
            SingletonSeparatedSyntaxList.prototype.separatorCount = function () {
                return 0;
            };

            SingletonSeparatedSyntaxList.prototype.toArray = function () {
                return [this.item];
            };
            SingletonSeparatedSyntaxList.prototype.toNonSeparatorArray = function () {
                return [this.item];
            };

            SingletonSeparatedSyntaxList.prototype.childAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSeparatedSyntaxList.prototype.nonSeparatorAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSeparatedSyntaxList.prototype.separatorAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            SingletonSeparatedSyntaxList.prototype.collectTextElements = function (elements) {
                this.item.collectTextElements(elements);
            };

            SingletonSeparatedSyntaxList.prototype.firstToken = function () {
                return this.item.firstToken();
            };

            SingletonSeparatedSyntaxList.prototype.lastToken = function () {
                return this.item.lastToken();
            };

            SingletonSeparatedSyntaxList.prototype.fullWidth = function () {
                return this.item.fullWidth();
            };

            SingletonSeparatedSyntaxList.prototype.width = function () {
                return this.item.width();
            };

            SingletonSeparatedSyntaxList.prototype.fullText = function () {
                return this.item.fullText();
            };

            SingletonSeparatedSyntaxList.prototype.leadingTrivia = function () {
                return this.item.leadingTrivia();
            };

            SingletonSeparatedSyntaxList.prototype.trailingTrivia = function () {
                return this.item.trailingTrivia();
            };

            SingletonSeparatedSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.item.leadingTriviaWidth();
            };

            SingletonSeparatedSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.item.trailingTriviaWidth();
            };

            SingletonSeparatedSyntaxList.prototype.isTypeScriptSpecific = function () {
                return this.item.isTypeScriptSpecific();
            };

            SingletonSeparatedSyntaxList.prototype.isIncrementallyUnusable = function () {
                return this.item.isIncrementallyUnusable();
            };

            SingletonSeparatedSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                return this.item.findTokenInternal(new TypeScript.PositionedSeparatedList(parent, this, fullStart), position, fullStart);
            };

            SingletonSeparatedSyntaxList.prototype.insertChildrenInto = function (array, index) {
                array.splice(index, 0, this.item);
            };
            return SingletonSeparatedSyntaxList;
        })();

        var NormalSeparatedSyntaxList = (function () {
            function NormalSeparatedSyntaxList(elements) {
                this._data = 0;
                this.elements = elements;
            }
            NormalSeparatedSyntaxList.prototype.kind = function () {
                return 2 /* SeparatedList */;
            };

            NormalSeparatedSyntaxList.prototype.isToken = function () {
                return false;
            };
            NormalSeparatedSyntaxList.prototype.isNode = function () {
                return false;
            };
            NormalSeparatedSyntaxList.prototype.isList = function () {
                return false;
            };
            NormalSeparatedSyntaxList.prototype.isSeparatedList = function () {
                return true;
            };
            NormalSeparatedSyntaxList.prototype.toJSON = function (key) {
                return this.elements;
            };

            NormalSeparatedSyntaxList.prototype.childCount = function () {
                return this.elements.length;
            };
            NormalSeparatedSyntaxList.prototype.nonSeparatorCount = function () {
                return TypeScript.IntegerUtilities.integerDivide(this.elements.length + 1, 2);
            };
            NormalSeparatedSyntaxList.prototype.separatorCount = function () {
                return TypeScript.IntegerUtilities.integerDivide(this.elements.length, 2);
            };

            NormalSeparatedSyntaxList.prototype.toArray = function () {
                return this.elements.slice(0);
            };

            NormalSeparatedSyntaxList.prototype.toNonSeparatorArray = function () {
                var result = [];
                for (var i = 0, n = this.nonSeparatorCount(); i < n; i++) {
                    result.push(this.nonSeparatorAt(i));
                }

                return result;
            };

            NormalSeparatedSyntaxList.prototype.childAt = function (index) {
                if (index < 0 || index >= this.elements.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.elements[index];
            };

            NormalSeparatedSyntaxList.prototype.nonSeparatorAt = function (index) {
                var value = index * 2;
                if (value < 0 || value >= this.elements.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.elements[value];
            };

            NormalSeparatedSyntaxList.prototype.separatorAt = function (index) {
                var value = index * 2 + 1;
                if (value < 0 || value >= this.elements.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.elements[value];
            };

            NormalSeparatedSyntaxList.prototype.firstToken = function () {
                var token;
                for (var i = 0, n = this.elements.length; i < n; i++) {
                    if (i % 2 === 0) {
                        var nodeOrToken = this.elements[i];
                        token = nodeOrToken.firstToken();
                        if (token !== null) {
                            return token;
                        }
                    } else {
                        token = this.elements[i];
                        if (token.width() > 0) {
                            return token;
                        }
                    }
                }

                return null;
            };

            NormalSeparatedSyntaxList.prototype.lastToken = function () {
                var token;
                for (var i = this.elements.length - 1; i >= 0; i--) {
                    if (i % 2 === 0) {
                        var nodeOrToken = this.elements[i];
                        token = nodeOrToken.lastToken();
                        if (token !== null) {
                            return token;
                        }
                    } else {
                        token = this.elements[i];
                        if (token.width() > 0) {
                            return token;
                        }
                    }
                }

                return null;
            };

            NormalSeparatedSyntaxList.prototype.fullText = function () {
                var elements = [];
                this.collectTextElements(elements);
                return elements.join("");
            };

            NormalSeparatedSyntaxList.prototype.isTypeScriptSpecific = function () {
                for (var i = 0, n = this.nonSeparatorCount(); i < n; i++) {
                    if (this.nonSeparatorAt(i).isTypeScriptSpecific()) {
                        return true;
                    }
                }

                return false;
            };

            NormalSeparatedSyntaxList.prototype.isIncrementallyUnusable = function () {
                return (this.data() & 2 /* NodeIncrementallyUnusableMask */) !== 0;
            };

            NormalSeparatedSyntaxList.prototype.fullWidth = function () {
                return this.data() >>> 3 /* NodeFullWidthShift */;
            };

            NormalSeparatedSyntaxList.prototype.width = function () {
                var fullWidth = this.fullWidth();
                return fullWidth - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            NormalSeparatedSyntaxList.prototype.leadingTrivia = function () {
                return this.firstToken().leadingTrivia();
            };

            NormalSeparatedSyntaxList.prototype.trailingTrivia = function () {
                return this.lastToken().trailingTrivia();
            };

            NormalSeparatedSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.firstToken().leadingTriviaWidth();
            };

            NormalSeparatedSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.lastToken().trailingTriviaWidth();
            };

            NormalSeparatedSyntaxList.prototype.computeData = function () {
                var fullWidth = 0;
                var isIncrementallyUnusable = false;

                for (var i = 0, n = this.elements.length; i < n; i++) {
                    var element = this.elements[i];

                    var childWidth = element.fullWidth();
                    fullWidth += childWidth;

                    isIncrementallyUnusable = isIncrementallyUnusable || element.isIncrementallyUnusable();
                }

                return (fullWidth << 3 /* NodeFullWidthShift */) | (isIncrementallyUnusable ? 2 /* NodeIncrementallyUnusableMask */ : 0) | 1 /* NodeDataComputed */;
            };

            NormalSeparatedSyntaxList.prototype.data = function () {
                if ((this._data & 1 /* NodeDataComputed */) === 0) {
                    this._data = this.computeData();
                }

                return this._data;
            };

            NormalSeparatedSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                parent = new TypeScript.PositionedSeparatedList(parent, this, fullStart);
                for (var i = 0, n = this.elements.length; i < n; i++) {
                    var element = this.elements[i];

                    var childWidth = element.fullWidth();
                    if (position < childWidth) {
                        return element.findTokenInternal(parent, position, fullStart);
                    }

                    position -= childWidth;
                    fullStart += childWidth;
                }

                throw TypeScript.Errors.invalidOperation();
            };

            NormalSeparatedSyntaxList.prototype.collectTextElements = function (elements) {
                for (var i = 0, n = this.elements.length; i < n; i++) {
                    var element = this.elements[i];
                    element.collectTextElements(elements);
                }
            };

            NormalSeparatedSyntaxList.prototype.insertChildrenInto = function (array, index) {
                if (index === 0) {
                    array.unshift.apply(array, this.elements);
                } else {
                    array.splice.apply(array, [index, 0].concat(this.elements));
                }
            };
            return NormalSeparatedSyntaxList;
        })();

        function separatedList(nodes) {
            return separatedListAndValidate(nodes, false);
        }
        Syntax.separatedList = separatedList;

        function separatedListAndValidate(nodes, validate) {
            if (nodes === undefined || nodes === null || nodes.length === 0) {
                return Syntax.emptySeparatedList;
            }

            if (validate) {
                for (var i = 0; i < nodes.length; i++) {
                    var item = nodes[i];

                    if (i % 2 === 1) {
                    }
                }
            }

            if (nodes.length === 1) {
                return new SingletonSeparatedSyntaxList(nodes[0]);
            }

            return new NormalSeparatedSyntaxList(nodes);
        }
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SlidingWindow = (function () {
        function SlidingWindow(source, window, defaultValue, sourceLength) {
            if (typeof sourceLength === "undefined") { sourceLength = -1; }
            this.source = source;
            this.window = window;
            this.defaultValue = defaultValue;
            this.sourceLength = sourceLength;
            this.windowCount = 0;
            this.windowAbsoluteStartIndex = 0;
            this.currentRelativeItemIndex = 0;
            this._pinCount = 0;
            this.firstPinnedAbsoluteIndex = -1;
        }
        SlidingWindow.prototype.windowAbsoluteEndIndex = function () {
            return this.windowAbsoluteStartIndex + this.windowCount;
        };

        SlidingWindow.prototype.addMoreItemsToWindow = function (argument) {
            if (this.sourceLength >= 0 && this.absoluteIndex() >= this.sourceLength) {
                return false;
            }

            if (this.windowCount >= this.window.length) {
                this.tryShiftOrGrowWindow();
            }

            var spaceAvailable = this.window.length - this.windowCount;
            var amountFetched = this.source.fetchMoreItems(argument, this.windowAbsoluteEndIndex(), this.window, this.windowCount, spaceAvailable);

            this.windowCount += amountFetched;
            return amountFetched > 0;
        };

        SlidingWindow.prototype.tryShiftOrGrowWindow = function () {
            var currentIndexIsPastWindowHalfwayPoint = this.currentRelativeItemIndex > (this.window.length >>> 1);

            var isAllowedToShift = this.firstPinnedAbsoluteIndex === -1 || this.firstPinnedAbsoluteIndex > this.windowAbsoluteStartIndex;

            if (currentIndexIsPastWindowHalfwayPoint && isAllowedToShift) {
                var shiftStartIndex = this.firstPinnedAbsoluteIndex === -1 ? this.currentRelativeItemIndex : this.firstPinnedAbsoluteIndex - this.windowAbsoluteStartIndex;

                var shiftCount = this.windowCount - shiftStartIndex;

                if (shiftCount > 0) {
                    TypeScript.ArrayUtilities.copy(this.window, shiftStartIndex, this.window, 0, shiftCount);
                }

                this.windowAbsoluteStartIndex += shiftStartIndex;

                this.windowCount -= shiftStartIndex;

                this.currentRelativeItemIndex -= shiftStartIndex;
            } else {
                TypeScript.ArrayUtilities.grow(this.window, this.window.length * 2, this.defaultValue);
            }
        };

        SlidingWindow.prototype.absoluteIndex = function () {
            return this.windowAbsoluteStartIndex + this.currentRelativeItemIndex;
        };

        SlidingWindow.prototype.isAtEndOfSource = function () {
            return this.absoluteIndex() >= this.sourceLength;
        };

        SlidingWindow.prototype.getAndPinAbsoluteIndex = function () {
            var absoluteIndex = this.absoluteIndex();
            var pinCount = this._pinCount++;
            if (pinCount === 0) {
                this.firstPinnedAbsoluteIndex = absoluteIndex;
            }

            return absoluteIndex;
        };

        SlidingWindow.prototype.releaseAndUnpinAbsoluteIndex = function (absoluteIndex) {
            this._pinCount--;
            if (this._pinCount === 0) {
                this.firstPinnedAbsoluteIndex = -1;
            }
        };

        SlidingWindow.prototype.rewindToPinnedIndex = function (absoluteIndex) {
            var relativeIndex = absoluteIndex - this.windowAbsoluteStartIndex;

            this.currentRelativeItemIndex = relativeIndex;
        };

        SlidingWindow.prototype.currentItem = function (argument) {
            if (this.currentRelativeItemIndex >= this.windowCount) {
                if (!this.addMoreItemsToWindow(argument)) {
                    return this.defaultValue;
                }
            }

            return this.window[this.currentRelativeItemIndex];
        };

        SlidingWindow.prototype.peekItemN = function (n) {
            while (this.currentRelativeItemIndex + n >= this.windowCount) {
                if (!this.addMoreItemsToWindow(null)) {
                    return this.defaultValue;
                }
            }

            return this.window[this.currentRelativeItemIndex + n];
        };

        SlidingWindow.prototype.moveToNextItem = function () {
            this.currentRelativeItemIndex++;
        };

        SlidingWindow.prototype.disgardAllItemsFromCurrentIndexOnwards = function () {
            this.windowCount = this.currentRelativeItemIndex;
        };

        SlidingWindow.prototype.setAbsoluteIndex = function (absoluteIndex) {
            if (this.absoluteIndex() === absoluteIndex) {
                return;
            }

            if (this._pinCount > 0) {
            }

            if (absoluteIndex >= this.windowAbsoluteStartIndex && absoluteIndex < this.windowAbsoluteEndIndex()) {
                this.currentRelativeItemIndex = (absoluteIndex - this.windowAbsoluteStartIndex);
            } else {
                this.windowAbsoluteStartIndex = absoluteIndex;

                this.windowCount = 0;

                this.currentRelativeItemIndex = 0;
            }
        };

        SlidingWindow.prototype.pinCount = function () {
            return this._pinCount;
        };
        return SlidingWindow;
    })();
    TypeScript.SlidingWindow = SlidingWindow;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        function emptySourceUnit() {
            return Syntax.normalModeFactory.sourceUnit(Syntax.emptyList, Syntax.token(10 /* EndOfFileToken */, { text: "" }));
        }
        Syntax.emptySourceUnit = emptySourceUnit;

        function getStandaloneExpression(positionedToken) {
            var token = positionedToken.token();
            if (positionedToken !== null && positionedToken.kind() === 11 /* IdentifierName */) {
                var parentPositionedNode = positionedToken.containingNode();
                var parentNode = parentPositionedNode.node();

                if (parentNode.kind() === 121 /* QualifiedName */ && parentNode.right === token) {
                    return parentPositionedNode;
                } else if (parentNode.kind() === 212 /* MemberAccessExpression */ && parentNode.name === token) {
                    return parentPositionedNode;
                }
            }

            return positionedToken;
        }
        Syntax.getStandaloneExpression = getStandaloneExpression;

        function isInModuleOrTypeContext(positionedToken) {
            if (positionedToken !== null) {
                var positionedNodeOrToken = Syntax.getStandaloneExpression(positionedToken);
                var parent = positionedNodeOrToken.containingNode();

                if (parent !== null) {
                    switch (parent.kind()) {
                        case 246 /* ModuleNameModuleReference */:
                            return true;
                        case 121 /* QualifiedName */:
                            return true;
                        default:
                            return isInTypeOnlyContext(positionedToken);
                    }
                }
            }

            return false;
        }
        Syntax.isInModuleOrTypeContext = isInModuleOrTypeContext;

        function isInTypeOnlyContext(positionedToken) {
            var positionedNodeOrToken = Syntax.getStandaloneExpression(positionedToken);
            var positionedParent = positionedNodeOrToken.containingNode();

            var parent = positionedParent.node();
            var nodeOrToken = positionedNodeOrToken.nodeOrToken();

            if (parent !== null) {
                switch (parent.kind()) {
                    case 124 /* ArrayType */:
                        return parent.type === nodeOrToken;
                    case 220 /* CastExpression */:
                        return parent.type === nodeOrToken;
                    case 244 /* TypeAnnotation */:
                    case 230 /* ExtendsHeritageClause */:
                    case 231 /* ImplementsHeritageClause */:
                    case 228 /* TypeArgumentList */:
                        return true;
                }
            }

            return false;
        }
        Syntax.isInTypeOnlyContext = isInTypeOnlyContext;

        function childOffset(parent, child) {
            var offset = 0;
            for (var i = 0, n = parent.childCount(); i < n; i++) {
                var current = parent.childAt(i);
                if (current === child) {
                    return offset;
                }

                if (current !== null) {
                    offset += current.fullWidth();
                }
            }

            throw TypeScript.Errors.invalidOperation();
        }
        Syntax.childOffset = childOffset;

        function childOffsetAt(parent, index) {
            var offset = 0;
            for (var i = 0; i < index; i++) {
                var current = parent.childAt(i);
                if (current !== null) {
                    offset += current.fullWidth();
                }
            }

            return offset;
        }
        Syntax.childOffsetAt = childOffsetAt;

        function childIndex(parent, child) {
            for (var i = 0, n = parent.childCount(); i < n; i++) {
                var current = parent.childAt(i);
                if (current === child) {
                    return i;
                }
            }

            throw TypeScript.Errors.invalidOperation();
        }
        Syntax.childIndex = childIndex;

        function nodeStructuralEquals(node1, node2) {
            if (node1 === null) {
                return node2 === null;
            }

            return node1.structuralEquals(node2);
        }
        Syntax.nodeStructuralEquals = nodeStructuralEquals;

        function nodeOrTokenStructuralEquals(node1, node2) {
            if (node1 === node2) {
                return true;
            }

            if (node1 === null || node2 === null) {
                return false;
            }

            if (node1.isToken()) {
                return node2.isToken() ? tokenStructuralEquals(node1, node2) : false;
            }

            return node2.isNode() ? nodeStructuralEquals(node1, node2) : false;
        }
        Syntax.nodeOrTokenStructuralEquals = nodeOrTokenStructuralEquals;

        function tokenStructuralEquals(token1, token2) {
            if (token1 === token2) {
                return true;
            }

            if (token1 === null || token2 === null) {
                return false;
            }

            return token1.kind() === token2.kind() && token1.width() === token2.width() && token1.fullWidth() === token2.fullWidth() && token1.text() === token2.text() && Syntax.triviaListStructuralEquals(token1.leadingTrivia(), token2.leadingTrivia()) && Syntax.triviaListStructuralEquals(token1.trailingTrivia(), token2.trailingTrivia());
        }
        Syntax.tokenStructuralEquals = tokenStructuralEquals;

        function triviaListStructuralEquals(triviaList1, triviaList2) {
            if (triviaList1.count() !== triviaList2.count()) {
                return false;
            }

            for (var i = 0, n = triviaList1.count(); i < n; i++) {
                if (!Syntax.triviaStructuralEquals(triviaList1.syntaxTriviaAt(i), triviaList2.syntaxTriviaAt(i))) {
                    return false;
                }
            }

            return true;
        }
        Syntax.triviaListStructuralEquals = triviaListStructuralEquals;

        function triviaStructuralEquals(trivia1, trivia2) {
            return trivia1.kind() === trivia2.kind() && trivia1.fullWidth() === trivia2.fullWidth() && trivia1.fullText() === trivia2.fullText();
        }
        Syntax.triviaStructuralEquals = triviaStructuralEquals;

        function listStructuralEquals(list1, list2) {
            if (list1.childCount() !== list2.childCount()) {
                return false;
            }

            for (var i = 0, n = list1.childCount(); i < n; i++) {
                var child1 = list1.childAt(i);
                var child2 = list2.childAt(i);

                if (!Syntax.nodeOrTokenStructuralEquals(child1, child2)) {
                    return false;
                }
            }

            return true;
        }
        Syntax.listStructuralEquals = listStructuralEquals;

        function separatedListStructuralEquals(list1, list2) {
            if (list1.childCount() !== list2.childCount()) {
                return false;
            }

            for (var i = 0, n = list1.childCount(); i < n; i++) {
                var element1 = list1.childAt(i);
                var element2 = list2.childAt(i);
                if (!Syntax.nodeOrTokenStructuralEquals(element1, element2)) {
                    return false;
                }
            }

            return true;
        }
        Syntax.separatedListStructuralEquals = separatedListStructuralEquals;

        function elementStructuralEquals(element1, element2) {
            if (element1 === element2) {
                return true;
            }

            if (element1 === null || element2 === null) {
                return false;
            }

            if (element2.kind() !== element2.kind()) {
                return false;
            }

            if (element1.isToken()) {
                return tokenStructuralEquals(element1, element2);
            } else if (element1.isNode()) {
                return nodeStructuralEquals(element1, element2);
            } else if (element1.isList()) {
                return listStructuralEquals(element1, element2);
            } else if (element1.isSeparatedList()) {
                return separatedListStructuralEquals(element1, element2);
            }

            throw TypeScript.Errors.invalidOperation();
        }
        Syntax.elementStructuralEquals = elementStructuralEquals;

        function identifierName(text, info) {
            if (typeof info === "undefined") { info = null; }
            return Syntax.identifier(text);
        }
        Syntax.identifierName = identifierName;

        function trueExpression() {
            return Syntax.token(37 /* TrueKeyword */);
        }
        Syntax.trueExpression = trueExpression;

        function falseExpression() {
            return Syntax.token(24 /* FalseKeyword */);
        }
        Syntax.falseExpression = falseExpression;

        function numericLiteralExpression(text) {
            return Syntax.token(13 /* NumericLiteral */, { text: text });
        }
        Syntax.numericLiteralExpression = numericLiteralExpression;

        function stringLiteralExpression(text) {
            return Syntax.token(14 /* StringLiteral */, { text: text });
        }
        Syntax.stringLiteralExpression = stringLiteralExpression;

        function isSuperInvocationExpression(node) {
            return node.kind() === 213 /* InvocationExpression */ && node.expression.kind() === 50 /* SuperKeyword */;
        }
        Syntax.isSuperInvocationExpression = isSuperInvocationExpression;

        function isSuperInvocationExpressionStatement(node) {
            return node.kind() === 149 /* ExpressionStatement */ && isSuperInvocationExpression(node.expression);
        }
        Syntax.isSuperInvocationExpressionStatement = isSuperInvocationExpressionStatement;

        function isSuperMemberAccessExpression(node) {
            return node.kind() === 212 /* MemberAccessExpression */ && node.expression.kind() === 50 /* SuperKeyword */;
        }
        Syntax.isSuperMemberAccessExpression = isSuperMemberAccessExpression;

        function isSuperMemberAccessInvocationExpression(node) {
            return node.kind() === 213 /* InvocationExpression */ && isSuperMemberAccessExpression(node.expression);
        }
        Syntax.isSuperMemberAccessInvocationExpression = isSuperMemberAccessInvocationExpression;

        function assignmentExpression(left, token, right) {
            return Syntax.normalModeFactory.binaryExpression(174 /* AssignmentExpression */, left, token, right);
        }
        Syntax.assignmentExpression = assignmentExpression;

        function nodeHasSkippedOrMissingTokens(node) {
            for (var i = 0; i < node.childCount(); i++) {
                var child = node.childAt(i);
                if (child !== null && child.isToken()) {
                    var token = child;

                    if (token.hasSkippedToken() || (token.width() === 0 && token.kind() !== 10 /* EndOfFileToken */)) {
                        return true;
                    }
                }
            }
            return false;
        }
        Syntax.nodeHasSkippedOrMissingTokens = nodeHasSkippedOrMissingTokens;

        function isUnterminatedStringLiteral(token) {
            if (token && token.kind() === 14 /* StringLiteral */) {
                var text = token.text();
                return text.length < 2 || text.charCodeAt(text.length - 1) !== text.charCodeAt(0);
            }

            return false;
        }
        Syntax.isUnterminatedStringLiteral = isUnterminatedStringLiteral;

        function isUnterminatedMultilineCommentTrivia(trivia) {
            if (trivia && trivia.kind() === 6 /* MultiLineCommentTrivia */) {
                var text = trivia.fullText();
                return text.length < 4 || text.substring(text.length - 2) !== "*/";
            }
            return false;
        }
        Syntax.isUnterminatedMultilineCommentTrivia = isUnterminatedMultilineCommentTrivia;

        function isEntirelyInsideCommentTrivia(trivia, fullStart, position) {
            if (trivia && trivia.isComment() && position > fullStart) {
                var end = fullStart + trivia.fullWidth();
                if (position < end) {
                    return true;
                } else if (position === end) {
                    return trivia.kind() === 7 /* SingleLineCommentTrivia */ || isUnterminatedMultilineCommentTrivia(trivia);
                }
            }

            return false;
        }
        Syntax.isEntirelyInsideCommentTrivia = isEntirelyInsideCommentTrivia;

        function isEntirelyInsideComment(sourceUnit, position) {
            var positionedToken = sourceUnit.findToken(position);
            var fullStart = positionedToken.fullStart();
            var triviaList = null;
            var lastTriviaBeforeToken = null;

            if (positionedToken.kind() === 10 /* EndOfFileToken */) {
                if (positionedToken.token().hasLeadingTrivia()) {
                    triviaList = positionedToken.token().leadingTrivia();
                } else {
                    positionedToken = positionedToken.previousToken();
                    if (positionedToken) {
                        if (positionedToken && positionedToken.token().hasTrailingTrivia()) {
                            triviaList = positionedToken.token().trailingTrivia();
                            fullStart = positionedToken.end();
                        }
                    }
                }
            } else {
                if (position <= (fullStart + positionedToken.token().leadingTriviaWidth())) {
                    triviaList = positionedToken.token().leadingTrivia();
                } else if (position >= (fullStart + positionedToken.token().width())) {
                    triviaList = positionedToken.token().trailingTrivia();
                    fullStart = positionedToken.end();
                }
            }

            if (triviaList) {
                for (var i = 0, n = triviaList.count(); i < n; i++) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    if (position <= fullStart) {
                        break;
                    } else if (position <= fullStart + trivia.fullWidth() && trivia.isComment()) {
                        lastTriviaBeforeToken = trivia;
                        break;
                    }

                    fullStart += trivia.fullWidth();
                }
            }

            return lastTriviaBeforeToken && isEntirelyInsideCommentTrivia(lastTriviaBeforeToken, fullStart, position);
        }
        Syntax.isEntirelyInsideComment = isEntirelyInsideComment;

        function isEntirelyInStringOrRegularExpressionLiteral(sourceUnit, position) {
            var positionedToken = sourceUnit.findToken(position);

            if (positionedToken) {
                if (positionedToken.kind() === 10 /* EndOfFileToken */) {
                    positionedToken = positionedToken.previousToken();
                    return positionedToken && positionedToken.token().trailingTriviaWidth() === 0 && isUnterminatedStringLiteral(positionedToken.token());
                } else if (position > positionedToken.start()) {
                    return (position < positionedToken.end() && (positionedToken.kind() === 14 /* StringLiteral */ || positionedToken.kind() === 12 /* RegularExpressionLiteral */)) || (position <= positionedToken.end() && isUnterminatedStringLiteral(positionedToken.token()));
                }
            }

            return false;
        }
        Syntax.isEntirelyInStringOrRegularExpressionLiteral = isEntirelyInStringOrRegularExpressionLiteral;

        function findSkippedTokenInTriviaList(positionedToken, position, lookInLeadingTriviaList) {
            var triviaList = null;
            var fullStart;

            if (lookInLeadingTriviaList) {
                triviaList = positionedToken.token().leadingTrivia();
                fullStart = positionedToken.fullStart();
            } else {
                triviaList = positionedToken.token().trailingTrivia();
                fullStart = positionedToken.end();
            }

            if (triviaList && triviaList.hasSkippedToken()) {
                for (var i = 0, n = triviaList.count(); i < n; i++) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    var triviaWidth = trivia.fullWidth();

                    if (trivia.isSkippedToken() && position >= fullStart && position <= fullStart + triviaWidth) {
                        return new TypeScript.PositionedSkippedToken(positionedToken, trivia.skippedToken(), fullStart);
                    }

                    fullStart += triviaWidth;
                }
            }

            return null;
        }

        function findSkippedTokenOnLeftInTriviaList(positionedToken, position, lookInLeadingTriviaList) {
            var triviaList = null;
            var fullEnd;

            if (lookInLeadingTriviaList) {
                triviaList = positionedToken.token().leadingTrivia();
                fullEnd = positionedToken.fullStart() + triviaList.fullWidth();
            } else {
                triviaList = positionedToken.token().trailingTrivia();
                fullEnd = positionedToken.fullEnd();
            }

            if (triviaList && triviaList.hasSkippedToken()) {
                for (var i = triviaList.count() - 1; i >= 0; i--) {
                    var trivia = triviaList.syntaxTriviaAt(i);
                    var triviaWidth = trivia.fullWidth();

                    if (trivia.isSkippedToken() && position >= fullEnd) {
                        return new TypeScript.PositionedSkippedToken(positionedToken, trivia.skippedToken(), fullEnd - triviaWidth);
                    }

                    fullEnd -= triviaWidth;
                }
            }

            return null;
        }

        function findSkippedTokenInLeadingTriviaList(positionedToken, position) {
            return findSkippedTokenInTriviaList(positionedToken, position, true);
        }
        Syntax.findSkippedTokenInLeadingTriviaList = findSkippedTokenInLeadingTriviaList;

        function findSkippedTokenInTrailingTriviaList(positionedToken, position) {
            return findSkippedTokenInTriviaList(positionedToken, position, false);
        }
        Syntax.findSkippedTokenInTrailingTriviaList = findSkippedTokenInTrailingTriviaList;

        function findSkippedTokenInPositionedToken(positionedToken, position) {
            var positionInLeadingTriviaList = (position < positionedToken.start());
            return findSkippedTokenInTriviaList(positionedToken, position, positionInLeadingTriviaList);
        }
        Syntax.findSkippedTokenInPositionedToken = findSkippedTokenInPositionedToken;

        function findSkippedTokenOnLeft(positionedToken, position) {
            var positionInLeadingTriviaList = (position < positionedToken.start());
            return findSkippedTokenOnLeftInTriviaList(positionedToken, position, positionInLeadingTriviaList);
        }
        Syntax.findSkippedTokenOnLeft = findSkippedTokenOnLeft;

        function getAncestorOfKind(positionedToken, kind) {
            while (positionedToken && positionedToken.parent()) {
                if (positionedToken.parent().kind() === kind) {
                    return positionedToken.parent();
                }

                positionedToken = positionedToken.parent();
            }

            return null;
        }
        Syntax.getAncestorOfKind = getAncestorOfKind;

        function hasAncestorOfKind(positionedToken, kind) {
            return Syntax.getAncestorOfKind(positionedToken, kind) !== null;
        }
        Syntax.hasAncestorOfKind = hasAncestorOfKind;

        function isIntegerLiteral(expression) {
            if (expression) {
                switch (expression.kind()) {
                    case 164 /* PlusExpression */:
                    case 165 /* NegateExpression */:
                        expression = expression.operand;
                        return expression.isToken() && TypeScript.IntegerUtilities.isInteger(expression.text());

                    case 13 /* NumericLiteral */:
                        var text = expression.text();
                        return TypeScript.IntegerUtilities.isInteger(text) || TypeScript.IntegerUtilities.isHexInteger(text);
                }
            }

            return false;
        }
        Syntax.isIntegerLiteral = isIntegerLiteral;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var NormalModeFactory = (function () {
            function NormalModeFactory() {
            }
            NormalModeFactory.prototype.sourceUnit = function (moduleElements, endOfFileToken) {
                return new TypeScript.SourceUnitSyntax(moduleElements, endOfFileToken, false);
            };
            NormalModeFactory.prototype.externalModuleReference = function (requireKeyword, openParenToken, stringLiteral, closeParenToken) {
                return new TypeScript.ExternalModuleReferenceSyntax(requireKeyword, openParenToken, stringLiteral, closeParenToken, false);
            };
            NormalModeFactory.prototype.moduleNameModuleReference = function (moduleName) {
                return new TypeScript.ModuleNameModuleReferenceSyntax(moduleName, false);
            };
            NormalModeFactory.prototype.importDeclaration = function (modifiers, importKeyword, identifier, equalsToken, moduleReference, semicolonToken) {
                return new TypeScript.ImportDeclarationSyntax(modifiers, importKeyword, identifier, equalsToken, moduleReference, semicolonToken, false);
            };
            NormalModeFactory.prototype.exportAssignment = function (exportKeyword, equalsToken, identifier, semicolonToken) {
                return new TypeScript.ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, false);
            };
            NormalModeFactory.prototype.classDeclaration = function (modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken) {
                return new TypeScript.ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.interfaceDeclaration = function (modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body) {
                return new TypeScript.InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, false);
            };
            NormalModeFactory.prototype.heritageClause = function (kind, extendsOrImplementsKeyword, typeNames) {
                return new TypeScript.HeritageClauseSyntax(kind, extendsOrImplementsKeyword, typeNames, false);
            };
            NormalModeFactory.prototype.moduleDeclaration = function (modifiers, moduleKeyword, name, stringLiteral, openBraceToken, moduleElements, closeBraceToken) {
                return new TypeScript.ModuleDeclarationSyntax(modifiers, moduleKeyword, name, stringLiteral, openBraceToken, moduleElements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.functionDeclaration = function (modifiers, functionKeyword, identifier, callSignature, block, semicolonToken) {
                return new TypeScript.FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, false);
            };
            NormalModeFactory.prototype.variableStatement = function (modifiers, variableDeclaration, semicolonToken) {
                return new TypeScript.VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, false);
            };
            NormalModeFactory.prototype.variableDeclaration = function (varKeyword, variableDeclarators) {
                return new TypeScript.VariableDeclarationSyntax(varKeyword, variableDeclarators, false);
            };
            NormalModeFactory.prototype.variableDeclarator = function (propertyName, typeAnnotation, equalsValueClause) {
                return new TypeScript.VariableDeclaratorSyntax(propertyName, typeAnnotation, equalsValueClause, false);
            };
            NormalModeFactory.prototype.equalsValueClause = function (equalsToken, value) {
                return new TypeScript.EqualsValueClauseSyntax(equalsToken, value, false);
            };
            NormalModeFactory.prototype.prefixUnaryExpression = function (kind, operatorToken, operand) {
                return new TypeScript.PrefixUnaryExpressionSyntax(kind, operatorToken, operand, false);
            };
            NormalModeFactory.prototype.arrayLiteralExpression = function (openBracketToken, expressions, closeBracketToken) {
                return new TypeScript.ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, false);
            };
            NormalModeFactory.prototype.omittedExpression = function () {
                return new TypeScript.OmittedExpressionSyntax(false);
            };
            NormalModeFactory.prototype.parenthesizedExpression = function (openParenToken, expression, closeParenToken) {
                return new TypeScript.ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, false);
            };
            NormalModeFactory.prototype.simpleArrowFunctionExpression = function (identifier, equalsGreaterThanToken, block, expression) {
                return new TypeScript.SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, block, expression, false);
            };
            NormalModeFactory.prototype.parenthesizedArrowFunctionExpression = function (callSignature, equalsGreaterThanToken, block, expression) {
                return new TypeScript.ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, block, expression, false);
            };
            NormalModeFactory.prototype.qualifiedName = function (left, dotToken, right) {
                return new TypeScript.QualifiedNameSyntax(left, dotToken, right, false);
            };
            NormalModeFactory.prototype.typeArgumentList = function (lessThanToken, typeArguments, greaterThanToken) {
                return new TypeScript.TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, false);
            };
            NormalModeFactory.prototype.constructorType = function (newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, false);
            };
            NormalModeFactory.prototype.functionType = function (typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, false);
            };
            NormalModeFactory.prototype.objectType = function (openBraceToken, typeMembers, closeBraceToken) {
                return new TypeScript.ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, false);
            };
            NormalModeFactory.prototype.arrayType = function (type, openBracketToken, closeBracketToken) {
                return new TypeScript.ArrayTypeSyntax(type, openBracketToken, closeBracketToken, false);
            };
            NormalModeFactory.prototype.genericType = function (name, typeArgumentList) {
                return new TypeScript.GenericTypeSyntax(name, typeArgumentList, false);
            };
            NormalModeFactory.prototype.typeQuery = function (typeOfKeyword, name) {
                return new TypeScript.TypeQuerySyntax(typeOfKeyword, name, false);
            };
            NormalModeFactory.prototype.typeAnnotation = function (colonToken, type) {
                return new TypeScript.TypeAnnotationSyntax(colonToken, type, false);
            };
            NormalModeFactory.prototype.block = function (openBraceToken, statements, closeBraceToken) {
                return new TypeScript.BlockSyntax(openBraceToken, statements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.parameter = function (dotDotDotToken, modifiers, identifier, questionToken, typeAnnotation, equalsValueClause) {
                return new TypeScript.ParameterSyntax(dotDotDotToken, modifiers, identifier, questionToken, typeAnnotation, equalsValueClause, false);
            };
            NormalModeFactory.prototype.memberAccessExpression = function (expression, dotToken, name) {
                return new TypeScript.MemberAccessExpressionSyntax(expression, dotToken, name, false);
            };
            NormalModeFactory.prototype.postfixUnaryExpression = function (kind, operand, operatorToken) {
                return new TypeScript.PostfixUnaryExpressionSyntax(kind, operand, operatorToken, false);
            };
            NormalModeFactory.prototype.elementAccessExpression = function (expression, openBracketToken, argumentExpression, closeBracketToken) {
                return new TypeScript.ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, false);
            };
            NormalModeFactory.prototype.invocationExpression = function (expression, argumentList) {
                return new TypeScript.InvocationExpressionSyntax(expression, argumentList, false);
            };
            NormalModeFactory.prototype.argumentList = function (typeArgumentList, openParenToken, _arguments, closeParenToken) {
                return new TypeScript.ArgumentListSyntax(typeArgumentList, openParenToken, _arguments, closeParenToken, false);
            };
            NormalModeFactory.prototype.binaryExpression = function (kind, left, operatorToken, right) {
                return new TypeScript.BinaryExpressionSyntax(kind, left, operatorToken, right, false);
            };
            NormalModeFactory.prototype.conditionalExpression = function (condition, questionToken, whenTrue, colonToken, whenFalse) {
                return new TypeScript.ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, false);
            };
            NormalModeFactory.prototype.constructSignature = function (newKeyword, callSignature) {
                return new TypeScript.ConstructSignatureSyntax(newKeyword, callSignature, false);
            };
            NormalModeFactory.prototype.methodSignature = function (propertyName, questionToken, callSignature) {
                return new TypeScript.MethodSignatureSyntax(propertyName, questionToken, callSignature, false);
            };
            NormalModeFactory.prototype.indexSignature = function (openBracketToken, parameter, closeBracketToken, typeAnnotation) {
                return new TypeScript.IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, false);
            };
            NormalModeFactory.prototype.propertySignature = function (propertyName, questionToken, typeAnnotation) {
                return new TypeScript.PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, false);
            };
            NormalModeFactory.prototype.callSignature = function (typeParameterList, parameterList, typeAnnotation) {
                return new TypeScript.CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, false);
            };
            NormalModeFactory.prototype.parameterList = function (openParenToken, parameters, closeParenToken) {
                return new TypeScript.ParameterListSyntax(openParenToken, parameters, closeParenToken, false);
            };
            NormalModeFactory.prototype.typeParameterList = function (lessThanToken, typeParameters, greaterThanToken) {
                return new TypeScript.TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, false);
            };
            NormalModeFactory.prototype.typeParameter = function (identifier, constraint) {
                return new TypeScript.TypeParameterSyntax(identifier, constraint, false);
            };
            NormalModeFactory.prototype.constraint = function (extendsKeyword, type) {
                return new TypeScript.ConstraintSyntax(extendsKeyword, type, false);
            };
            NormalModeFactory.prototype.elseClause = function (elseKeyword, statement) {
                return new TypeScript.ElseClauseSyntax(elseKeyword, statement, false);
            };
            NormalModeFactory.prototype.ifStatement = function (ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause) {
                return new TypeScript.IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, false);
            };
            NormalModeFactory.prototype.expressionStatement = function (expression, semicolonToken) {
                return new TypeScript.ExpressionStatementSyntax(expression, semicolonToken, false);
            };
            NormalModeFactory.prototype.constructorDeclaration = function (modifiers, constructorKeyword, callSignature, block, semicolonToken) {
                return new TypeScript.ConstructorDeclarationSyntax(modifiers, constructorKeyword, callSignature, block, semicolonToken, false);
            };
            NormalModeFactory.prototype.memberFunctionDeclaration = function (modifiers, propertyName, callSignature, block, semicolonToken) {
                return new TypeScript.MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, false);
            };
            NormalModeFactory.prototype.getAccessor = function (modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block) {
                return new TypeScript.GetAccessorSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, false);
            };
            NormalModeFactory.prototype.setAccessor = function (modifiers, setKeyword, propertyName, parameterList, block) {
                return new TypeScript.SetAccessorSyntax(modifiers, setKeyword, propertyName, parameterList, block, false);
            };
            NormalModeFactory.prototype.memberVariableDeclaration = function (modifiers, variableDeclarator, semicolonToken) {
                return new TypeScript.MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, false);
            };
            NormalModeFactory.prototype.indexMemberDeclaration = function (modifiers, indexSignature, semicolonToken) {
                return new TypeScript.IndexMemberDeclarationSyntax(modifiers, indexSignature, semicolonToken, false);
            };
            NormalModeFactory.prototype.throwStatement = function (throwKeyword, expression, semicolonToken) {
                return new TypeScript.ThrowStatementSyntax(throwKeyword, expression, semicolonToken, false);
            };
            NormalModeFactory.prototype.returnStatement = function (returnKeyword, expression, semicolonToken) {
                return new TypeScript.ReturnStatementSyntax(returnKeyword, expression, semicolonToken, false);
            };
            NormalModeFactory.prototype.objectCreationExpression = function (newKeyword, expression, argumentList) {
                return new TypeScript.ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, false);
            };
            NormalModeFactory.prototype.switchStatement = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken) {
                return new TypeScript.SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, false);
            };
            NormalModeFactory.prototype.caseSwitchClause = function (caseKeyword, expression, colonToken, statements) {
                return new TypeScript.CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, false);
            };
            NormalModeFactory.prototype.defaultSwitchClause = function (defaultKeyword, colonToken, statements) {
                return new TypeScript.DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, false);
            };
            NormalModeFactory.prototype.breakStatement = function (breakKeyword, identifier, semicolonToken) {
                return new TypeScript.BreakStatementSyntax(breakKeyword, identifier, semicolonToken, false);
            };
            NormalModeFactory.prototype.continueStatement = function (continueKeyword, identifier, semicolonToken) {
                return new TypeScript.ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, false);
            };
            NormalModeFactory.prototype.forStatement = function (forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement) {
                return new TypeScript.ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.forInStatement = function (forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement) {
                return new TypeScript.ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.whileStatement = function (whileKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.withStatement = function (withKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, false);
            };
            NormalModeFactory.prototype.enumDeclaration = function (modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken) {
                return new TypeScript.EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, false);
            };
            NormalModeFactory.prototype.enumElement = function (propertyName, equalsValueClause) {
                return new TypeScript.EnumElementSyntax(propertyName, equalsValueClause, false);
            };
            NormalModeFactory.prototype.castExpression = function (lessThanToken, type, greaterThanToken, expression) {
                return new TypeScript.CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, false);
            };
            NormalModeFactory.prototype.objectLiteralExpression = function (openBraceToken, propertyAssignments, closeBraceToken) {
                return new TypeScript.ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, false);
            };
            NormalModeFactory.prototype.simplePropertyAssignment = function (propertyName, colonToken, expression) {
                return new TypeScript.SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, false);
            };
            NormalModeFactory.prototype.functionPropertyAssignment = function (propertyName, callSignature, block) {
                return new TypeScript.FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, false);
            };
            NormalModeFactory.prototype.functionExpression = function (functionKeyword, identifier, callSignature, block) {
                return new TypeScript.FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, false);
            };
            NormalModeFactory.prototype.emptyStatement = function (semicolonToken) {
                return new TypeScript.EmptyStatementSyntax(semicolonToken, false);
            };
            NormalModeFactory.prototype.tryStatement = function (tryKeyword, block, catchClause, finallyClause) {
                return new TypeScript.TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, false);
            };
            NormalModeFactory.prototype.catchClause = function (catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block) {
                return new TypeScript.CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, false);
            };
            NormalModeFactory.prototype.finallyClause = function (finallyKeyword, block) {
                return new TypeScript.FinallyClauseSyntax(finallyKeyword, block, false);
            };
            NormalModeFactory.prototype.labeledStatement = function (identifier, colonToken, statement) {
                return new TypeScript.LabeledStatementSyntax(identifier, colonToken, statement, false);
            };
            NormalModeFactory.prototype.doStatement = function (doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken) {
                return new TypeScript.DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, false);
            };
            NormalModeFactory.prototype.typeOfExpression = function (typeOfKeyword, expression) {
                return new TypeScript.TypeOfExpressionSyntax(typeOfKeyword, expression, false);
            };
            NormalModeFactory.prototype.deleteExpression = function (deleteKeyword, expression) {
                return new TypeScript.DeleteExpressionSyntax(deleteKeyword, expression, false);
            };
            NormalModeFactory.prototype.voidExpression = function (voidKeyword, expression) {
                return new TypeScript.VoidExpressionSyntax(voidKeyword, expression, false);
            };
            NormalModeFactory.prototype.debuggerStatement = function (debuggerKeyword, semicolonToken) {
                return new TypeScript.DebuggerStatementSyntax(debuggerKeyword, semicolonToken, false);
            };
            return NormalModeFactory;
        })();
        Syntax.NormalModeFactory = NormalModeFactory;

        var StrictModeFactory = (function () {
            function StrictModeFactory() {
            }
            StrictModeFactory.prototype.sourceUnit = function (moduleElements, endOfFileToken) {
                return new TypeScript.SourceUnitSyntax(moduleElements, endOfFileToken, true);
            };
            StrictModeFactory.prototype.externalModuleReference = function (requireKeyword, openParenToken, stringLiteral, closeParenToken) {
                return new TypeScript.ExternalModuleReferenceSyntax(requireKeyword, openParenToken, stringLiteral, closeParenToken, true);
            };
            StrictModeFactory.prototype.moduleNameModuleReference = function (moduleName) {
                return new TypeScript.ModuleNameModuleReferenceSyntax(moduleName, true);
            };
            StrictModeFactory.prototype.importDeclaration = function (modifiers, importKeyword, identifier, equalsToken, moduleReference, semicolonToken) {
                return new TypeScript.ImportDeclarationSyntax(modifiers, importKeyword, identifier, equalsToken, moduleReference, semicolonToken, true);
            };
            StrictModeFactory.prototype.exportAssignment = function (exportKeyword, equalsToken, identifier, semicolonToken) {
                return new TypeScript.ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, true);
            };
            StrictModeFactory.prototype.classDeclaration = function (modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken) {
                return new TypeScript.ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.interfaceDeclaration = function (modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body) {
                return new TypeScript.InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, true);
            };
            StrictModeFactory.prototype.heritageClause = function (kind, extendsOrImplementsKeyword, typeNames) {
                return new TypeScript.HeritageClauseSyntax(kind, extendsOrImplementsKeyword, typeNames, true);
            };
            StrictModeFactory.prototype.moduleDeclaration = function (modifiers, moduleKeyword, name, stringLiteral, openBraceToken, moduleElements, closeBraceToken) {
                return new TypeScript.ModuleDeclarationSyntax(modifiers, moduleKeyword, name, stringLiteral, openBraceToken, moduleElements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.functionDeclaration = function (modifiers, functionKeyword, identifier, callSignature, block, semicolonToken) {
                return new TypeScript.FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, true);
            };
            StrictModeFactory.prototype.variableStatement = function (modifiers, variableDeclaration, semicolonToken) {
                return new TypeScript.VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, true);
            };
            StrictModeFactory.prototype.variableDeclaration = function (varKeyword, variableDeclarators) {
                return new TypeScript.VariableDeclarationSyntax(varKeyword, variableDeclarators, true);
            };
            StrictModeFactory.prototype.variableDeclarator = function (propertyName, typeAnnotation, equalsValueClause) {
                return new TypeScript.VariableDeclaratorSyntax(propertyName, typeAnnotation, equalsValueClause, true);
            };
            StrictModeFactory.prototype.equalsValueClause = function (equalsToken, value) {
                return new TypeScript.EqualsValueClauseSyntax(equalsToken, value, true);
            };
            StrictModeFactory.prototype.prefixUnaryExpression = function (kind, operatorToken, operand) {
                return new TypeScript.PrefixUnaryExpressionSyntax(kind, operatorToken, operand, true);
            };
            StrictModeFactory.prototype.arrayLiteralExpression = function (openBracketToken, expressions, closeBracketToken) {
                return new TypeScript.ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, true);
            };
            StrictModeFactory.prototype.omittedExpression = function () {
                return new TypeScript.OmittedExpressionSyntax(true);
            };
            StrictModeFactory.prototype.parenthesizedExpression = function (openParenToken, expression, closeParenToken) {
                return new TypeScript.ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, true);
            };
            StrictModeFactory.prototype.simpleArrowFunctionExpression = function (identifier, equalsGreaterThanToken, block, expression) {
                return new TypeScript.SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, block, expression, true);
            };
            StrictModeFactory.prototype.parenthesizedArrowFunctionExpression = function (callSignature, equalsGreaterThanToken, block, expression) {
                return new TypeScript.ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, block, expression, true);
            };
            StrictModeFactory.prototype.qualifiedName = function (left, dotToken, right) {
                return new TypeScript.QualifiedNameSyntax(left, dotToken, right, true);
            };
            StrictModeFactory.prototype.typeArgumentList = function (lessThanToken, typeArguments, greaterThanToken) {
                return new TypeScript.TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, true);
            };
            StrictModeFactory.prototype.constructorType = function (newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, true);
            };
            StrictModeFactory.prototype.functionType = function (typeParameterList, parameterList, equalsGreaterThanToken, type) {
                return new TypeScript.FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, true);
            };
            StrictModeFactory.prototype.objectType = function (openBraceToken, typeMembers, closeBraceToken) {
                return new TypeScript.ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, true);
            };
            StrictModeFactory.prototype.arrayType = function (type, openBracketToken, closeBracketToken) {
                return new TypeScript.ArrayTypeSyntax(type, openBracketToken, closeBracketToken, true);
            };
            StrictModeFactory.prototype.genericType = function (name, typeArgumentList) {
                return new TypeScript.GenericTypeSyntax(name, typeArgumentList, true);
            };
            StrictModeFactory.prototype.typeQuery = function (typeOfKeyword, name) {
                return new TypeScript.TypeQuerySyntax(typeOfKeyword, name, true);
            };
            StrictModeFactory.prototype.typeAnnotation = function (colonToken, type) {
                return new TypeScript.TypeAnnotationSyntax(colonToken, type, true);
            };
            StrictModeFactory.prototype.block = function (openBraceToken, statements, closeBraceToken) {
                return new TypeScript.BlockSyntax(openBraceToken, statements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.parameter = function (dotDotDotToken, modifiers, identifier, questionToken, typeAnnotation, equalsValueClause) {
                return new TypeScript.ParameterSyntax(dotDotDotToken, modifiers, identifier, questionToken, typeAnnotation, equalsValueClause, true);
            };
            StrictModeFactory.prototype.memberAccessExpression = function (expression, dotToken, name) {
                return new TypeScript.MemberAccessExpressionSyntax(expression, dotToken, name, true);
            };
            StrictModeFactory.prototype.postfixUnaryExpression = function (kind, operand, operatorToken) {
                return new TypeScript.PostfixUnaryExpressionSyntax(kind, operand, operatorToken, true);
            };
            StrictModeFactory.prototype.elementAccessExpression = function (expression, openBracketToken, argumentExpression, closeBracketToken) {
                return new TypeScript.ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, true);
            };
            StrictModeFactory.prototype.invocationExpression = function (expression, argumentList) {
                return new TypeScript.InvocationExpressionSyntax(expression, argumentList, true);
            };
            StrictModeFactory.prototype.argumentList = function (typeArgumentList, openParenToken, _arguments, closeParenToken) {
                return new TypeScript.ArgumentListSyntax(typeArgumentList, openParenToken, _arguments, closeParenToken, true);
            };
            StrictModeFactory.prototype.binaryExpression = function (kind, left, operatorToken, right) {
                return new TypeScript.BinaryExpressionSyntax(kind, left, operatorToken, right, true);
            };
            StrictModeFactory.prototype.conditionalExpression = function (condition, questionToken, whenTrue, colonToken, whenFalse) {
                return new TypeScript.ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, true);
            };
            StrictModeFactory.prototype.constructSignature = function (newKeyword, callSignature) {
                return new TypeScript.ConstructSignatureSyntax(newKeyword, callSignature, true);
            };
            StrictModeFactory.prototype.methodSignature = function (propertyName, questionToken, callSignature) {
                return new TypeScript.MethodSignatureSyntax(propertyName, questionToken, callSignature, true);
            };
            StrictModeFactory.prototype.indexSignature = function (openBracketToken, parameter, closeBracketToken, typeAnnotation) {
                return new TypeScript.IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, true);
            };
            StrictModeFactory.prototype.propertySignature = function (propertyName, questionToken, typeAnnotation) {
                return new TypeScript.PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, true);
            };
            StrictModeFactory.prototype.callSignature = function (typeParameterList, parameterList, typeAnnotation) {
                return new TypeScript.CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, true);
            };
            StrictModeFactory.prototype.parameterList = function (openParenToken, parameters, closeParenToken) {
                return new TypeScript.ParameterListSyntax(openParenToken, parameters, closeParenToken, true);
            };
            StrictModeFactory.prototype.typeParameterList = function (lessThanToken, typeParameters, greaterThanToken) {
                return new TypeScript.TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, true);
            };
            StrictModeFactory.prototype.typeParameter = function (identifier, constraint) {
                return new TypeScript.TypeParameterSyntax(identifier, constraint, true);
            };
            StrictModeFactory.prototype.constraint = function (extendsKeyword, type) {
                return new TypeScript.ConstraintSyntax(extendsKeyword, type, true);
            };
            StrictModeFactory.prototype.elseClause = function (elseKeyword, statement) {
                return new TypeScript.ElseClauseSyntax(elseKeyword, statement, true);
            };
            StrictModeFactory.prototype.ifStatement = function (ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause) {
                return new TypeScript.IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, true);
            };
            StrictModeFactory.prototype.expressionStatement = function (expression, semicolonToken) {
                return new TypeScript.ExpressionStatementSyntax(expression, semicolonToken, true);
            };
            StrictModeFactory.prototype.constructorDeclaration = function (modifiers, constructorKeyword, callSignature, block, semicolonToken) {
                return new TypeScript.ConstructorDeclarationSyntax(modifiers, constructorKeyword, callSignature, block, semicolonToken, true);
            };
            StrictModeFactory.prototype.memberFunctionDeclaration = function (modifiers, propertyName, callSignature, block, semicolonToken) {
                return new TypeScript.MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, true);
            };
            StrictModeFactory.prototype.getAccessor = function (modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block) {
                return new TypeScript.GetAccessorSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, true);
            };
            StrictModeFactory.prototype.setAccessor = function (modifiers, setKeyword, propertyName, parameterList, block) {
                return new TypeScript.SetAccessorSyntax(modifiers, setKeyword, propertyName, parameterList, block, true);
            };
            StrictModeFactory.prototype.memberVariableDeclaration = function (modifiers, variableDeclarator, semicolonToken) {
                return new TypeScript.MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, true);
            };
            StrictModeFactory.prototype.indexMemberDeclaration = function (modifiers, indexSignature, semicolonToken) {
                return new TypeScript.IndexMemberDeclarationSyntax(modifiers, indexSignature, semicolonToken, true);
            };
            StrictModeFactory.prototype.throwStatement = function (throwKeyword, expression, semicolonToken) {
                return new TypeScript.ThrowStatementSyntax(throwKeyword, expression, semicolonToken, true);
            };
            StrictModeFactory.prototype.returnStatement = function (returnKeyword, expression, semicolonToken) {
                return new TypeScript.ReturnStatementSyntax(returnKeyword, expression, semicolonToken, true);
            };
            StrictModeFactory.prototype.objectCreationExpression = function (newKeyword, expression, argumentList) {
                return new TypeScript.ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, true);
            };
            StrictModeFactory.prototype.switchStatement = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken) {
                return new TypeScript.SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, true);
            };
            StrictModeFactory.prototype.caseSwitchClause = function (caseKeyword, expression, colonToken, statements) {
                return new TypeScript.CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, true);
            };
            StrictModeFactory.prototype.defaultSwitchClause = function (defaultKeyword, colonToken, statements) {
                return new TypeScript.DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, true);
            };
            StrictModeFactory.prototype.breakStatement = function (breakKeyword, identifier, semicolonToken) {
                return new TypeScript.BreakStatementSyntax(breakKeyword, identifier, semicolonToken, true);
            };
            StrictModeFactory.prototype.continueStatement = function (continueKeyword, identifier, semicolonToken) {
                return new TypeScript.ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, true);
            };
            StrictModeFactory.prototype.forStatement = function (forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement) {
                return new TypeScript.ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.forInStatement = function (forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement) {
                return new TypeScript.ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.whileStatement = function (whileKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.withStatement = function (withKeyword, openParenToken, condition, closeParenToken, statement) {
                return new TypeScript.WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, true);
            };
            StrictModeFactory.prototype.enumDeclaration = function (modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken) {
                return new TypeScript.EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, true);
            };
            StrictModeFactory.prototype.enumElement = function (propertyName, equalsValueClause) {
                return new TypeScript.EnumElementSyntax(propertyName, equalsValueClause, true);
            };
            StrictModeFactory.prototype.castExpression = function (lessThanToken, type, greaterThanToken, expression) {
                return new TypeScript.CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, true);
            };
            StrictModeFactory.prototype.objectLiteralExpression = function (openBraceToken, propertyAssignments, closeBraceToken) {
                return new TypeScript.ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, true);
            };
            StrictModeFactory.prototype.simplePropertyAssignment = function (propertyName, colonToken, expression) {
                return new TypeScript.SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, true);
            };
            StrictModeFactory.prototype.functionPropertyAssignment = function (propertyName, callSignature, block) {
                return new TypeScript.FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, true);
            };
            StrictModeFactory.prototype.functionExpression = function (functionKeyword, identifier, callSignature, block) {
                return new TypeScript.FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, true);
            };
            StrictModeFactory.prototype.emptyStatement = function (semicolonToken) {
                return new TypeScript.EmptyStatementSyntax(semicolonToken, true);
            };
            StrictModeFactory.prototype.tryStatement = function (tryKeyword, block, catchClause, finallyClause) {
                return new TypeScript.TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, true);
            };
            StrictModeFactory.prototype.catchClause = function (catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block) {
                return new TypeScript.CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, true);
            };
            StrictModeFactory.prototype.finallyClause = function (finallyKeyword, block) {
                return new TypeScript.FinallyClauseSyntax(finallyKeyword, block, true);
            };
            StrictModeFactory.prototype.labeledStatement = function (identifier, colonToken, statement) {
                return new TypeScript.LabeledStatementSyntax(identifier, colonToken, statement, true);
            };
            StrictModeFactory.prototype.doStatement = function (doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken) {
                return new TypeScript.DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, true);
            };
            StrictModeFactory.prototype.typeOfExpression = function (typeOfKeyword, expression) {
                return new TypeScript.TypeOfExpressionSyntax(typeOfKeyword, expression, true);
            };
            StrictModeFactory.prototype.deleteExpression = function (deleteKeyword, expression) {
                return new TypeScript.DeleteExpressionSyntax(deleteKeyword, expression, true);
            };
            StrictModeFactory.prototype.voidExpression = function (voidKeyword, expression) {
                return new TypeScript.VoidExpressionSyntax(voidKeyword, expression, true);
            };
            StrictModeFactory.prototype.debuggerStatement = function (debuggerKeyword, semicolonToken) {
                return new TypeScript.DebuggerStatementSyntax(debuggerKeyword, semicolonToken, true);
            };
            return StrictModeFactory;
        })();
        Syntax.StrictModeFactory = StrictModeFactory;

        Syntax.normalModeFactory = new NormalModeFactory();
        Syntax.strictModeFactory = new StrictModeFactory();
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (SyntaxFacts) {
        function isDirectivePrologueElement(node) {
            if (node.kind() === 149 /* ExpressionStatement */) {
                var expressionStatement = node;
                var expression = expressionStatement.expression;

                if (expression.kind() === 14 /* StringLiteral */) {
                    return true;
                }
            }

            return false;
        }
        SyntaxFacts.isDirectivePrologueElement = isDirectivePrologueElement;

        function isUseStrictDirective(node) {
            var expressionStatement = node;
            var stringLiteral = expressionStatement.expression;

            var text = stringLiteral.text();
            return text === '"use strict"' || text === "'use strict'";
        }
        SyntaxFacts.isUseStrictDirective = isUseStrictDirective;

        function isIdentifierNameOrAnyKeyword(token) {
            var tokenKind = token.tokenKind;
            return tokenKind === 11 /* IdentifierName */ || SyntaxFacts.isAnyKeyword(tokenKind);
        }
        SyntaxFacts.isIdentifierNameOrAnyKeyword = isIdentifierNameOrAnyKeyword;
    })(TypeScript.SyntaxFacts || (TypeScript.SyntaxFacts = {}));
    var SyntaxFacts = TypeScript.SyntaxFacts;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var EmptySyntaxList = (function () {
            function EmptySyntaxList() {
            }
            EmptySyntaxList.prototype.kind = function () {
                return 1 /* List */;
            };

            EmptySyntaxList.prototype.isNode = function () {
                return false;
            };
            EmptySyntaxList.prototype.isToken = function () {
                return false;
            };
            EmptySyntaxList.prototype.isList = function () {
                return true;
            };
            EmptySyntaxList.prototype.isSeparatedList = function () {
                return false;
            };

            EmptySyntaxList.prototype.toJSON = function (key) {
                return [];
            };

            EmptySyntaxList.prototype.childCount = function () {
                return 0;
            };

            EmptySyntaxList.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptySyntaxList.prototype.toArray = function () {
                return [];
            };

            EmptySyntaxList.prototype.collectTextElements = function (elements) {
            };

            EmptySyntaxList.prototype.firstToken = function () {
                return null;
            };

            EmptySyntaxList.prototype.lastToken = function () {
                return null;
            };

            EmptySyntaxList.prototype.fullWidth = function () {
                return 0;
            };

            EmptySyntaxList.prototype.width = function () {
                return 0;
            };

            EmptySyntaxList.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            EmptySyntaxList.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            EmptySyntaxList.prototype.leadingTriviaWidth = function () {
                return 0;
            };

            EmptySyntaxList.prototype.trailingTriviaWidth = function () {
                return 0;
            };

            EmptySyntaxList.prototype.fullText = function () {
                return "";
            };

            EmptySyntaxList.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            EmptySyntaxList.prototype.isIncrementallyUnusable = function () {
                return false;
            };

            EmptySyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                throw TypeScript.Errors.invalidOperation();
            };

            EmptySyntaxList.prototype.insertChildrenInto = function (array, index) {
            };
            return EmptySyntaxList;
        })();
        Syntax.EmptySyntaxList = EmptySyntaxList;

        Syntax.emptyList = new EmptySyntaxList();

        var SingletonSyntaxList = (function () {
            function SingletonSyntaxList(item) {
                this.item = item;
            }
            SingletonSyntaxList.prototype.kind = function () {
                return 1 /* List */;
            };

            SingletonSyntaxList.prototype.isToken = function () {
                return false;
            };
            SingletonSyntaxList.prototype.isNode = function () {
                return false;
            };
            SingletonSyntaxList.prototype.isList = function () {
                return true;
            };
            SingletonSyntaxList.prototype.isSeparatedList = function () {
                return false;
            };

            SingletonSyntaxList.prototype.toJSON = function (key) {
                return [this.item];
            };

            SingletonSyntaxList.prototype.childCount = function () {
                return 1;
            };

            SingletonSyntaxList.prototype.childAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSyntaxList.prototype.toArray = function () {
                return [this.item];
            };

            SingletonSyntaxList.prototype.collectTextElements = function (elements) {
                this.item.collectTextElements(elements);
            };

            SingletonSyntaxList.prototype.firstToken = function () {
                return this.item.firstToken();
            };

            SingletonSyntaxList.prototype.lastToken = function () {
                return this.item.lastToken();
            };

            SingletonSyntaxList.prototype.fullWidth = function () {
                return this.item.fullWidth();
            };

            SingletonSyntaxList.prototype.width = function () {
                return this.item.width();
            };

            SingletonSyntaxList.prototype.leadingTrivia = function () {
                return this.item.leadingTrivia();
            };

            SingletonSyntaxList.prototype.trailingTrivia = function () {
                return this.item.trailingTrivia();
            };

            SingletonSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.item.leadingTriviaWidth();
            };

            SingletonSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.item.trailingTriviaWidth();
            };

            SingletonSyntaxList.prototype.fullText = function () {
                return this.item.fullText();
            };

            SingletonSyntaxList.prototype.isTypeScriptSpecific = function () {
                return this.item.isTypeScriptSpecific();
            };

            SingletonSyntaxList.prototype.isIncrementallyUnusable = function () {
                return this.item.isIncrementallyUnusable();
            };

            SingletonSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                return this.item.findTokenInternal(new TypeScript.PositionedList(parent, this, fullStart), position, fullStart);
            };

            SingletonSyntaxList.prototype.insertChildrenInto = function (array, index) {
                array.splice(index, 0, this.item);
            };
            return SingletonSyntaxList;
        })();

        var NormalSyntaxList = (function () {
            function NormalSyntaxList(nodeOrTokens) {
                this._data = 0;
                this.nodeOrTokens = nodeOrTokens;
            }
            NormalSyntaxList.prototype.kind = function () {
                return 1 /* List */;
            };

            NormalSyntaxList.prototype.isNode = function () {
                return false;
            };
            NormalSyntaxList.prototype.isToken = function () {
                return false;
            };
            NormalSyntaxList.prototype.isList = function () {
                return true;
            };
            NormalSyntaxList.prototype.isSeparatedList = function () {
                return false;
            };

            NormalSyntaxList.prototype.toJSON = function (key) {
                return this.nodeOrTokens;
            };

            NormalSyntaxList.prototype.childCount = function () {
                return this.nodeOrTokens.length;
            };

            NormalSyntaxList.prototype.childAt = function (index) {
                if (index < 0 || index >= this.nodeOrTokens.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.nodeOrTokens[index];
            };

            NormalSyntaxList.prototype.toArray = function () {
                return this.nodeOrTokens.slice(0);
            };

            NormalSyntaxList.prototype.collectTextElements = function (elements) {
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var element = this.nodeOrTokens[i];
                    element.collectTextElements(elements);
                }
            };

            NormalSyntaxList.prototype.firstToken = function () {
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var token = this.nodeOrTokens[i].firstToken();
                    if (token !== null) {
                        return token;
                    }
                }

                return null;
            };

            NormalSyntaxList.prototype.lastToken = function () {
                for (var i = this.nodeOrTokens.length - 1; i >= 0; i--) {
                    var token = this.nodeOrTokens[i].lastToken();
                    if (token !== null) {
                        return token;
                    }
                }

                return null;
            };

            NormalSyntaxList.prototype.fullText = function () {
                var elements = new Array();
                this.collectTextElements(elements);
                return elements.join("");
            };

            NormalSyntaxList.prototype.isTypeScriptSpecific = function () {
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    if (this.nodeOrTokens[i].isTypeScriptSpecific()) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxList.prototype.isIncrementallyUnusable = function () {
                return (this.data() & 2 /* NodeIncrementallyUnusableMask */) !== 0;
            };

            NormalSyntaxList.prototype.fullWidth = function () {
                return this.data() >>> 3 /* NodeFullWidthShift */;
            };

            NormalSyntaxList.prototype.width = function () {
                var fullWidth = this.fullWidth();
                return fullWidth - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            NormalSyntaxList.prototype.leadingTrivia = function () {
                return this.firstToken().leadingTrivia();
            };

            NormalSyntaxList.prototype.trailingTrivia = function () {
                return this.lastToken().trailingTrivia();
            };

            NormalSyntaxList.prototype.leadingTriviaWidth = function () {
                return this.firstToken().leadingTriviaWidth();
            };

            NormalSyntaxList.prototype.trailingTriviaWidth = function () {
                return this.lastToken().trailingTriviaWidth();
            };

            NormalSyntaxList.prototype.computeData = function () {
                var fullWidth = 0;
                var isIncrementallyUnusable = false;

                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var node = this.nodeOrTokens[i];
                    fullWidth += node.fullWidth();
                    isIncrementallyUnusable = isIncrementallyUnusable || node.isIncrementallyUnusable();
                }

                return (fullWidth << 3 /* NodeFullWidthShift */) | (isIncrementallyUnusable ? 2 /* NodeIncrementallyUnusableMask */ : 0) | 1 /* NodeDataComputed */;
            };

            NormalSyntaxList.prototype.data = function () {
                if ((this._data & 1 /* NodeDataComputed */) === 0) {
                    this._data = this.computeData();
                }

                return this._data;
            };

            NormalSyntaxList.prototype.findTokenInternal = function (parent, position, fullStart) {
                parent = new TypeScript.PositionedList(parent, this, fullStart);
                for (var i = 0, n = this.nodeOrTokens.length; i < n; i++) {
                    var nodeOrToken = this.nodeOrTokens[i];

                    var childWidth = nodeOrToken.fullWidth();
                    if (position < childWidth) {
                        return nodeOrToken.findTokenInternal(parent, position, fullStart);
                    }

                    position -= childWidth;
                    fullStart += childWidth;
                }

                throw TypeScript.Errors.invalidOperation();
            };

            NormalSyntaxList.prototype.insertChildrenInto = function (array, index) {
                if (index === 0) {
                    array.unshift.apply(array, this.nodeOrTokens);
                } else {
                    array.splice.apply(array, [index, 0].concat(this.nodeOrTokens));
                }
            };
            return NormalSyntaxList;
        })();

        function list(nodes) {
            if (nodes === undefined || nodes === null || nodes.length === 0) {
                return Syntax.emptyList;
            }

            if (nodes.length === 1) {
                var item = nodes[0];
                return new SingletonSyntaxList(item);
            }

            return new NormalSyntaxList(nodes);
        }
        Syntax.list = list;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxNode = (function () {
        function SyntaxNode(parsedInStrictMode) {
            this._data = parsedInStrictMode ? 4 /* NodeParsedInStrictModeMask */ : 0;
        }
        SyntaxNode.prototype.isNode = function () {
            return true;
        };
        SyntaxNode.prototype.isToken = function () {
            return false;
        };
        SyntaxNode.prototype.isList = function () {
            return false;
        };
        SyntaxNode.prototype.isSeparatedList = function () {
            return false;
        };

        SyntaxNode.prototype.kind = function () {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.childCount = function () {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.childAt = function (slot) {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.firstToken = function () {
            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    if (element.fullWidth() > 0 || element.kind() === 10 /* EndOfFileToken */) {
                        return element.firstToken();
                    }
                }
            }

            return null;
        };

        SyntaxNode.prototype.lastToken = function () {
            for (var i = this.childCount() - 1; i >= 0; i--) {
                var element = this.childAt(i);

                if (element !== null) {
                    if (element.fullWidth() > 0 || element.kind() === 10 /* EndOfFileToken */) {
                        return element.lastToken();
                    }
                }
            }

            return null;
        };

        SyntaxNode.prototype.insertChildrenInto = function (array, index) {
            for (var i = this.childCount() - 1; i >= 0; i--) {
                var element = this.childAt(i);

                if (element !== null) {
                    if (element.isNode() || element.isToken()) {
                        array.splice(index, 0, element);
                    } else if (element.isList()) {
                        element.insertChildrenInto(array, index);
                    } else if (element.isSeparatedList()) {
                        element.insertChildrenInto(array, index);
                    } else {
                        throw TypeScript.Errors.invalidOperation();
                    }
                }
            }
        };

        SyntaxNode.prototype.leadingTrivia = function () {
            var firstToken = this.firstToken();
            return firstToken ? firstToken.leadingTrivia() : TypeScript.Syntax.emptyTriviaList;
        };

        SyntaxNode.prototype.trailingTrivia = function () {
            var lastToken = this.lastToken();
            return lastToken ? lastToken.trailingTrivia() : TypeScript.Syntax.emptyTriviaList;
        };

        SyntaxNode.prototype.toJSON = function (key) {
            var result = {
                kind: TypeScript.SyntaxKind[this.kind()],
                fullWidth: this.fullWidth()
            };

            if (this.isIncrementallyUnusable()) {
                result.isIncrementallyUnusable = true;
            }

            if (this.parsedInStrictMode()) {
                result.parsedInStrictMode = true;
            }

            var thisAsIndexable = this;
            for (var i = 0, n = this.childCount(); i < n; i++) {
                var value = this.childAt(i);

                if (value) {
                    for (var name in this) {
                        if (value === thisAsIndexable[name]) {
                            result[name] = value;
                            break;
                        }
                    }
                }
            }

            return result;
        };

        SyntaxNode.prototype.accept = function (visitor) {
            throw TypeScript.Errors.abstract();
        };

        SyntaxNode.prototype.fullText = function () {
            var elements = [];
            this.collectTextElements(elements);
            return elements.join("");
        };

        SyntaxNode.prototype.collectTextElements = function (elements) {
            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    element.collectTextElements(elements);
                }
            }
        };

        SyntaxNode.prototype.replaceToken = function (token1, token2) {
            if (token1 === token2) {
                return this;
            }

            return this.accept(new TypeScript.SyntaxTokenReplacer(token1, token2));
        };

        SyntaxNode.prototype.withLeadingTrivia = function (trivia) {
            return this.replaceToken(this.firstToken(), this.firstToken().withLeadingTrivia(trivia));
        };

        SyntaxNode.prototype.withTrailingTrivia = function (trivia) {
            return this.replaceToken(this.lastToken(), this.lastToken().withTrailingTrivia(trivia));
        };

        SyntaxNode.prototype.hasLeadingTrivia = function () {
            return this.lastToken().hasLeadingTrivia();
        };

        SyntaxNode.prototype.hasTrailingTrivia = function () {
            return this.lastToken().hasTrailingTrivia();
        };

        SyntaxNode.prototype.isTypeScriptSpecific = function () {
            return false;
        };

        SyntaxNode.prototype.isIncrementallyUnusable = function () {
            return (this.data() & 2 /* NodeIncrementallyUnusableMask */) !== 0;
        };

        SyntaxNode.prototype.parsedInStrictMode = function () {
            return (this.data() & 4 /* NodeParsedInStrictModeMask */) !== 0;
        };

        SyntaxNode.prototype.fullWidth = function () {
            return this.data() >>> 3 /* NodeFullWidthShift */;
        };

        SyntaxNode.prototype.computeData = function () {
            var slotCount = this.childCount();

            var fullWidth = 0;
            var childWidth = 0;

            var isIncrementallyUnusable = ((this._data & 2 /* NodeIncrementallyUnusableMask */) !== 0) || slotCount === 0;

            for (var i = 0, n = slotCount; i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    childWidth = element.fullWidth();
                    fullWidth += childWidth;

                    if (!isIncrementallyUnusable) {
                        isIncrementallyUnusable = element.isIncrementallyUnusable();
                    }
                }
            }

            return (fullWidth << 3 /* NodeFullWidthShift */) | (isIncrementallyUnusable ? 2 /* NodeIncrementallyUnusableMask */ : 0) | 1 /* NodeDataComputed */;
        };

        SyntaxNode.prototype.data = function () {
            if ((this._data & 1 /* NodeDataComputed */) === 0) {
                this._data |= this.computeData();
            }

            return this._data;
        };

        SyntaxNode.prototype.findToken = function (position, includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var endOfFileToken = this.tryGetEndOfFileAt(position);
            if (endOfFileToken !== null) {
                return endOfFileToken;
            }

            if (position < 0 || position >= this.fullWidth()) {
                throw TypeScript.Errors.argumentOutOfRange("position");
            }

            var positionedToken = this.findTokenInternal(null, position, 0);

            if (includeSkippedTokens) {
                return TypeScript.Syntax.findSkippedTokenInPositionedToken(positionedToken, position) || positionedToken;
            }

            return positionedToken;
        };

        SyntaxNode.prototype.tryGetEndOfFileAt = function (position) {
            if (this.kind() === 120 /* SourceUnit */ && position === this.fullWidth()) {
                var sourceUnit = this;
                return new TypeScript.PositionedToken(new TypeScript.PositionedNode(null, sourceUnit, 0), sourceUnit.endOfFileToken, sourceUnit.moduleElements.fullWidth());
            }

            return null;
        };

        SyntaxNode.prototype.findTokenInternal = function (parent, position, fullStart) {
            parent = new TypeScript.PositionedNode(parent, this, fullStart);
            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element = this.childAt(i);

                if (element !== null) {
                    var childWidth = element.fullWidth();

                    if (position < childWidth) {
                        return element.findTokenInternal(parent, position, fullStart);
                    }

                    position -= childWidth;
                    fullStart += childWidth;
                }
            }

            throw TypeScript.Errors.invalidOperation();
        };

        SyntaxNode.prototype.findTokenOnLeft = function (position, includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var positionedToken = this.findToken(position, false);
            var start = positionedToken.start();

            if (includeSkippedTokens) {
                positionedToken = TypeScript.Syntax.findSkippedTokenOnLeft(positionedToken, position) || positionedToken;
            }

            if (position > start) {
                return positionedToken;
            }

            if (positionedToken.fullStart() === 0) {
                return null;
            }

            return positionedToken.previousToken(includeSkippedTokens);
        };

        SyntaxNode.prototype.findCompleteTokenOnLeft = function (position, includeSkippedTokens) {
            if (typeof includeSkippedTokens === "undefined") { includeSkippedTokens = false; }
            var positionedToken = this.findToken(position, false);

            if (includeSkippedTokens) {
                positionedToken = TypeScript.Syntax.findSkippedTokenOnLeft(positionedToken, position) || positionedToken;
            }

            if (positionedToken.token().width() > 0 && position >= positionedToken.end()) {
                return positionedToken;
            }

            return positionedToken.previousToken(includeSkippedTokens);
        };

        SyntaxNode.prototype.isModuleElement = function () {
            return false;
        };

        SyntaxNode.prototype.isClassElement = function () {
            return false;
        };

        SyntaxNode.prototype.isTypeMember = function () {
            return false;
        };

        SyntaxNode.prototype.isStatement = function () {
            return false;
        };

        SyntaxNode.prototype.isExpression = function () {
            return false;
        };

        SyntaxNode.prototype.isSwitchClause = function () {
            return false;
        };

        SyntaxNode.prototype.structuralEquals = function (node) {
            if (this === node) {
                return true;
            }
            if (node === null) {
                return false;
            }
            if (this.kind() !== node.kind()) {
                return false;
            }

            for (var i = 0, n = this.childCount(); i < n; i++) {
                var element1 = this.childAt(i);
                var element2 = node.childAt(i);

                if (!TypeScript.Syntax.elementStructuralEquals(element1, element2)) {
                    return false;
                }
            }

            return true;
        };

        SyntaxNode.prototype.width = function () {
            return this.fullWidth() - this.leadingTriviaWidth() - this.trailingTriviaWidth();
        };

        SyntaxNode.prototype.leadingTriviaWidth = function () {
            var firstToken = this.firstToken();
            return firstToken === null ? 0 : firstToken.leadingTriviaWidth();
        };

        SyntaxNode.prototype.trailingTriviaWidth = function () {
            var lastToken = this.lastToken();
            return lastToken === null ? 0 : lastToken.trailingTriviaWidth();
        };
        return SyntaxNode;
    })();
    TypeScript.SyntaxNode = SyntaxNode;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SourceUnitSyntax = (function (_super) {
        __extends(SourceUnitSyntax, _super);
        function SourceUnitSyntax(moduleElements, endOfFileToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.moduleElements = moduleElements;
            this.endOfFileToken = endOfFileToken;
        }
        SourceUnitSyntax.prototype.accept = function (visitor) {
            return visitor.visitSourceUnit(this);
        };

        SourceUnitSyntax.prototype.kind = function () {
            return 120 /* SourceUnit */;
        };

        SourceUnitSyntax.prototype.childCount = function () {
            return 2;
        };

        SourceUnitSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.moduleElements;
                case 1:
                    return this.endOfFileToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SourceUnitSyntax.prototype.update = function (moduleElements, endOfFileToken) {
            if (this.moduleElements === moduleElements && this.endOfFileToken === endOfFileToken) {
                return this;
            }

            return new SourceUnitSyntax(moduleElements, endOfFileToken, this.parsedInStrictMode());
        };

        SourceUnitSyntax.create = function (endOfFileToken) {
            return new SourceUnitSyntax(TypeScript.Syntax.emptyList, endOfFileToken, false);
        };

        SourceUnitSyntax.create1 = function (endOfFileToken) {
            return new SourceUnitSyntax(TypeScript.Syntax.emptyList, endOfFileToken, false);
        };

        SourceUnitSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SourceUnitSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SourceUnitSyntax.prototype.withModuleElements = function (moduleElements) {
            return this.update(moduleElements, this.endOfFileToken);
        };

        SourceUnitSyntax.prototype.withModuleElement = function (moduleElement) {
            return this.withModuleElements(TypeScript.Syntax.list([moduleElement]));
        };

        SourceUnitSyntax.prototype.withEndOfFileToken = function (endOfFileToken) {
            return this.update(this.moduleElements, endOfFileToken);
        };

        SourceUnitSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.moduleElements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return SourceUnitSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SourceUnitSyntax = SourceUnitSyntax;

    var ExternalModuleReferenceSyntax = (function (_super) {
        __extends(ExternalModuleReferenceSyntax, _super);
        function ExternalModuleReferenceSyntax(requireKeyword, openParenToken, stringLiteral, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.requireKeyword = requireKeyword;
            this.openParenToken = openParenToken;
            this.stringLiteral = stringLiteral;
            this.closeParenToken = closeParenToken;
        }
        ExternalModuleReferenceSyntax.prototype.accept = function (visitor) {
            return visitor.visitExternalModuleReference(this);
        };

        ExternalModuleReferenceSyntax.prototype.kind = function () {
            return 245 /* ExternalModuleReference */;
        };

        ExternalModuleReferenceSyntax.prototype.childCount = function () {
            return 4;
        };

        ExternalModuleReferenceSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.requireKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.stringLiteral;
                case 3:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ExternalModuleReferenceSyntax.prototype.isModuleReference = function () {
            return true;
        };

        ExternalModuleReferenceSyntax.prototype.update = function (requireKeyword, openParenToken, stringLiteral, closeParenToken) {
            if (this.requireKeyword === requireKeyword && this.openParenToken === openParenToken && this.stringLiteral === stringLiteral && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ExternalModuleReferenceSyntax(requireKeyword, openParenToken, stringLiteral, closeParenToken, this.parsedInStrictMode());
        };

        ExternalModuleReferenceSyntax.create1 = function (stringLiteral) {
            return new ExternalModuleReferenceSyntax(TypeScript.Syntax.token(66 /* RequireKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), stringLiteral, TypeScript.Syntax.token(73 /* CloseParenToken */), false);
        };

        ExternalModuleReferenceSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ExternalModuleReferenceSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ExternalModuleReferenceSyntax.prototype.withRequireKeyword = function (requireKeyword) {
            return this.update(requireKeyword, this.openParenToken, this.stringLiteral, this.closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.requireKeyword, openParenToken, this.stringLiteral, this.closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.withStringLiteral = function (stringLiteral) {
            return this.update(this.requireKeyword, this.openParenToken, stringLiteral, this.closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.requireKeyword, this.openParenToken, this.stringLiteral, closeParenToken);
        };

        ExternalModuleReferenceSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ExternalModuleReferenceSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ExternalModuleReferenceSyntax = ExternalModuleReferenceSyntax;

    var ModuleNameModuleReferenceSyntax = (function (_super) {
        __extends(ModuleNameModuleReferenceSyntax, _super);
        function ModuleNameModuleReferenceSyntax(moduleName, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.moduleName = moduleName;
        }
        ModuleNameModuleReferenceSyntax.prototype.accept = function (visitor) {
            return visitor.visitModuleNameModuleReference(this);
        };

        ModuleNameModuleReferenceSyntax.prototype.kind = function () {
            return 246 /* ModuleNameModuleReference */;
        };

        ModuleNameModuleReferenceSyntax.prototype.childCount = function () {
            return 1;
        };

        ModuleNameModuleReferenceSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.moduleName;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ModuleNameModuleReferenceSyntax.prototype.isModuleReference = function () {
            return true;
        };

        ModuleNameModuleReferenceSyntax.prototype.update = function (moduleName) {
            if (this.moduleName === moduleName) {
                return this;
            }

            return new ModuleNameModuleReferenceSyntax(moduleName, this.parsedInStrictMode());
        };

        ModuleNameModuleReferenceSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ModuleNameModuleReferenceSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ModuleNameModuleReferenceSyntax.prototype.withModuleName = function (moduleName) {
            return this.update(moduleName);
        };

        ModuleNameModuleReferenceSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ModuleNameModuleReferenceSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ModuleNameModuleReferenceSyntax = ModuleNameModuleReferenceSyntax;

    var ImportDeclarationSyntax = (function (_super) {
        __extends(ImportDeclarationSyntax, _super);
        function ImportDeclarationSyntax(modifiers, importKeyword, identifier, equalsToken, moduleReference, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.importKeyword = importKeyword;
            this.identifier = identifier;
            this.equalsToken = equalsToken;
            this.moduleReference = moduleReference;
            this.semicolonToken = semicolonToken;
        }
        ImportDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitImportDeclaration(this);
        };

        ImportDeclarationSyntax.prototype.kind = function () {
            return 133 /* ImportDeclaration */;
        };

        ImportDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        ImportDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.importKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.equalsToken;
                case 4:
                    return this.moduleReference;
                case 5:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ImportDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ImportDeclarationSyntax.prototype.update = function (modifiers, importKeyword, identifier, equalsToken, moduleReference, semicolonToken) {
            if (this.modifiers === modifiers && this.importKeyword === importKeyword && this.identifier === identifier && this.equalsToken === equalsToken && this.moduleReference === moduleReference && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ImportDeclarationSyntax(modifiers, importKeyword, identifier, equalsToken, moduleReference, semicolonToken, this.parsedInStrictMode());
        };

        ImportDeclarationSyntax.create = function (importKeyword, identifier, equalsToken, moduleReference, semicolonToken) {
            return new ImportDeclarationSyntax(TypeScript.Syntax.emptyList, importKeyword, identifier, equalsToken, moduleReference, semicolonToken, false);
        };

        ImportDeclarationSyntax.create1 = function (identifier, moduleReference) {
            return new ImportDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(49 /* ImportKeyword */), identifier, TypeScript.Syntax.token(107 /* EqualsToken */), moduleReference, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        ImportDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ImportDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ImportDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.importKeyword, this.identifier, this.equalsToken, this.moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        ImportDeclarationSyntax.prototype.withImportKeyword = function (importKeyword) {
            return this.update(this.modifiers, importKeyword, this.identifier, this.equalsToken, this.moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.importKeyword, identifier, this.equalsToken, this.moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withEqualsToken = function (equalsToken) {
            return this.update(this.modifiers, this.importKeyword, this.identifier, equalsToken, this.moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withModuleReference = function (moduleReference) {
            return this.update(this.modifiers, this.importKeyword, this.identifier, this.equalsToken, moduleReference, this.semicolonToken);
        };

        ImportDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.importKeyword, this.identifier, this.equalsToken, this.moduleReference, semicolonToken);
        };

        ImportDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ImportDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ImportDeclarationSyntax = ImportDeclarationSyntax;

    var ExportAssignmentSyntax = (function (_super) {
        __extends(ExportAssignmentSyntax, _super);
        function ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.exportKeyword = exportKeyword;
            this.equalsToken = equalsToken;
            this.identifier = identifier;
            this.semicolonToken = semicolonToken;
        }
        ExportAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitExportAssignment(this);
        };

        ExportAssignmentSyntax.prototype.kind = function () {
            return 134 /* ExportAssignment */;
        };

        ExportAssignmentSyntax.prototype.childCount = function () {
            return 4;
        };

        ExportAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.exportKeyword;
                case 1:
                    return this.equalsToken;
                case 2:
                    return this.identifier;
                case 3:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ExportAssignmentSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ExportAssignmentSyntax.prototype.update = function (exportKeyword, equalsToken, identifier, semicolonToken) {
            if (this.exportKeyword === exportKeyword && this.equalsToken === equalsToken && this.identifier === identifier && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ExportAssignmentSyntax(exportKeyword, equalsToken, identifier, semicolonToken, this.parsedInStrictMode());
        };

        ExportAssignmentSyntax.create1 = function (identifier) {
            return new ExportAssignmentSyntax(TypeScript.Syntax.token(47 /* ExportKeyword */), TypeScript.Syntax.token(107 /* EqualsToken */), identifier, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        ExportAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ExportAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ExportAssignmentSyntax.prototype.withExportKeyword = function (exportKeyword) {
            return this.update(exportKeyword, this.equalsToken, this.identifier, this.semicolonToken);
        };

        ExportAssignmentSyntax.prototype.withEqualsToken = function (equalsToken) {
            return this.update(this.exportKeyword, equalsToken, this.identifier, this.semicolonToken);
        };

        ExportAssignmentSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.exportKeyword, this.equalsToken, identifier, this.semicolonToken);
        };

        ExportAssignmentSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.exportKeyword, this.equalsToken, this.identifier, semicolonToken);
        };

        ExportAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ExportAssignmentSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ExportAssignmentSyntax = ExportAssignmentSyntax;

    var ClassDeclarationSyntax = (function (_super) {
        __extends(ClassDeclarationSyntax, _super);
        function ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.classKeyword = classKeyword;
            this.identifier = identifier;
            this.typeParameterList = typeParameterList;
            this.heritageClauses = heritageClauses;
            this.openBraceToken = openBraceToken;
            this.classElements = classElements;
            this.closeBraceToken = closeBraceToken;
        }
        ClassDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitClassDeclaration(this);
        };

        ClassDeclarationSyntax.prototype.kind = function () {
            return 131 /* ClassDeclaration */;
        };

        ClassDeclarationSyntax.prototype.childCount = function () {
            return 8;
        };

        ClassDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.classKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.typeParameterList;
                case 4:
                    return this.heritageClauses;
                case 5:
                    return this.openBraceToken;
                case 6:
                    return this.classElements;
                case 7:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ClassDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ClassDeclarationSyntax.prototype.update = function (modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken) {
            if (this.modifiers === modifiers && this.classKeyword === classKeyword && this.identifier === identifier && this.typeParameterList === typeParameterList && this.heritageClauses === heritageClauses && this.openBraceToken === openBraceToken && this.classElements === classElements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ClassDeclarationSyntax(modifiers, classKeyword, identifier, typeParameterList, heritageClauses, openBraceToken, classElements, closeBraceToken, this.parsedInStrictMode());
        };

        ClassDeclarationSyntax.create = function (classKeyword, identifier, openBraceToken, closeBraceToken) {
            return new ClassDeclarationSyntax(TypeScript.Syntax.emptyList, classKeyword, identifier, null, TypeScript.Syntax.emptyList, openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        ClassDeclarationSyntax.create1 = function (identifier) {
            return new ClassDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(44 /* ClassKeyword */), identifier, null, TypeScript.Syntax.emptyList, TypeScript.Syntax.token(70 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(71 /* CloseBraceToken */), false);
        };

        ClassDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ClassDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ClassDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        ClassDeclarationSyntax.prototype.withClassKeyword = function (classKeyword) {
            return this.update(this.modifiers, classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.classKeyword, identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withHeritageClauses = function (heritageClauses) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, heritageClauses, this.openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withHeritageClause = function (heritageClause) {
            return this.withHeritageClauses(TypeScript.Syntax.list([heritageClause]));
        };

        ClassDeclarationSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, openBraceToken, this.classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withClassElements = function (classElements) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, classElements, this.closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.withClassElement = function (classElement) {
            return this.withClassElements(TypeScript.Syntax.list([classElement]));
        };

        ClassDeclarationSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.modifiers, this.classKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.openBraceToken, this.classElements, closeBraceToken);
        };

        ClassDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ClassDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ClassDeclarationSyntax = ClassDeclarationSyntax;

    var InterfaceDeclarationSyntax = (function (_super) {
        __extends(InterfaceDeclarationSyntax, _super);
        function InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.interfaceKeyword = interfaceKeyword;
            this.identifier = identifier;
            this.typeParameterList = typeParameterList;
            this.heritageClauses = heritageClauses;
            this.body = body;
        }
        InterfaceDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitInterfaceDeclaration(this);
        };

        InterfaceDeclarationSyntax.prototype.kind = function () {
            return 128 /* InterfaceDeclaration */;
        };

        InterfaceDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        InterfaceDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.interfaceKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.typeParameterList;
                case 4:
                    return this.heritageClauses;
                case 5:
                    return this.body;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        InterfaceDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        InterfaceDeclarationSyntax.prototype.update = function (modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body) {
            if (this.modifiers === modifiers && this.interfaceKeyword === interfaceKeyword && this.identifier === identifier && this.typeParameterList === typeParameterList && this.heritageClauses === heritageClauses && this.body === body) {
                return this;
            }

            return new InterfaceDeclarationSyntax(modifiers, interfaceKeyword, identifier, typeParameterList, heritageClauses, body, this.parsedInStrictMode());
        };

        InterfaceDeclarationSyntax.create = function (interfaceKeyword, identifier, body) {
            return new InterfaceDeclarationSyntax(TypeScript.Syntax.emptyList, interfaceKeyword, identifier, null, TypeScript.Syntax.emptyList, body, false);
        };

        InterfaceDeclarationSyntax.create1 = function (identifier) {
            return new InterfaceDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(52 /* InterfaceKeyword */), identifier, null, TypeScript.Syntax.emptyList, ObjectTypeSyntax.create1(), false);
        };

        InterfaceDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        InterfaceDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        InterfaceDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.interfaceKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        InterfaceDeclarationSyntax.prototype.withInterfaceKeyword = function (interfaceKeyword) {
            return this.update(this.modifiers, interfaceKeyword, this.identifier, this.typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.interfaceKeyword, identifier, this.typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(this.modifiers, this.interfaceKeyword, this.identifier, typeParameterList, this.heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withHeritageClauses = function (heritageClauses) {
            return this.update(this.modifiers, this.interfaceKeyword, this.identifier, this.typeParameterList, heritageClauses, this.body);
        };

        InterfaceDeclarationSyntax.prototype.withHeritageClause = function (heritageClause) {
            return this.withHeritageClauses(TypeScript.Syntax.list([heritageClause]));
        };

        InterfaceDeclarationSyntax.prototype.withBody = function (body) {
            return this.update(this.modifiers, this.interfaceKeyword, this.identifier, this.typeParameterList, this.heritageClauses, body);
        };

        InterfaceDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return InterfaceDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.InterfaceDeclarationSyntax = InterfaceDeclarationSyntax;

    var HeritageClauseSyntax = (function (_super) {
        __extends(HeritageClauseSyntax, _super);
        function HeritageClauseSyntax(kind, extendsOrImplementsKeyword, typeNames, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.extendsOrImplementsKeyword = extendsOrImplementsKeyword;
            this.typeNames = typeNames;

            this._kind = kind;
        }
        HeritageClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitHeritageClause(this);
        };

        HeritageClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        HeritageClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.extendsOrImplementsKeyword;
                case 1:
                    return this.typeNames;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        HeritageClauseSyntax.prototype.kind = function () {
            return this._kind;
        };

        HeritageClauseSyntax.prototype.update = function (kind, extendsOrImplementsKeyword, typeNames) {
            if (this._kind === kind && this.extendsOrImplementsKeyword === extendsOrImplementsKeyword && this.typeNames === typeNames) {
                return this;
            }

            return new HeritageClauseSyntax(kind, extendsOrImplementsKeyword, typeNames, this.parsedInStrictMode());
        };

        HeritageClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        HeritageClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        HeritageClauseSyntax.prototype.withKind = function (kind) {
            return this.update(kind, this.extendsOrImplementsKeyword, this.typeNames);
        };

        HeritageClauseSyntax.prototype.withExtendsOrImplementsKeyword = function (extendsOrImplementsKeyword) {
            return this.update(this._kind, extendsOrImplementsKeyword, this.typeNames);
        };

        HeritageClauseSyntax.prototype.withTypeNames = function (typeNames) {
            return this.update(this._kind, this.extendsOrImplementsKeyword, typeNames);
        };

        HeritageClauseSyntax.prototype.withTypeName = function (typeName) {
            return this.withTypeNames(TypeScript.Syntax.separatedList([typeName]));
        };

        HeritageClauseSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return HeritageClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.HeritageClauseSyntax = HeritageClauseSyntax;

    var ModuleDeclarationSyntax = (function (_super) {
        __extends(ModuleDeclarationSyntax, _super);
        function ModuleDeclarationSyntax(modifiers, moduleKeyword, name, stringLiteral, openBraceToken, moduleElements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.moduleKeyword = moduleKeyword;
            this.name = name;
            this.stringLiteral = stringLiteral;
            this.openBraceToken = openBraceToken;
            this.moduleElements = moduleElements;
            this.closeBraceToken = closeBraceToken;
        }
        ModuleDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitModuleDeclaration(this);
        };

        ModuleDeclarationSyntax.prototype.kind = function () {
            return 130 /* ModuleDeclaration */;
        };

        ModuleDeclarationSyntax.prototype.childCount = function () {
            return 7;
        };

        ModuleDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.moduleKeyword;
                case 2:
                    return this.name;
                case 3:
                    return this.stringLiteral;
                case 4:
                    return this.openBraceToken;
                case 5:
                    return this.moduleElements;
                case 6:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ModuleDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ModuleDeclarationSyntax.prototype.update = function (modifiers, moduleKeyword, name, stringLiteral, openBraceToken, moduleElements, closeBraceToken) {
            if (this.modifiers === modifiers && this.moduleKeyword === moduleKeyword && this.name === name && this.stringLiteral === stringLiteral && this.openBraceToken === openBraceToken && this.moduleElements === moduleElements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ModuleDeclarationSyntax(modifiers, moduleKeyword, name, stringLiteral, openBraceToken, moduleElements, closeBraceToken, this.parsedInStrictMode());
        };

        ModuleDeclarationSyntax.create = function (moduleKeyword, openBraceToken, closeBraceToken) {
            return new ModuleDeclarationSyntax(TypeScript.Syntax.emptyList, moduleKeyword, null, null, openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        ModuleDeclarationSyntax.create1 = function () {
            return new ModuleDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(65 /* ModuleKeyword */), null, null, TypeScript.Syntax.token(70 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(71 /* CloseBraceToken */), false);
        };

        ModuleDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ModuleDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ModuleDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.moduleKeyword, this.name, this.stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        ModuleDeclarationSyntax.prototype.withModuleKeyword = function (moduleKeyword) {
            return this.update(this.modifiers, moduleKeyword, this.name, this.stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withName = function (name) {
            return this.update(this.modifiers, this.moduleKeyword, name, this.stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withStringLiteral = function (stringLiteral) {
            return this.update(this.modifiers, this.moduleKeyword, this.name, stringLiteral, this.openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.modifiers, this.moduleKeyword, this.name, this.stringLiteral, openBraceToken, this.moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withModuleElements = function (moduleElements) {
            return this.update(this.modifiers, this.moduleKeyword, this.name, this.stringLiteral, this.openBraceToken, moduleElements, this.closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.withModuleElement = function (moduleElement) {
            return this.withModuleElements(TypeScript.Syntax.list([moduleElement]));
        };

        ModuleDeclarationSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.modifiers, this.moduleKeyword, this.name, this.stringLiteral, this.openBraceToken, this.moduleElements, closeBraceToken);
        };

        ModuleDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ModuleDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ModuleDeclarationSyntax = ModuleDeclarationSyntax;

    var FunctionDeclarationSyntax = (function (_super) {
        __extends(FunctionDeclarationSyntax, _super);
        function FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.functionKeyword = functionKeyword;
            this.identifier = identifier;
            this.callSignature = callSignature;
            this.block = block;
            this.semicolonToken = semicolonToken;
        }
        FunctionDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionDeclaration(this);
        };

        FunctionDeclarationSyntax.prototype.kind = function () {
            return 129 /* FunctionDeclaration */;
        };

        FunctionDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        FunctionDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.functionKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.callSignature;
                case 4:
                    return this.block;
                case 5:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionDeclarationSyntax.prototype.isStatement = function () {
            return true;
        };

        FunctionDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        FunctionDeclarationSyntax.prototype.update = function (modifiers, functionKeyword, identifier, callSignature, block, semicolonToken) {
            if (this.modifiers === modifiers && this.functionKeyword === functionKeyword && this.identifier === identifier && this.callSignature === callSignature && this.block === block && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new FunctionDeclarationSyntax(modifiers, functionKeyword, identifier, callSignature, block, semicolonToken, this.parsedInStrictMode());
        };

        FunctionDeclarationSyntax.create = function (functionKeyword, identifier, callSignature) {
            return new FunctionDeclarationSyntax(TypeScript.Syntax.emptyList, functionKeyword, identifier, callSignature, null, null, false);
        };

        FunctionDeclarationSyntax.create1 = function (identifier) {
            return new FunctionDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(27 /* FunctionKeyword */), identifier, CallSignatureSyntax.create1(), null, null, false);
        };

        FunctionDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.functionKeyword, this.identifier, this.callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        FunctionDeclarationSyntax.prototype.withFunctionKeyword = function (functionKeyword) {
            return this.update(this.modifiers, functionKeyword, this.identifier, this.callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.functionKeyword, identifier, this.callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.modifiers, this.functionKeyword, this.identifier, callSignature, this.block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.functionKeyword, this.identifier, this.callSignature, block, this.semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.functionKeyword, this.identifier, this.callSignature, this.block, semicolonToken);
        };

        FunctionDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.modifiers.childCount() > 0) {
                return true;
            }
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block !== null && this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FunctionDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FunctionDeclarationSyntax = FunctionDeclarationSyntax;

    var VariableStatementSyntax = (function (_super) {
        __extends(VariableStatementSyntax, _super);
        function VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.variableDeclaration = variableDeclaration;
            this.semicolonToken = semicolonToken;
        }
        VariableStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitVariableStatement(this);
        };

        VariableStatementSyntax.prototype.kind = function () {
            return 148 /* VariableStatement */;
        };

        VariableStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        VariableStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.variableDeclaration;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VariableStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        VariableStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        VariableStatementSyntax.prototype.update = function (modifiers, variableDeclaration, semicolonToken) {
            if (this.modifiers === modifiers && this.variableDeclaration === variableDeclaration && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new VariableStatementSyntax(modifiers, variableDeclaration, semicolonToken, this.parsedInStrictMode());
        };

        VariableStatementSyntax.create = function (variableDeclaration, semicolonToken) {
            return new VariableStatementSyntax(TypeScript.Syntax.emptyList, variableDeclaration, semicolonToken, false);
        };

        VariableStatementSyntax.create1 = function (variableDeclaration) {
            return new VariableStatementSyntax(TypeScript.Syntax.emptyList, variableDeclaration, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        VariableStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VariableStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VariableStatementSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.variableDeclaration, this.semicolonToken);
        };

        VariableStatementSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        VariableStatementSyntax.prototype.withVariableDeclaration = function (variableDeclaration) {
            return this.update(this.modifiers, variableDeclaration, this.semicolonToken);
        };

        VariableStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.variableDeclaration, semicolonToken);
        };

        VariableStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.modifiers.childCount() > 0) {
                return true;
            }
            if (this.variableDeclaration.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VariableStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VariableStatementSyntax = VariableStatementSyntax;

    var VariableDeclarationSyntax = (function (_super) {
        __extends(VariableDeclarationSyntax, _super);
        function VariableDeclarationSyntax(varKeyword, variableDeclarators, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.varKeyword = varKeyword;
            this.variableDeclarators = variableDeclarators;
        }
        VariableDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitVariableDeclaration(this);
        };

        VariableDeclarationSyntax.prototype.kind = function () {
            return 224 /* VariableDeclaration */;
        };

        VariableDeclarationSyntax.prototype.childCount = function () {
            return 2;
        };

        VariableDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.varKeyword;
                case 1:
                    return this.variableDeclarators;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VariableDeclarationSyntax.prototype.update = function (varKeyword, variableDeclarators) {
            if (this.varKeyword === varKeyword && this.variableDeclarators === variableDeclarators) {
                return this;
            }

            return new VariableDeclarationSyntax(varKeyword, variableDeclarators, this.parsedInStrictMode());
        };

        VariableDeclarationSyntax.create1 = function (variableDeclarators) {
            return new VariableDeclarationSyntax(TypeScript.Syntax.token(40 /* VarKeyword */), variableDeclarators, false);
        };

        VariableDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VariableDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VariableDeclarationSyntax.prototype.withVarKeyword = function (varKeyword) {
            return this.update(varKeyword, this.variableDeclarators);
        };

        VariableDeclarationSyntax.prototype.withVariableDeclarators = function (variableDeclarators) {
            return this.update(this.varKeyword, variableDeclarators);
        };

        VariableDeclarationSyntax.prototype.withVariableDeclarator = function (variableDeclarator) {
            return this.withVariableDeclarators(TypeScript.Syntax.separatedList([variableDeclarator]));
        };

        VariableDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.variableDeclarators.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VariableDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VariableDeclarationSyntax = VariableDeclarationSyntax;

    var VariableDeclaratorSyntax = (function (_super) {
        __extends(VariableDeclaratorSyntax, _super);
        function VariableDeclaratorSyntax(propertyName, typeAnnotation, equalsValueClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.typeAnnotation = typeAnnotation;
            this.equalsValueClause = equalsValueClause;
        }
        VariableDeclaratorSyntax.prototype.accept = function (visitor) {
            return visitor.visitVariableDeclarator(this);
        };

        VariableDeclaratorSyntax.prototype.kind = function () {
            return 225 /* VariableDeclarator */;
        };

        VariableDeclaratorSyntax.prototype.childCount = function () {
            return 3;
        };

        VariableDeclaratorSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.typeAnnotation;
                case 2:
                    return this.equalsValueClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VariableDeclaratorSyntax.prototype.update = function (propertyName, typeAnnotation, equalsValueClause) {
            if (this.propertyName === propertyName && this.typeAnnotation === typeAnnotation && this.equalsValueClause === equalsValueClause) {
                return this;
            }

            return new VariableDeclaratorSyntax(propertyName, typeAnnotation, equalsValueClause, this.parsedInStrictMode());
        };

        VariableDeclaratorSyntax.create = function (propertyName) {
            return new VariableDeclaratorSyntax(propertyName, null, null, false);
        };

        VariableDeclaratorSyntax.create1 = function (propertyName) {
            return new VariableDeclaratorSyntax(propertyName, null, null, false);
        };

        VariableDeclaratorSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VariableDeclaratorSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VariableDeclaratorSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.typeAnnotation, this.equalsValueClause);
        };

        VariableDeclaratorSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.propertyName, typeAnnotation, this.equalsValueClause);
        };

        VariableDeclaratorSyntax.prototype.withEqualsValueClause = function (equalsValueClause) {
            return this.update(this.propertyName, this.typeAnnotation, equalsValueClause);
        };

        VariableDeclaratorSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeAnnotation !== null) {
                return true;
            }
            if (this.equalsValueClause !== null && this.equalsValueClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VariableDeclaratorSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VariableDeclaratorSyntax = VariableDeclaratorSyntax;

    var EqualsValueClauseSyntax = (function (_super) {
        __extends(EqualsValueClauseSyntax, _super);
        function EqualsValueClauseSyntax(equalsToken, value, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.equalsToken = equalsToken;
            this.value = value;
        }
        EqualsValueClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitEqualsValueClause(this);
        };

        EqualsValueClauseSyntax.prototype.kind = function () {
            return 232 /* EqualsValueClause */;
        };

        EqualsValueClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        EqualsValueClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.equalsToken;
                case 1:
                    return this.value;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EqualsValueClauseSyntax.prototype.update = function (equalsToken, value) {
            if (this.equalsToken === equalsToken && this.value === value) {
                return this;
            }

            return new EqualsValueClauseSyntax(equalsToken, value, this.parsedInStrictMode());
        };

        EqualsValueClauseSyntax.create1 = function (value) {
            return new EqualsValueClauseSyntax(TypeScript.Syntax.token(107 /* EqualsToken */), value, false);
        };

        EqualsValueClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EqualsValueClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EqualsValueClauseSyntax.prototype.withEqualsToken = function (equalsToken) {
            return this.update(equalsToken, this.value);
        };

        EqualsValueClauseSyntax.prototype.withValue = function (value) {
            return this.update(this.equalsToken, value);
        };

        EqualsValueClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.value.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return EqualsValueClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EqualsValueClauseSyntax = EqualsValueClauseSyntax;

    var PrefixUnaryExpressionSyntax = (function (_super) {
        __extends(PrefixUnaryExpressionSyntax, _super);
        function PrefixUnaryExpressionSyntax(kind, operatorToken, operand, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.operatorToken = operatorToken;
            this.operand = operand;

            this._kind = kind;
        }
        PrefixUnaryExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitPrefixUnaryExpression(this);
        };

        PrefixUnaryExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        PrefixUnaryExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.operatorToken;
                case 1:
                    return this.operand;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        PrefixUnaryExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        PrefixUnaryExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        PrefixUnaryExpressionSyntax.prototype.kind = function () {
            return this._kind;
        };

        PrefixUnaryExpressionSyntax.prototype.update = function (kind, operatorToken, operand) {
            if (this._kind === kind && this.operatorToken === operatorToken && this.operand === operand) {
                return this;
            }

            return new PrefixUnaryExpressionSyntax(kind, operatorToken, operand, this.parsedInStrictMode());
        };

        PrefixUnaryExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        PrefixUnaryExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        PrefixUnaryExpressionSyntax.prototype.withKind = function (kind) {
            return this.update(kind, this.operatorToken, this.operand);
        };

        PrefixUnaryExpressionSyntax.prototype.withOperatorToken = function (operatorToken) {
            return this.update(this._kind, operatorToken, this.operand);
        };

        PrefixUnaryExpressionSyntax.prototype.withOperand = function (operand) {
            return this.update(this._kind, this.operatorToken, operand);
        };

        PrefixUnaryExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.operand.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return PrefixUnaryExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.PrefixUnaryExpressionSyntax = PrefixUnaryExpressionSyntax;

    var ArrayLiteralExpressionSyntax = (function (_super) {
        __extends(ArrayLiteralExpressionSyntax, _super);
        function ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBracketToken = openBracketToken;
            this.expressions = expressions;
            this.closeBracketToken = closeBracketToken;
        }
        ArrayLiteralExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitArrayLiteralExpression(this);
        };

        ArrayLiteralExpressionSyntax.prototype.kind = function () {
            return 214 /* ArrayLiteralExpression */;
        };

        ArrayLiteralExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ArrayLiteralExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBracketToken;
                case 1:
                    return this.expressions;
                case 2:
                    return this.closeBracketToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ArrayLiteralExpressionSyntax.prototype.isPrimaryExpression = function () {
            return true;
        };

        ArrayLiteralExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        ArrayLiteralExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        ArrayLiteralExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ArrayLiteralExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ArrayLiteralExpressionSyntax.prototype.update = function (openBracketToken, expressions, closeBracketToken) {
            if (this.openBracketToken === openBracketToken && this.expressions === expressions && this.closeBracketToken === closeBracketToken) {
                return this;
            }

            return new ArrayLiteralExpressionSyntax(openBracketToken, expressions, closeBracketToken, this.parsedInStrictMode());
        };

        ArrayLiteralExpressionSyntax.create = function (openBracketToken, closeBracketToken) {
            return new ArrayLiteralExpressionSyntax(openBracketToken, TypeScript.Syntax.emptySeparatedList, closeBracketToken, false);
        };

        ArrayLiteralExpressionSyntax.create1 = function () {
            return new ArrayLiteralExpressionSyntax(TypeScript.Syntax.token(74 /* OpenBracketToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(75 /* CloseBracketToken */), false);
        };

        ArrayLiteralExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ArrayLiteralExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ArrayLiteralExpressionSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(openBracketToken, this.expressions, this.closeBracketToken);
        };

        ArrayLiteralExpressionSyntax.prototype.withExpressions = function (expressions) {
            return this.update(this.openBracketToken, expressions, this.closeBracketToken);
        };

        ArrayLiteralExpressionSyntax.prototype.withExpression = function (expression) {
            return this.withExpressions(TypeScript.Syntax.separatedList([expression]));
        };

        ArrayLiteralExpressionSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.openBracketToken, this.expressions, closeBracketToken);
        };

        ArrayLiteralExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expressions.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ArrayLiteralExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ArrayLiteralExpressionSyntax = ArrayLiteralExpressionSyntax;

    var OmittedExpressionSyntax = (function (_super) {
        __extends(OmittedExpressionSyntax, _super);
        function OmittedExpressionSyntax(parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
        }
        OmittedExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitOmittedExpression(this);
        };

        OmittedExpressionSyntax.prototype.kind = function () {
            return 223 /* OmittedExpression */;
        };

        OmittedExpressionSyntax.prototype.childCount = function () {
            return 0;
        };

        OmittedExpressionSyntax.prototype.childAt = function (slot) {
            throw TypeScript.Errors.invalidOperation();
        };

        OmittedExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        OmittedExpressionSyntax.prototype.update = function () {
            return this;
        };

        OmittedExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        OmittedExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        OmittedExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return OmittedExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.OmittedExpressionSyntax = OmittedExpressionSyntax;

    var ParenthesizedExpressionSyntax = (function (_super) {
        __extends(ParenthesizedExpressionSyntax, _super);
        function ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openParenToken = openParenToken;
            this.expression = expression;
            this.closeParenToken = closeParenToken;
        }
        ParenthesizedExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitParenthesizedExpression(this);
        };

        ParenthesizedExpressionSyntax.prototype.kind = function () {
            return 217 /* ParenthesizedExpression */;
        };

        ParenthesizedExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ParenthesizedExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openParenToken;
                case 1:
                    return this.expression;
                case 2:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParenthesizedExpressionSyntax.prototype.isPrimaryExpression = function () {
            return true;
        };

        ParenthesizedExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        ParenthesizedExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        ParenthesizedExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ParenthesizedExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ParenthesizedExpressionSyntax.prototype.update = function (openParenToken, expression, closeParenToken) {
            if (this.openParenToken === openParenToken && this.expression === expression && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ParenthesizedExpressionSyntax(openParenToken, expression, closeParenToken, this.parsedInStrictMode());
        };

        ParenthesizedExpressionSyntax.create1 = function (expression) {
            return new ParenthesizedExpressionSyntax(TypeScript.Syntax.token(72 /* OpenParenToken */), expression, TypeScript.Syntax.token(73 /* CloseParenToken */), false);
        };

        ParenthesizedExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParenthesizedExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParenthesizedExpressionSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(openParenToken, this.expression, this.closeParenToken);
        };

        ParenthesizedExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.openParenToken, expression, this.closeParenToken);
        };

        ParenthesizedExpressionSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.openParenToken, this.expression, closeParenToken);
        };

        ParenthesizedExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ParenthesizedExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ParenthesizedExpressionSyntax = ParenthesizedExpressionSyntax;

    var SimpleArrowFunctionExpressionSyntax = (function (_super) {
        __extends(SimpleArrowFunctionExpressionSyntax, _super);
        function SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, block, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.identifier = identifier;
            this.equalsGreaterThanToken = equalsGreaterThanToken;
            this.block = block;
            this.expression = expression;
        }
        SimpleArrowFunctionExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitSimpleArrowFunctionExpression(this);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.kind = function () {
            return 219 /* SimpleArrowFunctionExpression */;
        };

        SimpleArrowFunctionExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        SimpleArrowFunctionExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.identifier;
                case 1:
                    return this.equalsGreaterThanToken;
                case 2:
                    return this.block;
                case 3:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SimpleArrowFunctionExpressionSyntax.prototype.isArrowFunctionExpression = function () {
            return true;
        };

        SimpleArrowFunctionExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        SimpleArrowFunctionExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        SimpleArrowFunctionExpressionSyntax.prototype.update = function (identifier, equalsGreaterThanToken, block, expression) {
            if (this.identifier === identifier && this.equalsGreaterThanToken === equalsGreaterThanToken && this.block === block && this.expression === expression) {
                return this;
            }

            return new SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, block, expression, this.parsedInStrictMode());
        };

        SimpleArrowFunctionExpressionSyntax.create = function (identifier, equalsGreaterThanToken) {
            return new SimpleArrowFunctionExpressionSyntax(identifier, equalsGreaterThanToken, null, null, false);
        };

        SimpleArrowFunctionExpressionSyntax.create1 = function (identifier) {
            return new SimpleArrowFunctionExpressionSyntax(identifier, TypeScript.Syntax.token(85 /* EqualsGreaterThanToken */), null, null, false);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(identifier, this.equalsGreaterThanToken, this.block, this.expression);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.identifier, equalsGreaterThanToken, this.block, this.expression);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withBlock = function (block) {
            return this.update(this.identifier, this.equalsGreaterThanToken, block, this.expression);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.identifier, this.equalsGreaterThanToken, this.block, expression);
        };

        SimpleArrowFunctionExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return SimpleArrowFunctionExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SimpleArrowFunctionExpressionSyntax = SimpleArrowFunctionExpressionSyntax;

    var ParenthesizedArrowFunctionExpressionSyntax = (function (_super) {
        __extends(ParenthesizedArrowFunctionExpressionSyntax, _super);
        function ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, block, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.callSignature = callSignature;
            this.equalsGreaterThanToken = equalsGreaterThanToken;
            this.block = block;
            this.expression = expression;
        }
        ParenthesizedArrowFunctionExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitParenthesizedArrowFunctionExpression(this);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.kind = function () {
            return 218 /* ParenthesizedArrowFunctionExpression */;
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.callSignature;
                case 1:
                    return this.equalsGreaterThanToken;
                case 2:
                    return this.block;
                case 3:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.isArrowFunctionExpression = function () {
            return true;
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.update = function (callSignature, equalsGreaterThanToken, block, expression) {
            if (this.callSignature === callSignature && this.equalsGreaterThanToken === equalsGreaterThanToken && this.block === block && this.expression === expression) {
                return this;
            }

            return new ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, block, expression, this.parsedInStrictMode());
        };

        ParenthesizedArrowFunctionExpressionSyntax.create = function (callSignature, equalsGreaterThanToken) {
            return new ParenthesizedArrowFunctionExpressionSyntax(callSignature, equalsGreaterThanToken, null, null, false);
        };

        ParenthesizedArrowFunctionExpressionSyntax.create1 = function () {
            return new ParenthesizedArrowFunctionExpressionSyntax(CallSignatureSyntax.create1(), TypeScript.Syntax.token(85 /* EqualsGreaterThanToken */), null, null, false);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(callSignature, this.equalsGreaterThanToken, this.block, this.expression);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.callSignature, equalsGreaterThanToken, this.block, this.expression);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withBlock = function (block) {
            return this.update(this.callSignature, this.equalsGreaterThanToken, block, this.expression);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.callSignature, this.equalsGreaterThanToken, this.block, expression);
        };

        ParenthesizedArrowFunctionExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ParenthesizedArrowFunctionExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ParenthesizedArrowFunctionExpressionSyntax = ParenthesizedArrowFunctionExpressionSyntax;

    var QualifiedNameSyntax = (function (_super) {
        __extends(QualifiedNameSyntax, _super);
        function QualifiedNameSyntax(left, dotToken, right, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.left = left;
            this.dotToken = dotToken;
            this.right = right;
        }
        QualifiedNameSyntax.prototype.accept = function (visitor) {
            return visitor.visitQualifiedName(this);
        };

        QualifiedNameSyntax.prototype.kind = function () {
            return 121 /* QualifiedName */;
        };

        QualifiedNameSyntax.prototype.childCount = function () {
            return 3;
        };

        QualifiedNameSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.left;
                case 1:
                    return this.dotToken;
                case 2:
                    return this.right;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        QualifiedNameSyntax.prototype.isName = function () {
            return true;
        };

        QualifiedNameSyntax.prototype.isType = function () {
            return true;
        };

        QualifiedNameSyntax.prototype.update = function (left, dotToken, right) {
            if (this.left === left && this.dotToken === dotToken && this.right === right) {
                return this;
            }

            return new QualifiedNameSyntax(left, dotToken, right, this.parsedInStrictMode());
        };

        QualifiedNameSyntax.create1 = function (left, right) {
            return new QualifiedNameSyntax(left, TypeScript.Syntax.token(76 /* DotToken */), right, false);
        };

        QualifiedNameSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        QualifiedNameSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        QualifiedNameSyntax.prototype.withLeft = function (left) {
            return this.update(left, this.dotToken, this.right);
        };

        QualifiedNameSyntax.prototype.withDotToken = function (dotToken) {
            return this.update(this.left, dotToken, this.right);
        };

        QualifiedNameSyntax.prototype.withRight = function (right) {
            return this.update(this.left, this.dotToken, right);
        };

        QualifiedNameSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return QualifiedNameSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.QualifiedNameSyntax = QualifiedNameSyntax;

    var TypeArgumentListSyntax = (function (_super) {
        __extends(TypeArgumentListSyntax, _super);
        function TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.lessThanToken = lessThanToken;
            this.typeArguments = typeArguments;
            this.greaterThanToken = greaterThanToken;
        }
        TypeArgumentListSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeArgumentList(this);
        };

        TypeArgumentListSyntax.prototype.kind = function () {
            return 228 /* TypeArgumentList */;
        };

        TypeArgumentListSyntax.prototype.childCount = function () {
            return 3;
        };

        TypeArgumentListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.lessThanToken;
                case 1:
                    return this.typeArguments;
                case 2:
                    return this.greaterThanToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeArgumentListSyntax.prototype.update = function (lessThanToken, typeArguments, greaterThanToken) {
            if (this.lessThanToken === lessThanToken && this.typeArguments === typeArguments && this.greaterThanToken === greaterThanToken) {
                return this;
            }

            return new TypeArgumentListSyntax(lessThanToken, typeArguments, greaterThanToken, this.parsedInStrictMode());
        };

        TypeArgumentListSyntax.create = function (lessThanToken, greaterThanToken) {
            return new TypeArgumentListSyntax(lessThanToken, TypeScript.Syntax.emptySeparatedList, greaterThanToken, false);
        };

        TypeArgumentListSyntax.create1 = function () {
            return new TypeArgumentListSyntax(TypeScript.Syntax.token(80 /* LessThanToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(81 /* GreaterThanToken */), false);
        };

        TypeArgumentListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeArgumentListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeArgumentListSyntax.prototype.withLessThanToken = function (lessThanToken) {
            return this.update(lessThanToken, this.typeArguments, this.greaterThanToken);
        };

        TypeArgumentListSyntax.prototype.withTypeArguments = function (typeArguments) {
            return this.update(this.lessThanToken, typeArguments, this.greaterThanToken);
        };

        TypeArgumentListSyntax.prototype.withTypeArgument = function (typeArgument) {
            return this.withTypeArguments(TypeScript.Syntax.separatedList([typeArgument]));
        };

        TypeArgumentListSyntax.prototype.withGreaterThanToken = function (greaterThanToken) {
            return this.update(this.lessThanToken, this.typeArguments, greaterThanToken);
        };

        TypeArgumentListSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeArgumentListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeArgumentListSyntax = TypeArgumentListSyntax;

    var ConstructorTypeSyntax = (function (_super) {
        __extends(ConstructorTypeSyntax, _super);
        function ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.newKeyword = newKeyword;
            this.typeParameterList = typeParameterList;
            this.parameterList = parameterList;
            this.equalsGreaterThanToken = equalsGreaterThanToken;
            this.type = type;
        }
        ConstructorTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstructorType(this);
        };

        ConstructorTypeSyntax.prototype.kind = function () {
            return 125 /* ConstructorType */;
        };

        ConstructorTypeSyntax.prototype.childCount = function () {
            return 5;
        };

        ConstructorTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.newKeyword;
                case 1:
                    return this.typeParameterList;
                case 2:
                    return this.parameterList;
                case 3:
                    return this.equalsGreaterThanToken;
                case 4:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstructorTypeSyntax.prototype.isType = function () {
            return true;
        };

        ConstructorTypeSyntax.prototype.update = function (newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type) {
            if (this.newKeyword === newKeyword && this.typeParameterList === typeParameterList && this.parameterList === parameterList && this.equalsGreaterThanToken === equalsGreaterThanToken && this.type === type) {
                return this;
            }

            return new ConstructorTypeSyntax(newKeyword, typeParameterList, parameterList, equalsGreaterThanToken, type, this.parsedInStrictMode());
        };

        ConstructorTypeSyntax.create = function (newKeyword, parameterList, equalsGreaterThanToken, type) {
            return new ConstructorTypeSyntax(newKeyword, null, parameterList, equalsGreaterThanToken, type, false);
        };

        ConstructorTypeSyntax.create1 = function (type) {
            return new ConstructorTypeSyntax(TypeScript.Syntax.token(31 /* NewKeyword */), null, ParameterListSyntax.create1(), TypeScript.Syntax.token(85 /* EqualsGreaterThanToken */), type, false);
        };

        ConstructorTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstructorTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstructorTypeSyntax.prototype.withNewKeyword = function (newKeyword) {
            return this.update(newKeyword, this.typeParameterList, this.parameterList, this.equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(this.newKeyword, typeParameterList, this.parameterList, this.equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.newKeyword, this.typeParameterList, parameterList, this.equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.newKeyword, this.typeParameterList, this.parameterList, equalsGreaterThanToken, this.type);
        };

        ConstructorTypeSyntax.prototype.withType = function (type) {
            return this.update(this.newKeyword, this.typeParameterList, this.parameterList, this.equalsGreaterThanToken, type);
        };

        ConstructorTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstructorTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstructorTypeSyntax = ConstructorTypeSyntax;

    var FunctionTypeSyntax = (function (_super) {
        __extends(FunctionTypeSyntax, _super);
        function FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeParameterList = typeParameterList;
            this.parameterList = parameterList;
            this.equalsGreaterThanToken = equalsGreaterThanToken;
            this.type = type;
        }
        FunctionTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionType(this);
        };

        FunctionTypeSyntax.prototype.kind = function () {
            return 123 /* FunctionType */;
        };

        FunctionTypeSyntax.prototype.childCount = function () {
            return 4;
        };

        FunctionTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeParameterList;
                case 1:
                    return this.parameterList;
                case 2:
                    return this.equalsGreaterThanToken;
                case 3:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionTypeSyntax.prototype.isType = function () {
            return true;
        };

        FunctionTypeSyntax.prototype.update = function (typeParameterList, parameterList, equalsGreaterThanToken, type) {
            if (this.typeParameterList === typeParameterList && this.parameterList === parameterList && this.equalsGreaterThanToken === equalsGreaterThanToken && this.type === type) {
                return this;
            }

            return new FunctionTypeSyntax(typeParameterList, parameterList, equalsGreaterThanToken, type, this.parsedInStrictMode());
        };

        FunctionTypeSyntax.create = function (parameterList, equalsGreaterThanToken, type) {
            return new FunctionTypeSyntax(null, parameterList, equalsGreaterThanToken, type, false);
        };

        FunctionTypeSyntax.create1 = function (type) {
            return new FunctionTypeSyntax(null, ParameterListSyntax.create1(), TypeScript.Syntax.token(85 /* EqualsGreaterThanToken */), type, false);
        };

        FunctionTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionTypeSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(typeParameterList, this.parameterList, this.equalsGreaterThanToken, this.type);
        };

        FunctionTypeSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.typeParameterList, parameterList, this.equalsGreaterThanToken, this.type);
        };

        FunctionTypeSyntax.prototype.withEqualsGreaterThanToken = function (equalsGreaterThanToken) {
            return this.update(this.typeParameterList, this.parameterList, equalsGreaterThanToken, this.type);
        };

        FunctionTypeSyntax.prototype.withType = function (type) {
            return this.update(this.typeParameterList, this.parameterList, this.equalsGreaterThanToken, type);
        };

        FunctionTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return FunctionTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FunctionTypeSyntax = FunctionTypeSyntax;

    var ObjectTypeSyntax = (function (_super) {
        __extends(ObjectTypeSyntax, _super);
        function ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBraceToken = openBraceToken;
            this.typeMembers = typeMembers;
            this.closeBraceToken = closeBraceToken;
        }
        ObjectTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitObjectType(this);
        };

        ObjectTypeSyntax.prototype.kind = function () {
            return 122 /* ObjectType */;
        };

        ObjectTypeSyntax.prototype.childCount = function () {
            return 3;
        };

        ObjectTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBraceToken;
                case 1:
                    return this.typeMembers;
                case 2:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ObjectTypeSyntax.prototype.isType = function () {
            return true;
        };

        ObjectTypeSyntax.prototype.update = function (openBraceToken, typeMembers, closeBraceToken) {
            if (this.openBraceToken === openBraceToken && this.typeMembers === typeMembers && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ObjectTypeSyntax(openBraceToken, typeMembers, closeBraceToken, this.parsedInStrictMode());
        };

        ObjectTypeSyntax.create = function (openBraceToken, closeBraceToken) {
            return new ObjectTypeSyntax(openBraceToken, TypeScript.Syntax.emptySeparatedList, closeBraceToken, false);
        };

        ObjectTypeSyntax.create1 = function () {
            return new ObjectTypeSyntax(TypeScript.Syntax.token(70 /* OpenBraceToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(71 /* CloseBraceToken */), false);
        };

        ObjectTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ObjectTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ObjectTypeSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(openBraceToken, this.typeMembers, this.closeBraceToken);
        };

        ObjectTypeSyntax.prototype.withTypeMembers = function (typeMembers) {
            return this.update(this.openBraceToken, typeMembers, this.closeBraceToken);
        };

        ObjectTypeSyntax.prototype.withTypeMember = function (typeMember) {
            return this.withTypeMembers(TypeScript.Syntax.separatedList([typeMember]));
        };

        ObjectTypeSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.openBraceToken, this.typeMembers, closeBraceToken);
        };

        ObjectTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ObjectTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ObjectTypeSyntax = ObjectTypeSyntax;

    var ArrayTypeSyntax = (function (_super) {
        __extends(ArrayTypeSyntax, _super);
        function ArrayTypeSyntax(type, openBracketToken, closeBracketToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.type = type;
            this.openBracketToken = openBracketToken;
            this.closeBracketToken = closeBracketToken;
        }
        ArrayTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitArrayType(this);
        };

        ArrayTypeSyntax.prototype.kind = function () {
            return 124 /* ArrayType */;
        };

        ArrayTypeSyntax.prototype.childCount = function () {
            return 3;
        };

        ArrayTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.type;
                case 1:
                    return this.openBracketToken;
                case 2:
                    return this.closeBracketToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ArrayTypeSyntax.prototype.isType = function () {
            return true;
        };

        ArrayTypeSyntax.prototype.update = function (type, openBracketToken, closeBracketToken) {
            if (this.type === type && this.openBracketToken === openBracketToken && this.closeBracketToken === closeBracketToken) {
                return this;
            }

            return new ArrayTypeSyntax(type, openBracketToken, closeBracketToken, this.parsedInStrictMode());
        };

        ArrayTypeSyntax.create1 = function (type) {
            return new ArrayTypeSyntax(type, TypeScript.Syntax.token(74 /* OpenBracketToken */), TypeScript.Syntax.token(75 /* CloseBracketToken */), false);
        };

        ArrayTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ArrayTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ArrayTypeSyntax.prototype.withType = function (type) {
            return this.update(type, this.openBracketToken, this.closeBracketToken);
        };

        ArrayTypeSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(this.type, openBracketToken, this.closeBracketToken);
        };

        ArrayTypeSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.type, this.openBracketToken, closeBracketToken);
        };

        ArrayTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ArrayTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ArrayTypeSyntax = ArrayTypeSyntax;

    var GenericTypeSyntax = (function (_super) {
        __extends(GenericTypeSyntax, _super);
        function GenericTypeSyntax(name, typeArgumentList, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.name = name;
            this.typeArgumentList = typeArgumentList;
        }
        GenericTypeSyntax.prototype.accept = function (visitor) {
            return visitor.visitGenericType(this);
        };

        GenericTypeSyntax.prototype.kind = function () {
            return 126 /* GenericType */;
        };

        GenericTypeSyntax.prototype.childCount = function () {
            return 2;
        };

        GenericTypeSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.name;
                case 1:
                    return this.typeArgumentList;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        GenericTypeSyntax.prototype.isType = function () {
            return true;
        };

        GenericTypeSyntax.prototype.update = function (name, typeArgumentList) {
            if (this.name === name && this.typeArgumentList === typeArgumentList) {
                return this;
            }

            return new GenericTypeSyntax(name, typeArgumentList, this.parsedInStrictMode());
        };

        GenericTypeSyntax.create1 = function (name) {
            return new GenericTypeSyntax(name, TypeArgumentListSyntax.create1(), false);
        };

        GenericTypeSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        GenericTypeSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        GenericTypeSyntax.prototype.withName = function (name) {
            return this.update(name, this.typeArgumentList);
        };

        GenericTypeSyntax.prototype.withTypeArgumentList = function (typeArgumentList) {
            return this.update(this.name, typeArgumentList);
        };

        GenericTypeSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return GenericTypeSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.GenericTypeSyntax = GenericTypeSyntax;

    var TypeQuerySyntax = (function (_super) {
        __extends(TypeQuerySyntax, _super);
        function TypeQuerySyntax(typeOfKeyword, name, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeOfKeyword = typeOfKeyword;
            this.name = name;
        }
        TypeQuerySyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeQuery(this);
        };

        TypeQuerySyntax.prototype.kind = function () {
            return 127 /* TypeQuery */;
        };

        TypeQuerySyntax.prototype.childCount = function () {
            return 2;
        };

        TypeQuerySyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeOfKeyword;
                case 1:
                    return this.name;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeQuerySyntax.prototype.isType = function () {
            return true;
        };

        TypeQuerySyntax.prototype.update = function (typeOfKeyword, name) {
            if (this.typeOfKeyword === typeOfKeyword && this.name === name) {
                return this;
            }

            return new TypeQuerySyntax(typeOfKeyword, name, this.parsedInStrictMode());
        };

        TypeQuerySyntax.create1 = function (name) {
            return new TypeQuerySyntax(TypeScript.Syntax.token(39 /* TypeOfKeyword */), name, false);
        };

        TypeQuerySyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeQuerySyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeQuerySyntax.prototype.withTypeOfKeyword = function (typeOfKeyword) {
            return this.update(typeOfKeyword, this.name);
        };

        TypeQuerySyntax.prototype.withName = function (name) {
            return this.update(this.typeOfKeyword, name);
        };

        TypeQuerySyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeQuerySyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeQuerySyntax = TypeQuerySyntax;

    var TypeAnnotationSyntax = (function (_super) {
        __extends(TypeAnnotationSyntax, _super);
        function TypeAnnotationSyntax(colonToken, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.colonToken = colonToken;
            this.type = type;
        }
        TypeAnnotationSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeAnnotation(this);
        };

        TypeAnnotationSyntax.prototype.kind = function () {
            return 244 /* TypeAnnotation */;
        };

        TypeAnnotationSyntax.prototype.childCount = function () {
            return 2;
        };

        TypeAnnotationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.colonToken;
                case 1:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeAnnotationSyntax.prototype.update = function (colonToken, type) {
            if (this.colonToken === colonToken && this.type === type) {
                return this;
            }

            return new TypeAnnotationSyntax(colonToken, type, this.parsedInStrictMode());
        };

        TypeAnnotationSyntax.create1 = function (type) {
            return new TypeAnnotationSyntax(TypeScript.Syntax.token(106 /* ColonToken */), type, false);
        };

        TypeAnnotationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeAnnotationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeAnnotationSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(colonToken, this.type);
        };

        TypeAnnotationSyntax.prototype.withType = function (type) {
            return this.update(this.colonToken, type);
        };

        TypeAnnotationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeAnnotationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeAnnotationSyntax = TypeAnnotationSyntax;

    var BlockSyntax = (function (_super) {
        __extends(BlockSyntax, _super);
        function BlockSyntax(openBraceToken, statements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBraceToken = openBraceToken;
            this.statements = statements;
            this.closeBraceToken = closeBraceToken;
        }
        BlockSyntax.prototype.accept = function (visitor) {
            return visitor.visitBlock(this);
        };

        BlockSyntax.prototype.kind = function () {
            return 146 /* Block */;
        };

        BlockSyntax.prototype.childCount = function () {
            return 3;
        };

        BlockSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBraceToken;
                case 1:
                    return this.statements;
                case 2:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        BlockSyntax.prototype.isStatement = function () {
            return true;
        };

        BlockSyntax.prototype.isModuleElement = function () {
            return true;
        };

        BlockSyntax.prototype.update = function (openBraceToken, statements, closeBraceToken) {
            if (this.openBraceToken === openBraceToken && this.statements === statements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new BlockSyntax(openBraceToken, statements, closeBraceToken, this.parsedInStrictMode());
        };

        BlockSyntax.create = function (openBraceToken, closeBraceToken) {
            return new BlockSyntax(openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        BlockSyntax.create1 = function () {
            return new BlockSyntax(TypeScript.Syntax.token(70 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(71 /* CloseBraceToken */), false);
        };

        BlockSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        BlockSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        BlockSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(openBraceToken, this.statements, this.closeBraceToken);
        };

        BlockSyntax.prototype.withStatements = function (statements) {
            return this.update(this.openBraceToken, statements, this.closeBraceToken);
        };

        BlockSyntax.prototype.withStatement = function (statement) {
            return this.withStatements(TypeScript.Syntax.list([statement]));
        };

        BlockSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.openBraceToken, this.statements, closeBraceToken);
        };

        BlockSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return BlockSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.BlockSyntax = BlockSyntax;

    var ParameterSyntax = (function (_super) {
        __extends(ParameterSyntax, _super);
        function ParameterSyntax(dotDotDotToken, modifiers, identifier, questionToken, typeAnnotation, equalsValueClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.dotDotDotToken = dotDotDotToken;
            this.modifiers = modifiers;
            this.identifier = identifier;
            this.questionToken = questionToken;
            this.typeAnnotation = typeAnnotation;
            this.equalsValueClause = equalsValueClause;
        }
        ParameterSyntax.prototype.accept = function (visitor) {
            return visitor.visitParameter(this);
        };

        ParameterSyntax.prototype.kind = function () {
            return 242 /* Parameter */;
        };

        ParameterSyntax.prototype.childCount = function () {
            return 6;
        };

        ParameterSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.dotDotDotToken;
                case 1:
                    return this.modifiers;
                case 2:
                    return this.identifier;
                case 3:
                    return this.questionToken;
                case 4:
                    return this.typeAnnotation;
                case 5:
                    return this.equalsValueClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParameterSyntax.prototype.update = function (dotDotDotToken, modifiers, identifier, questionToken, typeAnnotation, equalsValueClause) {
            if (this.dotDotDotToken === dotDotDotToken && this.modifiers === modifiers && this.identifier === identifier && this.questionToken === questionToken && this.typeAnnotation === typeAnnotation && this.equalsValueClause === equalsValueClause) {
                return this;
            }

            return new ParameterSyntax(dotDotDotToken, modifiers, identifier, questionToken, typeAnnotation, equalsValueClause, this.parsedInStrictMode());
        };

        ParameterSyntax.create = function (identifier) {
            return new ParameterSyntax(null, TypeScript.Syntax.emptyList, identifier, null, null, null, false);
        };

        ParameterSyntax.create1 = function (identifier) {
            return new ParameterSyntax(null, TypeScript.Syntax.emptyList, identifier, null, null, null, false);
        };

        ParameterSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParameterSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParameterSyntax.prototype.withDotDotDotToken = function (dotDotDotToken) {
            return this.update(dotDotDotToken, this.modifiers, this.identifier, this.questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(this.dotDotDotToken, modifiers, this.identifier, this.questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        ParameterSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.dotDotDotToken, this.modifiers, identifier, this.questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.dotDotDotToken, this.modifiers, this.identifier, questionToken, this.typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.dotDotDotToken, this.modifiers, this.identifier, this.questionToken, typeAnnotation, this.equalsValueClause);
        };

        ParameterSyntax.prototype.withEqualsValueClause = function (equalsValueClause) {
            return this.update(this.dotDotDotToken, this.modifiers, this.identifier, this.questionToken, this.typeAnnotation, equalsValueClause);
        };

        ParameterSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.dotDotDotToken !== null) {
                return true;
            }
            if (this.modifiers.isTypeScriptSpecific()) {
                return true;
            }
            if (this.questionToken !== null) {
                return true;
            }
            if (this.typeAnnotation !== null) {
                return true;
            }
            if (this.equalsValueClause !== null) {
                return true;
            }
            return false;
        };
        return ParameterSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ParameterSyntax = ParameterSyntax;

    var MemberAccessExpressionSyntax = (function (_super) {
        __extends(MemberAccessExpressionSyntax, _super);
        function MemberAccessExpressionSyntax(expression, dotToken, name, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.dotToken = dotToken;
            this.name = name;
        }
        MemberAccessExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitMemberAccessExpression(this);
        };

        MemberAccessExpressionSyntax.prototype.kind = function () {
            return 212 /* MemberAccessExpression */;
        };

        MemberAccessExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        MemberAccessExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.dotToken;
                case 2:
                    return this.name;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MemberAccessExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        MemberAccessExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        MemberAccessExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        MemberAccessExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        MemberAccessExpressionSyntax.prototype.update = function (expression, dotToken, name) {
            if (this.expression === expression && this.dotToken === dotToken && this.name === name) {
                return this;
            }

            return new MemberAccessExpressionSyntax(expression, dotToken, name, this.parsedInStrictMode());
        };

        MemberAccessExpressionSyntax.create1 = function (expression, name) {
            return new MemberAccessExpressionSyntax(expression, TypeScript.Syntax.token(76 /* DotToken */), name, false);
        };

        MemberAccessExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MemberAccessExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MemberAccessExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.dotToken, this.name);
        };

        MemberAccessExpressionSyntax.prototype.withDotToken = function (dotToken) {
            return this.update(this.expression, dotToken, this.name);
        };

        MemberAccessExpressionSyntax.prototype.withName = function (name) {
            return this.update(this.expression, this.dotToken, name);
        };

        MemberAccessExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return MemberAccessExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MemberAccessExpressionSyntax = MemberAccessExpressionSyntax;

    var PostfixUnaryExpressionSyntax = (function (_super) {
        __extends(PostfixUnaryExpressionSyntax, _super);
        function PostfixUnaryExpressionSyntax(kind, operand, operatorToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.operand = operand;
            this.operatorToken = operatorToken;

            this._kind = kind;
        }
        PostfixUnaryExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitPostfixUnaryExpression(this);
        };

        PostfixUnaryExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        PostfixUnaryExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.operand;
                case 1:
                    return this.operatorToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        PostfixUnaryExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        PostfixUnaryExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        PostfixUnaryExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        PostfixUnaryExpressionSyntax.prototype.kind = function () {
            return this._kind;
        };

        PostfixUnaryExpressionSyntax.prototype.update = function (kind, operand, operatorToken) {
            if (this._kind === kind && this.operand === operand && this.operatorToken === operatorToken) {
                return this;
            }

            return new PostfixUnaryExpressionSyntax(kind, operand, operatorToken, this.parsedInStrictMode());
        };

        PostfixUnaryExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        PostfixUnaryExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        PostfixUnaryExpressionSyntax.prototype.withKind = function (kind) {
            return this.update(kind, this.operand, this.operatorToken);
        };

        PostfixUnaryExpressionSyntax.prototype.withOperand = function (operand) {
            return this.update(this._kind, operand, this.operatorToken);
        };

        PostfixUnaryExpressionSyntax.prototype.withOperatorToken = function (operatorToken) {
            return this.update(this._kind, this.operand, operatorToken);
        };

        PostfixUnaryExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.operand.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return PostfixUnaryExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.PostfixUnaryExpressionSyntax = PostfixUnaryExpressionSyntax;

    var ElementAccessExpressionSyntax = (function (_super) {
        __extends(ElementAccessExpressionSyntax, _super);
        function ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.openBracketToken = openBracketToken;
            this.argumentExpression = argumentExpression;
            this.closeBracketToken = closeBracketToken;
        }
        ElementAccessExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitElementAccessExpression(this);
        };

        ElementAccessExpressionSyntax.prototype.kind = function () {
            return 221 /* ElementAccessExpression */;
        };

        ElementAccessExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        ElementAccessExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.openBracketToken;
                case 2:
                    return this.argumentExpression;
                case 3:
                    return this.closeBracketToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ElementAccessExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        ElementAccessExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        ElementAccessExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ElementAccessExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ElementAccessExpressionSyntax.prototype.update = function (expression, openBracketToken, argumentExpression, closeBracketToken) {
            if (this.expression === expression && this.openBracketToken === openBracketToken && this.argumentExpression === argumentExpression && this.closeBracketToken === closeBracketToken) {
                return this;
            }

            return new ElementAccessExpressionSyntax(expression, openBracketToken, argumentExpression, closeBracketToken, this.parsedInStrictMode());
        };

        ElementAccessExpressionSyntax.create1 = function (expression, argumentExpression) {
            return new ElementAccessExpressionSyntax(expression, TypeScript.Syntax.token(74 /* OpenBracketToken */), argumentExpression, TypeScript.Syntax.token(75 /* CloseBracketToken */), false);
        };

        ElementAccessExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ElementAccessExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ElementAccessExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.openBracketToken, this.argumentExpression, this.closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(this.expression, openBracketToken, this.argumentExpression, this.closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.withArgumentExpression = function (argumentExpression) {
            return this.update(this.expression, this.openBracketToken, argumentExpression, this.closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.expression, this.openBracketToken, this.argumentExpression, closeBracketToken);
        };

        ElementAccessExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.argumentExpression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ElementAccessExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ElementAccessExpressionSyntax = ElementAccessExpressionSyntax;

    var InvocationExpressionSyntax = (function (_super) {
        __extends(InvocationExpressionSyntax, _super);
        function InvocationExpressionSyntax(expression, argumentList, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.argumentList = argumentList;
        }
        InvocationExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitInvocationExpression(this);
        };

        InvocationExpressionSyntax.prototype.kind = function () {
            return 213 /* InvocationExpression */;
        };

        InvocationExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        InvocationExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.argumentList;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        InvocationExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        InvocationExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        InvocationExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        InvocationExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        InvocationExpressionSyntax.prototype.update = function (expression, argumentList) {
            if (this.expression === expression && this.argumentList === argumentList) {
                return this;
            }

            return new InvocationExpressionSyntax(expression, argumentList, this.parsedInStrictMode());
        };

        InvocationExpressionSyntax.create1 = function (expression) {
            return new InvocationExpressionSyntax(expression, ArgumentListSyntax.create1(), false);
        };

        InvocationExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        InvocationExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        InvocationExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.argumentList);
        };

        InvocationExpressionSyntax.prototype.withArgumentList = function (argumentList) {
            return this.update(this.expression, argumentList);
        };

        InvocationExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.argumentList.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return InvocationExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.InvocationExpressionSyntax = InvocationExpressionSyntax;

    var ArgumentListSyntax = (function (_super) {
        __extends(ArgumentListSyntax, _super);
        function ArgumentListSyntax(typeArgumentList, openParenToken, _arguments, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeArgumentList = typeArgumentList;
            this.openParenToken = openParenToken;
            this.closeParenToken = closeParenToken;

            this.arguments = _arguments;
        }
        ArgumentListSyntax.prototype.accept = function (visitor) {
            return visitor.visitArgumentList(this);
        };

        ArgumentListSyntax.prototype.kind = function () {
            return 226 /* ArgumentList */;
        };

        ArgumentListSyntax.prototype.childCount = function () {
            return 4;
        };

        ArgumentListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeArgumentList;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.arguments;
                case 3:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ArgumentListSyntax.prototype.update = function (typeArgumentList, openParenToken, _arguments, closeParenToken) {
            if (this.typeArgumentList === typeArgumentList && this.openParenToken === openParenToken && this.arguments === _arguments && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ArgumentListSyntax(typeArgumentList, openParenToken, _arguments, closeParenToken, this.parsedInStrictMode());
        };

        ArgumentListSyntax.create = function (openParenToken, closeParenToken) {
            return new ArgumentListSyntax(null, openParenToken, TypeScript.Syntax.emptySeparatedList, closeParenToken, false);
        };

        ArgumentListSyntax.create1 = function () {
            return new ArgumentListSyntax(null, TypeScript.Syntax.token(72 /* OpenParenToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(73 /* CloseParenToken */), false);
        };

        ArgumentListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ArgumentListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ArgumentListSyntax.prototype.withTypeArgumentList = function (typeArgumentList) {
            return this.update(typeArgumentList, this.openParenToken, this.arguments, this.closeParenToken);
        };

        ArgumentListSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.typeArgumentList, openParenToken, this.arguments, this.closeParenToken);
        };

        ArgumentListSyntax.prototype.withArguments = function (_arguments) {
            return this.update(this.typeArgumentList, this.openParenToken, _arguments, this.closeParenToken);
        };

        ArgumentListSyntax.prototype.withArgument = function (_argument) {
            return this.withArguments(TypeScript.Syntax.separatedList([_argument]));
        };

        ArgumentListSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.typeArgumentList, this.openParenToken, this.arguments, closeParenToken);
        };

        ArgumentListSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeArgumentList !== null && this.typeArgumentList.isTypeScriptSpecific()) {
                return true;
            }
            if (this.arguments.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ArgumentListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ArgumentListSyntax = ArgumentListSyntax;

    var BinaryExpressionSyntax = (function (_super) {
        __extends(BinaryExpressionSyntax, _super);
        function BinaryExpressionSyntax(kind, left, operatorToken, right, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.left = left;
            this.operatorToken = operatorToken;
            this.right = right;

            this._kind = kind;
        }
        BinaryExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitBinaryExpression(this);
        };

        BinaryExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        BinaryExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.left;
                case 1:
                    return this.operatorToken;
                case 2:
                    return this.right;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        BinaryExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        BinaryExpressionSyntax.prototype.kind = function () {
            return this._kind;
        };

        BinaryExpressionSyntax.prototype.update = function (kind, left, operatorToken, right) {
            if (this._kind === kind && this.left === left && this.operatorToken === operatorToken && this.right === right) {
                return this;
            }

            return new BinaryExpressionSyntax(kind, left, operatorToken, right, this.parsedInStrictMode());
        };

        BinaryExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        BinaryExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        BinaryExpressionSyntax.prototype.withKind = function (kind) {
            return this.update(kind, this.left, this.operatorToken, this.right);
        };

        BinaryExpressionSyntax.prototype.withLeft = function (left) {
            return this.update(this._kind, left, this.operatorToken, this.right);
        };

        BinaryExpressionSyntax.prototype.withOperatorToken = function (operatorToken) {
            return this.update(this._kind, this.left, operatorToken, this.right);
        };

        BinaryExpressionSyntax.prototype.withRight = function (right) {
            return this.update(this._kind, this.left, this.operatorToken, right);
        };

        BinaryExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.left.isTypeScriptSpecific()) {
                return true;
            }
            if (this.right.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return BinaryExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.BinaryExpressionSyntax = BinaryExpressionSyntax;

    var ConditionalExpressionSyntax = (function (_super) {
        __extends(ConditionalExpressionSyntax, _super);
        function ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.condition = condition;
            this.questionToken = questionToken;
            this.whenTrue = whenTrue;
            this.colonToken = colonToken;
            this.whenFalse = whenFalse;
        }
        ConditionalExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitConditionalExpression(this);
        };

        ConditionalExpressionSyntax.prototype.kind = function () {
            return 186 /* ConditionalExpression */;
        };

        ConditionalExpressionSyntax.prototype.childCount = function () {
            return 5;
        };

        ConditionalExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.condition;
                case 1:
                    return this.questionToken;
                case 2:
                    return this.whenTrue;
                case 3:
                    return this.colonToken;
                case 4:
                    return this.whenFalse;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConditionalExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ConditionalExpressionSyntax.prototype.update = function (condition, questionToken, whenTrue, colonToken, whenFalse) {
            if (this.condition === condition && this.questionToken === questionToken && this.whenTrue === whenTrue && this.colonToken === colonToken && this.whenFalse === whenFalse) {
                return this;
            }

            return new ConditionalExpressionSyntax(condition, questionToken, whenTrue, colonToken, whenFalse, this.parsedInStrictMode());
        };

        ConditionalExpressionSyntax.create1 = function (condition, whenTrue, whenFalse) {
            return new ConditionalExpressionSyntax(condition, TypeScript.Syntax.token(105 /* QuestionToken */), whenTrue, TypeScript.Syntax.token(106 /* ColonToken */), whenFalse, false);
        };

        ConditionalExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConditionalExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConditionalExpressionSyntax.prototype.withCondition = function (condition) {
            return this.update(condition, this.questionToken, this.whenTrue, this.colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.condition, questionToken, this.whenTrue, this.colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withWhenTrue = function (whenTrue) {
            return this.update(this.condition, this.questionToken, whenTrue, this.colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.condition, this.questionToken, this.whenTrue, colonToken, this.whenFalse);
        };

        ConditionalExpressionSyntax.prototype.withWhenFalse = function (whenFalse) {
            return this.update(this.condition, this.questionToken, this.whenTrue, this.colonToken, whenFalse);
        };

        ConditionalExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.whenTrue.isTypeScriptSpecific()) {
                return true;
            }
            if (this.whenFalse.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ConditionalExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConditionalExpressionSyntax = ConditionalExpressionSyntax;

    var ConstructSignatureSyntax = (function (_super) {
        __extends(ConstructSignatureSyntax, _super);
        function ConstructSignatureSyntax(newKeyword, callSignature, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.newKeyword = newKeyword;
            this.callSignature = callSignature;
        }
        ConstructSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstructSignature(this);
        };

        ConstructSignatureSyntax.prototype.kind = function () {
            return 143 /* ConstructSignature */;
        };

        ConstructSignatureSyntax.prototype.childCount = function () {
            return 2;
        };

        ConstructSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.newKeyword;
                case 1:
                    return this.callSignature;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstructSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        ConstructSignatureSyntax.prototype.update = function (newKeyword, callSignature) {
            if (this.newKeyword === newKeyword && this.callSignature === callSignature) {
                return this;
            }

            return new ConstructSignatureSyntax(newKeyword, callSignature, this.parsedInStrictMode());
        };

        ConstructSignatureSyntax.create1 = function () {
            return new ConstructSignatureSyntax(TypeScript.Syntax.token(31 /* NewKeyword */), CallSignatureSyntax.create1(), false);
        };

        ConstructSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstructSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstructSignatureSyntax.prototype.withNewKeyword = function (newKeyword) {
            return this.update(newKeyword, this.callSignature);
        };

        ConstructSignatureSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.newKeyword, callSignature);
        };

        ConstructSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstructSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstructSignatureSyntax = ConstructSignatureSyntax;

    var MethodSignatureSyntax = (function (_super) {
        __extends(MethodSignatureSyntax, _super);
        function MethodSignatureSyntax(propertyName, questionToken, callSignature, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.questionToken = questionToken;
            this.callSignature = callSignature;
        }
        MethodSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitMethodSignature(this);
        };

        MethodSignatureSyntax.prototype.kind = function () {
            return 145 /* MethodSignature */;
        };

        MethodSignatureSyntax.prototype.childCount = function () {
            return 3;
        };

        MethodSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.questionToken;
                case 2:
                    return this.callSignature;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MethodSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        MethodSignatureSyntax.prototype.update = function (propertyName, questionToken, callSignature) {
            if (this.propertyName === propertyName && this.questionToken === questionToken && this.callSignature === callSignature) {
                return this;
            }

            return new MethodSignatureSyntax(propertyName, questionToken, callSignature, this.parsedInStrictMode());
        };

        MethodSignatureSyntax.create = function (propertyName, callSignature) {
            return new MethodSignatureSyntax(propertyName, null, callSignature, false);
        };

        MethodSignatureSyntax.create1 = function (propertyName) {
            return new MethodSignatureSyntax(propertyName, null, CallSignatureSyntax.create1(), false);
        };

        MethodSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MethodSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MethodSignatureSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.questionToken, this.callSignature);
        };

        MethodSignatureSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.propertyName, questionToken, this.callSignature);
        };

        MethodSignatureSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.propertyName, this.questionToken, callSignature);
        };

        MethodSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return MethodSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MethodSignatureSyntax = MethodSignatureSyntax;

    var IndexSignatureSyntax = (function (_super) {
        __extends(IndexSignatureSyntax, _super);
        function IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBracketToken = openBracketToken;
            this.parameter = parameter;
            this.closeBracketToken = closeBracketToken;
            this.typeAnnotation = typeAnnotation;
        }
        IndexSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitIndexSignature(this);
        };

        IndexSignatureSyntax.prototype.kind = function () {
            return 144 /* IndexSignature */;
        };

        IndexSignatureSyntax.prototype.childCount = function () {
            return 4;
        };

        IndexSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBracketToken;
                case 1:
                    return this.parameter;
                case 2:
                    return this.closeBracketToken;
                case 3:
                    return this.typeAnnotation;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        IndexSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        IndexSignatureSyntax.prototype.update = function (openBracketToken, parameter, closeBracketToken, typeAnnotation) {
            if (this.openBracketToken === openBracketToken && this.parameter === parameter && this.closeBracketToken === closeBracketToken && this.typeAnnotation === typeAnnotation) {
                return this;
            }

            return new IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, typeAnnotation, this.parsedInStrictMode());
        };

        IndexSignatureSyntax.create = function (openBracketToken, parameter, closeBracketToken) {
            return new IndexSignatureSyntax(openBracketToken, parameter, closeBracketToken, null, false);
        };

        IndexSignatureSyntax.create1 = function (parameter) {
            return new IndexSignatureSyntax(TypeScript.Syntax.token(74 /* OpenBracketToken */), parameter, TypeScript.Syntax.token(75 /* CloseBracketToken */), null, false);
        };

        IndexSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        IndexSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        IndexSignatureSyntax.prototype.withOpenBracketToken = function (openBracketToken) {
            return this.update(openBracketToken, this.parameter, this.closeBracketToken, this.typeAnnotation);
        };

        IndexSignatureSyntax.prototype.withParameter = function (parameter) {
            return this.update(this.openBracketToken, parameter, this.closeBracketToken, this.typeAnnotation);
        };

        IndexSignatureSyntax.prototype.withCloseBracketToken = function (closeBracketToken) {
            return this.update(this.openBracketToken, this.parameter, closeBracketToken, this.typeAnnotation);
        };

        IndexSignatureSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.openBracketToken, this.parameter, this.closeBracketToken, typeAnnotation);
        };

        IndexSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return IndexSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.IndexSignatureSyntax = IndexSignatureSyntax;

    var PropertySignatureSyntax = (function (_super) {
        __extends(PropertySignatureSyntax, _super);
        function PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.questionToken = questionToken;
            this.typeAnnotation = typeAnnotation;
        }
        PropertySignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitPropertySignature(this);
        };

        PropertySignatureSyntax.prototype.kind = function () {
            return 141 /* PropertySignature */;
        };

        PropertySignatureSyntax.prototype.childCount = function () {
            return 3;
        };

        PropertySignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.questionToken;
                case 2:
                    return this.typeAnnotation;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        PropertySignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        PropertySignatureSyntax.prototype.update = function (propertyName, questionToken, typeAnnotation) {
            if (this.propertyName === propertyName && this.questionToken === questionToken && this.typeAnnotation === typeAnnotation) {
                return this;
            }

            return new PropertySignatureSyntax(propertyName, questionToken, typeAnnotation, this.parsedInStrictMode());
        };

        PropertySignatureSyntax.create = function (propertyName) {
            return new PropertySignatureSyntax(propertyName, null, null, false);
        };

        PropertySignatureSyntax.create1 = function (propertyName) {
            return new PropertySignatureSyntax(propertyName, null, null, false);
        };

        PropertySignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        PropertySignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        PropertySignatureSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.questionToken, this.typeAnnotation);
        };

        PropertySignatureSyntax.prototype.withQuestionToken = function (questionToken) {
            return this.update(this.propertyName, questionToken, this.typeAnnotation);
        };

        PropertySignatureSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.propertyName, this.questionToken, typeAnnotation);
        };

        PropertySignatureSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return PropertySignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.PropertySignatureSyntax = PropertySignatureSyntax;

    var CallSignatureSyntax = (function (_super) {
        __extends(CallSignatureSyntax, _super);
        function CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeParameterList = typeParameterList;
            this.parameterList = parameterList;
            this.typeAnnotation = typeAnnotation;
        }
        CallSignatureSyntax.prototype.accept = function (visitor) {
            return visitor.visitCallSignature(this);
        };

        CallSignatureSyntax.prototype.kind = function () {
            return 142 /* CallSignature */;
        };

        CallSignatureSyntax.prototype.childCount = function () {
            return 3;
        };

        CallSignatureSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeParameterList;
                case 1:
                    return this.parameterList;
                case 2:
                    return this.typeAnnotation;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CallSignatureSyntax.prototype.isTypeMember = function () {
            return true;
        };

        CallSignatureSyntax.prototype.update = function (typeParameterList, parameterList, typeAnnotation) {
            if (this.typeParameterList === typeParameterList && this.parameterList === parameterList && this.typeAnnotation === typeAnnotation) {
                return this;
            }

            return new CallSignatureSyntax(typeParameterList, parameterList, typeAnnotation, this.parsedInStrictMode());
        };

        CallSignatureSyntax.create = function (parameterList) {
            return new CallSignatureSyntax(null, parameterList, null, false);
        };

        CallSignatureSyntax.create1 = function () {
            return new CallSignatureSyntax(null, ParameterListSyntax.create1(), null, false);
        };

        CallSignatureSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CallSignatureSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CallSignatureSyntax.prototype.withTypeParameterList = function (typeParameterList) {
            return this.update(typeParameterList, this.parameterList, this.typeAnnotation);
        };

        CallSignatureSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.typeParameterList, parameterList, this.typeAnnotation);
        };

        CallSignatureSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.typeParameterList, this.parameterList, typeAnnotation);
        };

        CallSignatureSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeParameterList !== null) {
                return true;
            }
            if (this.parameterList.isTypeScriptSpecific()) {
                return true;
            }
            if (this.typeAnnotation !== null) {
                return true;
            }
            return false;
        };
        return CallSignatureSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.CallSignatureSyntax = CallSignatureSyntax;

    var ParameterListSyntax = (function (_super) {
        __extends(ParameterListSyntax, _super);
        function ParameterListSyntax(openParenToken, parameters, closeParenToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openParenToken = openParenToken;
            this.parameters = parameters;
            this.closeParenToken = closeParenToken;
        }
        ParameterListSyntax.prototype.accept = function (visitor) {
            return visitor.visitParameterList(this);
        };

        ParameterListSyntax.prototype.kind = function () {
            return 227 /* ParameterList */;
        };

        ParameterListSyntax.prototype.childCount = function () {
            return 3;
        };

        ParameterListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openParenToken;
                case 1:
                    return this.parameters;
                case 2:
                    return this.closeParenToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ParameterListSyntax.prototype.update = function (openParenToken, parameters, closeParenToken) {
            if (this.openParenToken === openParenToken && this.parameters === parameters && this.closeParenToken === closeParenToken) {
                return this;
            }

            return new ParameterListSyntax(openParenToken, parameters, closeParenToken, this.parsedInStrictMode());
        };

        ParameterListSyntax.create = function (openParenToken, closeParenToken) {
            return new ParameterListSyntax(openParenToken, TypeScript.Syntax.emptySeparatedList, closeParenToken, false);
        };

        ParameterListSyntax.create1 = function () {
            return new ParameterListSyntax(TypeScript.Syntax.token(72 /* OpenParenToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(73 /* CloseParenToken */), false);
        };

        ParameterListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ParameterListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ParameterListSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(openParenToken, this.parameters, this.closeParenToken);
        };

        ParameterListSyntax.prototype.withParameters = function (parameters) {
            return this.update(this.openParenToken, parameters, this.closeParenToken);
        };

        ParameterListSyntax.prototype.withParameter = function (parameter) {
            return this.withParameters(TypeScript.Syntax.separatedList([parameter]));
        };

        ParameterListSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.openParenToken, this.parameters, closeParenToken);
        };

        ParameterListSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.parameters.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ParameterListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ParameterListSyntax = ParameterListSyntax;

    var TypeParameterListSyntax = (function (_super) {
        __extends(TypeParameterListSyntax, _super);
        function TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.lessThanToken = lessThanToken;
            this.typeParameters = typeParameters;
            this.greaterThanToken = greaterThanToken;
        }
        TypeParameterListSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeParameterList(this);
        };

        TypeParameterListSyntax.prototype.kind = function () {
            return 229 /* TypeParameterList */;
        };

        TypeParameterListSyntax.prototype.childCount = function () {
            return 3;
        };

        TypeParameterListSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.lessThanToken;
                case 1:
                    return this.typeParameters;
                case 2:
                    return this.greaterThanToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeParameterListSyntax.prototype.update = function (lessThanToken, typeParameters, greaterThanToken) {
            if (this.lessThanToken === lessThanToken && this.typeParameters === typeParameters && this.greaterThanToken === greaterThanToken) {
                return this;
            }

            return new TypeParameterListSyntax(lessThanToken, typeParameters, greaterThanToken, this.parsedInStrictMode());
        };

        TypeParameterListSyntax.create = function (lessThanToken, greaterThanToken) {
            return new TypeParameterListSyntax(lessThanToken, TypeScript.Syntax.emptySeparatedList, greaterThanToken, false);
        };

        TypeParameterListSyntax.create1 = function () {
            return new TypeParameterListSyntax(TypeScript.Syntax.token(80 /* LessThanToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(81 /* GreaterThanToken */), false);
        };

        TypeParameterListSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeParameterListSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeParameterListSyntax.prototype.withLessThanToken = function (lessThanToken) {
            return this.update(lessThanToken, this.typeParameters, this.greaterThanToken);
        };

        TypeParameterListSyntax.prototype.withTypeParameters = function (typeParameters) {
            return this.update(this.lessThanToken, typeParameters, this.greaterThanToken);
        };

        TypeParameterListSyntax.prototype.withTypeParameter = function (typeParameter) {
            return this.withTypeParameters(TypeScript.Syntax.separatedList([typeParameter]));
        };

        TypeParameterListSyntax.prototype.withGreaterThanToken = function (greaterThanToken) {
            return this.update(this.lessThanToken, this.typeParameters, greaterThanToken);
        };

        TypeParameterListSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeParameterListSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeParameterListSyntax = TypeParameterListSyntax;

    var TypeParameterSyntax = (function (_super) {
        __extends(TypeParameterSyntax, _super);
        function TypeParameterSyntax(identifier, constraint, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.identifier = identifier;
            this.constraint = constraint;
        }
        TypeParameterSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeParameter(this);
        };

        TypeParameterSyntax.prototype.kind = function () {
            return 238 /* TypeParameter */;
        };

        TypeParameterSyntax.prototype.childCount = function () {
            return 2;
        };

        TypeParameterSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.identifier;
                case 1:
                    return this.constraint;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeParameterSyntax.prototype.update = function (identifier, constraint) {
            if (this.identifier === identifier && this.constraint === constraint) {
                return this;
            }

            return new TypeParameterSyntax(identifier, constraint, this.parsedInStrictMode());
        };

        TypeParameterSyntax.create = function (identifier) {
            return new TypeParameterSyntax(identifier, null, false);
        };

        TypeParameterSyntax.create1 = function (identifier) {
            return new TypeParameterSyntax(identifier, null, false);
        };

        TypeParameterSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeParameterSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeParameterSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(identifier, this.constraint);
        };

        TypeParameterSyntax.prototype.withConstraint = function (constraint) {
            return this.update(this.identifier, constraint);
        };

        TypeParameterSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return TypeParameterSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeParameterSyntax = TypeParameterSyntax;

    var ConstraintSyntax = (function (_super) {
        __extends(ConstraintSyntax, _super);
        function ConstraintSyntax(extendsKeyword, type, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.extendsKeyword = extendsKeyword;
            this.type = type;
        }
        ConstraintSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstraint(this);
        };

        ConstraintSyntax.prototype.kind = function () {
            return 239 /* Constraint */;
        };

        ConstraintSyntax.prototype.childCount = function () {
            return 2;
        };

        ConstraintSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.extendsKeyword;
                case 1:
                    return this.type;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstraintSyntax.prototype.update = function (extendsKeyword, type) {
            if (this.extendsKeyword === extendsKeyword && this.type === type) {
                return this;
            }

            return new ConstraintSyntax(extendsKeyword, type, this.parsedInStrictMode());
        };

        ConstraintSyntax.create1 = function (type) {
            return new ConstraintSyntax(TypeScript.Syntax.token(48 /* ExtendsKeyword */), type, false);
        };

        ConstraintSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstraintSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstraintSyntax.prototype.withExtendsKeyword = function (extendsKeyword) {
            return this.update(extendsKeyword, this.type);
        };

        ConstraintSyntax.prototype.withType = function (type) {
            return this.update(this.extendsKeyword, type);
        };

        ConstraintSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstraintSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstraintSyntax = ConstraintSyntax;

    var ElseClauseSyntax = (function (_super) {
        __extends(ElseClauseSyntax, _super);
        function ElseClauseSyntax(elseKeyword, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.elseKeyword = elseKeyword;
            this.statement = statement;
        }
        ElseClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitElseClause(this);
        };

        ElseClauseSyntax.prototype.kind = function () {
            return 235 /* ElseClause */;
        };

        ElseClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        ElseClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.elseKeyword;
                case 1:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ElseClauseSyntax.prototype.update = function (elseKeyword, statement) {
            if (this.elseKeyword === elseKeyword && this.statement === statement) {
                return this;
            }

            return new ElseClauseSyntax(elseKeyword, statement, this.parsedInStrictMode());
        };

        ElseClauseSyntax.create1 = function (statement) {
            return new ElseClauseSyntax(TypeScript.Syntax.token(23 /* ElseKeyword */), statement, false);
        };

        ElseClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ElseClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ElseClauseSyntax.prototype.withElseKeyword = function (elseKeyword) {
            return this.update(elseKeyword, this.statement);
        };

        ElseClauseSyntax.prototype.withStatement = function (statement) {
            return this.update(this.elseKeyword, statement);
        };

        ElseClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ElseClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ElseClauseSyntax = ElseClauseSyntax;

    var IfStatementSyntax = (function (_super) {
        __extends(IfStatementSyntax, _super);
        function IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.ifKeyword = ifKeyword;
            this.openParenToken = openParenToken;
            this.condition = condition;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
            this.elseClause = elseClause;
        }
        IfStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitIfStatement(this);
        };

        IfStatementSyntax.prototype.kind = function () {
            return 147 /* IfStatement */;
        };

        IfStatementSyntax.prototype.childCount = function () {
            return 6;
        };

        IfStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.ifKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.condition;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.statement;
                case 5:
                    return this.elseClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        IfStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        IfStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        IfStatementSyntax.prototype.update = function (ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause) {
            if (this.ifKeyword === ifKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.statement === statement && this.elseClause === elseClause) {
                return this;
            }

            return new IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, elseClause, this.parsedInStrictMode());
        };

        IfStatementSyntax.create = function (ifKeyword, openParenToken, condition, closeParenToken, statement) {
            return new IfStatementSyntax(ifKeyword, openParenToken, condition, closeParenToken, statement, null, false);
        };

        IfStatementSyntax.create1 = function (condition, statement) {
            return new IfStatementSyntax(TypeScript.Syntax.token(28 /* IfKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), condition, TypeScript.Syntax.token(73 /* CloseParenToken */), statement, null, false);
        };

        IfStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        IfStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        IfStatementSyntax.prototype.withIfKeyword = function (ifKeyword) {
            return this.update(ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.ifKeyword, openParenToken, this.condition, this.closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.ifKeyword, this.openParenToken, condition, this.closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.ifKeyword, this.openParenToken, this.condition, closeParenToken, this.statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, statement, this.elseClause);
        };

        IfStatementSyntax.prototype.withElseClause = function (elseClause) {
            return this.update(this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, elseClause);
        };

        IfStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            if (this.elseClause !== null && this.elseClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return IfStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.IfStatementSyntax = IfStatementSyntax;

    var ExpressionStatementSyntax = (function (_super) {
        __extends(ExpressionStatementSyntax, _super);
        function ExpressionStatementSyntax(expression, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.expression = expression;
            this.semicolonToken = semicolonToken;
        }
        ExpressionStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitExpressionStatement(this);
        };

        ExpressionStatementSyntax.prototype.kind = function () {
            return 149 /* ExpressionStatement */;
        };

        ExpressionStatementSyntax.prototype.childCount = function () {
            return 2;
        };

        ExpressionStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.expression;
                case 1:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ExpressionStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ExpressionStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ExpressionStatementSyntax.prototype.update = function (expression, semicolonToken) {
            if (this.expression === expression && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ExpressionStatementSyntax(expression, semicolonToken, this.parsedInStrictMode());
        };

        ExpressionStatementSyntax.create1 = function (expression) {
            return new ExpressionStatementSyntax(expression, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        ExpressionStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ExpressionStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ExpressionStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(expression, this.semicolonToken);
        };

        ExpressionStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.expression, semicolonToken);
        };

        ExpressionStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ExpressionStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ExpressionStatementSyntax = ExpressionStatementSyntax;

    var ConstructorDeclarationSyntax = (function (_super) {
        __extends(ConstructorDeclarationSyntax, _super);
        function ConstructorDeclarationSyntax(modifiers, constructorKeyword, callSignature, block, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.constructorKeyword = constructorKeyword;
            this.callSignature = callSignature;
            this.block = block;
            this.semicolonToken = semicolonToken;
        }
        ConstructorDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitConstructorDeclaration(this);
        };

        ConstructorDeclarationSyntax.prototype.kind = function () {
            return 137 /* ConstructorDeclaration */;
        };

        ConstructorDeclarationSyntax.prototype.childCount = function () {
            return 5;
        };

        ConstructorDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.constructorKeyword;
                case 2:
                    return this.callSignature;
                case 3:
                    return this.block;
                case 4:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ConstructorDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        ConstructorDeclarationSyntax.prototype.update = function (modifiers, constructorKeyword, callSignature, block, semicolonToken) {
            if (this.modifiers === modifiers && this.constructorKeyword === constructorKeyword && this.callSignature === callSignature && this.block === block && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ConstructorDeclarationSyntax(modifiers, constructorKeyword, callSignature, block, semicolonToken, this.parsedInStrictMode());
        };

        ConstructorDeclarationSyntax.create = function (constructorKeyword, callSignature) {
            return new ConstructorDeclarationSyntax(TypeScript.Syntax.emptyList, constructorKeyword, callSignature, null, null, false);
        };

        ConstructorDeclarationSyntax.create1 = function () {
            return new ConstructorDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(62 /* ConstructorKeyword */), CallSignatureSyntax.create1(), null, null, false);
        };

        ConstructorDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ConstructorDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ConstructorDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.constructorKeyword, this.callSignature, this.block, this.semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        ConstructorDeclarationSyntax.prototype.withConstructorKeyword = function (constructorKeyword) {
            return this.update(this.modifiers, constructorKeyword, this.callSignature, this.block, this.semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.modifiers, this.constructorKeyword, callSignature, this.block, this.semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.constructorKeyword, this.callSignature, block, this.semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.constructorKeyword, this.callSignature, this.block, semicolonToken);
        };

        ConstructorDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return ConstructorDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ConstructorDeclarationSyntax = ConstructorDeclarationSyntax;

    var MemberFunctionDeclarationSyntax = (function (_super) {
        __extends(MemberFunctionDeclarationSyntax, _super);
        function MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.propertyName = propertyName;
            this.callSignature = callSignature;
            this.block = block;
            this.semicolonToken = semicolonToken;
        }
        MemberFunctionDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitMemberFunctionDeclaration(this);
        };

        MemberFunctionDeclarationSyntax.prototype.kind = function () {
            return 135 /* MemberFunctionDeclaration */;
        };

        MemberFunctionDeclarationSyntax.prototype.childCount = function () {
            return 5;
        };

        MemberFunctionDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.propertyName;
                case 2:
                    return this.callSignature;
                case 3:
                    return this.block;
                case 4:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MemberFunctionDeclarationSyntax.prototype.isMemberDeclaration = function () {
            return true;
        };

        MemberFunctionDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        MemberFunctionDeclarationSyntax.prototype.update = function (modifiers, propertyName, callSignature, block, semicolonToken) {
            if (this.modifiers === modifiers && this.propertyName === propertyName && this.callSignature === callSignature && this.block === block && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new MemberFunctionDeclarationSyntax(modifiers, propertyName, callSignature, block, semicolonToken, this.parsedInStrictMode());
        };

        MemberFunctionDeclarationSyntax.create = function (propertyName, callSignature) {
            return new MemberFunctionDeclarationSyntax(TypeScript.Syntax.emptyList, propertyName, callSignature, null, null, false);
        };

        MemberFunctionDeclarationSyntax.create1 = function (propertyName) {
            return new MemberFunctionDeclarationSyntax(TypeScript.Syntax.emptyList, propertyName, CallSignatureSyntax.create1(), null, null, false);
        };

        MemberFunctionDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MemberFunctionDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MemberFunctionDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.propertyName, this.callSignature, this.block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        MemberFunctionDeclarationSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.modifiers, propertyName, this.callSignature, this.block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.modifiers, this.propertyName, callSignature, this.block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.propertyName, this.callSignature, block, this.semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.propertyName, this.callSignature, this.block, semicolonToken);
        };

        MemberFunctionDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return MemberFunctionDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MemberFunctionDeclarationSyntax = MemberFunctionDeclarationSyntax;

    var GetAccessorSyntax = (function (_super) {
        __extends(GetAccessorSyntax, _super);
        function GetAccessorSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.getKeyword = getKeyword;
            this.propertyName = propertyName;
            this.parameterList = parameterList;
            this.typeAnnotation = typeAnnotation;
            this.block = block;
        }
        GetAccessorSyntax.prototype.accept = function (visitor) {
            return visitor.visitGetAccessor(this);
        };

        GetAccessorSyntax.prototype.kind = function () {
            return 139 /* GetAccessor */;
        };

        GetAccessorSyntax.prototype.childCount = function () {
            return 6;
        };

        GetAccessorSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.getKeyword;
                case 2:
                    return this.propertyName;
                case 3:
                    return this.parameterList;
                case 4:
                    return this.typeAnnotation;
                case 5:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        GetAccessorSyntax.prototype.isMemberDeclaration = function () {
            return true;
        };

        GetAccessorSyntax.prototype.isPropertyAssignment = function () {
            return true;
        };

        GetAccessorSyntax.prototype.isClassElement = function () {
            return true;
        };

        GetAccessorSyntax.prototype.update = function (modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block) {
            if (this.modifiers === modifiers && this.getKeyword === getKeyword && this.propertyName === propertyName && this.parameterList === parameterList && this.typeAnnotation === typeAnnotation && this.block === block) {
                return this;
            }

            return new GetAccessorSyntax(modifiers, getKeyword, propertyName, parameterList, typeAnnotation, block, this.parsedInStrictMode());
        };

        GetAccessorSyntax.create = function (getKeyword, propertyName, parameterList, block) {
            return new GetAccessorSyntax(TypeScript.Syntax.emptyList, getKeyword, propertyName, parameterList, null, block, false);
        };

        GetAccessorSyntax.create1 = function (propertyName) {
            return new GetAccessorSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(64 /* GetKeyword */), propertyName, ParameterListSyntax.create1(), null, BlockSyntax.create1(), false);
        };

        GetAccessorSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        GetAccessorSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        GetAccessorSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.getKeyword, this.propertyName, this.parameterList, this.typeAnnotation, this.block);
        };

        GetAccessorSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        GetAccessorSyntax.prototype.withGetKeyword = function (getKeyword) {
            return this.update(this.modifiers, getKeyword, this.propertyName, this.parameterList, this.typeAnnotation, this.block);
        };

        GetAccessorSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.modifiers, this.getKeyword, propertyName, this.parameterList, this.typeAnnotation, this.block);
        };

        GetAccessorSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.modifiers, this.getKeyword, this.propertyName, parameterList, this.typeAnnotation, this.block);
        };

        GetAccessorSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.modifiers, this.getKeyword, this.propertyName, this.parameterList, typeAnnotation, this.block);
        };

        GetAccessorSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.getKeyword, this.propertyName, this.parameterList, this.typeAnnotation, block);
        };

        GetAccessorSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.modifiers.childCount() > 0) {
                return true;
            }
            if (this.parameterList.isTypeScriptSpecific()) {
                return true;
            }
            if (this.typeAnnotation !== null) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return GetAccessorSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.GetAccessorSyntax = GetAccessorSyntax;

    var SetAccessorSyntax = (function (_super) {
        __extends(SetAccessorSyntax, _super);
        function SetAccessorSyntax(modifiers, setKeyword, propertyName, parameterList, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.setKeyword = setKeyword;
            this.propertyName = propertyName;
            this.parameterList = parameterList;
            this.block = block;
        }
        SetAccessorSyntax.prototype.accept = function (visitor) {
            return visitor.visitSetAccessor(this);
        };

        SetAccessorSyntax.prototype.kind = function () {
            return 140 /* SetAccessor */;
        };

        SetAccessorSyntax.prototype.childCount = function () {
            return 5;
        };

        SetAccessorSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.setKeyword;
                case 2:
                    return this.propertyName;
                case 3:
                    return this.parameterList;
                case 4:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SetAccessorSyntax.prototype.isMemberDeclaration = function () {
            return true;
        };

        SetAccessorSyntax.prototype.isPropertyAssignment = function () {
            return true;
        };

        SetAccessorSyntax.prototype.isClassElement = function () {
            return true;
        };

        SetAccessorSyntax.prototype.update = function (modifiers, setKeyword, propertyName, parameterList, block) {
            if (this.modifiers === modifiers && this.setKeyword === setKeyword && this.propertyName === propertyName && this.parameterList === parameterList && this.block === block) {
                return this;
            }

            return new SetAccessorSyntax(modifiers, setKeyword, propertyName, parameterList, block, this.parsedInStrictMode());
        };

        SetAccessorSyntax.create = function (setKeyword, propertyName, parameterList, block) {
            return new SetAccessorSyntax(TypeScript.Syntax.emptyList, setKeyword, propertyName, parameterList, block, false);
        };

        SetAccessorSyntax.create1 = function (propertyName) {
            return new SetAccessorSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(68 /* SetKeyword */), propertyName, ParameterListSyntax.create1(), BlockSyntax.create1(), false);
        };

        SetAccessorSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SetAccessorSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SetAccessorSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.setKeyword, this.propertyName, this.parameterList, this.block);
        };

        SetAccessorSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        SetAccessorSyntax.prototype.withSetKeyword = function (setKeyword) {
            return this.update(this.modifiers, setKeyword, this.propertyName, this.parameterList, this.block);
        };

        SetAccessorSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(this.modifiers, this.setKeyword, propertyName, this.parameterList, this.block);
        };

        SetAccessorSyntax.prototype.withParameterList = function (parameterList) {
            return this.update(this.modifiers, this.setKeyword, this.propertyName, parameterList, this.block);
        };

        SetAccessorSyntax.prototype.withBlock = function (block) {
            return this.update(this.modifiers, this.setKeyword, this.propertyName, this.parameterList, block);
        };

        SetAccessorSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return SetAccessorSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SetAccessorSyntax = SetAccessorSyntax;

    var MemberVariableDeclarationSyntax = (function (_super) {
        __extends(MemberVariableDeclarationSyntax, _super);
        function MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.variableDeclarator = variableDeclarator;
            this.semicolonToken = semicolonToken;
        }
        MemberVariableDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitMemberVariableDeclaration(this);
        };

        MemberVariableDeclarationSyntax.prototype.kind = function () {
            return 136 /* MemberVariableDeclaration */;
        };

        MemberVariableDeclarationSyntax.prototype.childCount = function () {
            return 3;
        };

        MemberVariableDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.variableDeclarator;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        MemberVariableDeclarationSyntax.prototype.isMemberDeclaration = function () {
            return true;
        };

        MemberVariableDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        MemberVariableDeclarationSyntax.prototype.update = function (modifiers, variableDeclarator, semicolonToken) {
            if (this.modifiers === modifiers && this.variableDeclarator === variableDeclarator && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new MemberVariableDeclarationSyntax(modifiers, variableDeclarator, semicolonToken, this.parsedInStrictMode());
        };

        MemberVariableDeclarationSyntax.create = function (variableDeclarator, semicolonToken) {
            return new MemberVariableDeclarationSyntax(TypeScript.Syntax.emptyList, variableDeclarator, semicolonToken, false);
        };

        MemberVariableDeclarationSyntax.create1 = function (variableDeclarator) {
            return new MemberVariableDeclarationSyntax(TypeScript.Syntax.emptyList, variableDeclarator, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        MemberVariableDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        MemberVariableDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        MemberVariableDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.variableDeclarator, this.semicolonToken);
        };

        MemberVariableDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        MemberVariableDeclarationSyntax.prototype.withVariableDeclarator = function (variableDeclarator) {
            return this.update(this.modifiers, variableDeclarator, this.semicolonToken);
        };

        MemberVariableDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.variableDeclarator, semicolonToken);
        };

        MemberVariableDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return MemberVariableDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.MemberVariableDeclarationSyntax = MemberVariableDeclarationSyntax;

    var IndexMemberDeclarationSyntax = (function (_super) {
        __extends(IndexMemberDeclarationSyntax, _super);
        function IndexMemberDeclarationSyntax(modifiers, indexSignature, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.indexSignature = indexSignature;
            this.semicolonToken = semicolonToken;
        }
        IndexMemberDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitIndexMemberDeclaration(this);
        };

        IndexMemberDeclarationSyntax.prototype.kind = function () {
            return 138 /* IndexMemberDeclaration */;
        };

        IndexMemberDeclarationSyntax.prototype.childCount = function () {
            return 3;
        };

        IndexMemberDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.indexSignature;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        IndexMemberDeclarationSyntax.prototype.isClassElement = function () {
            return true;
        };

        IndexMemberDeclarationSyntax.prototype.update = function (modifiers, indexSignature, semicolonToken) {
            if (this.modifiers === modifiers && this.indexSignature === indexSignature && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new IndexMemberDeclarationSyntax(modifiers, indexSignature, semicolonToken, this.parsedInStrictMode());
        };

        IndexMemberDeclarationSyntax.create = function (indexSignature, semicolonToken) {
            return new IndexMemberDeclarationSyntax(TypeScript.Syntax.emptyList, indexSignature, semicolonToken, false);
        };

        IndexMemberDeclarationSyntax.create1 = function (indexSignature) {
            return new IndexMemberDeclarationSyntax(TypeScript.Syntax.emptyList, indexSignature, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        IndexMemberDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        IndexMemberDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        IndexMemberDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.indexSignature, this.semicolonToken);
        };

        IndexMemberDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        IndexMemberDeclarationSyntax.prototype.withIndexSignature = function (indexSignature) {
            return this.update(this.modifiers, indexSignature, this.semicolonToken);
        };

        IndexMemberDeclarationSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.modifiers, this.indexSignature, semicolonToken);
        };

        IndexMemberDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return IndexMemberDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.IndexMemberDeclarationSyntax = IndexMemberDeclarationSyntax;

    var ThrowStatementSyntax = (function (_super) {
        __extends(ThrowStatementSyntax, _super);
        function ThrowStatementSyntax(throwKeyword, expression, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.throwKeyword = throwKeyword;
            this.expression = expression;
            this.semicolonToken = semicolonToken;
        }
        ThrowStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitThrowStatement(this);
        };

        ThrowStatementSyntax.prototype.kind = function () {
            return 157 /* ThrowStatement */;
        };

        ThrowStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        ThrowStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.throwKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ThrowStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ThrowStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ThrowStatementSyntax.prototype.update = function (throwKeyword, expression, semicolonToken) {
            if (this.throwKeyword === throwKeyword && this.expression === expression && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ThrowStatementSyntax(throwKeyword, expression, semicolonToken, this.parsedInStrictMode());
        };

        ThrowStatementSyntax.create1 = function (expression) {
            return new ThrowStatementSyntax(TypeScript.Syntax.token(36 /* ThrowKeyword */), expression, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        ThrowStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ThrowStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ThrowStatementSyntax.prototype.withThrowKeyword = function (throwKeyword) {
            return this.update(throwKeyword, this.expression, this.semicolonToken);
        };

        ThrowStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.throwKeyword, expression, this.semicolonToken);
        };

        ThrowStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.throwKeyword, this.expression, semicolonToken);
        };

        ThrowStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ThrowStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ThrowStatementSyntax = ThrowStatementSyntax;

    var ReturnStatementSyntax = (function (_super) {
        __extends(ReturnStatementSyntax, _super);
        function ReturnStatementSyntax(returnKeyword, expression, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.returnKeyword = returnKeyword;
            this.expression = expression;
            this.semicolonToken = semicolonToken;
        }
        ReturnStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitReturnStatement(this);
        };

        ReturnStatementSyntax.prototype.kind = function () {
            return 150 /* ReturnStatement */;
        };

        ReturnStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        ReturnStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.returnKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ReturnStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ReturnStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ReturnStatementSyntax.prototype.update = function (returnKeyword, expression, semicolonToken) {
            if (this.returnKeyword === returnKeyword && this.expression === expression && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ReturnStatementSyntax(returnKeyword, expression, semicolonToken, this.parsedInStrictMode());
        };

        ReturnStatementSyntax.create = function (returnKeyword, semicolonToken) {
            return new ReturnStatementSyntax(returnKeyword, null, semicolonToken, false);
        };

        ReturnStatementSyntax.create1 = function () {
            return new ReturnStatementSyntax(TypeScript.Syntax.token(33 /* ReturnKeyword */), null, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        ReturnStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ReturnStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ReturnStatementSyntax.prototype.withReturnKeyword = function (returnKeyword) {
            return this.update(returnKeyword, this.expression, this.semicolonToken);
        };

        ReturnStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.returnKeyword, expression, this.semicolonToken);
        };

        ReturnStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.returnKeyword, this.expression, semicolonToken);
        };

        ReturnStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression !== null && this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ReturnStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ReturnStatementSyntax = ReturnStatementSyntax;

    var ObjectCreationExpressionSyntax = (function (_super) {
        __extends(ObjectCreationExpressionSyntax, _super);
        function ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.newKeyword = newKeyword;
            this.expression = expression;
            this.argumentList = argumentList;
        }
        ObjectCreationExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitObjectCreationExpression(this);
        };

        ObjectCreationExpressionSyntax.prototype.kind = function () {
            return 216 /* ObjectCreationExpression */;
        };

        ObjectCreationExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ObjectCreationExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.newKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.argumentList;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ObjectCreationExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        ObjectCreationExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        ObjectCreationExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ObjectCreationExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ObjectCreationExpressionSyntax.prototype.update = function (newKeyword, expression, argumentList) {
            if (this.newKeyword === newKeyword && this.expression === expression && this.argumentList === argumentList) {
                return this;
            }

            return new ObjectCreationExpressionSyntax(newKeyword, expression, argumentList, this.parsedInStrictMode());
        };

        ObjectCreationExpressionSyntax.create = function (newKeyword, expression) {
            return new ObjectCreationExpressionSyntax(newKeyword, expression, null, false);
        };

        ObjectCreationExpressionSyntax.create1 = function (expression) {
            return new ObjectCreationExpressionSyntax(TypeScript.Syntax.token(31 /* NewKeyword */), expression, null, false);
        };

        ObjectCreationExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ObjectCreationExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ObjectCreationExpressionSyntax.prototype.withNewKeyword = function (newKeyword) {
            return this.update(newKeyword, this.expression, this.argumentList);
        };

        ObjectCreationExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.newKeyword, expression, this.argumentList);
        };

        ObjectCreationExpressionSyntax.prototype.withArgumentList = function (argumentList) {
            return this.update(this.newKeyword, this.expression, argumentList);
        };

        ObjectCreationExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.argumentList !== null && this.argumentList.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ObjectCreationExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ObjectCreationExpressionSyntax = ObjectCreationExpressionSyntax;

    var SwitchStatementSyntax = (function (_super) {
        __extends(SwitchStatementSyntax, _super);
        function SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.switchKeyword = switchKeyword;
            this.openParenToken = openParenToken;
            this.expression = expression;
            this.closeParenToken = closeParenToken;
            this.openBraceToken = openBraceToken;
            this.switchClauses = switchClauses;
            this.closeBraceToken = closeBraceToken;
        }
        SwitchStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitSwitchStatement(this);
        };

        SwitchStatementSyntax.prototype.kind = function () {
            return 151 /* SwitchStatement */;
        };

        SwitchStatementSyntax.prototype.childCount = function () {
            return 7;
        };

        SwitchStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.switchKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.expression;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.openBraceToken;
                case 5:
                    return this.switchClauses;
                case 6:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SwitchStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        SwitchStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        SwitchStatementSyntax.prototype.update = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken) {
            if (this.switchKeyword === switchKeyword && this.openParenToken === openParenToken && this.expression === expression && this.closeParenToken === closeParenToken && this.openBraceToken === openBraceToken && this.switchClauses === switchClauses && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, switchClauses, closeBraceToken, this.parsedInStrictMode());
        };

        SwitchStatementSyntax.create = function (switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, closeBraceToken) {
            return new SwitchStatementSyntax(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, TypeScript.Syntax.emptyList, closeBraceToken, false);
        };

        SwitchStatementSyntax.create1 = function (expression) {
            return new SwitchStatementSyntax(TypeScript.Syntax.token(34 /* SwitchKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), expression, TypeScript.Syntax.token(73 /* CloseParenToken */), TypeScript.Syntax.token(70 /* OpenBraceToken */), TypeScript.Syntax.emptyList, TypeScript.Syntax.token(71 /* CloseBraceToken */), false);
        };

        SwitchStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SwitchStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SwitchStatementSyntax.prototype.withSwitchKeyword = function (switchKeyword) {
            return this.update(switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.switchKeyword, openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.switchKeyword, this.openParenToken, expression, this.closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, closeParenToken, this.openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, openBraceToken, this.switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withSwitchClauses = function (switchClauses) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, switchClauses, this.closeBraceToken);
        };

        SwitchStatementSyntax.prototype.withSwitchClause = function (switchClause) {
            return this.withSwitchClauses(TypeScript.Syntax.list([switchClause]));
        };

        SwitchStatementSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.switchClauses, closeBraceToken);
        };

        SwitchStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.switchClauses.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return SwitchStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SwitchStatementSyntax = SwitchStatementSyntax;

    var CaseSwitchClauseSyntax = (function (_super) {
        __extends(CaseSwitchClauseSyntax, _super);
        function CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.caseKeyword = caseKeyword;
            this.expression = expression;
            this.colonToken = colonToken;
            this.statements = statements;
        }
        CaseSwitchClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitCaseSwitchClause(this);
        };

        CaseSwitchClauseSyntax.prototype.kind = function () {
            return 233 /* CaseSwitchClause */;
        };

        CaseSwitchClauseSyntax.prototype.childCount = function () {
            return 4;
        };

        CaseSwitchClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.caseKeyword;
                case 1:
                    return this.expression;
                case 2:
                    return this.colonToken;
                case 3:
                    return this.statements;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CaseSwitchClauseSyntax.prototype.isSwitchClause = function () {
            return true;
        };

        CaseSwitchClauseSyntax.prototype.update = function (caseKeyword, expression, colonToken, statements) {
            if (this.caseKeyword === caseKeyword && this.expression === expression && this.colonToken === colonToken && this.statements === statements) {
                return this;
            }

            return new CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, statements, this.parsedInStrictMode());
        };

        CaseSwitchClauseSyntax.create = function (caseKeyword, expression, colonToken) {
            return new CaseSwitchClauseSyntax(caseKeyword, expression, colonToken, TypeScript.Syntax.emptyList, false);
        };

        CaseSwitchClauseSyntax.create1 = function (expression) {
            return new CaseSwitchClauseSyntax(TypeScript.Syntax.token(16 /* CaseKeyword */), expression, TypeScript.Syntax.token(106 /* ColonToken */), TypeScript.Syntax.emptyList, false);
        };

        CaseSwitchClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CaseSwitchClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CaseSwitchClauseSyntax.prototype.withCaseKeyword = function (caseKeyword) {
            return this.update(caseKeyword, this.expression, this.colonToken, this.statements);
        };

        CaseSwitchClauseSyntax.prototype.withExpression = function (expression) {
            return this.update(this.caseKeyword, expression, this.colonToken, this.statements);
        };

        CaseSwitchClauseSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.caseKeyword, this.expression, colonToken, this.statements);
        };

        CaseSwitchClauseSyntax.prototype.withStatements = function (statements) {
            return this.update(this.caseKeyword, this.expression, this.colonToken, statements);
        };

        CaseSwitchClauseSyntax.prototype.withStatement = function (statement) {
            return this.withStatements(TypeScript.Syntax.list([statement]));
        };

        CaseSwitchClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return CaseSwitchClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.CaseSwitchClauseSyntax = CaseSwitchClauseSyntax;

    var DefaultSwitchClauseSyntax = (function (_super) {
        __extends(DefaultSwitchClauseSyntax, _super);
        function DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.defaultKeyword = defaultKeyword;
            this.colonToken = colonToken;
            this.statements = statements;
        }
        DefaultSwitchClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitDefaultSwitchClause(this);
        };

        DefaultSwitchClauseSyntax.prototype.kind = function () {
            return 234 /* DefaultSwitchClause */;
        };

        DefaultSwitchClauseSyntax.prototype.childCount = function () {
            return 3;
        };

        DefaultSwitchClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.defaultKeyword;
                case 1:
                    return this.colonToken;
                case 2:
                    return this.statements;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DefaultSwitchClauseSyntax.prototype.isSwitchClause = function () {
            return true;
        };

        DefaultSwitchClauseSyntax.prototype.update = function (defaultKeyword, colonToken, statements) {
            if (this.defaultKeyword === defaultKeyword && this.colonToken === colonToken && this.statements === statements) {
                return this;
            }

            return new DefaultSwitchClauseSyntax(defaultKeyword, colonToken, statements, this.parsedInStrictMode());
        };

        DefaultSwitchClauseSyntax.create = function (defaultKeyword, colonToken) {
            return new DefaultSwitchClauseSyntax(defaultKeyword, colonToken, TypeScript.Syntax.emptyList, false);
        };

        DefaultSwitchClauseSyntax.create1 = function () {
            return new DefaultSwitchClauseSyntax(TypeScript.Syntax.token(20 /* DefaultKeyword */), TypeScript.Syntax.token(106 /* ColonToken */), TypeScript.Syntax.emptyList, false);
        };

        DefaultSwitchClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DefaultSwitchClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DefaultSwitchClauseSyntax.prototype.withDefaultKeyword = function (defaultKeyword) {
            return this.update(defaultKeyword, this.colonToken, this.statements);
        };

        DefaultSwitchClauseSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.defaultKeyword, colonToken, this.statements);
        };

        DefaultSwitchClauseSyntax.prototype.withStatements = function (statements) {
            return this.update(this.defaultKeyword, this.colonToken, statements);
        };

        DefaultSwitchClauseSyntax.prototype.withStatement = function (statement) {
            return this.withStatements(TypeScript.Syntax.list([statement]));
        };

        DefaultSwitchClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statements.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return DefaultSwitchClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.DefaultSwitchClauseSyntax = DefaultSwitchClauseSyntax;

    var BreakStatementSyntax = (function (_super) {
        __extends(BreakStatementSyntax, _super);
        function BreakStatementSyntax(breakKeyword, identifier, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.breakKeyword = breakKeyword;
            this.identifier = identifier;
            this.semicolonToken = semicolonToken;
        }
        BreakStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitBreakStatement(this);
        };

        BreakStatementSyntax.prototype.kind = function () {
            return 152 /* BreakStatement */;
        };

        BreakStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        BreakStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.breakKeyword;
                case 1:
                    return this.identifier;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        BreakStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        BreakStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        BreakStatementSyntax.prototype.update = function (breakKeyword, identifier, semicolonToken) {
            if (this.breakKeyword === breakKeyword && this.identifier === identifier && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new BreakStatementSyntax(breakKeyword, identifier, semicolonToken, this.parsedInStrictMode());
        };

        BreakStatementSyntax.create = function (breakKeyword, semicolonToken) {
            return new BreakStatementSyntax(breakKeyword, null, semicolonToken, false);
        };

        BreakStatementSyntax.create1 = function () {
            return new BreakStatementSyntax(TypeScript.Syntax.token(15 /* BreakKeyword */), null, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        BreakStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        BreakStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        BreakStatementSyntax.prototype.withBreakKeyword = function (breakKeyword) {
            return this.update(breakKeyword, this.identifier, this.semicolonToken);
        };

        BreakStatementSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.breakKeyword, identifier, this.semicolonToken);
        };

        BreakStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.breakKeyword, this.identifier, semicolonToken);
        };

        BreakStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return BreakStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.BreakStatementSyntax = BreakStatementSyntax;

    var ContinueStatementSyntax = (function (_super) {
        __extends(ContinueStatementSyntax, _super);
        function ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.continueKeyword = continueKeyword;
            this.identifier = identifier;
            this.semicolonToken = semicolonToken;
        }
        ContinueStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitContinueStatement(this);
        };

        ContinueStatementSyntax.prototype.kind = function () {
            return 153 /* ContinueStatement */;
        };

        ContinueStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        ContinueStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.continueKeyword;
                case 1:
                    return this.identifier;
                case 2:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ContinueStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ContinueStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ContinueStatementSyntax.prototype.update = function (continueKeyword, identifier, semicolonToken) {
            if (this.continueKeyword === continueKeyword && this.identifier === identifier && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new ContinueStatementSyntax(continueKeyword, identifier, semicolonToken, this.parsedInStrictMode());
        };

        ContinueStatementSyntax.create = function (continueKeyword, semicolonToken) {
            return new ContinueStatementSyntax(continueKeyword, null, semicolonToken, false);
        };

        ContinueStatementSyntax.create1 = function () {
            return new ContinueStatementSyntax(TypeScript.Syntax.token(18 /* ContinueKeyword */), null, TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        ContinueStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ContinueStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ContinueStatementSyntax.prototype.withContinueKeyword = function (continueKeyword) {
            return this.update(continueKeyword, this.identifier, this.semicolonToken);
        };

        ContinueStatementSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.continueKeyword, identifier, this.semicolonToken);
        };

        ContinueStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.continueKeyword, this.identifier, semicolonToken);
        };

        ContinueStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return ContinueStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ContinueStatementSyntax = ContinueStatementSyntax;

    var ForStatementSyntax = (function (_super) {
        __extends(ForStatementSyntax, _super);
        function ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.forKeyword = forKeyword;
            this.openParenToken = openParenToken;
            this.variableDeclaration = variableDeclaration;
            this.initializer = initializer;
            this.firstSemicolonToken = firstSemicolonToken;
            this.condition = condition;
            this.secondSemicolonToken = secondSemicolonToken;
            this.incrementor = incrementor;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
        }
        ForStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitForStatement(this);
        };

        ForStatementSyntax.prototype.kind = function () {
            return 154 /* ForStatement */;
        };

        ForStatementSyntax.prototype.childCount = function () {
            return 10;
        };

        ForStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.forKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.variableDeclaration;
                case 3:
                    return this.initializer;
                case 4:
                    return this.firstSemicolonToken;
                case 5:
                    return this.condition;
                case 6:
                    return this.secondSemicolonToken;
                case 7:
                    return this.incrementor;
                case 8:
                    return this.closeParenToken;
                case 9:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ForStatementSyntax.prototype.isIterationStatement = function () {
            return true;
        };

        ForStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ForStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ForStatementSyntax.prototype.update = function (forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement) {
            if (this.forKeyword === forKeyword && this.openParenToken === openParenToken && this.variableDeclaration === variableDeclaration && this.initializer === initializer && this.firstSemicolonToken === firstSemicolonToken && this.condition === condition && this.secondSemicolonToken === secondSemicolonToken && this.incrementor === incrementor && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new ForStatementSyntax(forKeyword, openParenToken, variableDeclaration, initializer, firstSemicolonToken, condition, secondSemicolonToken, incrementor, closeParenToken, statement, this.parsedInStrictMode());
        };

        ForStatementSyntax.create = function (forKeyword, openParenToken, firstSemicolonToken, secondSemicolonToken, closeParenToken, statement) {
            return new ForStatementSyntax(forKeyword, openParenToken, null, null, firstSemicolonToken, null, secondSemicolonToken, null, closeParenToken, statement, false);
        };

        ForStatementSyntax.create1 = function (statement) {
            return new ForStatementSyntax(TypeScript.Syntax.token(26 /* ForKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), null, null, TypeScript.Syntax.token(78 /* SemicolonToken */), null, TypeScript.Syntax.token(78 /* SemicolonToken */), null, TypeScript.Syntax.token(73 /* CloseParenToken */), statement, false);
        };

        ForStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ForStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ForStatementSyntax.prototype.withForKeyword = function (forKeyword) {
            return this.update(forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.forKeyword, openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withVariableDeclaration = function (variableDeclaration) {
            return this.update(this.forKeyword, this.openParenToken, variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withInitializer = function (initializer) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withFirstSemicolonToken = function (firstSemicolonToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withSecondSemicolonToken = function (secondSemicolonToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, secondSemicolonToken, this.incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withIncrementor = function (incrementor) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, incrementor, this.closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, closeParenToken, this.statement);
        };

        ForStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.initializer, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementor, this.closeParenToken, statement);
        };

        ForStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.variableDeclaration !== null && this.variableDeclaration.isTypeScriptSpecific()) {
                return true;
            }
            if (this.initializer !== null && this.initializer.isTypeScriptSpecific()) {
                return true;
            }
            if (this.condition !== null && this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.incrementor !== null && this.incrementor.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ForStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ForStatementSyntax = ForStatementSyntax;

    var ForInStatementSyntax = (function (_super) {
        __extends(ForInStatementSyntax, _super);
        function ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.forKeyword = forKeyword;
            this.openParenToken = openParenToken;
            this.variableDeclaration = variableDeclaration;
            this.left = left;
            this.inKeyword = inKeyword;
            this.expression = expression;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
        }
        ForInStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitForInStatement(this);
        };

        ForInStatementSyntax.prototype.kind = function () {
            return 155 /* ForInStatement */;
        };

        ForInStatementSyntax.prototype.childCount = function () {
            return 8;
        };

        ForInStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.forKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.variableDeclaration;
                case 3:
                    return this.left;
                case 4:
                    return this.inKeyword;
                case 5:
                    return this.expression;
                case 6:
                    return this.closeParenToken;
                case 7:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ForInStatementSyntax.prototype.isIterationStatement = function () {
            return true;
        };

        ForInStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        ForInStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        ForInStatementSyntax.prototype.update = function (forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement) {
            if (this.forKeyword === forKeyword && this.openParenToken === openParenToken && this.variableDeclaration === variableDeclaration && this.left === left && this.inKeyword === inKeyword && this.expression === expression && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new ForInStatementSyntax(forKeyword, openParenToken, variableDeclaration, left, inKeyword, expression, closeParenToken, statement, this.parsedInStrictMode());
        };

        ForInStatementSyntax.create = function (forKeyword, openParenToken, inKeyword, expression, closeParenToken, statement) {
            return new ForInStatementSyntax(forKeyword, openParenToken, null, null, inKeyword, expression, closeParenToken, statement, false);
        };

        ForInStatementSyntax.create1 = function (expression, statement) {
            return new ForInStatementSyntax(TypeScript.Syntax.token(26 /* ForKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), null, null, TypeScript.Syntax.token(29 /* InKeyword */), expression, TypeScript.Syntax.token(73 /* CloseParenToken */), statement, false);
        };

        ForInStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ForInStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ForInStatementSyntax.prototype.withForKeyword = function (forKeyword) {
            return this.update(forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.forKeyword, openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withVariableDeclaration = function (variableDeclaration) {
            return this.update(this.forKeyword, this.openParenToken, variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withLeft = function (left) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, left, this.inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withInKeyword = function (inKeyword) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, inKeyword, this.expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withExpression = function (expression) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, expression, this.closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, closeParenToken, this.statement);
        };

        ForInStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.forKeyword, this.openParenToken, this.variableDeclaration, this.left, this.inKeyword, this.expression, this.closeParenToken, statement);
        };

        ForInStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.variableDeclaration !== null && this.variableDeclaration.isTypeScriptSpecific()) {
                return true;
            }
            if (this.left !== null && this.left.isTypeScriptSpecific()) {
                return true;
            }
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ForInStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ForInStatementSyntax = ForInStatementSyntax;

    var WhileStatementSyntax = (function (_super) {
        __extends(WhileStatementSyntax, _super);
        function WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.whileKeyword = whileKeyword;
            this.openParenToken = openParenToken;
            this.condition = condition;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
        }
        WhileStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitWhileStatement(this);
        };

        WhileStatementSyntax.prototype.kind = function () {
            return 158 /* WhileStatement */;
        };

        WhileStatementSyntax.prototype.childCount = function () {
            return 5;
        };

        WhileStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.whileKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.condition;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        WhileStatementSyntax.prototype.isIterationStatement = function () {
            return true;
        };

        WhileStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        WhileStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        WhileStatementSyntax.prototype.update = function (whileKeyword, openParenToken, condition, closeParenToken, statement) {
            if (this.whileKeyword === whileKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new WhileStatementSyntax(whileKeyword, openParenToken, condition, closeParenToken, statement, this.parsedInStrictMode());
        };

        WhileStatementSyntax.create1 = function (condition, statement) {
            return new WhileStatementSyntax(TypeScript.Syntax.token(42 /* WhileKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), condition, TypeScript.Syntax.token(73 /* CloseParenToken */), statement, false);
        };

        WhileStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        WhileStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        WhileStatementSyntax.prototype.withWhileKeyword = function (whileKeyword) {
            return this.update(whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.whileKeyword, openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.whileKeyword, this.openParenToken, condition, this.closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.whileKeyword, this.openParenToken, this.condition, closeParenToken, this.statement);
        };

        WhileStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, statement);
        };

        WhileStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return WhileStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.WhileStatementSyntax = WhileStatementSyntax;

    var WithStatementSyntax = (function (_super) {
        __extends(WithStatementSyntax, _super);
        function WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.withKeyword = withKeyword;
            this.openParenToken = openParenToken;
            this.condition = condition;
            this.closeParenToken = closeParenToken;
            this.statement = statement;
        }
        WithStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitWithStatement(this);
        };

        WithStatementSyntax.prototype.kind = function () {
            return 163 /* WithStatement */;
        };

        WithStatementSyntax.prototype.childCount = function () {
            return 5;
        };

        WithStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.withKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.condition;
                case 3:
                    return this.closeParenToken;
                case 4:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        WithStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        WithStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        WithStatementSyntax.prototype.update = function (withKeyword, openParenToken, condition, closeParenToken, statement) {
            if (this.withKeyword === withKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.statement === statement) {
                return this;
            }

            return new WithStatementSyntax(withKeyword, openParenToken, condition, closeParenToken, statement, this.parsedInStrictMode());
        };

        WithStatementSyntax.create1 = function (condition, statement) {
            return new WithStatementSyntax(TypeScript.Syntax.token(43 /* WithKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), condition, TypeScript.Syntax.token(73 /* CloseParenToken */), statement, false);
        };

        WithStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        WithStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        WithStatementSyntax.prototype.withWithKeyword = function (withKeyword) {
            return this.update(withKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.withKeyword, openParenToken, this.condition, this.closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.withKeyword, this.openParenToken, condition, this.closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.withKeyword, this.openParenToken, this.condition, closeParenToken, this.statement);
        };

        WithStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.withKeyword, this.openParenToken, this.condition, this.closeParenToken, statement);
        };

        WithStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return WithStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.WithStatementSyntax = WithStatementSyntax;

    var EnumDeclarationSyntax = (function (_super) {
        __extends(EnumDeclarationSyntax, _super);
        function EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.modifiers = modifiers;
            this.enumKeyword = enumKeyword;
            this.identifier = identifier;
            this.openBraceToken = openBraceToken;
            this.enumElements = enumElements;
            this.closeBraceToken = closeBraceToken;
        }
        EnumDeclarationSyntax.prototype.accept = function (visitor) {
            return visitor.visitEnumDeclaration(this);
        };

        EnumDeclarationSyntax.prototype.kind = function () {
            return 132 /* EnumDeclaration */;
        };

        EnumDeclarationSyntax.prototype.childCount = function () {
            return 6;
        };

        EnumDeclarationSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.modifiers;
                case 1:
                    return this.enumKeyword;
                case 2:
                    return this.identifier;
                case 3:
                    return this.openBraceToken;
                case 4:
                    return this.enumElements;
                case 5:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EnumDeclarationSyntax.prototype.isModuleElement = function () {
            return true;
        };

        EnumDeclarationSyntax.prototype.update = function (modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken) {
            if (this.modifiers === modifiers && this.enumKeyword === enumKeyword && this.identifier === identifier && this.openBraceToken === openBraceToken && this.enumElements === enumElements && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new EnumDeclarationSyntax(modifiers, enumKeyword, identifier, openBraceToken, enumElements, closeBraceToken, this.parsedInStrictMode());
        };

        EnumDeclarationSyntax.create = function (enumKeyword, identifier, openBraceToken, closeBraceToken) {
            return new EnumDeclarationSyntax(TypeScript.Syntax.emptyList, enumKeyword, identifier, openBraceToken, TypeScript.Syntax.emptySeparatedList, closeBraceToken, false);
        };

        EnumDeclarationSyntax.create1 = function (identifier) {
            return new EnumDeclarationSyntax(TypeScript.Syntax.emptyList, TypeScript.Syntax.token(46 /* EnumKeyword */), identifier, TypeScript.Syntax.token(70 /* OpenBraceToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(71 /* CloseBraceToken */), false);
        };

        EnumDeclarationSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EnumDeclarationSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EnumDeclarationSyntax.prototype.withModifiers = function (modifiers) {
            return this.update(modifiers, this.enumKeyword, this.identifier, this.openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withModifier = function (modifier) {
            return this.withModifiers(TypeScript.Syntax.list([modifier]));
        };

        EnumDeclarationSyntax.prototype.withEnumKeyword = function (enumKeyword) {
            return this.update(this.modifiers, enumKeyword, this.identifier, this.openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.modifiers, this.enumKeyword, identifier, this.openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(this.modifiers, this.enumKeyword, this.identifier, openBraceToken, this.enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withEnumElements = function (enumElements) {
            return this.update(this.modifiers, this.enumKeyword, this.identifier, this.openBraceToken, enumElements, this.closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.withEnumElement = function (enumElement) {
            return this.withEnumElements(TypeScript.Syntax.separatedList([enumElement]));
        };

        EnumDeclarationSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.modifiers, this.enumKeyword, this.identifier, this.openBraceToken, this.enumElements, closeBraceToken);
        };

        EnumDeclarationSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return EnumDeclarationSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EnumDeclarationSyntax = EnumDeclarationSyntax;

    var EnumElementSyntax = (function (_super) {
        __extends(EnumElementSyntax, _super);
        function EnumElementSyntax(propertyName, equalsValueClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.equalsValueClause = equalsValueClause;
        }
        EnumElementSyntax.prototype.accept = function (visitor) {
            return visitor.visitEnumElement(this);
        };

        EnumElementSyntax.prototype.kind = function () {
            return 243 /* EnumElement */;
        };

        EnumElementSyntax.prototype.childCount = function () {
            return 2;
        };

        EnumElementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.equalsValueClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EnumElementSyntax.prototype.update = function (propertyName, equalsValueClause) {
            if (this.propertyName === propertyName && this.equalsValueClause === equalsValueClause) {
                return this;
            }

            return new EnumElementSyntax(propertyName, equalsValueClause, this.parsedInStrictMode());
        };

        EnumElementSyntax.create = function (propertyName) {
            return new EnumElementSyntax(propertyName, null, false);
        };

        EnumElementSyntax.create1 = function (propertyName) {
            return new EnumElementSyntax(propertyName, null, false);
        };

        EnumElementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EnumElementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EnumElementSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.equalsValueClause);
        };

        EnumElementSyntax.prototype.withEqualsValueClause = function (equalsValueClause) {
            return this.update(this.propertyName, equalsValueClause);
        };

        EnumElementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.equalsValueClause !== null && this.equalsValueClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return EnumElementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EnumElementSyntax = EnumElementSyntax;

    var CastExpressionSyntax = (function (_super) {
        __extends(CastExpressionSyntax, _super);
        function CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.lessThanToken = lessThanToken;
            this.type = type;
            this.greaterThanToken = greaterThanToken;
            this.expression = expression;
        }
        CastExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitCastExpression(this);
        };

        CastExpressionSyntax.prototype.kind = function () {
            return 220 /* CastExpression */;
        };

        CastExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        CastExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.lessThanToken;
                case 1:
                    return this.type;
                case 2:
                    return this.greaterThanToken;
                case 3:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CastExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        CastExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        CastExpressionSyntax.prototype.update = function (lessThanToken, type, greaterThanToken, expression) {
            if (this.lessThanToken === lessThanToken && this.type === type && this.greaterThanToken === greaterThanToken && this.expression === expression) {
                return this;
            }

            return new CastExpressionSyntax(lessThanToken, type, greaterThanToken, expression, this.parsedInStrictMode());
        };

        CastExpressionSyntax.create1 = function (type, expression) {
            return new CastExpressionSyntax(TypeScript.Syntax.token(80 /* LessThanToken */), type, TypeScript.Syntax.token(81 /* GreaterThanToken */), expression, false);
        };

        CastExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CastExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CastExpressionSyntax.prototype.withLessThanToken = function (lessThanToken) {
            return this.update(lessThanToken, this.type, this.greaterThanToken, this.expression);
        };

        CastExpressionSyntax.prototype.withType = function (type) {
            return this.update(this.lessThanToken, type, this.greaterThanToken, this.expression);
        };

        CastExpressionSyntax.prototype.withGreaterThanToken = function (greaterThanToken) {
            return this.update(this.lessThanToken, this.type, greaterThanToken, this.expression);
        };

        CastExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.lessThanToken, this.type, this.greaterThanToken, expression);
        };

        CastExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            return true;
        };
        return CastExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.CastExpressionSyntax = CastExpressionSyntax;

    var ObjectLiteralExpressionSyntax = (function (_super) {
        __extends(ObjectLiteralExpressionSyntax, _super);
        function ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.openBraceToken = openBraceToken;
            this.propertyAssignments = propertyAssignments;
            this.closeBraceToken = closeBraceToken;
        }
        ObjectLiteralExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitObjectLiteralExpression(this);
        };

        ObjectLiteralExpressionSyntax.prototype.kind = function () {
            return 215 /* ObjectLiteralExpression */;
        };

        ObjectLiteralExpressionSyntax.prototype.childCount = function () {
            return 3;
        };

        ObjectLiteralExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.openBraceToken;
                case 1:
                    return this.propertyAssignments;
                case 2:
                    return this.closeBraceToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        ObjectLiteralExpressionSyntax.prototype.isPrimaryExpression = function () {
            return true;
        };

        ObjectLiteralExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        ObjectLiteralExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        ObjectLiteralExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        ObjectLiteralExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        ObjectLiteralExpressionSyntax.prototype.update = function (openBraceToken, propertyAssignments, closeBraceToken) {
            if (this.openBraceToken === openBraceToken && this.propertyAssignments === propertyAssignments && this.closeBraceToken === closeBraceToken) {
                return this;
            }

            return new ObjectLiteralExpressionSyntax(openBraceToken, propertyAssignments, closeBraceToken, this.parsedInStrictMode());
        };

        ObjectLiteralExpressionSyntax.create = function (openBraceToken, closeBraceToken) {
            return new ObjectLiteralExpressionSyntax(openBraceToken, TypeScript.Syntax.emptySeparatedList, closeBraceToken, false);
        };

        ObjectLiteralExpressionSyntax.create1 = function () {
            return new ObjectLiteralExpressionSyntax(TypeScript.Syntax.token(70 /* OpenBraceToken */), TypeScript.Syntax.emptySeparatedList, TypeScript.Syntax.token(71 /* CloseBraceToken */), false);
        };

        ObjectLiteralExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        ObjectLiteralExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        ObjectLiteralExpressionSyntax.prototype.withOpenBraceToken = function (openBraceToken) {
            return this.update(openBraceToken, this.propertyAssignments, this.closeBraceToken);
        };

        ObjectLiteralExpressionSyntax.prototype.withPropertyAssignments = function (propertyAssignments) {
            return this.update(this.openBraceToken, propertyAssignments, this.closeBraceToken);
        };

        ObjectLiteralExpressionSyntax.prototype.withPropertyAssignment = function (propertyAssignment) {
            return this.withPropertyAssignments(TypeScript.Syntax.separatedList([propertyAssignment]));
        };

        ObjectLiteralExpressionSyntax.prototype.withCloseBraceToken = function (closeBraceToken) {
            return this.update(this.openBraceToken, this.propertyAssignments, closeBraceToken);
        };

        ObjectLiteralExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.propertyAssignments.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return ObjectLiteralExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.ObjectLiteralExpressionSyntax = ObjectLiteralExpressionSyntax;

    var SimplePropertyAssignmentSyntax = (function (_super) {
        __extends(SimplePropertyAssignmentSyntax, _super);
        function SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.colonToken = colonToken;
            this.expression = expression;
        }
        SimplePropertyAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitSimplePropertyAssignment(this);
        };

        SimplePropertyAssignmentSyntax.prototype.kind = function () {
            return 240 /* SimplePropertyAssignment */;
        };

        SimplePropertyAssignmentSyntax.prototype.childCount = function () {
            return 3;
        };

        SimplePropertyAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.colonToken;
                case 2:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        SimplePropertyAssignmentSyntax.prototype.isPropertyAssignment = function () {
            return true;
        };

        SimplePropertyAssignmentSyntax.prototype.update = function (propertyName, colonToken, expression) {
            if (this.propertyName === propertyName && this.colonToken === colonToken && this.expression === expression) {
                return this;
            }

            return new SimplePropertyAssignmentSyntax(propertyName, colonToken, expression, this.parsedInStrictMode());
        };

        SimplePropertyAssignmentSyntax.create1 = function (propertyName, expression) {
            return new SimplePropertyAssignmentSyntax(propertyName, TypeScript.Syntax.token(106 /* ColonToken */), expression, false);
        };

        SimplePropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        SimplePropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        SimplePropertyAssignmentSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.colonToken, this.expression);
        };

        SimplePropertyAssignmentSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.propertyName, colonToken, this.expression);
        };

        SimplePropertyAssignmentSyntax.prototype.withExpression = function (expression) {
            return this.update(this.propertyName, this.colonToken, expression);
        };

        SimplePropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return SimplePropertyAssignmentSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.SimplePropertyAssignmentSyntax = SimplePropertyAssignmentSyntax;

    var FunctionPropertyAssignmentSyntax = (function (_super) {
        __extends(FunctionPropertyAssignmentSyntax, _super);
        function FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.propertyName = propertyName;
            this.callSignature = callSignature;
            this.block = block;
        }
        FunctionPropertyAssignmentSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionPropertyAssignment(this);
        };

        FunctionPropertyAssignmentSyntax.prototype.kind = function () {
            return 241 /* FunctionPropertyAssignment */;
        };

        FunctionPropertyAssignmentSyntax.prototype.childCount = function () {
            return 3;
        };

        FunctionPropertyAssignmentSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.propertyName;
                case 1:
                    return this.callSignature;
                case 2:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionPropertyAssignmentSyntax.prototype.isPropertyAssignment = function () {
            return true;
        };

        FunctionPropertyAssignmentSyntax.prototype.update = function (propertyName, callSignature, block) {
            if (this.propertyName === propertyName && this.callSignature === callSignature && this.block === block) {
                return this;
            }

            return new FunctionPropertyAssignmentSyntax(propertyName, callSignature, block, this.parsedInStrictMode());
        };

        FunctionPropertyAssignmentSyntax.create1 = function (propertyName) {
            return new FunctionPropertyAssignmentSyntax(propertyName, CallSignatureSyntax.create1(), BlockSyntax.create1(), false);
        };

        FunctionPropertyAssignmentSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionPropertyAssignmentSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionPropertyAssignmentSyntax.prototype.withPropertyName = function (propertyName) {
            return this.update(propertyName, this.callSignature, this.block);
        };

        FunctionPropertyAssignmentSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.propertyName, callSignature, this.block);
        };

        FunctionPropertyAssignmentSyntax.prototype.withBlock = function (block) {
            return this.update(this.propertyName, this.callSignature, block);
        };

        FunctionPropertyAssignmentSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FunctionPropertyAssignmentSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FunctionPropertyAssignmentSyntax = FunctionPropertyAssignmentSyntax;

    var FunctionExpressionSyntax = (function (_super) {
        __extends(FunctionExpressionSyntax, _super);
        function FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.functionKeyword = functionKeyword;
            this.identifier = identifier;
            this.callSignature = callSignature;
            this.block = block;
        }
        FunctionExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitFunctionExpression(this);
        };

        FunctionExpressionSyntax.prototype.kind = function () {
            return 222 /* FunctionExpression */;
        };

        FunctionExpressionSyntax.prototype.childCount = function () {
            return 4;
        };

        FunctionExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.functionKeyword;
                case 1:
                    return this.identifier;
                case 2:
                    return this.callSignature;
                case 3:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FunctionExpressionSyntax.prototype.isPrimaryExpression = function () {
            return true;
        };

        FunctionExpressionSyntax.prototype.isMemberExpression = function () {
            return true;
        };

        FunctionExpressionSyntax.prototype.isPostfixExpression = function () {
            return true;
        };

        FunctionExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        FunctionExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        FunctionExpressionSyntax.prototype.update = function (functionKeyword, identifier, callSignature, block) {
            if (this.functionKeyword === functionKeyword && this.identifier === identifier && this.callSignature === callSignature && this.block === block) {
                return this;
            }

            return new FunctionExpressionSyntax(functionKeyword, identifier, callSignature, block, this.parsedInStrictMode());
        };

        FunctionExpressionSyntax.create = function (functionKeyword, callSignature, block) {
            return new FunctionExpressionSyntax(functionKeyword, null, callSignature, block, false);
        };

        FunctionExpressionSyntax.create1 = function () {
            return new FunctionExpressionSyntax(TypeScript.Syntax.token(27 /* FunctionKeyword */), null, CallSignatureSyntax.create1(), BlockSyntax.create1(), false);
        };

        FunctionExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FunctionExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FunctionExpressionSyntax.prototype.withFunctionKeyword = function (functionKeyword) {
            return this.update(functionKeyword, this.identifier, this.callSignature, this.block);
        };

        FunctionExpressionSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.functionKeyword, identifier, this.callSignature, this.block);
        };

        FunctionExpressionSyntax.prototype.withCallSignature = function (callSignature) {
            return this.update(this.functionKeyword, this.identifier, callSignature, this.block);
        };

        FunctionExpressionSyntax.prototype.withBlock = function (block) {
            return this.update(this.functionKeyword, this.identifier, this.callSignature, block);
        };

        FunctionExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.callSignature.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FunctionExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FunctionExpressionSyntax = FunctionExpressionSyntax;

    var EmptyStatementSyntax = (function (_super) {
        __extends(EmptyStatementSyntax, _super);
        function EmptyStatementSyntax(semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.semicolonToken = semicolonToken;
        }
        EmptyStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitEmptyStatement(this);
        };

        EmptyStatementSyntax.prototype.kind = function () {
            return 156 /* EmptyStatement */;
        };

        EmptyStatementSyntax.prototype.childCount = function () {
            return 1;
        };

        EmptyStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        EmptyStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        EmptyStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        EmptyStatementSyntax.prototype.update = function (semicolonToken) {
            if (this.semicolonToken === semicolonToken) {
                return this;
            }

            return new EmptyStatementSyntax(semicolonToken, this.parsedInStrictMode());
        };

        EmptyStatementSyntax.create1 = function () {
            return new EmptyStatementSyntax(TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        EmptyStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        EmptyStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        EmptyStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(semicolonToken);
        };

        EmptyStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return EmptyStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.EmptyStatementSyntax = EmptyStatementSyntax;

    var TryStatementSyntax = (function (_super) {
        __extends(TryStatementSyntax, _super);
        function TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.tryKeyword = tryKeyword;
            this.block = block;
            this.catchClause = catchClause;
            this.finallyClause = finallyClause;
        }
        TryStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitTryStatement(this);
        };

        TryStatementSyntax.prototype.kind = function () {
            return 159 /* TryStatement */;
        };

        TryStatementSyntax.prototype.childCount = function () {
            return 4;
        };

        TryStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.tryKeyword;
                case 1:
                    return this.block;
                case 2:
                    return this.catchClause;
                case 3:
                    return this.finallyClause;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TryStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        TryStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        TryStatementSyntax.prototype.update = function (tryKeyword, block, catchClause, finallyClause) {
            if (this.tryKeyword === tryKeyword && this.block === block && this.catchClause === catchClause && this.finallyClause === finallyClause) {
                return this;
            }

            return new TryStatementSyntax(tryKeyword, block, catchClause, finallyClause, this.parsedInStrictMode());
        };

        TryStatementSyntax.create = function (tryKeyword, block) {
            return new TryStatementSyntax(tryKeyword, block, null, null, false);
        };

        TryStatementSyntax.create1 = function () {
            return new TryStatementSyntax(TypeScript.Syntax.token(38 /* TryKeyword */), BlockSyntax.create1(), null, null, false);
        };

        TryStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TryStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TryStatementSyntax.prototype.withTryKeyword = function (tryKeyword) {
            return this.update(tryKeyword, this.block, this.catchClause, this.finallyClause);
        };

        TryStatementSyntax.prototype.withBlock = function (block) {
            return this.update(this.tryKeyword, block, this.catchClause, this.finallyClause);
        };

        TryStatementSyntax.prototype.withCatchClause = function (catchClause) {
            return this.update(this.tryKeyword, this.block, catchClause, this.finallyClause);
        };

        TryStatementSyntax.prototype.withFinallyClause = function (finallyClause) {
            return this.update(this.tryKeyword, this.block, this.catchClause, finallyClause);
        };

        TryStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            if (this.catchClause !== null && this.catchClause.isTypeScriptSpecific()) {
                return true;
            }
            if (this.finallyClause !== null && this.finallyClause.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return TryStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TryStatementSyntax = TryStatementSyntax;

    var CatchClauseSyntax = (function (_super) {
        __extends(CatchClauseSyntax, _super);
        function CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.catchKeyword = catchKeyword;
            this.openParenToken = openParenToken;
            this.identifier = identifier;
            this.typeAnnotation = typeAnnotation;
            this.closeParenToken = closeParenToken;
            this.block = block;
        }
        CatchClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitCatchClause(this);
        };

        CatchClauseSyntax.prototype.kind = function () {
            return 236 /* CatchClause */;
        };

        CatchClauseSyntax.prototype.childCount = function () {
            return 6;
        };

        CatchClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.catchKeyword;
                case 1:
                    return this.openParenToken;
                case 2:
                    return this.identifier;
                case 3:
                    return this.typeAnnotation;
                case 4:
                    return this.closeParenToken;
                case 5:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        CatchClauseSyntax.prototype.update = function (catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block) {
            if (this.catchKeyword === catchKeyword && this.openParenToken === openParenToken && this.identifier === identifier && this.typeAnnotation === typeAnnotation && this.closeParenToken === closeParenToken && this.block === block) {
                return this;
            }

            return new CatchClauseSyntax(catchKeyword, openParenToken, identifier, typeAnnotation, closeParenToken, block, this.parsedInStrictMode());
        };

        CatchClauseSyntax.create = function (catchKeyword, openParenToken, identifier, closeParenToken, block) {
            return new CatchClauseSyntax(catchKeyword, openParenToken, identifier, null, closeParenToken, block, false);
        };

        CatchClauseSyntax.create1 = function (identifier) {
            return new CatchClauseSyntax(TypeScript.Syntax.token(17 /* CatchKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), identifier, null, TypeScript.Syntax.token(73 /* CloseParenToken */), BlockSyntax.create1(), false);
        };

        CatchClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        CatchClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        CatchClauseSyntax.prototype.withCatchKeyword = function (catchKeyword) {
            return this.update(catchKeyword, this.openParenToken, this.identifier, this.typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.catchKeyword, openParenToken, this.identifier, this.typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(this.catchKeyword, this.openParenToken, identifier, this.typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withTypeAnnotation = function (typeAnnotation) {
            return this.update(this.catchKeyword, this.openParenToken, this.identifier, typeAnnotation, this.closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.catchKeyword, this.openParenToken, this.identifier, this.typeAnnotation, closeParenToken, this.block);
        };

        CatchClauseSyntax.prototype.withBlock = function (block) {
            return this.update(this.catchKeyword, this.openParenToken, this.identifier, this.typeAnnotation, this.closeParenToken, block);
        };

        CatchClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.typeAnnotation !== null && this.typeAnnotation.isTypeScriptSpecific()) {
                return true;
            }
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return CatchClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.CatchClauseSyntax = CatchClauseSyntax;

    var FinallyClauseSyntax = (function (_super) {
        __extends(FinallyClauseSyntax, _super);
        function FinallyClauseSyntax(finallyKeyword, block, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.finallyKeyword = finallyKeyword;
            this.block = block;
        }
        FinallyClauseSyntax.prototype.accept = function (visitor) {
            return visitor.visitFinallyClause(this);
        };

        FinallyClauseSyntax.prototype.kind = function () {
            return 237 /* FinallyClause */;
        };

        FinallyClauseSyntax.prototype.childCount = function () {
            return 2;
        };

        FinallyClauseSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.finallyKeyword;
                case 1:
                    return this.block;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        FinallyClauseSyntax.prototype.update = function (finallyKeyword, block) {
            if (this.finallyKeyword === finallyKeyword && this.block === block) {
                return this;
            }

            return new FinallyClauseSyntax(finallyKeyword, block, this.parsedInStrictMode());
        };

        FinallyClauseSyntax.create1 = function () {
            return new FinallyClauseSyntax(TypeScript.Syntax.token(25 /* FinallyKeyword */), BlockSyntax.create1(), false);
        };

        FinallyClauseSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        FinallyClauseSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        FinallyClauseSyntax.prototype.withFinallyKeyword = function (finallyKeyword) {
            return this.update(finallyKeyword, this.block);
        };

        FinallyClauseSyntax.prototype.withBlock = function (block) {
            return this.update(this.finallyKeyword, block);
        };

        FinallyClauseSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.block.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return FinallyClauseSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.FinallyClauseSyntax = FinallyClauseSyntax;

    var LabeledStatementSyntax = (function (_super) {
        __extends(LabeledStatementSyntax, _super);
        function LabeledStatementSyntax(identifier, colonToken, statement, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.identifier = identifier;
            this.colonToken = colonToken;
            this.statement = statement;
        }
        LabeledStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitLabeledStatement(this);
        };

        LabeledStatementSyntax.prototype.kind = function () {
            return 160 /* LabeledStatement */;
        };

        LabeledStatementSyntax.prototype.childCount = function () {
            return 3;
        };

        LabeledStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.identifier;
                case 1:
                    return this.colonToken;
                case 2:
                    return this.statement;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        LabeledStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        LabeledStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        LabeledStatementSyntax.prototype.update = function (identifier, colonToken, statement) {
            if (this.identifier === identifier && this.colonToken === colonToken && this.statement === statement) {
                return this;
            }

            return new LabeledStatementSyntax(identifier, colonToken, statement, this.parsedInStrictMode());
        };

        LabeledStatementSyntax.create1 = function (identifier, statement) {
            return new LabeledStatementSyntax(identifier, TypeScript.Syntax.token(106 /* ColonToken */), statement, false);
        };

        LabeledStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        LabeledStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        LabeledStatementSyntax.prototype.withIdentifier = function (identifier) {
            return this.update(identifier, this.colonToken, this.statement);
        };

        LabeledStatementSyntax.prototype.withColonToken = function (colonToken) {
            return this.update(this.identifier, colonToken, this.statement);
        };

        LabeledStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.identifier, this.colonToken, statement);
        };

        LabeledStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return LabeledStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.LabeledStatementSyntax = LabeledStatementSyntax;

    var DoStatementSyntax = (function (_super) {
        __extends(DoStatementSyntax, _super);
        function DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.doKeyword = doKeyword;
            this.statement = statement;
            this.whileKeyword = whileKeyword;
            this.openParenToken = openParenToken;
            this.condition = condition;
            this.closeParenToken = closeParenToken;
            this.semicolonToken = semicolonToken;
        }
        DoStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitDoStatement(this);
        };

        DoStatementSyntax.prototype.kind = function () {
            return 161 /* DoStatement */;
        };

        DoStatementSyntax.prototype.childCount = function () {
            return 7;
        };

        DoStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.doKeyword;
                case 1:
                    return this.statement;
                case 2:
                    return this.whileKeyword;
                case 3:
                    return this.openParenToken;
                case 4:
                    return this.condition;
                case 5:
                    return this.closeParenToken;
                case 6:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DoStatementSyntax.prototype.isIterationStatement = function () {
            return true;
        };

        DoStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        DoStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        DoStatementSyntax.prototype.update = function (doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken) {
            if (this.doKeyword === doKeyword && this.statement === statement && this.whileKeyword === whileKeyword && this.openParenToken === openParenToken && this.condition === condition && this.closeParenToken === closeParenToken && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new DoStatementSyntax(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken, this.parsedInStrictMode());
        };

        DoStatementSyntax.create1 = function (statement, condition) {
            return new DoStatementSyntax(TypeScript.Syntax.token(22 /* DoKeyword */), statement, TypeScript.Syntax.token(42 /* WhileKeyword */), TypeScript.Syntax.token(72 /* OpenParenToken */), condition, TypeScript.Syntax.token(73 /* CloseParenToken */), TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        DoStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DoStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DoStatementSyntax.prototype.withDoKeyword = function (doKeyword) {
            return this.update(doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withStatement = function (statement) {
            return this.update(this.doKeyword, statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withWhileKeyword = function (whileKeyword) {
            return this.update(this.doKeyword, this.statement, whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withOpenParenToken = function (openParenToken) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, openParenToken, this.condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withCondition = function (condition) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, condition, this.closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withCloseParenToken = function (closeParenToken) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, closeParenToken, this.semicolonToken);
        };

        DoStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, semicolonToken);
        };

        DoStatementSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.statement.isTypeScriptSpecific()) {
                return true;
            }
            if (this.condition.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return DoStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.DoStatementSyntax = DoStatementSyntax;

    var TypeOfExpressionSyntax = (function (_super) {
        __extends(TypeOfExpressionSyntax, _super);
        function TypeOfExpressionSyntax(typeOfKeyword, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.typeOfKeyword = typeOfKeyword;
            this.expression = expression;
        }
        TypeOfExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitTypeOfExpression(this);
        };

        TypeOfExpressionSyntax.prototype.kind = function () {
            return 171 /* TypeOfExpression */;
        };

        TypeOfExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        TypeOfExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.typeOfKeyword;
                case 1:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        TypeOfExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        TypeOfExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        TypeOfExpressionSyntax.prototype.update = function (typeOfKeyword, expression) {
            if (this.typeOfKeyword === typeOfKeyword && this.expression === expression) {
                return this;
            }

            return new TypeOfExpressionSyntax(typeOfKeyword, expression, this.parsedInStrictMode());
        };

        TypeOfExpressionSyntax.create1 = function (expression) {
            return new TypeOfExpressionSyntax(TypeScript.Syntax.token(39 /* TypeOfKeyword */), expression, false);
        };

        TypeOfExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        TypeOfExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        TypeOfExpressionSyntax.prototype.withTypeOfKeyword = function (typeOfKeyword) {
            return this.update(typeOfKeyword, this.expression);
        };

        TypeOfExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.typeOfKeyword, expression);
        };

        TypeOfExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return TypeOfExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.TypeOfExpressionSyntax = TypeOfExpressionSyntax;

    var DeleteExpressionSyntax = (function (_super) {
        __extends(DeleteExpressionSyntax, _super);
        function DeleteExpressionSyntax(deleteKeyword, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.deleteKeyword = deleteKeyword;
            this.expression = expression;
        }
        DeleteExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitDeleteExpression(this);
        };

        DeleteExpressionSyntax.prototype.kind = function () {
            return 170 /* DeleteExpression */;
        };

        DeleteExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        DeleteExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.deleteKeyword;
                case 1:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DeleteExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        DeleteExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        DeleteExpressionSyntax.prototype.update = function (deleteKeyword, expression) {
            if (this.deleteKeyword === deleteKeyword && this.expression === expression) {
                return this;
            }

            return new DeleteExpressionSyntax(deleteKeyword, expression, this.parsedInStrictMode());
        };

        DeleteExpressionSyntax.create1 = function (expression) {
            return new DeleteExpressionSyntax(TypeScript.Syntax.token(21 /* DeleteKeyword */), expression, false);
        };

        DeleteExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DeleteExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DeleteExpressionSyntax.prototype.withDeleteKeyword = function (deleteKeyword) {
            return this.update(deleteKeyword, this.expression);
        };

        DeleteExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.deleteKeyword, expression);
        };

        DeleteExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return DeleteExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.DeleteExpressionSyntax = DeleteExpressionSyntax;

    var VoidExpressionSyntax = (function (_super) {
        __extends(VoidExpressionSyntax, _super);
        function VoidExpressionSyntax(voidKeyword, expression, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.voidKeyword = voidKeyword;
            this.expression = expression;
        }
        VoidExpressionSyntax.prototype.accept = function (visitor) {
            return visitor.visitVoidExpression(this);
        };

        VoidExpressionSyntax.prototype.kind = function () {
            return 172 /* VoidExpression */;
        };

        VoidExpressionSyntax.prototype.childCount = function () {
            return 2;
        };

        VoidExpressionSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.voidKeyword;
                case 1:
                    return this.expression;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        VoidExpressionSyntax.prototype.isUnaryExpression = function () {
            return true;
        };

        VoidExpressionSyntax.prototype.isExpression = function () {
            return true;
        };

        VoidExpressionSyntax.prototype.update = function (voidKeyword, expression) {
            if (this.voidKeyword === voidKeyword && this.expression === expression) {
                return this;
            }

            return new VoidExpressionSyntax(voidKeyword, expression, this.parsedInStrictMode());
        };

        VoidExpressionSyntax.create1 = function (expression) {
            return new VoidExpressionSyntax(TypeScript.Syntax.token(41 /* VoidKeyword */), expression, false);
        };

        VoidExpressionSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        VoidExpressionSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        VoidExpressionSyntax.prototype.withVoidKeyword = function (voidKeyword) {
            return this.update(voidKeyword, this.expression);
        };

        VoidExpressionSyntax.prototype.withExpression = function (expression) {
            return this.update(this.voidKeyword, expression);
        };

        VoidExpressionSyntax.prototype.isTypeScriptSpecific = function () {
            if (this.expression.isTypeScriptSpecific()) {
                return true;
            }
            return false;
        };
        return VoidExpressionSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.VoidExpressionSyntax = VoidExpressionSyntax;

    var DebuggerStatementSyntax = (function (_super) {
        __extends(DebuggerStatementSyntax, _super);
        function DebuggerStatementSyntax(debuggerKeyword, semicolonToken, parsedInStrictMode) {
            _super.call(this, parsedInStrictMode);
            this.debuggerKeyword = debuggerKeyword;
            this.semicolonToken = semicolonToken;
        }
        DebuggerStatementSyntax.prototype.accept = function (visitor) {
            return visitor.visitDebuggerStatement(this);
        };

        DebuggerStatementSyntax.prototype.kind = function () {
            return 162 /* DebuggerStatement */;
        };

        DebuggerStatementSyntax.prototype.childCount = function () {
            return 2;
        };

        DebuggerStatementSyntax.prototype.childAt = function (slot) {
            switch (slot) {
                case 0:
                    return this.debuggerKeyword;
                case 1:
                    return this.semicolonToken;
                default:
                    throw TypeScript.Errors.invalidOperation();
            }
        };

        DebuggerStatementSyntax.prototype.isStatement = function () {
            return true;
        };

        DebuggerStatementSyntax.prototype.isModuleElement = function () {
            return true;
        };

        DebuggerStatementSyntax.prototype.update = function (debuggerKeyword, semicolonToken) {
            if (this.debuggerKeyword === debuggerKeyword && this.semicolonToken === semicolonToken) {
                return this;
            }

            return new DebuggerStatementSyntax(debuggerKeyword, semicolonToken, this.parsedInStrictMode());
        };

        DebuggerStatementSyntax.create1 = function () {
            return new DebuggerStatementSyntax(TypeScript.Syntax.token(19 /* DebuggerKeyword */), TypeScript.Syntax.token(78 /* SemicolonToken */), false);
        };

        DebuggerStatementSyntax.prototype.withLeadingTrivia = function (trivia) {
            return _super.prototype.withLeadingTrivia.call(this, trivia);
        };

        DebuggerStatementSyntax.prototype.withTrailingTrivia = function (trivia) {
            return _super.prototype.withTrailingTrivia.call(this, trivia);
        };

        DebuggerStatementSyntax.prototype.withDebuggerKeyword = function (debuggerKeyword) {
            return this.update(debuggerKeyword, this.semicolonToken);
        };

        DebuggerStatementSyntax.prototype.withSemicolonToken = function (semicolonToken) {
            return this.update(this.debuggerKeyword, semicolonToken);
        };

        DebuggerStatementSyntax.prototype.isTypeScriptSpecific = function () {
            return false;
        };
        return DebuggerStatementSyntax;
    })(TypeScript.SyntaxNode);
    TypeScript.DebuggerStatementSyntax = DebuggerStatementSyntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxRewriter = (function () {
        function SyntaxRewriter() {
        }
        SyntaxRewriter.prototype.visitToken = function (token) {
            return token;
        };

        SyntaxRewriter.prototype.visitNode = function (node) {
            return node.accept(this);
        };

        SyntaxRewriter.prototype.visitNodeOrToken = function (node) {
            return node.isToken() ? this.visitToken(node) : this.visitNode(node);
        };

        SyntaxRewriter.prototype.visitList = function (list) {
            var newItems = null;

            for (var i = 0, n = list.childCount(); i < n; i++) {
                var item = list.childAt(i);
                var newItem = this.visitNodeOrToken(item);

                if (item !== newItem && newItems === null) {
                    newItems = [];
                    for (var j = 0; j < i; j++) {
                        newItems.push(list.childAt(j));
                    }
                }

                if (newItems) {
                    newItems.push(newItem);
                }
            }

            return newItems === null ? list : TypeScript.Syntax.list(newItems);
        };

        SyntaxRewriter.prototype.visitSeparatedList = function (list) {
            var newItems = null;

            for (var i = 0, n = list.childCount(); i < n; i++) {
                var item = list.childAt(i);
                var newItem = item.isToken() ? this.visitToken(item) : this.visitNode(item);

                if (item !== newItem && newItems === null) {
                    newItems = [];
                    for (var j = 0; j < i; j++) {
                        newItems.push(list.childAt(j));
                    }
                }

                if (newItems) {
                    newItems.push(newItem);
                }
            }

            return newItems === null ? list : TypeScript.Syntax.separatedList(newItems);
        };

        SyntaxRewriter.prototype.visitSourceUnit = function (node) {
            return node.update(this.visitList(node.moduleElements), this.visitToken(node.endOfFileToken));
        };

        SyntaxRewriter.prototype.visitExternalModuleReference = function (node) {
            return node.update(this.visitToken(node.requireKeyword), this.visitToken(node.openParenToken), this.visitToken(node.stringLiteral), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitModuleNameModuleReference = function (node) {
            return node.update(this.visitNodeOrToken(node.moduleName));
        };

        SyntaxRewriter.prototype.visitImportDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.importKeyword), this.visitToken(node.identifier), this.visitToken(node.equalsToken), this.visitNodeOrToken(node.moduleReference), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitExportAssignment = function (node) {
            return node.update(this.visitToken(node.exportKeyword), this.visitToken(node.equalsToken), this.visitToken(node.identifier), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitClassDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.classKeyword), this.visitToken(node.identifier), node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitList(node.heritageClauses), this.visitToken(node.openBraceToken), this.visitList(node.classElements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitInterfaceDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.interfaceKeyword), this.visitToken(node.identifier), node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitList(node.heritageClauses), this.visitNode(node.body));
        };

        SyntaxRewriter.prototype.visitHeritageClause = function (node) {
            return node.update(node.kind(), this.visitToken(node.extendsOrImplementsKeyword), this.visitSeparatedList(node.typeNames));
        };

        SyntaxRewriter.prototype.visitModuleDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.moduleKeyword), node.name === null ? null : this.visitNodeOrToken(node.name), node.stringLiteral === null ? null : this.visitToken(node.stringLiteral), this.visitToken(node.openBraceToken), this.visitList(node.moduleElements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitFunctionDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.functionKeyword), this.visitToken(node.identifier), this.visitNode(node.callSignature), node.block === null ? null : this.visitNode(node.block), node.semicolonToken === null ? null : this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitVariableStatement = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitNode(node.variableDeclaration), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitVariableDeclaration = function (node) {
            return node.update(this.visitToken(node.varKeyword), this.visitSeparatedList(node.variableDeclarators));
        };

        SyntaxRewriter.prototype.visitVariableDeclarator = function (node) {
            return node.update(this.visitToken(node.propertyName), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), node.equalsValueClause === null ? null : this.visitNode(node.equalsValueClause));
        };

        SyntaxRewriter.prototype.visitEqualsValueClause = function (node) {
            return node.update(this.visitToken(node.equalsToken), this.visitNodeOrToken(node.value));
        };

        SyntaxRewriter.prototype.visitPrefixUnaryExpression = function (node) {
            return node.update(node.kind(), this.visitToken(node.operatorToken), this.visitNodeOrToken(node.operand));
        };

        SyntaxRewriter.prototype.visitArrayLiteralExpression = function (node) {
            return node.update(this.visitToken(node.openBracketToken), this.visitSeparatedList(node.expressions), this.visitToken(node.closeBracketToken));
        };

        SyntaxRewriter.prototype.visitOmittedExpression = function (node) {
            return node;
        };

        SyntaxRewriter.prototype.visitParenthesizedExpression = function (node) {
            return node.update(this.visitToken(node.openParenToken), this.visitNodeOrToken(node.expression), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitSimpleArrowFunctionExpression = function (node) {
            return node.update(this.visitToken(node.identifier), this.visitToken(node.equalsGreaterThanToken), node.block === null ? null : this.visitNode(node.block), node.expression === null ? null : this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitParenthesizedArrowFunctionExpression = function (node) {
            return node.update(this.visitNode(node.callSignature), this.visitToken(node.equalsGreaterThanToken), node.block === null ? null : this.visitNode(node.block), node.expression === null ? null : this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitQualifiedName = function (node) {
            return node.update(this.visitNodeOrToken(node.left), this.visitToken(node.dotToken), this.visitToken(node.right));
        };

        SyntaxRewriter.prototype.visitTypeArgumentList = function (node) {
            return node.update(this.visitToken(node.lessThanToken), this.visitSeparatedList(node.typeArguments), this.visitToken(node.greaterThanToken));
        };

        SyntaxRewriter.prototype.visitConstructorType = function (node) {
            return node.update(this.visitToken(node.newKeyword), node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitNode(node.parameterList), this.visitToken(node.equalsGreaterThanToken), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitFunctionType = function (node) {
            return node.update(node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitNode(node.parameterList), this.visitToken(node.equalsGreaterThanToken), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitObjectType = function (node) {
            return node.update(this.visitToken(node.openBraceToken), this.visitSeparatedList(node.typeMembers), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitArrayType = function (node) {
            return node.update(this.visitNodeOrToken(node.type), this.visitToken(node.openBracketToken), this.visitToken(node.closeBracketToken));
        };

        SyntaxRewriter.prototype.visitGenericType = function (node) {
            return node.update(this.visitNodeOrToken(node.name), this.visitNode(node.typeArgumentList));
        };

        SyntaxRewriter.prototype.visitTypeQuery = function (node) {
            return node.update(this.visitToken(node.typeOfKeyword), this.visitNodeOrToken(node.name));
        };

        SyntaxRewriter.prototype.visitTypeAnnotation = function (node) {
            return node.update(this.visitToken(node.colonToken), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitBlock = function (node) {
            return node.update(this.visitToken(node.openBraceToken), this.visitList(node.statements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitParameter = function (node) {
            return node.update(node.dotDotDotToken === null ? null : this.visitToken(node.dotDotDotToken), this.visitList(node.modifiers), this.visitToken(node.identifier), node.questionToken === null ? null : this.visitToken(node.questionToken), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), node.equalsValueClause === null ? null : this.visitNode(node.equalsValueClause));
        };

        SyntaxRewriter.prototype.visitMemberAccessExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitToken(node.dotToken), this.visitToken(node.name));
        };

        SyntaxRewriter.prototype.visitPostfixUnaryExpression = function (node) {
            return node.update(node.kind(), this.visitNodeOrToken(node.operand), this.visitToken(node.operatorToken));
        };

        SyntaxRewriter.prototype.visitElementAccessExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitToken(node.openBracketToken), this.visitNodeOrToken(node.argumentExpression), this.visitToken(node.closeBracketToken));
        };

        SyntaxRewriter.prototype.visitInvocationExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitNode(node.argumentList));
        };

        SyntaxRewriter.prototype.visitArgumentList = function (node) {
            return node.update(node.typeArgumentList === null ? null : this.visitNode(node.typeArgumentList), this.visitToken(node.openParenToken), this.visitSeparatedList(node.arguments), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitBinaryExpression = function (node) {
            return node.update(node.kind(), this.visitNodeOrToken(node.left), this.visitToken(node.operatorToken), this.visitNodeOrToken(node.right));
        };

        SyntaxRewriter.prototype.visitConditionalExpression = function (node) {
            return node.update(this.visitNodeOrToken(node.condition), this.visitToken(node.questionToken), this.visitNodeOrToken(node.whenTrue), this.visitToken(node.colonToken), this.visitNodeOrToken(node.whenFalse));
        };

        SyntaxRewriter.prototype.visitConstructSignature = function (node) {
            return node.update(this.visitToken(node.newKeyword), this.visitNode(node.callSignature));
        };

        SyntaxRewriter.prototype.visitMethodSignature = function (node) {
            return node.update(this.visitToken(node.propertyName), node.questionToken === null ? null : this.visitToken(node.questionToken), this.visitNode(node.callSignature));
        };

        SyntaxRewriter.prototype.visitIndexSignature = function (node) {
            return node.update(this.visitToken(node.openBracketToken), this.visitNode(node.parameter), this.visitToken(node.closeBracketToken), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation));
        };

        SyntaxRewriter.prototype.visitPropertySignature = function (node) {
            return node.update(this.visitToken(node.propertyName), node.questionToken === null ? null : this.visitToken(node.questionToken), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation));
        };

        SyntaxRewriter.prototype.visitCallSignature = function (node) {
            return node.update(node.typeParameterList === null ? null : this.visitNode(node.typeParameterList), this.visitNode(node.parameterList), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation));
        };

        SyntaxRewriter.prototype.visitParameterList = function (node) {
            return node.update(this.visitToken(node.openParenToken), this.visitSeparatedList(node.parameters), this.visitToken(node.closeParenToken));
        };

        SyntaxRewriter.prototype.visitTypeParameterList = function (node) {
            return node.update(this.visitToken(node.lessThanToken), this.visitSeparatedList(node.typeParameters), this.visitToken(node.greaterThanToken));
        };

        SyntaxRewriter.prototype.visitTypeParameter = function (node) {
            return node.update(this.visitToken(node.identifier), node.constraint === null ? null : this.visitNode(node.constraint));
        };

        SyntaxRewriter.prototype.visitConstraint = function (node) {
            return node.update(this.visitToken(node.extendsKeyword), this.visitNodeOrToken(node.type));
        };

        SyntaxRewriter.prototype.visitElseClause = function (node) {
            return node.update(this.visitToken(node.elseKeyword), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitIfStatement = function (node) {
            return node.update(this.visitToken(node.ifKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement), node.elseClause === null ? null : this.visitNode(node.elseClause));
        };

        SyntaxRewriter.prototype.visitExpressionStatement = function (node) {
            return node.update(this.visitNodeOrToken(node.expression), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitConstructorDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.constructorKeyword), this.visitNode(node.callSignature), node.block === null ? null : this.visitNode(node.block), node.semicolonToken === null ? null : this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitMemberFunctionDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.propertyName), this.visitNode(node.callSignature), node.block === null ? null : this.visitNode(node.block), node.semicolonToken === null ? null : this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitGetAccessor = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.getKeyword), this.visitToken(node.propertyName), this.visitNode(node.parameterList), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitSetAccessor = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.setKeyword), this.visitToken(node.propertyName), this.visitNode(node.parameterList), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitMemberVariableDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitNode(node.variableDeclarator), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitIndexMemberDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitNode(node.indexSignature), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitThrowStatement = function (node) {
            return node.update(this.visitToken(node.throwKeyword), this.visitNodeOrToken(node.expression), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitReturnStatement = function (node) {
            return node.update(this.visitToken(node.returnKeyword), node.expression === null ? null : this.visitNodeOrToken(node.expression), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitObjectCreationExpression = function (node) {
            return node.update(this.visitToken(node.newKeyword), this.visitNodeOrToken(node.expression), node.argumentList === null ? null : this.visitNode(node.argumentList));
        };

        SyntaxRewriter.prototype.visitSwitchStatement = function (node) {
            return node.update(this.visitToken(node.switchKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.expression), this.visitToken(node.closeParenToken), this.visitToken(node.openBraceToken), this.visitList(node.switchClauses), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitCaseSwitchClause = function (node) {
            return node.update(this.visitToken(node.caseKeyword), this.visitNodeOrToken(node.expression), this.visitToken(node.colonToken), this.visitList(node.statements));
        };

        SyntaxRewriter.prototype.visitDefaultSwitchClause = function (node) {
            return node.update(this.visitToken(node.defaultKeyword), this.visitToken(node.colonToken), this.visitList(node.statements));
        };

        SyntaxRewriter.prototype.visitBreakStatement = function (node) {
            return node.update(this.visitToken(node.breakKeyword), node.identifier === null ? null : this.visitToken(node.identifier), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitContinueStatement = function (node) {
            return node.update(this.visitToken(node.continueKeyword), node.identifier === null ? null : this.visitToken(node.identifier), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitForStatement = function (node) {
            return node.update(this.visitToken(node.forKeyword), this.visitToken(node.openParenToken), node.variableDeclaration === null ? null : this.visitNode(node.variableDeclaration), node.initializer === null ? null : this.visitNodeOrToken(node.initializer), this.visitToken(node.firstSemicolonToken), node.condition === null ? null : this.visitNodeOrToken(node.condition), this.visitToken(node.secondSemicolonToken), node.incrementor === null ? null : this.visitNodeOrToken(node.incrementor), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitForInStatement = function (node) {
            return node.update(this.visitToken(node.forKeyword), this.visitToken(node.openParenToken), node.variableDeclaration === null ? null : this.visitNode(node.variableDeclaration), node.left === null ? null : this.visitNodeOrToken(node.left), this.visitToken(node.inKeyword), this.visitNodeOrToken(node.expression), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitWhileStatement = function (node) {
            return node.update(this.visitToken(node.whileKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitWithStatement = function (node) {
            return node.update(this.visitToken(node.withKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitEnumDeclaration = function (node) {
            return node.update(this.visitList(node.modifiers), this.visitToken(node.enumKeyword), this.visitToken(node.identifier), this.visitToken(node.openBraceToken), this.visitSeparatedList(node.enumElements), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitEnumElement = function (node) {
            return node.update(this.visitToken(node.propertyName), node.equalsValueClause === null ? null : this.visitNode(node.equalsValueClause));
        };

        SyntaxRewriter.prototype.visitCastExpression = function (node) {
            return node.update(this.visitToken(node.lessThanToken), this.visitNodeOrToken(node.type), this.visitToken(node.greaterThanToken), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitObjectLiteralExpression = function (node) {
            return node.update(this.visitToken(node.openBraceToken), this.visitSeparatedList(node.propertyAssignments), this.visitToken(node.closeBraceToken));
        };

        SyntaxRewriter.prototype.visitSimplePropertyAssignment = function (node) {
            return node.update(this.visitToken(node.propertyName), this.visitToken(node.colonToken), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitFunctionPropertyAssignment = function (node) {
            return node.update(this.visitToken(node.propertyName), this.visitNode(node.callSignature), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitFunctionExpression = function (node) {
            return node.update(this.visitToken(node.functionKeyword), node.identifier === null ? null : this.visitToken(node.identifier), this.visitNode(node.callSignature), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitEmptyStatement = function (node) {
            return node.update(this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitTryStatement = function (node) {
            return node.update(this.visitToken(node.tryKeyword), this.visitNode(node.block), node.catchClause === null ? null : this.visitNode(node.catchClause), node.finallyClause === null ? null : this.visitNode(node.finallyClause));
        };

        SyntaxRewriter.prototype.visitCatchClause = function (node) {
            return node.update(this.visitToken(node.catchKeyword), this.visitToken(node.openParenToken), this.visitToken(node.identifier), node.typeAnnotation === null ? null : this.visitNode(node.typeAnnotation), this.visitToken(node.closeParenToken), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitFinallyClause = function (node) {
            return node.update(this.visitToken(node.finallyKeyword), this.visitNode(node.block));
        };

        SyntaxRewriter.prototype.visitLabeledStatement = function (node) {
            return node.update(this.visitToken(node.identifier), this.visitToken(node.colonToken), this.visitNodeOrToken(node.statement));
        };

        SyntaxRewriter.prototype.visitDoStatement = function (node) {
            return node.update(this.visitToken(node.doKeyword), this.visitNodeOrToken(node.statement), this.visitToken(node.whileKeyword), this.visitToken(node.openParenToken), this.visitNodeOrToken(node.condition), this.visitToken(node.closeParenToken), this.visitToken(node.semicolonToken));
        };

        SyntaxRewriter.prototype.visitTypeOfExpression = function (node) {
            return node.update(this.visitToken(node.typeOfKeyword), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitDeleteExpression = function (node) {
            return node.update(this.visitToken(node.deleteKeyword), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitVoidExpression = function (node) {
            return node.update(this.visitToken(node.voidKeyword), this.visitNodeOrToken(node.expression));
        };

        SyntaxRewriter.prototype.visitDebuggerStatement = function (node) {
            return node.update(this.visitToken(node.debuggerKeyword), this.visitToken(node.semicolonToken));
        };
        return SyntaxRewriter;
    })();
    TypeScript.SyntaxRewriter = SyntaxRewriter;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxDedenter = (function (_super) {
        __extends(SyntaxDedenter, _super);
        function SyntaxDedenter(dedentFirstToken, dedentationAmount, minimumIndent, options) {
            _super.call(this);
            this.dedentationAmount = dedentationAmount;
            this.minimumIndent = minimumIndent;
            this.options = options;
            this.lastTriviaWasNewLine = dedentFirstToken;
        }
        SyntaxDedenter.prototype.abort = function () {
            this.lastTriviaWasNewLine = false;
            this.dedentationAmount = 0;
        };

        SyntaxDedenter.prototype.isAborted = function () {
            return this.dedentationAmount === 0;
        };

        SyntaxDedenter.prototype.visitToken = function (token) {
            if (token.width() === 0) {
                return token;
            }

            var result = token;
            if (this.lastTriviaWasNewLine) {
                result = token.withLeadingTrivia(this.dedentTriviaList(token.leadingTrivia()));
            }

            if (this.isAborted()) {
                return token;
            }

            this.lastTriviaWasNewLine = token.hasTrailingNewLine();
            return result;
        };

        SyntaxDedenter.prototype.dedentTriviaList = function (triviaList) {
            var result = [];
            var dedentNextWhitespace = true;

            for (var i = 0, n = triviaList.count(); i < n && !this.isAborted(); i++) {
                var trivia = triviaList.syntaxTriviaAt(i);

                var dedentThisTrivia = dedentNextWhitespace;
                dedentNextWhitespace = false;

                if (dedentThisTrivia) {
                    if (trivia.kind() === 4 /* WhitespaceTrivia */) {
                        var hasFollowingNewLine = (i < triviaList.count() - 1) && triviaList.syntaxTriviaAt(i + 1).kind() === 5 /* NewLineTrivia */;
                        result.push(this.dedentWhitespace(trivia, hasFollowingNewLine));
                        continue;
                    } else if (trivia.kind() !== 5 /* NewLineTrivia */) {
                        this.abort();
                        break;
                    }
                }

                if (trivia.kind() === 6 /* MultiLineCommentTrivia */) {
                    result.push(this.dedentMultiLineComment(trivia));
                    continue;
                }

                result.push(trivia);
                if (trivia.kind() === 5 /* NewLineTrivia */) {
                    dedentNextWhitespace = true;
                }
            }

            if (dedentNextWhitespace) {
                this.abort();
            }

            if (this.isAborted()) {
                return triviaList;
            }

            return TypeScript.Syntax.triviaList(result);
        };

        SyntaxDedenter.prototype.dedentSegment = function (segment, hasFollowingNewLineTrivia) {
            var firstNonWhitespacePosition = TypeScript.Indentation.firstNonWhitespacePosition(segment);

            if (firstNonWhitespacePosition === segment.length) {
                if (hasFollowingNewLineTrivia) {
                    return "";
                }
            } else if (TypeScript.CharacterInfo.isLineTerminator(segment.charCodeAt(firstNonWhitespacePosition))) {
                return segment.substring(firstNonWhitespacePosition);
            }

            var firstNonWhitespaceColumn = TypeScript.Indentation.columnForPositionInString(segment, firstNonWhitespacePosition, this.options);

            var newFirstNonWhitespaceColumn = TypeScript.MathPrototype.min(firstNonWhitespaceColumn, TypeScript.MathPrototype.max(firstNonWhitespaceColumn - this.dedentationAmount, this.minimumIndent));

            if (newFirstNonWhitespaceColumn === firstNonWhitespaceColumn) {
                this.abort();
                return segment;
            }

            this.dedentationAmount = firstNonWhitespaceColumn - newFirstNonWhitespaceColumn;
            TypeScript.Debug.assert(this.dedentationAmount >= 0);

            var indentationString = TypeScript.Indentation.indentationString(newFirstNonWhitespaceColumn, this.options);

            return indentationString + segment.substring(firstNonWhitespacePosition);
        };

        SyntaxDedenter.prototype.dedentWhitespace = function (trivia, hasFollowingNewLineTrivia) {
            var newIndentation = this.dedentSegment(trivia.fullText(), hasFollowingNewLineTrivia);
            return TypeScript.Syntax.whitespace(newIndentation);
        };

        SyntaxDedenter.prototype.dedentMultiLineComment = function (trivia) {
            var segments = TypeScript.Syntax.splitMultiLineCommentTriviaIntoMultipleLines(trivia);
            if (segments.length === 1) {
                return trivia;
            }

            for (var i = 1; i < segments.length; i++) {
                var segment = segments[i];
                segments[i] = this.dedentSegment(segment, false);
            }

            var result = segments.join("");

            return TypeScript.Syntax.multiLineComment(result);
        };

        SyntaxDedenter.dedentNode = function (node, dedentFirstToken, dedentAmount, minimumIndent, options) {
            var dedenter = new SyntaxDedenter(dedentFirstToken, dedentAmount, minimumIndent, options);
            var result = node.accept(dedenter);

            if (dedenter.isAborted()) {
                return node;
            }

            return result;
        };
        return SyntaxDedenter;
    })(TypeScript.SyntaxRewriter);
    TypeScript.SyntaxDedenter = SyntaxDedenter;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxIndenter = (function (_super) {
        __extends(SyntaxIndenter, _super);
        function SyntaxIndenter(indentFirstToken, indentationAmount, options) {
            _super.call(this);
            this.indentationAmount = indentationAmount;
            this.options = options;
            this.lastTriviaWasNewLine = indentFirstToken;
            this.indentationTrivia = TypeScript.Indentation.indentationTrivia(this.indentationAmount, this.options);
        }
        SyntaxIndenter.prototype.visitToken = function (token) {
            if (token.width() === 0) {
                return token;
            }

            var result = token;
            if (this.lastTriviaWasNewLine) {
                result = token.withLeadingTrivia(this.indentTriviaList(token.leadingTrivia()));
            }

            this.lastTriviaWasNewLine = token.hasTrailingNewLine();
            return result;
        };

        SyntaxIndenter.prototype.indentTriviaList = function (triviaList) {
            var result = [];

            var indentNextTrivia = true;
            for (var i = 0, n = triviaList.count(); i < n; i++) {
                var trivia = triviaList.syntaxTriviaAt(i);

                var indentThisTrivia = indentNextTrivia;
                indentNextTrivia = false;

                switch (trivia.kind()) {
                    case 6 /* MultiLineCommentTrivia */:
                        this.indentMultiLineComment(trivia, indentThisTrivia, result);
                        continue;

                    case 7 /* SingleLineCommentTrivia */:
                    case 8 /* SkippedTokenTrivia */:
                        this.indentSingleLineOrSkippedText(trivia, indentThisTrivia, result);
                        continue;

                    case 4 /* WhitespaceTrivia */:
                        this.indentWhitespace(trivia, indentThisTrivia, result);
                        continue;

                    case 5 /* NewLineTrivia */:
                        result.push(trivia);
                        indentNextTrivia = true;
                        continue;

                    default:
                        throw TypeScript.Errors.invalidOperation();
                }
            }

            if (indentNextTrivia) {
                result.push(this.indentationTrivia);
            }

            return TypeScript.Syntax.triviaList(result);
        };

        SyntaxIndenter.prototype.indentSegment = function (segment) {
            var firstNonWhitespacePosition = TypeScript.Indentation.firstNonWhitespacePosition(segment);

            if (firstNonWhitespacePosition < segment.length && TypeScript.CharacterInfo.isLineTerminator(segment.charCodeAt(firstNonWhitespacePosition))) {
                return segment;
            }

            var firstNonWhitespaceColumn = TypeScript.Indentation.columnForPositionInString(segment, firstNonWhitespacePosition, this.options);

            var newFirstNonWhitespaceColumn = firstNonWhitespaceColumn + this.indentationAmount;

            var indentationString = TypeScript.Indentation.indentationString(newFirstNonWhitespaceColumn, this.options);

            return indentationString + segment.substring(firstNonWhitespacePosition);
        };

        SyntaxIndenter.prototype.indentWhitespace = function (trivia, indentThisTrivia, result) {
            if (!indentThisTrivia) {
                result.push(trivia);
                return;
            }

            var newIndentation = this.indentSegment(trivia.fullText());
            result.push(TypeScript.Syntax.whitespace(newIndentation));
        };

        SyntaxIndenter.prototype.indentSingleLineOrSkippedText = function (trivia, indentThisTrivia, result) {
            if (indentThisTrivia) {
                result.push(this.indentationTrivia);
            }

            result.push(trivia);
        };

        SyntaxIndenter.prototype.indentMultiLineComment = function (trivia, indentThisTrivia, result) {
            if (indentThisTrivia) {
                result.push(this.indentationTrivia);
            }

            var segments = TypeScript.Syntax.splitMultiLineCommentTriviaIntoMultipleLines(trivia);

            for (var i = 1; i < segments.length; i++) {
                segments[i] = this.indentSegment(segments[i]);
            }

            var newText = segments.join("");
            result.push(TypeScript.Syntax.multiLineComment(newText));
        };

        SyntaxIndenter.indentNode = function (node, indentFirstToken, indentAmount, options) {
            var indenter = new SyntaxIndenter(indentFirstToken, indentAmount, options);
            return node.accept(indenter);
        };

        SyntaxIndenter.indentNodes = function (nodes, indentFirstToken, indentAmount, options) {
            var indenter = new SyntaxIndenter(indentFirstToken, indentAmount, options);
            var result = TypeScript.ArrayUtilities.select(nodes, function (n) {
                return n.accept(indenter);
            });

            return result;
        };
        return SyntaxIndenter;
    })(TypeScript.SyntaxRewriter);
    TypeScript.SyntaxIndenter = SyntaxIndenter;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var VariableWidthTokenWithNoTrivia = (function () {
            function VariableWidthTokenWithNoTrivia(fullText, kind) {
                this._fullText = fullText;
                this.tokenKind = kind;
            }
            VariableWidthTokenWithNoTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithNoTrivia(this._fullText, this.tokenKind);
            };

            VariableWidthTokenWithNoTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithNoTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithNoTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithNoTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithNoTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithNoTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            VariableWidthTokenWithNoTrivia.prototype.width = function () {
                return this.fullWidth() - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            VariableWidthTokenWithNoTrivia.prototype.text = function () {
                return this.fullText().substr(this.leadingTriviaWidth(), this.width());
            };
            VariableWidthTokenWithNoTrivia.prototype.fullText = function () {
                return this._fullText;
            };

            VariableWidthTokenWithNoTrivia.prototype.value = function () {
                if (this._value === undefined) {
                    this._value = Syntax.value(this);
                }

                return this._value;
            };

            VariableWidthTokenWithNoTrivia.prototype.valueText = function () {
                if (this._valueText === undefined) {
                    this._valueText = Syntax.valueText(this);
                }

                return this._valueText;
            };

            VariableWidthTokenWithNoTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithNoTrivia.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithNoTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithNoTrivia.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithNoTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithNoTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithNoTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithNoTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithNoTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithNoTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithNoTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithNoTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithNoTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithNoTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithNoTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            VariableWidthTokenWithNoTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            VariableWidthTokenWithNoTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithNoTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithNoTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithNoTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return VariableWidthTokenWithNoTrivia;
        })();
        Syntax.VariableWidthTokenWithNoTrivia = VariableWidthTokenWithNoTrivia;

        var VariableWidthTokenWithLeadingTrivia = (function () {
            function VariableWidthTokenWithLeadingTrivia(fullText, kind, leadingTriviaInfo) {
                this._fullText = fullText;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
            }
            VariableWidthTokenWithLeadingTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithLeadingTrivia(this._fullText, this.tokenKind, this._leadingTriviaInfo);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithLeadingTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.width = function () {
                return this.fullWidth() - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            VariableWidthTokenWithLeadingTrivia.prototype.text = function () {
                return this.fullText().substr(this.leadingTriviaWidth(), this.width());
            };
            VariableWidthTokenWithLeadingTrivia.prototype.fullText = function () {
                return this._fullText;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.value = function () {
                if (this._value === undefined) {
                    this._value = Syntax.value(this);
                }

                return this._value;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.valueText = function () {
                if (this._valueText === undefined) {
                    this._valueText = Syntax.valueText(this);
                }

                return this._valueText;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), 0, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithLeadingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithLeadingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithLeadingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            VariableWidthTokenWithLeadingTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithLeadingTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithLeadingTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithLeadingTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return VariableWidthTokenWithLeadingTrivia;
        })();
        Syntax.VariableWidthTokenWithLeadingTrivia = VariableWidthTokenWithLeadingTrivia;

        var VariableWidthTokenWithTrailingTrivia = (function () {
            function VariableWidthTokenWithTrailingTrivia(fullText, kind, trailingTriviaInfo) {
                this._fullText = fullText;
                this.tokenKind = kind;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            VariableWidthTokenWithTrailingTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithTrailingTrivia(this._fullText, this.tokenKind, this._trailingTriviaInfo);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithTrailingTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.width = function () {
                return this.fullWidth() - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            VariableWidthTokenWithTrailingTrivia.prototype.text = function () {
                return this.fullText().substr(this.leadingTriviaWidth(), this.width());
            };
            VariableWidthTokenWithTrailingTrivia.prototype.fullText = function () {
                return this._fullText;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.value = function () {
                if (this._value === undefined) {
                    this._value = Syntax.value(this);
                }

                return this._value;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.valueText = function () {
                if (this._valueText === undefined) {
                    this._valueText = Syntax.valueText(this);
                }

                return this._valueText;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), this.leadingTriviaWidth() + this.width(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            VariableWidthTokenWithTrailingTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithTrailingTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithTrailingTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithTrailingTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return VariableWidthTokenWithTrailingTrivia;
        })();
        Syntax.VariableWidthTokenWithTrailingTrivia = VariableWidthTokenWithTrailingTrivia;

        var VariableWidthTokenWithLeadingAndTrailingTrivia = (function () {
            function VariableWidthTokenWithLeadingAndTrailingTrivia(fullText, kind, leadingTriviaInfo, trailingTriviaInfo) {
                this._fullText = fullText;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.clone = function () {
                return new VariableWidthTokenWithLeadingAndTrailingTrivia(this._fullText, this.tokenKind, this._leadingTriviaInfo, this._trailingTriviaInfo);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isList = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.width = function () {
                return this.fullWidth() - this.leadingTriviaWidth() - this.trailingTriviaWidth();
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.text = function () {
                return this.fullText().substr(this.leadingTriviaWidth(), this.width());
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.fullText = function () {
                return this._fullText;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.value = function () {
                if (this._value === undefined) {
                    this._value = Syntax.value(this);
                }

                return this._value;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.valueText = function () {
                if (this._valueText === undefined) {
                    this._valueText = Syntax.valueText(this);
                }

                return this._valueText;
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), 0, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), this.leadingTriviaWidth() + this.width(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            VariableWidthTokenWithLeadingAndTrailingTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return VariableWidthTokenWithLeadingAndTrailingTrivia;
        })();
        Syntax.VariableWidthTokenWithLeadingAndTrailingTrivia = VariableWidthTokenWithLeadingAndTrailingTrivia;

        var FixedWidthTokenWithNoTrivia = (function () {
            function FixedWidthTokenWithNoTrivia(kind) {
                this.tokenKind = kind;
            }
            FixedWidthTokenWithNoTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithNoTrivia(this.tokenKind);
            };

            FixedWidthTokenWithNoTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithNoTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithNoTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithNoTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithNoTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithNoTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            FixedWidthTokenWithNoTrivia.prototype.width = function () {
                return this.text().length;
            };

            FixedWidthTokenWithNoTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithNoTrivia.prototype.fullText = function () {
                return this.text();
            };

            FixedWidthTokenWithNoTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithNoTrivia.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithNoTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithNoTrivia.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithNoTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithNoTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithNoTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithNoTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithNoTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithNoTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithNoTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithNoTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithNoTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            FixedWidthTokenWithNoTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            FixedWidthTokenWithNoTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithNoTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithNoTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithNoTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return FixedWidthTokenWithNoTrivia;
        })();
        Syntax.FixedWidthTokenWithNoTrivia = FixedWidthTokenWithNoTrivia;

        var FixedWidthTokenWithLeadingTrivia = (function () {
            function FixedWidthTokenWithLeadingTrivia(fullText, kind, leadingTriviaInfo) {
                this._fullText = fullText;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
            }
            FixedWidthTokenWithLeadingTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithLeadingTrivia(this._fullText, this.tokenKind, this._leadingTriviaInfo);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithLeadingTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.width = function () {
                return this.text().length;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.fullText = function () {
                return this._fullText;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), 0, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingComment = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithLeadingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithLeadingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithLeadingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            FixedWidthTokenWithLeadingTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithLeadingTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithLeadingTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithLeadingTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return FixedWidthTokenWithLeadingTrivia;
        })();
        Syntax.FixedWidthTokenWithLeadingTrivia = FixedWidthTokenWithLeadingTrivia;

        var FixedWidthTokenWithTrailingTrivia = (function () {
            function FixedWidthTokenWithTrailingTrivia(fullText, kind, trailingTriviaInfo) {
                this._fullText = fullText;
                this.tokenKind = kind;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            FixedWidthTokenWithTrailingTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithTrailingTrivia(this._fullText, this.tokenKind, this._trailingTriviaInfo);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithTrailingTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.width = function () {
                return this.text().length;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.fullText = function () {
                return this._fullText;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingComment = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };

            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), this.leadingTriviaWidth() + this.width(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            FixedWidthTokenWithTrailingTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithTrailingTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithTrailingTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithTrailingTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return FixedWidthTokenWithTrailingTrivia;
        })();
        Syntax.FixedWidthTokenWithTrailingTrivia = FixedWidthTokenWithTrailingTrivia;

        var FixedWidthTokenWithLeadingAndTrailingTrivia = (function () {
            function FixedWidthTokenWithLeadingAndTrailingTrivia(fullText, kind, leadingTriviaInfo, trailingTriviaInfo) {
                this._fullText = fullText;
                this.tokenKind = kind;
                this._leadingTriviaInfo = leadingTriviaInfo;
                this._trailingTriviaInfo = trailingTriviaInfo;
            }
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.clone = function () {
                return new FixedWidthTokenWithLeadingAndTrailingTrivia(this._fullText, this.tokenKind, this._leadingTriviaInfo, this._trailingTriviaInfo);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isNode = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isToken = function () {
                return true;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isList = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isSeparatedList = function () {
                return false;
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.kind = function () {
                return this.tokenKind;
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.childCount = function () {
                return 0;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange('index');
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.width = function () {
                return this.text().length;
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.text = function () {
                return TypeScript.SyntaxFacts.getText(this.tokenKind);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.fullText = function () {
                return this._fullText;
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.value = function () {
                return Syntax.value(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.valueText = function () {
                return Syntax.valueText(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingComment = function () {
                return hasTriviaComment(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingNewLine = function () {
                return hasTriviaNewLine(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTriviaWidth = function () {
                return getTriviaWidth(this._leadingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.leadingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), 0, getTriviaWidth(this._leadingTriviaInfo), false);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingTrivia = function () {
                return true;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingComment = function () {
                return hasTriviaComment(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingNewLine = function () {
                return hasTriviaNewLine(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTriviaWidth = function () {
                return getTriviaWidth(this._trailingTriviaInfo);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.trailingTrivia = function () {
                return TypeScript.Scanner.scanTrivia(TypeScript.SimpleText.fromString(this._fullText), this.leadingTriviaWidth() + this.width(), getTriviaWidth(this._trailingTriviaInfo), true);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.hasSkippedToken = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.toJSON = function (key) {
                return Syntax.tokenToJSON(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.firstToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.lastToken = function () {
                return this;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isTypeScriptSpecific = function () {
                return false;
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isIncrementallyUnusable = function () {
                return this.fullWidth() === 0 || TypeScript.SyntaxFacts.isAnyDivideOrRegularExpressionToken(this.tokenKind);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.realize = function () {
                return Syntax.realizeToken(this);
            };
            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.collectTextElements = function (elements) {
                collectTokenTextElements(this, elements);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isExpression = function () {
                return Syntax.isExpression(this);
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            FixedWidthTokenWithLeadingAndTrailingTrivia.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return FixedWidthTokenWithLeadingAndTrailingTrivia;
        })();
        Syntax.FixedWidthTokenWithLeadingAndTrailingTrivia = FixedWidthTokenWithLeadingAndTrailingTrivia;

        function collectTokenTextElements(token, elements) {
            token.leadingTrivia().collectTextElements(elements);
            elements.push(token.text());
            token.trailingTrivia().collectTextElements(elements);
        }

        function getTriviaWidth(value) {
            return value >>> 2 /* TriviaFullWidthShift */;
        }

        function hasTriviaComment(value) {
            return (value & 2 /* TriviaCommentMask */) !== 0;
        }

        function hasTriviaNewLine(value) {
            return (value & 1 /* TriviaNewLineMask */) !== 0;
        }
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        function isExpression(token) {
            switch (token.tokenKind) {
                case 11 /* IdentifierName */:
                case 12 /* RegularExpressionLiteral */:
                case 13 /* NumericLiteral */:
                case 14 /* StringLiteral */:
                case 24 /* FalseKeyword */:
                case 32 /* NullKeyword */:
                case 35 /* ThisKeyword */:
                case 37 /* TrueKeyword */:
                case 50 /* SuperKeyword */:
                    return true;
            }

            return false;
        }
        Syntax.isExpression = isExpression;

        function realizeToken(token) {
            return new RealizedToken(token.tokenKind, token.leadingTrivia(), token.text(), token.value(), token.valueText(), token.trailingTrivia());
        }
        Syntax.realizeToken = realizeToken;

        function convertToIdentifierName(token) {
            TypeScript.Debug.assert(TypeScript.SyntaxFacts.isAnyKeyword(token.tokenKind));
            return new RealizedToken(11 /* IdentifierName */, token.leadingTrivia(), token.text(), token.text(), token.text(), token.trailingTrivia());
        }
        Syntax.convertToIdentifierName = convertToIdentifierName;

        function tokenToJSON(token) {
            var result = {};

            for (var name in TypeScript.SyntaxKind) {
                if (TypeScript.SyntaxKind[name] === token.kind()) {
                    result.kind = name;
                    break;
                }
            }

            result.width = token.width();
            if (token.fullWidth() !== token.width()) {
                result.fullWidth = token.fullWidth();
            }

            result.text = token.text();

            var value = token.value();
            if (value !== null) {
                result.value = value;
                result.valueText = token.valueText();
            }

            if (token.hasLeadingTrivia()) {
                result.hasLeadingTrivia = true;
            }

            if (token.hasLeadingComment()) {
                result.hasLeadingComment = true;
            }

            if (token.hasLeadingNewLine()) {
                result.hasLeadingNewLine = true;
            }

            if (token.hasLeadingSkippedText()) {
                result.hasLeadingSkippedText = true;
            }

            if (token.hasTrailingTrivia()) {
                result.hasTrailingTrivia = true;
            }

            if (token.hasTrailingComment()) {
                result.hasTrailingComment = true;
            }

            if (token.hasTrailingNewLine()) {
                result.hasTrailingNewLine = true;
            }

            if (token.hasTrailingSkippedText()) {
                result.hasTrailingSkippedText = true;
            }

            var trivia = token.leadingTrivia();
            if (trivia.count() > 0) {
                result.leadingTrivia = trivia;
            }

            trivia = token.trailingTrivia();
            if (trivia.count() > 0) {
                result.trailingTrivia = trivia;
            }

            return result;
        }
        Syntax.tokenToJSON = tokenToJSON;

        function value(token) {
            return value1(token.tokenKind, token.text());
        }
        Syntax.value = value;

        function hexValue(text, start, length) {
            var intChar = 0;
            for (var i = 0; i < length; i++) {
                var ch2 = text.charCodeAt(start + i);
                if (!TypeScript.CharacterInfo.isHexDigit(ch2)) {
                    break;
                }

                intChar = (intChar << 4) + TypeScript.CharacterInfo.hexValue(ch2);
            }

            return intChar;
        }

        var characterArray = [];

        function convertEscapes(text) {
            characterArray.length = 0;
            var result = "";

            for (var i = 0, n = text.length; i < n; i++) {
                var ch = text.charCodeAt(i);

                if (ch === 92 /* backslash */) {
                    i++;
                    if (i < n) {
                        ch = text.charCodeAt(i);
                        switch (ch) {
                            case 48 /* _0 */:
                                characterArray.push(0 /* nullCharacter */);
                                continue;

                            case 98 /* b */:
                                characterArray.push(8 /* backspace */);
                                continue;

                            case 102 /* f */:
                                characterArray.push(12 /* formFeed */);
                                continue;

                            case 110 /* n */:
                                characterArray.push(10 /* lineFeed */);
                                continue;

                            case 114 /* r */:
                                characterArray.push(13 /* carriageReturn */);
                                continue;

                            case 116 /* t */:
                                characterArray.push(9 /* tab */);
                                continue;

                            case 118 /* v */:
                                characterArray.push(11 /* verticalTab */);
                                continue;

                            case 120 /* x */:
                                characterArray.push(hexValue(text, i + 1, 2));
                                i += 2;
                                continue;

                            case 117 /* u */:
                                characterArray.push(hexValue(text, i + 1, 4));
                                i += 4;
                                continue;

                            case 13 /* carriageReturn */:
                                var nextIndex = i + 1;
                                if (nextIndex < text.length && text.charCodeAt(nextIndex) === 10 /* lineFeed */) {
                                    i++;
                                }
                                continue;

                            case 10 /* lineFeed */:
                            case 8233 /* paragraphSeparator */:
                            case 8232 /* lineSeparator */:
                                continue;

                            default:
                        }
                    }
                }

                characterArray.push(ch);

                if (i && !(i % 1024)) {
                    result = result.concat(String.fromCharCode.apply(null, characterArray));
                    characterArray.length = 0;
                }
            }

            if (characterArray.length) {
                result = result.concat(String.fromCharCode.apply(null, characterArray));
            }

            return result;
        }

        function massageEscapes(text) {
            return text.indexOf("\\") >= 0 ? convertEscapes(text) : text;
        }
        Syntax.massageEscapes = massageEscapes;

        function value1(kind, text) {
            if (kind === 11 /* IdentifierName */) {
                return massageEscapes(text);
            }

            switch (kind) {
                case 37 /* TrueKeyword */:
                    return true;
                case 24 /* FalseKeyword */:
                    return false;
                case 32 /* NullKeyword */:
                    return null;
            }

            if (TypeScript.SyntaxFacts.isAnyKeyword(kind) || TypeScript.SyntaxFacts.isAnyPunctuation(kind)) {
                return TypeScript.SyntaxFacts.getText(kind);
            }

            if (kind === 13 /* NumericLiteral */) {
                return TypeScript.IntegerUtilities.isHexInteger(text) ? parseInt(text, 16) : parseFloat(text);
            } else if (kind === 14 /* StringLiteral */) {
                if (text.length > 1 && text.charCodeAt(text.length - 1) === text.charCodeAt(0)) {
                    return massageEscapes(text.substr(1, text.length - 2));
                } else {
                    return massageEscapes(text.substr(1));
                }
            } else if (kind === 12 /* RegularExpressionLiteral */) {
                return regularExpressionValue(text);
            } else if (kind === 10 /* EndOfFileToken */ || kind === 9 /* ErrorToken */) {
                return null;
            } else {
                throw TypeScript.Errors.invalidOperation();
            }
        }

        function regularExpressionValue(text) {
            try  {
                var lastSlash = text.lastIndexOf("/");
                var body = text.substring(1, lastSlash);
                var flags = text.substring(lastSlash + 1);
                return new RegExp(body, flags);
            } catch (e) {
                return null;
            }
        }

        function valueText1(kind, text) {
            var value = value1(kind, text);
            return value === null ? "" : value.toString();
        }

        function valueText(token) {
            var value = token.value();
            return value === null ? "" : value.toString();
        }
        Syntax.valueText = valueText;

        var EmptyToken = (function () {
            function EmptyToken(kind) {
                this.tokenKind = kind;
            }
            EmptyToken.prototype.clone = function () {
                return new EmptyToken(this.tokenKind);
            };

            EmptyToken.prototype.kind = function () {
                return this.tokenKind;
            };

            EmptyToken.prototype.isToken = function () {
                return true;
            };
            EmptyToken.prototype.isNode = function () {
                return false;
            };
            EmptyToken.prototype.isList = function () {
                return false;
            };
            EmptyToken.prototype.isSeparatedList = function () {
                return false;
            };

            EmptyToken.prototype.childCount = function () {
                return 0;
            };

            EmptyToken.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            EmptyToken.prototype.toJSON = function (key) {
                return tokenToJSON(this);
            };
            EmptyToken.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };

            EmptyToken.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            EmptyToken.prototype.firstToken = function () {
                return this;
            };
            EmptyToken.prototype.lastToken = function () {
                return this;
            };
            EmptyToken.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            EmptyToken.prototype.isIncrementallyUnusable = function () {
                return true;
            };

            EmptyToken.prototype.fullWidth = function () {
                return 0;
            };
            EmptyToken.prototype.width = function () {
                return 0;
            };
            EmptyToken.prototype.text = function () {
                return "";
            };
            EmptyToken.prototype.fullText = function () {
                return "";
            };
            EmptyToken.prototype.value = function () {
                return null;
            };
            EmptyToken.prototype.valueText = function () {
                return "";
            };

            EmptyToken.prototype.hasLeadingTrivia = function () {
                return false;
            };
            EmptyToken.prototype.hasLeadingComment = function () {
                return false;
            };
            EmptyToken.prototype.hasLeadingNewLine = function () {
                return false;
            };
            EmptyToken.prototype.hasLeadingSkippedText = function () {
                return false;
            };
            EmptyToken.prototype.leadingTriviaWidth = function () {
                return 0;
            };
            EmptyToken.prototype.hasTrailingTrivia = function () {
                return false;
            };
            EmptyToken.prototype.hasTrailingComment = function () {
                return false;
            };
            EmptyToken.prototype.hasTrailingNewLine = function () {
                return false;
            };
            EmptyToken.prototype.hasTrailingSkippedText = function () {
                return false;
            };
            EmptyToken.prototype.hasSkippedToken = function () {
                return false;
            };

            EmptyToken.prototype.trailingTriviaWidth = function () {
                return 0;
            };
            EmptyToken.prototype.leadingTrivia = function () {
                return Syntax.emptyTriviaList;
            };
            EmptyToken.prototype.trailingTrivia = function () {
                return Syntax.emptyTriviaList;
            };
            EmptyToken.prototype.realize = function () {
                return realizeToken(this);
            };
            EmptyToken.prototype.collectTextElements = function (elements) {
            };

            EmptyToken.prototype.withLeadingTrivia = function (leadingTrivia) {
                return this.realize().withLeadingTrivia(leadingTrivia);
            };

            EmptyToken.prototype.withTrailingTrivia = function (trailingTrivia) {
                return this.realize().withTrailingTrivia(trailingTrivia);
            };

            EmptyToken.prototype.isExpression = function () {
                return isExpression(this);
            };

            EmptyToken.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            EmptyToken.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            EmptyToken.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            EmptyToken.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return EmptyToken;
        })();

        function emptyToken(kind) {
            return new EmptyToken(kind);
        }
        Syntax.emptyToken = emptyToken;

        var RealizedToken = (function () {
            function RealizedToken(tokenKind, leadingTrivia, text, value, valueText, trailingTrivia) {
                this.tokenKind = tokenKind;
                this._leadingTrivia = leadingTrivia;
                this._text = text;
                this._value = value;
                this._valueText = valueText;
                this._trailingTrivia = trailingTrivia;
            }
            RealizedToken.prototype.clone = function () {
                return new RealizedToken(this.tokenKind, this._leadingTrivia, this._text, this._value, this._valueText, this._trailingTrivia);
            };

            RealizedToken.prototype.kind = function () {
                return this.tokenKind;
            };
            RealizedToken.prototype.toJSON = function (key) {
                return tokenToJSON(this);
            };
            RealizedToken.prototype.firstToken = function () {
                return this;
            };
            RealizedToken.prototype.lastToken = function () {
                return this;
            };
            RealizedToken.prototype.isTypeScriptSpecific = function () {
                return false;
            };

            RealizedToken.prototype.isIncrementallyUnusable = function () {
                return true;
            };

            RealizedToken.prototype.accept = function (visitor) {
                return visitor.visitToken(this);
            };

            RealizedToken.prototype.childCount = function () {
                return 0;
            };

            RealizedToken.prototype.childAt = function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            };

            RealizedToken.prototype.isToken = function () {
                return true;
            };
            RealizedToken.prototype.isNode = function () {
                return false;
            };
            RealizedToken.prototype.isList = function () {
                return false;
            };
            RealizedToken.prototype.isSeparatedList = function () {
                return false;
            };
            RealizedToken.prototype.isTrivia = function () {
                return false;
            };
            RealizedToken.prototype.isTriviaList = function () {
                return false;
            };

            RealizedToken.prototype.fullWidth = function () {
                return this._leadingTrivia.fullWidth() + this.width() + this._trailingTrivia.fullWidth();
            };
            RealizedToken.prototype.width = function () {
                return this.text().length;
            };

            RealizedToken.prototype.text = function () {
                return this._text;
            };
            RealizedToken.prototype.fullText = function () {
                return this._leadingTrivia.fullText() + this.text() + this._trailingTrivia.fullText();
            };

            RealizedToken.prototype.value = function () {
                return this._value;
            };
            RealizedToken.prototype.valueText = function () {
                return this._valueText;
            };

            RealizedToken.prototype.hasLeadingTrivia = function () {
                return this._leadingTrivia.count() > 0;
            };
            RealizedToken.prototype.hasLeadingComment = function () {
                return this._leadingTrivia.hasComment();
            };
            RealizedToken.prototype.hasLeadingNewLine = function () {
                return this._leadingTrivia.hasNewLine();
            };
            RealizedToken.prototype.hasLeadingSkippedText = function () {
                return this._leadingTrivia.hasSkippedToken();
            };
            RealizedToken.prototype.leadingTriviaWidth = function () {
                return this._leadingTrivia.fullWidth();
            };

            RealizedToken.prototype.hasTrailingTrivia = function () {
                return this._trailingTrivia.count() > 0;
            };
            RealizedToken.prototype.hasTrailingComment = function () {
                return this._trailingTrivia.hasComment();
            };
            RealizedToken.prototype.hasTrailingNewLine = function () {
                return this._trailingTrivia.hasNewLine();
            };
            RealizedToken.prototype.hasTrailingSkippedText = function () {
                return this._trailingTrivia.hasSkippedToken();
            };
            RealizedToken.prototype.trailingTriviaWidth = function () {
                return this._trailingTrivia.fullWidth();
            };

            RealizedToken.prototype.hasSkippedToken = function () {
                return this.hasLeadingSkippedText() || this.hasTrailingSkippedText();
            };

            RealizedToken.prototype.leadingTrivia = function () {
                return this._leadingTrivia;
            };
            RealizedToken.prototype.trailingTrivia = function () {
                return this._trailingTrivia;
            };

            RealizedToken.prototype.findTokenInternal = function (parent, position, fullStart) {
                return new TypeScript.PositionedToken(parent, this, fullStart);
            };

            RealizedToken.prototype.collectTextElements = function (elements) {
                this.leadingTrivia().collectTextElements(elements);
                elements.push(this.text());
                this.trailingTrivia().collectTextElements(elements);
            };

            RealizedToken.prototype.withLeadingTrivia = function (leadingTrivia) {
                return new RealizedToken(this.tokenKind, leadingTrivia, this._text, this._value, this._valueText, this._trailingTrivia);
            };

            RealizedToken.prototype.withTrailingTrivia = function (trailingTrivia) {
                return new RealizedToken(this.tokenKind, this._leadingTrivia, this._text, this._value, this._valueText, trailingTrivia);
            };

            RealizedToken.prototype.isExpression = function () {
                return isExpression(this);
            };

            RealizedToken.prototype.isPrimaryExpression = function () {
                return this.isExpression();
            };

            RealizedToken.prototype.isMemberExpression = function () {
                return this.isExpression();
            };

            RealizedToken.prototype.isPostfixExpression = function () {
                return this.isExpression();
            };

            RealizedToken.prototype.isUnaryExpression = function () {
                return this.isExpression();
            };
            return RealizedToken;
        })();

        function token(kind, info) {
            if (typeof info === "undefined") { info = null; }
            var text = (info !== null && info.text !== undefined) ? info.text : TypeScript.SyntaxFacts.getText(kind);

            return new RealizedToken(kind, Syntax.triviaList(info === null ? null : info.leadingTrivia), text, value1(kind, text), valueText1(kind, text), Syntax.triviaList(info === null ? null : info.trailingTrivia));
        }
        Syntax.token = token;

        function identifier(text, info) {
            if (typeof info === "undefined") { info = null; }
            info = info || {};
            info.text = text;
            return token(11 /* IdentifierName */, info);
        }
        Syntax.identifier = identifier;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxTokenReplacer = (function (_super) {
        __extends(SyntaxTokenReplacer, _super);
        function SyntaxTokenReplacer(token1, token2) {
            _super.call(this);
            this.token1 = token1;
            this.token2 = token2;
        }
        SyntaxTokenReplacer.prototype.visitToken = function (token) {
            if (token === this.token1) {
                var result = this.token2;
                this.token1 = null;
                this.token2 = null;

                return result;
            }

            return token;
        };

        SyntaxTokenReplacer.prototype.visitNode = function (node) {
            if (this.token1 === null) {
                return node;
            }

            return _super.prototype.visitNode.call(this, node);
        };

        SyntaxTokenReplacer.prototype.visitList = function (list) {
            if (this.token1 === null) {
                return list;
            }

            return _super.prototype.visitList.call(this, list);
        };

        SyntaxTokenReplacer.prototype.visitSeparatedList = function (list) {
            if (this.token1 === null) {
                return list;
            }

            return _super.prototype.visitSeparatedList.call(this, list);
        };
        return SyntaxTokenReplacer;
    })(TypeScript.SyntaxRewriter);
    TypeScript.SyntaxTokenReplacer = SyntaxTokenReplacer;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        var AbstractTrivia = (function () {
            function AbstractTrivia(_kind) {
                this._kind = _kind;
            }
            AbstractTrivia.prototype.fullWidth = function () {
                throw TypeScript.Errors.abstract();
            };

            AbstractTrivia.prototype.fullText = function () {
                throw TypeScript.Errors.abstract();
            };

            AbstractTrivia.prototype.skippedToken = function () {
                throw TypeScript.Errors.abstract();
            };

            AbstractTrivia.prototype.toJSON = function (key) {
                var result = {};

                for (var name in TypeScript.SyntaxKind) {
                    if (TypeScript.SyntaxKind[name] === this._kind) {
                        result.kind = name;
                        break;
                    }
                }

                if (this.isSkippedToken()) {
                    result.skippedToken = this.skippedToken();
                } else {
                    result.text = this.fullText();
                }
                return result;
            };

            AbstractTrivia.prototype.kind = function () {
                return this._kind;
            };

            AbstractTrivia.prototype.isWhitespace = function () {
                return this.kind() === 4 /* WhitespaceTrivia */;
            };

            AbstractTrivia.prototype.isComment = function () {
                return this.kind() === 7 /* SingleLineCommentTrivia */ || this.kind() === 6 /* MultiLineCommentTrivia */;
            };

            AbstractTrivia.prototype.isNewLine = function () {
                return this.kind() === 5 /* NewLineTrivia */;
            };

            AbstractTrivia.prototype.isSkippedToken = function () {
                return this.kind() === 8 /* SkippedTokenTrivia */;
            };

            AbstractTrivia.prototype.collectTextElements = function (elements) {
                elements.push(this.fullText());
            };
            return AbstractTrivia;
        })();

        var NormalTrivia = (function (_super) {
            __extends(NormalTrivia, _super);
            function NormalTrivia(kind, _text) {
                _super.call(this, kind);
                this._text = _text;
            }
            NormalTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };

            NormalTrivia.prototype.fullText = function () {
                return this._text;
            };

            NormalTrivia.prototype.skippedToken = function () {
                throw TypeScript.Errors.invalidOperation();
            };
            return NormalTrivia;
        })(AbstractTrivia);

        var SkippedTokenTrivia = (function (_super) {
            __extends(SkippedTokenTrivia, _super);
            function SkippedTokenTrivia(_skippedToken) {
                _super.call(this, 8 /* SkippedTokenTrivia */);
                this._skippedToken = _skippedToken;
            }
            SkippedTokenTrivia.prototype.fullWidth = function () {
                return this.fullText().length;
            };

            SkippedTokenTrivia.prototype.fullText = function () {
                return this.skippedToken().fullText();
            };

            SkippedTokenTrivia.prototype.skippedToken = function () {
                return this._skippedToken;
            };
            return SkippedTokenTrivia;
        })(AbstractTrivia);

        var DeferredTrivia = (function (_super) {
            __extends(DeferredTrivia, _super);
            function DeferredTrivia(kind, _text, _fullStart, _fullWidth) {
                _super.call(this, kind);
                this._text = _text;
                this._fullStart = _fullStart;
                this._fullWidth = _fullWidth;
                this._fullText = null;
            }
            DeferredTrivia.prototype.fullWidth = function () {
                return this._fullWidth;
            };

            DeferredTrivia.prototype.fullText = function () {
                if (!this._fullText) {
                    this._fullText = this._text.substr(this._fullStart, this._fullWidth, false);
                    this._text = null;
                }

                return this._fullText;
            };

            DeferredTrivia.prototype.skippedToken = function () {
                throw TypeScript.Errors.invalidOperation();
            };
            return DeferredTrivia;
        })(AbstractTrivia);

        function deferredTrivia(kind, text, fullStart, fullWidth) {
            return new DeferredTrivia(kind, text, fullStart, fullWidth);
        }
        Syntax.deferredTrivia = deferredTrivia;

        function trivia(kind, text) {
            return new NormalTrivia(kind, text);
        }
        Syntax.trivia = trivia;

        function skippedTokenTrivia(token) {
            TypeScript.Debug.assert(!token.hasLeadingTrivia());
            TypeScript.Debug.assert(!token.hasTrailingTrivia());
            TypeScript.Debug.assert(token.fullWidth() > 0);
            return new SkippedTokenTrivia(token);
        }
        Syntax.skippedTokenTrivia = skippedTokenTrivia;

        function spaces(count) {
            return trivia(4 /* WhitespaceTrivia */, TypeScript.StringUtilities.repeat(" ", count));
        }
        Syntax.spaces = spaces;

        function whitespace(text) {
            return trivia(4 /* WhitespaceTrivia */, text);
        }
        Syntax.whitespace = whitespace;

        function multiLineComment(text) {
            return trivia(6 /* MultiLineCommentTrivia */, text);
        }
        Syntax.multiLineComment = multiLineComment;

        function singleLineComment(text) {
            return trivia(7 /* SingleLineCommentTrivia */, text);
        }
        Syntax.singleLineComment = singleLineComment;

        Syntax.spaceTrivia = spaces(1);
        Syntax.lineFeedTrivia = trivia(5 /* NewLineTrivia */, "\n");
        Syntax.carriageReturnTrivia = trivia(5 /* NewLineTrivia */, "\r");
        Syntax.carriageReturnLineFeedTrivia = trivia(5 /* NewLineTrivia */, "\r\n");

        function splitMultiLineCommentTriviaIntoMultipleLines(trivia) {
            var result = [];

            var triviaText = trivia.fullText();
            var currentIndex = 0;

            for (var i = 0; i < triviaText.length; i++) {
                var ch = triviaText.charCodeAt(i);

                var isCarriageReturnLineFeed = false;
                switch (ch) {
                    case 13 /* carriageReturn */:
                        if (i < triviaText.length - 1 && triviaText.charCodeAt(i + 1) === 10 /* lineFeed */) {
                            i++;
                        }

                    case 10 /* lineFeed */:
                    case 8233 /* paragraphSeparator */:
                    case 8232 /* lineSeparator */:
                        result.push(triviaText.substring(currentIndex, i + 1));

                        currentIndex = i + 1;
                        continue;
                }
            }

            result.push(triviaText.substring(currentIndex));
            return result;
        }
        Syntax.splitMultiLineCommentTriviaIntoMultipleLines = splitMultiLineCommentTriviaIntoMultipleLines;
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));

var TypeScript;
(function (TypeScript) {
    (function (Syntax) {
        Syntax.emptyTriviaList = {
            kind: function () {
                return 3 /* TriviaList */;
            },
            count: function () {
                return 0;
            },
            syntaxTriviaAt: function (index) {
                throw TypeScript.Errors.argumentOutOfRange("index");
            },
            last: function () {
                throw TypeScript.Errors.argumentOutOfRange("index");
            },
            fullWidth: function () {
                return 0;
            },
            fullText: function () {
                return "";
            },
            hasComment: function () {
                return false;
            },
            hasNewLine: function () {
                return false;
            },
            hasSkippedToken: function () {
                return false;
            },
            toJSON: function (key) {
                return [];
            },
            collectTextElements: function (elements) {
            },
            toArray: function () {
                return [];
            },
            concat: function (trivia) {
                return trivia;
            }
        };

        function concatTrivia(list1, list2) {
            if (list1.count() === 0) {
                return list2;
            }

            if (list2.count() === 0) {
                return list1;
            }

            var trivia = list1.toArray();
            trivia.push.apply(trivia, list2.toArray());

            return triviaList(trivia);
        }

        function isComment(trivia) {
            return trivia.kind() === 6 /* MultiLineCommentTrivia */ || trivia.kind() === 7 /* SingleLineCommentTrivia */;
        }

        var SingletonSyntaxTriviaList = (function () {
            function SingletonSyntaxTriviaList(item) {
                this.item = item;
            }
            SingletonSyntaxTriviaList.prototype.kind = function () {
                return 3 /* TriviaList */;
            };

            SingletonSyntaxTriviaList.prototype.count = function () {
                return 1;
            };

            SingletonSyntaxTriviaList.prototype.syntaxTriviaAt = function (index) {
                if (index !== 0) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.item;
            };

            SingletonSyntaxTriviaList.prototype.last = function () {
                return this.item;
            };

            SingletonSyntaxTriviaList.prototype.fullWidth = function () {
                return this.item.fullWidth();
            };

            SingletonSyntaxTriviaList.prototype.fullText = function () {
                return this.item.fullText();
            };

            SingletonSyntaxTriviaList.prototype.hasComment = function () {
                return isComment(this.item);
            };

            SingletonSyntaxTriviaList.prototype.hasNewLine = function () {
                return this.item.kind() === 5 /* NewLineTrivia */;
            };

            SingletonSyntaxTriviaList.prototype.hasSkippedToken = function () {
                return this.item.kind() === 8 /* SkippedTokenTrivia */;
            };

            SingletonSyntaxTriviaList.prototype.toJSON = function (key) {
                return [this.item];
            };

            SingletonSyntaxTriviaList.prototype.collectTextElements = function (elements) {
                this.item.collectTextElements(elements);
            };

            SingletonSyntaxTriviaList.prototype.toArray = function () {
                return [this.item];
            };

            SingletonSyntaxTriviaList.prototype.concat = function (trivia) {
                return concatTrivia(this, trivia);
            };
            return SingletonSyntaxTriviaList;
        })();

        var NormalSyntaxTriviaList = (function () {
            function NormalSyntaxTriviaList(trivia) {
                this.trivia = trivia;
            }
            NormalSyntaxTriviaList.prototype.kind = function () {
                return 3 /* TriviaList */;
            };

            NormalSyntaxTriviaList.prototype.count = function () {
                return this.trivia.length;
            };

            NormalSyntaxTriviaList.prototype.syntaxTriviaAt = function (index) {
                if (index < 0 || index >= this.trivia.length) {
                    throw TypeScript.Errors.argumentOutOfRange("index");
                }

                return this.trivia[index];
            };

            NormalSyntaxTriviaList.prototype.last = function () {
                return this.trivia[this.trivia.length - 1];
            };

            NormalSyntaxTriviaList.prototype.fullWidth = function () {
                return TypeScript.ArrayUtilities.sum(this.trivia, function (t) {
                    return t.fullWidth();
                });
            };

            NormalSyntaxTriviaList.prototype.fullText = function () {
                var result = "";

                for (var i = 0, n = this.trivia.length; i < n; i++) {
                    result += this.trivia[i].fullText();
                }

                return result;
            };

            NormalSyntaxTriviaList.prototype.hasComment = function () {
                for (var i = 0; i < this.trivia.length; i++) {
                    if (isComment(this.trivia[i])) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxTriviaList.prototype.hasNewLine = function () {
                for (var i = 0; i < this.trivia.length; i++) {
                    if (this.trivia[i].kind() === 5 /* NewLineTrivia */) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxTriviaList.prototype.hasSkippedToken = function () {
                for (var i = 0; i < this.trivia.length; i++) {
                    if (this.trivia[i].kind() === 8 /* SkippedTokenTrivia */) {
                        return true;
                    }
                }

                return false;
            };

            NormalSyntaxTriviaList.prototype.toJSON = function (key) {
                return this.trivia;
            };

            NormalSyntaxTriviaList.prototype.collectTextElements = function (elements) {
                for (var i = 0; i < this.trivia.length; i++) {
                    this.trivia[i].collectTextElements(elements);
                }
            };

            NormalSyntaxTriviaList.prototype.toArray = function () {
                return this.trivia.slice(0);
            };

            NormalSyntaxTriviaList.prototype.concat = function (trivia) {
                return concatTrivia(this, trivia);
            };
            return NormalSyntaxTriviaList;
        })();

        function triviaList(trivia) {
            if (trivia === undefined || trivia === null || trivia.length === 0) {
                return Syntax.emptyTriviaList;
            }

            if (trivia.length === 1) {
                return new SingletonSyntaxTriviaList(trivia[0]);
            }

            return new NormalSyntaxTriviaList(trivia);
        }
        Syntax.triviaList = triviaList;

        Syntax.spaceTriviaList = triviaList([Syntax.spaceTrivia]);
    })(TypeScript.Syntax || (TypeScript.Syntax = {}));
    var Syntax = TypeScript.Syntax;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxUtilities = (function () {
        function SyntaxUtilities() {
        }
        SyntaxUtilities.isAngleBracket = function (positionedElement) {
            var element = positionedElement.element();
            var parent = positionedElement.parentElement();
            if (parent !== null && (element.kind() === 80 /* LessThanToken */ || element.kind() === 81 /* GreaterThanToken */)) {
                switch (parent.kind()) {
                    case 228 /* TypeArgumentList */:
                    case 229 /* TypeParameterList */:
                    case 220 /* CastExpression */:
                        return true;
                }
            }

            return false;
        };

        SyntaxUtilities.getToken = function (list, kind) {
            for (var i = 0, n = list.childCount(); i < n; i++) {
                var token = list.childAt(i);
                if (token.tokenKind === kind) {
                    return token;
                }
            }

            return null;
        };

        SyntaxUtilities.containsToken = function (list, kind) {
            return SyntaxUtilities.getToken(list, kind) !== null;
        };

        SyntaxUtilities.hasExportKeyword = function (moduleElement) {
            return SyntaxUtilities.getExportKeyword(moduleElement) !== null;
        };

        SyntaxUtilities.getExportKeyword = function (moduleElement) {
            switch (moduleElement.kind()) {
                case 130 /* ModuleDeclaration */:
                case 131 /* ClassDeclaration */:
                case 129 /* FunctionDeclaration */:
                case 148 /* VariableStatement */:
                case 132 /* EnumDeclaration */:
                case 128 /* InterfaceDeclaration */:
                case 133 /* ImportDeclaration */:
                    return SyntaxUtilities.getToken(moduleElement.modifiers, 47 /* ExportKeyword */);
                default:
                    return null;
            }
        };

        SyntaxUtilities.isAmbientDeclarationSyntax = function (positionNode) {
            if (!positionNode) {
                return false;
            }

            var node = positionNode.node();
            switch (node.kind()) {
                case 130 /* ModuleDeclaration */:
                case 131 /* ClassDeclaration */:
                case 129 /* FunctionDeclaration */:
                case 148 /* VariableStatement */:
                case 132 /* EnumDeclaration */:
                    if (SyntaxUtilities.containsToken(node.modifiers, 63 /* DeclareKeyword */)) {
                        return true;
                    }

                case 133 /* ImportDeclaration */:
                case 137 /* ConstructorDeclaration */:
                case 135 /* MemberFunctionDeclaration */:
                case 139 /* GetAccessor */:
                case 140 /* SetAccessor */:
                case 136 /* MemberVariableDeclaration */:
                    if (node.isClassElement() || node.isModuleElement()) {
                        return SyntaxUtilities.isAmbientDeclarationSyntax(positionNode.containingNode());
                    }

                case 243 /* EnumElement */:
                    return SyntaxUtilities.isAmbientDeclarationSyntax(positionNode.containingNode().containingNode());

                default:
                    return SyntaxUtilities.isAmbientDeclarationSyntax(positionNode.containingNode());
            }
        };
        return SyntaxUtilities;
    })();
    TypeScript.SyntaxUtilities = SyntaxUtilities;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxVisitor = (function () {
        function SyntaxVisitor() {
        }
        SyntaxVisitor.prototype.defaultVisit = function (node) {
            return null;
        };

        SyntaxVisitor.prototype.visitToken = function (token) {
            return this.defaultVisit(token);
        };

        SyntaxVisitor.prototype.visitSourceUnit = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitExternalModuleReference = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitModuleNameModuleReference = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitImportDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitExportAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitClassDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitInterfaceDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitHeritageClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitModuleDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVariableStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVariableDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVariableDeclarator = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEqualsValueClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitPrefixUnaryExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitArrayLiteralExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitOmittedExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParenthesizedExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSimpleArrowFunctionExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParenthesizedArrowFunctionExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitQualifiedName = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeArgumentList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstructorType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitObjectType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitArrayType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitGenericType = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeQuery = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeAnnotation = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitBlock = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParameter = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMemberAccessExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitPostfixUnaryExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitElementAccessExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitInvocationExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitArgumentList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitBinaryExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConditionalExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstructSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMethodSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitIndexSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitPropertySignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCallSignature = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitParameterList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeParameterList = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeParameter = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstraint = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitElseClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitIfStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitExpressionStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitConstructorDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMemberFunctionDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitGetAccessor = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSetAccessor = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitMemberVariableDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitIndexMemberDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitThrowStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitReturnStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitObjectCreationExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSwitchStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCaseSwitchClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDefaultSwitchClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitBreakStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitContinueStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitForStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitForInStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitWhileStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitWithStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEnumDeclaration = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEnumElement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCastExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitObjectLiteralExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitSimplePropertyAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionPropertyAssignment = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFunctionExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitEmptyStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTryStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitCatchClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitFinallyClause = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitLabeledStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDoStatement = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitTypeOfExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDeleteExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitVoidExpression = function (node) {
            return this.defaultVisit(node);
        };

        SyntaxVisitor.prototype.visitDebuggerStatement = function (node) {
            return this.defaultVisit(node);
        };
        return SyntaxVisitor;
    })();
    TypeScript.SyntaxVisitor = SyntaxVisitor;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxWalker = (function () {
        function SyntaxWalker() {
        }
        SyntaxWalker.prototype.visitToken = function (token) {
        };

        SyntaxWalker.prototype.visitNode = function (node) {
            node.accept(this);
        };

        SyntaxWalker.prototype.visitNodeOrToken = function (nodeOrToken) {
            if (nodeOrToken.isToken()) {
                this.visitToken(nodeOrToken);
            } else {
                this.visitNode(nodeOrToken);
            }
        };

        SyntaxWalker.prototype.visitOptionalToken = function (token) {
            if (token === null) {
                return;
            }

            this.visitToken(token);
        };

        SyntaxWalker.prototype.visitOptionalNode = function (node) {
            if (node === null) {
                return;
            }

            this.visitNode(node);
        };

        SyntaxWalker.prototype.visitOptionalNodeOrToken = function (nodeOrToken) {
            if (nodeOrToken === null) {
                return;
            }

            this.visitNodeOrToken(nodeOrToken);
        };

        SyntaxWalker.prototype.visitList = function (list) {
            for (var i = 0, n = list.childCount(); i < n; i++) {
                this.visitNodeOrToken(list.childAt(i));
            }
        };

        SyntaxWalker.prototype.visitSeparatedList = function (list) {
            for (var i = 0, n = list.childCount(); i < n; i++) {
                var item = list.childAt(i);
                this.visitNodeOrToken(item);
            }
        };

        SyntaxWalker.prototype.visitSourceUnit = function (node) {
            this.visitList(node.moduleElements);
            this.visitToken(node.endOfFileToken);
        };

        SyntaxWalker.prototype.visitExternalModuleReference = function (node) {
            this.visitToken(node.requireKeyword);
            this.visitToken(node.openParenToken);
            this.visitToken(node.stringLiteral);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitModuleNameModuleReference = function (node) {
            this.visitNodeOrToken(node.moduleName);
        };

        SyntaxWalker.prototype.visitImportDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.importKeyword);
            this.visitToken(node.identifier);
            this.visitToken(node.equalsToken);
            this.visitNodeOrToken(node.moduleReference);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitExportAssignment = function (node) {
            this.visitToken(node.exportKeyword);
            this.visitToken(node.equalsToken);
            this.visitToken(node.identifier);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitClassDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.classKeyword);
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.typeParameterList);
            this.visitList(node.heritageClauses);
            this.visitToken(node.openBraceToken);
            this.visitList(node.classElements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitInterfaceDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.interfaceKeyword);
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.typeParameterList);
            this.visitList(node.heritageClauses);
            this.visitNode(node.body);
        };

        SyntaxWalker.prototype.visitHeritageClause = function (node) {
            this.visitToken(node.extendsOrImplementsKeyword);
            this.visitSeparatedList(node.typeNames);
        };

        SyntaxWalker.prototype.visitModuleDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.moduleKeyword);
            this.visitOptionalNodeOrToken(node.name);
            this.visitOptionalToken(node.stringLiteral);
            this.visitToken(node.openBraceToken);
            this.visitList(node.moduleElements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitFunctionDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.functionKeyword);
            this.visitToken(node.identifier);
            this.visitNode(node.callSignature);
            this.visitOptionalNode(node.block);
            this.visitOptionalToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitVariableStatement = function (node) {
            this.visitList(node.modifiers);
            this.visitNode(node.variableDeclaration);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitVariableDeclaration = function (node) {
            this.visitToken(node.varKeyword);
            this.visitSeparatedList(node.variableDeclarators);
        };

        SyntaxWalker.prototype.visitVariableDeclarator = function (node) {
            this.visitToken(node.propertyName);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitOptionalNode(node.equalsValueClause);
        };

        SyntaxWalker.prototype.visitEqualsValueClause = function (node) {
            this.visitToken(node.equalsToken);
            this.visitNodeOrToken(node.value);
        };

        SyntaxWalker.prototype.visitPrefixUnaryExpression = function (node) {
            this.visitToken(node.operatorToken);
            this.visitNodeOrToken(node.operand);
        };

        SyntaxWalker.prototype.visitArrayLiteralExpression = function (node) {
            this.visitToken(node.openBracketToken);
            this.visitSeparatedList(node.expressions);
            this.visitToken(node.closeBracketToken);
        };

        SyntaxWalker.prototype.visitOmittedExpression = function (node) {
        };

        SyntaxWalker.prototype.visitParenthesizedExpression = function (node) {
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitSimpleArrowFunctionExpression = function (node) {
            this.visitToken(node.identifier);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitOptionalNode(node.block);
            this.visitOptionalNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitParenthesizedArrowFunctionExpression = function (node) {
            this.visitNode(node.callSignature);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitOptionalNode(node.block);
            this.visitOptionalNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitQualifiedName = function (node) {
            this.visitNodeOrToken(node.left);
            this.visitToken(node.dotToken);
            this.visitToken(node.right);
        };

        SyntaxWalker.prototype.visitTypeArgumentList = function (node) {
            this.visitToken(node.lessThanToken);
            this.visitSeparatedList(node.typeArguments);
            this.visitToken(node.greaterThanToken);
        };

        SyntaxWalker.prototype.visitConstructorType = function (node) {
            this.visitToken(node.newKeyword);
            this.visitOptionalNode(node.typeParameterList);
            this.visitNode(node.parameterList);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitFunctionType = function (node) {
            this.visitOptionalNode(node.typeParameterList);
            this.visitNode(node.parameterList);
            this.visitToken(node.equalsGreaterThanToken);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitObjectType = function (node) {
            this.visitToken(node.openBraceToken);
            this.visitSeparatedList(node.typeMembers);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitArrayType = function (node) {
            this.visitNodeOrToken(node.type);
            this.visitToken(node.openBracketToken);
            this.visitToken(node.closeBracketToken);
        };

        SyntaxWalker.prototype.visitGenericType = function (node) {
            this.visitNodeOrToken(node.name);
            this.visitNode(node.typeArgumentList);
        };

        SyntaxWalker.prototype.visitTypeQuery = function (node) {
            this.visitToken(node.typeOfKeyword);
            this.visitNodeOrToken(node.name);
        };

        SyntaxWalker.prototype.visitTypeAnnotation = function (node) {
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitBlock = function (node) {
            this.visitToken(node.openBraceToken);
            this.visitList(node.statements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitParameter = function (node) {
            this.visitOptionalToken(node.dotDotDotToken);
            this.visitList(node.modifiers);
            this.visitToken(node.identifier);
            this.visitOptionalToken(node.questionToken);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitOptionalNode(node.equalsValueClause);
        };

        SyntaxWalker.prototype.visitMemberAccessExpression = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.dotToken);
            this.visitToken(node.name);
        };

        SyntaxWalker.prototype.visitPostfixUnaryExpression = function (node) {
            this.visitNodeOrToken(node.operand);
            this.visitToken(node.operatorToken);
        };

        SyntaxWalker.prototype.visitElementAccessExpression = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.openBracketToken);
            this.visitNodeOrToken(node.argumentExpression);
            this.visitToken(node.closeBracketToken);
        };

        SyntaxWalker.prototype.visitInvocationExpression = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitNode(node.argumentList);
        };

        SyntaxWalker.prototype.visitArgumentList = function (node) {
            this.visitOptionalNode(node.typeArgumentList);
            this.visitToken(node.openParenToken);
            this.visitSeparatedList(node.arguments);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitBinaryExpression = function (node) {
            this.visitNodeOrToken(node.left);
            this.visitToken(node.operatorToken);
            this.visitNodeOrToken(node.right);
        };

        SyntaxWalker.prototype.visitConditionalExpression = function (node) {
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.questionToken);
            this.visitNodeOrToken(node.whenTrue);
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.whenFalse);
        };

        SyntaxWalker.prototype.visitConstructSignature = function (node) {
            this.visitToken(node.newKeyword);
            this.visitNode(node.callSignature);
        };

        SyntaxWalker.prototype.visitMethodSignature = function (node) {
            this.visitToken(node.propertyName);
            this.visitOptionalToken(node.questionToken);
            this.visitNode(node.callSignature);
        };

        SyntaxWalker.prototype.visitIndexSignature = function (node) {
            this.visitToken(node.openBracketToken);
            this.visitNode(node.parameter);
            this.visitToken(node.closeBracketToken);
            this.visitOptionalNode(node.typeAnnotation);
        };

        SyntaxWalker.prototype.visitPropertySignature = function (node) {
            this.visitToken(node.propertyName);
            this.visitOptionalToken(node.questionToken);
            this.visitOptionalNode(node.typeAnnotation);
        };

        SyntaxWalker.prototype.visitCallSignature = function (node) {
            this.visitOptionalNode(node.typeParameterList);
            this.visitNode(node.parameterList);
            this.visitOptionalNode(node.typeAnnotation);
        };

        SyntaxWalker.prototype.visitParameterList = function (node) {
            this.visitToken(node.openParenToken);
            this.visitSeparatedList(node.parameters);
            this.visitToken(node.closeParenToken);
        };

        SyntaxWalker.prototype.visitTypeParameterList = function (node) {
            this.visitToken(node.lessThanToken);
            this.visitSeparatedList(node.typeParameters);
            this.visitToken(node.greaterThanToken);
        };

        SyntaxWalker.prototype.visitTypeParameter = function (node) {
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.constraint);
        };

        SyntaxWalker.prototype.visitConstraint = function (node) {
            this.visitToken(node.extendsKeyword);
            this.visitNodeOrToken(node.type);
        };

        SyntaxWalker.prototype.visitElseClause = function (node) {
            this.visitToken(node.elseKeyword);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitIfStatement = function (node) {
            this.visitToken(node.ifKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
            this.visitOptionalNode(node.elseClause);
        };

        SyntaxWalker.prototype.visitExpressionStatement = function (node) {
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitConstructorDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.constructorKeyword);
            this.visitNode(node.callSignature);
            this.visitOptionalNode(node.block);
            this.visitOptionalToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitMemberFunctionDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.propertyName);
            this.visitNode(node.callSignature);
            this.visitOptionalNode(node.block);
            this.visitOptionalToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitGetAccessor = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.getKeyword);
            this.visitToken(node.propertyName);
            this.visitNode(node.parameterList);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitSetAccessor = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.setKeyword);
            this.visitToken(node.propertyName);
            this.visitNode(node.parameterList);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitMemberVariableDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitNode(node.variableDeclarator);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitIndexMemberDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitNode(node.indexSignature);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitThrowStatement = function (node) {
            this.visitToken(node.throwKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitReturnStatement = function (node) {
            this.visitToken(node.returnKeyword);
            this.visitOptionalNodeOrToken(node.expression);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitObjectCreationExpression = function (node) {
            this.visitToken(node.newKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitOptionalNode(node.argumentList);
        };

        SyntaxWalker.prototype.visitSwitchStatement = function (node) {
            this.visitToken(node.switchKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.closeParenToken);
            this.visitToken(node.openBraceToken);
            this.visitList(node.switchClauses);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitCaseSwitchClause = function (node) {
            this.visitToken(node.caseKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.colonToken);
            this.visitList(node.statements);
        };

        SyntaxWalker.prototype.visitDefaultSwitchClause = function (node) {
            this.visitToken(node.defaultKeyword);
            this.visitToken(node.colonToken);
            this.visitList(node.statements);
        };

        SyntaxWalker.prototype.visitBreakStatement = function (node) {
            this.visitToken(node.breakKeyword);
            this.visitOptionalToken(node.identifier);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitContinueStatement = function (node) {
            this.visitToken(node.continueKeyword);
            this.visitOptionalToken(node.identifier);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitForStatement = function (node) {
            this.visitToken(node.forKeyword);
            this.visitToken(node.openParenToken);
            this.visitOptionalNode(node.variableDeclaration);
            this.visitOptionalNodeOrToken(node.initializer);
            this.visitToken(node.firstSemicolonToken);
            this.visitOptionalNodeOrToken(node.condition);
            this.visitToken(node.secondSemicolonToken);
            this.visitOptionalNodeOrToken(node.incrementor);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitForInStatement = function (node) {
            this.visitToken(node.forKeyword);
            this.visitToken(node.openParenToken);
            this.visitOptionalNode(node.variableDeclaration);
            this.visitOptionalNodeOrToken(node.left);
            this.visitToken(node.inKeyword);
            this.visitNodeOrToken(node.expression);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitWhileStatement = function (node) {
            this.visitToken(node.whileKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitWithStatement = function (node) {
            this.visitToken(node.withKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitEnumDeclaration = function (node) {
            this.visitList(node.modifiers);
            this.visitToken(node.enumKeyword);
            this.visitToken(node.identifier);
            this.visitToken(node.openBraceToken);
            this.visitSeparatedList(node.enumElements);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitEnumElement = function (node) {
            this.visitToken(node.propertyName);
            this.visitOptionalNode(node.equalsValueClause);
        };

        SyntaxWalker.prototype.visitCastExpression = function (node) {
            this.visitToken(node.lessThanToken);
            this.visitNodeOrToken(node.type);
            this.visitToken(node.greaterThanToken);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitObjectLiteralExpression = function (node) {
            this.visitToken(node.openBraceToken);
            this.visitSeparatedList(node.propertyAssignments);
            this.visitToken(node.closeBraceToken);
        };

        SyntaxWalker.prototype.visitSimplePropertyAssignment = function (node) {
            this.visitToken(node.propertyName);
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitFunctionPropertyAssignment = function (node) {
            this.visitToken(node.propertyName);
            this.visitNode(node.callSignature);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitFunctionExpression = function (node) {
            this.visitToken(node.functionKeyword);
            this.visitOptionalToken(node.identifier);
            this.visitNode(node.callSignature);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitEmptyStatement = function (node) {
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitTryStatement = function (node) {
            this.visitToken(node.tryKeyword);
            this.visitNode(node.block);
            this.visitOptionalNode(node.catchClause);
            this.visitOptionalNode(node.finallyClause);
        };

        SyntaxWalker.prototype.visitCatchClause = function (node) {
            this.visitToken(node.catchKeyword);
            this.visitToken(node.openParenToken);
            this.visitToken(node.identifier);
            this.visitOptionalNode(node.typeAnnotation);
            this.visitToken(node.closeParenToken);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitFinallyClause = function (node) {
            this.visitToken(node.finallyKeyword);
            this.visitNode(node.block);
        };

        SyntaxWalker.prototype.visitLabeledStatement = function (node) {
            this.visitToken(node.identifier);
            this.visitToken(node.colonToken);
            this.visitNodeOrToken(node.statement);
        };

        SyntaxWalker.prototype.visitDoStatement = function (node) {
            this.visitToken(node.doKeyword);
            this.visitNodeOrToken(node.statement);
            this.visitToken(node.whileKeyword);
            this.visitToken(node.openParenToken);
            this.visitNodeOrToken(node.condition);
            this.visitToken(node.closeParenToken);
            this.visitToken(node.semicolonToken);
        };

        SyntaxWalker.prototype.visitTypeOfExpression = function (node) {
            this.visitToken(node.typeOfKeyword);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitDeleteExpression = function (node) {
            this.visitToken(node.deleteKeyword);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitVoidExpression = function (node) {
            this.visitToken(node.voidKeyword);
            this.visitNodeOrToken(node.expression);
        };

        SyntaxWalker.prototype.visitDebuggerStatement = function (node) {
            this.visitToken(node.debuggerKeyword);
            this.visitToken(node.semicolonToken);
        };
        return SyntaxWalker;
    })();
    TypeScript.SyntaxWalker = SyntaxWalker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var PositionTrackingWalker = (function (_super) {
        __extends(PositionTrackingWalker, _super);
        function PositionTrackingWalker() {
            _super.apply(this, arguments);
            this._position = 0;
        }
        PositionTrackingWalker.prototype.visitToken = function (token) {
            this._position += token.fullWidth();
        };

        PositionTrackingWalker.prototype.position = function () {
            return this._position;
        };

        PositionTrackingWalker.prototype.skip = function (element) {
            this._position += element.fullWidth();
        };
        return PositionTrackingWalker;
    })(TypeScript.SyntaxWalker);
    TypeScript.PositionTrackingWalker = PositionTrackingWalker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxInformationMap = (function (_super) {
        __extends(SyntaxInformationMap, _super);
        function SyntaxInformationMap(trackParents, trackPreviousToken) {
            _super.call(this);
            this.trackParents = trackParents;
            this.trackPreviousToken = trackPreviousToken;
            this.tokenToInformation = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
            this.elementToPosition = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
            this._previousToken = null;
            this._previousTokenInformation = null;
            this._currentPosition = 0;
            this._elementToParent = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
            this._parentStack = [];
            this._parentStack.push(null);
        }
        SyntaxInformationMap.create = function (node, trackParents, trackPreviousToken) {
            var map = new SyntaxInformationMap(trackParents, trackPreviousToken);
            map.visitNode(node);
            return map;
        };

        SyntaxInformationMap.prototype.visitNode = function (node) {
            this.trackParents && this._elementToParent.add(node, TypeScript.ArrayUtilities.last(this._parentStack));
            this.elementToPosition.add(node, this._currentPosition);

            this.trackParents && this._parentStack.push(node);
            _super.prototype.visitNode.call(this, node);
            this.trackParents && this._parentStack.pop();
        };

        SyntaxInformationMap.prototype.visitToken = function (token) {
            this.trackParents && this._elementToParent.add(token, TypeScript.ArrayUtilities.last(this._parentStack));

            if (this.trackPreviousToken) {
                var tokenInformation = {
                    previousToken: this._previousToken,
                    nextToken: null
                };

                if (this._previousTokenInformation !== null) {
                    this._previousTokenInformation.nextToken = token;
                }

                this._previousToken = token;
                this._previousTokenInformation = tokenInformation;

                this.tokenToInformation.add(token, tokenInformation);
            }

            this.elementToPosition.add(token, this._currentPosition);
            this._currentPosition += token.fullWidth();
        };

        SyntaxInformationMap.prototype.parent = function (element) {
            return this._elementToParent.get(element);
        };

        SyntaxInformationMap.prototype.fullStart = function (element) {
            return this.elementToPosition.get(element);
        };

        SyntaxInformationMap.prototype.start = function (element) {
            return this.fullStart(element) + element.leadingTriviaWidth();
        };

        SyntaxInformationMap.prototype.end = function (element) {
            return this.start(element) + element.width();
        };

        SyntaxInformationMap.prototype.previousToken = function (token) {
            return this.tokenInformation(token).previousToken;
        };

        SyntaxInformationMap.prototype.tokenInformation = function (token) {
            return this.tokenToInformation.get(token);
        };

        SyntaxInformationMap.prototype.firstTokenInLineContainingToken = function (token) {
            var current = token;
            while (true) {
                var information = this.tokenInformation(current);
                if (this.isFirstTokenInLineWorker(information)) {
                    break;
                }

                current = information.previousToken;
            }

            return current;
        };

        SyntaxInformationMap.prototype.isFirstTokenInLine = function (token) {
            var information = this.tokenInformation(token);
            return this.isFirstTokenInLineWorker(information);
        };

        SyntaxInformationMap.prototype.isFirstTokenInLineWorker = function (information) {
            return information.previousToken === null || information.previousToken.hasTrailingNewLine();
        };
        return SyntaxInformationMap;
    })(TypeScript.SyntaxWalker);
    TypeScript.SyntaxInformationMap = SyntaxInformationMap;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var SyntaxNodeInvariantsChecker = (function (_super) {
        __extends(SyntaxNodeInvariantsChecker, _super);
        function SyntaxNodeInvariantsChecker() {
            _super.apply(this, arguments);
            this.tokenTable = TypeScript.Collections.createHashTable(TypeScript.Collections.DefaultHashTableCapacity, TypeScript.Collections.identityHashCode);
        }
        SyntaxNodeInvariantsChecker.checkInvariants = function (node) {
            node.accept(new SyntaxNodeInvariantsChecker());
        };

        SyntaxNodeInvariantsChecker.prototype.visitToken = function (token) {
            this.tokenTable.add(token, token);
        };
        return SyntaxNodeInvariantsChecker;
    })(TypeScript.SyntaxWalker);
    TypeScript.SyntaxNodeInvariantsChecker = SyntaxNodeInvariantsChecker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    var DepthLimitedWalker = (function (_super) {
        __extends(DepthLimitedWalker, _super);
        function DepthLimitedWalker(maximumDepth) {
            _super.call(this);
            this._depth = 0;
            this._maximumDepth = 0;
            this._maximumDepth = maximumDepth;
        }
        DepthLimitedWalker.prototype.visitNode = function (node) {
            if (this._depth < this._maximumDepth) {
                this._depth++;
                _super.prototype.visitNode.call(this, node);
                this._depth--;
            } else {
                this.skip(node);
            }
        };
        return DepthLimitedWalker;
    })(TypeScript.PositionTrackingWalker);
    TypeScript.DepthLimitedWalker = DepthLimitedWalker;
})(TypeScript || (TypeScript = {}));
var TypeScript;
(function (TypeScript) {
    (function (Parser) {
        

        var ExpressionPrecedence;
        (function (ExpressionPrecedence) {
            ExpressionPrecedence[ExpressionPrecedence["CommaExpressionPrecedence"] = 1] = "CommaExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["AssignmentExpressionPrecedence"] = 2] = "AssignmentExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["ConditionalExpressionPrecedence"] = 3] = "ConditionalExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["ArrowFunctionPrecedence"] = 4] = "ArrowFunctionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["LogicalOrExpressionPrecedence"] = 5] = "LogicalOrExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["LogicalAndExpressionPrecedence"] = 6] = "LogicalAndExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["BitwiseOrExpressionPrecedence"] = 7] = "BitwiseOrExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["BitwiseExclusiveOrExpressionPrecedence"] = 8] = "BitwiseExclusiveOrExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["BitwiseAndExpressionPrecedence"] = 9] = "BitwiseAndExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["EqualityExpressionPrecedence"] = 10] = "EqualityExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["RelationalExpressionPrecedence"] = 11] = "RelationalExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["ShiftExpressionPrecdence"] = 12] = "ShiftExpressionPrecdence";
            ExpressionPrecedence[ExpressionPrecedence["AdditiveExpressionPrecedence"] = 13] = "AdditiveExpressionPrecedence";
            ExpressionPrecedence[ExpressionPrecedence["MultiplicativeExpressionPrecedence"] = 14] = "MultiplicativeExpressionPrecedence";

            ExpressionPrecedence[ExpressionPrecedence["UnaryExpressionPrecedence"] = 15] = "UnaryExpressionPrecedence";
        })(ExpressionPrecedence || (ExpressionPrecedence = {}));

        var ListParsingState;
        (function (ListParsingState) {
            ListParsingState[ListParsingState["SourceUnit_ModuleElements"] = 1 << 0] = "SourceUnit_ModuleElements";
            ListParsingState[ListParsingState["ClassDeclaration_ClassElements"] = 1 << 1] = "ClassDeclaration_ClassElements";
            ListParsingState[ListParsingState["ModuleDeclaration_ModuleElements"] = 1 << 2] = "ModuleDeclaration_ModuleElements";
            ListParsingState[ListParsingState["SwitchStatement_SwitchClauses"] = 1 << 3] = "SwitchStatement_SwitchClauses";
            ListParsingState[ListParsingState["SwitchClause_Statements"] = 1 << 4] = "SwitchClause_Statements";
            ListParsingState[ListParsingState["Block_Statements"] = 1 << 5] = "Block_Statements";
            ListParsingState[ListParsingState["TryBlock_Statements"] = 1 << 6] = "TryBlock_Statements";
            ListParsingState[ListParsingState["CatchBlock_Statements"] = 1 << 7] = "CatchBlock_Statements";
            ListParsingState[ListParsingState["EnumDeclaration_EnumElements"] = 1 << 8] = "EnumDeclaration_EnumElements";
            ListParsingState[ListParsingState["ObjectType_TypeMembers"] = 1 << 9] = "ObjectType_TypeMembers";
            ListParsingState[ListParsingState["ClassOrInterfaceDeclaration_HeritageClauses"] = 1 << 10] = "ClassOrInterfaceDeclaration_HeritageClauses";
            ListParsingState[ListParsingState["HeritageClause_TypeNameList"] = 1 << 11] = "HeritageClause_TypeNameList";
            ListParsingState[ListParsingState["VariableDeclaration_VariableDeclarators_AllowIn"] = 1 << 12] = "VariableDeclaration_VariableDeclarators_AllowIn";
            ListParsingState[ListParsingState["VariableDeclaration_VariableDeclarators_DisallowIn"] = 1 << 13] = "VariableDeclaration_VariableDeclarators_DisallowIn";
            ListParsingState[ListParsingState["ArgumentList_AssignmentExpressions"] = 1 << 14] = "ArgumentList_AssignmentExpressions";
            ListParsingState[ListParsingState["ObjectLiteralExpression_PropertyAssignments"] = 1 << 15] = "ObjectLiteralExpression_PropertyAssignments";
            ListParsingState[ListParsingState["ArrayLiteralExpression_AssignmentExpressions"] = 1 << 16] = "ArrayLiteralExpression_AssignmentExpressions";
            ListParsingState[ListParsingState["ParameterList_Parameters"] = 1 << 17] = "ParameterList_Parameters";
            ListParsingState[ListParsingState["TypeArgumentList_Types"] = 1 << 18] = "TypeArgumentList_Types";
            ListParsingState[ListParsingState["TypeParameterList_TypeParameters"] = 1 << 19] = "TypeParameterList_TypeParameters";

            ListParsingState[ListParsingState["FirstListParsingState"] = ListParsingState.SourceUnit_ModuleElements] = "FirstListParsingState";
            ListParsingState[ListParsingState["LastListParsingState"] = ListParsingState.TypeParameterList_TypeParameters] = "LastListParsingState";
        })(ListParsingState || (ListParsingState = {}));

        var SyntaxCursor = (function () {
            function SyntaxCursor(sourceUnit) {
                this._elements = [];
                this._index = 0;
                this._pinCount = 0;
                sourceUnit.insertChildrenInto(this._elements, 0);
            }
            SyntaxCursor.prototype.isFinished = function () {
                return this._index === this._elements.length;
            };

            SyntaxCursor.prototype.currentElement = function () {
                if (this.isFinished()) {
                    return null;
                }

                return this._elements[this._index];
            };

            SyntaxCursor.prototype.currentNode = function () {
                var element = this.currentElement();
                return element !== null && element.isNode() ? element : null;
            };

            SyntaxCursor.prototype.moveToFirstChild = function () {
                if (this.isFinished()) {
                    return;
                }

                var element = this._elements[this._index];
                if (element.isToken()) {
                    return;
                }

                var node = element;

                this._elements.splice(this._index, 1);

                node.insertChildrenInto(this._elements, this._index);
            };

            SyntaxCursor.prototype.moveToNextSibling = function () {
                if (this.isFinished()) {
                    return;
                }

                if (this._pinCount > 0) {
                    this._index++;
                    return;
                }

                this._elements.shift();
            };

            SyntaxCursor.prototype.getAndPinCursorIndex = function () {
                this._pinCount++;
                return this._index;
            };

            SyntaxCursor.prototype.releaseAndUnpinCursorIndex = function (index) {
                this._pinCount--;
                if (this._pinCount === 0) {
                }
            };

            SyntaxCursor.prototype.rewindToPinnedCursorIndex = function (index) {
                this._index = index;
            };

            SyntaxCursor.prototype.pinCount = function () {
                return this._pinCount;
            };

            SyntaxCursor.prototype.moveToFirstToken = function () {
                var element;

                while (!this.isFinished()) {
                    element = this.currentElement();
                    if (element.isNode()) {
                        this.moveToFirstChild();
                        continue;
                    }

                    return;
                }
            };

            SyntaxCursor.prototype.currentToken = function () {
                this.moveToFirstToken();
                if (this.isFinished()) {
                    return null;
                }

                var element = this.currentElement();

                return element;
            };

            SyntaxCursor.prototype.peekToken = function (n) {
                this.moveToFirstToken();
                var pin = this.getAndPinCursorIndex();

                for (var i = 0; i < n; i++) {
                    this.moveToNextSibling();
                    this.moveToFirstToken();
                }

                var result = this.currentToken();
                this.rewindToPinnedCursorIndex(pin);
                this.releaseAndUnpinCursorIndex(pin);

                return result;
            };
            return SyntaxCursor;
        })();

        

        var NormalParserSource = (function () {
            function NormalParserSource(fileName, text, languageVersion) {
                this._previousToken = null;
                this._absolutePosition = 0;
                this._tokenDiagnostics = [];
                this.rewindPointPool = [];
                this.rewindPointPoolCount = 0;
                this.slidingWindow = new TypeScript.SlidingWindow(this, TypeScript.ArrayUtilities.createArray(32, null), null);
                this.scanner = new TypeScript.Scanner(fileName, text, languageVersion);
            }
            NormalParserSource.prototype.currentNode = function () {
                return null;
            };

            NormalParserSource.prototype.moveToNextNode = function () {
                throw TypeScript.Errors.invalidOperation();
            };

            NormalParserSource.prototype.absolutePosition = function () {
                return this._absolutePosition;
            };

            NormalParserSource.prototype.previousToken = function () {
                return this._previousToken;
            };

            NormalParserSource.prototype.tokenDiagnostics = function () {
                return this._tokenDiagnostics;
            };

            NormalParserSource.prototype.getOrCreateRewindPoint = function () {
                if (this.rewindPointPoolCount === 0) {
                    return {};
                }

                this.rewindPointPoolCount--;
                var result = this.rewindPointPool[this.rewindPointPoolCount];
                this.rewindPointPool[this.rewindPointPoolCount] = null;
                return result;
            };

            NormalParserSource.prototype.getRewindPoint = function () {
                var slidingWindowIndex = this.slidingWindow.getAndPinAbsoluteIndex();

                var rewindPoint = this.getOrCreateRewindPoint();

                rewindPoint.slidingWindowIndex = slidingWindowIndex;
                rewindPoint.previousToken = this._previousToken;
                rewindPoint.absolutePosition = this._absolutePosition;

                rewindPoint.pinCount = this.slidingWindow.pinCount();

                return rewindPoint;
            };

            NormalParserSource.prototype.isPinned = function () {
                return this.slidingWindow.pinCount() > 0;
            };

            NormalParserSource.prototype.rewind = function (rewindPoint) {
                this.slidingWindow.rewindToPinnedIndex(rewindPoint.slidingWindowIndex);

                this._previousToken = rewindPoint.previousToken;
                this._absolutePosition = rewindPoint.absolutePosition;
            };

            NormalParserSource.prototype.releaseRewindPoint = function (rewindPoint) {
                this.slidingWindow.releaseAndUnpinAbsoluteIndex(rewindPoint.absoluteIndex);

                this.rewindPointPool[this.rewindPointPoolCount] = rewindPoint;
                this.rewindPointPoolCount++;
            };

            NormalParserSource.prototype.fetchMoreItems = function (allowRegularExpression, sourceIndex, window, destinationIndex, spaceAvailable) {
                window[destinationIndex] = this.scanner.scan(this._tokenDiagnostics, allowRegularExpression);
                return 1;
            };

            NormalParserSource.prototype.peekToken = function (n) {
                return this.slidingWindow.peekItemN(n);
            };

            NormalParserSource.prototype.moveToNextToken = function () {
                var currentToken = this.currentToken();
                this._absolutePosition += currentToken.fullWidth();
                this._previousToken = currentToken;

                this.slidingWindow.moveToNextItem();
            };

            NormalParserSource.prototype.currentToken = function () {
                return this.slidingWindow.currentItem(false);
            };

            NormalParserSource.prototype.removeDiagnosticsOnOrAfterPosition = function (position) {
                var tokenDiagnosticsLength = this._tokenDiagnostics.length;
                while (tokenDiagnosticsLength > 0) {
                    var diagnostic = this._tokenDiagnostics[tokenDiagnosticsLength - 1];
                    if (diagnostic.start() >= position) {
                        tokenDiagnosticsLength--;
                    } else {
                        break;
                    }
                }

                this._tokenDiagnostics.length = tokenDiagnosticsLength;
            };

            NormalParserSource.prototype.resetToPosition = function (absolutePosition, previousToken) {
                this._absolutePosition = absolutePosition;
                this._previousToken = previousToken;

                this.removeDiagnosticsOnOrAfterPosition(absolutePosition);

                this.slidingWindow.disgardAllItemsFromCurrentIndexOnwards();

                this.scanner.setAbsoluteIndex(absolutePosition);
            };

            NormalParserSource.prototype.currentTokenAllowingRegularExpression = function () {
                this.resetToPosition(this._absolutePosition, this._previousToken);

                var token = this.slidingWindow.currentItem(true);

                return token;
            };
            return NormalParserSource;
        })();

        var IncrementalParserSource = (function () {
            function IncrementalParserSource(oldSyntaxTree, textChangeRange, newText) {
                this._changeDelta = 0;
                var oldSourceUnit = oldSyntaxTree.sourceUnit();
                this._oldSourceUnitCursor = new SyntaxCursor(oldSourceUnit);

                this._changeRange = IncrementalParserSource.extendToAffectedRange(textChangeRange, oldSourceUnit);

                if (TypeScript.Debug.shouldAssert(2 /* Aggressive */)) {
                    TypeScript.Debug.assert((oldSourceUnit.fullWidth() - this._changeRange.span().length() + this._changeRange.newLength()) === newText.length());
                }

                this._normalParserSource = new NormalParserSource(oldSyntaxTree.fileName(), newText, oldSyntaxTree.parseOptions().languageVersion());
            }
            IncrementalParserSource.extendToAffectedRange = function (changeRange, sourceUnit) {
                var maxLookahead = 1;

                var start = changeRange.span().start();

                for (var i = 0; start > 0 && i <= maxLookahead; i++) {
                    var token = sourceUnit.findToken(start);

                    var position = token.fullStart();

                    start = TypeScript.MathPrototype.max(0, position - 1);
                }

                var finalSpan = TypeScript.TextSpan.fromBounds(start, changeRange.span().end());
                var finalLength = changeRange.newLength() + (changeRange.span().start() - start);

                return new TypeScript.TextChangeRange(finalSpan, finalLength);
            };

            IncrementalParserSource.prototype.absolutePosition = function () {
                return this._normalParserSource.absolutePosition();
            };

            IncrementalParserSource.prototype.previousToken = function () {
                return this._normalParserSource.previousToken();
            };

            IncrementalParserSource.prototype.tokenDiagnostics = function () {
                return this._normalParserSource.tokenDiagnostics();
            };

            IncrementalParserSource.prototype.getRewindPoint = function () {
                var rewindPoint = this._normalParserSource.getRewindPoint();
                var oldSourceUnitCursorIndex = this._oldSourceUnitCursor.getAndPinCursorIndex();

                rewindPoint.changeDelta = this._changeDelta;
                rewindPoint.changeRange = this._changeRange;
                rewindPoint.oldSourceUnitCursorIndex = oldSourceUnitCursorIndex;

                return rewindPoint;
            };

            IncrementalParserSource.prototype.rewind = function (rewindPoint) {
                this._changeRange = rewindPoint.changeRange;
                this._changeDelta = rewindPoint.changeDelta;
                this._oldSourceUnitCursor.rewindToPinnedCursorIndex(rewindPoint.oldSourceUnitCursorIndex);

                this._normalParserSource.rewind(rewindPoint);
            };

            IncrementalParserSource.prototype.releaseRewindPoint = function (rewindPoint) {
                this._oldSourceUnitCursor.releaseAndUnpinCursorIndex(rewindPoint.oldSourceUnitCursorIndex);
                this._normalParserSource.releaseRewindPoint(rewindPoint);
            };

            IncrementalParserSource.prototype.canReadFromOldSourceUnit = function () {
                if (this._normalParserSource.isPinned()) {
                    return false;
                }

                if (this._changeRange !== null && this._changeRange.newSpan().intersectsWithPosition(this.absolutePosition())) {
                    return false;
                }

                this.syncCursorToNewTextIfBehind();

                return this._changeDelta === 0 && !this._oldSourceUnitCursor.isFinished();
            };

            IncrementalParserSource.prototype.currentNode = function () {
                if (this.canReadFromOldSourceUnit()) {
                    return this.tryGetNodeFromOldSourceUnit();
                }

                return null;
            };

            IncrementalParserSource.prototype.currentToken = function () {
                if (this.canReadFromOldSourceUnit()) {
                    var token = this.tryGetTokenFromOldSourceUnit();
                    if (token !== null) {
                        return token;
                    }
                }

                return this._normalParserSource.currentToken();
            };

            IncrementalParserSource.prototype.currentTokenAllowingRegularExpression = function () {
                return this._normalParserSource.currentTokenAllowingRegularExpression();
            };

            IncrementalParserSource.prototype.syncCursorToNewTextIfBehind = function () {
                while (true) {
                    if (this._oldSourceUnitCursor.isFinished()) {
                        break;
                    }

                    if (this._changeDelta >= 0) {
                        break;
                    }

                    var currentElement = this._oldSourceUnitCursor.currentElement();

                    if (currentElement.isNode() && (currentElement.fullWidth() > Math.abs(this._changeDelta))) {
                        this._oldSourceUnitCursor.moveToFirstChild();
                    } else {
                        this._oldSourceUnitCursor.moveToNextSibling();

                        this._changeDelta += currentElement.fullWidth();
                    }
                }
            };

            IncrementalParserSource.prototype.intersectsWithChangeRangeSpanInOriginalText = function (start, length) {
                return this._changeRange !== null && this._changeRange.span().intersectsWith(start, length);
            };

            IncrementalParserSource.prototype.tryGetNodeFromOldSourceUnit = function () {
                while (true) {
                    var node = this._oldSourceUnitCursor.currentNode();
                    if (node === null) {
                        return null;
                    }

                    if (!this.intersectsWithChangeRangeSpanInOriginalText(this.absolutePosition(), node.fullWidth())) {
                        if (!node.isIncrementallyUnusable()) {
                            return node;
                        }
                    }

                    this._oldSourceUnitCursor.moveToFirstChild();
                }
            };

            IncrementalParserSource.prototype.canReuseTokenFromOldSourceUnit = function (position, token) {
                if (token !== null) {
                    if (!this.intersectsWithChangeRangeSpanInOriginalText(position, token.fullWidth())) {
                        if (!token.isIncrementallyUnusable()) {
                            return true;
                        }
                    }
                }

                return false;
            };

            IncrementalParserSource.prototype.tryGetTokenFromOldSourceUnit = function () {
                var token = this._oldSourceUnitCursor.currentToken();

                return this.canReuseTokenFromOldSourceUnit(this.absolutePosition(), token) ? token : null;
            };

            IncrementalParserSource.prototype.peekToken = function (n) {
                if (this.canReadFromOldSourceUnit()) {
                    var token = this.tryPeekTokenFromOldSourceUnit(n);
                    if (token !== null) {
                        return token;
                    }
                }

                return this._normalParserSource.peekToken(n);
            };

            IncrementalParserSource.prototype.tryPeekTokenFromOldSourceUnit = function (n) {
                var currentPosition = this.absolutePosition();
                for (var i = 0; i < n; i++) {
                    var interimToken = this._oldSourceUnitCursor.peekToken(i);
                    if (!this.canReuseTokenFromOldSourceUnit(currentPosition, interimToken)) {
                        return null;
                    }

                    currentPosition += interimToken.fullWidth();
                }

                var token = this._oldSourceUnitCursor.peekToken(n);
                return this.canReuseTokenFromOldSourceUnit(currentPosition, token) ? token : null;
            };

            IncrementalParserSource.prototype.moveToNextNode = function () {
                var currentElement = this._oldSourceUnitCursor.currentElement();
                var currentNode = this._oldSourceUnitCursor.currentNode();

                this._oldSourceUnitCursor.moveToNextSibling();

                var absolutePosition = this.absolutePosition() + currentNode.fullWidth();
                var previousToken = currentNode.lastToken();
                this._normalParserSource.resetToPosition(absolutePosition, previousToken);

                if (this._changeRange !== null) {
                }
            };

            IncrementalParserSource.prototype.moveToNextToken = function () {
                var currentToken = this.currentToken();

                if (this._oldSourceUnitCursor.currentToken() === currentToken) {
                    this._oldSourceUnitCursor.moveToNextSibling();

                    var absolutePosition = this.absolutePosition() + currentToken.fullWidth();
                    var previousToken = currentToken;
                    this._normalParserSource.resetToPosition(absolutePosition, previousToken);

                    if (this._changeRange !== null) {
                    }
                } else {
                    this._changeDelta -= currentToken.fullWidth();

                    this._normalParserSource.moveToNextToken();

                    if (this._changeRange !== null) {
                        var changeRangeSpanInNewText = this._changeRange.newSpan();
                        if (this.absolutePosition() >= changeRangeSpanInNewText.end()) {
                            this._changeDelta += this._changeRange.newLength() - this._changeRange.span().length();
                            this._changeRange = null;
                        }
                    }
                }
            };
            return IncrementalParserSource;
        })();

        var ParserImpl = (function () {
            function ParserImpl(fileName, lineMap, source, parseOptions, newText_forDebuggingPurposesOnly) {
                this.newText_forDebuggingPurposesOnly = newText_forDebuggingPurposesOnly;
                this.listParsingState = 0;
                this.isInStrictMode = false;
                this.diagnostics = [];
                this.factory = TypeScript.Syntax.normalModeFactory;
                this.mergeTokensStorage = [];
                this.arrayPool = [];
                this.fileName = fileName;
                this.lineMap = lineMap;
                this.source = source;
                this.parseOptions = parseOptions;
            }
            ParserImpl.prototype.getRewindPoint = function () {
                var rewindPoint = this.source.getRewindPoint();

                rewindPoint.diagnosticsCount = this.diagnostics.length;

                rewindPoint.isInStrictMode = this.isInStrictMode;
                rewindPoint.listParsingState = this.listParsingState;

                return rewindPoint;
            };

            ParserImpl.prototype.rewind = function (rewindPoint) {
                this.source.rewind(rewindPoint);

                this.diagnostics.length = rewindPoint.diagnosticsCount;
            };

            ParserImpl.prototype.releaseRewindPoint = function (rewindPoint) {
                this.source.releaseRewindPoint(rewindPoint);
            };

            ParserImpl.prototype.currentTokenStart = function () {
                return this.source.absolutePosition() + this.currentToken().leadingTriviaWidth();
            };

            ParserImpl.prototype.previousTokenStart = function () {
                if (this.previousToken() === null) {
                    return 0;
                }

                return this.source.absolutePosition() - this.previousToken().fullWidth() + this.previousToken().leadingTriviaWidth();
            };

            ParserImpl.prototype.previousTokenEnd = function () {
                if (this.previousToken() === null) {
                    return 0;
                }

                return this.previousTokenStart() + this.previousToken().width();
            };

            ParserImpl.prototype.currentNode = function () {
                var node = this.source.currentNode();

                if (node === null || node.parsedInStrictMode() !== this.isInStrictMode) {
                    return null;
                }

                return node;
            };

            ParserImpl.prototype.currentToken = function () {
                return this.source.currentToken();
            };

            ParserImpl.prototype.currentTokenAllowingRegularExpression = function () {
                return this.source.currentTokenAllowingRegularExpression();
            };

            ParserImpl.prototype.peekToken = function (n) {
                return this.source.peekToken(n);
            };

            ParserImpl.prototype.eatAnyToken = function () {
                var token = this.currentToken();
                this.moveToNextToken();
                return token;
            };

            ParserImpl.prototype.moveToNextToken = function () {
                this.source.moveToNextToken();
            };

            ParserImpl.prototype.previousToken = function () {
                return this.source.previousToken();
            };

            ParserImpl.prototype.eatNode = function () {
                var node = this.source.currentNode();
                this.source.moveToNextNode();
                return node;
            };

            ParserImpl.prototype.eatToken = function (kind) {
                var token = this.currentToken();
                if (token.tokenKind === kind) {
                    this.moveToNextToken();
                    return token;
                }

                return this.createMissingToken(kind, token);
            };

            ParserImpl.prototype.tryEatToken = function (kind) {
                if (this.currentToken().tokenKind === kind) {
                    return this.eatToken(kind);
                }

                return null;
            };

            ParserImpl.prototype.eatKeyword = function (kind) {
                var token = this.currentToken();
                if (token.tokenKind === kind) {
                    this.moveToNextToken();
                    return token;
                }

                return this.createMissingToken(kind, token);
            };

            ParserImpl.prototype.isIdentifier = function (token) {
                var tokenKind = token.tokenKind;

                if (tokenKind === 11 /* IdentifierName */) {
                    return true;
                }

                if (tokenKind >= 51 /* FirstFutureReservedStrictKeyword */) {
                    if (tokenKind <= 59 /* LastFutureReservedStrictKeyword */) {
                        return !this.isInStrictMode;
                    }

                    return tokenKind <= 69 /* LastTypeScriptKeyword */;
                }

                return false;
            };

            ParserImpl.prototype.eatIdentifierNameToken = function () {
                var token = this.currentToken();

                if (token.tokenKind === 11 /* IdentifierName */) {
                    this.moveToNextToken();
                    return token;
                }

                if (TypeScript.SyntaxFacts.isAnyKeyword(token.tokenKind)) {
                    this.moveToNextToken();
                    return TypeScript.Syntax.convertToIdentifierName(token);
                }

                return this.createMissingToken(11 /* IdentifierName */, token);
            };

            ParserImpl.prototype.eatIdentifierToken = function () {
                var token = this.currentToken();
                if (this.isIdentifier(token)) {
                    this.moveToNextToken();

                    if (token.tokenKind === 11 /* IdentifierName */) {
                        return token;
                    }

                    return TypeScript.Syntax.convertToIdentifierName(token);
                }

                return this.createMissingToken(11 /* IdentifierName */, token);
            };

            ParserImpl.prototype.canEatAutomaticSemicolon = function (allowWithoutNewLine) {
                var token = this.currentToken();

                if (token.tokenKind === 10 /* EndOfFileToken */) {
                    return true;
                }

                if (token.tokenKind === 71 /* CloseBraceToken */) {
                    return true;
                }

                if (allowWithoutNewLine) {
                    return true;
                }

                if (this.previousToken() !== null && this.previousToken().hasTrailingNewLine()) {
                    return true;
                }

                return false;
            };

            ParserImpl.prototype.canEatExplicitOrAutomaticSemicolon = function (allowWithoutNewline) {
                var token = this.currentToken();

                if (token.tokenKind === 78 /* SemicolonToken */) {
                    return true;
                }

                return this.canEatAutomaticSemicolon(allowWithoutNewline);
            };

            ParserImpl.prototype.eatExplicitOrAutomaticSemicolon = function (allowWithoutNewline) {
                var token = this.currentToken();

                if (token.tokenKind === 78 /* SemicolonToken */) {
                    return this.eatToken(78 /* SemicolonToken */);
                }

                if (this.canEatAutomaticSemicolon(allowWithoutNewline)) {
                    var semicolonToken = TypeScript.Syntax.emptyToken(78 /* SemicolonToken */);

                    if (!this.parseOptions.allowAutomaticSemicolonInsertion()) {
                        this.addDiagnostic(new TypeScript.Diagnostic(this.fileName, this.lineMap, this.previousTokenEnd(), 0, TypeScript.DiagnosticCode.Automatic_semicolon_insertion_not_allowed, null));
                    }

                    return semicolonToken;
                }

                return this.eatToken(78 /* SemicolonToken */);
            };

            ParserImpl.prototype.isKeyword = function (kind) {
                if (kind >= 15 /* FirstKeyword */) {
                    if (kind <= 50 /* LastFutureReservedKeyword */) {
                        return true;
                    }

                    if (this.isInStrictMode) {
                        return kind <= 59 /* LastFutureReservedStrictKeyword */;
                    }
                }

                return false;
            };

            ParserImpl.prototype.createMissingToken = function (expectedKind, actual) {
                var diagnostic = this.getExpectedTokenDiagnostic(expectedKind, actual);
                this.addDiagnostic(diagnostic);

                return TypeScript.Syntax.emptyToken(expectedKind);
            };

            ParserImpl.prototype.getExpectedTokenDiagnostic = function (expectedKind, actual) {
                var token = this.currentToken();

                if (TypeScript.SyntaxFacts.isAnyKeyword(expectedKind) || TypeScript.SyntaxFacts.isAnyPunctuation(expectedKind)) {
                    return new TypeScript.Diagnostic(this.fileName, this.lineMap, this.currentTokenStart(), token.width(), TypeScript.DiagnosticCode._0_expected, [TypeScript.SyntaxFacts.getText(expectedKind)]);
                } else {
                    if (actual !== null && TypeScript.SyntaxFacts.isAnyKeyword(actual.tokenKind)) {
                        return new TypeScript.Diagnostic(this.fileName, this.lineMap, this.currentTokenStart(), token.width(), TypeScript.DiagnosticCode.Identifier_expected_0_is_a_keyword, [TypeScript.SyntaxFacts.getText(actual.tokenKind)]);
                    } else {
                        return new TypeScript.Diagnostic(this.fileName, this.lineMap, this.currentTokenStart(), token.width(), TypeScript.DiagnosticCode.Identifier_expected, null);
                    }
                }
            };

            ParserImpl.getPrecedence = function (expressionKind) {
                switch (expressionKind) {
                    case 173 /* CommaExpression */:
                        return 1 /* CommaExpressionPrecedence */;

                    case 174 /* AssignmentExpression */:
                    case 175 /* AddAssignmentExpression */:
                    case 176 /* SubtractAssignmentExpression */:
                    case 177 /* MultiplyAssignmentExpression */:
                    case 178 /* DivideAssignmentExpression */:
                    case 179 /* ModuloAssignmentExpression */:
                    case 180 /* AndAssignmentExpression */:
                    case 181 /* ExclusiveOrAssignmentExpression */:
                    case 182 /* OrAssignmentExpression */:
                    case 183 /* LeftShiftAssignmentExpression */:
                    case 184 /* SignedRightShiftAssignmentExpression */:
                    case 185 /* UnsignedRightShiftAssignmentExpression */:
                        return 2 /* AssignmentExpressionPrecedence */;

    