/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GotoTest
implements TestLocator {
    private static final String FILE = "(.+)";
    private static final String EXT = "(.+)";
    private final String[] ZENTEST_PATTERNS = new String[]{"app/controllers/(.+)\\.(.+)", "test/controllers/(.+)_test\\.(.+)", "app/views/(.+)\\.(.+)", "test/views/(.+)_test\\.(.+)", "app/models/(.+)\\.(.+)", "test/unit/(.+)_test\\.(.+)", "lib/(.+)\\.(.+)", "test/unit/test_(.+)\\.(.+)"};
    private final String[] RSPEC_PATTERNS = new String[]{"app/models/(.+)\\.(.+)", "spec/models/(.+)_spec\\.(.+)", "app/controllers/(.+)\\.(.+)", "spec/controllers/(.+)_spec\\.(.+)", "app/views/(.+)\\.(.+)", "spec/views/(.+)_spec\\.(.+)", "app/helpers/(.+)\\.(.+)", "spec/helpers/(.+)_spec\\.(.+)", "lib/(.+)\\.(.+)", "spec/(.+)_spec\\.(.+)", "lib/(.+)\\.(.+)", "spec/lib/(.+)_spec\\.(.+)", "/(.+)\\.(.+)", "/(.+)_spec\\.(.+)"};
    private final String[] RAILS_PATTERNS = new String[]{"app/controllers/(.+)\\.(.+)", "test/functional/(.+)_test\\.(.+)", "app/models/(.+)\\.(.+)", "test/unit/(.+)_test\\.(.+)", "lib/(.+)\\.(.+)", "test/unit/test_(.+)\\.(.+)", "lib/(.+)\\.(.+)", "test/lib/test_(.+)\\.(.+)", "lib/(.+)\\.(.+)", "test/lib/(.+)_test\\.(.+)", "app/(.+)\\.(.+)", "test/(.+)_test\\.(.+)"};
    private final String[] RUBYTEST_PATTERNS = new String[]{"lib/(.+)\\.(.+)", "test/test_(.+)\\.(.+)", "lib/(.+)\\.(.+)", "test/(.+)_test\\.(.+)", "lib/(.+)\\.(.+)", "test/tc_(.+)\\.(.+)", "/(.+)\\.(.+)", "/test_(.+)\\.(.+)", "/(.+)\\.(.+)", "/(.+)_test\\.(.+)", "/(.+)\\.(.+)", "/tc_(.+)\\.(.+)"};

    private String[] getProjectSourceRootPatterns(Project project) {
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        if (rubyBaseProject == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (FileObject sourceRoot : rubyBaseProject.getSourceRootFiles()) {
            for (FileObject testRoot : rubyBaseProject.getTestSourceRootFiles()) {
                this.addPatternPairs(sourceRoot, testRoot, result);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private void addPatternPairs(FileObject sourceRoot, FileObject testRoot, List<String> result) {
        result.add(sourceRoot.getName() + "/" + "(.+)" + "\\." + "(.+)");
        result.add(testRoot.getName() + "/" + "test_" + "(.+)" + "\\." + "(.+)");
        result.add(sourceRoot.getName() + "/" + "(.+)" + "\\." + "(.+)");
        result.add(testRoot.getName() + "/" + "(.+)" + "_test\\." + "(.+)");
        result.add(sourceRoot.getName() + "/" + "(.+)" + "\\." + "(.+)");
        result.add(testRoot.getName() + "/" + "(.+)" + "_spec\\." + "(.+)");
    }

    private boolean isZenTestInstalled(Project project) {
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)project);
        return gemManager != null && gemManager.getLatestVersion("ZenTest") != null;
    }

    private boolean isRSpecInstalled(Project project) {
        return new RSpecSupport(project).isRSpecInstalled();
    }

    private boolean isRailsInstalled() {
        return true;
    }

    private void appendRegexp(StringBuilder sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '/' && File.separatorChar != '/') {
                sb.append(File.separatorChar);
                continue;
            }
            if (c == '\\') continue;
            sb.append(c);
        }
    }

    private File findMatching(File file, String pattern1, String pattern2) {
        assert (file.getPath().equals(file.getAbsolutePath())) : "This method requires absolute paths";
        String path = GotoTest.slashifyPathForRE(file.getPath());
        Pattern pattern = Pattern.compile("(.*)" + pattern1);
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            String name = matcher.group(2);
            String ext = matcher.group(3);
            int nameIndex = pattern2.indexOf("(.+)");
            assert (nameIndex != -1);
            int extIndex = pattern2.indexOf("(.+)", nameIndex + "(.+)".length());
            assert (extIndex != -1);
            StringBuilder sb = new StringBuilder();
            this.appendRegexp(sb, prefix);
            this.appendRegexp(sb, File.separator);
            this.appendRegexp(sb, pattern2.substring(0, nameIndex));
            this.appendRegexp(sb, name);
            this.appendRegexp(sb, pattern2.substring(nameIndex + "(.+)".length(), extIndex));
            this.appendRegexp(sb, ext);
            String otherPath = GotoTest.slashifyPathForRE(sb.toString());
            File otherFile = new File(otherPath);
            if (otherFile.exists()) {
                return otherFile;
            }
            if (pattern2.indexOf(47) != -1) {
                int fileIndex = pattern2.indexOf("(.+)");
                String newPattern = pattern2.substring(0, fileIndex) + name + pattern2.substring(fileIndex + "(.+)".length());
                Pattern p2 = Pattern.compile("(.*)" + newPattern);
                File parent = otherFile.getParentFile();
                File[] children = parent.listFiles();
                if (children != null) {
                    for (File f : children) {
                        if (!p2.matcher(GotoTest.slashifyPathForRE(f.getPath())).matches()) continue;
                        return f;
                    }
                }
            }
        }
        return null;
    }

    private File findMatching(String[] patternPairs, File file, boolean findTest) {
        for (int index = 0; index < patternPairs.length; index += 2) {
            String pattern1 = patternPairs[index];
            String pattern2 = patternPairs[index + 1];
            File matching = null;
            matching = findTest ? this.findMatching(file, pattern1, pattern2) : this.findMatching(file, pattern2, pattern1);
            if (matching == null) continue;
            return matching;
        }
        return null;
    }

    private FileObject findMatchingFile(FileObject fo, boolean findTest) {
        File file = FileUtil.toFile((FileObject)fo);
        File matching = this.findMatchingFile(file = file.getAbsoluteFile(), findTest);
        if (matching != null) {
            return FileUtil.toFileObject((File)matching);
        }
        return null;
    }

    private File findMatchingFile(File file, boolean findTest) {
        File matching;
        Project project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)file));
        if (project != null && this.isZenTestInstalled(project) && (matching = this.findMatching(this.ZENTEST_PATTERNS, file, findTest)) != null) {
            return matching;
        }
        if (this.isRailsInstalled() && (matching = this.findMatching(this.RAILS_PATTERNS, file, findTest)) != null) {
            return matching;
        }
        matching = this.findMatching(this.RUBYTEST_PATTERNS, file, findTest);
        if (matching != null) {
            return matching;
        }
        if (project != null) {
            if (this.isRSpecInstalled(project) && (matching = this.findMatching(this.RSPEC_PATTERNS, file, findTest)) != null) {
                return matching;
            }
            matching = this.findMatching(this.getProjectSourceRootPatterns(project), file, findTest);
            if (matching != null) {
                return matching;
            }
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation find(FileObject fileObject, int caretOffset, boolean findTest) {
        DeclarationFinder.DeclarationLocation location;
        FileObject matching = this.findMatchingFile(fileObject, findTest);
        if (matching != null) {
            return new DeclarationFinder.DeclarationLocation(matching, -1);
        }
        if (caretOffset != -1 && (location = this.findTestPair(fileObject, caretOffset, findTest)) != DeclarationFinder.DeclarationLocation.NONE) {
            matching = location.getFileObject();
            int offset = location.getOffset();
            return new DeclarationFinder.DeclarationLocation(matching, offset);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public DeclarationFinder.DeclarationLocation findTest(FileObject fileObject, int caretOffset) {
        return this.find(fileObject, caretOffset, true);
    }

    public DeclarationFinder.DeclarationLocation findTested(FileObject fileObject, int caretOffset) {
        return this.find(fileObject, caretOffset, false);
    }

    private DeclarationFinder.DeclarationLocation findTestPair(FileObject fo, final int offset, final boolean findTest) {
        Source source = Source.create((FileObject)fo);
        if (source == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        final DeclarationFinder.DeclarationLocation[] locationResult = new DeclarationFinder.DeclarationLocation[]{DeclarationFinder.DeclarationLocation.NONE};
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    RubyIndex index;
                    Parser.Result parserResult = resultIterator.getParserResult();
                    if (!(parserResult instanceof RubyParseResult)) {
                        return;
                    }
                    Node root = AstUtilities.getRoot((Parser.Result)parserResult);
                    if (root == null) {
                        return;
                    }
                    ClassNode cls = AstUtilities.findClassAtOffset((Node)root, (int)offset);
                    if (cls == null) {
                        try {
                            BaseDocument doc = RubyUtils.getDocument((Parser.Result)parserResult);
                            int endOffset = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
                            if (endOffset != offset) {
                                cls = AstUtilities.findClassAtOffset((Node)root, (int)endOffset);
                            }
                        }
                        catch (BadLocationException ble) {
                            // empty catch block
                        }
                    }
                    if (cls != null && (index = RubyIndex.get((Parser.Result)parserResult)) != null) {
                        String className = AstUtilities.getClassOrModuleName((IScopingNode)cls);
                        String TEST = "Test";
                        if (findTest) {
                            String name = className + TEST;
                            DeclarationFinder.DeclarationLocation location = GotoTest.this.findClass(name, index);
                            if (location != DeclarationFinder.DeclarationLocation.NONE) {
                                locationResult[0] = location;
                                return;
                            }
                            name = TEST + className;
                            location = GotoTest.this.findClass(name, index);
                            if (location != DeclarationFinder.DeclarationLocation.NONE) {
                                locationResult[0] = location;
                                return;
                            }
                        } else {
                            String name;
                            DeclarationFinder.DeclarationLocation location;
                            if (className.endsWith(TEST) && (location = GotoTest.this.findClass(name = className.substring(0, className.length() - TEST.length()), index)) != DeclarationFinder.DeclarationLocation.NONE) {
                                locationResult[0] = location;
                                return;
                            }
                            if (className.startsWith(TEST) && (location = GotoTest.this.findClass(name = className.substring(TEST.length()), index)) != DeclarationFinder.DeclarationLocation.NONE) {
                                locationResult[0] = location;
                                return;
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException pe) {
            Exceptions.printStackTrace((Throwable)pe);
        }
        return locationResult[0];
    }

    private DeclarationFinder.DeclarationLocation findClass(String className, RubyIndex index) {
        Set classes = index.getClasses(className, QuerySupport.Kind.EXACT, true, false, false, null);
        for (IndexedClass c : classes) {
            FileObject fo = c.getFileObject();
            if (fo == null) continue;
            int offset = 0;
            Node node = AstUtilities.getForeignNode((IndexedElement)c);
            if (node != null) {
                offset = node.getPosition().getStartOffset();
            }
            return new DeclarationFinder.DeclarationLocation(fo, offset);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public boolean appliesTo(FileObject fo) {
        return RubyUtils.isRubyFile((FileObject)fo) || RubyUtils.isRhtmlFile((FileObject)fo);
    }

    public boolean asynchronous() {
        return false;
    }

    public TestLocator.LocationResult findOpposite(FileObject fileObject, int caretOffset) {
        DeclarationFinder.DeclarationLocation location = this.findTest(fileObject, caretOffset);
        if (location == DeclarationFinder.DeclarationLocation.NONE) {
            location = this.findTested(fileObject, caretOffset);
        }
        if (location != DeclarationFinder.DeclarationLocation.NONE) {
            return new TestLocator.LocationResult(location.getFileObject(), location.getOffset());
        }
        return new TestLocator.LocationResult(NbBundle.getMessage(GotoTest.class, (String)"OppositeNotFound"));
    }

    public void findOpposite(FileObject fo, int caretOffset, TestLocator.LocationListener callback) {
        throw new UnsupportedOperationException("GotoTest is synchronous");
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        String name = fo.getName();
        return name.indexOf("_test") != -1 || name.indexOf("test_") != -1 || name.indexOf("_spec") != -1 ? TestLocator.FileType.TEST : TestLocator.FileType.TESTED;
    }

    private static String slashifyPathForRE(String path) {
        return File.separatorChar == '/' ? path : path.replace(File.separatorChar, '/');
    }
}

